/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.RangeGroup;
import org.hsqldb.Routine;
import org.hsqldb.RoutineSchema;
import org.hsqldb.Session;
import org.hsqldb.SetFunction;
import org.hsqldb.SetFunctionValueUser;
import org.hsqldb.error.Error;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.lib.ArrayListIdentity;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.Set;
import org.hsqldb.map.ValuePool;
import org.hsqldb.result.Result;
import org.hsqldb.types.Type;

public class FunctionSQLInvoked
extends Expression {
    RoutineSchema routineSchema;
    Routine routine;
    Expression condition = Expression.EXPR_TRUE;

    FunctionSQLInvoked(RoutineSchema routineSchema) {
        super(routineSchema.isAggregate() ? 98 : 27);
        this.routineSchema = routineSchema;
    }

    public void setArguments(Expression[] expressionArray) {
        this.nodes = expressionArray;
    }

    @Override
    public HsqlList resolveColumnReferences(Session session, RangeGroup rangeGroup, int n, RangeGroup[] rangeGroupArray, HsqlList hsqlList, boolean bl) {
        HsqlList hsqlList2 = this.condition.resolveColumnReferences(session, rangeGroup, n, rangeGroupArray, null, false);
        if (hsqlList2 != null) {
            ExpressionColumn.checkColumnsResolved(hsqlList2);
        }
        if (this.isSelfAggregate()) {
            if (hsqlList == null) {
                hsqlList = new ArrayListIdentity();
            }
            hsqlList.add(this);
            return hsqlList;
        }
        return super.resolveColumnReferences(session, rangeGroup, n, rangeGroupArray, hsqlList, bl);
    }

    @Override
    public void resolveTypes(Session session, Expression expression2) {
        int n;
        Type[] typeArray = new Type[this.nodes.length];
        for (n = 0; n < this.nodes.length; ++n) {
            Expression expression3 = this.nodes[n];
            expression3.resolveTypes(session, this);
            typeArray[n] = expression3.dataType;
        }
        this.routine = this.routineSchema.getSpecificRoutine(typeArray);
        for (n = 0; n < this.nodes.length; ++n) {
            if (this.nodes[n].dataType != null) continue;
            this.nodes[n].dataType = this.routine.getParameterTypes()[n];
        }
        this.dataType = this.routine.getReturnType();
        this.condition.resolveTypes(session, null);
    }

    private Object getValueInternal(Session session, Object[] objectArray) {
        boolean bl = false;
        int n = this.routine.javaMethodWithConnection ? 1 : 0;
        Object[] objectArray2 = ValuePool.emptyObjectArray;
        boolean bl2 = true;
        if (n + this.nodes.length > 0) {
            if (this.opType == 98) {
                objectArray2 = new Object[this.routine.getParameterCount()];
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray2[i + 1] = objectArray[i];
                }
            } else {
                objectArray2 = new Object[this.nodes.length + n];
            }
            if (!this.routine.isPSM()) {
                JDBCConnection jDBCConnection = session.getInternalConnection();
                if (n > 0) {
                    objectArray2[0] = jDBCConnection;
                }
            }
        }
        Type[] typeArray = this.routine.getParameterTypes();
        for (int i = 0; i < this.nodes.length; ++i) {
            Expression expression2 = this.nodes[i];
            Object object = expression2.getValue(session, typeArray[i]);
            if (object == null) {
                if (this.routine.isNullInputOutput()) {
                    return null;
                }
                if (!this.routine.getParameter(i).isNullable()) {
                    return Result.newErrorResult(Error.error(4811));
                }
            }
            if (this.routine.isPSM()) {
                objectArray2[i] = object;
                continue;
            }
            objectArray2[i + n] = expression2.dataType.convertSQLToJava(session, object);
        }
        Result result = this.routine.invoke(session, objectArray2, objectArray, bl2);
        session.releaseInternalConnection();
        if (result.isError()) {
            throw result.getException();
        }
        if (bl) {
            return result.valueData;
        }
        return result;
    }

    @Override
    public Object getValue(Session session) {
        Object object = this.getValueInternal(session, null);
        if (object instanceof Result) {
            Result result = (Result)object;
            if (result.isError()) {
                throw result.getException();
            }
            if (result.isSimpleValue()) {
                object = result.getValueObject();
            } else if (result.isData()) {
                object = result;
            } else {
                throw Error.error(4605, this.routine.getName().name);
            }
        }
        return object;
    }

    @Override
    public Result getResult(Session session) {
        Object object = this.getValueInternal(session, null);
        if (object instanceof Result) {
            return (Result)object;
        }
        return Result.newPSMResult(object);
    }

    @Override
    void collectObjectNames(Set set) {
        set.add(this.routine.getSpecificName());
    }

    @Override
    public String getSQL() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.routineSchema.getName().getSchemaQualifiedStatementName());
        stringBuilder.append('(');
        int n = this.nodes.length;
        if (this.opType == 98) {
            n = 1;
        }
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.nodes[i].getSQL());
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public String describe(Session session, int n) {
        return super.describe(session, n);
    }

    @Override
    public boolean isSelfAggregate() {
        return this.routineSchema.isAggregate();
    }

    public boolean isDeterministic() {
        return this.routine.isDeterministic();
    }

    @Override
    boolean equals(Expression expression2) {
        if (expression2 instanceof FunctionSQLInvoked) {
            FunctionSQLInvoked functionSQLInvoked = (FunctionSQLInvoked)expression2;
            return super.equals(expression2) && this.opType == expression2.opType && this.routineSchema == functionSQLInvoked.routineSchema && this.routine == functionSQLInvoked.routine && this.condition.equals(functionSQLInvoked.condition);
        }
        return false;
    }

    @Override
    public SetFunction updateAggregatingValue(Session session, SetFunction setFunction) {
        if (!this.condition.testCondition(session)) {
            return setFunction;
        }
        if (setFunction == null) {
            setFunction = new SetFunctionValueUser();
        }
        Object[] objectArray = ((SetFunctionValueUser)setFunction).list;
        objectArray[0] = Boolean.FALSE;
        this.getValueInternal(session, objectArray);
        return setFunction;
    }

    @Override
    public Object getAggregatedValue(Session session, SetFunction setFunction) {
        if (setFunction == null) {
            setFunction = new SetFunctionValueUser();
        }
        Object[] objectArray = ((SetFunctionValueUser)setFunction).list;
        objectArray[0] = Boolean.TRUE;
        Result result = (Result)this.getValueInternal(session, objectArray);
        if (result.isError()) {
            throw result.getException();
        }
        return result.getValueObject();
    }

    @Override
    public Expression getCondition() {
        return this.condition;
    }

    @Override
    public boolean hasCondition() {
        return this.condition != null && !this.condition.isTrue();
    }

    @Override
    public void setCondition(ExpressionLogical expressionLogical) {
        this.condition = expressionLogical;
    }
}

