/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Constraint;
import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.ParserDDL;
import org.hsqldb.PeriodDefinition;
import org.hsqldb.RangeGroup;
import org.hsqldb.ReferenceObject;
import org.hsqldb.Routine;
import org.hsqldb.RoutineSchema;
import org.hsqldb.Row;
import org.hsqldb.Schema;
import org.hsqldb.SchemaManager;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Statement;
import org.hsqldb.StatementDMQL;
import org.hsqldb.Table;
import org.hsqldb.TablePeriodWorks;
import org.hsqldb.TableWorks;
import org.hsqldb.Token;
import org.hsqldb.TriggerDef;
import org.hsqldb.TriggerDefSQL;
import org.hsqldb.View;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.map.ValuePool;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.result.Result;
import org.hsqldb.rights.Grantee;
import org.hsqldb.rights.GranteeManager;
import org.hsqldb.rights.Right;
import org.hsqldb.rights.User;
import org.hsqldb.types.Charset;
import org.hsqldb.types.Collation;
import org.hsqldb.types.Type;

public class StatementSchema
extends Statement {
    int order;
    Object[] arguments = ValuePool.emptyObjectArray;
    boolean isSchemaDefinition;
    Token[] statementTokens;

    StatementSchema(int n, int n2) {
        super(n, n2);
        this.isTransactionStatement = true;
    }

    StatementSchema(String string, int n) {
        this(string, n, null, null, null);
    }

    StatementSchema(String string, int n, Object[] objectArray, HsqlNameManager.HsqlName[] hsqlNameArray, HsqlNameManager.HsqlName[] hsqlNameArray2) {
        super(n);
        this.isTransactionStatement = true;
        this.sql = string;
        if (objectArray != null) {
            this.arguments = objectArray;
        }
        if (hsqlNameArray != null) {
            this.readTableNames = hsqlNameArray;
        }
        if (hsqlNameArray2 != null) {
            this.writeTableNames = hsqlNameArray2;
        }
        switch (n) {
            case 1152: 
            case 1153: {
                this.group = 2002;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 1121: 
            case 1122: {
                this.group = 2002;
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 1128: 
            case 1129: 
            case 1130: 
            case 1131: 
            case 1147: {
                this.group = 2002;
                break;
            }
            case 53: {
                this.group = 2002;
                this.order = 10;
                break;
            }
            case 54: {
                this.group = 2002;
                this.order = 10;
                break;
            }
            case 63: 
            case 64: {
                this.group = 2002;
                break;
            }
            case 68: {
                this.group = 2001;
                break;
            }
            case 65: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 69: {
                this.group = 2001;
                this.order = 7;
                break;
            }
            case 71: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 87: {
                this.group = 2001;
                this.order = 2;
                break;
            }
            case 88: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 89: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 90: {
                this.group = 2001;
                this.order = 7;
                break;
            }
            case 93: {
                this.group = 2001;
                this.order = 2;
                break;
            }
            case 94: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 95: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 96: {
                this.group = 2001;
                this.order = 5;
                break;
            }
            case 1126: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 9: {
                this.group = 2001;
                this.order = 9;
                break;
            }
            case 11: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 13: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 23: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 1124: {
                this.group = 2001;
                this.order = 8;
                break;
            }
            case 1125: {
                this.group = 2002;
                this.order = 4;
                break;
            }
            case 1146: {
                this.group = 2002;
                this.order = 12;
                break;
            }
            case 1123: {
                this.group = 2002;
                this.order = 11;
                break;
            }
            case 1214: {
                this.group = 2002;
                this.statementTokens = (Token[])objectArray[0];
                break;
            }
            case 1162: {
                this.group = 2002;
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementSchema");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result execute(Session session) {
        Result result;
        try {
            result = this.getResult(session);
        }
        catch (Throwable throwable) {
            result = Result.newErrorResult(throwable, this.getSQL());
        }
        if (result.isError()) {
            result.getException().setStatementType(this.group, this.type);
            return result;
        }
        session.database.schemaManager.setSchemaChangeTimestamp();
        HsqlNameManager.HsqlName hsqlName = session.currentSchema;
        try {
            if (this.type == 1153) {
                session.currentSchema = SqlInvariants.INFORMATION_SCHEMA_HSQLNAME;
            }
            if (this.isLogged) {
                session.database.logger.writeOtherStatement(session, this.sql);
            }
        }
        catch (Throwable throwable) {
            Result result2 = Result.newErrorResult(throwable, this.sql);
            return result2;
        }
        finally {
            if (this.type == 1153) {
                session.currentSchema = hsqlName;
            }
        }
        return result;
    }

    Result getResult(Session session) {
        SchemaManager schemaManager = session.database.schemaManager;
        if (this.isExplain) {
            return Result.newSingleColumnStringResult("OPERATION", this.describe(session));
        }
        block34 : switch (this.type) {
            case 1152: 
            case 1153: {
                HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.arguments[0];
                HsqlNameManager.HsqlName hsqlName2 = (HsqlNameManager.HsqlName)this.arguments[1];
                switch (hsqlName.type) {
                    case 1: {
                        try {
                            session.checkAdmin();
                            session.checkDDLWrite();
                            hsqlName.rename(hsqlName2);
                            break block34;
                        }
                        catch (HsqlException hsqlException) {
                            return Result.newErrorResult(hsqlException, this.sql);
                        }
                    }
                    case 2: {
                        StatementSchema.checkSchemaUpdateAuthorisation(session, hsqlName);
                        schemaManager.checkSchemaNameCanChange(hsqlName);
                        schemaManager.renameSchema(hsqlName, hsqlName2);
                        break block34;
                    }
                }
                try {
                    SchemaObject schemaObject;
                    Object object;
                    hsqlName.setSchemaIfNull(session.getCurrentSchemaHsqlName());
                    if (hsqlName.type == 9) {
                        object = schemaManager.getUserTable(hsqlName.parent);
                        int n = ((Table)object).getColumnIndex(hsqlName.name);
                        schemaObject = ((Table)object).getColumn(n);
                    } else {
                        schemaObject = schemaManager.getSchemaObject(hsqlName);
                        if (schemaObject == null) {
                            throw Error.error(5501, hsqlName.name);
                        }
                        hsqlName = hsqlName.type == 24 ? ((Routine)schemaObject).getSpecificName() : schemaObject.getName();
                    }
                    StatementSchema.checkSchemaUpdateAuthorisation(session, hsqlName.schema);
                    hsqlName2.setSchemaIfNull(hsqlName.schema);
                    if (hsqlName.schema != hsqlName2.schema) {
                        object = Error.error(5505);
                        return Result.newErrorResult((Throwable)object, this.sql);
                    }
                    hsqlName2.parent = hsqlName.parent;
                    switch (schemaObject.getType()) {
                        case 9: {
                            object = schemaObject.getName().parent;
                            schemaManager.checkObjectIsReferenced((HsqlNameManager.HsqlName)object);
                            Table table = schemaManager.getUserTable((HsqlNameManager.HsqlName)object);
                            TriggerDef[] triggerDefArray = table.getTriggers();
                            for (int i = 0; i < triggerDefArray.length; ++i) {
                                if (!(triggerDefArray[i] instanceof TriggerDefSQL)) continue;
                                throw Error.error(5502, triggerDefArray[i].getName().getSchemaQualifiedStatementName());
                            }
                            table.renameColumn((ColumnSchema)schemaObject, hsqlName2);
                            break block34;
                        }
                    }
                    schemaManager.renameSchemaObject(hsqlName, hsqlName2);
                    break;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1121: {
                Table table = (Table)this.arguments[0];
                int[] nArray = (int[])this.arguments[1];
                HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.arguments[2];
                try {
                    Index index = (Index)session.database.schemaManager.getSchemaObject(hsqlName);
                    TableWorks tableWorks = new TableWorks(session, table);
                    tableWorks.alterIndex(index, nArray);
                    break;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 5: {
                try {
                    NumberSequence numberSequence = (NumberSequence)this.arguments[0];
                    NumberSequence numberSequence2 = (NumberSequence)this.arguments[1];
                    StatementSchema.checkSchemaUpdateAuthorisation(session, numberSequence.getSchemaName());
                    numberSequence.reset(numberSequence2);
                    break;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 3: {
                try {
                    int n = (Integer)this.arguments[0];
                    Type type = (Type)this.arguments[1];
                    switch (n) {
                        case 1134: {
                            Constraint constraint = (Constraint)this.arguments[2];
                            this.setOrCheckObjectName(session, type.getName(), constraint.getName(), true);
                            type.userTypeModifier.addConstraint(constraint);
                            session.database.schemaManager.addSchemaObject(constraint);
                            break;
                        }
                        case 1135: {
                            Expression expression2 = (Expression)this.arguments[2];
                            type.userTypeModifier.setDefaultClause(expression2);
                            break;
                        }
                        case 1130: {
                            HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.arguments[2];
                            session.database.schemaManager.removeSchemaObject(hsqlName);
                            break;
                        }
                        case 1132: {
                            type.userTypeModifier.removeDefaultClause();
                        }
                    }
                    break;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 7: {
                try {
                    int n = (Integer)this.arguments[0];
                    Table table = (Table)this.arguments[1];
                    block87 : switch (n) {
                        case 1134: {
                            Object object;
                            Constraint constraint = (Constraint)this.arguments[2];
                            Boolean bl = (Boolean)this.arguments[3];
                            if (bl.booleanValue() && (object = session.database.schemaManager.findSchemaObject(constraint.getName().name, constraint.getName().schema.name, constraint.getName().type)) != null) {
                                return Result.updateZeroResult;
                            }
                            switch (constraint.getConstraintType()) {
                                case 4: {
                                    object = new TableWorks(session, table);
                                    ((TableWorks)object).addPrimaryKey(constraint);
                                    break block87;
                                }
                                case 2: {
                                    object = new TableWorks(session, table);
                                    ((TableWorks)object).addUniqueConstraint(constraint);
                                    break block87;
                                }
                                case 0: {
                                    object = new TableWorks(session, table);
                                    ((TableWorks)object).addForeignKey(constraint);
                                    break block87;
                                }
                                case 3: {
                                    object = new TableWorks(session, table);
                                    ((TableWorks)object).addCheckConstraint(constraint);
                                    break block87;
                                }
                            }
                            break;
                        }
                        case 1133: {
                            ColumnSchema columnSchema = (ColumnSchema)this.arguments[2];
                            int n2 = (Integer)this.arguments[3];
                            HsqlArrayList hsqlArrayList = (HsqlArrayList)this.arguments[4];
                            Boolean bl = (Boolean)this.arguments[5];
                            TableWorks tableWorks = new TableWorks(session, table);
                            if (bl.booleanValue() && table.findColumn(columnSchema.getName().name) != -1) break;
                            tableWorks.addColumn(columnSchema, n2, hsqlArrayList);
                            break;
                        }
                        case 1136: {
                            ColumnSchema columnSchema = (ColumnSchema)this.arguments[2];
                            Type type = (Type)this.arguments[3];
                            ColumnSchema columnSchema2 = columnSchema.duplicate();
                            columnSchema2.setType(type);
                            TableWorks tableWorks = new TableWorks(session, table);
                            tableWorks.retypeColumn(columnSchema, columnSchema2);
                            break;
                        }
                        case 1144: {
                            ColumnSchema columnSchema = (ColumnSchema)this.arguments[2];
                            Type type = (Type)this.arguments[3];
                            NumberSequence numberSequence = (NumberSequence)this.arguments[4];
                            ColumnSchema columnSchema3 = columnSchema.duplicate();
                            columnSchema3.setType(type);
                            columnSchema3.setIdentity(numberSequence);
                            TableWorks tableWorks = new TableWorks(session, table);
                            tableWorks.retypeColumn(columnSchema, columnSchema3);
                            break;
                        }
                        case 1137: {
                            ColumnSchema columnSchema = (ColumnSchema)this.arguments[2];
                            int n3 = (Integer)this.arguments[3];
                            NumberSequence numberSequence = (NumberSequence)this.arguments[4];
                            if (columnSchema.isIdentity()) {
                                columnSchema.getIdentitySequence().reset(numberSequence);
                                break;
                            }
                            columnSchema.setIdentity(numberSequence);
                            table.setColumnTypeVars(n3);
                            break;
                        }
                        case 1139: {
                            ColumnSchema columnSchema = (ColumnSchema)this.arguments[2];
                            boolean bl = (Boolean)this.arguments[3];
                            TableWorks tableWorks = new TableWorks(session, table);
                            tableWorks.setColNullability(columnSchema, bl);
                            break;
                        }
                        case 1140: {
                            ColumnSchema columnSchema = (ColumnSchema)this.arguments[2];
                            int n4 = (Integer)this.arguments[3];
                            Expression expression3 = (Expression)this.arguments[4];
                            TableWorks tableWorks = new TableWorks(session, table);
                            tableWorks.setColDefaultExpression(n4, expression3);
                            break;
                        }
                        case 1141: {
                            ColumnSchema columnSchema = (ColumnSchema)this.arguments[2];
                            int n5 = (Integer)this.arguments[3];
                            TableWorks tableWorks = new TableWorks(session, table);
                            tableWorks.setColDefaultExpression(n5, null);
                            table.setColumnTypeVars(n5);
                            break;
                        }
                        case 1142: {
                            ColumnSchema columnSchema = (ColumnSchema)this.arguments[2];
                            int n6 = (Integer)this.arguments[3];
                            columnSchema.setGeneratingExpression(null);
                            table.setColumnTypeVars(n6);
                            break;
                        }
                        case 1143: {
                            ColumnSchema columnSchema = (ColumnSchema)this.arguments[2];
                            int n7 = (Integer)this.arguments[3];
                            columnSchema.setIdentity(null);
                            table.setColumnTypeVars(n7);
                            break;
                        }
                    }
                    break;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 115: {
                Table table = (Table)this.arguments[0];
                PeriodDefinition periodDefinition = (PeriodDefinition)this.arguments[1];
                TablePeriodWorks tablePeriodWorks = new TablePeriodWorks(session, table);
                try {
                    if (periodDefinition.getPeriodType() == 1) {
                        tablePeriodWorks.addSystemPeriod(periodDefinition);
                        break;
                    }
                    tablePeriodWorks.addApplicationPeriod(periodDefinition);
                    break;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 116: {
                Table table = (Table)this.arguments[0];
                PeriodDefinition periodDefinition = (PeriodDefinition)this.arguments[1];
                Boolean bl = (Boolean)this.arguments[2];
                TablePeriodWorks tablePeriodWorks = new TablePeriodWorks(session, table);
                try {
                    if (periodDefinition.getPeriodType() == 1) {
                        tablePeriodWorks.dropSystemPeriod(bl);
                        break;
                    }
                    tablePeriodWorks.dropApplicationPeriod(bl);
                    break;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 117: {
                Table table = (Table)this.arguments[0];
                TablePeriodWorks tablePeriodWorks = new TablePeriodWorks(session, table);
                try {
                    tablePeriodWorks.addSystemVersioning();
                    break;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 118: {
                Table table = (Table)this.arguments[0];
                Boolean bl = (Boolean)this.arguments[1];
                TablePeriodWorks tablePeriodWorks = new TablePeriodWorks(session, table);
                try {
                    tablePeriodWorks.dropSystemVersioning(bl);
                    break;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 4: {
                Routine routine = (Routine)this.arguments[0];
                try {
                    Routine routine2 = (Routine)schemaManager.getSchemaObject(routine.getSpecificName());
                    schemaManager.replaceReferences(routine2, routine);
                    routine2.setAsAlteredRoutine(routine);
                    break;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 6: 
            case 8: {
                throw Error.runtimeError(201, "StatementSchema");
            }
            case 1122: {
                View view = (View)this.arguments[0];
                try {
                    StatementSchema.checkSchemaUpdateAuthorisation(session, view.getSchemaName());
                    View view2 = (View)schemaManager.getSchemaObject(view.getName());
                    if (view2 == null) {
                        throw Error.error(5501, view.getName().name);
                    }
                    view.setName(view2.getName());
                    view.compile(session, null);
                    OrderedHashSet orderedHashSet = schemaManager.getReferencesTo(view2.getName());
                    if (orderedHashSet.getCommonElementCount(view.getReferences()) > 0) {
                        throw Error.error(5502);
                    }
                    int n = schemaManager.getTableIndex(view2);
                    schemaManager.setTable(n, view);
                    OrderedHashSet orderedHashSet2 = new OrderedHashSet();
                    orderedHashSet2.add(view);
                    try {
                        schemaManager.recompileDependentObjects(orderedHashSet2);
                        schemaManager.replaceReferences(view2, view);
                    }
                    catch (HsqlException hsqlException) {
                        schemaManager.setTable(n, view2);
                        schemaManager.recompileDependentObjects(orderedHashSet2);
                    }
                    break;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1128: {
                try {
                    HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.arguments[0];
                    int n = (Integer)this.arguments[1];
                    boolean bl = (Boolean)this.arguments[2];
                    boolean bl2 = (Boolean)this.arguments[3];
                    Table table = schemaManager.getUserTable(hsqlName.parent);
                    int n8 = table.getColumnIndex(hsqlName.name);
                    if (table.getColumnCount() == 1) {
                        throw Error.error(5591);
                    }
                    StatementSchema.checkSchemaUpdateAuthorisation(session, table.getSchemaName());
                    TableWorks tableWorks = new TableWorks(session, table);
                    tableWorks.dropColumn(n8, bl);
                    break;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 1129: 
            case 1130: 
            case 1131: 
            case 1147: {
                try {
                    HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.arguments[0];
                    int n = (Integer)this.arguments[1];
                    boolean bl = (Boolean)this.arguments[2];
                    boolean bl3 = (Boolean)this.arguments[3];
                    switch (this.type) {
                        case 29: 
                        case 1131: {
                            session.checkAdmin();
                            session.checkDDLWrite();
                            break;
                        }
                        case 31: {
                            StatementSchema.checkSchemaUpdateAuthorisation(session, hsqlName);
                            if (schemaManager.schemaExists(hsqlName.name) || !bl3) break;
                            return Result.updateZeroResult;
                        }
                        default: {
                            if (hsqlName.schema == null) {
                                hsqlName.schema = session.getCurrentSchemaHsqlName();
                            } else if (!schemaManager.schemaExists(hsqlName.schema.name) && bl3) {
                                return Result.updateZeroResult;
                            }
                            hsqlName.schema = schemaManager.getUserSchemaHsqlName(hsqlName.schema.name);
                            StatementSchema.checkSchemaUpdateAuthorisation(session, hsqlName.schema);
                            SchemaObject schemaObject = schemaManager.getSchemaObject(hsqlName);
                            if (schemaObject == null) {
                                if (bl3) {
                                    return Result.updateZeroResult;
                                }
                                throw Error.error(5501, hsqlName.name);
                            }
                            hsqlName = hsqlName.type == 24 ? ((Routine)schemaObject).getSpecificName() : schemaObject.getName();
                        }
                    }
                    if (!bl) {
                        schemaManager.checkObjectIsReferenced(hsqlName);
                    }
                    switch (this.type) {
                        case 29: {
                            StatementSchema.dropRole(session, hsqlName, bl);
                            break;
                        }
                        case 1131: {
                            StatementSchema.dropUser(session, hsqlName, bl);
                            break;
                        }
                        case 31: {
                            this.dropSchema(session, hsqlName, bl);
                            break;
                        }
                        case 24: {
                            break;
                        }
                        case 25: 
                        case 26: 
                        case 32: 
                        case 36: 
                        case 1147: {
                            this.dropObject(session, hsqlName, bl);
                            break;
                        }
                        case 27: {
                            this.dropType(session, hsqlName, bl);
                            break;
                        }
                        case 28: {
                            StatementSchema.dropDomain(session, hsqlName, bl);
                            break;
                        }
                        case 30: {
                            this.dropRoutine(session, hsqlName, bl);
                            break;
                        }
                        case 33: 
                        case 39: {
                            this.dropTable(session, hsqlName, bl);
                            break;
                        }
                        case 34: 
                        case 35: 
                        case 37: 
                        case 38: {
                            break;
                        }
                        case 1129: {
                            StatementSchema.checkSchemaUpdateAuthorisation(session, hsqlName.schema);
                            schemaManager.dropIndex(session, hsqlName);
                            break;
                        }
                        case 1130: {
                            StatementSchema.checkSchemaUpdateAuthorisation(session, hsqlName.schema);
                            schemaManager.dropConstraint(session, hsqlName, bl);
                        }
                    }
                    break;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 53: 
            case 63: {
                try {
                    boolean bl = this.type == 53;
                    OrderedHashSet orderedHashSet = (OrderedHashSet)this.arguments[0];
                    HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.arguments[1];
                    this.setSchemaName(session, null, hsqlName);
                    hsqlName = schemaManager.getSchemaObjectName(hsqlName.schema, hsqlName.name, hsqlName.type, true);
                    SchemaObject schemaObject = schemaManager.getSchemaObject(hsqlName);
                    Right right = (Right)this.arguments[2];
                    Grantee grantee = (Grantee)this.arguments[3];
                    boolean bl4 = (Boolean)this.arguments[4];
                    boolean bl5 = (Boolean)this.arguments[5];
                    if (grantee == null) {
                        grantee = this.isSchemaDefinition ? this.schemaName.owner : session.getGrantee();
                    }
                    GranteeManager granteeManager = session.database.granteeManager;
                    switch (schemaObject.getType()) {
                        case 14: {
                            break;
                        }
                        case 3: 
                        case 4: {
                            Table table = (Table)schemaObject;
                            right.setColumns(table);
                            if (table.getTableType() == 3 && !right.isFull()) {
                                return Result.newErrorResult(Error.error(5595), this.sql);
                            }
                            Expression expression4 = right.getFilterExpression();
                            if (expression4 == null) break;
                            expression4 = expression4.duplicate();
                            RangeGroup.RangeGroupSimple rangeGroupSimple = new RangeGroup.RangeGroupSimple(table.getDefaultRanges(), false);
                            expression4.resolveColumnReferences(session, rangeGroupSimple, RangeGroup.emptyArray, null);
                        }
                    }
                    if (bl) {
                        granteeManager.grant(session, orderedHashSet, schemaObject, right, grantee, bl5);
                        break;
                    }
                    granteeManager.revoke(orderedHashSet, schemaObject, right, grantee, bl5, bl4);
                    break;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 54: 
            case 64: {
                try {
                    String string;
                    int n;
                    boolean bl = this.type == 54;
                    OrderedHashSet orderedHashSet = (OrderedHashSet)this.arguments[0];
                    OrderedHashSet orderedHashSet3 = (OrderedHashSet)this.arguments[1];
                    Grantee grantee = (Grantee)this.arguments[2];
                    boolean bl6 = (Boolean)this.arguments[3];
                    GranteeManager granteeManager = session.database.granteeManager;
                    granteeManager.checkGranteeList(orderedHashSet);
                    for (n = 0; n < orderedHashSet.size(); ++n) {
                        string = (String)orderedHashSet.get(n);
                        granteeManager.checkRoleList(string, orderedHashSet3, grantee, bl);
                    }
                    if (bl) {
                        for (n = 0; n < orderedHashSet.size(); ++n) {
                            string = (String)orderedHashSet.get(n);
                            for (int i = 0; i < orderedHashSet3.size(); ++i) {
                                String string2 = (String)orderedHashSet3.get(i);
                                granteeManager.grant(string, string2, grantee);
                            }
                        }
                    } else {
                        for (n = 0; n < orderedHashSet.size(); ++n) {
                            string = (String)orderedHashSet.get(n);
                            for (int i = 0; i < orderedHashSet3.size(); ++i) {
                                granteeManager.revoke(string, (String)orderedHashSet3.get(i), grantee);
                            }
                        }
                    }
                    break;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 9: {
                return Result.updateZeroResult;
            }
            case 11: {
                Charset charset = (Charset)this.arguments[0];
                try {
                    this.setOrCheckObjectName(session, null, charset.getName(), true);
                    schemaManager.addSchemaObject(charset);
                    break;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 13: {
                Collation collation = (Collation)this.arguments[0];
                try {
                    this.setOrCheckObjectName(session, null, collation.getName(), true);
                    schemaManager.addSchemaObject(collation);
                    break;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 65: {
                try {
                    session.checkAdmin();
                    session.checkDDLWrite();
                    HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.arguments[0];
                    session.database.getGranteeManager().addRole(hsqlName);
                    break;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1126: {
                HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.arguments[0];
                String string = (String)this.arguments[1];
                Grantee grantee = (Grantee)this.arguments[2];
                boolean bl = (Boolean)this.arguments[3];
                boolean bl7 = (Boolean)this.arguments[4];
                try {
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.getUserManager().createUser(session, hsqlName, string, bl7);
                    if (!bl) break;
                    session.database.getGranteeManager().grant(hsqlName.name, "DBA", grantee);
                    break;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 68: {
                HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.arguments[0];
                Grantee grantee = (Grantee)this.arguments[1];
                Boolean bl = (Boolean)this.arguments[2];
                try {
                    session.checkDDLWrite();
                    if (schemaManager.schemaExists(hsqlName.name)) {
                        if (session.isProcessingScript() && "PUBLIC".equals(hsqlName.name)) break;
                        if (bl != null && bl.booleanValue()) {
                            return Result.updateZeroResult;
                        }
                        throw Error.error(5504, hsqlName.name);
                    }
                    schemaManager.createSchema(hsqlName, grantee);
                    Schema schema = schemaManager.findSchema(hsqlName.name);
                    this.sql = schema.getSQL();
                    if (!session.isProcessingScript() || !session.database.getProperties().isVersion18()) break;
                    session.setCurrentSchemaHsqlName(schema.getName());
                    break;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 69: {
                Routine routine = (Routine)this.arguments[0];
                try {
                    this.setOrCheckObjectName(session, null, routine.getName(), false);
                    schemaManager.addSchemaObject(routine);
                    break;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1124: {
                HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.arguments[0];
                Routine[] routineArray = (Routine[])this.arguments[1];
                try {
                    session.checkAdmin();
                    session.checkDDLWrite();
                    if (hsqlName == null) break;
                    for (int i = 0; i < routineArray.length; ++i) {
                        routineArray[i].setName(hsqlName);
                        schemaManager.addSchemaObject(routineArray[i]);
                    }
                    break;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 71: {
                NumberSequence numberSequence = (NumberSequence)this.arguments[0];
                Boolean bl = (Boolean)this.arguments[1];
                try {
                    this.setOrCheckObjectName(session, null, numberSequence.getName(), true);
                    schemaManager.addSchemaObject(numberSequence);
                    break;
                }
                catch (HsqlException hsqlException) {
                    if (bl != null && bl.booleanValue()) {
                        return Result.updateZeroResult;
                    }
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 23: {
                Type type = (Type)this.arguments[0];
                Constraint[] constraintArray = type.userTypeModifier.getConstraints();
                try {
                    this.setOrCheckObjectName(session, null, type.getName(), true);
                    for (int i = 0; i < constraintArray.length; ++i) {
                        Constraint constraint = constraintArray[i];
                        this.setOrCheckObjectName(session, type.getName(), constraint.getName(), true);
                        schemaManager.addSchemaObject(constraint);
                    }
                    schemaManager.addSchemaObject(type);
                    break;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 87: {
                Table table = (Table)this.arguments[0];
                HsqlArrayList hsqlArrayList = (HsqlArrayList)this.arguments[1];
                HsqlArrayList hsqlArrayList2 = (HsqlArrayList)this.arguments[2];
                StatementDMQL statementDMQL = (StatementDMQL)this.arguments[3];
                Boolean bl = (Boolean)this.arguments[4];
                HsqlArrayList hsqlArrayList3 = null;
                try {
                    this.setOrCheckObjectName(session, null, table.getName(), true);
                }
                catch (HsqlException hsqlException) {
                    if (bl != null && bl.booleanValue()) {
                        return Result.updateZeroResult;
                    }
                    return Result.newErrorResult(hsqlException, this.sql);
                }
                try {
                    Object object;
                    Object object2;
                    if (this.isSchemaDefinition) {
                        hsqlArrayList3 = new HsqlArrayList();
                    }
                    if (hsqlArrayList.size() != 0) {
                        table = ParserDDL.addTableConstraintDefinitions(session, table, hsqlArrayList, hsqlArrayList3, true);
                        this.arguments[1] = hsqlArrayList3;
                    }
                    table.compile(session, null);
                    schemaManager.addSchemaObject(table);
                    if (hsqlArrayList2 != null && !hsqlArrayList2.isEmpty()) {
                        object2 = new TableWorks(session, table);
                        for (int i = 0; i < hsqlArrayList2.size(); ++i) {
                            object = (Constraint)hsqlArrayList2.get(i);
                            ((TableWorks)object2).addIndex(((Constraint)object).getMainColumns(), ((Constraint)object).getName(), false);
                        }
                        table = ((TableWorks)object2).getTable();
                    }
                    if (statementDMQL != null) {
                        object2 = statementDMQL.execute(session);
                        if (((Result)object2).isError()) {
                            return object2;
                        }
                        table.insertIntoTable(session, (Result)object2);
                        if (table.hasLobColumn) {
                            RowIterator rowIterator = table.rowIterator(session);
                            while (rowIterator.next()) {
                                object = rowIterator.getCurrentRow();
                                Object[] objectArray = ((Row)object).getData();
                                session.sessionData.adjustLobUsageCount(table, objectArray, 1);
                            }
                        }
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    schemaManager.removeExportedKeys(table);
                    schemaManager.removeDependentObjects(table.getName());
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 88: {
                return Result.updateZeroResult;
            }
            case 89: {
                return Result.updateZeroResult;
            }
            case 90: {
                TriggerDef triggerDef = (TriggerDef)this.arguments[0];
                HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.arguments[1];
                Boolean bl = (Boolean)this.arguments[2];
                try {
                    this.setOrCheckObjectName(session, null, triggerDef.getName(), true);
                    if (hsqlName != null) {
                        this.setOrCheckObjectName(session, null, hsqlName, false);
                        if (schemaManager.getSchemaObject(hsqlName) == null) {
                            throw Error.error(5501, hsqlName.name);
                        }
                    }
                    triggerDef.table.addTrigger(triggerDef, hsqlName);
                    schemaManager.addSchemaObject(triggerDef);
                    triggerDef.start();
                    break;
                }
                catch (HsqlException hsqlException) {
                    if (bl != null && bl.booleanValue()) {
                        return Result.updateZeroResult;
                    }
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 93: {
                return Result.updateZeroResult;
            }
            case 94: {
                Type type = (Type)this.arguments[0];
                try {
                    this.setOrCheckObjectName(session, null, type.getName(), true);
                    schemaManager.addSchemaObject(type);
                    break;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 95: {
                return Result.updateZeroResult;
            }
            case 96: {
                View view = (View)this.arguments[0];
                Boolean bl = (Boolean)this.arguments[1];
                try {
                    this.setOrCheckObjectName(session, null, view.getName(), true);
                }
                catch (HsqlException hsqlException) {
                    if (bl != null && bl.booleanValue()) {
                        return Result.updateZeroResult;
                    }
                    return Result.newErrorResult(hsqlException, this.sql);
                }
                try {
                    view.compile(session, null);
                    schemaManager.addSchemaObject(view);
                    break;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1125: {
                Table table = (Table)this.arguments[0];
                int[] nArray = (int[])this.arguments[1];
                HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.arguments[2];
                boolean bl = (Boolean)this.arguments[3];
                RoutineSchema routineSchema = (RoutineSchema)this.arguments[4];
                Boolean bl8 = (Boolean)this.arguments[5];
                try {
                    this.setOrCheckObjectName(session, table.getName(), hsqlName, true);
                }
                catch (HsqlException hsqlException) {
                    if (bl8 != null && bl8.booleanValue()) {
                        return Result.updateZeroResult;
                    }
                    return Result.newErrorResult(hsqlException, this.sql);
                }
                try {
                    TableWorks tableWorks = new TableWorks(session, table);
                    tableWorks.addIndex(nArray, hsqlName, bl);
                    break;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1146: {
                HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.arguments[0];
                HsqlNameManager.HsqlName hsqlName3 = (HsqlNameManager.HsqlName)this.arguments[1];
                this.setSchemaName(session, null, hsqlName);
                this.setSchemaName(session, null, hsqlName3);
                this.setOrCheckObjectName(session, null, hsqlName, true);
                SchemaObject schemaObject = session.database.schemaManager.findAnySchemaObjectForSynonym(hsqlName.name, hsqlName.schema.name);
                if (schemaObject != null) {
                    throw Error.error(5504);
                }
                schemaObject = session.database.schemaManager.findAnySchemaObjectForSynonym(hsqlName3.name, hsqlName3.schema.name);
                if (schemaObject == null) {
                    throw Error.error(5501);
                }
                if (!session.getGrantee().isFullyAccessibleByRole(schemaObject.getName())) {
                    throw Error.error(5501);
                }
                hsqlName3 = schemaObject.getName();
                ReferenceObject referenceObject = new ReferenceObject(hsqlName, hsqlName3);
                schemaManager.addSchemaObject(referenceObject);
                break;
            }
            case 1123: {
                HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.arguments[0];
                String string = (String)this.arguments[1];
                switch (hsqlName.type) {
                    case 9: {
                        Table table = (Table)schemaManager.getSchemaObject(hsqlName.parent.name, hsqlName.parent.schema.name, 3);
                        if (!session.getGrantee().isFullyAccessibleByRole(table.getName())) {
                            throw Error.error(5501);
                        }
                        int n = table.getColumnIndex(hsqlName.name);
                        if (n < 0) {
                            throw Error.error(5501);
                        }
                        ColumnSchema columnSchema = table.getColumn(n);
                        columnSchema.getName().comment = string;
                        break block34;
                    }
                    case 18: {
                        RoutineSchema routineSchema = (RoutineSchema)schemaManager.getSchemaObject(hsqlName.name, hsqlName.schema.name, 18);
                        if (!session.getGrantee().isFullyAccessibleByRole(routineSchema.getName())) {
                            throw Error.error(5501);
                        }
                        routineSchema.getName().comment = string;
                        break block34;
                    }
                    case 3: {
                        Table table = (Table)schemaManager.getSchemaObject(hsqlName.name, hsqlName.schema.name, 3);
                        if (!session.getGrantee().isFullyAccessibleByRole(table.getName())) {
                            throw Error.error(5501);
                        }
                        table.getName().comment = string;
                        break block34;
                    }
                }
                break;
            }
            case 1162: {
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementSchema");
            }
        }
        return Result.updateZeroResult;
    }

    private void dropType(Session session, HsqlNameManager.HsqlName hsqlName, boolean bl) {
        StatementSchema.checkSchemaUpdateAuthorisation(session, hsqlName.schema);
        Type type = (Type)session.database.schemaManager.getSchemaObject(hsqlName);
        session.database.schemaManager.removeSchemaObject(hsqlName, bl);
        type.userTypeModifier = null;
    }

    private static void dropDomain(Session session, HsqlNameManager.HsqlName hsqlName, boolean bl) {
        Type type = (Type)session.database.schemaManager.getSchemaObject(hsqlName);
        OrderedHashSet orderedHashSet = session.database.schemaManager.getReferencesTo(type.getName());
        if (!bl && orderedHashSet.size() > 0) {
            HsqlNameManager.HsqlName hsqlName2 = (HsqlNameManager.HsqlName)orderedHashSet.get(0);
            throw Error.error(5502, hsqlName2.getSchemaQualifiedStatementName());
        }
        Constraint[] constraintArray = type.userTypeModifier.getConstraints();
        orderedHashSet = new OrderedHashSet();
        for (int i = 0; i < constraintArray.length; ++i) {
            orderedHashSet.add(constraintArray[i].getName());
        }
        session.database.schemaManager.removeSchemaObjects(orderedHashSet);
        session.database.schemaManager.removeSchemaObject(type.getName(), bl);
        type.userTypeModifier = null;
    }

    private static void dropRole(Session session, HsqlNameManager.HsqlName hsqlName, boolean bl) {
        Grantee grantee = session.database.getGranteeManager().getRole(hsqlName.name);
        if (!bl && session.database.schemaManager.hasSchemas(grantee)) {
            HsqlArrayList hsqlArrayList = session.database.schemaManager.getSchemas(grantee);
            Schema schema = (Schema)hsqlArrayList.get(0);
            throw Error.error(5502, schema.getName().statementName);
        }
        session.database.schemaManager.dropSchemas(session, grantee, bl);
        session.database.getGranteeManager().dropRole(hsqlName.name);
    }

    private static void dropUser(Session session, HsqlNameManager.HsqlName hsqlName, boolean bl) {
        User user = session.database.getUserManager().get(hsqlName.name);
        if (session.database.getSessionManager().isUserActive(hsqlName.name)) {
            throw Error.error(5539);
        }
        if (!bl && session.database.schemaManager.hasSchemas(user)) {
            HsqlArrayList hsqlArrayList = session.database.schemaManager.getSchemas(user);
            Schema schema = (Schema)hsqlArrayList.get(0);
            throw Error.error(5502, schema.getName().statementName);
        }
        session.database.schemaManager.dropSchemas(session, user, bl);
        session.database.getUserManager().dropUser(hsqlName.name);
    }

    private void dropSchema(Session session, HsqlNameManager.HsqlName hsqlName, boolean bl) {
        HsqlNameManager.HsqlName hsqlName2 = session.database.schemaManager.getUserSchemaHsqlName(hsqlName.name);
        StatementSchema.checkSchemaUpdateAuthorisation(session, hsqlName2);
        session.database.schemaManager.dropSchema(session, hsqlName.name, bl);
    }

    private void dropRoutine(Session session, HsqlNameManager.HsqlName hsqlName, boolean bl) {
        StatementSchema.checkSchemaUpdateAuthorisation(session, hsqlName.schema);
        session.database.schemaManager.removeSchemaObject(hsqlName, bl);
    }

    private void dropObject(Session session, HsqlNameManager.HsqlName hsqlName, boolean bl) {
        StatementSchema.checkSchemaUpdateAuthorisation(session, hsqlName.schema);
        hsqlName = session.database.schemaManager.getSchemaObjectName(hsqlName.schema, hsqlName.name, hsqlName.type, true);
        session.database.schemaManager.removeSchemaObject(hsqlName, bl);
    }

    private void dropTable(Session session, HsqlNameManager.HsqlName hsqlName, boolean bl) {
        Table table = session.database.schemaManager.findUserTable(hsqlName.name, hsqlName.schema.name);
        session.database.schemaManager.dropTableOrView(session, table, bl);
    }

    static void checkSchemaUpdateAuthorisation(Session session, HsqlNameManager.HsqlName hsqlName) {
        if (session.isProcessingLog()) {
            return;
        }
        if (SqlInvariants.isSystemSchemaName(hsqlName.name)) {
            throw Error.error(5503);
        }
        if (session.parser.isSchemaDefinition) {
            if (hsqlName == session.getCurrentSchemaHsqlName()) {
                return;
            }
            throw Error.error(5505, hsqlName.name);
        }
        session.getGrantee().checkSchemaUpdateOrGrantRights(hsqlName.name);
        session.checkDDLWrite();
    }

    void setOrCheckObjectName(Session session, HsqlNameManager.HsqlName hsqlName, HsqlNameManager.HsqlName hsqlName2, boolean bl) {
        if (hsqlName2.schema == null) {
            hsqlName2.schema = this.schemaName == null ? session.getCurrentSchemaHsqlName() : this.schemaName;
        } else {
            hsqlName2.schema = session.getSchemaHsqlName(hsqlName2.schema.name);
            if (hsqlName2.schema == null) {
                throw Error.error(5505);
            }
            if (this.isSchemaDefinition && this.schemaName != hsqlName2.schema) {
                throw Error.error(5505);
            }
        }
        if (hsqlName2.parent == null) {
            hsqlName2.parent = hsqlName;
        }
        if (!this.isSchemaDefinition) {
            StatementSchema.checkSchemaUpdateAuthorisation(session, hsqlName2.schema);
        }
        if (bl) {
            session.database.schemaManager.checkSchemaObjectNotExists(hsqlName2);
        }
    }

    void setSchemaName(Session session, HsqlNameManager.HsqlName hsqlName, HsqlNameManager.HsqlName hsqlName2) {
        if (hsqlName2.schema == null) {
            hsqlName2.schema = this.schemaName == null ? session.getCurrentSchemaHsqlName() : this.schemaName;
        } else {
            hsqlName2.schema = session.getSchemaHsqlName(hsqlName2.schema.name);
            if (hsqlName2.schema == null) {
                throw Error.error(5505);
            }
            if (this.isSchemaDefinition && this.schemaName != hsqlName2.schema) {
                throw Error.error(5505);
            }
        }
    }

    @Override
    public boolean isAutoCommitStatement() {
        return true;
    }

    @Override
    public String describe(Session session) {
        return this.sql;
    }

    public Object[] getArguments() {
        return this.arguments;
    }
}

