/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.definition.parameter;

import java.io.Serializable;
import java.util.Optional;
import pl.touk.nussknacker.engine.api.AdditionalVariables;
import pl.touk.nussknacker.engine.api.BranchParamName;
import pl.touk.nussknacker.engine.api.LazyParameter;
import pl.touk.nussknacker.engine.api.ParamName;
import pl.touk.nussknacker.engine.api.definition.Parameter;
import pl.touk.nussknacker.engine.api.definition.ParameterEditor;
import pl.touk.nussknacker.engine.api.definition.ParameterValidator;
import pl.touk.nussknacker.engine.api.process.ParameterConfig;
import pl.touk.nussknacker.engine.api.process.SingleNodeConfig;
import pl.touk.nussknacker.engine.api.typed.typing;
import pl.touk.nussknacker.engine.api.typed.typing$Typed$;
import pl.touk.nussknacker.engine.definition.parameter.ParameterData;
import pl.touk.nussknacker.engine.definition.parameter.ParameterData$;
import pl.touk.nussknacker.engine.definition.parameter.editor.EditorExtractor$;
import pl.touk.nussknacker.engine.definition.parameter.validator.ValidatorExtractorParameters;
import pl.touk.nussknacker.engine.definition.parameter.validator.ValidatorsExtractor$;
import pl.touk.nussknacker.engine.types.EspTypeUtils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class ParameterExtractor$ {
    public static ParameterExtractor$ MODULE$;

    static {
        new ParameterExtractor$();
    }

    public Parameter extractParameter(java.lang.reflect.Parameter p, SingleNodeConfig nodeConfig) {
        Option nodeParamNames = Option$.MODULE$.apply((Object)p.getAnnotation(ParamName.class)).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.value());
        Option branchParamName = Option$.MODULE$.apply((Object)p.getAnnotation(BranchParamName.class)).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.value());
        String name = (String)nodeParamNames.orElse((Function0 & Serializable & scala.Serializable)() -> branchParamName).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.throwIllegalArgument(p, false, "missing @ParamName or @BranchParamName annotation"));
        ParameterConfig parameterConfig = nodeConfig.paramConfig(name);
        typing.TypingResult rawParamType = EspTypeUtils$.MODULE$.extractParameterType(p);
        typing.TypingResult paramWithUnwrappedBranch = branchParamName.isDefined() ? this.extractBranchParamType(rawParamType, p) : rawParamType;
        Tuple2<typing.TypingResult, Object> tuple2 = this.determineIfLazyParameter(paramWithUnwrappedBranch);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        typing.TypingResult paramTypeWithUnwrappedLazy = (typing.TypingResult)tuple2._1();
        boolean isLazyParameter = tuple2._2$mcZ$sp();
        Tuple2 tuple22 = new Tuple2((Object)paramTypeWithUnwrappedLazy, (Object)BoxesRunTime.boxToBoolean((boolean)isLazyParameter));
        Tuple2 tuple23 = tuple22;
        typing.TypingResult paramTypeWithUnwrappedLazy2 = (typing.TypingResult)tuple23._1();
        boolean isLazyParameter2 = tuple23._2$mcZ$sp();
        Tuple3<typing.TypingResult, Object, Object> tuple3 = this.determineOptionalParameter(paramTypeWithUnwrappedLazy2);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        typing.TypingResult paramType = (typing.TypingResult)tuple3._1();
        boolean isScalaOptionParameter = BoxesRunTime.unboxToBoolean((Object)tuple3._2());
        boolean isJavaOptionalParameter = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
        Tuple3 tuple32 = new Tuple3((Object)paramType, (Object)BoxesRunTime.boxToBoolean((boolean)isScalaOptionParameter), (Object)BoxesRunTime.boxToBoolean((boolean)isJavaOptionalParameter));
        Tuple3 tuple33 = tuple32;
        typing.TypingResult paramType2 = (typing.TypingResult)tuple33._1();
        boolean isScalaOptionParameter2 = BoxesRunTime.unboxToBoolean((Object)tuple33._2());
        boolean isJavaOptionalParameter2 = BoxesRunTime.unboxToBoolean((Object)tuple33._3());
        ParameterData parameterData = ParameterData$.MODULE$.apply(p, paramType2);
        Option<ParameterEditor> extractedEditor = EditorExtractor$.MODULE$.extract(parameterData, parameterConfig);
        List<ParameterValidator> validators = ValidatorsExtractor$.MODULE$.extract(new ValidatorExtractorParameters(parameterData, isScalaOptionParameter2 || isJavaOptionalParameter2, parameterConfig));
        return new Parameter(name, paramType2, extractedEditor, validators, this.additionalVariables(p), (Set<String>)Predef$.MODULE$.Set().empty(), branchParamName.isDefined(), isLazyParameter2, isScalaOptionParameter2, isJavaOptionalParameter2);
    }

    private typing.TypingResult extractBranchParamType(typing.TypingResult typ, java.lang.reflect.Parameter p) {
        typing.TypingResult valueType;
        block3: {
            block2: {
                typing.TypingResult typingResult = typ;
                if (!(typingResult instanceof typing.TypedClass)) break block2;
                typing.TypedClass typedClass = (typing.TypedClass)typingResult;
                Class<?> cl = typedClass.klass();
                List<typing.TypingResult> list = typedClass.params();
                if (!(list instanceof .colon.colon)) break block2;
                .colon.colon colon2 = (.colon.colon)list;
                typing.TypingResult typingResult2 = (typing.TypingResult)colon2.head();
                List list2 = colon2.tl$access$1();
                if (!(typingResult2 instanceof typing.TypedClass)) break block2;
                typing.TypedClass typedClass2 = (typing.TypedClass)typingResult2;
                Class<?> keyClass = typedClass2.klass();
                if (!(list2 instanceof .colon.colon)) break block2;
                .colon.colon colon3 = (.colon.colon)list2;
                valueType = (typing.TypingResult)colon3.head();
                List list3 = colon3.tl$access$1();
                if (Nil$.MODULE$.equals(list3) && Map.class.isAssignableFrom(cl) && String.class.isAssignableFrom(keyClass)) break block3;
            }
            throw this.throwIllegalArgument(p, true, "invalid type: should be Map[String, T]");
        }
        typing.TypingResult typingResult = valueType;
        return typingResult;
    }

    private Nothing$ throwIllegalArgument(java.lang.reflect.Parameter p, boolean isBranch, String message) {
        String method = p.getDeclaringExecutable().getName();
        String declaring = p.getDeclaringExecutable().getDeclaringClass().getName();
        String parameterType = isBranch ? "Branch parameter" : "Parameter";
        throw new IllegalArgumentException(new StringBuilder(29).append(parameterType).append(" ").append(p).append(" of method: ").append(method).append(" in class: ").append(declaring).append(" has ").append(message).toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Tuple2<typing.TypingResult, Object> determineIfLazyParameter(typing.TypingResult typ) {
        typing.TypingResult typingResult = typ;
        if (!(typingResult instanceof typing.TypedClass)) return new Tuple2((Object)typ, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        typing.TypedClass typedClass = (typing.TypedClass)typingResult;
        Class<?> cl = typedClass.klass();
        List<typing.TypingResult> genericParams = typedClass.params();
        if (!LazyParameter.class.isAssignableFrom(cl)) return new Tuple2((Object)typ, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        return new Tuple2(genericParams.head(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Tuple3<typing.TypingResult, Object, Object> determineOptionalParameter(typing.TypingResult typ) {
        boolean bl = false;
        typing.TypedClass typedClass = null;
        typing.TypingResult typingResult = typ;
        if (typingResult instanceof typing.TypedClass) {
            bl = true;
            typedClass = (typing.TypedClass)typingResult;
            Class<?> cl = typedClass.klass();
            List<typing.TypingResult> genericParams = typedClass.params();
            if (Option.class.isAssignableFrom(cl)) {
                return new Tuple3(genericParams.head(), (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
        }
        if (!bl) return new Tuple3((Object)typ, (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        Class<?> cl = typedClass.klass();
        List<typing.TypingResult> genericParams = typedClass.params();
        if (!Optional.class.isAssignableFrom(cl)) return new Tuple3((Object)typ, (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        return new Tuple3(genericParams.head(), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    private Map<String, typing.TypingResult> additionalVariables(java.lang.reflect.Parameter p) {
        return (Map)Option$.MODULE$.apply((Object)p.getAnnotation(AdditionalVariables.class)).map((Function1 & Serializable & scala.Serializable)x$5 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$5.value())).map((Function1 & Serializable & scala.Serializable)additionalVariable -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)additionalVariable.name()), (Object)typing$Typed$.MODULE$.apply(additionalVariable.clazz())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms())).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
    }

    private ParameterExtractor$() {
        MODULE$ = this;
    }
}

