/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.notifications;

import java.io.Serializable;
import java.time.Clock;
import java.time.Instant;
import pl.touk.nussknacker.engine.api.deployment.ProcessActionId;
import pl.touk.nussknacker.engine.api.deployment.ProcessActionState$;
import pl.touk.nussknacker.engine.api.deployment.ProcessActionType$;
import pl.touk.nussknacker.engine.api.process.ProcessName;
import pl.touk.nussknacker.ui.db.entity.ProcessActionEntityData;
import pl.touk.nussknacker.ui.notifications.Notification;
import pl.touk.nussknacker.ui.notifications.Notification$;
import pl.touk.nussknacker.ui.notifications.NotificationConfig;
import pl.touk.nussknacker.ui.notifications.NotificationService;
import pl.touk.nussknacker.ui.notifications.NotificationServiceImpl$;
import pl.touk.nussknacker.ui.process.repository.DBIOActionRunner;
import pl.touk.nussknacker.ui.process.repository.DbProcessActionRepository;
import pl.touk.nussknacker.ui.security.api.LoggedUser;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import slick.dbio.DBIOAction;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b\u0001B\u0006\r\u0001]A\u0001B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\t{\u0001\u0011\t\u0011)A\u0005}!A\u0011\t\u0001B\u0001B\u0003%!\t\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003G\u0011\u0015q\u0005\u0001\"\u0001P\u0011\u0015i\u0001\u0001\"\u0011V\u000f%\t\t\u0001DA\u0001\u0012\u0003\t\u0019A\u0002\u0005\f\u0019\u0005\u0005\t\u0012AA\u0003\u0011\u0019q\u0005\u0002\"\u0001\u0002\b!I\u0011\u0011\u0002\u0005\u0012\u0002\u0013\u0005\u00111\u0002\u0002\u0018\u001d>$\u0018NZ5dCRLwN\\*feZL7-Z%na2T!!\u0004\b\u0002\u001b9|G/\u001b4jG\u0006$\u0018n\u001c8t\u0015\ty\u0001#\u0001\u0002vS*\u0011\u0011CE\u0001\f]V\u001c8o\u001b8bG.,'O\u0003\u0002\u0014)\u0005!Ao\\;l\u0015\u0005)\u0012A\u00019m\u0007\u0001\u00192\u0001\u0001\r\u001f!\tIB$D\u0001\u001b\u0015\u0005Y\u0012!B:dC2\f\u0017BA\u000f\u001b\u0005\u0019\te.\u001f*fMB\u0011q\u0004I\u0007\u0002\u0019%\u0011\u0011\u0005\u0004\u0002\u0014\u001d>$\u0018NZ5dCRLwN\\*feZL7-Z\u0001\u0011C\u000e$\u0018n\u001c8SKB|7/\u001b;pef\u00042\u0001J\u0015,\u001b\u0005)#B\u0001\u0014(\u0003)\u0011X\r]8tSR|'/\u001f\u0006\u0003Q9\tq\u0001\u001d:pG\u0016\u001c8/\u0003\u0002+K\tIBI\u0019)s_\u000e,7o]!di&|gNU3q_NLGo\u001c:z!\ta#H\u0004\u0002.o9\u0011a\u0006\u000e\b\u0003_Ij\u0011\u0001\r\u0006\u0003cY\ta\u0001\u0010:p_Rt\u0014\"A\u001a\u0002\u0005\u0011\u0014\u0017BA\u001b7\u0003\u0011)H/\u001b7\u000b\u0003MJ!\u0001O\u001d\u0002'\u0011\u0013\u0015jT!di&|g.\u00138ti\u0006t7-Z:\u000b\u0005U2\u0014BA\u001e=\u0005\t!%I\u0003\u00029s\u0005QAMY5p%Vtg.\u001a:\u0011\u0005\u0011z\u0014B\u0001!&\u0005A!%)S(BGRLwN\u001c*v]:,'/\u0001\u0004d_:4\u0017n\u001a\t\u0003?\rK!\u0001\u0012\u0007\u0003%9{G/\u001b4jG\u0006$\u0018n\u001c8D_:4\u0017nZ\u0001\u0006G2|7m\u001b\t\u0003\u000f2k\u0011\u0001\u0013\u0006\u0003\u0013*\u000bA\u0001^5nK*\t1*\u0001\u0003kCZ\f\u0017BA'I\u0005\u0015\u0019En\\2l\u0003\u0019a\u0014N\\5u}Q)\u0001+\u0015*T)B\u0011q\u0004\u0001\u0005\u0006E\u0015\u0001\ra\t\u0005\u0006{\u0015\u0001\rA\u0010\u0005\u0006\u0003\u0016\u0001\rA\u0011\u0005\b\u000b\u0016\u0001\n\u00111\u0001G)\t1\u0006\u0010F\u0002XSN\u00042\u0001W.^\u001b\u0005I&B\u0001.\u001b\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u00039f\u0013aAR;ukJ,\u0007c\u00010dM:\u0011q,\u0019\b\u0003_\u0001L\u0011aG\u0005\u0003Ej\tq\u0001]1dW\u0006<W-\u0003\u0002eK\n!A*[:u\u0015\t\u0011'\u0004\u0005\u0002 O&\u0011\u0001\u000e\u0004\u0002\r\u001d>$\u0018NZ5dCRLwN\u001c\u0005\u0006U\u001a\u0001\u001da[\u0001\u0005kN,'\u000f\u0005\u0002mc6\tQN\u0003\u0002o_\u0006\u0019\u0011\r]5\u000b\u0005At\u0011\u0001C:fGV\u0014\u0018\u000e^=\n\u0005Il'A\u0003'pO\u001e,G-V:fe\")AO\u0002a\u0002k\u0006\u0011Qm\u0019\t\u00031ZL!a^-\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\b\"B=\u0007\u0001\u0004Q\u0018A\u00058pi&4\u0017nY1uS>t7/\u00114uKJ\u00042!G>~\u0013\ta(D\u0001\u0004PaRLwN\u001c\t\u0003\u000fzL!a %\u0003\u000f%s7\u000f^1oi\u00069bj\u001c;jM&\u001c\u0017\r^5p]N+'O^5dK&k\u0007\u000f\u001c\t\u0003?!\u0019\"\u0001\u0003\r\u0015\u0005\u0005\r\u0011a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'\u0006\u0002\u0002\u000e)\u001aa)a\u0004,\u0005\u0005E\u0001\u0003BA\n\u0003;i!!!\u0006\u000b\t\u0005]\u0011\u0011D\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0007\u001b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003?\t)BA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class NotificationServiceImpl
implements NotificationService {
    private final DbProcessActionRepository<DBIOAction> actionRepository;
    private final DBIOActionRunner dbioRunner;
    private final NotificationConfig config;
    private final Clock clock;

    public static Clock $lessinit$greater$default$4() {
        return NotificationServiceImpl$.MODULE$.$lessinit$greater$default$4();
    }

    @Override
    public Future<List<Notification>> notifications(Option<Instant> notificationsAfter, LoggedUser user, ExecutionContext ec) {
        Instant now = this.clock.instant();
        Instant limitBasedOnConfig = now.minusMillis(this.config.duration().toMillis());
        Instant limit = (Instant)notificationsAfter.map((Function1 & Serializable & scala.Serializable)x$1 -> NotificationServiceImpl.maxInstant$1(x$1, limitBasedOnConfig)).getOrElse((Function0 & Serializable & scala.Serializable)() -> limitBasedOnConfig);
        return this.dbioRunner.run(this.actionRepository.getUserActionsAfter(user, (Set<Enumeration.Value>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{ProcessActionType$.MODULE$.Deploy(), ProcessActionType$.MODULE$.Cancel()}))), (Set<Enumeration.Value>)((Set)ProcessActionState$.MODULE$.FinishedStates().$plus((Object)ProcessActionState$.MODULE$.Failed())), limit)).map((Function1 & Serializable & scala.Serializable)x$2 -> ((TraversableOnce)x$2.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                ProcessActionEntityData processActionEntityData = (ProcessActionEntityData)tuple2._1();
                ProcessName processName = (ProcessName)tuple2._2();
                if (processActionEntityData != null) {
                    ProcessActionId id = processActionEntityData.id();
                    Enumeration.Value actionType = processActionEntityData.actionType();
                    Enumeration.Value value = processActionEntityData.state();
                    Enumeration.Value value2 = ProcessActionState$.MODULE$.Finished();
                    Enumeration.Value value3 = value;
                    if (value2 == null) {
                        if (value3 == null) return Notification$.MODULE$.actionFinishedNotification(id.toString(), actionType, processName);
                    } else if (value2.equals(value3)) {
                        return Notification$.MODULE$.actionFinishedNotification(id.toString(), actionType, processName);
                    }
                }
            }
            if (tuple2 != null) {
                ProcessActionEntityData processActionEntityData = (ProcessActionEntityData)tuple2._1();
                ProcessName processName = (ProcessName)tuple2._2();
                if (processActionEntityData != null) {
                    ProcessActionId id = processActionEntityData.id();
                    Enumeration.Value actionType = processActionEntityData.actionType();
                    Enumeration.Value value = processActionEntityData.state();
                    Enumeration.Value value4 = ProcessActionState$.MODULE$.ExecutionFinished();
                    Enumeration.Value value5 = value;
                    if (value4 == null) {
                        if (value5 == null) return Notification$.MODULE$.actionExecutionFinishedNotification(id.toString(), actionType, processName);
                    } else if (value4.equals(value5)) {
                        return Notification$.MODULE$.actionExecutionFinishedNotification(id.toString(), actionType, processName);
                    }
                }
            }
            if (tuple2 != null) {
                ProcessActionEntityData processActionEntityData = (ProcessActionEntityData)tuple2._1();
                ProcessName processName = (ProcessName)tuple2._2();
                if (processActionEntityData != null) {
                    ProcessActionId id = processActionEntityData.id();
                    Enumeration.Value actionType = processActionEntityData.actionType();
                    Enumeration.Value value = processActionEntityData.state();
                    Option<String> failureMessageOpt = processActionEntityData.failureMessage();
                    Enumeration.Value value6 = ProcessActionState$.MODULE$.Failed();
                    Enumeration.Value value7 = value;
                    if (value6 == null) {
                        if (value7 == null) return Notification$.MODULE$.actionFailedNotification(id.toString(), actionType, processName, failureMessageOpt);
                    } else if (value6.equals(value7)) {
                        return Notification$.MODULE$.actionFailedNotification(id.toString(), actionType, processName, failureMessageOpt);
                    }
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            ProcessActionEntityData a = (ProcessActionEntityData)tuple2._1();
            ProcessName processName = (ProcessName)tuple2._2();
            throw new IllegalStateException(new StringBuilder(53).append("Unexpected action returned by query: ").append(a).append(", for scenario: ").append(processName).toString());
        }, Seq$.MODULE$.canBuildFrom())).toList(), ec);
    }

    private static final Instant maxInstant$1(Instant instant1, Instant instant2) {
        return instant1.compareTo(instant2) > 0 ? instant1 : instant2;
    }

    public NotificationServiceImpl(DbProcessActionRepository<DBIOAction> actionRepository, DBIOActionRunner dbioRunner, NotificationConfig config, Clock clock) {
        this.actionRepository = actionRepository;
        this.dbioRunner = dbioRunner;
        this.config = config;
        this.clock = clock;
    }
}

