/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.component;

import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.data.Validated;
import cats.data.Validated$;
import java.io.Serializable;
import pl.touk.nussknacker.engine.api.component.ComponentGroupName;
import pl.touk.nussknacker.engine.api.component.ComponentId;
import pl.touk.nussknacker.restmodel.definition.package;
import pl.touk.nussknacker.ui.component.ComponentConfigurationException;
import pl.touk.nussknacker.ui.component.ComponentIdProvider;
import pl.touk.nussknacker.ui.component.ComponentObjects;
import pl.touk.nussknacker.ui.component.ComponentValidationData;
import pl.touk.nussknacker.ui.component.ComponentWrongConfiguration;
import pl.touk.nussknacker.ui.component.DefaultComponentService$;
import pl.touk.nussknacker.ui.component.WrongConfigurationAttribute$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;

public final class ComponentsValidator$ {
    public static ComponentsValidator$ MODULE$;

    static {
        new ComponentsValidator$();
    }

    public void checkUnsafe(Map<String, ComponentObjects> componentObjectsMap, ComponentIdProvider componentIdProvider) {
        List components = (List)componentObjectsMap.toList().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String processingType = (String)tuple2._1();
            ComponentObjects componentObjects = (ComponentObjects)tuple2._2();
            List<ComponentValidationData> list = MODULE$.extractComponents(processingType, componentObjects, componentIdProvider);
            return list;
        }, List$.MODULE$.canBuildFrom());
        this.validateComponents((List<ComponentValidationData>)components).valueOr((Function1 & Serializable & scala.Serializable)wrongConfigurations -> {
            throw new ComponentConfigurationException("Wrong configured components were found.", (NonEmptyList<ComponentWrongConfiguration<?>>)wrongConfigurations);
        });
    }

    private List<ComponentValidationData> extractComponents(String processingType, ComponentObjects componentObjects, ComponentIdProvider componentIdProvider) {
        return (List)componentObjects.templates().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ComponentGroupName groupName = (ComponentGroupName)tuple2._1();
            package.ComponentTemplate com = (package.ComponentTemplate)tuple2._2();
            String componentId = componentIdProvider.createComponentId(processingType, (Option<String>)new Some((Object)com.label()), com.type());
            String icon = DefaultComponentService$.MODULE$.getComponentIcon(componentObjects.config(), com);
            ComponentValidationData componentValidationData = new ComponentValidationData(componentId, com.label(), icon, com.type(), groupName);
            return componentValidationData;
        }, List$.MODULE$.canBuildFrom());
    }

    private Validated<NonEmptyList<ComponentWrongConfiguration<?>>, BoxedUnit> validateComponents(List<ComponentValidationData> components) {
        Validated validated;
        List wrongComponents = ((TraversableOnce)components.groupBy((Function1 & Serializable & scala.Serializable)x$1 -> new ComponentId(x$1.id())).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Nil$ nil$;
            .colon.colon colon2;
            List list;
            List list2;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null && (list2 = (List)tuple2._2()) instanceof .colon.colon && Nil$.MODULE$.equals(list = (colon2 = (.colon.colon)list2).tl$access$1())) {
                nil$ = Nil$.MODULE$;
            } else if (tuple2 != null) {
                String componentId = ((ComponentId)tuple2._1()).value();
                List components = (List)tuple2._2();
                nil$ = MODULE$.computeWrongConfigurations(componentId, (Iterable<ComponentValidationData>)components);
            } else {
                throw new MatchError((Object)tuple2);
            }
            return nil$;
        }, Iterable$.MODULE$.canBuildFrom())).toList();
        Option option = NonEmptyList$.MODULE$.fromList(wrongComponents);
        if (None$.MODULE$.equals(option)) {
            validated = Validated$.MODULE$.valid((Object)BoxedUnit.UNIT);
        } else if (option instanceof Some) {
            Some some = (Some)option;
            NonEmptyList nonEmptyWrongComponents = (NonEmptyList)some.value();
            validated = Validated$.MODULE$.invalid((Object)nonEmptyWrongComponents);
        } else {
            throw new MatchError((Object)option);
        }
        return validated;
    }

    private List<ComponentWrongConfiguration<?>> computeWrongConfigurations(String componentId, Iterable<ComponentValidationData> components) {
        Option wrongConfiguredNames = ComponentsValidator$.checkUniqueAttributeValue$1(WrongConfigurationAttribute$.MODULE$.NameAttribute(), (Iterable)components.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name(), scala.collection.Iterable$.MODULE$.canBuildFrom()), componentId);
        Option wrongConfiguredIcons = ComponentsValidator$.checkUniqueAttributeValue$1(WrongConfigurationAttribute$.MODULE$.IconAttribute(), (Iterable)components.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.icon(), scala.collection.Iterable$.MODULE$.canBuildFrom()), componentId);
        Option wrongConfiguredGroups = ComponentsValidator$.checkUniqueAttributeValue$1(WrongConfigurationAttribute$.MODULE$.ComponentGroupNameAttribute(), (Iterable)components.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.componentGroupName(), scala.collection.Iterable$.MODULE$.canBuildFrom()), componentId);
        Option wrongConfiguredTypes = ComponentsValidator$.checkUniqueAttributeValue$1(WrongConfigurationAttribute$.MODULE$.ComponentTypeAttribute(), (Iterable)components.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.componentType(), scala.collection.Iterable$.MODULE$.canBuildFrom()), componentId);
        Iterable wrongConfigurations = (Iterable)((TraversableLike)((TraversableLike)Option$.MODULE$.option2Iterable(wrongConfiguredNames).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(wrongConfiguredTypes), scala.collection.Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(wrongConfiguredGroups), scala.collection.Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(wrongConfiguredIcons), scala.collection.Iterable$.MODULE$.canBuildFrom());
        return wrongConfigurations.toList();
    }

    private static final Option checkUniqueAttributeValue$1(Enumeration.Value attribute, Iterable values, String componentId$1) {
        .colon.colon colon2;
        List list;
        List list2 = (List)values.toList().distinct();
        Object object = list2 instanceof .colon.colon && Nil$.MODULE$.equals(list = (colon2 = (.colon.colon)list2).tl$access$1()) ? None$.MODULE$ : new Some(new ComponentWrongConfiguration(componentId$1, attribute, list2));
        return object;
    }

    private ComponentsValidator$() {
        MODULE$ = this;
    }
}

