/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.process;

import cats.Foldable;
import cats.UnorderedFoldable$;
import cats.implicits$;
import cats.instances.package;
import cats.kernel.Monoid;
import cats.kernel.Semigroup;
import cats.kernel.Semigroup$;
import com.typesafe.config.Config;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import pl.touk.nussknacker.engine.CategoryConfig;
import pl.touk.nussknacker.engine.util.Implicits$;
import pl.touk.nussknacker.ui.process.ConfigProcessCategoryService;
import pl.touk.nussknacker.ui.process.LegacyConfigProcessCategoryService;
import pl.touk.nussknacker.ui.process.MixedProcessCategoryService;
import pl.touk.nussknacker.ui.process.ProcessCategoryService;
import pl.touk.nussknacker.ui.process.ProcessingTypeCategoryService;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ConfigProcessCategoryService$
implements LazyLogging {
    public static ConfigProcessCategoryService$ MODULE$;
    private final String categoryConfigPath;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new ConfigProcessCategoryService$();
    }

    private Logger logger$lzycompute() {
        ConfigProcessCategoryService$ configProcessCategoryService$ = this;
        synchronized (configProcessCategoryService$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public String categoryConfigPath() {
        return this.categoryConfigPath;
    }

    public ProcessCategoryService apply(Config config, Map<String, CategoryConfig> processingCategories) {
        ProcessCategoryService processCategoryService;
        Tuple2 tuple2 = (Tuple2)implicits$.MODULE$.toFoldableOps(processingCategories.toList().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Option<String> option;
                String processingType = (String)tuple2._1();
                CategoryConfig categoryConfig = (CategoryConfig)tuple2._2();
                if (categoryConfig != null && (option = categoryConfig.category()) instanceof Some) {
                    Some some = (Some)option;
                    String category = (String)some.value();
                    return new Tuple2((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)processingType), (Object)category)})), (Object)Predef$.MODULE$.Set().empty());
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            String processingTypeWithoutCategory = (String)tuple2._1();
            CategoryConfig categoryConfig = (CategoryConfig)tuple2._2();
            if (categoryConfig == null) throw new MatchError((Object)tuple2);
            Option<String> option = categoryConfig.category();
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)tuple2);
            return new Tuple2((Object)Predef$.MODULE$.Map().empty(), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{processingTypeWithoutCategory})));
        }, List$.MODULE$.canBuildFrom()), (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForList()).combineAll(Semigroup$.MODULE$.catsKernelMonoidForTuple2(package.map$.MODULE$.catsKernelStdMonoidForMap((Semigroup)Semigroup$.MODULE$.catsKernelMonoidForString()), (Monoid)package.set$.MODULE$.catsKernelStdSemilatticeForSet()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Map processingTypesWithDefinedCategory = (Map)tuple2._1();
        Set notDefinedCategoryProcessingTypes = (Set)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)processingTypesWithDefinedCategory, (Object)notDefinedCategoryProcessingTypes);
        Tuple2 tuple23 = tuple22;
        Map processingTypesWithDefinedCategory2 = (Map)tuple23._1();
        Set notDefinedCategoryProcessingTypes2 = (Set)tuple23._2();
        boolean isLegacyConfigFormat = config.hasPath(this.categoryConfigPath());
        if (isLegacyConfigFormat) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringBuilder(157).append("Legacy ").append(this.categoryConfigPath()).append(" format detected. Please replace it by categories defined inside scenarioTypes. ").append("In the further versions the support for the old format will be removed").toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            LegacyConfigProcessCategoryService legacy = new LegacyConfigProcessCategoryService(config);
            processCategoryService = notDefinedCategoryProcessingTypes2.nonEmpty() ? new MixedProcessCategoryService(new ProcessingTypeCategoryService((Map<String, String>)processingTypesWithDefinedCategory2), legacy) : legacy;
        } else {
            if (notDefinedCategoryProcessingTypes2.nonEmpty()) {
                throw new IllegalArgumentException(new StringBuilder(84).append("Illegal categories configuration. These scenario types have no category configured: ").append(notDefinedCategoryProcessingTypes2).toString());
            }
            processCategoryService = new ProcessingTypeCategoryService((Map<String, String>)processingTypesWithDefinedCategory2);
        }
        ProcessingTypeCategoryService service2 = processCategoryService;
        this.checkProcessingTypeToCategoryMappingAmbiguity(service2);
        this.checkCategoryToProcessingTypeMappingAmbiguity((Iterable<String>)processingCategories.keys(), service2);
        return service2;
    }

    private void checkProcessingTypeToCategoryMappingAmbiguity(ProcessCategoryService service2) {
        Map processingTypesForEachCategory = Implicits$.MODULE$.RichScalaMap(((TraversableLike)service2.getAllCategories().map((Function1 & Serializable & scala.Serializable)category -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)service2.getTypeForCategoryUnsafe((String)category)), category), List$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x$3 -> (String)x$3._1())).mapValuesNow((Function1 & Serializable & scala.Serializable)x$4 -> ((TraversableOnce)x$4.map((Function1 & Serializable & scala.Serializable)x$5 -> (String)x$5._2(), List$.MODULE$.canBuildFrom())).toSet());
        Map ambiguousProcessingTypeToCategoryMappings = (Map)processingTypesForEachCategory.filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ConfigProcessCategoryService$.$anonfun$checkProcessingTypeToCategoryMappingAmbiguity$5(x$6)));
        if (ambiguousProcessingTypeToCategoryMappings.nonEmpty()) {
            throw new ConfigProcessCategoryService.ProcessingTypeToCategoryMappingAmbiguousException((Map<String, Set<String>>)ambiguousProcessingTypeToCategoryMappings);
        }
    }

    private void checkCategoryToProcessingTypeMappingAmbiguity(Iterable<String> scenarioTypes, ProcessCategoryService service2) {
        Map processingTypesForEachCategory = Implicits$.MODULE$.RichScalaMap(((TraversableLike)scenarioTypes.map((Function1 & Serializable & scala.Serializable)processingType -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)service2.getProcessingTypeCategoryUnsafe((String)processingType)), processingType), Iterable$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x$7 -> (String)x$7._1())).mapValuesNow((Function1 & Serializable & scala.Serializable)x$8 -> ((TraversableOnce)x$8.map((Function1 & Serializable & scala.Serializable)x$9 -> (String)x$9._2(), Iterable$.MODULE$.canBuildFrom())).toSet());
        Map ambiguousCategoryToProcessingTypeMappings = (Map)processingTypesForEachCategory.filter((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ConfigProcessCategoryService$.$anonfun$checkCategoryToProcessingTypeMappingAmbiguity$5(x$10)));
        if (ambiguousCategoryToProcessingTypeMappings.nonEmpty()) {
            throw new ConfigProcessCategoryService.CategoryToProcessingTypeMappingAmbiguousException((Map<String, Set<String>>)ambiguousCategoryToProcessingTypeMappings);
        }
    }

    public static final /* synthetic */ boolean $anonfun$checkProcessingTypeToCategoryMappingAmbiguity$5(Tuple2 x$6) {
        return ((TraversableOnce)x$6._2()).size() > 1;
    }

    public static final /* synthetic */ boolean $anonfun$checkCategoryToProcessingTypeMappingAmbiguity$5(Tuple2 x$10) {
        return ((TraversableOnce)x$10._2()).size() > 1;
    }

    private ConfigProcessCategoryService$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.categoryConfigPath = "categoriesConfig";
    }
}

