/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.api;

import akka.http.javadsl.common.JsonEntityStreamingSupport;
import akka.http.scaladsl.marshalling.Marshaller;
import akka.http.scaladsl.marshalling.Marshaller$;
import akka.http.scaladsl.marshalling.ToResponseMarshallable;
import akka.http.scaladsl.marshalling.ToResponseMarshallable$;
import akka.http.scaladsl.model.ContentTypeRange;
import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.HttpEntity$;
import akka.http.scaladsl.model.HttpProtocol;
import akka.http.scaladsl.model.HttpResponse;
import akka.http.scaladsl.model.HttpResponse$;
import akka.http.scaladsl.model.MediaType;
import akka.http.scaladsl.model.RequestEntity;
import akka.http.scaladsl.model.ResponseEntity;
import akka.http.scaladsl.model.StatusCode;
import akka.http.scaladsl.model.StatusCodes;
import akka.http.scaladsl.model.StatusCodes$;
import akka.http.scaladsl.server.Directives$;
import akka.http.scaladsl.server.ExceptionHandler;
import akka.http.scaladsl.server.ExceptionHandler$;
import akka.http.scaladsl.unmarshalling.Unmarshaller;
import akka.stream.scaladsl.Source;
import akka.util.ByteString;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import de.heikoseeberger.akkahttpcirce.BaseCirceSupport;
import de.heikoseeberger.akkahttpcirce.FailFastCirceSupport;
import de.heikoseeberger.akkahttpcirce.FailFastUnmarshaller;
import io.circe.Decoder;
import io.circe.Encoder;
import io.circe.Error;
import io.circe.Json;
import io.circe.ParsingFailure;
import io.circe.Printer;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.ExecutionException;
import pl.touk.nussknacker.ui.BadRequestError;
import pl.touk.nussknacker.ui.FatalError;
import pl.touk.nussknacker.ui.IllegalOperationError;
import pl.touk.nussknacker.ui.NotFoundError;
import pl.touk.nussknacker.ui.NuDesignerError;
import pl.touk.nussknacker.ui.OtherError;
import pl.touk.nussknacker.ui.UnauthorizedError;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.NotImplementedError;
import scala.Option;
import scala.PartialFunction;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

public final class NuDesignerErrorToHttp$
implements LazyLogging,
FailFastCirceSupport {
    public static NuDesignerErrorToHttp$ MODULE$;
    private final Marshaller<Source<ByteString, Object>, RequestEntity> de$heikoseeberger$akkahttpcirce$BaseCirceSupport$$jsonSourceStringMarshaller;
    private final Unmarshaller<HttpEntity, Json> jsonUnmarshaller;
    private final Unmarshaller<HttpEntity, Either<ParsingFailure, Json>> safeJsonUnmarshaller;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new NuDesignerErrorToHttp$();
    }

    public final <A> Unmarshaller<ByteString, A> fromByteStringUnmarshaller(Decoder<A> evidence$5) {
        return FailFastUnmarshaller.fromByteStringUnmarshaller$((FailFastUnmarshaller)this, evidence$5);
    }

    public final <A> Unmarshaller<HttpEntity, A> unmarshaller(Decoder<A> evidence$6) {
        return FailFastUnmarshaller.unmarshaller$((FailFastUnmarshaller)this, evidence$6);
    }

    public final <A> Unmarshaller<HttpEntity, Either<Error, A>> safeUnmarshaller(Decoder<A> evidence$7) {
        return FailFastUnmarshaller.safeUnmarshaller$((FailFastUnmarshaller)this, evidence$7);
    }

    public Seq<ContentTypeRange> unmarshallerContentTypes() {
        return BaseCirceSupport.unmarshallerContentTypes$((BaseCirceSupport)this);
    }

    public Seq<MediaType.WithFixedCharset> mediaTypes() {
        return BaseCirceSupport.mediaTypes$((BaseCirceSupport)this);
    }

    public final Marshaller<Json, RequestEntity> jsonMarshaller(Printer printer) {
        return BaseCirceSupport.jsonMarshaller$((BaseCirceSupport)this, (Printer)printer);
    }

    public final Printer jsonMarshaller$default$1() {
        return BaseCirceSupport.jsonMarshaller$default$1$((BaseCirceSupport)this);
    }

    public final <A> Marshaller<A, RequestEntity> marshaller(Encoder<A> evidence$2, Printer printer) {
        return BaseCirceSupport.marshaller$((BaseCirceSupport)this, evidence$2, (Printer)printer);
    }

    public final <A> Printer marshaller$default$2() {
        return BaseCirceSupport.marshaller$default$2$((BaseCirceSupport)this);
    }

    public Unmarshaller<ByteString, Json> byteStringJsonUnmarshaller() {
        return BaseCirceSupport.byteStringJsonUnmarshaller$((BaseCirceSupport)this);
    }

    public <A> Unmarshaller<HttpEntity, Source<A, Object>> sourceUnmarshaller(Decoder<A> evidence$4, JsonEntityStreamingSupport support) {
        return BaseCirceSupport.sourceUnmarshaller$((BaseCirceSupport)this, evidence$4, (JsonEntityStreamingSupport)support);
    }

    public <A> JsonEntityStreamingSupport sourceUnmarshaller$default$2() {
        return BaseCirceSupport.sourceUnmarshaller$default$2$((BaseCirceSupport)this);
    }

    public <A> Marshaller<Source<A, Object>, RequestEntity> sourceMarshaller(Encoder<A> writes, Printer printer, JsonEntityStreamingSupport support) {
        return BaseCirceSupport.sourceMarshaller$((BaseCirceSupport)this, writes, (Printer)printer, (JsonEntityStreamingSupport)support);
    }

    public <A> Printer sourceMarshaller$default$2() {
        return BaseCirceSupport.sourceMarshaller$default$2$((BaseCirceSupport)this);
    }

    public <A> JsonEntityStreamingSupport sourceMarshaller$default$3() {
        return BaseCirceSupport.sourceMarshaller$default$3$((BaseCirceSupport)this);
    }

    public Marshaller<Source<ByteString, Object>, RequestEntity> de$heikoseeberger$akkahttpcirce$BaseCirceSupport$$jsonSourceStringMarshaller() {
        return this.de$heikoseeberger$akkahttpcirce$BaseCirceSupport$$jsonSourceStringMarshaller;
    }

    public final Unmarshaller<HttpEntity, Json> jsonUnmarshaller() {
        return this.jsonUnmarshaller;
    }

    public final Unmarshaller<HttpEntity, Either<ParsingFailure, Json>> safeJsonUnmarshaller() {
        return this.safeJsonUnmarshaller;
    }

    public final void de$heikoseeberger$akkahttpcirce$BaseCirceSupport$_setter_$de$heikoseeberger$akkahttpcirce$BaseCirceSupport$$jsonSourceStringMarshaller_$eq(Marshaller<Source<ByteString, Object>, RequestEntity> x$1) {
        this.de$heikoseeberger$akkahttpcirce$BaseCirceSupport$$jsonSourceStringMarshaller = x$1;
    }

    public final void de$heikoseeberger$akkahttpcirce$BaseCirceSupport$_setter_$jsonUnmarshaller_$eq(Unmarshaller<HttpEntity, Json> x$1) {
        this.jsonUnmarshaller = x$1;
    }

    public final void de$heikoseeberger$akkahttpcirce$BaseCirceSupport$_setter_$safeJsonUnmarshaller_$eq(Unmarshaller<HttpEntity, Either<ParsingFailure, Json>> x$1) {
        this.safeJsonUnmarshaller = x$1;
    }

    private Logger logger$lzycompute() {
        NuDesignerErrorToHttp$ nuDesignerErrorToHttp$ = this;
        synchronized (nuDesignerErrorToHttp$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public ExceptionHandler nuDesignerErrorHandler() {
        return ExceptionHandler$.MODULE$.apply((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                Option option = NonFatal$.MODULE$.unapply(A1);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    object = Directives$.MODULE$.complete((Function0 & Serializable & scala.Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)NuDesignerErrorToHttp$.MODULE$.pl$touk$nussknacker$ui$api$NuDesignerErrorToHttp$$errorToHttpResponse(NuDesignerErrorToHttp$.MODULE$.unwrapException(e)), Marshaller$.MODULE$.fromResponse()));
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                Option option = NonFatal$.MODULE$.unapply(throwable);
                boolean bl = !option.isEmpty();
                return bl;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(java.lang.Throwable )}, serializedLambda);
            }
        });
    }

    public Throwable unwrapException(Throwable e) {
        Throwable throwable;
        Throwable throwable2 = e;
        if (throwable2 instanceof ExecutionException) {
            ExecutionException executionException = (ExecutionException)throwable2;
            throwable = executionException.getCause();
        } else {
            throwable = throwable2;
        }
        return throwable;
    }

    public HttpResponse pl$touk$nussknacker$ui$api$NuDesignerErrorToHttp$$errorToHttpResponse(Throwable e) {
        HttpResponse httpResponse;
        Throwable throwable = e;
        if (throwable instanceof NuDesignerError) {
            NuDesignerError nuDesignerError = (NuDesignerError)throwable;
            this.logError(nuDesignerError);
            httpResponse = this.httpResponseFrom(nuDesignerError);
        } else if (throwable instanceof IllegalArgumentException) {
            BoxedUnit boxedUnit;
            IllegalArgumentException illegalArgumentException = (IllegalArgumentException)throwable;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringBuilder(18).append("Illegal argument: ").append(illegalArgumentException.getMessage()).toString(), (Throwable)illegalArgumentException);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            StatusCodes.ClientError x$1 = StatusCodes$.MODULE$.BadRequest();
            HttpEntity.Strict x$2 = HttpEntity$.MODULE$.apply(illegalArgumentException.getMessage());
            Seq x$3 = HttpResponse$.MODULE$.apply$default$2();
            HttpProtocol x$4 = HttpResponse$.MODULE$.apply$default$4();
            httpResponse = HttpResponse$.MODULE$.apply((StatusCode)x$1, x$3, (ResponseEntity)x$2, x$4);
        } else if (throwable instanceof NotImplementedError) {
            BoxedUnit boxedUnit;
            NotImplementedError notImplementedError = (NotImplementedError)throwable;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringBuilder(17).append("Not implemented: ").append(notImplementedError.getMessage()).toString(), (Throwable)notImplementedError);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            StatusCodes.ServerError x$5 = StatusCodes$.MODULE$.NotImplemented();
            HttpEntity.Strict x$6 = HttpEntity$.MODULE$.apply(notImplementedError.getMessage());
            Seq x$7 = HttpResponse$.MODULE$.apply$default$2();
            HttpProtocol x$8 = HttpResponse$.MODULE$.apply$default$4();
            httpResponse = HttpResponse$.MODULE$.apply((StatusCode)x$5, x$7, (ResponseEntity)x$6, x$8);
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringBuilder(15).append("Unknown error: ").append(throwable.getMessage()).toString(), throwable);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            StatusCodes.ServerError x$9 = StatusCodes$.MODULE$.InternalServerError();
            HttpEntity.Strict x$10 = HttpEntity$.MODULE$.apply(throwable.getMessage());
            Seq x$11 = HttpResponse$.MODULE$.apply$default$2();
            HttpProtocol x$12 = HttpResponse$.MODULE$.apply$default$4();
            httpResponse = HttpResponse$.MODULE$.apply((StatusCode)x$9, x$11, (ResponseEntity)x$10, x$12);
        }
        return httpResponse;
    }

    public <T> ToResponseMarshallable toResponseEither(Either<NuDesignerError, T> either, Encoder<T> evidence$1) {
        ToResponseMarshallable toResponseMarshallable;
        Either<NuDesignerError, T> either2 = either;
        if (either2 instanceof Right) {
            Right right = (Right)either2;
            Object t = right.value();
            toResponseMarshallable = ToResponseMarshallable$.MODULE$.apply(t, Marshaller$.MODULE$.liftMarshaller(this.marshaller(evidence$1, this.marshaller$default$2())));
        } else if (either2 instanceof Left) {
            Left left = (Left)either2;
            NuDesignerError err = (NuDesignerError)left.value();
            toResponseMarshallable = ToResponseMarshallable$.MODULE$.apply((Object)this.httpResponseFrom(err), Marshaller$.MODULE$.fromResponse());
        } else {
            throw new MatchError(either2);
        }
        return toResponseMarshallable;
    }

    public HttpResponse httpResponseFrom(NuDesignerError error) {
        StatusCode x$1 = this.httpStatusCodeFrom(error);
        HttpEntity.Strict x$2 = HttpEntity$.MODULE$.apply(error.getMessage());
        Seq x$3 = HttpResponse$.MODULE$.apply$default$2();
        HttpProtocol x$4 = HttpResponse$.MODULE$.apply$default$4();
        return HttpResponse$.MODULE$.apply(x$1, x$3, (ResponseEntity)x$2, x$4);
    }

    private void logError(NuDesignerError error) {
        NuDesignerError nuDesignerError = error;
        if (nuDesignerError instanceof NotFoundError) {
            BoxedUnit boxedUnit;
            NotFoundError notFoundError = (NotFoundError)nuDesignerError;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringBuilder(19).append("Not found error: ").append(notFoundError.getMessage()).append(". ").append(this.returnedHttpStatusInfo(notFoundError)).toString(), (Throwable)notFoundError);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (nuDesignerError instanceof BadRequestError) {
            BoxedUnit boxedUnit;
            BadRequestError badRequestError = (BadRequestError)nuDesignerError;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringBuilder(21).append("Bad request error: ").append(badRequestError.getMessage()).append(". ").append(this.returnedHttpStatusInfo(badRequestError)).toString(), (Throwable)badRequestError);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        } else if (nuDesignerError instanceof UnauthorizedError) {
            BoxedUnit boxedUnit;
            UnauthorizedError unauthorizedError = (UnauthorizedError)nuDesignerError;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringBuilder(22).append("Unauthorized error: ").append(unauthorizedError.getMessage()).append(". ").append(this.returnedHttpStatusInfo(unauthorizedError)).toString(), (Throwable)unauthorizedError);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit4 = boxedUnit;
        } else if (nuDesignerError instanceof IllegalOperationError) {
            BoxedUnit boxedUnit;
            IllegalOperationError illegalOperationError = (IllegalOperationError)nuDesignerError;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringBuilder(46).append("Illegal operation error: ").append(illegalOperationError.getMessage()).append(". ").append(this.returnedHttpStatusInfo(illegalOperationError)).append(" Error details: [").append(illegalOperationError.details()).append("].").toString(), (Throwable)illegalOperationError);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit5 = boxedUnit;
        } else if (nuDesignerError instanceof OtherError) {
            BoxedUnit boxedUnit;
            OtherError otherError = (OtherError)nuDesignerError;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringBuilder(15).append("Other error: ").append(otherError.getMessage()).append(". ").append(this.returnedHttpStatusInfo(otherError)).toString(), (Throwable)otherError);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit6 = boxedUnit;
        } else if (nuDesignerError instanceof FatalError) {
            BoxedUnit boxedUnit;
            FatalError fatalError = (FatalError)nuDesignerError;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringBuilder(15).append("Fatal error: ").append(fatalError.getMessage()).append(". ").append(this.returnedHttpStatusInfo(fatalError)).toString(), (Throwable)fatalError);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit7 = boxedUnit;
        } else {
            throw new MatchError((Object)nuDesignerError);
        }
    }

    private String returnedHttpStatusInfo(NuDesignerError error) {
        return new StringBuilder(30).append("Http status ").append(this.httpStatusCodeFrom(error).intValue()).append(" will be returned.").toString();
    }

    private StatusCode httpStatusCodeFrom(NuDesignerError error) {
        StatusCodes.ClientError clientError;
        NuDesignerError nuDesignerError = error;
        if (nuDesignerError instanceof NotFoundError) {
            clientError = StatusCodes$.MODULE$.NotFound();
        } else if (nuDesignerError instanceof FatalError) {
            clientError = StatusCodes$.MODULE$.InternalServerError();
        } else if (nuDesignerError instanceof BadRequestError) {
            clientError = StatusCodes$.MODULE$.BadRequest();
        } else if (nuDesignerError instanceof UnauthorizedError) {
            clientError = StatusCodes$.MODULE$.Unauthorized();
        } else if (nuDesignerError instanceof IllegalOperationError) {
            clientError = StatusCodes$.MODULE$.Conflict();
        } else if (nuDesignerError instanceof OtherError) {
            clientError = StatusCodes$.MODULE$.InternalServerError();
        } else {
            throw new MatchError((Object)nuDesignerError);
        }
        return clientError;
    }

    private NuDesignerErrorToHttp$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        BaseCirceSupport.$init$((BaseCirceSupport)this);
        FailFastUnmarshaller.$init$((FailFastUnmarshaller)this);
    }
}

