/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.process.migrate;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import pl.touk.nussknacker.engine.api.graph.ScenarioGraph;
import pl.touk.nussknacker.engine.api.process.ProcessName;
import pl.touk.nussknacker.engine.canonicalgraph.CanonicalProcess;
import pl.touk.nussknacker.engine.util.Implicits$;
import pl.touk.nussknacker.restmodel.scenariodetails.ScenarioWithDetailsForMigrations;
import pl.touk.nussknacker.restmodel.validation.ValidationResults;
import pl.touk.nussknacker.ui.process.fragment.FragmentRepository;
import pl.touk.nussknacker.ui.process.fragment.FragmentResolver;
import pl.touk.nussknacker.ui.process.marshall.CanonicalProcessConverter$;
import pl.touk.nussknacker.ui.process.migrate.MigratedProcessDetails;
import pl.touk.nussknacker.ui.process.migrate.MigrationResult;
import pl.touk.nussknacker.ui.process.migrate.ProcessModelMigrator;
import pl.touk.nussknacker.ui.process.migrate.TestMigrationResult;
import pl.touk.nussknacker.ui.process.processingtype.ProcessingTypeDataProvider;
import pl.touk.nussknacker.ui.security.api.LoggedUser;
import pl.touk.nussknacker.ui.validation.UIProcessValidator;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.MapLike;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.collection.parallel.ExecutionContextTaskSupport;
import scala.collection.parallel.ParIterableLike;
import scala.collection.parallel.TaskSupport;
import scala.collection.parallel.immutable.ParVector;
import scala.collection.parallel.immutable.ParVector$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\u0005%e\u0001B\u0005\u000b\u0001]A\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005\u0001\")1\n\u0001C\u0001\u0019\")\u0001\f\u0001C\u00013\"9\u00111\u0003\u0001\u0005\n\u0005U\u0001bBA\u0016\u0001\u0011%\u0011Q\u0006\u0005\b\u0003\u000b\u0002A\u0011BA$\u0011\u001d\tI\u0006\u0001C\u0005\u00037\u00121\u0003V3ti6{G-\u001a7NS\u001e\u0014\u0018\r^5p]NT!a\u0003\u0007\u0002\u000f5LwM]1uK*\u0011QBD\u0001\baJ|7-Z:t\u0015\ty\u0001#\u0001\u0002vS*\u0011\u0011CE\u0001\f]V\u001c8o\u001b8bG.,'O\u0003\u0002\u0014)\u0005!Ao\\;l\u0015\u0005)\u0012A\u00019m\u0007\u0001\u00192\u0001\u0001\r\u001f!\tIB$D\u0001\u001b\u0015\u0005Y\u0012!B:dC2\f\u0017BA\u000f\u001b\u0005\u0019\te.\u001f*fMB\u0011qDJ\u0007\u0002A)\u0011\u0011EI\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003G\u0011\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002K\u0005\u00191m\\7\n\u0005\u001d\u0002#a\u0003'bufdunZ4j]\u001e\f\u0011\"\\5he\u0006$xN]:1\u0005)2\u0004\u0003B\u0016/aQj\u0011\u0001\f\u0006\u0003[1\ta\u0002\u001d:pG\u0016\u001c8/\u001b8hif\u0004X-\u0003\u00020Y\tQ\u0002K]8dKN\u001c\u0018N\\4UsB,G)\u0019;b!J|g/\u001b3feB\u0011\u0011GM\u0007\u0002\u0015%\u00111G\u0003\u0002\u0015!J|7-Z:t\u001b>$W\r\\'jOJ\fGo\u001c:\u0011\u0005U2D\u0002\u0001\u0003\no\u0005\t\t\u0011!A\u0003\u0002a\u00121a\u0018\u00132#\tID\b\u0005\u0002\u001au%\u00111H\u0007\u0002\b\u001d>$\b.\u001b8h!\tIR(\u0003\u0002?5\t\u0019\u0011I\\=\u0002!A\u0014xnY3tgZ\u000bG.\u001b3bi>\u0014\bGA!J!\u0011YcF\u0011%\u0011\u0005\r3U\"\u0001#\u000b\u0005\u0015s\u0011A\u0003<bY&$\u0017\r^5p]&\u0011q\t\u0012\u0002\u0013+&\u0003&o\\2fgN4\u0016\r\\5eCR|'\u000f\u0005\u00026\u0013\u0012I!JAA\u0001\u0002\u0003\u0015\t\u0001\u000f\u0002\u0004?\u0012\u0012\u0014A\u0002\u001fj]&$h\bF\u0002N\u001dN\u0003\"!\r\u0001\t\u000b!\u001a\u0001\u0019A(1\u0005A\u0013\u0006\u0003B\u0016/aE\u0003\"!\u000e*\u0005\u0013]r\u0015\u0011!A\u0001\u0006\u0003A\u0004\"B \u0004\u0001\u0004!\u0006GA+X!\u0011YcF\u0011,\u0011\u0005U:F!\u0003&T\u0003\u0003\u0005\tQ!\u00019\u00039!Xm\u001d;NS\u001e\u0014\u0018\r^5p]N$RA\u0017;\u0000\u0003\u0007!\"a\u00176\u0011\u0007q#wM\u0004\u0002^E:\u0011a,Y\u0007\u0002?*\u0011\u0001MF\u0001\u0007yI|w\u000e\u001e \n\u0003mI!a\u0019\u000e\u0002\u000fA\f7m[1hK&\u0011QM\u001a\u0002\u0005\u0019&\u001cHO\u0003\u0002d5A\u0011\u0011\u0007[\u0005\u0003S*\u00111\u0003V3ti6KwM]1uS>t'+Z:vYRDQa\u001b\u0003A\u00041\fA!^:feB\u0011QN]\u0007\u0002]*\u0011q\u000e]\u0001\u0004CBL'BA9\u000f\u0003!\u0019XmY;sSRL\u0018BA:o\u0005)aunZ4fIV\u001bXM\u001d\u0005\u0006k\u0012\u0001\rA^\u0001\naJ|7-Z:tKN\u00042\u0001\u00183x!\tAX0D\u0001z\u0015\tQ80A\btG\u0016t\u0017M]5pI\u0016$\u0018-\u001b7t\u0015\ta\b#A\u0005sKN$Xn\u001c3fY&\u0011a0\u001f\u0002!'\u000e,g.\u0019:j_^KG\u000f\u001b#fi\u0006LGn\u001d$pe6KwM]1uS>t7\u000f\u0003\u0004\u0002\u0002\u0011\u0001\rA^\u0001\nMJ\fw-\\3oiNDq!!\u0002\u0005\u0001\u0004\t9!\u0001\rcCR\u001c\u0007.\u001b8h\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\u0004B!!\u0003\u0002\u00105\u0011\u00111\u0002\u0006\u0004\u0003\u001bQ\u0012AC2p]\u000e,(O]3oi&!\u0011\u0011CA\u0006\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH/\u0001\bnS\u001e\u0014\u0018\r^3Qe>\u001cWm]:\u0015\t\u0005]\u0011q\u0005\u000b\u0005\u00033\t)\u0003E\u0003\u001a\u00037\ty\"C\u0002\u0002\u001ei\u0011aa\u00149uS>t\u0007cA\u0019\u0002\"%\u0019\u00111\u0005\u0006\u0003-5KwM]1uK\u0012\u0004&o\\2fgN$U\r^1jYNDQa[\u0003A\u00041Da!!\u000b\u0006\u0001\u00049\u0018aE:dK:\f'/[8XSRDG)\u001a;bS2\u001c\u0018!\u00079sKB\f'/\u001a$sC\u001elWM\u001c;SKB|7/\u001b;pef$B!a\f\u0002BI)\u0011\u0011\u0007\r\u00026\u00191\u00111\u0007\u0004\u0001\u0003_\u0011A\u0002\u0010:fM&tW-\\3oiz\u0002B!a\u000e\u0002>5\u0011\u0011\u0011\b\u0006\u0004\u0003wa\u0011\u0001\u00034sC\u001elWM\u001c;\n\t\u0005}\u0012\u0011\b\u0002\u0013\rJ\fw-\\3oiJ+\u0007o\\:ji>\u0014\u0018\u0010C\u0004\u0002\u0002\u0019\u0001\r!a\u0011\u0011\tq#\u0017qD\u0001\u0012aJ|7-Z:t\u0013:\u0004\u0016M]1mY\u0016dGCBA%\u0003'\n9\u0006F\u0002\\\u0003\u0017Ba!D\u0004A\u0002\u00055\u0003CB\r\u0002P\u0005}q-C\u0002\u0002Ri\u0011\u0011BR;oGRLwN\\\u0019\t\u000f\u0005Us\u00011\u0001\u0002D\u0005)\u0011N\u001c9vi\"9\u0011QA\u0004A\u0002\u0005\u001d\u0011\u0001E3yiJ\f7\r\u001e(fo\u0016\u0013(o\u001c:t)\u0019\ti&!!\u0002\u0006B!\u0011qLA>\u001d\u0011\t\t'!\u001e\u000f\t\u0005\r\u00141\u000f\b\u0005\u0003K\n\tH\u0004\u0003\u0002h\u0005=d\u0002BA5\u0003[r1AXA6\u0013\u0005)\u0012BA\n\u0015\u0013\t\t\"#\u0003\u0002}!%\u0011Qi_\u0005\u0005\u0003o\nI(A\tWC2LG-\u0019;j_:\u0014Vm];miNT!!R>\n\t\u0005u\u0014q\u0010\u0002\u0011-\u0006d\u0017\u000eZ1uS>t'+Z:vYRTA!a\u001e\u0002z!9\u00111\u0011\u0005A\u0002\u0005u\u0013A\u00022fM>\u0014X\rC\u0004\u0002\b\"\u0001\r!!\u0018\u0002\u000b\u00054G/\u001a:")
public class TestModelMigrations
implements LazyLogging {
    private final ProcessingTypeDataProvider<ProcessModelMigrator, ?> migrators;
    private final ProcessingTypeDataProvider<UIProcessValidator, ?> processValidator;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        TestModelMigrations testModelMigrations = this;
        synchronized (testModelMigrations) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public List<TestMigrationResult> testMigrations(List<ScenarioWithDetailsForMigrations> processes, List<ScenarioWithDetailsForMigrations> fragments, ExecutionContext batchingExecutionContext, LoggedUser user) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Testing scenario migrations (scenarios={}, fragments={})", new Object[]{BoxesRunTime.boxToInteger((int)processes.count((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TestModelMigrations.$anonfun$testMigrations$1(x$1)))), BoxesRunTime.boxToInteger((int)fragments.count((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TestModelMigrations.$anonfun$testMigrations$2(x$2))))});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        List migratedFragments = (List)fragments.flatMap((Function1 & Serializable & scala.Serializable)scenarioWithDetails -> Option$.MODULE$.option2Iterable(this.migrateProcess((ScenarioWithDetailsForMigrations)scenarioWithDetails, user)), List$.MODULE$.canBuildFrom());
        List migratedProcesses = (List)processes.flatMap((Function1 & Serializable & scala.Serializable)scenarioWithDetails -> Option$.MODULE$.option2Iterable(this.migrateProcess((ScenarioWithDetailsForMigrations)scenarioWithDetails, user)), List$.MODULE$.canBuildFrom());
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Validating migrated scenarios");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ProcessingTypeDataProvider validator = this.processValidator.mapValues((Function1 & Serializable & scala.Serializable)x$3 -> x$3.withFragmentResolver(new FragmentResolver(this.prepareFragmentRepository((List<MigratedProcessDetails>)migratedFragments))));
        return this.processInParallel((List<MigratedProcessDetails>)((List)migratedFragments.$plus$plus((GenTraversableOnce)migratedProcesses, List$.MODULE$.canBuildFrom())), batchingExecutionContext, (Function1<MigratedProcessDetails, TestMigrationResult>)(Function1 & Serializable & scala.Serializable)migrationDetails -> {
            ValidationResults.ValidationResult validationResult = ((UIProcessValidator)validator.forProcessingTypeUnsafe(migrationDetails.processingType(), user)).validate(migrationDetails.newScenarioGraph(), migrationDetails.processName(), migrationDetails.isFragment(), user);
            ValidationResults.ValidationResult newErrors = this.extractNewErrors(migrationDetails.oldProcessErrors(), validationResult);
            return new TestMigrationResult(migrationDetails.processName(), newErrors);
        });
    }

    private Option<MigratedProcessDetails> migrateProcess(ScenarioWithDetailsForMigrations scenarioWithDetails, LoggedUser user) {
        return this.migrators.forProcessingType(scenarioWithDetails.processingType(), user).flatMap((Function1 & Serializable & scala.Serializable)migrator -> migrator.migrateProcess(scenarioWithDetails.name(), scenarioWithDetails.scenarioGraphUnsafe(), (Option<Object>)scenarioWithDetails.modelVersion(), scenarioWithDetails.processCategory(), false).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)TestModelMigrations.$anonfun$migrateProcess$2(check$ifrefutable$1))).map((Function1 & Serializable & scala.Serializable)x$5 -> {
            MigrationResult migrationResult = x$5;
            if (migrationResult == null) {
                throw new MatchError((Object)migrationResult);
            }
            CanonicalProcess newProcess = migrationResult.process();
            ScenarioGraph scenarioGraph = CanonicalProcessConverter$.MODULE$.toScenarioGraph(newProcess);
            Tuple2 tuple2 = new Tuple2((Object)migrationResult, (Object)scenarioGraph);
            return tuple2;
        }).map((Function1 & Serializable & scala.Serializable)x$6 -> {
            ScenarioGraph scenarioGraph;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x$6;
                    if (tuple2 == null) break block2;
                    MigrationResult migrationResult = (MigrationResult)tuple2._1();
                    scenarioGraph = (ScenarioGraph)tuple2._2();
                    if (migrationResult != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            MigratedProcessDetails migratedProcessDetails = new MigratedProcessDetails(scenarioWithDetails.name(), scenarioWithDetails.processingType(), scenarioWithDetails.isFragment(), scenarioGraph, scenarioWithDetails.validationResultUnsafe());
            return migratedProcessDetails;
        }));
    }

    private FragmentRepository prepareFragmentRepository(List<MigratedProcessDetails> fragments) {
        ListMap fragmentsByProcessingType = Implicits$.MODULE$.RichTupleList((List)fragments.map((Function1 & Serializable & scala.Serializable)fragmentDetails -> {
            CanonicalProcess canonical = CanonicalProcessConverter$.MODULE$.fromScenarioGraph(fragmentDetails.newScenarioGraph(), fragmentDetails.processName());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fragmentDetails.processingType()), (Object)canonical);
        }, List$.MODULE$.canBuildFrom())).toGroupedMap();
        return new FragmentRepository(null, fragmentsByProcessingType){
            private final ListMap fragmentsByProcessingType$1;

            public final List<CanonicalProcess> fetchLatestFragmentsSync(String processingType, LoggedUser user) {
                return FragmentRepository.fetchLatestFragmentsSync$(this, processingType, user);
            }

            public final Option<CanonicalProcess> fetchLatestFragmentSync(ProcessName fragmentName, LoggedUser user) {
                return FragmentRepository.fetchLatestFragmentSync$(this, fragmentName, user);
            }

            public Future<List<CanonicalProcess>> fetchLatestFragments(String processingType, LoggedUser user) {
                return Future$.MODULE$.successful(this.fragmentsByProcessingType$1.getOrElse((Object)processingType, (Function0 & Serializable & scala.Serializable)() -> List$.MODULE$.empty()));
            }

            public Future<Option<CanonicalProcess>> fetchLatestFragment(ProcessName fragmentName, LoggedUser user) {
                throw new IllegalStateException("FragmentRepository.get(ProcessName) used during migration");
            }
            {
                this.fragmentsByProcessingType$1 = fragmentsByProcessingType$1;
                FragmentRepository.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$fetchLatestFragments$1()}, serializedLambda);
            }
        };
    }

    private List<TestMigrationResult> processInParallel(List<MigratedProcessDetails> input, ExecutionContext batchingExecutionContext, Function1<MigratedProcessDetails, TestMigrationResult> process) {
        ParVector parallelCollection = new ParVector(input.toVector());
        parallelCollection.tasksupport_$eq((TaskSupport)new ExecutionContextTaskSupport(batchingExecutionContext));
        return ((ParIterableLike)parallelCollection.map(process, (CanBuildFrom)ParVector$.MODULE$.canBuildFrom())).toList();
    }

    private ValidationResults.ValidationResult extractNewErrors(ValidationResults.ValidationResult before, ValidationResults.ValidationResult after) {
        return new ValidationResults.ValidationResult(new ValidationResults.ValidationErrors(TestModelMigrations.diffOnMap$1(before.errors().invalidNodes(), after.errors().invalidNodes()), TestModelMigrations.diffErrorLists$1(before.errors().processPropertiesErrors(), after.errors().processPropertiesErrors()), TestModelMigrations.diffOnGlobalErrors$1(before.errors().globalErrors(), after.errors().globalErrors())), new ValidationResults.ValidationWarnings(TestModelMigrations.diffOnMap$1(before.warnings().invalidNodes(), after.warnings().invalidNodes())), Predef$.MODULE$.Map().empty());
    }

    public static final /* synthetic */ boolean $anonfun$testMigrations$1(ScenarioWithDetailsForMigrations x$1) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$testMigrations$2(ScenarioWithDetailsForMigrations x$2) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$migrateProcess$2(MigrationResult check$ifrefutable$1) {
        MigrationResult migrationResult = check$ifrefutable$1;
        boolean bl = migrationResult != null;
        return bl;
    }

    private static final Tuple3 errorToKey$1(ValidationResults.NodeValidationError error) {
        return new Tuple3((Object)error.fieldName(), (Object)error.errorType(), (Object)error.typ());
    }

    private static final List diffErrorLists$1(List before, List after) {
        Set errorsBefore = ((TraversableOnce)before.map((Function1 & Serializable & scala.Serializable)error -> TestModelMigrations.errorToKey$1(error), List$.MODULE$.canBuildFrom())).toSet();
        return (List)after.filterNot((Function1 & Serializable & scala.Serializable)error -> BoxesRunTime.boxToBoolean((boolean)errorsBefore.contains((Object)TestModelMigrations.errorToKey$1(error))));
    }

    public static final /* synthetic */ boolean $anonfun$extractNewErrors$5(Tuple2 x$7) {
        return ((SeqLike)x$7._2()).isEmpty();
    }

    private static final Map diffOnMap$1(Map before, Map after) {
        return (Map)((MapLike)after.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String nodeId = (String)tuple2._1();
            List errorsAfter = (List)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)nodeId, (Object)TestModelMigrations.diffErrorLists$1((List)before.getOrElse((Object)nodeId, (Function0 & Serializable & scala.Serializable)() -> List$.MODULE$.empty()), errorsAfter));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)TestModelMigrations.$anonfun$extractNewErrors$5(x$7)));
    }

    private static final List diffOnGlobalErrors$1(List before, List after) {
        Set errorsBefore = ((TraversableOnce)before.map((Function1 & Serializable & scala.Serializable)globalError -> TestModelMigrations.errorToKey$1(globalError.error()), List$.MODULE$.canBuildFrom())).toSet();
        return (List)after.filterNot((Function1 & Serializable & scala.Serializable)globalError -> BoxesRunTime.boxToBoolean((boolean)errorsBefore.contains((Object)TestModelMigrations.errorToKey$1(globalError.error()))));
    }

    public TestModelMigrations(ProcessingTypeDataProvider<ProcessModelMigrator, ?> migrators, ProcessingTypeDataProvider<UIProcessValidator, ?> processValidator) {
        this.migrators = migrators;
        this.processValidator = processValidator;
        LazyLogging.$init$((LazyLogging)this);
    }
}

