/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.process;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BoundedInputStream;
import pl.touk.nussknacker.engine.api.process.ProcessId;
import pl.touk.nussknacker.engine.api.process.VersionId;
import pl.touk.nussknacker.ui.config.AttachmentsConfig;
import pl.touk.nussknacker.ui.process.repository.ProcessActivityRepository;
import pl.touk.nussknacker.ui.security.api.LoggedUser;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Using;
import scala.util.Using$;

@ScalaSignature(bytes="\u0006\u0001\tUd\u0001B\u0015+\u0001UB\u0001B\u0012\u0001\u0003\u0002\u0003\u0006Ia\u0012\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\u001b\"A1\u000b\u0001B\u0001B\u0003-A\u000bC\u0003[\u0001\u0011\u00051\fC\u0003c\u0001\u0011\u00051\rC\u0004\u00028\u0001!\t!!\u000f\b\u000f\u0005m#\u0006#\u0001\u0002^\u00191\u0011F\u000bE\u0001\u0003?BaA\u0017\u0005\u0005\u0002\u0005\u0005TABA2\u0011\u0001\t)G\u0002\u0004\u0002x!\u0011\u0015\u0011\u0010\u0005\nm.\u0011)\u001a!C\u0001\u0003\u000fC\u0011\"!#\f\u0005#\u0005\u000b\u0011B<\t\u0015\u0005\u00051B!f\u0001\n\u0003\tY\t\u0003\u0006\u0002\u000e.\u0011\t\u0012)A\u0005\u0003\u0007A!\"a$\f\u0005+\u0007I\u0011AAI\u0011)\t\u0019j\u0003B\tB\u0003%\u0011Q\u0002\u0005\u000b\u0003+[!Q3A\u0005\u0002\u0005]\u0005BCAM\u0017\tE\t\u0015!\u0003\u0002l!1!l\u0003C\u0001\u00037C\u0011\"!+\f\u0003\u0003%\t!a+\t\u0013\u0005U6\"%A\u0005\u0002\u0005]\u0006\"CAg\u0017E\u0005I\u0011AAh\u0011%\t\u0019nCI\u0001\n\u0003\t)\u000eC\u0005\u0002Z.\t\n\u0011\"\u0001\u0002\\\"I\u0011q\\\u0006\u0002\u0002\u0013\u0005\u0013\u0011\u001d\u0005\n\u0003[\\\u0011\u0011!C\u0001\u0003_D\u0011\"a>\f\u0003\u0003%\t!!?\t\u0013\t\u00151\"!A\u0005B\t\u001d\u0001\"\u0003B\u000b\u0017\u0005\u0005I\u0011\u0001B\f\u0011%\u0011\tcCA\u0001\n\u0003\u0012\u0019\u0003C\u0005\u0003&-\t\t\u0011\"\u0011\u0003(!I!\u0011F\u0006\u0002\u0002\u0013\u0005#1F\u0004\n\u0005_A\u0011\u0011!E\u0001\u0005c1\u0011\"a\u001e\t\u0003\u0003E\tAa\r\t\ri\u001bC\u0011\u0001B!\u0011%\u0011)cIA\u0001\n\u000b\u00129\u0003C\u0005\u0003D\r\n\t\u0011\"!\u0003F!I!qJ\u0012\u0002\u0002\u0013\u0005%\u0011\u000b\u0005\n\u0005?\u001a\u0013\u0011!C\u0005\u0005C\u0012\u0011dU2f]\u0006\u0014\u0018n\\!ui\u0006\u001c\u0007.\\3oiN+'O^5dK*\u00111\u0006L\u0001\baJ|7-Z:t\u0015\tic&\u0001\u0002vS*\u0011q\u0006M\u0001\f]V\u001c8o\u001b8bG.,'O\u0003\u00022e\u0005!Ao\\;l\u0015\u0005\u0019\u0014A\u00019m\u0007\u0001\u00192\u0001\u0001\u001c=!\t9$(D\u00019\u0015\u0005I\u0014!B:dC2\f\u0017BA\u001e9\u0005\u0019\te.\u001f*fMB\u0011Q\bR\u0007\u0002})\u0011q\bQ\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003\u0003\n\u000b\u0001\u0002^=qKN\fg-\u001a\u0006\u0002\u0007\u0006\u00191m\\7\n\u0005\u0015s$a\u0003'bufdunZ4j]\u001e\faaY8oM&<\u0007C\u0001%K\u001b\u0005I%B\u0001$-\u0013\tY\u0015JA\tBiR\f7\r[7f]R\u001c8i\u001c8gS\u001e\f!d]2f]\u0006\u0014\u0018n\\!di&4\u0018\u000e^=SKB|7/\u001b;pef\u0004\"AT)\u000e\u0003=S!\u0001\u0015\u0016\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0002S\u001f\nI\u0002K]8dKN\u001c\u0018i\u0019;jm&$\u0018PU3q_NLGo\u001c:z\u0003\t)7\r\u0005\u0002V16\taK\u0003\u0002Xq\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005e3&\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0003\u0019a\u0014N\\5u}Q\u0019A\fY1\u0015\u0005u{\u0006C\u00010\u0001\u001b\u0005Q\u0003\"B*\u0005\u0001\b!\u0006\"\u0002$\u0005\u0001\u00049\u0005\"\u0002'\u0005\u0001\u0004i\u0015AD:bm\u0016\fE\u000f^1dQ6,g\u000e\u001e\u000b\bIV|\u0018\u0011BA\u0012)\t)7\u000eE\u0002VM\"L!a\u001a,\u0003\r\u0019+H/\u001e:f!\t9\u0014.\u0003\u0002kq\t!QK\\5u\u0011\u0015aW\u0001q\u0001n\u0003)awnZ4fIV\u001bXM\u001d\t\u0003]Nl\u0011a\u001c\u0006\u0003aF\f1!\u00199j\u0015\t\u0011H&\u0001\u0005tK\u000e,(/\u001b;z\u0013\t!xN\u0001\u0006M_\u001e<W\rZ+tKJDQA^\u0003A\u0002]\f!b]2f]\u0006\u0014\u0018n\\%e!\tAX0D\u0001z\u0015\tY#P\u0003\u0002qw*\u0011APL\u0001\u0007K:<\u0017N\\3\n\u0005yL(!\u0003)s_\u000e,7o]%e\u0011\u001d\t\t!\u0002a\u0001\u0003\u0007\t\u0011c]2f]\u0006\u0014\u0018n\u001c,feNLwN\\%e!\rA\u0018QA\u0005\u0004\u0003\u000fI(!\u0003,feNLwN\\%e\u0011\u001d\tY!\u0002a\u0001\u0003\u001b\t\u0001c\u001c:jO&t\u0017\r\u001c$jY\u0016t\u0015-\\3\u0011\t\u0005=\u0011Q\u0004\b\u0005\u0003#\tI\u0002E\u0002\u0002\u0014aj!!!\u0006\u000b\u0007\u0005]A'\u0001\u0004=e>|GOP\u0005\u0004\u00037A\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002 \u0005\u0005\"AB*ue&twMC\u0002\u0002\u001caBq!!\n\u0006\u0001\u0004\t9#A\u0006j]B,Ho\u0015;sK\u0006l\u0007\u0003BA\u0015\u0003gi!!a\u000b\u000b\t\u00055\u0012qF\u0001\u0003S>T!!!\r\u0002\t)\fg/Y\u0005\u0005\u0003k\tYCA\u0006J]B,Ho\u0015;sK\u0006l\u0017A\u0004:fC\u0012\fE\u000f^1dQ6,g\u000e\u001e\u000b\u0007\u0003w\u0011IGa\u001d\u0011\tU3\u0017Q\b\t\u0006o\u0005}\u00121I\u0005\u0004\u0003\u0003B$AB(qi&|g\u000eE\u0002\u0002F)q1!a\u0012\b\u001d\u0011\tI%!\u0017\u000f\t\u0005-\u0013q\u000b\b\u0005\u0003\u001b\n)F\u0004\u0003\u0002P\u0005Mc\u0002BA\n\u0003#J\u0011aM\u0005\u0003cIJ!a\f\u0019\n\u00055r\u0013BA\u0016-\u0003e\u00196-\u001a8be&|\u0017\t\u001e;bG\"lWM\u001c;TKJ4\u0018nY3\u0011\u0005yC1C\u0001\u00057)\t\tiF\u0001\fBiR\f7\r[7f]R$\u0015\r^1XSRDg*Y7f!\u001d9\u0014qMA\u0007\u0003WJ1!!\u001b9\u0005\u0019!V\u000f\u001d7feA)q'!\u001c\u0002r%\u0019\u0011q\u000e\u001d\u0003\u000b\u0005\u0013(/Y=\u0011\u0007]\n\u0019(C\u0002\u0002va\u0012AAQ=uK\ny\u0011\t\u001e;bG\"lWM\u001c;U_\u0006#Gm\u0005\u0004\fm\u0005m\u0014\u0011\u0011\t\u0004o\u0005u\u0014bAA@q\t9\u0001K]8ek\u000e$\bcA\u001c\u0002\u0004&\u0019\u0011Q\u0011\u001d\u0003\u0019M+'/[1mSj\f'\r\\3\u0016\u0003]\f1b]2f]\u0006\u0014\u0018n\\%eAU\u0011\u00111A\u0001\u0013g\u000e,g.\u0019:j_Z+'o]5p]&#\u0007%\u0001\u0005gS2,g*Y7f+\t\ti!A\u0005gS2,g*Y7fA\u0005!A-\u0019;b+\t\tY'A\u0003eCR\f\u0007\u0005\u0006\u0006\u0002\u001e\u0006\u0005\u00161UAS\u0003O\u00032!a(\f\u001b\u0005A\u0001\"\u0002<\u0015\u0001\u00049\bbBA\u0001)\u0001\u0007\u00111\u0001\u0005\b\u0003\u001f#\u0002\u0019AA\u0007\u0011\u001d\t)\n\u0006a\u0001\u0003W\nAaY8qsRQ\u0011QTAW\u0003_\u000b\t,a-\t\u000fY,\u0002\u0013!a\u0001o\"I\u0011\u0011A\u000b\u0011\u0002\u0003\u0007\u00111\u0001\u0005\n\u0003\u001f+\u0002\u0013!a\u0001\u0003\u001bA\u0011\"!&\u0016!\u0003\u0005\r!a\u001b\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u0018\u0016\u0004o\u0006m6FAA_!\u0011\ty,!3\u000e\u0005\u0005\u0005'\u0002BAb\u0003\u000b\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u001d\u0007(\u0001\u0006b]:|G/\u0019;j_:LA!a3\u0002B\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\u001b\u0016\u0005\u0003\u0007\tY,\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005]'\u0006BA\u0007\u0003w\u000babY8qs\u0012\"WMZ1vYR$C'\u0006\u0002\u0002^*\"\u00111NA^\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u001d\t\u0005\u0003K\fY/\u0004\u0002\u0002h*!\u0011\u0011^A\u0018\u0003\u0011a\u0017M\\4\n\t\u0005}\u0011q]\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003c\u00042aNAz\u0013\r\t)\u0010\u000f\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003w\u0014\t\u0001E\u00028\u0003{L1!a@9\u0005\r\te.\u001f\u0005\n\u0005\u0007a\u0012\u0011!a\u0001\u0003c\f1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B\u0005!\u0019\u0011YA!\u0005\u0002|6\u0011!Q\u0002\u0006\u0004\u0005\u001fA\u0014AC2pY2,7\r^5p]&!!1\u0003B\u0007\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\te!q\u0004\t\u0004o\tm\u0011b\u0001B\u000fq\t9!i\\8mK\u0006t\u0007\"\u0003B\u0002=\u0005\u0005\t\u0019AA~\u0003!A\u0017m\u001d5D_\u0012,GCAAy\u0003!!xn\u0015;sS:<GCAAr\u0003\u0019)\u0017/^1mgR!!\u0011\u0004B\u0017\u0011%\u0011\u0019!IA\u0001\u0002\u0004\tY0A\bBiR\f7\r[7f]R$v.\u00113e!\r\tyjI\n\u0006G\tU\u0012\u0011\u0011\t\u000e\u0005o\u0011id^A\u0002\u0003\u001b\tY'!(\u000e\u0005\te\"b\u0001B\u001eq\u00059!/\u001e8uS6,\u0017\u0002\u0002B \u0005s\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c85)\t\u0011\t$A\u0003baBd\u0017\u0010\u0006\u0006\u0002\u001e\n\u001d#\u0011\nB&\u0005\u001bBQA\u001e\u0014A\u0002]Dq!!\u0001'\u0001\u0004\t\u0019\u0001C\u0004\u0002\u0010\u001a\u0002\r!!\u0004\t\u000f\u0005Ue\u00051\u0001\u0002l\u00059QO\\1qa2LH\u0003\u0002B*\u00057\u0002RaNA \u0005+\u0002\"b\u000eB,o\u0006\r\u0011QBA6\u0013\r\u0011I\u0006\u000f\u0002\u0007)V\u0004H.\u001a\u001b\t\u0013\tus%!AA\u0002\u0005u\u0015a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011\u0019\u0007\u0005\u0003\u0002f\n\u0015\u0014\u0002\u0002B4\u0003O\u0014aa\u00142kK\u000e$\bb\u0002B6\r\u0001\u0007!QN\u0001\rCR$\u0018m\u00195nK:$\u0018\n\u001a\t\u0004o\t=\u0014b\u0001B9q\t!Aj\u001c8h\u0011\u00151h\u00011\u0001x\u0001")
public class ScenarioAttachmentService
implements LazyLogging {
    private final AttachmentsConfig config;
    private final ProcessActivityRepository scenarioActivityRepository;
    private final ExecutionContext ec;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        ScenarioAttachmentService scenarioAttachmentService = this;
        synchronized (scenarioAttachmentService) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public Future<BoxedUnit> saveAttachment(ProcessId scenarioId, VersionId scenarioVersionId, String originalFileName, InputStream inputStream, LoggedUser loggedUser) {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new BoundedInputStream(inputStream, $this.config.maxSizeInBytes() + 1L), this.ec).map((Function1 & Serializable & scala.Serializable)x$1 -> (byte[])Using$.MODULE$.resource(x$1, (Function1 & Serializable & scala.Serializable)isResource -> IOUtils.toByteArray((InputStream)isResource), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$), this.ec).flatMap((Function1 & Serializable & scala.Serializable)bytes -> (long)((byte[])bytes).length > $this.config.maxSizeInBytes() ? Future$.MODULE$.failed((Throwable)new IllegalArgumentException(new StringBuilder(42).append("Maximum (").append($this.config.maxSizeInBytes()).append(" bytes) attachment size exceeded.").toString())) : $this.scenarioActivityRepository.addAttachment(new AttachmentToAdd(scenarioId, scenarioVersionId, originalFileName, (byte[])bytes), $this.ec, loggedUser), this.ec);
    }

    public Future<Option<Tuple2<String, byte[]>>> readAttachment(long attachmentId, ProcessId scenarioId) {
        return this.scenarioActivityRepository.findAttachment(attachmentId, scenarioId, this.ec).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.map((Function1 & Serializable & scala.Serializable)attachment -> new Tuple2((Object)attachment.fileName(), (Object)attachment.data())), this.ec);
    }

    public ScenarioAttachmentService(AttachmentsConfig config, ProcessActivityRepository scenarioActivityRepository, ExecutionContext ec) {
        this.config = config;
        this.scenarioActivityRepository = scenarioActivityRepository;
        this.ec = ec;
        LazyLogging.$init$((LazyLogging)this);
    }

    public static final class AttachmentToAdd
    implements Product,
    scala.Serializable {
        private final ProcessId scenarioId;
        private final VersionId scenarioVersionId;
        private final String fileName;
        private final byte[] data;

        public ProcessId scenarioId() {
            return this.scenarioId;
        }

        public VersionId scenarioVersionId() {
            return this.scenarioVersionId;
        }

        public String fileName() {
            return this.fileName;
        }

        public byte[] data() {
            return this.data;
        }

        public AttachmentToAdd copy(ProcessId scenarioId, VersionId scenarioVersionId, String fileName, byte[] data) {
            return new AttachmentToAdd(scenarioId, scenarioVersionId, fileName, data);
        }

        public ProcessId copy$default$1() {
            return this.scenarioId();
        }

        public VersionId copy$default$2() {
            return this.scenarioVersionId();
        }

        public String copy$default$3() {
            return this.fileName();
        }

        public byte[] copy$default$4() {
            return this.data();
        }

        public String productPrefix() {
            return "AttachmentToAdd";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.scenarioId();
                    break;
                }
                case 1: {
                    object = this.scenarioVersionId();
                    break;
                }
                case 2: {
                    object = this.fileName();
                    break;
                }
                case 3: {
                    object = this.data();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof AttachmentToAdd;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof AttachmentToAdd)) return false;
            boolean bl = true;
            if (!bl) return false;
            AttachmentToAdd attachmentToAdd = (AttachmentToAdd)x$1;
            ProcessId processId = this.scenarioId();
            ProcessId processId2 = attachmentToAdd.scenarioId();
            if (processId == null) {
                if (processId2 != null) {
                    return false;
                }
            } else if (!processId.equals(processId2)) return false;
            VersionId versionId = this.scenarioVersionId();
            VersionId versionId2 = attachmentToAdd.scenarioVersionId();
            if (versionId == null) {
                if (versionId2 != null) {
                    return false;
                }
            } else if (!versionId.equals(versionId2)) return false;
            String string = this.fileName();
            String string2 = attachmentToAdd.fileName();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.data() != attachmentToAdd.data()) return false;
            return true;
        }

        public AttachmentToAdd(ProcessId scenarioId, VersionId scenarioVersionId, String fileName, byte[] data) {
            this.scenarioId = scenarioId;
            this.scenarioVersionId = scenarioVersionId;
            this.fileName = fileName;
            this.data = data;
            Product.$init$((Product)this);
        }
    }
}

