/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.process.newdeployment;

import cats.Applicative;
import cats.Functor;
import cats.Invariant$;
import cats.Monad;
import cats.data.EitherT;
import cats.data.EitherT$;
import db.util.DBIOActionInstances$;
import java.io.Serializable;
import java.sql.Timestamp;
import java.time.Clock;
import pl.touk.nussknacker.engine.api.deployment.DataFreshnessPolicy;
import pl.touk.nussknacker.engine.api.deployment.ProcessState;
import pl.touk.nussknacker.engine.api.process.ProcessIdWithName;
import pl.touk.nussknacker.engine.api.process.ProcessName;
import pl.touk.nussknacker.security.Permission$;
import pl.touk.nussknacker.ui.db.entity.ProcessEntityData;
import pl.touk.nussknacker.ui.process.deployment.CommonCommandData;
import pl.touk.nussknacker.ui.process.newdeployment.DeploymentCommand;
import pl.touk.nussknacker.ui.process.newdeployment.DeploymentEntityFactory;
import pl.touk.nussknacker.ui.process.newdeployment.DeploymentId;
import pl.touk.nussknacker.ui.process.newdeployment.DeploymentRepository;
import pl.touk.nussknacker.ui.process.newdeployment.DeploymentService$NoPermissionError$;
import pl.touk.nussknacker.ui.process.newdeployment.RunDeploymentCommand;
import pl.touk.nussknacker.ui.process.repository.CommentValidationError;
import pl.touk.nussknacker.ui.process.repository.DBIOActionRunner;
import pl.touk.nussknacker.ui.process.repository.ScenarioMetadataRepository;
import pl.touk.nussknacker.ui.security.api.LoggedUser;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.collection.Iterator;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import slick.dbio.DBIOAction;

@ScalaSignature(bytes="\u0006\u0001\u0011=e!B;w\u0001\u0005\u001d\u0001BCA\u000b\u0001\t\u0005\t\u0015!\u0003\u0002\u0018!Q\u00111\u0005\u0001\u0003\u0002\u0003\u0006I!!\n\t\u0015\u00055\u0002A!A!\u0002\u0013\ty\u0003\u0003\u0006\u0002:\u0001\u0011\t\u0011)A\u0005\u0003wA!\"!\u0011\u0001\u0005\u0003\u0005\u000b\u0011BA\"\u0011)\t\u0019\u0006\u0001B\u0001B\u0003-\u0011Q\u000b\u0005\b\u0003C\u0002A\u0011AA2\u0011\u001d\t)\b\u0001C\u0001\u0003oBqaa\u001c\u0001\t\u0003\u0019\t\bC\u0004\u0004,\u0002!Ia!,\t\u000f\r]\u0006\u0001\"\u0003\u0004:\"911 \u0001\u0005\n\ru\bb\u0002C\u0005\u0001\u0011%A1\u0002\u0005\b\t'\u0001A\u0011\u0002C\u000b\u0011\u001d!i\u0003\u0001C\u0005\t_Aq\u0001b\u001f\u0001\t\u0013!ihB\u0004\u00024ZD\t!!.\u0007\rU4\b\u0012AA\\\u0011\u001d\t\tG\u0005C\u0001\u0003s3\u0011\"a/\u0013!\u0003\r\n#!0\u0007\u0013\t=%\u0003%A\u0012\"\tEeABAa%\t\u000b\u0019\r\u0003\u0006\u0002VZ\u0011)\u001a!C\u0001\u0003/D!\"a8\u0017\u0005#\u0005\u000b\u0011BAm\u0011\u001d\t\tG\u0006C\u0001\u0003CD\u0011\"a:\u0017\u0003\u0003%\t!!;\t\u0013\u00055h#%A\u0005\u0002\u0005=\b\"\u0003B\u0003-\u0005\u0005I\u0011\tB\u0004\u0011%\u0011)BFA\u0001\n\u0003\u00119\u0002C\u0005\u0003 Y\t\t\u0011\"\u0001\u0003\"!I!Q\u0006\f\u0002\u0002\u0013\u0005#q\u0006\u0005\n\u0005{1\u0012\u0011!C\u0001\u0005\u007fA\u0011B!\u0013\u0017\u0003\u0003%\tEa\u0013\t\u0013\t5c#!A\u0005B\t=\u0003\"\u0003B)-\u0005\u0005I\u0011\tB*\u000f%\u0011YPEA\u0001\u0012\u0003\u0011iPB\u0005\u0002BJ\t\t\u0011#\u0001\u0003\u0000\"9\u0011\u0011M\u0013\u0005\u0002\r5\u0001\"\u0003B'K\u0005\u0005IQ\tB(\u0011%\u0019y!JA\u0001\n\u0003\u001b\t\u0002C\u0005\u0004\u0016\u0015\n\t\u0011\"!\u0004\u0018!I!1X\u0013\u0002\u0002\u0013%!Q\u0018\u0004\u0007\u0005\u000b\u0014\"Ia2\t\u0015\t%7F!f\u0001\n\u0003\u0011Y\r\u0003\u0006\u0003`.\u0012\t\u0012)A\u0005\u0005\u001bDq!!\u0019,\t\u0003\u0011\t\u000fC\u0005\u0002h.\n\t\u0011\"\u0001\u0003h\"I\u0011Q^\u0016\u0012\u0002\u0013\u0005!1\u001e\u0005\n\u0005\u000bY\u0013\u0011!C!\u0005\u000fA\u0011B!\u0006,\u0003\u0003%\tAa\u0006\t\u0013\t}1&!A\u0005\u0002\t=\b\"\u0003B\u0017W\u0005\u0005I\u0011\tB\u0018\u0011%\u0011idKA\u0001\n\u0003\u0011\u0019\u0010C\u0005\u0003J-\n\t\u0011\"\u0011\u0003L!I!QJ\u0016\u0002\u0002\u0013\u0005#q\n\u0005\n\u0005#Z\u0013\u0011!C!\u0005o<\u0011ba\t\u0013\u0003\u0003E\ta!\n\u0007\u0013\t\u0015'#!A\t\u0002\r\u001d\u0002bBA1u\u0011\u000511\u0006\u0005\n\u0005\u001bR\u0014\u0011!C#\u0005\u001fB\u0011ba\u0004;\u0003\u0003%\ti!\f\t\u0013\rU!(!A\u0005\u0002\u000eE\u0002\"\u0003B^u\u0005\u0005I\u0011\u0002B_\r\u0019\u0011)J\u0005\"\u0003\u0018\"Q\u0011Q\u001b!\u0003\u0016\u0004%\t!a6\t\u0015\u0005}\u0007I!E!\u0002\u0013\tI\u000eC\u0004\u0002b\u0001#\tA!'\t\u0013\u0005\u001d\b)!A\u0005\u0002\t}\u0005\"CAw\u0001F\u0005I\u0011AAx\u0011%\u0011)\u0001QA\u0001\n\u0003\u00129\u0001C\u0005\u0003\u0016\u0001\u000b\t\u0011\"\u0001\u0003\u0018!I!q\u0004!\u0002\u0002\u0013\u0005!1\u0015\u0005\n\u0005[\u0001\u0015\u0011!C!\u0005_A\u0011B!\u0010A\u0003\u0003%\tAa*\t\u0013\t%\u0003)!A\u0005B\t-\u0003\"\u0003B'\u0001\u0006\u0005I\u0011\tB(\u0011%\u0011\t\u0006QA\u0001\n\u0003\u0012YkB\u0005\u00048I\t\t\u0011#\u0001\u0004:\u0019I!Q\u0013\n\u0002\u0002#\u000511\b\u0005\b\u0003CzE\u0011AB \u0011%\u0011ieTA\u0001\n\u000b\u0012y\u0005C\u0005\u0004\u0010=\u000b\t\u0011\"!\u0004B!I1QC(\u0002\u0002\u0013\u00055Q\t\u0005\n\u0005w{\u0015\u0011!C\u0005\u0005{;qa!\u0013\u0013\u0011\u0003\u0013\tLB\u0004\u0003\nJA\tIa#\t\u000f\u0005\u0005d\u000b\"\u0001\u00030\"I!Q\u0001,\u0002\u0002\u0013\u0005#q\u0001\u0005\n\u0005+1\u0016\u0011!C\u0001\u0005/A\u0011Ba\bW\u0003\u0003%\tAa-\t\u0013\t5b+!A\u0005B\t=\u0002\"\u0003B\u001f-\u0006\u0005I\u0011\u0001B\\\u0011%\u0011IEVA\u0001\n\u0003\u0012Y\u0005C\u0005\u0003NY\u000b\t\u0011\"\u0011\u0003P!I!1\u0018,\u0002\u0002\u0013%!Q\u0018\u0004\u0007\u0005/\u0012\"I!\u0017\t\u0015\tm\u0003M!f\u0001\n\u0003\u0011i\u0006\u0003\u0006\u0003n\u0001\u0014\t\u0012)A\u0005\u0005?Bq!!\u0019a\t\u0003\u0011y\u0007C\u0005\u0002h\u0002\f\t\u0011\"\u0001\u0003v!I\u0011Q\u001e1\u0012\u0002\u0013\u0005!\u0011\u0010\u0005\n\u0005\u000b\u0001\u0017\u0011!C!\u0005\u000fA\u0011B!\u0006a\u0003\u0003%\tAa\u0006\t\u0013\t}\u0001-!A\u0005\u0002\tu\u0004\"\u0003B\u0017A\u0006\u0005I\u0011\tB\u0018\u0011%\u0011i\u0004YA\u0001\n\u0003\u0011\t\tC\u0005\u0003J\u0001\f\t\u0011\"\u0011\u0003L!I!Q\n1\u0002\u0002\u0013\u0005#q\n\u0005\n\u0005#\u0002\u0017\u0011!C!\u0005\u000b;\u0011ba\u0013\u0013\u0003\u0003E\ta!\u0014\u0007\u0013\t]##!A\t\u0002\r=\u0003bBA1_\u0012\u000511\u000b\u0005\n\u0005\u001bz\u0017\u0011!C#\u0005\u001fB\u0011ba\u0004p\u0003\u0003%\ti!\u0016\t\u0013\rUq.!A\u0005\u0002\u000ee\u0003\"\u0003B^_\u0006\u0005I\u0011\u0002B_\u0005E!U\r\u001d7ps6,g\u000e^*feZL7-\u001a\u0006\u0003ob\fQB\\3xI\u0016\u0004Hn\\=nK:$(BA={\u0003\u001d\u0001(o\\2fgNT!a\u001f?\u0002\u0005UL'BA?\u007f\u0003-qWo]:l]\u0006\u001c7.\u001a:\u000b\u0007}\f\t!\u0001\u0003u_V\\'BAA\u0002\u0003\t\u0001Hn\u0001\u0001\u0014\u0007\u0001\tI\u0001\u0005\u0003\u0002\f\u0005EQBAA\u0007\u0015\t\ty!A\u0003tG\u0006d\u0017-\u0003\u0003\u0002\u0014\u00055!AB!osJ+g-\u0001\u000etG\u0016t\u0017M]5p\u001b\u0016$\u0018\rZ1uCJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0003\u0002\u001a\u0005}QBAA\u000e\u0015\r\ti\u0002_\u0001\u000be\u0016\u0004xn]5u_JL\u0018\u0002BA\u0011\u00037\u0011!dU2f]\u0006\u0014\u0018n\\'fi\u0006$\u0017\r^1SKB|7/\u001b;pef\fA\u0003Z3qY>LX.\u001a8u%\u0016\u0004xn]5u_JL\b\u0003BA\u0014\u0003Si\u0011A^\u0005\u0004\u0003W1(\u0001\u0006#fa2|\u00170\\3oiJ+\u0007o\\:ji>\u0014\u00180A\fmK\u001e\f7-\u001f#fa2|\u00170\\3oiN+'O^5dKB!\u0011\u0011GA\u001c\u001b\t\t\u0019DC\u0002\u00026a\f!\u0002Z3qY>LX.\u001a8u\u0013\r)\u00181G\u0001\u000bI\nLwNU;o]\u0016\u0014\b\u0003BA\r\u0003{IA!a\u0010\u0002\u001c\t\u0001BIQ%P\u0003\u000e$\u0018n\u001c8Sk:tWM]\u0001\u0006G2|7m\u001b\t\u0005\u0003\u000b\ny%\u0004\u0002\u0002H)!\u0011\u0011JA&\u0003\u0011!\u0018.\\3\u000b\u0005\u00055\u0013\u0001\u00026bm\u0006LA!!\u0015\u0002H\t)1\t\\8dW\u0006\u0011Qm\u0019\t\u0005\u0003/\ni&\u0004\u0002\u0002Z)!\u00111LA\u0007\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003?\nIF\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u00061A(\u001b8jiz\"B\"!\u001a\u0002l\u00055\u0014qNA9\u0003g\"B!a\u001a\u0002jA\u0019\u0011q\u0005\u0001\t\u000f\u0005Ms\u0001q\u0001\u0002V!9\u0011QC\u0004A\u0002\u0005]\u0001bBA\u0012\u000f\u0001\u0007\u0011Q\u0005\u0005\b\u0003[9\u0001\u0019AA\u0018\u0011\u001d\tId\u0002a\u0001\u0003wAq!!\u0011\b\u0001\u0004\t\u0019%\u0001\bqe>\u001cWm]:D_6l\u0017M\u001c3\u0015\t\u0005e4Q\r\t\u0007\u0003/\nY(a \n\t\u0005u\u0014\u0011\f\u0002\u0007\rV$XO]3\u0011\u0011\u0005\u0005\u0015\u0011SAL\u0007?rA!a!\u0002\u000e:!\u0011QQAF\u001b\t\t9I\u0003\u0003\u0002\n\u0006\u0015\u0011A\u0002\u001fs_>$h(\u0003\u0002\u0002\u0010%!\u0011qRA\u0007\u0003\u001d\u0001\u0018mY6bO\u0016LA!a%\u0002\u0016\n1Q)\u001b;iKJTA!a$\u0002\u000eA\u0019\u0011\u0011\u0014\u000b\u000f\u0007\u0005m\u0015C\u0004\u0003\u0002\u001e\u0006Ef\u0002BAP\u0003_sA!!)\u0002.:!\u00111UAV\u001d\u0011\t)+!+\u000f\t\u0005\u0015\u0015qU\u0005\u0003\u0003\u0007I1a`A\u0001\u0013\tih0\u0003\u0002|y&\u0011\u0011P_\u0005\u0003ob\f\u0011\u0003R3qY>LX.\u001a8u'\u0016\u0014h/[2f!\r\t9CE\n\u0004%\u0005%ACAA[\u0005I\u0011VO\u001c#fa2|\u00170\\3oi\u0016\u0013(o\u001c:\u0014\u0007Q\tI!K\u0003\u0015-\u000146F\u0001\u000fD_:4G.[2uS:<G)\u001a9m_flWM\u001c;JI\u0016\u0013(o\u001c:\u0014\u0013Y\tI!!2\u0002J\u0006=\u0007cAAd)5\t!\u0003\u0005\u0003\u0002\f\u0005-\u0017\u0002BAg\u0003\u001b\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0003\u0002\f\u0005E\u0017\u0002BAj\u0003\u001b\u0011AbU3sS\u0006d\u0017N_1cY\u0016\f!!\u001b3\u0016\u0005\u0005e\u0007\u0003BA\u0014\u00037L1!!8w\u00051!U\r\u001d7ps6,g\u000e^%e\u0003\rIG\r\t\u000b\u0005\u0003G\f)\u000fE\u0002\u0002HZAq!!6\u001a\u0001\u0004\tI.\u0001\u0003d_BLH\u0003BAr\u0003WD\u0011\"!6\u001b!\u0003\u0005\r!!7\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u001f\u0016\u0005\u00033\f\u0019p\u000b\u0002\u0002vB!\u0011q\u001fB\u0001\u001b\t\tIP\u0003\u0003\u0002|\u0006u\u0018!C;oG\",7m[3e\u0015\u0011\ty0!\u0004\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\u0004\u0005e(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"A!\u0003\u0011\t\t-!\u0011C\u0007\u0003\u0005\u001bQAAa\u0004\u0002L\u0005!A.\u00198h\u0013\u0011\u0011\u0019B!\u0004\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\u0011I\u0002\u0005\u0003\u0002\f\tm\u0011\u0002\u0002B\u000f\u0003\u001b\u00111!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$BAa\t\u0003*A!\u00111\u0002B\u0013\u0013\u0011\u00119#!\u0004\u0003\u0007\u0005s\u0017\u0010C\u0005\u0003,y\t\t\u00111\u0001\u0003\u001a\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"A!\r\u0011\r\tM\"\u0011\bB\u0012\u001b\t\u0011)D\u0003\u0003\u00038\u00055\u0011AC2pY2,7\r^5p]&!!1\bB\u001b\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\t\u0005#q\t\t\u0005\u0003\u0017\u0011\u0019%\u0003\u0003\u0003F\u00055!a\u0002\"p_2,\u0017M\u001c\u0005\n\u0005W\u0001\u0013\u0011!a\u0001\u0005G\t\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u00053\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005\u0013\ta!Z9vC2\u001cH\u0003\u0002B!\u0005+B\u0011Ba\u000b$\u0003\u0003\u0005\rAa\t\u000339+woQ8n[\u0016tGOV1mS\u0012\fG/[8o\u000bJ\u0014xN]\n\nA\u0006%\u0011QYAe\u0003\u001f\fq!\\3tg\u0006<W-\u0006\u0002\u0003`A!!\u0011\rB5\u001d\u0011\u0011\u0019G!\u001a\u0011\t\u0005\u0015\u0015QB\u0005\u0005\u0005O\ni!\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005'\u0011YG\u0003\u0003\u0003h\u00055\u0011\u0001C7fgN\fw-\u001a\u0011\u0015\t\tE$1\u000f\t\u0004\u0003\u000f\u0004\u0007b\u0002B.G\u0002\u0007!q\f\u000b\u0005\u0005c\u00129\bC\u0005\u0003\\\u0011\u0004\n\u00111\u0001\u0003`U\u0011!1\u0010\u0016\u0005\u0005?\n\u0019\u0010\u0006\u0003\u0003$\t}\u0004\"\u0003B\u0016Q\u0006\u0005\t\u0019\u0001B\r)\u0011\u0011\tEa!\t\u0013\t-\".!AA\u0002\t\rB\u0003\u0002B!\u0005\u000fC\u0011Ba\u000bn\u0003\u0003\u0005\rAa\t\u0003#9{\u0007+\u001a:nSN\u001c\u0018n\u001c8FeJ|'oE\u0006W\u0003\u0013\t)M!$\u0002J\u0006=\u0007cAAd+\tAr)\u001a;EKBdw._7f]R\u001cF/\u0019;vg\u0016\u0013(o\u001c:\u0014\u0007U\tI!K\u0002\u0016\u0001Z\u0013q\u0003R3qY>LX.\u001a8u\u001d>$hi\\;oI\u0016\u0013(o\u001c:\u0014\u0013\u0001\u000bIA!$\u0002J\u0006=G\u0003\u0002BN\u0005;\u00032!a2A\u0011\u001d\t)n\u0011a\u0001\u00033$BAa'\u0003\"\"I\u0011Q\u001b#\u0011\u0002\u0003\u0007\u0011\u0011\u001c\u000b\u0005\u0005G\u0011)\u000bC\u0005\u0003,!\u000b\t\u00111\u0001\u0003\u001aQ!!\u0011\tBU\u0011%\u0011YCSA\u0001\u0002\u0004\u0011\u0019\u0003\u0006\u0003\u0003B\t5\u0006\"\u0003B\u0016\u001b\u0006\u0005\t\u0019\u0001B\u0012)\t\u0011\t\fE\u0002\u0002HZ#BAa\t\u00036\"I!1\u0006.\u0002\u0002\u0003\u0007!\u0011\u0004\u000b\u0005\u0005\u0003\u0012I\fC\u0005\u0003,q\u000b\t\u00111\u0001\u0003$\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011y\f\u0005\u0003\u0003\f\t\u0005\u0017\u0002\u0002Bb\u0005\u001b\u0011aa\u00142kK\u000e$(!F*dK:\f'/[8O_R4u.\u001e8e\u000bJ\u0014xN]\n\nW\u0005%\u0011QYAe\u0003\u001f\fAb]2f]\u0006\u0014\u0018n\u001c(b[\u0016,\"A!4\u0011\t\t='1\\\u0007\u0003\u0005#T1!\u001fBj\u0015\u0011\u0011)Na6\u0002\u0007\u0005\u0004\u0018NC\u0002\u0003Zr\fa!\u001a8hS:,\u0017\u0002\u0002Bo\u0005#\u00141\u0002\u0015:pG\u0016\u001c8OT1nK\u0006i1oY3oCJLwNT1nK\u0002\"BAa9\u0003fB\u0019\u0011qY\u0016\t\u000f\t%g\u00061\u0001\u0003NR!!1\u001dBu\u0011%\u0011Im\fI\u0001\u0002\u0004\u0011i-\u0006\u0002\u0003n*\"!QZAz)\u0011\u0011\u0019C!=\t\u0013\t-2'!AA\u0002\teA\u0003\u0002B!\u0005kD\u0011Ba\u000b6\u0003\u0003\u0005\rAa\t\u0015\t\t\u0005#\u0011 \u0005\n\u0005WA\u0014\u0011!a\u0001\u0005G\tAdQ8oM2L7\r^5oO\u0012+\u0007\u000f\\8z[\u0016tG/\u00133FeJ|'\u000fE\u0002\u0002H\u0016\u001aR!JB\u0001\u0003\u001f\u0004\u0002ba\u0001\u0004\n\u0005e\u00171]\u0007\u0003\u0007\u000bQAaa\u0002\u0002\u000e\u00059!/\u001e8uS6,\u0017\u0002BB\u0006\u0007\u000b\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c82)\t\u0011i0A\u0003baBd\u0017\u0010\u0006\u0003\u0002d\u000eM\u0001bBAkQ\u0001\u0007\u0011\u0011\\\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0019Iba\b\u0011\r\u0005-11DAm\u0013\u0011\u0019i\"!\u0004\u0003\r=\u0003H/[8o\u0011%\u0019\t#KA\u0001\u0002\u0004\t\u0019/A\u0002yIA\nQcU2f]\u0006\u0014\u0018n\u001c(pi\u001a{WO\u001c3FeJ|'\u000fE\u0002\u0002Hj\u001aRAOB\u0015\u0003\u001f\u0004\u0002ba\u0001\u0004\n\t5'1\u001d\u000b\u0003\u0007K!BAa9\u00040!9!\u0011Z\u001fA\u0002\t5G\u0003BB\u001a\u0007k\u0001b!a\u0003\u0004\u001c\t5\u0007\"CB\u0011}\u0005\u0005\t\u0019\u0001Br\u0003]!U\r\u001d7ps6,g\u000e\u001e(pi\u001a{WO\u001c3FeJ|'\u000fE\u0002\u0002H>\u001bRaTB\u001f\u0003\u001f\u0004\u0002ba\u0001\u0004\n\u0005e'1\u0014\u000b\u0003\u0007s!BAa'\u0004D!9\u0011Q\u001b*A\u0002\u0005eG\u0003BB\r\u0007\u000fB\u0011b!\tT\u0003\u0003\u0005\rAa'\u0002#9{\u0007+\u001a:nSN\u001c\u0018n\u001c8FeJ|'/A\rOK^\u001cu.\\7f]R4\u0016\r\\5eCRLwN\\#se>\u0014\bcAAd_N)qn!\u0015\u0002PBA11AB\u0005\u0005?\u0012\t\b\u0006\u0002\u0004NQ!!\u0011OB,\u0011\u001d\u0011YF\u001da\u0001\u0005?\"Baa\u0017\u0004^A1\u00111BB\u000e\u0005?B\u0011b!\tt\u0003\u0003\u0005\rA!\u001d\u0011\t\u0005-1\u0011M\u0005\u0005\u0007G\niA\u0001\u0003V]&$\bbBB4\u0011\u0001\u00071\u0011N\u0001\bG>lW.\u00198e!\u0011\t9ca\u001b\n\u0007\r5dOA\tEKBdw._7f]R\u001cu.\\7b]\u0012\f1cZ3u\t\u0016\u0004Hn\\=nK:$8\u000b^1ukN$Baa\u001d\u0004*R!1QOBL!\u0019\t9&a\u001f\u0004xAA\u0011\u0011QAI\u0007s\u001aY\bE\u0002\u0002\u001aV\u0001Ba! \u0004\u0012:!1qPBF\u001d\u0011\u0019\ti!#\u000f\t\r\r5q\u0011\b\u0005\u0003C\u001b))C\u0002\u0003ZrLAA!6\u0003X&!\u0011Q\u0007Bj\u0013\u0011\u0019iia$\u0002\u0017M#\u0018\r^3Ti\u0006$Xo\u001d\u0006\u0005\u0003k\u0011\u0019.\u0003\u0003\u0004\u0014\u000eU%AC*uCR,8OT1nK*!1QRBH\u0011\u001d\u0019I*\u0003a\u0002\u00077\u000b!\u0002\\8hO\u0016$Wk]3s!\u0011\u0019ij!*\u000e\u0005\r}%\u0002\u0002Bk\u0007CS1aa){\u0003!\u0019XmY;sSRL\u0018\u0002BBT\u0007?\u0013!\u0002T8hO\u0016$Wk]3s\u0011\u001d\t).\u0003a\u0001\u00033\fQB];o\t\u0016\u0004Hn\\=nK:$H\u0003BA=\u0007_Cqaa\u001a\u000b\u0001\u0004\u0019\t\f\u0005\u0003\u0002(\rM\u0016bAB[m\n!\"+\u001e8EKBdw._7f]R\u001cu.\\7b]\u0012\f1cZ3u'\u000e,g.\u0019:j_6+G/\u00193bi\u0006$Baa/\u0004zBQ1QXBd\u0007\u0017\u001cIoa;\u000e\u0005\r}&\u0002BBa\u0007\u0007\fA\u0001Z1uC*\u00111QY\u0001\u0005G\u0006$8/\u0003\u0003\u0004J\u000e}&aB#ji\",'\u000f\u0016\t\u0005\u0007\u001b\u001c\u0019O\u0004\u0003\u0004P\u000eug\u0002BBi\u0007/tA!!\"\u0004T&\u00111Q[\u0001\u0003I\nLAa!7\u0004\\\u0006!Q\u000f^5m\u0015\t\u0019).\u0003\u0003\u0004`\u000e\u0005\u0018a\u0005#C\u0013>\u000b5\r^5p]&s7\u000f^1oG\u0016\u001c(\u0002BBm\u00077LAa!:\u0004h\n\u0011AI\u0011\u0006\u0005\u0007?\u001c\t\u000fE\u0002\u0002\u001a.\u0002Ba!<\u0004v6\u00111q\u001e\u0006\u0005\u0007c\u001c\u00190\u0001\u0004f]RLG/\u001f\u0006\u0004\u0007+T\u0018\u0002BB|\u0007_\u0014\u0011\u0003\u0015:pG\u0016\u001c8/\u00128uSRLH)\u0019;b\u0011\u001d\u00199g\u0003a\u0001\u0007c\u000bab]1wK\u0012+\u0007\u000f\\8z[\u0016tG\u000f\u0006\u0004\u0004\u0000\u0012\rAQ\u0001\t\u000b\u0007{\u001b9ma3\u0005\u0002\r}\u0003cAAM-!91q\r\u0007A\u0002\rE\u0006b\u0002C\u0004\u0019\u0001\u000711^\u0001\u0011g\u000e,g.\u0019:j_6+G/\u00193bi\u0006\fa$\u001b8w_.,G*Z4bGf\u0014VO\u001c#fa2|\u00170\\3oi2{w-[2\u0015\r\u00115Aq\u0002C\t!)\u0019ila2\u0004L\u0006]5q\f\u0005\b\u0007Oj\u0001\u0019ABY\u0011\u001d!9!\u0004a\u0001\u0007W\f\u0011cZ3u\t\u0016\u0004Hn\\=nK:$()_%e)\u0011!9\u0002b\u000b\u0011\u0015\ru6q\u0019C\r\t7!i\u0002\u0005\u0003\u0002X\u0005m\u0004cAAM\u0001B!Aq\u0004C\u0013\u001d\u0011\tY\n\"\t\n\u0007\u0011\rb/\u0001\u000bEKBdw._7f]R\u0014V\r]8tSR|'/_\u0005\u0005\tO!IC\u0001\u0010EKBdw._7f]R<\u0016\u000e\u001e5TG\u0016t\u0017M]5p\u001b\u0016$\u0018\rZ1uC*\u0019A1\u0005<\t\u000f\u0005Ug\u00021\u0001\u0002Z\u0006y1\r[3dWB+'/\\5tg&|g.\u0006\u0003\u00052\u0011mB\u0003\u0003C\u001a\t7\"y\u0006b\u0019\u0015\t\u0011UBq\n\t\u000b\u0007{\u001b9\rb\u000e\u0005N\r}\u0003\u0003\u0002C\u001d\twa\u0001\u0001B\u0004\u0005>=\u0011\r\u0001b\u0010\u0003\u0003\u0019+B\u0001\"\u0011\u0005JE!A1\tB\u0012!\u0011\tY\u0001\"\u0012\n\t\u0011\u001d\u0013Q\u0002\u0002\b\u001d>$\b.\u001b8h\t!!Y\u0005b\u000fC\u0002\u0011\u0005#!A0\u000f\u0007\u0005eU\u000bC\u0005\u0005R=\t\t\u0011q\u0001\u0005T\u0005QQM^5eK:\u001cW\rJ\u0019\u0011\r\u0011UCq\u000bC\u001c\u001b\t\u0019\u0019-\u0003\u0003\u0005Z\r\r'aC!qa2L7-\u0019;jm\u0016Dq\u0001\"\u0018\u0010\u0001\u0004\u0019Y*\u0001\u0003vg\u0016\u0014\bb\u0002C1\u001f\u0001\u0007!qL\u0001\tG\u0006$XmZ8ss\"9AQM\bA\u0002\u0011\u001d\u0014A\u00039fe6L7o]5p]B!A\u0011\u000eC;\u001d\u0011!Y\u0007b\u001c\u000f\t\u0005\u0005FQN\u0005\u0004\u0007Gc\u0018\u0002\u0002C9\tg\n!\u0002U3s[&\u001c8/[8o\u0015\r\u0019\u0019\u000b`\u0005\u0005\to\"IH\u0001\u0006QKJl\u0017n]:j_:TA\u0001\"\u001d\u0005t\u0005\tr-\u001a;TG\u0016t\u0017M]5p'R\fG/^:\u0015\t\u0011}DQ\u0012\u000b\u0005\t\u0003#Y\t\u0005\u0006\u0004>\u000e\u001dG\u0011DB=\t\u0007\u0003B\u0001\"\"\u0005\b6\u00111qR\u0005\u0005\t\u0013\u001byI\u0001\u0007Qe>\u001cWm]:Ti\u0006$X\rC\u0004\u0004\u001aB\u0001\u001daa'\t\u000f\u0011\u001d\u0001\u00031\u0001\u0004l\u0002")
public class DeploymentService {
    private final ScenarioMetadataRepository scenarioMetadataRepository;
    private final DeploymentRepository deploymentRepository;
    private final pl.touk.nussknacker.ui.process.deployment.DeploymentService legacyDeploymentService;
    private final DBIOActionRunner dbioRunner;
    private final Clock clock;
    private final ExecutionContext ec;

    public Future<Either<RunDeploymentError, BoxedUnit>> processCommand(DeploymentCommand command) {
        DeploymentCommand deploymentCommand = command;
        if (!(deploymentCommand instanceof RunDeploymentCommand)) {
            throw new MatchError((Object)deploymentCommand);
        }
        RunDeploymentCommand runDeploymentCommand = (RunDeploymentCommand)deploymentCommand;
        Future<Either<RunDeploymentError, BoxedUnit>> future = this.runDeployment(runDeploymentCommand);
        return future;
    }

    public Future<Either<GetDeploymentStatusError, String>> getDeploymentStatus(DeploymentId id, LoggedUser loggedUser) {
        return (Future)this.getDeploymentById(id).flatMap((Function1 & Serializable & scala.Serializable)deploymentWithScenarioMetadata -> this.checkPermission(loggedUser, deploymentWithScenarioMetadata.scenarioMetadata().processCategory(), Permission$.MODULE$.Read(), (Applicative)Invariant$.MODULE$.catsInstancesForFuture($this.ec)).flatMap((Function1 & Serializable & scala.Serializable)_ -> this.getScenarioStatus(deploymentWithScenarioMetadata.scenarioMetadata(), loggedUser).map((Function1 & Serializable & scala.Serializable)scenarioState -> scenarioState.status().name(), (Functor)Invariant$.MODULE$.catsInstancesForFuture($this.ec)), (Monad)Invariant$.MODULE$.catsInstancesForFuture($this.ec)), (Monad)Invariant$.MODULE$.catsInstancesForFuture(this.ec)).value();
    }

    private Future<Either<RunDeploymentError, BoxedUnit>> runDeployment(RunDeploymentCommand command) {
        return this.dbioRunner.run((DBIOAction)this.getScenarioMetadata(command).flatMap((Function1 & Serializable & scala.Serializable)scenarioMetadata -> this.checkPermission(command.user(), scenarioMetadata.processCategory(), Permission$.MODULE$.Deploy(), (Applicative)DBIOActionInstances$.MODULE$.dbMonad($this.ec)).flatMap((Function1 & Serializable & scala.Serializable)_2 -> this.saveDeployment(command, (ProcessEntityData)scenarioMetadata).flatMap((Function1 & Serializable & scala.Serializable)_ -> this.invokeLegacyRunDeploymentLogic(command, (ProcessEntityData)scenarioMetadata).map((Function1 & Serializable & scala.Serializable)runResult -> {
            DeploymentService.$anonfun$runDeployment$4(runResult);
            return BoxedUnit.UNIT;
        }, DBIOActionInstances$.MODULE$.dbMonad($this.ec)), DBIOActionInstances$.MODULE$.dbMonad($this.ec)), DBIOActionInstances$.MODULE$.dbMonad($this.ec)), DBIOActionInstances$.MODULE$.dbMonad(this.ec)).value());
    }

    private EitherT<DBIOAction, ScenarioNotFoundError, ProcessEntityData> getScenarioMetadata(RunDeploymentCommand command) {
        return EitherT$.MODULE$.fromOptionF(this.scenarioMetadataRepository.getScenarioMetadata(command.scenarioName()), (Function0 & Serializable & scala.Serializable)() -> new ScenarioNotFoundError(command.scenarioName()), DBIOActionInstances$.MODULE$.dbMonad(this.ec));
    }

    private EitherT<DBIOAction, ConflictingDeploymentIdError, BoxedUnit> saveDeployment(RunDeploymentCommand command, ProcessEntityData scenarioMetadata) {
        return new EitherT(this.deploymentRepository.saveDeployment(new DeploymentEntityFactory.DeploymentEntityData(command.id(), scenarioMetadata.id(), Timestamp.from(this.clock.instant()), command.user().id()))).leftMap((Function1 & Serializable & scala.Serializable)e -> new ConflictingDeploymentIdError(e.id()), DBIOActionInstances$.MODULE$.dbMonad(this.ec));
    }

    private EitherT<DBIOAction, RunDeploymentError, BoxedUnit> invokeLegacyRunDeploymentLogic(RunDeploymentCommand command, ProcessEntityData scenarioMetadata) {
        return new EitherT((Object)DBIOActionInstances$.MODULE$.DB().from(this.legacyDeploymentService.processCommand(new pl.touk.nussknacker.ui.process.deployment.RunDeploymentCommand(new CommonCommandData(new ProcessIdWithName(scenarioMetadata.id(), command.scenarioName()), command.comment(), command.user()), (Option<String>)None$.MODULE$, command.nodesDeploymentData())).transform((Function1 & Serializable & scala.Serializable)result -> result.map((Function1 & Serializable & scala.Serializable)x$1 -> package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)).recover((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof CommentValidationError) {
                    CommentValidationError commentValidationError = (CommentValidationError)A1;
                    String msg = commentValidationError.message();
                    object = package$.MODULE$.Left().apply((Object)new NewCommentValidationError(msg));
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof CommentValidationError;
                return bl;
            }
        }), this.ec)));
    }

    private EitherT<Future, DeploymentNotFoundError, DeploymentRepository.DeploymentWithScenarioMetadata> getDeploymentById(DeploymentId id) {
        return EitherT$.MODULE$.fromOptionF(this.dbioRunner.run(this.deploymentRepository.getDeploymentById(id)), (Function0 & Serializable & scala.Serializable)() -> new DeploymentNotFoundError(id), (Functor)Invariant$.MODULE$.catsInstancesForFuture(this.ec));
    }

    private <F> EitherT<F, DeploymentService$NoPermissionError$, BoxedUnit> checkPermission(LoggedUser user, String category, Enumeration.Value permission, Applicative<F> evidence$1) {
        return EitherT.CondPartiallyApplied$.MODULE$.apply$extension(EitherT$.MODULE$.cond(), user.can(category, permission), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {}, (Function0 & Serializable & scala.Serializable)() -> DeploymentService$NoPermissionError$.MODULE$, evidence$1);
    }

    private EitherT<Future, GetDeploymentStatusError, ProcessState> getScenarioStatus(ProcessEntityData scenarioMetadata, LoggedUser loggedUser) {
        DataFreshnessPolicy.Fresh$ freshnessPolicy = DataFreshnessPolicy.Fresh$.MODULE$;
        return EitherT.RightPartiallyApplied$.MODULE$.apply$extension(EitherT$.MODULE$.right(), this.legacyDeploymentService.getProcessState(new ProcessIdWithName(scenarioMetadata.id(), scenarioMetadata.name()), loggedUser, (DataFreshnessPolicy)freshnessPolicy), (Functor)Invariant$.MODULE$.catsInstancesForFuture(this.ec));
    }

    public static final /* synthetic */ void $anonfun$runDeployment$4(BoxedUnit runResult) {
    }

    public DeploymentService(ScenarioMetadataRepository scenarioMetadataRepository, DeploymentRepository deploymentRepository, pl.touk.nussknacker.ui.process.deployment.DeploymentService legacyDeploymentService, DBIOActionRunner dbioRunner, Clock clock, ExecutionContext ec) {
        this.scenarioMetadataRepository = scenarioMetadataRepository;
        this.deploymentRepository = deploymentRepository;
        this.legacyDeploymentService = legacyDeploymentService;
        this.dbioRunner = dbioRunner;
        this.clock = clock;
        this.ec = ec;
    }

    public static final class ConflictingDeploymentIdError
    implements RunDeploymentError,
    Product,
    scala.Serializable {
        private final DeploymentId id;

        public DeploymentId id() {
            return this.id;
        }

        public ConflictingDeploymentIdError copy(DeploymentId id) {
            return new ConflictingDeploymentIdError(id);
        }

        public DeploymentId copy$default$1() {
            return this.id();
        }

        public String productPrefix() {
            return "ConflictingDeploymentIdError";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return this.id();
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ConflictingDeploymentIdError;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ConflictingDeploymentIdError)) return false;
            boolean bl = true;
            if (!bl) return false;
            ConflictingDeploymentIdError conflictingDeploymentIdError = (ConflictingDeploymentIdError)x$1;
            DeploymentId deploymentId = this.id();
            DeploymentId deploymentId2 = conflictingDeploymentIdError.id();
            if (deploymentId != null) {
                if (!((Object)deploymentId).equals(deploymentId2)) return false;
                return true;
            }
            if (deploymentId2 == null) return true;
            return false;
        }

        public ConflictingDeploymentIdError(DeploymentId id) {
            this.id = id;
            Product.$init$((Product)this);
        }
    }

    public static final class DeploymentNotFoundError
    implements GetDeploymentStatusError,
    Product,
    scala.Serializable {
        private final DeploymentId id;

        public DeploymentId id() {
            return this.id;
        }

        public DeploymentNotFoundError copy(DeploymentId id) {
            return new DeploymentNotFoundError(id);
        }

        public DeploymentId copy$default$1() {
            return this.id();
        }

        public String productPrefix() {
            return "DeploymentNotFoundError";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return this.id();
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof DeploymentNotFoundError;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof DeploymentNotFoundError)) return false;
            boolean bl = true;
            if (!bl) return false;
            DeploymentNotFoundError deploymentNotFoundError = (DeploymentNotFoundError)x$1;
            DeploymentId deploymentId = this.id();
            DeploymentId deploymentId2 = deploymentNotFoundError.id();
            if (deploymentId != null) {
                if (!((Object)deploymentId).equals(deploymentId2)) return false;
                return true;
            }
            if (deploymentId2 == null) return true;
            return false;
        }

        public DeploymentNotFoundError(DeploymentId id) {
            this.id = id;
            Product.$init$((Product)this);
        }
    }

    public static interface GetDeploymentStatusError {
    }

    public static final class NewCommentValidationError
    implements RunDeploymentError,
    Product,
    scala.Serializable {
        private final String message;

        public String message() {
            return this.message;
        }

        public NewCommentValidationError copy(String message) {
            return new NewCommentValidationError(message);
        }

        public String copy$default$1() {
            return this.message();
        }

        public String productPrefix() {
            return "NewCommentValidationError";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return this.message();
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof NewCommentValidationError;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof NewCommentValidationError)) return false;
            boolean bl = true;
            if (!bl) return false;
            NewCommentValidationError newCommentValidationError = (NewCommentValidationError)x$1;
            String string = this.message();
            String string2 = newCommentValidationError.message();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public NewCommentValidationError(String message) {
            this.message = message;
            Product.$init$((Product)this);
        }
    }

    public static interface RunDeploymentError {
    }

    public static final class ScenarioNotFoundError
    implements RunDeploymentError,
    Product,
    scala.Serializable {
        private final ProcessName scenarioName;

        public ProcessName scenarioName() {
            return this.scenarioName;
        }

        public ScenarioNotFoundError copy(ProcessName scenarioName) {
            return new ScenarioNotFoundError(scenarioName);
        }

        public ProcessName copy$default$1() {
            return this.scenarioName();
        }

        public String productPrefix() {
            return "ScenarioNotFoundError";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return this.scenarioName();
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ScenarioNotFoundError;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ScenarioNotFoundError)) return false;
            boolean bl = true;
            if (!bl) return false;
            ScenarioNotFoundError scenarioNotFoundError = (ScenarioNotFoundError)x$1;
            ProcessName processName = this.scenarioName();
            ProcessName processName2 = scenarioNotFoundError.scenarioName();
            if (processName != null) {
                if (!processName.equals(processName2)) return false;
                return true;
            }
            if (processName2 == null) return true;
            return false;
        }

        public ScenarioNotFoundError(ProcessName scenarioName) {
            this.scenarioName = scenarioName;
            Product.$init$((Product)this);
        }
    }
}

