/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.process.repository;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import db.util.DBIOActionInstances$;
import java.io.Serializable;
import java.sql.Timestamp;
import java.time.Instant;
import pl.touk.nussknacker.engine.api.deployment.ProcessActionId;
import pl.touk.nussknacker.engine.api.deployment.ScenarioActionName;
import pl.touk.nussknacker.engine.api.process.ProcessId;
import pl.touk.nussknacker.engine.api.process.ProcessIdWithName;
import pl.touk.nussknacker.engine.api.process.ProcessName;
import pl.touk.nussknacker.engine.api.process.VersionId;
import pl.touk.nussknacker.engine.api.process.VersionId$;
import pl.touk.nussknacker.engine.canonicalgraph.CanonicalProcess;
import pl.touk.nussknacker.restmodel.component.ScenarioComponentsUsages;
import pl.touk.nussknacker.ui.db.DbRef;
import pl.touk.nussknacker.ui.db.entity.AttachmentEntityFactory;
import pl.touk.nussknacker.ui.db.entity.BaseEntityFactory;
import pl.touk.nussknacker.ui.db.entity.CommentActions;
import pl.touk.nussknacker.ui.db.entity.CommentEntityData;
import pl.touk.nussknacker.ui.db.entity.CommentEntityFactory;
import pl.touk.nussknacker.ui.db.entity.EnvironmentsEntityFactory;
import pl.touk.nussknacker.ui.db.entity.ProcessActionEntityFactory;
import pl.touk.nussknacker.ui.db.entity.ProcessEntityData;
import pl.touk.nussknacker.ui.db.entity.ProcessEntityFactory;
import pl.touk.nussknacker.ui.db.entity.ProcessVersionEntityData;
import pl.touk.nussknacker.ui.db.entity.ProcessVersionEntityFactory;
import pl.touk.nussknacker.ui.db.entity.TagsEntityFactory;
import pl.touk.nussknacker.ui.listener.Comment;
import pl.touk.nussknacker.ui.process.newdeployment.DeploymentEntityFactory;
import pl.touk.nussknacker.ui.process.newdeployment.DeploymentId;
import pl.touk.nussknacker.ui.process.processingtype.ProcessingTypeDataProvider;
import pl.touk.nussknacker.ui.process.repository.ProcessDBQueryRepository;
import pl.touk.nussknacker.ui.process.repository.ProcessRepository;
import pl.touk.nussknacker.ui.process.repository.ProcessRepository$RemoteUserName$;
import pl.touk.nussknacker.ui.process.repository.Repository;
import pl.touk.nussknacker.ui.process.repository.ScenarioComponentsUsagesHelper$;
import pl.touk.nussknacker.ui.process.repository.ScenarioShapeFetchStrategy;
import pl.touk.nussknacker.ui.process.repository.ScenarioShapeFetchStrategy$FetchScenarioGraph$;
import pl.touk.nussknacker.ui.process.repository.UpdateProcessComment;
import pl.touk.nussknacker.ui.security.api.LoggedUser;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import slick.ast.BaseTypedType;
import slick.dbio.DBIOAction;
import slick.dbio.DBIOAction$;
import slick.dbio.Effect;
import slick.dbio.NoStream;
import slick.jdbc.JdbcActionComponent;
import slick.jdbc.JdbcProfile;
import slick.jdbc.JdbcType;
import slick.lifted.BaseColumnExtensionMethods;
import slick.lifted.BooleanColumnExtensionMethods$;
import slick.lifted.CanBeQueryCondition$;
import slick.lifted.OptionMapper2$;
import slick.lifted.Query;
import slick.lifted.Rep;
import slick.lifted.Shape$;
import slick.lifted.TableQuery;
import slick.sql.FixedSqlAction;

@ScalaSignature(bytes="\u0006\u0001\t%c\u0001\u0002\b\u0010\u0001qA\u0001\"\u0015\u0001\u0003\u0006\u0004%\tB\u0015\u0005\t-\u0002\u0011\t\u0011)A\u0005'\"Aq\u000b\u0001B\u0001B\u0003%\u0001\fC\u0003n\u0001\u0011\u0005a\u000eC\u0003w\u0001\u0011\u0005s\u000fC\u0004\u0002\u0002\u0001!\t!a\u0001\t\u000f\u0005M\u0003\u0001\"\u0001\u0002V!9\u0011Q\u000e\u0001\u0005\n\u0005=\u0004bBA\\\u0001\u0011\u0005\u0011\u0011\u0018\u0005\b\u0003\u000b\u0004A\u0011AAd\u0011\u001d\ty\r\u0001C\u0001\u0003#Dq!a9\u0001\t#\t)\u000fC\u0004\u0002x\u0002!\t!!?\u0003'\u0011\u0013\u0005K]8dKN\u001c(+\u001a9pg&$xN]=\u000b\u0005A\t\u0012A\u0003:fa>\u001c\u0018\u000e^8ss*\u0011!cE\u0001\baJ|7-Z:t\u0015\t!R#\u0001\u0002vS*\u0011acF\u0001\f]V\u001c8o\u001b8bG.,'O\u0003\u0002\u00193\u0005!Ao\\;l\u0015\u0005Q\u0012A\u00019m\u0007\u0001\u0019r\u0001A\u000f$syBe\n\u0005\u0002\u001fC5\tqDC\u0001!\u0003\u0015\u00198-\u00197b\u0013\t\u0011sD\u0001\u0004B]f\u0014VM\u001a\t\u0004I\u0015:S\"A\b\n\u0005\u0019z!!\u0005)s_\u000e,7o\u001d*fa>\u001c\u0018\u000e^8ssB\u0011\u0001F\u000e\b\u0003SMr!A\u000b\u0019\u000f\u0005-rS\"\u0001\u0017\u000b\u00055Z\u0012A\u0002\u001fs_>$h(C\u00010\u0003\t!'-\u0003\u00022e\u0005!Q\u000f^5m\u0015\u0005y\u0013B\u0001\u001b6\u0003M!%)S(BGRLwN\\%ogR\fgnY3t\u0015\t\t$'\u0003\u00028q\t\u0011AI\u0011\u0006\u0003iU\u0002\"A\u000f\u001f\u000e\u0003mR!aL\n\n\u0005uZ$\u0001\u0003(v)\u0006\u0014G.Z:\u0011\u0005}2U\"\u0001!\u000b\u0005\u0005\u0013\u0015\u0001D:dC2\fGn\\4hS:<'BA\"E\u0003!!\u0018\u0010]3tC\u001a,'\"A#\u0002\u0007\r|W.\u0003\u0002H\u0001\nYA*\u0019>z\u0019><w-\u001b8h!\tIE*D\u0001K\u0015\tY5(\u0001\u0004f]RLG/_\u0005\u0003\u001b*\u0013abQ8n[\u0016tG/Q2uS>t7\u000fE\u0002%\u001f\u001eJ!\u0001U\b\u00031A\u0013xnY3tg\u0012\u0013\u0015+^3ssJ+\u0007o\\:ji>\u0014\u00180A\u0003eEJ+g-F\u0001T!\tQD+\u0003\u0002Vw\t)AI\u0019*fM\u00061AM\u0019*fM\u0002\nA\"\\8eK24VM]:j_:\u0004$!\u00173\u0011\tikvLY\u0007\u00027*\u0011A,E\u0001\u000faJ|7-Z:tS:<G/\u001f9f\u0013\tq6L\u0001\u000eQe>\u001cWm]:j]\u001e$\u0016\u0010]3ECR\f\u0007K]8wS\u0012,'\u000f\u0005\u0002\u001fA&\u0011\u0011m\b\u0002\u0004\u0013:$\bCA2e\u0019\u0001!\u0011\"Z\u0002\u0002\u0002\u0003\u0005)\u0011\u00014\u0003\u0007}##'\u0005\u0002hUB\u0011a\u0004[\u0005\u0003S~\u0011qAT8uQ&tw\r\u0005\u0002\u001fW&\u0011An\b\u0002\u0004\u0003:L\u0018A\u0002\u001fj]&$h\bF\u0002paF\u0004\"\u0001\n\u0001\t\u000bE#\u0001\u0019A*\t\u000b]#\u0001\u0019\u0001:1\u0005M,\b\u0003\u0002.^?R\u0004\"aY;\u0005\u0013\u0015\f\u0018\u0011!A\u0001\u0006\u00031\u0017a\u0001:v]V\u0011\u0001P`\u000b\u0002sB!aD\u001f?}\u0013\tYxDA\u0005Gk:\u001cG/[8ocA\u0019\u0001FN?\u0011\u0005\rtH!B@\u0006\u0005\u00041'!\u0001*\u0002\u001dM\fg/\u001a(foB\u0013xnY3tgR!\u0011QAA%)\u0011\t9!!\u000e\u0011\t!2\u0014\u0011\u0002\t\u0006=\u0005-\u0011qB\u0005\u0004\u0003\u001by\"AB(qi&|g\u000e\u0005\u0003\u0002\u0012\u0005=b\u0002BA\n\u0003WqA!!\u0006\u0002*9!\u0011qCA\u0014\u001d\u0011\tI\"!\n\u000f\t\u0005m\u00111\u0005\b\u0005\u0003;\t\tCD\u0002,\u0003?I\u0011AG\u0005\u00031eI!AF\f\n\u0005Q)\u0012B\u0001\n\u0014\u0013\t\u0001\u0012#C\u0002\u0002.=\t\u0011\u0003\u0015:pG\u0016\u001c8OU3q_NLGo\u001c:z\u0013\u0011\t\t$a\r\u0003\u001dA\u0013xnY3tg\u000e\u0013X-\u0019;fI*\u0019\u0011QF\b\t\u000f\u0005]b\u0001q\u0001\u0002:\u0005QAn\\4hK\u0012,6/\u001a:\u0011\t\u0005m\u0012QI\u0007\u0003\u0003{QA!a\u0010\u0002B\u0005\u0019\u0011\r]5\u000b\u0007\u0005\r3#\u0001\u0005tK\u000e,(/\u001b;z\u0013\u0011\t9%!\u0010\u0003\u00151{wmZ3e+N,'\u000fC\u0004\u0002L\u0019\u0001\r!!\u0014\u0002\r\u0005\u001cG/[8o!\u0011\t\t\"a\u0014\n\t\u0005E\u00131\u0007\u0002\u0014\u0007J,\u0017\r^3Qe>\u001cWm]:BGRLwN\\\u0001\u000ekB$\u0017\r^3Qe>\u001cWm]:\u0015\t\u0005]\u00131\r\u000b\u0005\u00033\n\t\u0007\u0005\u0003)m\u0005m\u0003\u0003BA\t\u0003;JA!a\u0018\u00024\tq\u0001K]8dKN\u001cX\u000b\u001d3bi\u0016$\u0007bBA\u001c\u000f\u0001\u000f\u0011\u0011\b\u0005\b\u0003K:\u0001\u0019AA4\u0003M)\b\u000fZ1uKB\u0013xnY3tg\u0006\u001bG/[8o!\u0011\t\t\"!\u001b\n\t\u0005-\u00141\u0007\u0002\u0014+B$\u0017\r^3Qe>\u001cWm]:BGRLwN\\\u0001\u0016kB$\u0017\r^3Qe>\u001cWm]:J]R,'O\\1m))\t\t(!\u001e\u0002\n\u0006e\u00151\u0015\u000b\u0005\u00033\n\u0019\bC\u0004\u00028!\u0001\u001d!!\u000f\t\u000f\u0005]\u0004\u00021\u0001\u0002z\u0005I\u0001O]8dKN\u001c\u0018\n\u001a\t\u0005\u0003w\n))\u0004\u0002\u0002~)\u0019!#a \u000b\t\u0005}\u0012\u0011\u0011\u0006\u0004\u0003\u0007+\u0012AB3oO&tW-\u0003\u0003\u0002\b\u0006u$!\u0005)s_\u000e,7o]%e/&$\bNT1nK\"9\u00111\u0012\u0005A\u0002\u00055\u0015\u0001E2b]>t\u0017nY1m!J|7-Z:t!\u0011\ty)!&\u000e\u0005\u0005E%\u0002BAJ\u0003\u0003\u000babY1o_:L7-\u00197he\u0006\u0004\b.\u0003\u0003\u0002\u0018\u0006E%\u0001E\"b]>t\u0017nY1m!J|7-Z:t\u0011\u001d\tY\n\u0003a\u0001\u0003;\u000b\u0011%\u001b8de\u0016\f7/\u001a,feNLwN\\,iK:T5o\u001c8O_R\u001c\u0005.\u00198hK\u0012\u00042AHAP\u0013\r\t\tk\b\u0002\b\u0005>|G.Z1o\u0011\u001d\t)\u000b\u0003a\u0001\u0003O\u000b\u0001\"^:fe:\u000bW.\u001a\t\u0005\u0003S\u000b\tL\u0004\u0003\u0002,\u00065\u0006CA\u0016 \u0013\r\tykH\u0001\u0007!J,G-\u001a4\n\t\u0005M\u0016Q\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005=v$A\u0007eK2,G/\u001a)s_\u000e,7o\u001d\u000b\u0005\u0003w\u000b\u0019\r\u0005\u0003)m\u0005u\u0006c\u0001\u0010\u0002@&\u0019\u0011\u0011Y\u0010\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003oJ\u0001\u0019AA=\u0003\u001d\t'o\u00195jm\u0016$b!a/\u0002J\u0006-\u0007bBA<\u0015\u0001\u0007\u0011\u0011\u0010\u0005\b\u0003\u001bT\u0001\u0019AAO\u0003)I7/\u0011:dQ&4X\rZ\u0001\u000ee\u0016t\u0017-\\3Qe>\u001cWm]:\u0015\r\u0005M\u0017q[Am)\u0011\tY,!6\t\u000f\u0005]2\u0002q\u0001\u0002:!1!c\u0003a\u0001\u0003sBq!a7\f\u0001\u0004\ti.A\u0004oK^t\u0015-\\3\u0011\t\u0005m\u0014q\\\u0005\u0005\u0003C\fiHA\u0006Qe>\u001cWm]:OC6,\u0017a\u00018poV\u0011\u0011q\u001d\t\u0005\u0003S\f\u00190\u0004\u0002\u0002l*!\u0011Q^Ax\u0003\u0011!\u0018.\\3\u000b\u0005\u0005E\u0018\u0001\u00026bm\u0006LA!!>\u0002l\n9\u0011J\\:uC:$\u0018aD2iC:<WMV3sg&|g.\u00133\u0015\u0011\u0005m(1\u0007B\u001e\u0005\u000b\u0002\u0012\"!@\u0003\n}\u0013IB!\n\u000f\t\u0005}(\u0011A\u0007\u0002\u0001%!!1\u0001B\u0003\u0003\u001d\u0001(o\u001c4jY\u0016L1Aa\u0002\u0010\u0005)\u0011V\r]8tSR|'/_\u0005\u0005\u0005\u0017\u0011iAA\u0007Qe>4\u0017\u000e\\3BGRLwN\\\u0005\u0005\u0005\u001f\u0011\tBA\nKI\n\u001c\u0017i\u0019;j_:\u001cu.\u001c9p]\u0016tGO\u0003\u0003\u0003\u0014\tU\u0011\u0001\u00026eE\u000eT!Aa\u0006\u0002\u000bMd\u0017nY6\u0011\t\tm!\u0011E\u0007\u0003\u0005;QAAa\b\u0003\u0016\u0005!AMY5p\u0013\u0011\u0011\u0019C!\b\u0003\u00119{7\u000b\u001e:fC6\u0004BAa\n\u0003.9!!1\u0004B\u0015\u0013\u0011\u0011YC!\b\u0002\r\u00153g-Z2u\u0013\u0011\u0011yC!\r\u0003\u000b]\u0013\u0018\u000e^3\u000b\t\t-\"Q\u0004\u0005\b\u0003oj\u0001\u0019\u0001B\u001b!\u0011\tYHa\u000e\n\t\te\u0012Q\u0010\u0002\n!J|7-Z:t\u0013\u0012DqA!\u0010\u000e\u0001\u0004\u0011y$A\u0005wKJ\u001c\u0018n\u001c8JIB!\u00111\u0010B!\u0013\u0011\u0011\u0019%! \u0003\u0013Y+'o]5p]&#\u0007b\u0002B$\u001b\u0001\u0007!qH\u0001\u0012m\u0016\u00148/[8o\u0013\u0012$v.\u00169eCR,\u0007")
public class DBProcessRepository
implements ProcessRepository<DBIOAction>,
LazyLogging,
CommentActions,
ProcessDBQueryRepository<DBIOAction> {
    private final DbRef dbRef;
    private final ProcessingTypeDataProvider<Object, ?> modelVersion;
    private JdbcProfile profile;
    private JdbcProfile.API api;
    private transient Logger logger;
    private TableQuery<DeploymentEntityFactory.DeploymentsEntity> deploymentsTable;
    private final TableQuery<AttachmentEntityFactory.AttachmentEntity> attachmentsTable;
    private final TableQuery<TagsEntityFactory.TagsEntity> tagsTable;
    private final TableQuery<ProcessActionEntityFactory.ProcessActionEntity> processActionsTable;
    private final TableQuery<EnvironmentsEntityFactory.EnvironmentsEntity> environmentsTable;
    private final TableQuery<ProcessVersionEntityFactory.ProcessVersionEntity> processVersionsTable;
    private final TableQuery<ProcessVersionEntityFactory.ProcessVersionEntityWithScenarioJson> processVersionsTableWithScenarioJson;
    private final TableQuery<ProcessVersionEntityFactory.ProcessVersionEntityWithComponentsUsages> processVersionsTableWithComponentsUsages;
    private final TableQuery<ProcessVersionEntityFactory.ProcessVersionEntityWithUnit> processVersionsTableWithUnit;
    private final TableQuery<CommentEntityFactory.CommentEntity> commentsTable;
    private final TableQuery<ProcessEntityFactory.ProcessEntity> processesTable;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    @Override
    public Query<ProcessEntityFactory.ProcessEntity, ProcessEntityData, Seq> processTableFilteredByUser(LoggedUser loggedUser) {
        return ProcessDBQueryRepository.processTableFilteredByUser$(this, loggedUser);
    }

    @Override
    public Query<ProcessVersionEntityFactory.BaseProcessVersionEntity, ProcessVersionEntityData, Seq> fetchProcessLatestVersionsQuery(ProcessId processId, ScenarioShapeFetchStrategy<?> fetchShape) {
        return ProcessDBQueryRepository.fetchProcessLatestVersionsQuery$(this, processId, fetchShape);
    }

    @Override
    public Query<Tuple2<Tuple2<Tuple2<Rep<ProcessId>, Rep<Option<Timestamp>>>, ProcessVersionEntityFactory.BaseProcessVersionEntity>, ProcessEntityFactory.ProcessEntity>, Tuple2<Tuple2<Tuple2<ProcessId, Option<Timestamp>>, ProcessVersionEntityData>, ProcessEntityData>, Seq> fetchLatestProcessesQuery(Function1<ProcessEntityFactory.ProcessEntity, Rep<Object>> query, Set<ProcessId> deployedProcesses, Option<Object> isDeployed, ScenarioShapeFetchStrategy<?> fetchShape, LoggedUser loggedUser) {
        return ProcessDBQueryRepository.fetchLatestProcessesQuery$(this, query, deployedProcesses, isDeployed, fetchShape, loggedUser);
    }

    @Override
    public TableQuery<ProcessVersionEntityFactory.BaseProcessVersionEntity> processVersionsTableQuery(ScenarioShapeFetchStrategy<?> fetchShape) {
        return ProcessDBQueryRepository.processVersionsTableQuery$(this, fetchShape);
    }

    @Override
    public Query<ProcessVersionEntityFactory.BaseProcessVersionEntity, ProcessVersionEntityData, Seq> latestProcessVersionsNoJsonQuery(ProcessName processName) {
        return ProcessDBQueryRepository.latestProcessVersionsNoJsonQuery$(this, processName);
    }

    @Override
    public <T extends JdbcProfile> DBIOAction<Object, NoStream, Effect.All> nextIdAction(T jdbcProfile) {
        return CommentActions.nextIdAction$(this, jdbcProfile);
    }

    @Override
    public DBIOAction<Option<CommentEntityData>, NoStream, Effect.All> newCommentAction(ProcessId processId, Function0<VersionId> processVersionId, Option<Comment> comment, ExecutionContext ec, LoggedUser loggedUser) {
        return CommentActions.newCommentAction$(this, processId, processVersionId, comment, ec, loggedUser);
    }

    @Override
    public JdbcType<DeploymentId> deploymentIdMapping() {
        return DeploymentEntityFactory.deploymentIdMapping$(this);
    }

    @Override
    public JdbcType<ProcessId> processIdMapping() {
        return BaseEntityFactory.processIdMapping$(this);
    }

    @Override
    public JdbcType<ProcessName> processNameMapping() {
        return BaseEntityFactory.processNameMapping$(this);
    }

    @Override
    public JdbcType<VersionId> versionIdMapping() {
        return BaseEntityFactory.versionIdMapping$(this);
    }

    @Override
    public JdbcType<ProcessActionId> processActionIdMapping() {
        return BaseEntityFactory.processActionIdMapping$(this);
    }

    @Override
    public JdbcType<ScenarioActionName> scenarioActionName() {
        return BaseEntityFactory.scenarioActionName$(this);
    }

    @Override
    public JdbcType<Enumeration.Value> processActionState() {
        return BaseEntityFactory.processActionState$(this);
    }

    private JdbcProfile profile$lzycompute() {
        DBProcessRepository dBProcessRepository = this;
        synchronized (dBProcessRepository) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.profile = Repository.profile$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.profile;
    }

    @Override
    public JdbcProfile profile() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.profile$lzycompute() : this.profile;
    }

    private JdbcProfile.API api$lzycompute() {
        DBProcessRepository dBProcessRepository = this;
        synchronized (dBProcessRepository) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.api = Repository.api$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.api;
    }

    @Override
    public JdbcProfile.API api() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.api$lzycompute() : this.api;
    }

    private Logger logger$lzycompute() {
        DBProcessRepository dBProcessRepository = this;
        synchronized (dBProcessRepository) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private TableQuery<DeploymentEntityFactory.DeploymentsEntity> deploymentsTable$lzycompute() {
        DBProcessRepository dBProcessRepository = this;
        synchronized (dBProcessRepository) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.deploymentsTable = DeploymentEntityFactory.deploymentsTable$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.deploymentsTable;
    }

    @Override
    public TableQuery<DeploymentEntityFactory.DeploymentsEntity> deploymentsTable() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.deploymentsTable$lzycompute() : this.deploymentsTable;
    }

    @Override
    public TableQuery<AttachmentEntityFactory.AttachmentEntity> attachmentsTable() {
        return this.attachmentsTable;
    }

    @Override
    public void pl$touk$nussknacker$ui$db$entity$AttachmentEntityFactory$_setter_$attachmentsTable_$eq(TableQuery<AttachmentEntityFactory.AttachmentEntity> x$1) {
        this.attachmentsTable = x$1;
    }

    @Override
    public TableQuery<TagsEntityFactory.TagsEntity> tagsTable() {
        return this.tagsTable;
    }

    @Override
    public void pl$touk$nussknacker$ui$db$entity$TagsEntityFactory$_setter_$tagsTable_$eq(TableQuery<TagsEntityFactory.TagsEntity> x$1) {
        this.tagsTable = x$1;
    }

    @Override
    public TableQuery<ProcessActionEntityFactory.ProcessActionEntity> processActionsTable() {
        return this.processActionsTable;
    }

    @Override
    public void pl$touk$nussknacker$ui$db$entity$ProcessActionEntityFactory$_setter_$processActionsTable_$eq(TableQuery<ProcessActionEntityFactory.ProcessActionEntity> x$1) {
        this.processActionsTable = x$1;
    }

    @Override
    public TableQuery<EnvironmentsEntityFactory.EnvironmentsEntity> environmentsTable() {
        return this.environmentsTable;
    }

    @Override
    public void pl$touk$nussknacker$ui$db$entity$EnvironmentsEntityFactory$_setter_$environmentsTable_$eq(TableQuery<EnvironmentsEntityFactory.EnvironmentsEntity> x$1) {
        this.environmentsTable = x$1;
    }

    @Override
    public TableQuery<ProcessVersionEntityFactory.ProcessVersionEntity> processVersionsTable() {
        return this.processVersionsTable;
    }

    @Override
    public TableQuery<ProcessVersionEntityFactory.ProcessVersionEntityWithScenarioJson> processVersionsTableWithScenarioJson() {
        return this.processVersionsTableWithScenarioJson;
    }

    @Override
    public TableQuery<ProcessVersionEntityFactory.ProcessVersionEntityWithComponentsUsages> processVersionsTableWithComponentsUsages() {
        return this.processVersionsTableWithComponentsUsages;
    }

    @Override
    public TableQuery<ProcessVersionEntityFactory.ProcessVersionEntityWithUnit> processVersionsTableWithUnit() {
        return this.processVersionsTableWithUnit;
    }

    @Override
    public void pl$touk$nussknacker$ui$db$entity$ProcessVersionEntityFactory$_setter_$processVersionsTable_$eq(TableQuery<ProcessVersionEntityFactory.ProcessVersionEntity> x$1) {
        this.processVersionsTable = x$1;
    }

    @Override
    public void pl$touk$nussknacker$ui$db$entity$ProcessVersionEntityFactory$_setter_$processVersionsTableWithScenarioJson_$eq(TableQuery<ProcessVersionEntityFactory.ProcessVersionEntityWithScenarioJson> x$1) {
        this.processVersionsTableWithScenarioJson = x$1;
    }

    @Override
    public void pl$touk$nussknacker$ui$db$entity$ProcessVersionEntityFactory$_setter_$processVersionsTableWithComponentsUsages_$eq(TableQuery<ProcessVersionEntityFactory.ProcessVersionEntityWithComponentsUsages> x$1) {
        this.processVersionsTableWithComponentsUsages = x$1;
    }

    @Override
    public void pl$touk$nussknacker$ui$db$entity$ProcessVersionEntityFactory$_setter_$processVersionsTableWithUnit_$eq(TableQuery<ProcessVersionEntityFactory.ProcessVersionEntityWithUnit> x$1) {
        this.processVersionsTableWithUnit = x$1;
    }

    @Override
    public TableQuery<CommentEntityFactory.CommentEntity> commentsTable() {
        return this.commentsTable;
    }

    @Override
    public void pl$touk$nussknacker$ui$db$entity$CommentEntityFactory$_setter_$commentsTable_$eq(TableQuery<CommentEntityFactory.CommentEntity> x$1) {
        this.commentsTable = x$1;
    }

    @Override
    public TableQuery<ProcessEntityFactory.ProcessEntity> processesTable() {
        return this.processesTable;
    }

    @Override
    public void pl$touk$nussknacker$ui$db$entity$ProcessEntityFactory$_setter_$processesTable_$eq(TableQuery<ProcessEntityFactory.ProcessEntity> x$1) {
        this.processesTable = x$1;
    }

    @Override
    public DbRef dbRef() {
        return this.dbRef;
    }

    @Override
    public <R> Function1<DBIOAction<R, NoStream, Effect.All>, DBIOAction<R, NoStream, Effect.All>> run() {
        return (Function1 & Serializable & scala.Serializable)x -> (DBIOAction)Predef$.MODULE$.identity(x);
    }

    @Override
    public DBIOAction<Option<ProcessRepository.ProcessCreated>, NoStream, Effect.All> saveNewProcess(ProcessRepository.CreateProcessAction action, LoggedUser loggedUser) {
        BoxedUnit boxedUnit;
        String userName = (String)action.forwardedUserName().map((Function1 & Serializable & scala.Serializable)x$2 -> ProcessRepository$RemoteUserName$.MODULE$.display$extension(((ProcessRepository.RemoteUserName)x$2).name())).getOrElse((Function0 & Serializable & scala.Serializable)() -> loggedUser.username());
        ProcessId x$1 = new ProcessId(-1L);
        ProcessName x$22 = action.processName();
        String x$32 = action.category();
        None$ x$4 = None$.MODULE$;
        String x$5 = action.processingType();
        boolean x$6 = action.isFragment();
        boolean x$7 = false;
        Timestamp x$8 = Timestamp.from(this.now());
        String x$9 = userName;
        ProcessEntityData processToSave = new ProcessEntityData(x$1, x$22, (Option<String>)x$4, x$32, x$5, x$6, x$7, x$8, x$9);
        JdbcActionComponent.IntoInsertActionComposer insertNew = ((JdbcActionComponent.CountingInsertActionComposer)this.profile().api().queryInsertActionExtensionMethods(this.processesTable())).returning(this.processesTable().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.id(), Shape$.MODULE$.repColumnShape(this.processIdMapping()))).into((Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ProcessEntityData entity = (ProcessEntityData)tuple2._1();
            ProcessId newId = (ProcessId)tuple2._2();
            ProcessEntityData processEntityData = entity.copy(newId, entity.copy$default$2(), entity.copy$default$3(), entity.copy$default$4(), entity.copy$default$5(), entity.copy$default$6(), entity.copy$default$7(), entity.copy$default$8(), entity.copy$default$9());
            return processEntityData;
        });
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Saving scenario {} by user {}", new Object[]{action.processName(), userName});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return ((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.profile().api().streamableQueryActionExtensionMethods(this.latestProcessVersionsNoJsonQuery(action.processName()))).result().headOption().flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            DBIOAction dBIOAction;
            Option option = x0$2;
            if (option instanceof Some) {
                dBIOAction = DBIOAction$.MODULE$.failed((Throwable)new ProcessDBQueryRepository.ProcessAlreadyExists(action.processName().value()));
            } else if (None$.MODULE$.equals(option)) {
                dBIOAction = ((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.profile().api().streamableQueryActionExtensionMethods(this.processesTable().filter((Function1 & Serializable & scala.Serializable)x$4 -> new BaseColumnExtensionMethods(this.profile().api().columnExtensionMethods(x$4.name(), this.processNameMapping())).$eq$eq$eq((Rep)this.profile().api().valueToConstColumn((Object)action.processName(), this.processNameMapping()), OptionMapper2$.MODULE$.getOptionMapper2TT(this.processNameMapping())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()))).result().headOption().flatMap((Function1 & Serializable & scala.Serializable)x0$3 -> {
                    DBIOAction dBIOAction;
                    Option option = x0$3;
                    if (option instanceof Some) {
                        dBIOAction = DBIOAction$.MODULE$.failed((Throwable)new ProcessDBQueryRepository.ProcessAlreadyExists(action.processName().value()));
                    } else if (None$.MODULE$.equals(option)) {
                        dBIOAction = insertNew.$plus$eq((Object)processToSave).flatMap((Function1 & Serializable & scala.Serializable)entity -> this.updateProcessInternal(new ProcessIdWithName(entity.id(), entity.name()), action.canonicalProcess(), false, userName, loggedUser), ExecutionContext.Implicits$.MODULE$.global()).map((Function1 & Serializable & scala.Serializable)res -> res.newVersion().map((Function1 & Serializable & scala.Serializable)x$5 -> new ProcessRepository.ProcessCreated(res.processId(), (VersionId)x$5)), ExecutionContext.Implicits$.MODULE$.global());
                    } else {
                        throw new MatchError((Object)option);
                    }
                    return dBIOAction;
                }, ExecutionContext.Implicits$.MODULE$.global());
            } else {
                throw new MatchError((Object)option);
            }
            return dBIOAction;
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    @Override
    public DBIOAction<ProcessRepository.ProcessUpdated, NoStream, Effect.All> updateProcess(ProcessRepository.UpdateProcessAction updateProcessAction, LoggedUser loggedUser) {
        String userName = (String)updateProcessAction.forwardedUserName().map((Function1 & Serializable & scala.Serializable)x$6 -> ProcessRepository$RemoteUserName$.MODULE$.display$extension(((ProcessRepository.RemoteUserName)x$6).name())).getOrElse((Function0 & Serializable & scala.Serializable)() -> loggedUser.username());
        return this.updateProcessInternal(updateProcessAction.id(), updateProcessAction.canonicalProcess(), updateProcessAction.increaseVersionWhenJsonNotChanged(), userName, loggedUser).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ProcessRepository.ProcessUpdated processUpdated = x0$1;
            if (processUpdated != null) {
                ProcessId processId = processUpdated.processId();
                Option<VersionId> option = processUpdated.newVersion();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    VersionId newVersion = (VersionId)some.value();
                    return this.addNewCommentToVersion$1(processId, newVersion, updateProcessAction, loggedUser).map((Function1 & Serializable & scala.Serializable)x$7 -> processUpdated, ExecutionContext.Implicits$.MODULE$.global());
                }
            }
            if (processUpdated == null) return this.profile().api().DBIO().successful((Object)processUpdated);
            ProcessId processId = processUpdated.processId();
            Option<VersionId> option = processUpdated.oldVersion();
            if (!(option instanceof Some)) return this.profile().api().DBIO().successful((Object)processUpdated);
            Some some = (Some)option;
            VersionId oldVersion = (VersionId)some.value();
            return this.addNewCommentToVersion$1(processId, oldVersion, updateProcessAction, loggedUser).map((Function1 & Serializable & scala.Serializable)x$8 -> processUpdated, ExecutionContext.Implicits$.MODULE$.global());
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    private DBIOAction<ProcessRepository.ProcessUpdated, NoStream, Effect.All> updateProcessInternal(ProcessIdWithName processId, CanonicalProcess canonicalProcess, boolean increaseVersionWhenJsonNotChanged, String userName, LoggedUser loggedUser) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Updating scenario {} by user {}", new Object[]{processId.name(), userName});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return ((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.profile().api().streamableQueryActionExtensionMethods(this.processTableFilteredByUser(loggedUser).filter((Function1 & Serializable & scala.Serializable)x$9 -> new BaseColumnExtensionMethods(this.profile().api().columnExtensionMethods(x$9.id(), this.processIdMapping())).$eq$eq$eq((Rep)this.profile().api().valueToConstColumn((Object)processId.id(), this.processIdMapping()), OptionMapper2$.MODULE$.getOptionMapper2TT(this.processIdMapping())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()))).result().headOption().map((Function1 & Serializable & scala.Serializable)maybeProcess -> {
            ProcessEntityData process = (ProcessEntityData)maybeProcess.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new ProcessDBQueryRepository.ProcessNotFoundError(processId.name());
            });
            return new Tuple2(maybeProcess, (Object)process);
        }, ExecutionContext.Implicits$.MODULE$.global()).flatMap((Function1 & Serializable & scala.Serializable)x$14 -> {
            Tuple2 tuple2 = x$14;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ProcessEntityData process = (ProcessEntityData)tuple2._2();
            DBIOAction dBIOAction = ((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.profile().api().streamableQueryActionExtensionMethods(this.fetchProcessLatestVersionsQuery(processId.id(), ScenarioShapeFetchStrategy$FetchScenarioGraph$.MODULE$))).result().headOption().map((Function1 & Serializable & scala.Serializable)latestProcessVersion -> {
                Option newProcessVersionOpt = this.versionToInsert$1((Option)latestProcessVersion, process.processingType(), increaseVersionWhenJsonNotChanged, canonicalProcess, processId, userName, loggedUser);
                return new Tuple2(latestProcessVersion, (Object)newProcessVersionOpt);
            }, ExecutionContext.Implicits$.MODULE$.global()).flatMap((Function1 & Serializable & scala.Serializable)x$13 -> {
                Tuple2 tuple2 = x$13;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Option latestProcessVersion = (Option)tuple2._1();
                Option newProcessVersionOpt = (Option)tuple2._2();
                DBIOAction dBIOAction = ((DBIOAction)newProcessVersionOpt.map((Function1 & Serializable & scala.Serializable)x$10 -> ((JdbcActionComponent.SimpleInsertActionComposer)this.profile().api().queryInsertActionExtensionMethods(this.processVersionsTable())).$plus$eq(x$10)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (DBIOAction)DBIOActionInstances$.MODULE$.dbMonad(ExecutionContext.Implicits$.MODULE$.global()).pure((Object)BoxesRunTime.boxToInteger((int)0)))).map((Function1 & Serializable & scala.Serializable)_ -> DBProcessRepository.$anonfun$updateProcessInternal$9(process, latestProcessVersion, newProcessVersionOpt, BoxesRunTime.unboxToInt((Object)_)), ExecutionContext.Implicits$.MODULE$.global());
                return dBIOAction;
            }, ExecutionContext.Implicits$.MODULE$.global());
            return dBIOAction;
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    @Override
    public DBIOAction<BoxedUnit, NoStream, Effect.All> deleteProcess(ProcessIdWithName processId) {
        return this.profile().api().queryDeleteActionExtensionMethods(this.processesTable().filter((Function1 & Serializable & scala.Serializable)x$15 -> new BaseColumnExtensionMethods(this.profile().api().columnExtensionMethods(x$15.id(), this.processIdMapping())).$eq$eq$eq((Rep)this.profile().api().valueToConstColumn((Object)processId.id(), this.processIdMapping()), OptionMapper2$.MODULE$.getOptionMapper2TT(this.processIdMapping())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition())).delete().map((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x0$1 -> {
            int n = x0$1;
            switch (n) {
                case 0: {
                    throw new ProcessDBQueryRepository.ProcessNotFoundError(processId.name());
                }
                case 1: {
                    break;
                }
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                }
            }
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    @Override
    public DBIOAction<BoxedUnit, NoStream, Effect.All> archive(ProcessIdWithName processId, boolean isArchived) {
        return this.profile().api().queryUpdateActionExtensionMethods(this.processesTable().filter((Function1 & Serializable & scala.Serializable)x$16 -> new BaseColumnExtensionMethods(this.profile().api().columnExtensionMethods(x$16.id(), this.processIdMapping())).$eq$eq$eq((Rep)this.profile().api().valueToConstColumn((Object)processId.id(), this.processIdMapping()), OptionMapper2$.MODULE$.getOptionMapper2TT(this.processIdMapping())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.isArchived(), Shape$.MODULE$.repColumnShape((BaseTypedType)this.profile().api().booleanColumnType()))).update((Object)BoxesRunTime.boxToBoolean((boolean)isArchived)).map((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x0$1 -> {
            int n = x0$1;
            switch (n) {
                case 0: {
                    throw new ProcessDBQueryRepository.ProcessNotFoundError(processId.name());
                }
                case 1: {
                    break;
                }
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                }
            }
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    @Override
    public DBIOAction<BoxedUnit, NoStream, Effect.All> renameProcess(ProcessIdWithName process, ProcessName newName, LoggedUser loggedUser) {
        DBIOAction updateNameInProcessJson = ((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.profile().api().streamableQueryActionExtensionMethods(this.processVersionsTableWithScenarioJson().filter((Function1 & Serializable & scala.Serializable)x$18 -> new BaseColumnExtensionMethods(this.profile().api().columnExtensionMethods(x$18.processId(), this.processIdMapping())).$eq$eq$eq((Rep)this.profile().api().valueToConstColumn((Object)process.id(), this.processIdMapping()), OptionMapper2$.MODULE$.getOptionMapper2TT(this.processIdMapping())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).join(this.processesTable()).on((Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ProcessVersionEntityFactory.ProcessVersionEntityWithScenarioJson version = (ProcessVersionEntityFactory.ProcessVersionEntityWithScenarioJson)((Object)((Object)tuple2._1()));
            ProcessEntityFactory.ProcessEntity process = (ProcessEntityFactory.ProcessEntity)((Object)((Object)tuple2._2()));
            Rep rep = new BaseColumnExtensionMethods(this.profile().api().columnExtensionMethods(version.processId(), this.processIdMapping())).$eq$eq$eq(process.id(), OptionMapper2$.MODULE$.getOptionMapper2TT(this.processIdMapping()));
            return rep;
        }, CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()))).result().flatMap((Function1 & Serializable & scala.Serializable)processVersions -> this.profile().api().DBIO().seq((Seq)processVersions.map(((Function2 & Serializable & scala.Serializable)(Function2 & Serializable & scala.Serializable)(processVersion, process) -> this.updateNameInSingleProcessVersion$1((ProcessVersionEntityData)processVersion, (ProcessEntityData)process, newName)).tupled(), Seq$.MODULE$.canBuildFrom())), ExecutionContext.Implicits$.MODULE$.global());
        FixedSqlAction updateNameInProcess = this.profile().api().queryUpdateActionExtensionMethods(this.processesTable().filter((Function1 & Serializable & scala.Serializable)x$19 -> new BaseColumnExtensionMethods(this.profile().api().columnExtensionMethods(x$19.id(), this.processIdMapping())).$eq$eq$eq((Rep)this.profile().api().valueToConstColumn((Object)process.id(), this.processIdMapping()), OptionMapper2$.MODULE$.getOptionMapper2TT(this.processIdMapping())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).map((Function1 & Serializable & scala.Serializable)x$20 -> x$20.name(), Shape$.MODULE$.repColumnShape(this.processNameMapping()))).update((Object)newName);
        DBIOAction addCommentAction = ((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.profile().api().streamableQueryActionExtensionMethods(this.processVersionsTableWithUnit().filter((Function1 & Serializable & scala.Serializable)x$21 -> new BaseColumnExtensionMethods(this.profile().api().columnExtensionMethods(x$21.processId(), this.processIdMapping())).$eq$eq$eq((Rep)this.profile().api().valueToConstColumn((Object)process.id(), this.processIdMapping()), OptionMapper2$.MODULE$.getOptionMapper2TT(this.processIdMapping())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).sortBy((Function1 & Serializable & scala.Serializable)x$22 -> this.profile().api().columnToOrdered(x$22.id(), this.versionIdMapping()).desc(), (Function1)Predef$.MODULE$.$conforms()))).result().headOption().flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            DBIOAction<Option<CommentEntityData>, NoStream, Effect.All> dBIOAction;
            Option option = x0$2;
            if (option instanceof Some) {
                Some some = (Some)option;
                ProcessVersionEntityData version = (ProcessVersionEntityData)some.value();
                dBIOAction = this.newCommentAction(process.id(), (Function0<VersionId>)(Function0 & Serializable & scala.Serializable)() -> version.id(), (Option<Comment>)new Some((Object)new UpdateProcessComment(new StringBuilder(16).append("Rename: [").append(process.name()).append("] -> [").append(newName).append("]").toString())), ExecutionContext.Implicits$.MODULE$.global(), loggedUser);
            } else if (None$.MODULE$.equals(option)) {
                dBIOAction = this.profile().api().DBIO().successful((Object)BoxedUnit.UNIT);
            } else {
                throw new MatchError((Object)option);
            }
            return dBIOAction;
        }, ExecutionContext.Implicits$.MODULE$.global());
        DBIOAction action = ((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.profile().api().streamableQueryActionExtensionMethods(this.processesTable().filter((Function1 & Serializable & scala.Serializable)x$23 -> new BaseColumnExtensionMethods(this.profile().api().columnExtensionMethods(x$23.name(), this.processNameMapping())).$eq$eq$eq((Rep)this.profile().api().valueToConstColumn((Object)newName, this.processNameMapping()), OptionMapper2$.MODULE$.getOptionMapper2TT(this.processNameMapping())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()))).result().headOption().flatMap((Function1 & Serializable & scala.Serializable)x0$3 -> {
            DBIOAction dBIOAction;
            Option option = x0$3;
            if (option instanceof Some) {
                dBIOAction = this.profile().api().DBIO().failed((Throwable)new ProcessDBQueryRepository.ProcessAlreadyExists(newName.value()));
            } else if (None$.MODULE$.equals(option)) {
                dBIOAction = this.profile().api().jdbcActionExtensionMethods(this.profile().api().DBIO().seq((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DBIOAction[]{updateNameInProcess, updateNameInProcessJson, addCommentAction})).map((Function1 & Serializable & scala.Serializable)x$24 -> {
                    DBProcessRepository.$anonfun$renameProcess$14(x$24);
                    return BoxedUnit.UNIT;
                }, ExecutionContext.Implicits$.MODULE$.global())).transactionally();
            } else {
                throw new MatchError((Object)option);
            }
            return dBIOAction;
        }, ExecutionContext.Implicits$.MODULE$.global());
        return action;
    }

    public Instant now() {
        return Instant.now();
    }

    public FixedSqlAction<Object, NoStream, Effect.Write> changeVersionId(ProcessId processId, VersionId versionId, VersionId versionIdToUpdate) {
        return this.profile().api().queryUpdateActionExtensionMethods(this.processVersionsTableWithUnit().filter((Function1 & Serializable & scala.Serializable)v -> BooleanColumnExtensionMethods$.MODULE$.$amp$amp$extension(this.profile().api().booleanColumnExtensionMethods(new BaseColumnExtensionMethods(this.profile().api().columnExtensionMethods(v.id(), this.versionIdMapping())).$eq$eq$eq((Rep)this.profile().api().valueToConstColumn((Object)versionId, this.versionIdMapping()), OptionMapper2$.MODULE$.getOptionMapper2TT(this.versionIdMapping()))), new BaseColumnExtensionMethods(this.profile().api().columnExtensionMethods(v.processId(), this.processIdMapping())).$eq$eq$eq((Rep)this.profile().api().valueToConstColumn((Object)processId, this.processIdMapping()), OptionMapper2$.MODULE$.getOptionMapper2TT(this.processIdMapping())), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)this.profile().api().booleanColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).map((Function1 & Serializable & scala.Serializable)x$25 -> x$25.id(), Shape$.MODULE$.repColumnShape(this.versionIdMapping()))).update((Object)versionIdToUpdate);
    }

    private final DBIOAction addNewCommentToVersion$1(ProcessId processId, VersionId versionId, ProcessRepository.UpdateProcessAction updateProcessAction$1, LoggedUser loggedUser$2) {
        return this.newCommentAction(processId, (Function0<VersionId>)(Function0 & Serializable & scala.Serializable)() -> versionId, updateProcessAction$1.comment(), ExecutionContext.Implicits$.MODULE$.global(), loggedUser$2);
    }

    private final ProcessVersionEntityData createProcessVersionEntityData$1(VersionId version, String processingType, ProcessIdWithName processId$1, CanonicalProcess canonicalProcess$1, String userName$2, LoggedUser loggedUser$3) {
        return new ProcessVersionEntityData(version, processId$1.id(), (Option<CanonicalProcess>)new Some((Object)canonicalProcess$1), Timestamp.from(this.now()), userName$2, this.modelVersion.forProcessingType(processingType, loggedUser$3), (Option<ScenarioComponentsUsages>)new Some((Object)ScenarioComponentsUsagesHelper$.MODULE$.compute(canonicalProcess$1)));
    }

    private static final boolean isLastVersionContainsSameProcess$1(ProcessVersionEntityData lastVersion, CanonicalProcess canonicalProcess$1) {
        return lastVersion.json().contains((Object)canonicalProcess$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Option versionToInsert$1(Option latestProcessVersion, String processingType, boolean increaseVersionWhenJsonNotChanged$1, CanonicalProcess canonicalProcess$1, ProcessIdWithName processId$1, String userName$2, LoggedUser loggedUser$3) {
        boolean bl = false;
        Some some = null;
        Option option = latestProcessVersion;
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            ProcessVersionEntityData version = (ProcessVersionEntityData)some.value();
            if (DBProcessRepository.isLastVersionContainsSameProcess$1(version, canonicalProcess$1) && !increaseVersionWhenJsonNotChanged$1) {
                return None$.MODULE$;
            }
        }
        if (!bl) return new Some((Object)this.createProcessVersionEntityData$1(VersionId$.MODULE$.initialVersionId(), processingType, processId$1, canonicalProcess$1, userName$2, loggedUser$3));
        ProcessVersionEntityData version = (ProcessVersionEntityData)some.value();
        return new Some((Object)this.createProcessVersionEntityData$1(version.id().increase(), processingType, processId$1, canonicalProcess$1, userName$2, loggedUser$3));
    }

    public static final /* synthetic */ ProcessRepository.ProcessUpdated $anonfun$updateProcessInternal$9(ProcessEntityData process$1, Option latestProcessVersion$1, Option newProcessVersionOpt$1, int _) {
        return new ProcessRepository.ProcessUpdated(process$1.id(), (Option<VersionId>)latestProcessVersion$1.map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.id()), (Option<VersionId>)newProcessVersionOpt$1.map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.id()));
    }

    private final DBIOAction updateNameInSingleProcessVersion$1(ProcessVersionEntityData processVersion, ProcessEntityData process, ProcessName newName$1) {
        DBIOAction dBIOAction;
        Option<CanonicalProcess> option = processVersion.json();
        if (option instanceof Some) {
            Some some = (Some)option;
            CanonicalProcess json = (CanonicalProcess)some.value();
            CanonicalProcess updatedProcess = json.copy(json.metaData().copy(newName$1.value(), json.metaData().copy$default$2()), json.copy$default$2(), json.copy$default$3());
            Some x$1 = new Some((Object)updatedProcess);
            VersionId x$2 = processVersion.copy$default$1();
            ProcessId x$3 = processVersion.copy$default$2();
            Timestamp x$4 = processVersion.copy$default$4();
            String x$5 = processVersion.copy$default$5();
            Option<Object> x$6 = processVersion.copy$default$6();
            Option<ScenarioComponentsUsages> x$7 = processVersion.copy$default$7();
            ProcessVersionEntityData updatedProcessVersion = processVersion.copy(x$2, x$3, (Option<CanonicalProcess>)x$1, x$4, x$5, x$6, x$7);
            dBIOAction = this.profile().api().queryUpdateActionExtensionMethods(this.processVersionsTableWithScenarioJson().filter((Function1 & Serializable & scala.Serializable)version -> BooleanColumnExtensionMethods$.MODULE$.$amp$amp$extension(this.profile().api().booleanColumnExtensionMethods(new BaseColumnExtensionMethods(this.profile().api().columnExtensionMethods(version.id(), this.versionIdMapping())).$eq$eq$eq((Rep)this.profile().api().valueToConstColumn((Object)processVersion.id(), this.versionIdMapping()), OptionMapper2$.MODULE$.getOptionMapper2TT(this.versionIdMapping()))), new BaseColumnExtensionMethods(this.profile().api().columnExtensionMethods(version.processId(), this.processIdMapping())).$eq$eq$eq((Rep)this.profile().api().valueToConstColumn((Object)process.id(), this.processIdMapping()), OptionMapper2$.MODULE$.getOptionMapper2TT(this.processIdMapping())), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)this.profile().api().booleanColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition())).update((Object)updatedProcessVersion);
        } else if (None$.MODULE$.equals(option)) {
            dBIOAction = this.profile().api().DBIO().successful((Object)BoxedUnit.UNIT);
        } else {
            throw new MatchError(option);
        }
        return dBIOAction;
    }

    public static final /* synthetic */ void $anonfun$renameProcess$14(BoxedUnit x$24) {
    }

    public DBProcessRepository(DbRef dbRef, ProcessingTypeDataProvider<Object, ?> modelVersion) {
        this.dbRef = dbRef;
        this.modelVersion = modelVersion;
        BaseEntityFactory.$init$(this);
        ProcessEntityFactory.$init$(this);
        CommentEntityFactory.$init$(this);
        ProcessVersionEntityFactory.$init$(this);
        EnvironmentsEntityFactory.$init$(this);
        ProcessActionEntityFactory.$init$(this);
        TagsEntityFactory.$init$(this);
        AttachmentEntityFactory.$init$(this);
        DeploymentEntityFactory.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        CommentActions.$init$(this);
        Repository.$init$(this);
        ProcessDBQueryRepository.$init$(this);
    }
}

