/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.statistics;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import pl.touk.nussknacker.ui.config.UsageStatisticsReportsConfig;
import pl.touk.nussknacker.ui.db.DBIOActionExtensions;
import pl.touk.nussknacker.ui.process.repository.DBIOActionRunner;
import pl.touk.nussknacker.ui.statistics.CannotGenerateStatisticsError$;
import pl.touk.nussknacker.ui.statistics.Fingerprint;
import pl.touk.nussknacker.ui.statistics.StatisticError;
import pl.touk.nussknacker.ui.statistics.repository.FingerprintRepository;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Random$;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import slick.dbio.DBIOAction;
import slick.dbio.Effect;
import slick.dbio.NoStream;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b\u0001\u0002\u0006\f\u0001YA\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\t\u000b\u0002\u0011\t\u0011)A\u0006\r\"AA\n\u0001B\u0001B\u0003-Q\nC\u0003U\u0001\u0011\u0005Q\u000bC\u0003]\u0001\u0011\u0005Q\fC\u0003}\u0001\u0011%Q\u0010\u0003\u0004\u0000\u0001\u0011%\u0011\u0011\u0001\u0005\b\u0003\u0017\u0001A\u0011BA\u0007\u0011\u001d\t\t\u0003\u0001C\u0005\u0003G\u0011!CR5oO\u0016\u0014\bO]5oiN+'O^5dK*\u0011A\"D\u0001\u000bgR\fG/[:uS\u000e\u001c(B\u0001\b\u0010\u0003\t)\u0018N\u0003\u0002\u0011#\u0005Ya.^:tW:\f7m[3s\u0015\t\u00112#\u0001\u0003u_V\\'\"\u0001\u000b\u0002\u0005Ad7\u0001A\n\u0005\u0001]ir\u0005\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012D\u0001\u0004B]f\u0014VM\u001a\t\u0003=\u0015j\u0011a\b\u0006\u0003A\u0005\nAb]2bY\u0006dwnZ4j]\u001eT!AI\u0012\u0002\u0011QL\b/Z:bM\u0016T\u0011\u0001J\u0001\u0004G>l\u0017B\u0001\u0014 \u0005-a\u0015M_=M_\u001e<\u0017N\\4\u0011\u0005!ZS\"A\u0015\u000b\u0005)j\u0011A\u00013c\u0013\ta\u0013F\u0001\u000bE\u0005&{\u0015i\u0019;j_:,\u0005\u0010^3og&|gn]\u0001\u0016M&tw-\u001a:qe&tGOU3q_NLGo\u001c:z!\ry#\u0007N\u0007\u0002a)\u0011\u0011gC\u0001\u000be\u0016\u0004xn]5u_JL\u0018BA\u001a1\u0005U1\u0015N\\4feB\u0014\u0018N\u001c;SKB|7/\u001b;pef\u0004\"!\u000e\"\u000f\u0005YzdBA\u001c=\u001d\tA4(D\u0001:\u0015\tQT#\u0001\u0004=e>|GOP\u0005\u0002U%\u0011QHP\u0001\u0005kRLGNC\u0001+\u0013\t\u0001\u0015)A\nE\u0005&{\u0015i\u0019;j_:Len\u001d;b]\u000e,7O\u0003\u0002>}%\u00111\t\u0012\u0002\u0003\t\nS!\u0001Q!\u0002\u0005\u0015\u001c\u0007CA$K\u001b\u0005A%BA%\u001a\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003\u0017\"\u0013\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002\u0015\u0011\u0014\u0017n\u001c*v]:,'\u000f\u0005\u0002O%6\tqJ\u0003\u00022!*\u0011\u0011+D\u0001\baJ|7-Z:t\u0013\t\u0019vJ\u0001\tE\u0005&{\u0015i\u0019;j_:\u0014VO\u001c8fe\u00061A(\u001b8jiz\"\"AV.\u0015\u0007]K&\f\u0005\u0002Y\u00015\t1\u0002C\u0003F\t\u0001\u000fa\tC\u0003M\t\u0001\u000fQ\nC\u0003.\t\u0001\u0007a&A\u0006gS:<WM\u001d9sS:$Hc\u00010qoB\u0019qiX1\n\u0005\u0001D%A\u0002$viV\u0014X\r\u0005\u0003cO*lgBA2f\u001d\tAD-C\u0001\u001b\u0013\t1\u0017$A\u0004qC\u000e\\\u0017mZ3\n\u0005!L'AB#ji\",'O\u0003\u0002g3A\u0011\u0001l[\u0005\u0003Y.\u0011ab\u0015;bi&\u001cH/[2FeJ|'\u000f\u0005\u0002Y]&\u0011qn\u0003\u0002\f\r&tw-\u001a:qe&tG\u000fC\u0003r\u000b\u0001\u0007!/\u0001\u0004d_:4\u0017n\u001a\t\u0003gVl\u0011\u0001\u001e\u0006\u0003c6I!A\u001e;\u00039U\u001b\u0018mZ3Ti\u0006$\u0018n\u001d;jGN\u0014V\r]8siN\u001cuN\u001c4jO\")\u00010\u0002a\u0001s\u0006\u0019b-\u001b8hKJ\u0004(/\u001b8u\r&dWMT1nKB\u0011\u0001L_\u0005\u0003w.\u0011\u0001BR5mK:\u000bW.Z\u0001\u0010M\u0016$8\r[(s\u000f\u0016tWM]1uKR\u0011aL \u0005\u0006q\u001a\u0001\r!_\u0001\u0018e\u0016\fGMR5oO\u0016\u0014\bO]5oi\u001a\u0013x.\u001c$jY\u0016$B!a\u0001\u0002\nA!\u0001$!\u0002n\u0013\r\t9!\u0007\u0002\u0007\u001fB$\u0018n\u001c8\t\u000ba<\u0001\u0019A=\u0002\u001f\u0019LgnZ3saJLg\u000e\u001e$jY\u0016$B!a\u0004\u0002 A!\u0011\u0011CA\u000e\u001b\t\t\u0019B\u0003\u0003\u0002\u0016\u0005]\u0011AA5p\u0015\t\tI\"\u0001\u0003kCZ\f\u0017\u0002BA\u000f\u0003'\u0011AAR5mK\")\u0001\u0010\u0003a\u0001s\u0006\t\"/\u00198e_64\u0015N\\4feB\u0014\u0018N\u001c;\u0016\u00035\u0004")
public class FingerprintService
implements LazyLogging,
DBIOActionExtensions {
    private final FingerprintRepository<DBIOAction> fingerprintRepository;
    private final ExecutionContext ec;
    private final DBIOActionRunner dbioRunner;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public <T> DBIOActionExtensions.RunExtension<T> RunExtension(DBIOAction<T, NoStream, Effect.All> action) {
        return DBIOActionExtensions.RunExtension$(this, action);
    }

    private Logger logger$lzycompute() {
        FingerprintService fingerprintService = this;
        synchronized (fingerprintService) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public Future<Either<StatisticError, Fingerprint>> fingerprint(UsageStatisticsReportsConfig config, String fingerprintFileName) {
        Future future;
        Option option = config.fingerprint().filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isBlank()));
        if (option instanceof Some) {
            Some some = (Some)option;
            String fingerprintFromConfig = (String)some.value();
            future = Future$.MODULE$.successful((Object)package$.MODULE$.Right().apply((Object)new Fingerprint(fingerprintFromConfig)));
        } else if (None$.MODULE$.equals(option)) {
            future = this.fetchOrGenerate(fingerprintFileName);
        } else {
            throw new MatchError((Object)option);
        }
        return future;
    }

    private Future<Either<StatisticError, Fingerprint>> fetchOrGenerate(String fingerprintFileName) {
        return this.RunExtension(this.fingerprintRepository.read()).run(this.dbioRunner).flatMap((Function1 & Serializable & scala.Serializable)dbFingerprint -> {
            Future future;
            Option option = dbFingerprint;
            if (option instanceof Some) {
                Some some = (Some)option;
                String dbValue = ((Fingerprint)some.value()).value();
                future = Future$.MODULE$.successful((Object)package$.MODULE$.Right().apply((Object)new Fingerprint(dbValue)));
            } else if (None$.MODULE$.equals(option)) {
                String generated = ((Fingerprint)this.readFingerprintFromFile(fingerprintFileName).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Fingerprint(this.randomFingerprint()))).value();
                future = this.RunExtension($this.fingerprintRepository.readOrSave(generated).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Left left;
                    Either either = x0$1;
                    if (either instanceof Left) {
                        BoxedUnit boxedUnit;
                        if (this.logger().underlying().isWarnEnabled()) {
                            this.logger().underlying().warn("Cannot persist fingerprint in DB");
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        left = package$.MODULE$.Left().apply((Object)CannotGenerateStatisticsError$.MODULE$);
                    } else if (either instanceof Right) {
                        BoxedUnit boxedUnit;
                        Right right = (Right)either;
                        String fingerprint = ((Fingerprint)right.value()).value();
                        if (this.logger().underlying().isDebugEnabled()) {
                            this.logger().underlying().debug("Saved fingerprint {}", new Object[]{fingerprint});
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        left = package$.MODULE$.Right().apply((Object)new Fingerprint(fingerprint));
                    } else {
                        throw new MatchError((Object)either);
                    }
                    return left;
                }, $this.ec)).runInTransaction($this.dbioRunner);
            } else {
                throw new MatchError((Object)option);
            }
            return future.map((Function1 & Serializable & scala.Serializable)result -> result, $this.ec);
        }, this.ec);
    }

    private Option<Fingerprint> readFingerprintFromFile(String fingerprintFileName) {
        None$ none$;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> FileUtils.readFileToString((File)this.fingerprintFile(fingerprintFileName), (Charset)StandardCharsets.UTF_8));
        if (try_ instanceof Failure) {
            none$ = None$.MODULE$;
        } else if (try_ instanceof Success) {
            Success success = (Success)try_;
            String value = (String)success.value();
            none$ = new Some((Object)new Fingerprint(value.trim()));
        } else {
            throw new MatchError((Object)try_);
        }
        return none$;
    }

    private File fingerprintFile(String fingerprintFileName) {
        return new File((String)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)System.getProperty("java.io.tmpdir"))).toOption().flatten(Predef$.MODULE$.$conforms()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "/tmp"), fingerprintFileName);
    }

    private String randomFingerprint() {
        return new StringBuilder(4).append("gen-").append(Random$.MODULE$.alphanumeric().take(10).mkString()).toString();
    }

    public FingerprintService(FingerprintRepository<DBIOAction> fingerprintRepository, ExecutionContext ec, DBIOActionRunner dbioRunner) {
        this.fingerprintRepository = fingerprintRepository;
        this.ec = ec;
        this.dbioRunner = dbioRunner;
        LazyLogging.$init$((LazyLogging)this);
        DBIOActionExtensions.$init$(this);
    }
}

