/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.api;

import cats.data.NonEmptyList;
import java.io.Serializable;
import pl.touk.nussknacker.engine.api.deployment.DeploymentStatus;
import pl.touk.nussknacker.engine.api.deployment.ProblemDeploymentStatus$;
import pl.touk.nussknacker.engine.api.process.ProcessName;
import pl.touk.nussknacker.engine.newdeployment.DeploymentId;
import pl.touk.nussknacker.restmodel.validation.ValidationResults;
import pl.touk.nussknacker.security.AuthCredentials;
import pl.touk.nussknacker.ui.api.BaseHttpService;
import pl.touk.nussknacker.ui.api.description.DeploymentApiEndpoints;
import pl.touk.nussknacker.ui.api.description.DeploymentApiEndpoints$Dtos$DeploymentOfArchivedScenarioError$;
import pl.touk.nussknacker.ui.api.description.DeploymentApiEndpoints$Dtos$DeploymentOfFragmentError$;
import pl.touk.nussknacker.ui.api.description.DeploymentApiEndpoints$Dtos$NoPermissionError$;
import pl.touk.nussknacker.ui.process.newactivity.ActivityService;
import pl.touk.nussknacker.ui.process.newactivity.ActivityService$;
import pl.touk.nussknacker.ui.process.newdeployment.DeploymentService;
import pl.touk.nussknacker.ui.process.newdeployment.DeploymentService$DeploymentOfArchivedScenarioError$;
import pl.touk.nussknacker.ui.process.newdeployment.DeploymentService$DeploymentOfFragmentError$;
import pl.touk.nussknacker.ui.process.newdeployment.DeploymentService$NoPermissionError$;
import pl.touk.nussknacker.ui.process.newdeployment.RunDeploymentCommand;
import pl.touk.nussknacker.ui.security.api.AuthManager;
import pl.touk.nussknacker.ui.security.api.LoggedUser;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import sttp.tapir.EndpointInput;

@ScalaSignature(bytes="\u0006\u0001-3A\u0001C\u0005\u0001)!A\u0011\u0004\u0001B\u0001B\u0003%!\u0004\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003#\u0011!Q\u0003A!A!\u0002\u0013Y\u0003\u0002C\u0019\u0001\u0005\u0003\u0005\u000b1\u0002\u001a\t\u000bi\u0002A\u0011A\u001e\t\u000f\t\u0003!\u0019!C\u0005\u0007\"1!\n\u0001Q\u0001\n\u0011\u0013\u0001\u0004R3qY>LX.\u001a8u\u0003BL\u0007\n\u001e;q'\u0016\u0014h/[2f\u0015\tQ1\"A\u0002ba&T!\u0001D\u0007\u0002\u0005UL'B\u0001\b\u0010\u0003-qWo]:l]\u0006\u001c7.\u001a:\u000b\u0005A\t\u0012\u0001\u0002;pk.T\u0011AE\u0001\u0003a2\u001c\u0001a\u0005\u0002\u0001+A\u0011acF\u0007\u0002\u0013%\u0011\u0001$\u0003\u0002\u0010\u0005\u0006\u001cX\r\u0013;uaN+'O^5dK\u0006Y\u0011-\u001e;i\u001b\u0006t\u0017mZ3s!\tYr$D\u0001\u001d\u0015\tQQD\u0003\u0002\u001f\u0017\u0005A1/Z2ve&$\u00180\u0003\u0002!9\tY\u0011)\u001e;i\u001b\u0006t\u0017mZ3s\u0003=\t7\r^5wSRL8+\u001a:wS\u000e,\u0007CA\u0012)\u001b\u0005!#BA\u0013'\u0003-qWm^1di&4\u0018\u000e^=\u000b\u0005\u001dZ\u0011a\u00029s_\u000e,7o]\u0005\u0003S\u0011\u0012q\"Q2uSZLG/_*feZL7-Z\u0001\u0012I\u0016\u0004Hn\\=nK:$8+\u001a:wS\u000e,\u0007C\u0001\u00170\u001b\u0005i#B\u0001\u0018'\u00035qWm\u001e3fa2|\u00170\\3oi&\u0011\u0001'\f\u0002\u0012\t\u0016\u0004Hn\\=nK:$8+\u001a:wS\u000e,\u0017\u0001E3yK\u000e,H/[8o\u0007>tG/\u001a=u!\t\u0019\u0004(D\u00015\u0015\t)d'\u0001\u0006d_:\u001cWO\u001d:f]RT\u0011aN\u0001\u0006g\u000e\fG.Y\u0005\u0003sQ\u0012\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002\rqJg.\u001b;?)\u0011at\bQ!\u0015\u0005ur\u0004C\u0001\f\u0001\u0011\u0015\tT\u0001q\u00013\u0011\u0015IR\u00011\u0001\u001b\u0011\u0015\tS\u00011\u0001#\u0011\u0015QS\u00011\u0001,\u0003%)g\u000e\u001a9pS:$8/F\u0001E!\t)\u0005*D\u0001G\u0015\t9\u0015\"A\u0006eKN\u001c'/\u001b9uS>t\u0017BA%G\u0005Y!U\r\u001d7ps6,g\u000e^!qS\u0016sG\r]8j]R\u001c\u0018AC3oIB|\u0017N\u001c;tA\u0001")
public class DeploymentApiHttpService
extends BaseHttpService {
    private final ActivityService activityService;
    private final DeploymentService deploymentService;
    private final ExecutionContext executionContext;
    private final DeploymentApiEndpoints endpoints;

    private DeploymentApiEndpoints endpoints() {
        return this.endpoints;
    }

    public DeploymentApiHttpService(AuthManager authManager, ActivityService activityService, DeploymentService deploymentService, ExecutionContext executionContext) {
        this.activityService = activityService;
        this.deploymentService = deploymentService;
        this.executionContext = executionContext;
        super(authManager, executionContext);
        this.endpoints = new DeploymentApiEndpoints((EndpointInput<AuthCredentials>)authManager.authenticationEndpointInput());
        this.expose(this.ServerLogicExtension(this.endpoints().runDeploymentEndpoint().serverSecurityLogic((Function1 & Serializable & scala.Serializable)credentials -> this.authorizeKnownUser((AuthCredentials)credentials))).serverLogicFlatErrors((Function1 & Serializable & scala.Serializable)loggedUser -> (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            DeploymentId deploymentId = (DeploymentId)tuple2._1();
            DeploymentApiEndpoints.Dtos.RunDeploymentRequest request = (DeploymentApiEndpoints.Dtos.RunDeploymentRequest)tuple2._2();
            Future future = $this.activityService.processCommand(new RunDeploymentCommand(deploymentId, request.scenarioName(), request.nodesDeploymentData(), (LoggedUser)loggedUser), request.comment(), ActivityService$.MODULE$.fromRunDeploymentCommand()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.left().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                DeploymentApiEndpoints.Dtos.RunDeploymentError runDeploymentError;
                ActivityService.ActivityError activityError = x0$2;
                if (activityError instanceof ActivityService.UnderlyingServiceError) {
                    DeploymentApiEndpoints.Dtos.RunDeploymentError runDeploymentError2;
                    ActivityService.UnderlyingServiceError underlyingServiceError = (ActivityService.UnderlyingServiceError)activityError;
                    DeploymentService.RunDeploymentError err = (DeploymentService.RunDeploymentError)underlyingServiceError.error();
                    DeploymentService.RunDeploymentError runDeploymentError3 = err;
                    if (runDeploymentError3 instanceof DeploymentService.ConflictingDeploymentIdError) {
                        DeploymentService.ConflictingDeploymentIdError conflictingDeploymentIdError = (DeploymentService.ConflictingDeploymentIdError)runDeploymentError3;
                        DeploymentId id = conflictingDeploymentIdError.id();
                        runDeploymentError2 = new DeploymentApiEndpoints.Dtos.ConflictingDeploymentIdError(id);
                    } else if (runDeploymentError3 instanceof DeploymentService.ConcurrentDeploymentsForScenarioArePerformedError) {
                        DeploymentService.ConcurrentDeploymentsForScenarioArePerformedError concurrentDeploymentsForScenarioArePerformedError = (DeploymentService.ConcurrentDeploymentsForScenarioArePerformedError)runDeploymentError3;
                        ProcessName scenarioName = concurrentDeploymentsForScenarioArePerformedError.scenarioName();
                        NonEmptyList<DeploymentId> concurrentDeploymentsIds = concurrentDeploymentsForScenarioArePerformedError.concurrentDeploymentsIds();
                        runDeploymentError2 = new DeploymentApiEndpoints.Dtos.ConcurrentDeploymentsForScenarioArePerformedError(scenarioName, concurrentDeploymentsIds);
                    } else if (runDeploymentError3 instanceof DeploymentService.ScenarioNotFoundError) {
                        DeploymentService.ScenarioNotFoundError scenarioNotFoundError = (DeploymentService.ScenarioNotFoundError)runDeploymentError3;
                        ProcessName scenarioName = scenarioNotFoundError.scenarioName();
                        runDeploymentError2 = new DeploymentApiEndpoints.Dtos.ScenarioNotFoundError(scenarioName);
                    } else if (DeploymentService$DeploymentOfFragmentError$.MODULE$.equals(runDeploymentError3)) {
                        runDeploymentError2 = DeploymentApiEndpoints$Dtos$DeploymentOfFragmentError$.MODULE$;
                    } else if (DeploymentService$DeploymentOfArchivedScenarioError$.MODULE$.equals(runDeploymentError3)) {
                        runDeploymentError2 = DeploymentApiEndpoints$Dtos$DeploymentOfArchivedScenarioError$.MODULE$;
                    } else if (DeploymentService$NoPermissionError$.MODULE$.equals(runDeploymentError3)) {
                        runDeploymentError2 = DeploymentApiEndpoints$Dtos$NoPermissionError$.MODULE$;
                    } else if (runDeploymentError3 instanceof DeploymentService.ScenarioGraphValidationError) {
                        DeploymentService.ScenarioGraphValidationError scenarioGraphValidationError = (DeploymentService.ScenarioGraphValidationError)runDeploymentError3;
                        ValidationResults.ValidationErrors errors = scenarioGraphValidationError.errors();
                        runDeploymentError2 = new DeploymentApiEndpoints.Dtos.ScenarioGraphValidationError(errors);
                    } else if (runDeploymentError3 instanceof DeploymentService.DeployValidationError) {
                        DeploymentService.DeployValidationError deployValidationError = (DeploymentService.DeployValidationError)runDeploymentError3;
                        String message = deployValidationError.message();
                        runDeploymentError2 = new DeploymentApiEndpoints.Dtos.DeployValidationError(message);
                    } else {
                        throw new MatchError((Object)runDeploymentError3);
                    }
                    runDeploymentError = runDeploymentError2;
                } else if (activityError instanceof ActivityService.CommentValidationError) {
                    ActivityService.CommentValidationError commentValidationError = (ActivityService.CommentValidationError)activityError;
                    String message = commentValidationError.message();
                    runDeploymentError = new DeploymentApiEndpoints.Dtos.CommentValidationError(message);
                } else {
                    throw new MatchError((Object)activityError);
                }
                return runDeploymentError;
            }), $this.executionContext);
            return future;
        }));
        this.expose(this.ServerLogicExtension(this.endpoints().getDeploymentStatusEndpoint().serverSecurityLogic((Function1 & Serializable & scala.Serializable)credentials -> this.authorizeKnownUser((AuthCredentials)credentials))).serverLogicFlatErrors((Function1 & Serializable & scala.Serializable)loggedUser -> (Function1 & Serializable & scala.Serializable)deploymentId -> $this.deploymentService.getDeploymentStatus((DeploymentId)deploymentId, (LoggedUser)loggedUser).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.map((Function1 & Serializable & scala.Serializable)statusWithModifiedAt -> new DeploymentApiEndpoints.Dtos.GetDeploymentStatusResponse(((DeploymentStatus)statusWithModifiedAt.value()).name(), (Option<String>)ProblemDeploymentStatus$.MODULE$.extractDescription((DeploymentStatus)statusWithModifiedAt.value()), statusWithModifiedAt.modifiedAt().toInstant())).left().map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            scala.Serializable serializable;
            DeploymentService.GetDeploymentStatusError getDeploymentStatusError = x0$3;
            if (getDeploymentStatusError instanceof DeploymentService.DeploymentNotFoundError) {
                DeploymentService.DeploymentNotFoundError deploymentNotFoundError = (DeploymentService.DeploymentNotFoundError)getDeploymentStatusError;
                DeploymentId id = deploymentNotFoundError.id();
                serializable = new DeploymentApiEndpoints.Dtos.DeploymentNotFoundError(id);
            } else if (DeploymentService$NoPermissionError$.MODULE$.equals(getDeploymentStatusError)) {
                serializable = DeploymentApiEndpoints$Dtos$NoPermissionError$.MODULE$;
            } else {
                throw new MatchError((Object)getDeploymentStatusError);
            }
            return serializable;
        }), $this.executionContext)));
    }
}

