/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.db.timeseries.questdb;

import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.wal.WalPurgeJob;
import io.questdb.griffin.SqlExecutionContext;
import java.io.Serializable;
import java.time.Clock;
import java.time.temporal.ChronoUnit;
import pl.touk.nussknacker.ui.db.timeseries.questdb.QuestDbExtensions$;
import pl.touk.nussknacker.ui.db.timeseries.questdb.RetentionTask$;
import pl.touk.nussknacker.ui.db.timeseries.questdb.ThreadAwareObjectPool;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rd!B\f\u0019\u0001a1\u0003\u0002C\u001c\u0001\u0005\u000b\u0007I\u0011B\u001d\t\u0011\r\u0003!\u0011!Q\u0001\niB\u0001\u0002\u0012\u0001\u0003\u0006\u0004%I!\u0012\u0005\t#\u0002\u0011\t\u0011)A\u0005\r\"A!\u000b\u0001BC\u0002\u0013%1\u000b\u0003\u0005_\u0001\t\u0005\t\u0015!\u0003U\u0011!y\u0006A!b\u0001\n\u0013\u0001\u0007\u0002C5\u0001\u0005\u0003\u0005\u000b\u0011B1\t\u000b)\u0004A\u0011A6\t\u000fE\u0004!\u0019!C\u0005e\"1\u0011\u0010\u0001Q\u0001\nMDqA\u001f\u0001C\u0002\u0013%Q\t\u0003\u0004|\u0001\u0001\u0006IA\u0012\u0005\u0006y\u0002!\t! \u0005\u0007\u0003\u0007\u0001A\u0011A?\t\u000f\u0005\u0015\u0001\u0001\"\u0003\u0002\b!9\u00111\u0006\u0001\u0005\n\u00055raBA&1!\u0005\u0011Q\n\u0004\u0007/aA\t!a\u0014\t\r)\u001cB\u0011AA)\u0011\u001d\t\u0019f\u0005C\u0005\u0003+Bq!!\u0018\u0014\t\u0013\tyFA\u0007SKR,g\u000e^5p]R\u000b7o\u001b\u0006\u00033i\tq!];fgR$'M\u0003\u0002\u001c9\u0005QA/[7fg\u0016\u0014\u0018.Z:\u000b\u0005uq\u0012A\u00013c\u0015\ty\u0002%\u0001\u0002vS*\u0011\u0011EI\u0001\f]V\u001c8o\u001b8bG.,'O\u0003\u0002$I\u0005!Ao\\;l\u0015\u0005)\u0013A\u00019m'\r\u0001q%\f\t\u0003Q-j\u0011!\u000b\u0006\u0002U\u0005)1oY1mC&\u0011A&\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\u00059*T\"A\u0018\u000b\u0005A\n\u0014\u0001D:dC2\fGn\\4hS:<'B\u0001\u001a4\u0003!!\u0018\u0010]3tC\u001a,'\"\u0001\u001b\u0002\u0007\r|W.\u0003\u00027_\tYA*\u0019>z\u0019><w-\u001b8h\u0003\u0019)gnZ5oK\u000e\u0001Q#\u0001\u001e\u0011\u0005m\nU\"\u0001\u001f\u000b\u0005ur\u0014!B2bSJ|'BA\r@\u0015\u0005\u0001\u0015AA5p\u0013\t\u0011EHA\u0006DC&\u0014x.\u00128hS:,\u0017aB3oO&tW\rI\u0001\ni\u0006\u0014G.\u001a(b[\u0016,\u0012A\u0012\t\u0003\u000f:s!\u0001\u0013'\u0011\u0005%KS\"\u0001&\u000b\u0005-C\u0014A\u0002\u001fs_>$h(\u0003\u0002NS\u00051\u0001K]3eK\u001aL!a\u0014)\u0003\rM#(/\u001b8h\u0015\ti\u0015&\u0001\u0006uC\ndWMT1nK\u0002\nab]9m\u0007>tG/\u001a=u!>|G.F\u0001U!\r)f\u000bW\u0007\u00021%\u0011q\u000b\u0007\u0002\u0016)\"\u0014X-\u00193Bo\u0006\u0014Xm\u00142kK\u000e$\bk\\8m!\tIF,D\u0001[\u0015\tYf(A\u0004he&4g-\u001b8\n\u0005uS&aE*rY\u0016CXmY;uS>t7i\u001c8uKb$\u0018aD:rY\u000e{g\u000e^3yiB{w\u000e\u001c\u0011\u0002\u000b\rdwnY6\u0016\u0003\u0005\u0004\"AY4\u000e\u0003\rT!\u0001Z3\u0002\tQLW.\u001a\u0006\u0002M\u0006!!.\u0019<b\u0013\tA7MA\u0003DY>\u001c7.\u0001\u0004dY>\u001c7\u000eI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b1lgn\u001c9\u0011\u0005U\u0003\u0001\"B\u001c\n\u0001\u0004Q\u0004\"\u0002#\n\u0001\u00041\u0005\"\u0002*\n\u0001\u0004!\u0006\"B0\n\u0001\u0004\t\u0017aC<bYB+(oZ3K_\n,\u0012a\u001d\t\u0003i^l\u0011!\u001e\u0006\u0003mr\n1a^1m\u0013\tAXOA\u0006XC2\u0004VO]4f\u0015>\u0014\u0017\u0001D<bYB+(oZ3K_\n\u0004\u0013\u0001G:fY\u0016\u001cG/\u00117m!\u0006\u0014H/\u001b;j_:\u001c\u0018+^3ss\u0006I2/\u001a7fGR\fE\u000e\u001c)beRLG/[8ogF+XM]=!\u0003%\u0011XO\\+og\u00064W\rF\u0001\u007f!\tAs0C\u0002\u0002\u0002%\u0012A!\u00168ji\u0006)1\r\\8tK\u0006iq-\u001a;QCJ$\u0018\u000e^5p]N$B!!\u0003\u0002(A1\u00111BA\u000b\u00037qA!!\u0004\u0002\u00129\u0019\u0011*a\u0004\n\u0003)J1!a\u0005*\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0006\u0002\u001a\t!A*[:u\u0015\r\t\u0019\"\u000b\t\u0007Q\u0005ua)!\t\n\u0007\u0005}\u0011F\u0001\u0004UkBdWM\r\t\u0004Q\u0005\r\u0012bAA\u0013S\t!Aj\u001c8h\u0011\u0019\tI\u0003\u0005a\u00011\u0006Q1/\u001d7D_:$X\r\u001f;\u0002/\u0015t7/\u001e:f\u001f:,\u0007+\u0019:uSRLwN\\#ySN$HCBA\u0018\u0003\u000b\n9\u0005E\u0003)\u0003c\t)$C\u0002\u00024%\u0012aa\u00149uS>t\u0007#BA\u001c\u0003\u00032UBAA\u001d\u0015\u0011\tY$!\u0010\u0002\t\u0011\fG/\u0019\u0006\u0003\u0003\u007f\tAaY1ug&!\u00111IA\u001d\u00051quN\\#naRLH*[:u\u0011\u0015y\u0016\u00031\u0001b\u0011\u001d\tI%\u0005a\u0001\u0003\u0013\tQ\"\u00197m!\u0006\u0014H/\u001b;j_:\u001c\u0018!\u0004*fi\u0016tG/[8o)\u0006\u001c8\u000e\u0005\u0002V'M\u00111c\n\u000b\u0003\u0003\u001b\n\u0001DY;jY\u0012$%o\u001c9QCJ$\u0018\u000e^5p]N\fV/\u001a:z)\u00151\u0015qKA-\u0011\u0015!U\u00031\u0001G\u0011\u001d\tY&\u0006a\u0001\u0003k\t!\u0002]1si&$\u0018n\u001c8t\u0003u\u0011W/\u001b7e'\u0016dWm\u0019;BY2\u0004\u0016M\u001d;ji&|gn])vKJLHc\u0001$\u0002b!)AI\u0006a\u0001\r\u0002")
public class RetentionTask
implements LazyLogging {
    private final CairoEngine engine;
    private final String tableName;
    private final ThreadAwareObjectPool<SqlExecutionContext> sqlContextPool;
    private final Clock clock;
    private final WalPurgeJob walPurgeJob;
    private final String selectAllPartitionsQuery;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        RetentionTask retentionTask = this;
        synchronized (retentionTask) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private CairoEngine engine() {
        return this.engine;
    }

    private String tableName() {
        return this.tableName;
    }

    private ThreadAwareObjectPool<SqlExecutionContext> sqlContextPool() {
        return this.sqlContextPool;
    }

    private Clock clock() {
        return this.clock;
    }

    private WalPurgeJob walPurgeJob() {
        return this.walPurgeJob;
    }

    private String selectAllPartitionsQuery() {
        return this.selectAllPartitionsQuery;
    }

    public void runUnsafe() {
        Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Cleaning up old data");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            SqlExecutionContext sqlContext = this.sqlContextPool().get();
            List<Tuple2<String, Object>> allPartitions = this.getPartitions(sqlContext);
            this.ensureOnePartitionExist(this.clock(), allPartitions).foreach((Function1 & Serializable & scala.Serializable)partitionsToDrop -> {
                RetentionTask.$anonfun$runUnsafe$2(this, sqlContext, partitionsToDrop);
                return BoxedUnit.UNIT;
            });
            return this.walPurgeJob().run(2);
        });
    }

    public void close() {
        this.walPurgeJob().close();
    }

    private List<Tuple2<String, Object>> getPartitions(SqlExecutionContext sqlContext) {
        return QuestDbExtensions$.MODULE$.RecordCursorFactoryExtension(this.engine().select((CharSequence)this.selectAllPartitionsQuery(), sqlContext)).fetch(sqlContext, (Function1 & Serializable & scala.Serializable)record -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((Object)record.getStrA(0)).toString()), (Object)BoxesRunTime.boxToLong((long)(record.getTimestamp(1) / 1000L))));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Option<NonEmptyList<String>> ensureOnePartitionExist(Clock clock, List<Tuple2<String, Object>> allPartitions) {
        long todayInMillis = clock.instant().truncatedTo(ChronoUnit.DAYS).toEpochMilli();
        Tuple2 tuple2 = allPartitions.span((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)RetentionTask.$anonfun$ensureOnePartitionExist$1(todayInMillis, x$1)));
        if (tuple2 == null) return None$.MODULE$;
        List oldPartitions = (List)tuple2._1();
        List list = (List)tuple2._2();
        if (!(oldPartitions instanceof .colon.colon)) return None$.MODULE$;
        .colon.colon colon2 = (.colon.colon)oldPartitions;
        if (!(list instanceof .colon.colon)) return None$.MODULE$;
        return NonEmptyList$.MODULE$.fromList((List)colon2.map((Function1 & Serializable & scala.Serializable)x$2 -> (String)x$2._1(), List$.MODULE$.canBuildFrom()));
    }

    public static final /* synthetic */ void $anonfun$runUnsafe$2(RetentionTask $this, SqlExecutionContext sqlContext$1, NonEmptyList partitionsToDrop) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        String query = RetentionTask$.MODULE$.pl$touk$nussknacker$ui$db$timeseries$questdb$RetentionTask$$buildDropPartitionsQuery($this.tableName(), (NonEmptyList<String>)partitionsToDrop);
        if ($this.logger().underlying().isInfoEnabled()) {
            $this.logger().underlying().info("Dropping old partitions: {}", new Object[]{query});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        $this.engine().ddl((CharSequence)query, sqlContext$1);
        if ($this.logger().underlying().isInfoEnabled()) {
            $this.logger().underlying().info("Dropping old partitions succeed");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ boolean $anonfun$ensureOnePartitionExist$1(long todayInMillis$1, Tuple2 x$1) {
        return x$1._2$mcJ$sp() < todayInMillis$1;
    }

    public RetentionTask(CairoEngine engine, String tableName, ThreadAwareObjectPool<SqlExecutionContext> sqlContextPool, Clock clock) {
        this.engine = engine;
        this.tableName = tableName;
        this.sqlContextPool = sqlContextPool;
        this.clock = clock;
        LazyLogging.$init$((LazyLogging)this);
        WalPurgeJob job = new WalPurgeJob(engine);
        engine.setWalPurgeJobRunLock(job.getRunLock());
        this.walPurgeJob = job;
        this.selectAllPartitionsQuery = RetentionTask$.MODULE$.pl$touk$nussknacker$ui$db$timeseries$questdb$RetentionTask$$buildSelectAllPartitionsQuery(tableName);
    }
}

