/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.db.timeseries.questdb;

import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.questdb.cairo.CairoEngine;
import io.questdb.griffin.SqlExecutionContext;
import java.io.Serializable;
import java.time.Clock;
import java.time.temporal.ChronoUnit;
import pl.touk.nussknacker.ui.db.timeseries.questdb.QuestDbExtensions$;
import pl.touk.nussknacker.ui.db.timeseries.questdb.RetentionTask$;
import pl.touk.nussknacker.ui.db.timeseries.questdb.ThreadAwareObjectPool;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%c!\u0002\u000b\u0016\u0001U\u0019\u0003\u0002\u0003\u001b\u0001\u0005\u000b\u0007I\u0011\u0002\u001c\t\u0011\u0001\u0003!\u0011!Q\u0001\n]B\u0001\"\u0011\u0001\u0003\u0006\u0004%IA\u0011\u0005\t\u001d\u0002\u0011\t\u0011)A\u0005\u0007\"Aq\n\u0001BC\u0002\u0013%\u0001\u000b\u0003\u0005\\\u0001\t\u0005\t\u0015!\u0003R\u0011!a\u0006A!b\u0001\n\u0013i\u0006\u0002\u00034\u0001\u0005\u0003\u0005\u000b\u0011\u00020\t\u000b\u001d\u0004A\u0011\u00015\t\u000f9\u0004!\u0019!C\u0005\u0005\"1q\u000e\u0001Q\u0001\n\rCQ\u0001\u001d\u0001\u0005\u0002EDQ!\u001e\u0001\u0005\nYDq!!\u0005\u0001\t\u0013\t\u0019bB\u0004\u00022UA\t!a\r\u0007\rQ)\u0002\u0012AA\u001b\u0011\u00199\u0007\u0003\"\u0001\u00028!9\u0011\u0011\b\t\u0005\n\u0005m\u0002bBA\"!\u0011%\u0011Q\t\u0002\u000e%\u0016$XM\u001c;j_:$\u0016m]6\u000b\u0005Y9\u0012aB9vKN$HM\u0019\u0006\u00031e\t!\u0002^5nKN,'/[3t\u0015\tQ2$\u0001\u0002eE*\u0011A$H\u0001\u0003k&T!AH\u0010\u0002\u00179,8o]6oC\u000e\\WM\u001d\u0006\u0003A\u0005\nA\u0001^8vW*\t!%\u0001\u0002qYN\u0019\u0001\u0001\n\u0016\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0003\u001d\nQa]2bY\u0006L!!\u000b\u0014\u0003\r\u0005s\u0017PU3g!\tY#'D\u0001-\u0015\tic&\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u00020a\u0005AA/\u001f9fg\u00064WMC\u00012\u0003\r\u0019w.\\\u0005\u0003g1\u00121\u0002T1{s2{wmZ5oO\u00061QM\\4j]\u0016\u001c\u0001!F\u00018!\tAd(D\u0001:\u0015\tQ4(A\u0003dC&\u0014xN\u0003\u0002\u0017y)\tQ(\u0001\u0002j_&\u0011q(\u000f\u0002\f\u0007\u0006L'o\\#oO&tW-A\u0004f]\u001eLg.\u001a\u0011\u0002\u0013Q\f'\r\\3OC6,W#A\"\u0011\u0005\u0011[eBA#J!\t1e%D\u0001H\u0015\tAU'\u0001\u0004=e>|GOP\u0005\u0003\u0015\u001a\na\u0001\u0015:fI\u00164\u0017B\u0001'N\u0005\u0019\u0019FO]5oO*\u0011!JJ\u0001\u000bi\u0006\u0014G.\u001a(b[\u0016\u0004\u0013AD:rY\u000e{g\u000e^3yiB{w\u000e\\\u000b\u0002#B\u0019!kU+\u000e\u0003UI!\u0001V\u000b\u0003+QC'/Z1e\u0003^\f'/Z(cU\u0016\u001cG\u000fU8pYB\u0011a+W\u0007\u0002/*\u0011\u0001lO\u0001\bOJLgMZ5o\u0013\tQvKA\nTc2,\u00050Z2vi&|gnQ8oi\u0016DH/A\btc2\u001cuN\u001c;fqR\u0004vn\u001c7!\u0003\u0015\u0019Gn\\2l+\u0005q\u0006CA0e\u001b\u0005\u0001'BA1c\u0003\u0011!\u0018.\\3\u000b\u0003\r\fAA[1wC&\u0011Q\r\u0019\u0002\u0006\u00072|7m[\u0001\u0007G2|7m\u001b\u0011\u0002\rqJg.\u001b;?)\u0015I'n\u001b7n!\t\u0011\u0006\u0001C\u00035\u0013\u0001\u0007q\u0007C\u0003B\u0013\u0001\u00071\tC\u0003P\u0013\u0001\u0007\u0011\u000bC\u0003]\u0013\u0001\u0007a,\u0001\rtK2,7\r^!mYB\u000b'\u000f^5uS>t7/U;fef\f\u0011d]3mK\u000e$\u0018\t\u001c7QCJ$\u0018\u000e^5p]N\fV/\u001a:zA\u0005I!/\u001e8V]N\fg-\u001a\u000b\u0002eB\u0011Qe]\u0005\u0003i\u001a\u0012A!\u00168ji\u0006iq-\u001a;QCJ$\u0018\u000e^5p]N$2a^A\u0007!\u0011AX0!\u0001\u000f\u0005e\\hB\u0001${\u0013\u00059\u0013B\u0001?'\u0003\u001d\u0001\u0018mY6bO\u0016L!A`@\u0003\t1K7\u000f\u001e\u0006\u0003y\u001a\u0002b!JA\u0002\u0007\u0006\u001d\u0011bAA\u0003M\t1A+\u001e9mKJ\u00022!JA\u0005\u0013\r\tYA\n\u0002\u0005\u0019>tw\r\u0003\u0004\u0002\u00105\u0001\r!V\u0001\u000bgFd7i\u001c8uKb$\u0018aF3ogV\u0014Xm\u00148f!\u0006\u0014H/\u001b;j_:,\u00050[:u)\u0019\t)\"a\u000b\u0002.A)Q%a\u0006\u0002\u001c%\u0019\u0011\u0011\u0004\u0014\u0003\r=\u0003H/[8o!\u0015\ti\"a\nD\u001b\t\tyB\u0003\u0003\u0002\"\u0005\r\u0012\u0001\u00023bi\u0006T!!!\n\u0002\t\r\fGo]\u0005\u0005\u0003S\tyB\u0001\u0007O_:,U\u000e\u001d;z\u0019&\u001cH\u000fC\u0003]\u001d\u0001\u0007a\f\u0003\u0004\u000209\u0001\ra^\u0001\u000eC2d\u0007+\u0019:uSRLwN\\:\u0002\u001bI+G/\u001a8uS>tG+Y:l!\t\u0011\u0006c\u0005\u0002\u0011IQ\u0011\u00111G\u0001\u0019EVLG\u000e\u001a#s_B\u0004\u0016M\u001d;ji&|gn])vKJLH#B\"\u0002>\u0005}\u0002\"B!\u0013\u0001\u0004\u0019\u0005bBA!%\u0001\u0007\u00111D\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\u0018!\b2vS2$7+\u001a7fGR\fE\u000e\u001c)beRLG/[8ogF+XM]=\u0015\u0007\r\u000b9\u0005C\u0003B'\u0001\u00071\t")
public class RetentionTask
implements LazyLogging {
    private final CairoEngine engine;
    private final String tableName;
    private final ThreadAwareObjectPool<SqlExecutionContext> sqlContextPool;
    private final Clock clock;
    private final String selectAllPartitionsQuery;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        RetentionTask retentionTask = this;
        synchronized (retentionTask) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private CairoEngine engine() {
        return this.engine;
    }

    private String tableName() {
        return this.tableName;
    }

    private ThreadAwareObjectPool<SqlExecutionContext> sqlContextPool() {
        return this.sqlContextPool;
    }

    private Clock clock() {
        return this.clock;
    }

    private String selectAllPartitionsQuery() {
        return this.selectAllPartitionsQuery;
    }

    public void runUnsafe() {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Cleaning up old data");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        SqlExecutionContext sqlContext = this.sqlContextPool().get();
        List<Tuple2<String, Object>> allPartitions = this.getPartitions(sqlContext);
        this.ensureOnePartitionExist(this.clock(), allPartitions).foreach((Function1 & Serializable & scala.Serializable)partitionsToDrop -> {
            RetentionTask.$anonfun$runUnsafe$1(this, sqlContext, partitionsToDrop);
            return BoxedUnit.UNIT;
        });
    }

    private List<Tuple2<String, Object>> getPartitions(SqlExecutionContext sqlContext) {
        return QuestDbExtensions$.MODULE$.RecordCursorFactoryExtension(this.engine().select((CharSequence)this.selectAllPartitionsQuery(), sqlContext)).fetch(sqlContext, (Function1 & Serializable & scala.Serializable)record -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((Object)record.getStrA(0)).toString()), (Object)BoxesRunTime.boxToLong((long)(record.getTimestamp(1) / 1000L))));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Option<NonEmptyList<String>> ensureOnePartitionExist(Clock clock, List<Tuple2<String, Object>> allPartitions) {
        long todayInMillis = clock.instant().truncatedTo(ChronoUnit.DAYS).toEpochMilli();
        Tuple2 tuple2 = allPartitions.span((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)RetentionTask.$anonfun$ensureOnePartitionExist$1(todayInMillis, x$1)));
        if (tuple2 == null) return None$.MODULE$;
        List oldPartitions = (List)tuple2._1();
        List list = (List)tuple2._2();
        if (!(oldPartitions instanceof .colon.colon)) return None$.MODULE$;
        .colon.colon colon2 = (.colon.colon)oldPartitions;
        if (!(list instanceof .colon.colon)) return None$.MODULE$;
        return NonEmptyList$.MODULE$.fromList((List)colon2.map((Function1 & Serializable & scala.Serializable)x$2 -> (String)x$2._1(), List$.MODULE$.canBuildFrom()));
    }

    public static final /* synthetic */ void $anonfun$runUnsafe$1(RetentionTask $this, SqlExecutionContext sqlContext$1, NonEmptyList partitionsToDrop) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        String query = RetentionTask$.MODULE$.pl$touk$nussknacker$ui$db$timeseries$questdb$RetentionTask$$buildDropPartitionsQuery($this.tableName(), (NonEmptyList<String>)partitionsToDrop);
        if ($this.logger().underlying().isInfoEnabled()) {
            $this.logger().underlying().info("Dropping old partitions: {}", new Object[]{query});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        $this.engine().ddl((CharSequence)query, sqlContext$1);
        if ($this.logger().underlying().isInfoEnabled()) {
            $this.logger().underlying().info("Dropping old partitions succeed");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ boolean $anonfun$ensureOnePartitionExist$1(long todayInMillis$1, Tuple2 x$1) {
        return x$1._2$mcJ$sp() < todayInMillis$1;
    }

    public RetentionTask(CairoEngine engine, String tableName, ThreadAwareObjectPool<SqlExecutionContext> sqlContextPool, Clock clock) {
        this.engine = engine;
        this.tableName = tableName;
        this.sqlContextPool = sqlContextPool;
        this.clock = clock;
        LazyLogging.$init$((LazyLogging)this);
        this.selectAllPartitionsQuery = RetentionTask$.MODULE$.pl$touk$nussknacker$ui$db$timeseries$questdb$RetentionTask$$buildSelectAllPartitionsQuery(tableName);
    }
}

