/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.process.processingtype;

import cats.data.NonEmptyList;
import cats.data.Validated;
import com.typesafe.config.Config;
import java.io.Serializable;
import net.ceedubs.ficus.Ficus$;
import pl.touk.nussknacker.engine.BaseModelData;
import pl.touk.nussknacker.engine.CustomProcessValidator;
import pl.touk.nussknacker.engine.DeploymentManagerDependencies;
import pl.touk.nussknacker.engine.DeploymentManagerProvider;
import pl.touk.nussknacker.engine.MetaDataInitializer;
import pl.touk.nussknacker.engine.ModelData;
import pl.touk.nussknacker.engine.api.component.ComponentId;
import pl.touk.nussknacker.engine.api.component.ProcessingMode;
import pl.touk.nussknacker.engine.api.component.ScenarioPropertyConfig;
import pl.touk.nussknacker.engine.api.deployment.DeploymentManager;
import pl.touk.nussknacker.engine.api.deployment.cache.ScenarioStateCachingConfig$;
import pl.touk.nussknacker.engine.definition.component.ComponentDefinitionWithImplementation;
import pl.touk.nussknacker.engine.definition.component.ComponentStaticDefinition;
import pl.touk.nussknacker.engine.definition.component.DynamicComponentStaticDefinitionDeterminer$;
import pl.touk.nussknacker.engine.deployment.EngineSetupName;
import pl.touk.nussknacker.engine.util.config.FicusReaders$;
import pl.touk.nussknacker.ui.process.processingtype.DeploymentData;
import pl.touk.nussknacker.ui.process.processingtype.DeploymentManagerType;
import pl.touk.nussknacker.ui.process.processingtype.DesignerModelData;
import pl.touk.nussknacker.ui.process.processingtype.ProcessingTypeData;
import pl.touk.nussknacker.ui.process.processingtype.ScenarioParametersDeterminer$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.util.control.NonFatal$;

public final class ProcessingTypeData$
implements scala.Serializable {
    public static ProcessingTypeData$ MODULE$;

    static {
        new ProcessingTypeData$();
    }

    public ProcessingTypeData createProcessingTypeData(String name, ModelData modelData, DeploymentManagerProvider deploymentManagerProvider, DeploymentManagerDependencies deploymentManagerDependencies, EngineSetupName engineSetupName, Config deploymentConfig, String category) {
        ProcessingTypeData processingTypeData;
        try {
            MetaDataInitializer metaDataInitializer = deploymentManagerProvider.metaDataInitializer(deploymentConfig);
            DeploymentData deploymentData = this.createDeploymentData(deploymentManagerProvider, deploymentManagerDependencies, engineSetupName, modelData, deploymentConfig, metaDataInitializer);
            DesignerModelData designerModelData = this.createDesignerModelData(modelData, metaDataInitializer, name);
            processingTypeData = this.apply(name, designerModelData, deploymentData, category);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable ex = (Throwable)option.get();
                throw new IllegalArgumentException(new StringBuilder(68).append("Error during creation of processing type data for processing type [").append(name).append("]").toString(), ex);
            }
            throw throwable;
        }
        return processingTypeData;
    }

    private DeploymentData createDeploymentData(DeploymentManagerProvider deploymentManagerProvider, DeploymentManagerDependencies deploymentManagerDependencies, EngineSetupName engineSetupName, ModelData modelData, Config deploymentConfig, MetaDataInitializer metaDataInitializer) {
        Option scenarioStateCacheTTL = ScenarioStateCachingConfig$.MODULE$.extractScenarioStateCacheTTL(deploymentConfig);
        Validated validDeploymentManager = deploymentManagerProvider.createDeploymentManager((BaseModelData)modelData, deploymentManagerDependencies, deploymentConfig, scenarioStateCacheTTL);
        Map scenarioProperties = deploymentManagerProvider.scenarioPropertiesConfig(deploymentConfig).$plus$plus((GenTraversableOnce)Ficus$.MODULE$.toFicusConfig(modelData.modelConfig()).getOrElse("scenarioPropertiesConfig", (Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty(), Ficus$.MODULE$.optionValueReader(Ficus$.MODULE$.mapValueReader(FicusReaders$.MODULE$.paramConfigReader()))));
        return new DeploymentData((Validated<NonEmptyList<String>, DeploymentManager>)validDeploymentManager, metaDataInitializer, (Map<String, ScenarioPropertyConfig>)scenarioProperties, (List<CustomProcessValidator>)deploymentManagerProvider.additionalValidators(deploymentConfig), new DeploymentManagerType(deploymentManagerProvider.name()), engineSetupName);
    }

    private DesignerModelData createDesignerModelData(ModelData modelData, MetaDataInitializer metaDataInitializer, String processingType) {
        Map staticDefinitionForDynamicComponents = DynamicComponentStaticDefinitionDeterminer$.MODULE$.collectStaticDefinitionsForDynamicComponents(modelData, (Function1 & Serializable & scala.Serializable)x$1 -> metaDataInitializer.create(x$1, Predef$.MODULE$.Map().empty()));
        ProcessingMode singleProcessingMode = ScenarioParametersDeterminer$.MODULE$.determineProcessingMode((List<ComponentDefinitionWithImplementation>)modelData.modelDefinition().components(), processingType);
        return new DesignerModelData(modelData, (Map<ComponentId, ComponentStaticDefinition>)staticDefinitionForDynamicComponents, singleProcessingMode);
    }

    public ProcessingTypeData apply(String name, DesignerModelData designerModelData, DeploymentData deploymentData, String category) {
        return new ProcessingTypeData(name, designerModelData, deploymentData, category);
    }

    public Option<Tuple4<String, DesignerModelData, DeploymentData, String>> unapply(ProcessingTypeData x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple4((Object)x$0.name(), (Object)x$0.designerModelData(), (Object)x$0.deploymentData(), (Object)x$0.category()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ProcessingTypeData$() {
        MODULE$ = this;
    }
}

