/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.factory;

import akka.actor.ActorSystem;
import akka.actor.ActorSystem$;
import akka.actor.ClassicActorSystemProvider;
import akka.actor.Terminated;
import akka.stream.Materializer;
import akka.stream.Materializer$;
import cats.Functor;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.Resource;
import cats.effect.package$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.jmx.JmxReporter;
import java.io.Serializable;
import java.time.Clock;
import pl.touk.nussknacker.engine.ConfigWithUnresolvedVersion;
import pl.touk.nussknacker.engine.util.JavaClassVersionChecker;
import pl.touk.nussknacker.engine.util.SLF4JBridgeHandlerRegistrar$;
import pl.touk.nussknacker.ui.LoadableDesignerConfigBasedNussknackerConfig;
import pl.touk.nussknacker.ui.NussknackerConfig;
import pl.touk.nussknacker.ui.db.DbRef;
import pl.touk.nussknacker.ui.db.DbRef$;
import pl.touk.nussknacker.ui.db.timeseries.FEStatisticsRepository;
import pl.touk.nussknacker.ui.db.timeseries.questdb.QuestDbFEStatisticsRepository$;
import pl.touk.nussknacker.ui.process.processingtype.loader.ProcessingTypeDataLoader;
import pl.touk.nussknacker.ui.process.processingtype.loader.ProcessingTypesConfigBasedProcessingTypeDataLoader;
import pl.touk.nussknacker.ui.server.AkkaHttpBasedRouteProvider;
import pl.touk.nussknacker.ui.server.NussknackerHttpServer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005ms!B\b\u0011\u0011\u0003Yb!B\u000f\u0011\u0011\u0003q\u0002\"B\u0013\u0002\t\u00031c\u0001B\u000f\u0011\u0001\u001dB\u0001BM\u0002\u0003\u0002\u0003\u0006Ia\r\u0005\to\r\u0011\t\u0011)A\u0005q!)Qe\u0001C\u0001\u0005\")Qe\u0001C\u0001\r\")Qe\u0001C\u0001\u0011\")1k\u0001C\u0001)\"9aoAI\u0001\n\u00039\bbBA\u0003\u0007\u0011%\u0011q\u0001\u0005\b\u0003g\u0019A\u0011BA\u001b\u0011\u001d\tie\u0001C\u0005\u0003\u001fBq!a\u0016\u0004\t\u0013\tI&A\u000bOkN\u001c8N\\1dW\u0016\u0014\u0018\t\u001d9GC\u000e$xN]=\u000b\u0005E\u0011\u0012a\u00024bGR|'/\u001f\u0006\u0003'Q\t!!^5\u000b\u0005U1\u0012a\u00038vgN\\g.Y2lKJT!a\u0006\r\u0002\tQ|Wo\u001b\u0006\u00023\u0005\u0011\u0001\u000f\\\u0002\u0001!\ta\u0012!D\u0001\u0011\u0005UqUo]:l]\u0006\u001c7.\u001a:BaB4\u0015m\u0019;pef\u001c\"!A\u0010\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0003\t\nQa]2bY\u0006L!\u0001J\u0011\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t1dE\u0002\u0004?!\u0002\"!\u000b\u0019\u000e\u0003)R!a\u000b\u0017\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u00055r\u0013\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003=\n1aY8n\u0013\t\t$FA\u0006MCjLHj\\4hS:<\u0017!\u00058vgN\\g.Y2lKJ\u001cuN\u001c4jOB\u0011A'N\u0007\u0002%%\u0011aG\u0005\u0002\u0012\u001dV\u001c8o\u001b8bG.,'oQ8oM&<\u0017\u0001\u00079s_\u000e,7o]5oORK\b/\u001a#bi\u0006du.\u00193feB\u0011\u0011\bQ\u0007\u0002u)\u00111\bP\u0001\u0007Y>\fG-\u001a:\u000b\u0005ur\u0014A\u00049s_\u000e,7o]5oORL\b/\u001a\u0006\u0003\u007fI\tq\u0001\u001d:pG\u0016\u001c8/\u0003\u0002Bu\tA\u0002K]8dKN\u001c\u0018N\\4UsB,G)\u0019;b\u0019>\fG-\u001a:\u0015\u0007\r#U\t\u0005\u0002\u001d\u0007!)!G\u0002a\u0001g!)qG\u0002a\u0001qQ\u00111i\u0012\u0005\u0006e\u001d\u0001\ra\r\u000b\u0003\u0007&CQA\u0013\u0005A\u0002-\u000b1b\u00197bgNdu.\u00193feB\u0011A*U\u0007\u0002\u001b*\u0011ajT\u0001\u0005Y\u0006twMC\u0001Q\u0003\u0011Q\u0017M^1\n\u0005Ik%aC\"mCN\u001cHj\\1eKJ\f\u0011b\u0019:fCR,\u0017\t\u001d9\u0015\u0005Us\u0007\u0003\u0002,eO.t!aV1\u000f\u0005asfBA-]\u001b\u0005Q&BA.\u001b\u0003\u0019a$o\\8u}%\tQ,\u0001\u0003dCR\u001c\u0018BA0a\u0003\u0019)gMZ3di*\tQ,\u0003\u0002cG\u00069\u0001/Y2lC\u001e,'BA0a\u0013\t)gM\u0001\u0005SKN|WO]2f\u0015\t\u00117\r\u0005\u0002iS6\t1-\u0003\u0002kG\n\u0011\u0011j\u0014\t\u0003A1L!!\\\u0011\u0003\tUs\u0017\u000e\u001e\u0005\b_&\u0001\n\u00111\u0001q\u0003\u0015\u0019Gn\\2l!\t\tH/D\u0001s\u0015\t\u0019x*\u0001\u0003uS6,\u0017BA;s\u0005\u0015\u0019En\\2l\u0003M\u0019'/Z1uK\u0006\u0003\b\u000f\n3fM\u0006,H\u000e\u001e\u00132+\u0005A(F\u00019zW\u0005Q\bcA>\u0002\u00025\tAP\u0003\u0002~}\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003\u007f\u0006\n!\"\u00198o_R\fG/[8o\u0013\r\t\u0019\u0001 \u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!E2sK\u0006$X-Q2u_J\u001c\u0016p\u001d;f[R!\u0011\u0011BA\u0012!\u001d\tY!!\u0005h\u0003'i!!!\u0004\u000b\u0007\u0005=1-\u0001\u0004lKJtW\r\\\u0005\u0004K\u00065\u0001\u0003BA\u000b\u0003?i!!a\u0006\u000b\t\u0005e\u00111D\u0001\u0006C\u000e$xN\u001d\u0006\u0003\u0003;\tA!Y6lC&!\u0011\u0011EA\f\u0005-\t5\r^8s'f\u001cH/Z7\t\u000f\u0005\u00152\u00021\u0001\u0002(\u000511m\u001c8gS\u001e\u0004B!!\u000b\u000205\u0011\u00111\u0006\u0006\u0004\u0003[!\u0012AB3oO&tW-\u0003\u0003\u00022\u0005-\"aG\"p]\u001aLwmV5uQVs'/Z:pYZ,GMV3sg&|g.A\u0012de\u0016\fG/Z$f]\u0016\u0014\u0018\r\u001c)veB|7/Z'fiJL7m\u001d*fO&\u001cHO]=\u0015\u0005\u0005]\u0002cBA\u0006\u0003#9\u0017\u0011\b\t\u0005\u0003w\tI%\u0004\u0002\u0002>)!\u0011qHA!\u0003!iW\r\u001e:jGN,$\u0002BA\"\u0003\u000b\n!\u0002\u001a:pa^L'0\u0019:e\u0015\t\t9%\u0001\u0002j_&!\u00111JA\u001f\u00059iU\r\u001e:jGJ+w-[:uef\f\u0001c\u001d;beRTU\u000e\u001f*fa>\u0014H/\u001a:\u0015\t\u0005E\u00131\u000b\t\u0007\u0003\u0017\t\tbZ6\t\u000f\u0005US\u00021\u0001\u0002:\u0005yQ.\u001a;sS\u000e\u001c(+Z4jgR\u0014\u00180\u0001\u0011de\u0016\fG/Z*uCJ$\u0018I\u001c3Ti>\u0004Hj\\4hS:<WI\u001c;sS\u0016\u001cHCAA)\u0001")
public class NussknackerAppFactory
implements LazyLogging {
    private final NussknackerConfig nussknackerConfig;
    private final ProcessingTypeDataLoader processingTypeDataLoader;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        NussknackerAppFactory nussknackerAppFactory = this;
        synchronized (nussknackerAppFactory) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public Resource<IO, BoxedUnit> createApp(Clock clock) {
        return package$.MODULE$.Resource().eval(this.nussknackerConfig.loadApplicationConfig()).flatMap((Function1 & Serializable & scala.Serializable)config -> this.createActorSystem((ConfigWithUnresolvedVersion)config).map((Function1 & Serializable & scala.Serializable)system -> {
            Materializer materializer = Materializer$.MODULE$.apply((ClassicActorSystemProvider)system);
            return new Tuple2(system, (Object)materializer);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> {
            Tuple2 tuple2 = x$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ActorSystem system = (ActorSystem)tuple2._1();
            Materializer materializer = (Materializer)tuple2._2();
            Resource resource = package$.MODULE$.Resource().eval((Object)IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> JavaClassVersionChecker.check())).flatMap((Function1 & Serializable & scala.Serializable)_2 -> package$.MODULE$.Resource().eval((Object)IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> SLF4JBridgeHandlerRegistrar$.MODULE$.register())).flatMap((Function1 & Serializable & scala.Serializable)_ -> this.createGeneralPurposeMetricsRegistry().flatMap((Function1 & Serializable & scala.Serializable)metricsRegistry -> DbRef$.MODULE$.create(config.resolved()).flatMap((Function1 & Serializable & scala.Serializable)db -> QuestDbFEStatisticsRepository$.MODULE$.create(system, clock, config.resolved()).map((Function1 & Serializable & scala.Serializable)feStatisticsRepository -> {
                NussknackerHttpServer server = new NussknackerHttpServer(new AkkaHttpBasedRouteProvider((DbRef)db, (MetricRegistry)metricsRegistry, $this.processingTypeDataLoader, (FEStatisticsRepository<Future>)feStatisticsRepository, clock, system, materializer), system);
                return new Tuple2(feStatisticsRepository, (Object)server);
            }).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                NussknackerHttpServer server = (NussknackerHttpServer)tuple2._2();
                Resource resource = server.start((ConfigWithUnresolvedVersion)config, (MetricRegistry)metricsRegistry).flatMap((Function1 & Serializable & scala.Serializable)_ -> this.startJmxReporter((MetricRegistry)metricsRegistry).flatMap((Function1 & Serializable & scala.Serializable)_2 -> this.createStartAndStopLoggingEntries().map((Function1 & Serializable & scala.Serializable)_ -> {
                    NussknackerAppFactory.$anonfun$createApp$14(_);
                    return BoxedUnit.UNIT;
                })));
                return resource;
            })))));
            return resource;
        }));
    }

    public Clock createApp$default$1() {
        return Clock.systemUTC();
    }

    private Resource<IO, ActorSystem> createActorSystem(ConfigWithUnresolvedVersion config) {
        return package$.MODULE$.Resource().make((Object)IO$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> ActorSystem$.MODULE$.apply("nussknacker-designer", config.resolved())), (Function1 & Serializable & scala.Serializable)system -> IO$.MODULE$.fromFuture(IO$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> system.terminate())).map((Function1 & Serializable & scala.Serializable)x$3 -> {
            NussknackerAppFactory.$anonfun$createActorSystem$4(x$3);
            return BoxedUnit.UNIT;
        }), (Functor)IO$.MODULE$.asyncForIO());
    }

    private Resource<IO, MetricRegistry> createGeneralPurposeMetricsRegistry() {
        return package$.MODULE$.Resource().pure((Object)new MetricRegistry());
    }

    private Resource<IO, BoxedUnit> startJmxReporter(MetricRegistry metricsRegistry) {
        return package$.MODULE$.Resource().eval((Object)IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> JmxReporter.forRegistry((MetricRegistry)metricsRegistry).build().start()));
    }

    private Resource<IO, BoxedUnit> createStartAndStopLoggingEntries() {
        return package$.MODULE$.Resource().make((Object)IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Nussknacker started!");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }), (Function1 & Serializable & scala.Serializable)x$4 -> IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Stopping Nussknacker ...");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }), (Functor)IO$.MODULE$.asyncForIO());
    }

    public static final /* synthetic */ void $anonfun$createApp$14(BoxedUnit _) {
    }

    public static final /* synthetic */ void $anonfun$createActorSystem$4(Terminated x$3) {
    }

    public NussknackerAppFactory(NussknackerConfig nussknackerConfig, ProcessingTypeDataLoader processingTypeDataLoader) {
        this.nussknackerConfig = nussknackerConfig;
        this.processingTypeDataLoader = processingTypeDataLoader;
        LazyLogging.$init$((LazyLogging)this);
    }

    public NussknackerAppFactory(NussknackerConfig nussknackerConfig) {
        this(nussknackerConfig, new ProcessingTypesConfigBasedProcessingTypeDataLoader(nussknackerConfig));
    }

    public NussknackerAppFactory(ClassLoader classLoader) {
        this(new LoadableDesignerConfigBasedNussknackerConfig(classLoader));
    }
}

