/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.process.repository;

import cats.Monad;
import cats.data.OptionT;
import cats.data.OptionT$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import db.util.DBIOActionInstances$;
import java.io.Serializable;
import java.time.Instant;
import pl.touk.nussknacker.engine.api.deployment.ProcessAction;
import pl.touk.nussknacker.engine.api.deployment.ProcessActionState$;
import pl.touk.nussknacker.engine.api.deployment.ScenarioActionName;
import pl.touk.nussknacker.engine.api.deployment.ScenarioActionName$;
import pl.touk.nussknacker.engine.api.graph.ScenarioGraph;
import pl.touk.nussknacker.engine.api.process.ProcessId;
import pl.touk.nussknacker.engine.api.process.ProcessIdWithName;
import pl.touk.nussknacker.engine.api.process.ProcessName;
import pl.touk.nussknacker.engine.api.process.ScenarioVersion;
import pl.touk.nussknacker.engine.api.process.VersionId;
import pl.touk.nussknacker.engine.canonicalgraph.CanonicalProcess;
import pl.touk.nussknacker.restmodel.component.ScenarioComponentsUsages;
import pl.touk.nussknacker.ui.db.DbRef;
import pl.touk.nussknacker.ui.db.entity.ProcessEntityData;
import pl.touk.nussknacker.ui.db.entity.ProcessEntityFactory;
import pl.touk.nussknacker.ui.db.entity.ProcessVersionEntityData;
import pl.touk.nussknacker.ui.db.entity.TagsEntityData;
import pl.touk.nussknacker.ui.process.ScenarioQuery;
import pl.touk.nussknacker.ui.process.marshall.CanonicalProcessConverter$;
import pl.touk.nussknacker.ui.process.repository.DBFetchingProcessRepository$;
import pl.touk.nussknacker.ui.process.repository.FetchingProcessRepository;
import pl.touk.nussknacker.ui.process.repository.ProcessActionRepository;
import pl.touk.nussknacker.ui.process.repository.ProcessDBQueryRepository;
import pl.touk.nussknacker.ui.process.repository.ProcessDBQueryRepository$;
import pl.touk.nussknacker.ui.process.repository.ScenarioShapeFetchStrategy;
import pl.touk.nussknacker.ui.process.repository.ScenarioShapeFetchStrategy$FetchCanonical$;
import pl.touk.nussknacker.ui.process.repository.ScenarioShapeFetchStrategy$FetchComponentsUsages$;
import pl.touk.nussknacker.ui.process.repository.ScenarioShapeFetchStrategy$FetchScenarioGraph$;
import pl.touk.nussknacker.ui.process.repository.ScenarioShapeFetchStrategy$NotFetch$;
import pl.touk.nussknacker.ui.process.repository.ScenarioWithDetailsEntity;
import pl.touk.nussknacker.ui.security.api.LoggedUser;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import slick.ast.BaseTypedType;
import slick.ast.TypedType;
import slick.dbio.DBIOAction;
import slick.dbio.Effect;
import slick.dbio.NoStream;
import slick.jdbc.JdbcActionComponent;
import slick.lifted.BaseColumnExtensionMethods;
import slick.lifted.BooleanColumnExtensionMethods$;
import slick.lifted.CanBeQueryCondition$;
import slick.lifted.OptionMapper2$;
import slick.lifted.Rep;
import slick.lifted.Shape$;

@ScalaSignature(bytes="\u0006\u0001\r\u001dw!B\r\u001b\u0011\u00039c!B\u0015\u001b\u0011\u0003Q\u0003\"B\u0019\u0002\t\u0003\u0011\u0004\"B\u001a\u0002\t\u0003!\u0004bBBU\u0003\u0011\u000511\u0016\u0004\u0006Si\t\tA\u000f\u0005\t/\u0016\u0011)\u0019!C\t1\"Aq,\u0002B\u0001B\u0003%\u0011\f\u0003\u0005a\u000b\t\u0005\t\u0015!\u0003b\u0011!!WAaA!\u0002\u0017)\u0007\u0002C6\u0006\u0005\u000b\u0007I1\u00037\t\u0011M,!\u0011!Q\u0001\n5DQ!M\u0003\u0005\u0002QDQa_\u0003\u0005BqDq!!\u0015\u0006\t\u0013\t\u0019\u0006C\u0004\u0002Z\u0016!I!a7\t\u000f\t\u001dR\u0001\"\u0011\u0003*!9!qI\u0003\u0005B\t%\u0003b\u0002B9\u000b\u0011\u0005#1\u000f\u0005\b\u0005\u000f+A\u0011\u0001BE\u0011\u001d\u0011)*\u0002C!\u0005/CqAa4\u0006\t\u0013\u0011\t\u000eC\u0004\u0004\b\u0015!Ia!\u0003\t\u000f\rmR\u0001\"\u0003\u0004>!91\u0011R\u0003\u0005\n\r-\u0015a\u0007#C\r\u0016$8\r[5oOB\u0013xnY3tgJ+\u0007o\\:ji>\u0014\u0018P\u0003\u0002\u001c9\u0005Q!/\u001a9pg&$xN]=\u000b\u0005uq\u0012a\u00029s_\u000e,7o\u001d\u0006\u0003?\u0001\n!!^5\u000b\u0005\u0005\u0012\u0013a\u00038vgN\\g.Y2lKJT!a\t\u0013\u0002\tQ|Wo\u001b\u0006\u0002K\u0005\u0011\u0001\u000f\\\u0002\u0001!\tA\u0013!D\u0001\u001b\u0005m!%IR3uG\"Lgn\u001a)s_\u000e,7o\u001d*fa>\u001c\u0018\u000e^8ssN\u0011\u0011a\u000b\t\u0003Y=j\u0011!\f\u0006\u0002]\u0005)1oY1mC&\u0011\u0001'\f\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u00059\u0013AB2sK\u0006$X\rF\u00036\u0007K\u001b9\u000bF\u00027\u0007G\u0013BaN\u001d\u0004\u001e\u001a!\u0001h\u0001\u00017\u00051a$/\u001a4j]\u0016lWM\u001c;?!\u0011ASaa\u0007\u0016\u0005m\n5cA\u0003=\u001bB\u0019\u0001&P \n\u0005yR\"!\u0007$fi\u000eD\u0017N\\4Qe>\u001cWm]:SKB|7/\u001b;pef\u0004\"\u0001Q!\r\u0001\u0011)!)\u0002b\u0001\u0007\n\ta)\u0006\u0002E\u0017F\u0011Q\t\u0013\t\u0003Y\u0019K!aR\u0017\u0003\u000f9{G\u000f[5oOB\u0011A&S\u0005\u0003\u00156\u00121!\u00118z\t\u0015a\u0015I1\u0001E\u0005\u0005y\u0006C\u0001(V\u001b\u0005y%B\u0001)R\u00031\u00198-\u00197bY><w-\u001b8h\u0015\t\u00116+\u0001\u0005usB,7/\u00194f\u0015\u0005!\u0016aA2p[&\u0011ak\u0014\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw-A\u0003eEJ+g-F\u0001Z!\tQV,D\u0001\\\u0015\taf$\u0001\u0002eE&\u0011al\u0017\u0002\u0006\t\n\u0014VMZ\u0001\u0007I\n\u0014VM\u001a\u0011\u0002!\u0005\u001cG/[8o%\u0016\u0004xn]5u_JL\bC\u0001\u0015c\u0013\t\u0019'DA\fQe>\u001cWm]:BGRLwN\u001c*fa>\u001c\u0018\u000e^8ss\u0006QQM^5eK:\u001cW\rJ\u0019\u0011\u0007\u0019Lw(D\u0001h\u0015\u0005A\u0017\u0001B2biNL!A[4\u0003\u000b5{g.\u00193\u0002\u0005\u0015\u001cW#A7\u0011\u00059\fX\"A8\u000b\u0005Al\u0013AC2p]\u000e,(O]3oi&\u0011!o\u001c\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\f1!Z2!)\r)\u0018P\u001f\u000b\u0004m^D\bc\u0001\u0015\u0006\u007f!)A\r\u0004a\u0002K\")1\u000e\u0004a\u0002[\")q\u000b\u0004a\u00013\")\u0001\r\u0004a\u0001C\u0006Yb-\u001a;dQ2\u000bG/Z:u!J|7-Z:tKN$U\r^1jYN,2!`A\u0011)\rq\u0018Q\t\u000b\b\u007f\u0006\u0015\u0012qFA\"!\u0011\u0001\u0015)!\u0001\u0011\r\u0005\r\u00111CA\r\u001d\u0011\t)!a\u0004\u000f\t\u0005\u001d\u0011QB\u0007\u0003\u0003\u0013Q1!a\u0003'\u0003\u0019a$o\\8u}%\ta&C\u0002\u0002\u00125\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0016\u0005]!\u0001\u0002'jgRT1!!\u0005.!\u0015A\u00131DA\u0010\u0013\r\tiB\u0007\u0002\u001a'\u000e,g.\u0019:j_^KG\u000f\u001b#fi\u0006LGn]#oi&$\u0018\u0010E\u0002A\u0003C!a!a\t\u000e\u0005\u0004!%A\u0001)T\u0011%\t9#DA\u0001\u0002\b\tI#\u0001\u0006fm&$WM\\2fII\u0002R\u0001KA\u0016\u0003?I1!!\f\u001b\u0005i\u00196-\u001a8be&|7\u000b[1qK\u001a+Go\u00195TiJ\fG/Z4z\u0011\u001d\t\t$\u0004a\u0002\u0003g\t!\u0002\\8hO\u0016$Wk]3s!\u0011\t)$a\u0010\u000e\u0005\u0005]\"\u0002BA\u001d\u0003w\t1!\u00199j\u0015\r\tiDH\u0001\tg\u0016\u001cWO]5us&!\u0011\u0011IA\u001c\u0005)aunZ4fIV\u001bXM\u001d\u0005\u0006W6\u0001\u001d!\u001c\u0005\b\u0003\u000fj\u0001\u0019AA%\u0003\u0015\tX/\u001a:z!\u0011\tY%!\u0014\u000e\u0003qI1!a\u0014\u001d\u00055\u00196-\u001a8be&|\u0017+^3ss\u00061c-\u001a;dQ2\u000bG/Z:u!J|7-Z:t\t\u0016$\u0018-\u001b7t\u0005f\fV/\u001a:z\u0003\u000e$\u0018n\u001c8\u0016\t\u0005U\u00131\u0010\u000b\u0007\u0003/\nI+a4\u0015\u0011\u0005e\u0013qTAS\u0003O\u0003\"\"a\u0017\u0002f\u0005U\u0014QPAB\u001d\u0011\ti&a\u0018\u000e\u0003\u0015IA!!\u000f\u0002b%\u0019\u00111\r\u000e\u0003\u0015I+\u0007o\\:ji>\u0014\u00180\u0003\u0003\u0002h\u0005%$A\u0003#C\u0013>\u000b5\r^5p]&!\u00111NA7\u0005\u001d\tE.[1tKNTA!a\u001c\u0002r\u00051A.\u001b4uK\u0012T!!a\u001d\u0002\u000bMd\u0017nY6\u0011\r\u0005\r\u00111CA<!\u0015A\u00131DA=!\r\u0001\u00151\u0010\u0003\u0007\u0003Gq!\u0019\u0001#\u0011\t\u0005m\u0013qP\u0005\u0005\u0003\u0003\u000bIG\u0001\u0005O_N#(/Z1n%\u0019\t))a\"\u0002\u001a\u001a)\u0001(\u0002\u0001\u0002\u0004B!\u0011\u0011RAH\u001d\u0011\tY&a#\n\t\u00055\u0015\u0011N\u0001\u0007\u000b\u001a4Wm\u0019;\n\t\u0005E\u00151\u0013\u0002\u0004\u00032d'\u0002BAG\u0003+SA!a&\u0002r\u0005!AMY5p!\u0011\tI)a'\n\t\u0005u\u00151\u0013\u0002\u0005%\u0016\fG\rC\u0005\u0002\":\t\t\u0011q\u0001\u0002$\u0006QQM^5eK:\u001cW\rJ\u001a\u0011\u000b!\nY#!\u001f\t\u000f\u0005Eb\u0002q\u0001\u00024!)1N\u0004a\u0002[\"9\u0011q\t\bA\u0002\u0005-\u0006c\u0002\u0017\u0002.\u0006E\u00161Y\u0005\u0004\u0003_k#!\u0003$v]\u000e$\u0018n\u001c82!\u0011\t\u0019,a0\u0011\t\u0005U\u00161X\u0007\u0003\u0003oS1!!/\\\u0003\u0019)g\u000e^5us&!\u0011QXA\\\u0005Q\u0001&o\\2fgN,e\u000e^5us\u001a\u000b7\r^8ss&!\u0011\u0011YA^\u00055\u0001&o\\2fgN,e\u000e^5usB1\u00111LAc\u0003\u0013LA!a2\u0002j\t\u0019!+\u001a9\u0011\u00071\nY-C\u0002\u0002N6\u0012qAQ8pY\u0016\fg\u000eC\u0004\u0002R:\u0001\r!a5\u0002\u0015%\u001cH)\u001a9m_f,G\rE\u0003-\u0003+\fI-C\u0002\u0002X6\u0012aa\u00149uS>t\u0017a\u00054fi\u000eD\u0017i\u0019;j_:\u001cxJ]#naRLX\u0003BAo\u00057!B!a8\u0003\u001eQ!\u0011\u0011\u001dB\n!\u0019\tY&a9\u0002h&!\u0011Q]A5\u0005\u0011!%)S(\u0011\u0011\u0005%\u0018\u0011_A|\u0005\u000fqA!a;\u0002nB\u0019\u0011qA\u0017\n\u0007\u0005=X&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003g\f)PA\u0002NCBT1!a<.!\u0011\tIPa\u0001\u000e\u0005\u0005m(bA\u000f\u0002~*!\u0011\u0011HA\u0000\u0015\r\u0011\t\u0001I\u0001\u0007K:<\u0017N\\3\n\t\t\u0015\u00111 \u0002\n!J|7-Z:t\u0013\u0012\u0004BA!\u0003\u0003\u00105\u0011!1\u0002\u0006\u0005\u0005\u001b\ti0\u0001\u0006eKBdw._7f]RLAA!\u0005\u0003\f\ti\u0001K]8dKN\u001c\u0018i\u0019;j_:D\u0011B!\u0006\u0010\u0003\u0003\u0005\u001dAa\u0006\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$C\u0007E\u0003)\u0003W\u0011I\u0002E\u0002A\u00057!a!a\t\u0010\u0005\u0004!\u0005\u0002\u0003B\u0010\u001f\u0011\u0005\rA!\t\u0002\u000f\u0011|g)\u001a;dQB)AFa\t\u0002b&\u0019!QE\u0017\u0003\u0011q\u0012\u0017P\\1nKz\nQEZ3uG\"d\u0015\r^3tiB\u0013xnY3tg\u0012+G/Y5mg\u001a{'\u000f\u0015:pG\u0016\u001c8/\u00133\u0016\t\t-\"q\u0007\u000b\u0005\u0005[\u0011\u0019\u0005\u0006\u0005\u00030\te\"q\bB!!\u0011\u0001\u0015I!\r\u0011\u000b1\n)Na\r\u0011\u000b!\nYB!\u000e\u0011\u0007\u0001\u00139\u0004\u0002\u0004\u0002$A\u0011\r\u0001\u0012\u0005\n\u0005w\u0001\u0012\u0011!a\u0002\u0005{\t!\"\u001a<jI\u0016t7-\u001a\u00136!\u0015A\u00131\u0006B\u001b\u0011\u001d\t\t\u0004\u0005a\u0002\u0003gAQa\u001b\tA\u00045DqA!\u0012\u0011\u0001\u0004\t90\u0001\u0002jI\u0006Ab-\u001a;dQB\u0013xnY3tg\u0012+G/Y5mg\u001a{'/\u00133\u0016\t\t-#q\u000b\u000b\u0007\u0005\u001b\u0012\u0019Ga\u001a\u0015\u0011\t=#\u0011\fB0\u0005C\u0002B\u0001Q!\u0003RA)A&!6\u0003TA)\u0001&a\u0007\u0003VA\u0019\u0001Ia\u0016\u0005\r\u0005\r\u0012C1\u0001E\u0011%\u0011Y&EA\u0001\u0002\b\u0011i&\u0001\u0006fm&$WM\\2fIY\u0002R\u0001KA\u0016\u0005+Bq!!\r\u0012\u0001\b\t\u0019\u0004C\u0003l#\u0001\u000fQ\u000eC\u0004\u0003fE\u0001\r!a>\u0002\u0013A\u0014xnY3tg&#\u0007b\u0002B5#\u0001\u0007!1N\u0001\nm\u0016\u00148/[8o\u0013\u0012\u0004B!!?\u0003n%!!qNA~\u0005%1VM]:j_:LE-\u0001\bgKR\u001c\u0007\u000e\u0015:pG\u0016\u001c8/\u00133\u0015\t\tU$Q\u0010\u000b\u0005\u0005o\u0012Y\b\u0005\u0003A\u0003\ne\u0004#\u0002\u0017\u0002V\u0006]\b\"B6\u0013\u0001\bi\u0007b\u0002B@%\u0001\u0007!\u0011Q\u0001\faJ|7-Z:t\u001d\u0006lW\r\u0005\u0003\u0002z\n\r\u0015\u0002\u0002BC\u0003w\u00141\u0002\u0015:pG\u0016\u001c8OT1nK\u0006\u0001b-\u001a;dQB\u0013xnY3tg:\u000bW.\u001a\u000b\u0005\u0005\u0017\u0013\u0019\n\u0006\u0003\u0003\u000e\nE\u0005\u0003\u0002!B\u0005\u001f\u0003R\u0001LAk\u0005\u0003CQa[\nA\u00045DqA!\u001a\u0014\u0001\u0004\t90A\ngKR\u001c\u0007\u000e\u0015:pG\u0016\u001c8/\u001b8h)f\u0004X\r\u0006\u0003\u0003\u001a\n\u001dGC\u0002BN\u0005\u0003\u0014)\r\u0005\u0003A\u0003\nu\u0005\u0003\u0002BP\u0005wsAA!)\u0003::!!1\u0015B\\\u001d\u0011\u0011)K!.\u000f\t\t\u001d&1\u0017\b\u0005\u0005S\u0013\tL\u0004\u0003\u0003,\n=f\u0002BA\u0004\u0005[K\u0011!J\u0005\u0003G\u0011J!!\t\u0012\n\u0007\t\u0005\u0001%\u0003\u0003\u0002:\u0005}\u0018bA\u000f\u0002~&!\u0011\u0011CA~\u0013\u0011\u0011iLa0\u0003\u001dA\u0013xnY3tg&tw\rV=qK*!\u0011\u0011CA~\u0011\u001d\u0011\u0019\r\u0006a\u0002\u0003g\tA!^:fe\")1\u000e\u0006a\u0002[\"9!Q\r\u000bA\u0002\t%\u0007\u0003BA}\u0005\u0017LAA!4\u0002|\n\t\u0002K]8dKN\u001c\u0018\nZ,ji\"t\u0015-\\3\u0002U\u0019,Go\u00195MCR,7\u000f\u001e)s_\u000e,7o\u001d#fi\u0006LGn\u001d$peB\u0013xnY3tg&#\u0017+^3ssV!!1\u001bB})\u0011\u0011)n!\u0002\u0015\u0011\t]'1`B\u0001\u0007\u0007\u0001bA!7\u0003n\nMh\u0002\u0002Bn\u0005OtAA!8\u0003b:!\u0011q\u0001Bp\u0013\u0005a\u0016\u0002\u0002Br\u0005K\fA!\u001e;jY*\tA,\u0003\u0003\u0003j\n-\u0018a\u0005#C\u0013>\u000b5\r^5p]&s7\u000f^1oG\u0016\u001c(\u0002\u0002Br\u0005KLAAa<\u0003r\n\u0011AI\u0011\u0006\u0005\u0005S\u0014Y\u000fE\u0003-\u0003+\u0014)\u0010E\u0003)\u00037\u00119\u0010E\u0002A\u0005s$a!a\t\u0016\u0005\u0004!\u0005\"\u0003B\u007f+\u0005\u0005\t9\u0001B\u0000\u0003))g/\u001b3f]\u000e,Ge\u000e\t\u0006Q\u0005-\"q\u001f\u0005\b\u0003c)\u00029AA\u001a\u0011\u0015YW\u0003q\u0001n\u0011\u001d\u0011)%\u0006a\u0001\u0003o\fQDZ3uG\"\u0004&o\\2fgN$U\r^1jYN4uN\u001d,feNLwN\\\u000b\u0005\u0007\u0017\u0019\t\u0003\u0006\u0004\u0004\u000e\r52q\u0007\u000b\t\u0007\u001f\u0019\u0019c!\u000b\u0004,AA1\u0011CB\f\u00077\u0019i\"\u0004\u0002\u0004\u0014)\u00191QC4\u0002\t\u0011\fG/Y\u0005\u0005\u00073\u0019\u0019BA\u0004PaRLwN\u001c+\u0011\t\te'Q\u001e\t\u0006Q\u0005m1q\u0004\t\u0004\u0001\u000e\u0005BABA\u0012-\t\u0007A\tC\u0005\u0004&Y\t\t\u0011q\u0001\u0004(\u0005QQM^5eK:\u001cW\r\n\u001d\u0011\u000b!\nYca\b\t\u000f\u0005Eb\u0003q\u0001\u00024!)1N\u0006a\u0002[\"91q\u0006\fA\u0002\rE\u0012A\u00049s_\u000e,7o\u001d,feNLwN\u001c\t\u0005\u0003k\u001b\u0019$\u0003\u0003\u00046\u0005]&\u0001\u0007)s_\u000e,7o\u001d,feNLwN\\#oi&$\u0018\u0010R1uC\"91\u0011\b\fA\u0002\u0005%\u0017aD5t\u0019\u0006$Xm\u001d;WKJ\u001c\u0018n\u001c8\u0002#\r\u0014X-\u0019;f\rVdG\u000eR3uC&d7/\u0006\u0003\u0004@\r\u001dCCEB!\u0007\u001f\u001a9f!\u0017\u0004`\r\r4qMB5\u0007w\"Baa\u0011\u0004JA)\u0001&a\u0007\u0004FA\u0019\u0001ia\u0012\u0005\r\u0005\rrC1\u0001E\u0011%\u0019YeFA\u0001\u0002\b\u0019i%\u0001\u0006fm&$WM\\2fIe\u0002R\u0001KA\u0016\u0007\u000bBa!H\fA\u0002\rE\u0003\u0003BA[\u0007'JAa!\u0016\u00028\n\t\u0002K]8dKN\u001cXI\u001c;jif$\u0015\r^1\t\u000f\r=r\u00031\u0001\u00042!911L\fA\u0002\ru\u0013A\u00047bgR\f5\r^5p]\u0012\u000bG/\u0019\t\u0006Y\u0005U'q\u0001\u0005\b\u0007C:\u0002\u0019AB/\u0003Ma\u0017m\u001d;Ti\u0006$X-Q2uS>tG)\u0019;b\u0011\u001d\u0019)g\u0006a\u0001\u0007;\na\u0003\\1ti\u0012+\u0007\u000f\\8zK\u0012\f5\r^5p]\u0012\u000bG/\u0019\u0005\b\u0007s9\u0002\u0019AAe\u0011\u001d\u0019Yg\u0006a\u0001\u0007[\nA\u0001^1hgB)A&!6\u0004pA1\u00111AB9\u0007kJAaa\u001d\u0002\u0018\t\u00191+Z9\u0011\t\u0005U6qO\u0005\u0005\u0007s\n9L\u0001\bUC\u001e\u001cXI\u001c;jif$\u0015\r^1\t\u000f\rut\u00031\u0001\u0004\u0000\u00059\u0001.[:u_JL\b#\u0002\u0017\u0002V\u000e\u0005\u0005CBA\u0002\u0007c\u001a\u0019\t\u0005\u0003\u0002z\u000e\u0015\u0015\u0002BBD\u0003w\u0014qbU2f]\u0006\u0014\u0018n\u001c,feNLwN\\\u0001\u0015G>tg/\u001a:u)>$\u0016M]4fiNC\u0017\r]3\u0016\t\r551\u0013\u000b\u0005\u0007\u001f\u001bY\n\u0006\u0003\u0004\u0012\u000eU\u0005c\u0001!\u0004\u0014\u00121\u00111\u0005\rC\u0002\u0011C\u0011ba&\u0019\u0003\u0003\u0005\u001da!'\u0002\u0017\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007\r\t\u0006Q\u0005-2\u0011\u0013\u0005\b\u0007_A\u0002\u0019AB\u0019!\rA3qT\u0005\u0004\u0007CS\"A\u0004#cS>\u0014V\r]8tSR|'/\u001f\u0005\u0006W\u000e\u0001\u001d!\u001c\u0005\u0006/\u000e\u0001\r!\u0017\u0005\u0006A\u000e\u0001\r!Y\u0001\u0017GJ,\u0017\r^3GkR,(/\u001a*fa>\u001c\u0018\u000e^8ssR11QVBb\u0007\u000b$Baa,\u0004BJ11\u0011WBZ\u0007w3Q\u0001\u000f\u0003\u0001\u0007_\u0003B\u0001K\u0003\u00046B\u0019ana.\n\u0007\revN\u0001\u0004GkR,(/\u001a\t\u0004Q\ru\u0016bAB`5\ty!)Y:jGJ+\u0007o\\:ji>\u0014\u0018\u0010C\u0003l\t\u0001\u000fQ\u000eC\u0003X\t\u0001\u0007\u0011\fC\u0003a\t\u0001\u0007\u0011\r")
public abstract class DBFetchingProcessRepository<F>
extends FetchingProcessRepository<F>
implements LazyLogging {
    private final DbRef dbRef;
    private final ProcessActionRepository actionRepository;
    private final ExecutionContext ec;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static DBFetchingProcessRepository<Future> createFutureRepository(DbRef dbRef, ProcessActionRepository processActionRepository, ExecutionContext executionContext) {
        return DBFetchingProcessRepository$.MODULE$.createFutureRepository(dbRef, processActionRepository, executionContext);
    }

    public static DBFetchingProcessRepository<DBIOAction> create(DbRef dbRef, ProcessActionRepository processActionRepository, ExecutionContext executionContext) {
        return DBFetchingProcessRepository$.MODULE$.create(dbRef, processActionRepository, executionContext);
    }

    private Logger logger$lzycompute() {
        DBFetchingProcessRepository dBFetchingProcessRepository = this;
        synchronized (dBFetchingProcessRepository) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public DbRef dbRef() {
        return this.dbRef;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    @Override
    public <PS> F fetchLatestProcessesDetails(ScenarioQuery query, ScenarioShapeFetchStrategy<PS> evidence$2, LoggedUser loggedUser, ExecutionContext ec) {
        .colon.colon expr = new .colon.colon((Object)query.isFragment().map((Function1 & Serializable & scala.Serializable)arg -> DBFetchingProcessRepository.$anonfun$fetchLatestProcessesDetails$1(this, BoxesRunTime.unboxToBoolean((Object)arg))), (List)new .colon.colon((Object)query.isArchived().map((Function1 & Serializable & scala.Serializable)arg -> DBFetchingProcessRepository.$anonfun$fetchLatestProcessesDetails$3(this, BoxesRunTime.unboxToBoolean((Object)arg))), (List)new .colon.colon((Object)query.categories().map((Function1 & Serializable & scala.Serializable)arg -> (Function1 & Serializable & scala.Serializable)process -> new BaseColumnExtensionMethods(this.api().columnExtensionMethods(process.processCategory(), (BaseTypedType)this.api().stringColumnType())).inSet((Iterable)arg, OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)this.api().stringColumnType()))), (List)new .colon.colon((Object)query.processingTypes().map((Function1 & Serializable & scala.Serializable)arg -> (Function1 & Serializable & scala.Serializable)process -> new BaseColumnExtensionMethods(this.api().columnExtensionMethods(process.processingType(), (BaseTypedType)this.api().stringColumnType())).inSet((Iterable)arg, OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)this.api().stringColumnType()))), (List)new .colon.colon((Object)query.names().map((Function1 & Serializable & scala.Serializable)arg -> (Function1 & Serializable & scala.Serializable)process -> new BaseColumnExtensionMethods(this.api().columnExtensionMethods(process.name(), this.processNameMapping())).inSet((Iterable)arg, OptionMapper2$.MODULE$.getOptionMapper2TT(this.processNameMapping()))), (List)Nil$.MODULE$)))));
        return (F)this.run().apply(this.fetchLatestProcessDetailsByQueryAction((Function1<ProcessEntityFactory.ProcessEntity, Rep<Object>>)((Function1 & Serializable & scala.Serializable)arg_0 -> DBFetchingProcessRepository.$anonfun$fetchLatestProcessesDetails$11(this, (List)expr, arg_0)), query.isDeployed(), evidence$2, loggedUser, ec));
    }

    private <PS> DBIOAction<List<ScenarioWithDetailsEntity<PS>>, NoStream, Effect.All> fetchLatestProcessDetailsByQueryAction(Function1<ProcessEntityFactory.ProcessEntity, Rep<Object>> query, Option<Object> isDeployed, ScenarioShapeFetchStrategy<PS> evidence$3, LoggedUser loggedUser, ExecutionContext ec) {
        return this.fetchActionsOrEmpty((Function0<DBIOAction<Map<ProcessId, ProcessAction>, NoStream, Effect.All>>)(Function0 & Serializable & scala.Serializable)() -> $this.actionRepository.getLastActionPerProcess((Set<Enumeration.Value>)ProcessActionState$.MODULE$.FinishedStates(), (Option<Set<ScenarioActionName>>)None$.MODULE$), evidence$3).flatMap((Function1 & Serializable & scala.Serializable)lastActionPerProcess -> this.fetchActionsOrEmpty((Function0<DBIOAction<Map<ProcessId, ProcessAction>, NoStream, Effect.All>>)(Function0 & Serializable & scala.Serializable)() -> $this.actionRepository.getLastActionPerProcess((Set<Enumeration.Value>)ProcessActionState$.MODULE$.FinishedStates(), (Option<Set<ScenarioActionName>>)new Some((Object)ScenarioActionName$.MODULE$.StateActions())), evidence$3).flatMap((Function1 & Serializable & scala.Serializable)lastStateActionPerProcess -> this.fetchActionsOrEmpty((Function0<DBIOAction<Map<ProcessId, ProcessAction>, NoStream, Effect.All>>)(Function0 & Serializable & scala.Serializable)() -> $this.actionRepository.getLastActionPerProcess((Set<Enumeration.Value>)ProcessActionState$.MODULE$.FinishedStates(), (Option<Set<ScenarioActionName>>)new Some((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new ScenarioActionName[]{new ScenarioActionName(ScenarioActionName$.MODULE$.Deploy()), new ScenarioActionName(ScenarioActionName$.MODULE$.Cancel())})))), evidence$3).map((Function1 & Serializable & scala.Serializable)x$1 -> (Map)x$1.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DBFetchingProcessRepository.$anonfun$fetchLatestProcessDetailsByQueryAction$7(x0$1))), ec).flatMap((Function1 & Serializable & scala.Serializable)lastDeployedActionPerProcess -> ((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.api().streamableQueryActionExtensionMethods(this.fetchLatestProcessesQuery(query, (Set<ProcessId>)lastDeployedActionPerProcess.keySet(), isDeployed, evidence$3, loggedUser))).result().map((Function1 & Serializable & scala.Serializable)latestProcesses -> (Seq)latestProcesses.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            ProcessEntityData process;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x0$2;
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._1();
                    process = (ProcessEntityData)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            ProcessVersionEntityData processVersion = (ProcessVersionEntityData)tuple2._2();
            ScenarioWithDetailsEntity scenarioWithDetailsEntity = this.createFullDetails(process, processVersion, (Option<ProcessAction>)lastActionPerProcess.get((Object)process.id()), (Option<ProcessAction>)lastStateActionPerProcess.get((Object)process.id()), (Option<ProcessAction>)lastDeployedActionPerProcess.get((Object)process.id()), true, (Option<Seq<TagsEntityData>>)None$.MODULE$, (Option<Seq<ScenarioVersion>>)None$.MODULE$, evidence$3);
            return scenarioWithDetailsEntity;
        }, Seq$.MODULE$.canBuildFrom()), ec), ec), ec), ec).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toList(), ec);
    }

    private <PS> DBIOAction<Map<ProcessId, ProcessAction>, NoStream, Effect.All> fetchActionsOrEmpty(Function0<DBIOAction<Map<ProcessId, ProcessAction>, NoStream, Effect.All>> doFetch, ScenarioShapeFetchStrategy<PS> evidence$4) {
        ScenarioShapeFetchStrategy scenarioShapeFetchStrategy = (ScenarioShapeFetchStrategy)Predef$.MODULE$.implicitly(evidence$4);
        DBIOAction dBIOAction = ScenarioShapeFetchStrategy$FetchComponentsUsages$.MODULE$.equals(scenarioShapeFetchStrategy) ? this.api().DBIO().successful((Object)Predef$.MODULE$.Map().empty()) : (DBIOAction)doFetch.apply();
        return dBIOAction;
    }

    @Override
    public <PS> F fetchLatestProcessDetailsForProcessId(ProcessId id, ScenarioShapeFetchStrategy<PS> evidence$5, LoggedUser loggedUser, ExecutionContext ec) {
        return (F)this.run().apply(this.fetchLatestProcessDetailsForProcessIdQuery(id, evidence$5, loggedUser, ec));
    }

    @Override
    public <PS> F fetchProcessDetailsForId(ProcessId processId, VersionId versionId, ScenarioShapeFetchStrategy<PS> evidence$6, LoggedUser loggedUser, ExecutionContext ec) {
        OptionT action = new OptionT((Object)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.api().streamableQueryActionExtensionMethods(this.fetchProcessLatestVersionsQuery(processId, ScenarioShapeFetchStrategy$NotFetch$.MODULE$))).result().headOption()).flatMap((Function1 & Serializable & scala.Serializable)latestProcessVersion -> new OptionT((Object)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.api().streamableQueryActionExtensionMethods(this.fetchProcessLatestVersionsQuery(processId, evidence$6).filter((Function1 & Serializable & scala.Serializable)pv -> new BaseColumnExtensionMethods(this.api().columnExtensionMethods(pv.id(), this.versionIdMapping())).$eq$eq$eq((Rep)this.api().valueToConstColumn((Object)versionId, this.versionIdMapping()), OptionMapper2$.MODULE$.getOptionMapper2TT(this.versionIdMapping())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()))).result().headOption()).flatMap((Function1 & Serializable & scala.Serializable)processVersion -> {
            VersionId versionId = latestProcessVersion.id();
            VersionId versionId2 = processVersion.id();
            return this.fetchProcessDetailsForVersion((ProcessVersionEntityData)processVersion, !(versionId != null ? !versionId.equals(versionId2) : versionId2 != null), evidence$6, loggedUser, ec).map((Function1 & Serializable & scala.Serializable)processDetails -> processDetails, DBIOActionInstances$.MODULE$.dbMonad(ec));
        }, DBIOActionInstances$.MODULE$.dbMonad(ec)), DBIOActionInstances$.MODULE$.dbMonad(ec));
        return (F)this.run().apply(action.value());
    }

    @Override
    public F fetchProcessId(ProcessName processName, ExecutionContext ec) {
        return (F)this.run().apply((Object)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.api().streamableQueryActionExtensionMethods(this.processesTable().filter((Function1 & Serializable & scala.Serializable)x$3 -> new BaseColumnExtensionMethods(this.api().columnExtensionMethods(x$3.name(), this.processNameMapping())).$eq$eq$eq((Rep)this.api().valueToConstColumn((Object)processName, this.processNameMapping()), OptionMapper2$.MODULE$.getOptionMapper2TT(this.processNameMapping())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.id(), Shape$.MODULE$.repColumnShape(this.processIdMapping())))).result().headOption().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.map((Function1 & Serializable & scala.Serializable)id -> id), ec));
    }

    @Override
    public F fetchProcessName(ProcessId processId, ExecutionContext ec) {
        return (F)this.run().apply((Object)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.api().streamableQueryActionExtensionMethods(this.processesTable().filter((Function1 & Serializable & scala.Serializable)x$6 -> new BaseColumnExtensionMethods(this.api().columnExtensionMethods(x$6.id(), this.processIdMapping())).$eq$eq$eq((Rep)this.api().valueToConstColumn((Object)processId, this.processIdMapping()), OptionMapper2$.MODULE$.getOptionMapper2TT(this.processIdMapping())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.name(), Shape$.MODULE$.repColumnShape(this.processNameMapping())))).result().headOption());
    }

    @Override
    public F fetchProcessingType(ProcessIdWithName processId, LoggedUser user, ExecutionContext ec) {
        ScenarioShapeFetchStrategy$NotFetch$ fetchStrategy = ScenarioShapeFetchStrategy$NotFetch$.MODULE$;
        return (F)this.run().apply((Object)this.fetchLatestProcessDetailsForProcessIdQuery(processId.id(), fetchStrategy, user, ec).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DBIOAction dBIOAction;
            Option option = x0$1;
            if (None$.MODULE$.equals(option)) {
                dBIOAction = this.api().DBIO().failed((Throwable)new ProcessDBQueryRepository.ProcessNotFoundError(processId.name()));
            } else if (option instanceof Some) {
                Some some = (Some)option;
                ScenarioWithDetailsEntity process = (ScenarioWithDetailsEntity)some.value();
                dBIOAction = this.api().DBIO().successful((Object)process.processingType());
            } else {
                throw new MatchError((Object)option);
            }
            return dBIOAction;
        }, ec));
    }

    private <PS> DBIOAction<Option<ScenarioWithDetailsEntity<PS>>, NoStream, Effect.All> fetchLatestProcessDetailsForProcessIdQuery(ProcessId id, ScenarioShapeFetchStrategy<PS> evidence$7, LoggedUser loggedUser, ExecutionContext ec) {
        return (DBIOAction)new OptionT((Object)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.api().streamableQueryActionExtensionMethods(this.fetchProcessLatestVersionsQuery(id, evidence$7))).result().headOption()).flatMap((Function1 & Serializable & scala.Serializable)latestProcessVersion -> this.fetchProcessDetailsForVersion((ProcessVersionEntityData)latestProcessVersion, true, evidence$7, loggedUser, ec).map((Function1 & Serializable & scala.Serializable)processDetails -> processDetails, DBIOActionInstances$.MODULE$.dbMonad(ec)), DBIOActionInstances$.MODULE$.dbMonad(ec)).value();
    }

    private <PS> OptionT<DBIOAction, ScenarioWithDetailsEntity<PS>> fetchProcessDetailsForVersion(ProcessVersionEntityData processVersion, boolean isLatestVersion, ScenarioShapeFetchStrategy<PS> evidence$8, LoggedUser loggedUser, ExecutionContext ec) {
        ProcessId id = processVersion.processId();
        return new OptionT((Object)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.api().streamableQueryActionExtensionMethods(this.processTableFilteredByUser(loggedUser).filter((Function1 & Serializable & scala.Serializable)x$8 -> new BaseColumnExtensionMethods(this.api().columnExtensionMethods(x$8.id(), this.processIdMapping())).$eq$eq$eq((Rep)this.api().valueToConstColumn((Object)id, this.processIdMapping()), OptionMapper2$.MODULE$.getOptionMapper2TT(this.processIdMapping())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()))).result().headOption()).flatMap((Function1 & Serializable & scala.Serializable)process -> OptionT$.MODULE$.liftF((Object)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.api().streamableQueryActionExtensionMethods(this.fetchProcessLatestVersionsQuery(id, ScenarioShapeFetchStrategy$NotFetch$.MODULE$))).result(), DBIOActionInstances$.MODULE$.dbMonad(ec)).flatMap((Function1 & Serializable & scala.Serializable)processVersions -> OptionT$.MODULE$.liftF($this.actionRepository.getFinishedProcessActions(id, (Option<Set<ScenarioActionName>>)None$.MODULE$, ec), DBIOActionInstances$.MODULE$.dbMonad(ec)).flatMap((Function1 & Serializable & scala.Serializable)actions -> OptionT$.MODULE$.liftF((Object)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.api().streamableQueryActionExtensionMethods(this.tagsTable().filter((Function1 & Serializable & scala.Serializable)x$9 -> new BaseColumnExtensionMethods(this.api().columnExtensionMethods(x$9.processId(), this.processIdMapping())).$eq$eq$eq((Rep)this.api().valueToConstColumn((Object)process.id(), this.processIdMapping()), OptionMapper2$.MODULE$.getOptionMapper2TT(this.processIdMapping())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()))).result(), DBIOActionInstances$.MODULE$.dbMonad(ec)).map((Function1 & Serializable & scala.Serializable)tags -> this.createFullDetails((ProcessEntityData)process, processVersion, (Option<ProcessAction>)actions.headOption(), (Option<ProcessAction>)actions.find((Function1 & Serializable & scala.Serializable)a -> BoxesRunTime.boxToBoolean((boolean)DBFetchingProcessRepository.$anonfun$fetchProcessDetailsForVersion$7(a))), (Option<ProcessAction>)actions.find((Function1 & Serializable & scala.Serializable)action -> BoxesRunTime.boxToBoolean((boolean)DBFetchingProcessRepository.$anonfun$fetchProcessDetailsForVersion$8(action))).filter((Function1 & Serializable & scala.Serializable)action -> BoxesRunTime.boxToBoolean((boolean)DBFetchingProcessRepository.$anonfun$fetchProcessDetailsForVersion$9(action))), isLatestVersion, (Option<Seq<TagsEntityData>>)new Some(tags), (Option<Seq<ScenarioVersion>>)new Some(processVersions.map((Function1 & Serializable & scala.Serializable)v -> ProcessDBQueryRepository$.MODULE$.toProcessVersion((ProcessVersionEntityData)v, (List<ProcessAction>)((List)actions.filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)DBFetchingProcessRepository.$anonfun$fetchProcessDetailsForVersion$11(v, p))))), Seq$.MODULE$.canBuildFrom())), evidence$8), DBIOActionInstances$.MODULE$.dbMonad(ec)), DBIOActionInstances$.MODULE$.dbMonad(ec)), DBIOActionInstances$.MODULE$.dbMonad(ec)), DBIOActionInstances$.MODULE$.dbMonad(ec));
    }

    private <PS> ScenarioWithDetailsEntity<PS> createFullDetails(ProcessEntityData process, ProcessVersionEntityData processVersion, Option<ProcessAction> lastActionData, Option<ProcessAction> lastStateActionData, Option<ProcessAction> lastDeployedActionData, boolean isLatestVersion, Option<Seq<TagsEntityData>> tags, Option<Seq<ScenarioVersion>> history, ScenarioShapeFetchStrategy<PS> evidence$9) {
        ProcessId x$1 = process.id();
        ProcessName x$2 = process.name();
        VersionId x$3 = processVersion.id();
        boolean x$4 = isLatestVersion;
        boolean x$5 = process.isArchived();
        boolean x$6 = process.isFragment();
        Option<String> x$7 = process.description();
        String x$8 = process.processingType();
        String x$9 = process.processCategory();
        Option<ProcessAction> x$102 = lastActionData;
        Option<ProcessAction> x$11 = lastStateActionData;
        Option<ProcessAction> x$122 = lastDeployedActionData;
        Option x$13 = tags.map((Function1 & Serializable & scala.Serializable)x$10 -> ((TraversableOnce)x$10.map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.name(), Seq$.MODULE$.canBuildFrom())).toList());
        Instant x$14 = processVersion.createDate().toInstant();
        Instant x$15 = processVersion.createDate().toInstant();
        String x$16 = processVersion.user();
        Instant x$17 = process.createdAt().toInstant();
        String x$18 = process.createdBy();
        PS x$19 = this.convertToTargetShape(processVersion, evidence$9);
        Option x$20 = history.map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.toList());
        Option<Object> x$21 = processVersion.modelVersion();
        return new ScenarioWithDetailsEntity<PS>(x$2, x$1, x$3, x$4, x$7, x$5, x$6, x$8, x$9, x$14, x$15, x$16, x$17, x$18, (Option<List<String>>)x$13, x$122, x$11, x$102, x$19, (Option<List<ScenarioVersion>>)x$20, x$21);
    }

    /*
     * Enabled aggressive block sorting
     */
    private <PS> PS convertToTargetShape(ProcessVersionEntityData processVersion, ScenarioShapeFetchStrategy<PS> evidence$10) {
        ScenarioShapeFetchStrategy scenarioShapeFetchStrategy;
        BoxedUnit boxedUnit;
        Tuple3 tuple3 = new Tuple3(processVersion.json(), processVersion.componentsUsages(), Predef$.MODULE$.implicitly(evidence$10));
        if (tuple3 != null) {
            Option option = (Option)tuple3._1();
            ScenarioShapeFetchStrategy scenarioShapeFetchStrategy2 = (ScenarioShapeFetchStrategy)tuple3._3();
            if (option instanceof Some) {
                Some some = (Some)option;
                CanonicalProcess canonical = (CanonicalProcess)some.value();
                if (ScenarioShapeFetchStrategy$FetchCanonical$.MODULE$.equals(scenarioShapeFetchStrategy2)) {
                    boxedUnit = canonical;
                    return (PS)boxedUnit;
                }
            }
        }
        if (tuple3 != null) {
            Option option = (Option)tuple3._1();
            ScenarioShapeFetchStrategy scenarioShapeFetchStrategy3 = (ScenarioShapeFetchStrategy)tuple3._3();
            if (option instanceof Some) {
                Some some = (Some)option;
                CanonicalProcess canonical = (CanonicalProcess)some.value();
                if (ScenarioShapeFetchStrategy$FetchScenarioGraph$.MODULE$.equals(scenarioShapeFetchStrategy3)) {
                    ScenarioGraph scenarioGraph = CanonicalProcessConverter$.MODULE$.toScenarioGraph(canonical);
                    boxedUnit = scenarioGraph;
                    return (PS)boxedUnit;
                }
            }
        }
        if (tuple3 != null && ScenarioShapeFetchStrategy$NotFetch$.MODULE$.equals(scenarioShapeFetchStrategy = (ScenarioShapeFetchStrategy)tuple3._3())) {
            boxedUnit = BoxedUnit.UNIT;
            return (PS)boxedUnit;
        }
        if (tuple3 != null) {
            Option option = (Option)tuple3._2();
            ScenarioShapeFetchStrategy scenarioShapeFetchStrategy4 = (ScenarioShapeFetchStrategy)tuple3._3();
            if (option instanceof Some) {
                Some some = (Some)option;
                ScenarioComponentsUsages componentsUsages = (ScenarioComponentsUsages)some.value();
                if (ScenarioShapeFetchStrategy$FetchComponentsUsages$.MODULE$.equals(scenarioShapeFetchStrategy4)) {
                    boxedUnit = componentsUsages;
                    return (PS)boxedUnit;
                }
            }
        }
        if (tuple3 == null) throw new MatchError((Object)tuple3);
        ScenarioShapeFetchStrategy strategy = (ScenarioShapeFetchStrategy)tuple3._3();
        throw new IllegalArgumentException(new StringBuilder(68).append("Missing scenario json data, it's required to convert for strategy: ").append(strategy).append(".").toString());
    }

    public static final /* synthetic */ Function1 $anonfun$fetchLatestProcessesDetails$1(DBFetchingProcessRepository $this, boolean arg) {
        return (Function1 & Serializable & scala.Serializable)process -> new BaseColumnExtensionMethods($this.api().columnExtensionMethods(process.isFragment(), (BaseTypedType)$this.api().booleanColumnType())).$eq$eq$eq((Rep)$this.api().valueToConstColumn((Object)BoxesRunTime.boxToBoolean((boolean)arg), (TypedType)$this.api().booleanColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)$this.api().booleanColumnType()));
    }

    public static final /* synthetic */ Function1 $anonfun$fetchLatestProcessesDetails$3(DBFetchingProcessRepository $this, boolean arg) {
        return (Function1 & Serializable & scala.Serializable)process -> new BaseColumnExtensionMethods($this.api().columnExtensionMethods(process.isArchived(), (BaseTypedType)$this.api().booleanColumnType())).$eq$eq$eq((Rep)$this.api().valueToConstColumn((Object)BoxesRunTime.boxToBoolean((boolean)arg), (TypedType)$this.api().booleanColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)$this.api().booleanColumnType()));
    }

    public static final /* synthetic */ Rep $anonfun$fetchLatestProcessesDetails$11(DBFetchingProcessRepository $this, List expr$1, ProcessEntityFactory.ProcessEntity process) {
        return (Rep)((LinearSeqOptimized)expr$1.flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).foldLeft((Object)$this.api().valueToConstColumn((Object)BoxesRunTime.boxToBoolean((boolean)true), (TypedType)$this.api().booleanColumnType()), (Function2 & Serializable & scala.Serializable)(x, y) -> BooleanColumnExtensionMethods$.MODULE$.$amp$amp$extension($this.api().booleanColumnExtensionMethods(x), (Rep)y.apply((Object)process), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)$this.api().booleanColumnType())));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$fetchLatestProcessDetailsByQueryAction$7(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        ProcessAction action = (ProcessAction)tuple2._2();
        String string = action.actionName();
        String string2 = ScenarioActionName$.MODULE$.Deploy();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Enumeration.Value value = action.state();
        Enumeration.Value value2 = ProcessActionState$.MODULE$.Finished();
        if (value == null) {
            if (value2 == null) return true;
            return false;
        } else {
            if (!value.equals(value2)) return false;
            return true;
        }
    }

    public static final /* synthetic */ boolean $anonfun$fetchProcessDetailsForVersion$7(ProcessAction a) {
        return ScenarioActionName$.MODULE$.StateActions().contains((Object)new ScenarioActionName(a.actionName()));
    }

    public static final /* synthetic */ boolean $anonfun$fetchProcessDetailsForVersion$8(ProcessAction action) {
        return ((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new ScenarioActionName[]{new ScenarioActionName(ScenarioActionName$.MODULE$.Deploy()), new ScenarioActionName(ScenarioActionName$.MODULE$.Cancel())}))).contains((Object)new ScenarioActionName(action.actionName()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$fetchProcessDetailsForVersion$9(ProcessAction action) {
        String string = action.actionName();
        String string2 = ScenarioActionName$.MODULE$.Deploy();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Enumeration.Value value = action.state();
        Enumeration.Value value2 = ProcessActionState$.MODULE$.Finished();
        if (value == null) {
            if (value2 == null) return true;
            return false;
        } else {
            if (!value.equals(value2)) return false;
            return true;
        }
    }

    public static final /* synthetic */ boolean $anonfun$fetchProcessDetailsForVersion$11(ProcessVersionEntityData v$1, ProcessAction p) {
        VersionId versionId = p.processVersionId();
        VersionId versionId2 = v$1.id();
        return !(versionId != null ? !versionId.equals(versionId2) : versionId2 != null);
    }

    public DBFetchingProcessRepository(DbRef dbRef, ProcessActionRepository actionRepository, Monad<F> evidence$1, ExecutionContext ec) {
        this.dbRef = dbRef;
        this.actionRepository = actionRepository;
        this.ec = ec;
        super(evidence$1);
        LazyLogging.$init$((LazyLogging)this);
    }
}

