/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.api;

import cats.Functor;
import cats.Invariant$;
import cats.Monad;
import cats.data.EitherT;
import cats.data.EitherT$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.net.URLConnection;
import java.time.Instant;
import java.time.ZoneId;
import java.util.UUID;
import pl.touk.nussknacker.engine.api.Comment;
import pl.touk.nussknacker.engine.api.Comment$;
import pl.touk.nussknacker.engine.api.component.ProcessingMode;
import pl.touk.nussknacker.engine.api.deployment.BatchDeploymentRelatedActivity;
import pl.touk.nussknacker.engine.api.deployment.DeploymentManager;
import pl.touk.nussknacker.engine.api.deployment.DeploymentRelatedActivity;
import pl.touk.nussknacker.engine.api.deployment.DeploymentResult;
import pl.touk.nussknacker.engine.api.deployment.Environment;
import pl.touk.nussknacker.engine.api.deployment.ManagerSpecificScenarioActivitiesStoredByManager;
import pl.touk.nussknacker.engine.api.deployment.ScenarioActivity;
import pl.touk.nussknacker.engine.api.deployment.ScenarioActivityId;
import pl.touk.nussknacker.engine.api.deployment.ScenarioAttachment;
import pl.touk.nussknacker.engine.api.deployment.ScenarioComment;
import pl.touk.nussknacker.engine.api.deployment.ScenarioUser;
import pl.touk.nussknacker.engine.api.deployment.ScenarioVersionId;
import pl.touk.nussknacker.engine.api.deployment.ScheduledExecutionStatus;
import pl.touk.nussknacker.engine.api.deployment.UserName;
import pl.touk.nussknacker.engine.api.process.ProcessId;
import pl.touk.nussknacker.engine.api.process.ProcessIdWithName;
import pl.touk.nussknacker.engine.api.process.ProcessName;
import pl.touk.nussknacker.security.AuthCredentials;
import pl.touk.nussknacker.security.Permission$;
import pl.touk.nussknacker.ui.api.AuthorizeProcess;
import pl.touk.nussknacker.ui.api.BaseHttpService;
import pl.touk.nussknacker.ui.api.DeploymentCommentSettings;
import pl.touk.nussknacker.ui.api.description.scenarioActivity.Dtos;
import pl.touk.nussknacker.ui.api.description.scenarioActivity.Dtos$Attachment$;
import pl.touk.nussknacker.ui.api.description.scenarioActivity.Dtos$GetAttachmentResponse$;
import pl.touk.nussknacker.ui.api.description.scenarioActivity.Dtos$ScenarioActivitiesMetadata$;
import pl.touk.nussknacker.ui.api.description.scenarioActivity.Dtos$ScenarioActivity$;
import pl.touk.nussknacker.ui.api.description.scenarioActivity.Dtos$ScenarioActivityAttachmentFile$Deleted$;
import pl.touk.nussknacker.ui.api.description.scenarioActivity.Dtos$ScenarioActivityCommentContent$NotAvailable$;
import pl.touk.nussknacker.ui.api.description.scenarioActivity.Dtos$ScenarioActivityError$NoPermission$;
import pl.touk.nussknacker.ui.api.description.scenarioActivity.Dtos$ScenarioType$Fragment$;
import pl.touk.nussknacker.ui.api.description.scenarioActivity.Dtos$ScenarioType$Scenario$;
import pl.touk.nussknacker.ui.api.description.scenarioActivity.Endpoints;
import pl.touk.nussknacker.ui.process.ProcessService;
import pl.touk.nussknacker.ui.process.ProcessService$GetScenarioWithDetailsOptions$;
import pl.touk.nussknacker.ui.process.ScenarioAttachmentService;
import pl.touk.nussknacker.ui.process.deployment.DeploymentManagerDispatcher;
import pl.touk.nussknacker.ui.process.repository.CommentValidationError;
import pl.touk.nussknacker.ui.process.repository.DBIOActionRunner;
import pl.touk.nussknacker.ui.process.repository.DeploymentComment$;
import pl.touk.nussknacker.ui.process.repository.activities.ScenarioActivityRepository;
import pl.touk.nussknacker.ui.process.repository.activities.ScenarioActivityRepository$DeleteAttachmentError$CouldNotDeleteAttachment$;
import pl.touk.nussknacker.ui.process.repository.activities.ScenarioActivityRepository$ModifyCommentError$ActivityDoesNotExist$;
import pl.touk.nussknacker.ui.process.repository.activities.ScenarioActivityRepository$ModifyCommentError$CommentDoesNotExist$;
import pl.touk.nussknacker.ui.process.repository.activities.ScenarioActivityRepository$ModifyCommentError$CouldNotModifyComment$;
import pl.touk.nussknacker.ui.security.api.AuthManager;
import pl.touk.nussknacker.ui.security.api.LoggedUser;
import pl.touk.nussknacker.ui.server.HeadersSupport$ContentDisposition$;
import pl.touk.nussknacker.ui.server.TapirStreamEndpointProvider;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sttp.model.MediaType$;
import sttp.tapir.EndpointInput;

@ScalaSignature(bytes="\u0006\u0001\r\u0005e\u0001B\u0012%\u0001=B\u0001B\u0010\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u000f\"Aq\n\u0001B\u0001B\u0003%\u0001\u000b\u0003\u0005Y\u0001\t\u0005\t\u0015!\u0003Z\u0011!i\u0006A!A!\u0002\u0013q\u0006\u0002C1\u0001\u0005\u0003\u0005\u000b\u0011\u00022\t\u0011\u0015\u0004!\u0011!Q\u0001\n\u0019D\u0001b\u001c\u0001\u0003\u0002\u0003\u0006I\u0001\u001d\u0005\tm\u0002\u0011\t\u0011)A\u0005o\"A1\u0010\u0001B\u0001B\u0003-A\u0010C\u0004\u0002\u0006\u0001!\t!a\u0002\t\u0013\u0005\u0005\u0002A1A\u0005\f\u0005\r\u0002\u0002CA\u001b\u0001\u0001\u0006I!!\n\t\u0013\u0005]\u0002A1A\u0005\n\u0005e\u0002\u0002CA+\u0001\u0001\u0006I!a\u000f\t\u0013\u0005]\u0003A1A\u0005\n\u0005e\u0003\u0002CA6\u0001\u0001\u0006I!a\u0017\t\u000f\u00055\u0004\u0001\"\u0003\u0002p!9\u0011\u0011\u001c\u0001\u0005\n\u0005m\u0007b\u0002B\t\u0001\u0011%!1\u0003\u0005\b\u0005O\u0001A\u0011\u0002B\u0015\u0011\u001d\u0011)\u0006\u0001C\u0005\u0005/BqA!\u0016\u0001\t\u0013\u0011i\u0007C\u0004\u0003V\u0001!IAa \t\u000f\t\u001d\u0005\u0001\"\u0003\u0003\n\"9!1\u0015\u0001\u0005\n\t\u0015\u0006b\u0002B[\u0001\u0011%!q\u0017\u0005\b\u0007\u000b\u0001A\u0011BB\u0004\u0011\u001d\u0019)\u0001\u0001C\u0005\u0007/Aqaa\n\u0001\t\u0013\u0019I\u0003C\u0004\u0004.\u0001!Iaa\f\t\u000f\rm\u0002\u0001\"\u0003\u0004>!91Q\n\u0001\u0005\n\r=\u0003bBB0\u0001\u0011%1\u0011\r\u0002\u001f'\u000e,g.\u0019:j_\u0006\u001bG/\u001b<jif\f\u0005/\u001b%uiB\u001cVM\u001d<jG\u0016T!!\n\u0014\u0002\u0007\u0005\u0004\u0018N\u0003\u0002(Q\u0005\u0011Q/\u001b\u0006\u0003S)\n1B\\;tg.t\u0017mY6fe*\u00111\u0006L\u0001\u0005i>,8NC\u0001.\u0003\t\u0001Hn\u0001\u0001\u0014\u0007\u0001\u0001D\u0007\u0005\u00022e5\tA%\u0003\u00024I\ty!)Y:f\u0011R$\boU3sm&\u001cW\r\u0005\u00026y5\taG\u0003\u00028q\u0005a1oY1mC2|wmZ5oO*\u0011\u0011HO\u0001\tif\u0004Xm]1gK*\t1(A\u0002d_6L!!\u0010\u001c\u0003\u00171\u000b'0\u001f'pO\u001eLgnZ\u0001\fCV$\b.T1oC\u001e,'\u000f\u0005\u0002A\t6\t\u0011I\u0003\u0002&\u0005*\u00111IJ\u0001\tg\u0016\u001cWO]5us&\u0011Q)\u0011\u0002\f\u0003V$\b.T1oC\u001e,'/A\u000eeKBdw._7f]Rl\u0015M\\1hKJ$\u0015n\u001d9bi\u000eDWM\u001d\t\u0003\u00116k\u0011!\u0013\u0006\u0003\u0015.\u000b!\u0002Z3qY>LX.\u001a8u\u0015\tae%A\u0004qe>\u001cWm]:\n\u00059K%a\u0007#fa2|\u00170\\3oi6\u000bg.Y4fe\u0012K7\u000f]1uG\",'/\u0001\u000etG\u0016t\u0017M]5p\u0003\u000e$\u0018N^5usJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002R-6\t!K\u0003\u0002T)\u0006Q\u0011m\u0019;jm&$\u0018.Z:\u000b\u0005U[\u0015A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011qK\u0015\u0002\u001b'\u000e,g.\u0019:j_\u0006\u001bG/\u001b<jif\u0014V\r]8tSR|'/_\u0001\u0010g\u000e,g.\u0019:j_N+'O^5dKB\u0011!lW\u0007\u0002\u0017&\u0011Al\u0013\u0002\u000f!J|7-Z:t'\u0016\u0014h/[2f\u0003I\u00198-\u001a8be&|\u0017)\u001e;i_JL'0\u001a:\u0011\u0005Ez\u0016B\u00011%\u0005A\tU\u000f\u001e5pe&TX\r\u0015:pG\u0016\u001c8/A\tbiR\f7\r[7f]R\u001cVM\u001d<jG\u0016\u0004\"AW2\n\u0005\u0011\\%!G*dK:\f'/[8BiR\f7\r[7f]R\u001cVM\u001d<jG\u0016\f\u0011\u0004Z3qY>LX.\u001a8u\u0007>lW.\u001a8u'\u0016$H/\u001b8hgB\u0019qM\u001b7\u000e\u0003!T\u0011![\u0001\u0006g\u000e\fG.Y\u0005\u0003W\"\u0014aa\u00149uS>t\u0007CA\u0019n\u0013\tqGEA\rEKBdw._7f]R\u001cu.\\7f]R\u001cV\r\u001e;j]\u001e\u001c\u0018AF:ue\u0016\fW.\u00128ea>Lg\u000e\u001e)s_ZLG-\u001a:\u0011\u0005E$X\"\u0001:\u000b\u0005M4\u0013AB:feZ,'/\u0003\u0002ve\nYB+\u00199jeN#(/Z1n\u000b:$\u0007o\\5oiB\u0013xN^5eKJ\f\u0001\u0003\u001a2j_\u0006\u001bG/[8o%Vtg.\u001a:\u0011\u0005aLX\"\u0001+\n\u0005i$&\u0001\u0005#C\u0013>\u000b5\r^5p]J+hN\\3s\u0003A)\u00070Z2vi&|gnQ8oi\u0016DH\u000fE\u0002~\u0003\u0003i\u0011A \u0006\u0003\u007f\"\f!bY8oGV\u0014(/\u001a8u\u0013\r\t\u0019A \u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\fa\u0001P5oSRtD\u0003FA\u0005\u0003\u001f\t\t\"a\u0005\u0002\u0016\u0005]\u0011\u0011DA\u000e\u0003;\ty\u0002\u0006\u0003\u0002\f\u00055\u0001CA\u0019\u0001\u0011\u0015Y8\u0002q\u0001}\u0011\u0015q4\u00021\u0001@\u0011\u001515\u00021\u0001H\u0011\u0015y5\u00021\u0001Q\u0011\u0015A6\u00021\u0001Z\u0011\u0015i6\u00021\u0001_\u0011\u0015\t7\u00021\u0001c\u0011\u0015)7\u00021\u0001g\u0011\u0015y7\u00021\u0001q\u0011\u001518\u00021\u0001x\u0003\u0019QxN\\3JIV\u0011\u0011Q\u0005\t\u0005\u0003O\t\t$\u0004\u0002\u0002*)!\u00111FA\u0017\u0003\u0011!\u0018.\\3\u000b\u0005\u0005=\u0012\u0001\u00026bm\u0006LA!a\r\u0002*\t1!l\u001c8f\u0013\u0012\fqA_8oK&#\u0007%A\u0007tK\u000e,(/\u001b;z\u0013:\u0004X\u000f^\u000b\u0003\u0003w\u0001b!!\u0010\u0002H\u0005-SBAA \u0015\u0011\t\t%a\u0011\u0002\u000bQ\f\u0007/\u001b:\u000b\u0005\u0005\u0015\u0013\u0001B:uiBLA!!\u0013\u0002@\tiQI\u001c3q_&tG/\u00138qkR\u0004B!!\u0014\u0002R5\u0011\u0011q\n\u0006\u0003\u0007\"JA!a\u0015\u0002P\ty\u0011)\u001e;i\u0007J,G-\u001a8uS\u0006d7/\u0001\btK\u000e,(/\u001b;z\u0013:\u0004X\u000f\u001e\u0011\u0002\u0013\u0015tG\r]8j]R\u001cXCAA.!\u0011\ti&a\u001a\u000e\u0005\u0005}#\u0002BA1\u0003G\n\u0001c]2f]\u0006\u0014\u0018n\\!di&4\u0018\u000e^=\u000b\u0007\u0005\u0015D%A\u0006eKN\u001c'/\u001b9uS>t\u0017\u0002BA5\u0003?\u0012\u0011\"\u00128ea>Lg\u000e^:\u0002\u0015\u0015tG\r]8j]R\u001c\b%A\nhKR\u001c6-\u001a8be&|\u0017\n\u001a\"z\u001d\u0006lW\r\u0006\u0003\u0002r\u0005=\u0007CCA:\u0003{\n\t)a\"\u0002@6\u0011\u0011Q\u000f\u0006\u0005\u0003o\nI(\u0001\u0003eCR\f'BAA>\u0003\u0011\u0019\u0017\r^:\n\t\u0005}\u0014Q\u000f\u0002\b\u000b&$\b.\u001a:U!\ri\u00181Q\u0005\u0004\u0003\u000bs(A\u0002$viV\u0014X\r\u0005\u0003\u0002\n\u0006ef\u0002BAF\u0003gsA!!$\u00020:!\u0011qRAW\u001d\u0011\t\t*a+\u000f\t\u0005M\u0015\u0011\u0016\b\u0005\u0003+\u000b9K\u0004\u0003\u0002\u0018\u0006\u0015f\u0002BAM\u0003GsA!a'\u0002\"6\u0011\u0011Q\u0014\u0006\u0004\u0003?s\u0013A\u0002\u001fs_>$h(C\u0001.\u0013\tYC&\u0003\u0002*U%\u0011q\u0005K\u0005\u0003K\u0019J1!!\u001a%\u0013\u0011\t\t'a\u0019\n\t\u0005E\u0016qL\u0001\u0005\tR|7/\u0003\u0003\u00026\u0006]\u0016!F*dK:\f'/[8BGRLg/\u001b;z\u000bJ\u0014xN\u001d\u0006\u0005\u0003c\u000by&\u0003\u0003\u0002<\u0006u&A\u0003(p'\u000e,g.\u0019:j_*!\u0011QWA\\!\u0011\t\t-a3\u000e\u0005\u0005\r'b\u0001'\u0002F*\u0019Q%a2\u000b\u0007\u0005%\u0007&\u0001\u0004f]\u001eLg.Z\u0005\u0005\u0003\u001b\f\u0019MA\u0005Qe>\u001cWm]:JI\"9\u0011\u0011\u001b\nA\u0002\u0005M\u0017\u0001D:dK:\f'/[8OC6,\u0007\u0003BAa\u0003+LA!a6\u0002D\nY\u0001K]8dKN\u001ch*Y7f\u00031I7/Q;uQ>\u0014\u0018N_3e)\u0019\ti.a>\u0002|R!\u0011q\\Aw!)\t\u0019(! \u0002\u0002\u0006\u0005\u0018q\u001d\t\u0005\u0003\u0017\u000b\u0019/\u0003\u0003\u0002f\u0006]&!F*dK:\f'/[8BGRLg/\u001b;z\u000bJ\u0014xN\u001d\t\u0004O\u0006%\u0018bAAvQ\n!QK\\5u\u0011\u001d\tyo\u0005a\u0002\u0003c\f!\u0002\\8hO\u0016$Wk]3s!\r\u0001\u00151_\u0005\u0004\u0003k\f%A\u0003'pO\u001e,G-V:fe\"9\u0011\u0011`\nA\u0002\u0005}\u0016AC:dK:\f'/[8JI\"9\u0011Q`\nA\u0002\u0005}\u0018A\u00039fe6L7o]5p]B!!\u0011\u0001B\u0006\u001d\u0011\u0011\u0019Aa\u0002\u000f\t\u0005U%QA\u0005\u0003\u0007\"JAA!\u0003\u0002P\u0005Q\u0001+\u001a:nSN\u001c\u0018n\u001c8\n\t\t5!q\u0002\u0002\u000b!\u0016\u0014X.[:tS>t'\u0002\u0002B\u0005\u0003\u001f\nACZ3uG\"\u0004&o\\2fgN\f5\r^5wSRLH\u0003\u0002B\u000b\u0005K\u0001\"\"a\u001d\u0002~\u0005\u0005\u0015\u0011\u001dB\f!\u0011\u0011IBa\b\u000f\t\u0005-%1D\u0005\u0005\u0005;\t9,\u0001\u0004MK\u001e\f7-_\u0005\u0005\u0005C\u0011\u0019CA\bQe>\u001cWm]:BGRLg/\u001b;z\u0015\u0011\u0011i\"a.\t\u000f\u0005eH\u00031\u0001\u0002@\u0006ya-\u001a;dQ\u0006\u001bG/\u001b<ji&,7\u000f\u0006\u0003\u0003,\t-C\u0003\u0002B\u0017\u0005\u0013\u0002\"\"a\u001d\u0002~\u0005\u0005\u0015\u0011\u001dB\u0018!\u0019\u0011\tDa\u000f\u0003B9!!1\u0007B\u001c\u001d\u0011\tYJ!\u000e\n\u0003%L1A!\u000fi\u0003\u001d\u0001\u0018mY6bO\u0016LAA!\u0010\u0003@\t!A*[:u\u0015\r\u0011I\u0004\u001b\t\u0005\u0005\u0007\u0012)E\u0004\u0003\u0002^\u0005=\u0016\u0002\u0002B$\u0003o\u0013\u0001cU2f]\u0006\u0014\u0018n\\!di&4\u0018\u000e^=\t\u000f\u0005=X\u0003q\u0001\u0002r\"9!QJ\u000bA\u0002\t=\u0013!\u00059s_\u000e,7o]%e/&$\bNT1nKB!\u0011\u0011\u0019B)\u0013\u0011\u0011\u0019&a1\u0003#A\u0013xnY3tg&#w+\u001b;i\u001d\u0006lW-A\u0003u_\u0012#x\u000e\u0006\u0003\u0003Z\t}\u0003\u0003\u0002B\"\u00057JAA!\u0018\u00028\n92kY3oCJLw.Q2uSZLG/_\"p[6,g\u000e\u001e\u0005\b\u0005C2\u0002\u0019\u0001B2\u0003=\u00198-\u001a8be&|7i\\7nK:$\b\u0003\u0002B3\u0005Sj!Aa\u001a\u000b\u0007)\u000b)-\u0003\u0003\u0003l\t\u001d$aD*dK:\f'/[8D_6lWM\u001c;\u0015\t\t=$Q\u000f\t\u0005\u0005\u0007\u0012\t(\u0003\u0003\u0003t\u0005]&AG*dK:\f'/[8BGRLg/\u001b;z\u0003R$\u0018m\u00195nK:$\bb\u0002B</\u0001\u0007!\u0011P\u0001\u000bCR$\u0018m\u00195nK:$\b\u0003\u0002B3\u0005wJAA! \u0003h\t\u00112kY3oCJLw.\u0011;uC\u000eDW.\u001a8u)\u0011\u0011\tE!!\t\u000f\u0005\u0005\u0004\u00041\u0001\u0003\u0004B!!Q\rBC\u0013\u0011\u00119Ea\u001a\u0002\u001b\u0005$GMT3x\u0007>lW.\u001a8u)\u0019\u0011YIa&\u0003\"R!!Q\u0012BK!)\t\u0019(! \u0002\u0002\u0006\u0005(q\u0012\t\u0005\u0005K\u0012\t*\u0003\u0003\u0003\u0014\n\u001d$AE*dK:\f'/[8BGRLg/\u001b;z\u0013\u0012Dq!a<\u001a\u0001\b\t\t\u0010C\u0004\u0003\u001af\u0001\rAa'\u0002\u000fI,\u0017/^3tiB!\u00111\u0012BO\u0013\u0011\u0011y*a.\u0003#\u0005#GmQ8n[\u0016tGOU3rk\u0016\u001cH\u000fC\u0004\u0002zf\u0001\r!a0\u0002\u0017\u0015$\u0017\u000e^\"p[6,g\u000e\u001e\u000b\u0007\u0005O\u0013YKa-\u0015\t\t5%\u0011\u0016\u0005\b\u0003_T\u00029AAy\u0011\u001d\u0011IJ\u0007a\u0001\u0005[\u0003B!a#\u00030&!!\u0011WA\\\u0005I)E-\u001b;D_6lWM\u001c;SKF,Xm\u001d;\t\u000f\u0005e(\u00041\u0001\u0002@\u0006ya/\u00197jI\u0006$XmQ8n[\u0016tG\u000f\u0006\u0004\u0003:\n\u001d(\u0011\u001f\t\t\u0005w\u0013\tM!2\u0002h6\u0011!Q\u0018\u0006\u0004\u0005\u007fC\u0017\u0001B;uS2LAAa1\u0003>\n1Q)\u001b;iKJ\u0004BAa2\u0003b:!!\u0011\u001aBn\u001d\u0011\u0011YMa6\u000f\t\t5'Q\u001b\b\u0005\u0005\u001f\u0014\u0019N\u0004\u0003\u0002\u0014\nE\u0017B\u0001''\u0013\t)6*\u0003\u0002T)&\u0019!\u0011\u001c*\u00025M\u001bWM\\1sS>\f5\r^5wSRL(+\u001a9pg&$xN]=\n\t\tu'q\\\u0001\u0013\u001b>$\u0017NZ=D_6lWM\u001c;FeJ|'OC\u0002\u0003ZJKAAa9\u0003f\nq\u0011J\u001c<bY&$7i\u001c8uK:$(\u0002\u0002Bo\u0005?DqA!;\u001c\u0001\u0004\u0011Y/A\u000ed_6lWM\u001c;N_\u0012Lg-[2bi&|g.T3uC\u0012\fG/\u0019\t\u0005\u0005\u0013\u0014i/\u0003\u0003\u0003p\n}'aG\"p[6,g\u000e^'pI&4\u0017nY1uS>tW*\u001a;bI\u0006$\u0018\rC\u0004\u0003tn\u0001\rA!>\u0002\u000f\r|g\u000e^3oiB!!q\u001fB\u0000\u001d\u0011\u0011IPa?\u0011\u0007\u0005m\u0005.C\u0002\u0003~\"\fa\u0001\u0015:fI\u00164\u0017\u0002BB\u0001\u0007\u0007\u0011aa\u0015;sS:<'b\u0001B\u007fQ\u0006iA-\u001a7fi\u0016\u001cu.\\7f]R$ba!\u0003\u0004\u000e\rUA\u0003\u0002BG\u0007\u0017Aq!a<\u001d\u0001\b\t\t\u0010C\u0004\u0003\u001ar\u0001\raa\u0004\u0011\t\u0005-5\u0011C\u0005\u0005\u0007'\t9L\u0001\u0010EKB\u0014XmY1uK\u0012$U\r\\3uK\u000e{W.\\3oiJ+\u0017/^3ti\"9\u0011\u0011 \u000fA\u0002\u0005}FCBB\r\u0007;\u0019)\u0003\u0006\u0003\u0003\u000e\u000em\u0001bBAx;\u0001\u000f\u0011\u0011\u001f\u0005\b\u00053k\u0002\u0019AB\u0010!\u0011\tYi!\t\n\t\r\r\u0012q\u0017\u0002\u0015\t\u0016dW\r^3D_6lWM\u001c;SKF,Xm\u001d;\t\u000f\u0005eX\u00041\u0001\u0002@\u0006Yb/\u00197jI\u0006$XmQ8n[\u0016tGoQ1o\u0005\u0016\u0014V-\\8wK\u0012$BA!/\u0004,!9!\u0011\u001e\u0010A\u0002\t-\u0018\u0001\u00054fi\u000eD\u0017\t\u001e;bG\"lWM\u001c;t)\u0011\u0019\td!\u000f\u0011\u0015\u0005M\u0014QPAA\u0003C\u001c\u0019\u0004\u0005\u0003\u0002\f\u000eU\u0012\u0002BB\u001c\u0003o\u00131cU2f]\u0006\u0014\u0018n\\!ui\u0006\u001c\u0007.\\3oiNDq!!? \u0001\u0004\ty,\u0001\btCZ,\u0017\t\u001e;bG\"lWM\u001c;\u0015\r\r}21IB&)\u0011\tyn!\u0011\t\u000f\u0005=\b\u0005q\u0001\u0002r\"9!\u0011\u0014\u0011A\u0002\r\u0015\u0003\u0003BAF\u0007\u000fJAa!\u0013\u00028\n!\u0012\t\u001a3BiR\f7\r[7f]R\u0014V-];fgRDq!!?!\u0001\u0004\ty,A\fnCJ\\\u0017\t\u001e;bG\"lWM\u001c;Bg\u0012+G.\u001a;fIR11\u0011KB+\u0007;\"B!a8\u0004T!9\u0011q^\u0011A\u0004\u0005E\bb\u0002BMC\u0001\u00071q\u000b\t\u0005\u0003\u0017\u001bI&\u0003\u0003\u0004\\\u0005]&a\u0006#fY\u0016$X-\u0011;uC\u000eDW.\u001a8u%\u0016\fX/Z:u\u0011\u001d\tI0\ta\u0001\u0003\u007f\u000bQBY;jY\u0012\u0014Vm\u001d9p]N,G\u0003BB2\u0007S\u0002B!a#\u0004f%!1qMA\\\u0005U9U\r^!ui\u0006\u001c\u0007.\\3oiJ+7\u000f]8og\u0016Dqaa\u001b#\u0001\u0004\u0019i'A\bnCf\u0014W-\u0011;uC\u000eDW.\u001a8u!\u00119'na\u001c\u0011\u000f\u001d\u001c\tH!>\u0004v%\u001911\u000f5\u0003\rQ+\b\u000f\\33!\u001597qOB>\u0013\r\u0019I\b\u001b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004O\u000eu\u0014bAB@Q\n!!)\u001f;f\u0001")
public class ScenarioActivityApiHttpService
extends BaseHttpService
implements LazyLogging {
    private final DeploymentManagerDispatcher deploymentManagerDispatcher;
    private final ScenarioActivityRepository scenarioActivityRepository;
    private final ProcessService scenarioService;
    private final AuthorizeProcess scenarioAuthorizer;
    private final ScenarioAttachmentService attachmentService;
    private final Option<DeploymentCommentSettings> deploymentCommentSettings;
    private final DBIOActionRunner dbioActionRunner;
    private final ExecutionContext executionContext;
    private final ZoneId zoneId;
    private final EndpointInput<AuthCredentials> securityInput;
    private final Endpoints endpoints;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        ScenarioActivityApiHttpService scenarioActivityApiHttpService = this;
        synchronized (scenarioActivityApiHttpService) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private ZoneId zoneId() {
        return this.zoneId;
    }

    private EndpointInput<AuthCredentials> securityInput() {
        return this.securityInput;
    }

    private Endpoints endpoints() {
        return this.endpoints;
    }

    private EitherT<Future, Dtos.ScenarioActivityError.NoScenario, ProcessId> getScenarioIdByName(ProcessName scenarioName) {
        return EitherT$.MODULE$.fromOptionF(this.scenarioService.getProcessId(scenarioName, this.executionContext), (Function0 & Serializable & scala.Serializable)() -> new Dtos.ScenarioActivityError.NoScenario(scenarioName), (Functor)Invariant$.MODULE$.catsInstancesForFuture(this.executionContext));
    }

    private EitherT<Future, Dtos.ScenarioActivityError, BoxedUnit> isAuthorized(ProcessId scenarioId, Enumeration.Value permission, LoggedUser loggedUser) {
        return new EitherT((Object)this.scenarioAuthorizer.check(scenarioId, permission, loggedUser).map((Function1 & Serializable & scala.Serializable)x0$1 -> ScenarioActivityApiHttpService.$anonfun$isAuthorized$1(BoxesRunTime.unboxToBoolean((Object)x0$1)), this.executionContext));
    }

    private EitherT<Future, Dtos.ScenarioActivityError, Dtos.Legacy.ProcessActivity> fetchProcessActivity(ProcessId scenarioId) {
        return EitherT.RightPartiallyApplied$.MODULE$.apply$extension(EitherT$.MODULE$.right(), this.dbioActionRunner.run(this.scenarioActivityRepository.findActivity(scenarioId)), (Functor)Invariant$.MODULE$.catsInstancesForFuture(this.executionContext));
    }

    private EitherT<Future, Dtos.ScenarioActivityError, List<Dtos.ScenarioActivity>> fetchActivities(ProcessIdWithName processIdWithName, LoggedUser loggedUser) {
        return EitherT.RightPartiallyApplied$.MODULE$.apply$extension(EitherT$.MODULE$.right(), (Object)this.dbioActionRunner.run(this.scenarioActivityRepository.findActivities(processIdWithName.id())).flatMap((Function1 & Serializable & scala.Serializable)generalActivities -> $this.deploymentManagerDispatcher.deploymentManager(processIdWithName, $this.executionContext, loggedUser).flatMap((Function1 & Serializable & scala.Serializable)deploymentManager -> {
            Future future;
            Some some;
            DeploymentManager manager;
            Option option = deploymentManager;
            if (option instanceof Some && (manager = (DeploymentManager)(some = (Some)option).value()) instanceof ManagerSpecificScenarioActivitiesStoredByManager) {
                DeploymentManager deploymentManager2 = manager;
                future = ((ManagerSpecificScenarioActivitiesStoredByManager)deploymentManager2).managerSpecificScenarioActivities(processIdWithName);
            } else {
                boolean bl = option instanceof Some ? true : None$.MODULE$.equals(option);
                if (bl) {
                    future = Future$.MODULE$.successful((Object)List$.MODULE$.empty());
                } else {
                    throw new MatchError((Object)option);
                }
            }
            return future.map((Function1 & Serializable & scala.Serializable)deploymentManagerSpecificActivities -> {
                Seq combinedActivities = (Seq)generalActivities.$plus$plus((GenTraversableOnce)deploymentManagerSpecificActivities, Seq$.MODULE$.canBuildFrom());
                Seq combinedSuccessfulActivities = (Seq)combinedActivities.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ScenarioActivityApiHttpService.$anonfun$fetchActivities$4(x0$1)));
                List sortedResult = (List)((TraversableOnce)combinedSuccessfulActivities.map((Function1 & Serializable & scala.Serializable)scenarioActivity -> this.toDto((ScenarioActivity)scenarioActivity), Seq$.MODULE$.canBuildFrom())).toList().sortBy((Function1 & Serializable & scala.Serializable)x$3 -> x$3.date(), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
                return new Tuple4(deploymentManagerSpecificActivities, (Object)combinedActivities, (Object)combinedSuccessfulActivities, (Object)sortedResult);
            }, $this.executionContext).map((Function1 & Serializable & scala.Serializable)x$4 -> {
                List sortedResult;
                Tuple4 tuple4 = x$4;
                if (tuple4 == null) {
                    throw new MatchError((Object)tuple4);
                }
                List list = sortedResult = (List)tuple4._4();
                return list;
            }, $this.executionContext);
        }, $this.executionContext), this.executionContext), (Functor)Invariant$.MODULE$.catsInstancesForFuture(this.executionContext));
    }

    private Dtos.ScenarioActivityComment toDto(ScenarioComment scenarioComment) {
        Dtos.ScenarioActivityComment scenarioActivityComment;
        ScenarioComment scenarioComment2 = scenarioComment;
        if (scenarioComment2 instanceof ScenarioComment.WithContent) {
            ScenarioComment.WithContent withContent = (ScenarioComment.WithContent)scenarioComment2;
            String comment = withContent.comment();
            scenarioActivityComment = new Dtos.ScenarioActivityComment(new Dtos.ScenarioActivityCommentContent.Available(comment), scenarioComment.lastModifiedByUserName().value(), scenarioComment.lastModifiedAt());
        } else if (scenarioComment2 instanceof ScenarioComment.WithoutContent) {
            scenarioActivityComment = new Dtos.ScenarioActivityComment(Dtos$ScenarioActivityCommentContent$NotAvailable$.MODULE$, scenarioComment.lastModifiedByUserName().value(), scenarioComment.lastModifiedAt());
        } else {
            throw new MatchError((Object)scenarioComment2);
        }
        return scenarioActivityComment;
    }

    private Dtos.ScenarioActivityAttachment toDto(ScenarioAttachment attachment) {
        Dtos.ScenarioActivityAttachment scenarioActivityAttachment;
        ScenarioAttachment scenarioAttachment = attachment;
        if (scenarioAttachment instanceof ScenarioAttachment.Available) {
            ScenarioAttachment.Available available = (ScenarioAttachment.Available)scenarioAttachment;
            long attachmentId = available.attachmentId();
            String attachmentFilename = available.attachmentFilename();
            UserName lastModifiedByUserName = available.lastModifiedByUserName();
            Instant lastModifiedAt = available.lastModifiedAt();
            scenarioActivityAttachment = new Dtos.ScenarioActivityAttachment(new Dtos.ScenarioActivityAttachmentFile.Available(attachmentId), attachmentFilename, lastModifiedByUserName.value(), lastModifiedAt);
        } else if (scenarioAttachment instanceof ScenarioAttachment.Deleted) {
            ScenarioAttachment.Deleted deleted = (ScenarioAttachment.Deleted)scenarioAttachment;
            String attachmentFilename = deleted.attachmentFilename();
            UserName deletedByUserName = deleted.deletedByUserName();
            Instant deletedAt = deleted.deletedAt();
            scenarioActivityAttachment = new Dtos.ScenarioActivityAttachment(Dtos$ScenarioActivityAttachmentFile$Deleted$.MODULE$, attachmentFilename, deletedByUserName.value(), deletedAt);
        } else {
            throw new MatchError((Object)scenarioAttachment);
        }
        return scenarioActivityAttachment;
    }

    private Dtos.ScenarioActivity toDto(ScenarioActivity scenarioActivity) {
        Dtos.ScenarioActivity scenarioActivity2;
        ScenarioActivity scenarioActivity3 = scenarioActivity;
        if (scenarioActivity3 instanceof ScenarioActivity.ScenarioCreated) {
            ScenarioActivity.ScenarioCreated scenarioCreated = (ScenarioActivity.ScenarioCreated)scenarioActivity3;
            UUID scenarioActivityId = scenarioCreated.scenarioActivityId();
            ScenarioUser user = scenarioCreated.user();
            Instant date = scenarioCreated.date();
            Option scenarioVersionId = scenarioCreated.scenarioVersionId();
            scenarioActivity2 = Dtos$ScenarioActivity$.MODULE$.forScenarioCreated(scenarioActivityId, user.name().value(), date, (Option<Object>)scenarioVersionId.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)((ScenarioVersionId)x$5).value())));
        } else if (scenarioActivity3 instanceof ScenarioActivity.ScenarioArchived) {
            ScenarioActivity.ScenarioArchived scenarioArchived = (ScenarioActivity.ScenarioArchived)scenarioActivity3;
            UUID scenarioActivityId = scenarioArchived.scenarioActivityId();
            ScenarioUser user = scenarioArchived.user();
            Instant date = scenarioArchived.date();
            Option scenarioVersionId = scenarioArchived.scenarioVersionId();
            scenarioActivity2 = Dtos$ScenarioActivity$.MODULE$.forScenarioArchived(scenarioActivityId, user.name().value(), date, (Option<Object>)scenarioVersionId.map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)((ScenarioVersionId)x$6).value())));
        } else if (scenarioActivity3 instanceof ScenarioActivity.ScenarioUnarchived) {
            ScenarioActivity.ScenarioUnarchived scenarioUnarchived = (ScenarioActivity.ScenarioUnarchived)scenarioActivity3;
            UUID scenarioActivityId = scenarioUnarchived.scenarioActivityId();
            ScenarioUser user = scenarioUnarchived.user();
            Instant date = scenarioUnarchived.date();
            Option scenarioVersionId = scenarioUnarchived.scenarioVersionId();
            scenarioActivity2 = Dtos$ScenarioActivity$.MODULE$.forScenarioUnarchived(scenarioActivityId, user.name().value(), date, (Option<Object>)scenarioVersionId.map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)((ScenarioVersionId)x$7).value())));
        } else if (scenarioActivity3 instanceof ScenarioActivity.ScenarioDeployed) {
            ScenarioActivity.ScenarioDeployed scenarioDeployed = (ScenarioActivity.ScenarioDeployed)scenarioActivity3;
            UUID scenarioActivityId = scenarioDeployed.scenarioActivityId();
            ScenarioUser user = scenarioDeployed.user();
            Instant date = scenarioDeployed.date();
            Option scenarioVersionId = scenarioDeployed.scenarioVersionId();
            ScenarioComment comment = scenarioDeployed.comment();
            scenarioActivity2 = Dtos$ScenarioActivity$.MODULE$.forScenarioDeployed(scenarioActivityId, user.name().value(), date, (Option<Object>)scenarioVersionId.map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)((ScenarioVersionId)x$8).value())), this.toDto(comment));
        } else if (scenarioActivity3 instanceof ScenarioActivity.ScenarioPaused) {
            ScenarioActivity.ScenarioPaused scenarioPaused = (ScenarioActivity.ScenarioPaused)scenarioActivity3;
            UUID scenarioActivityId = scenarioPaused.scenarioActivityId();
            ScenarioUser user = scenarioPaused.user();
            Instant date = scenarioPaused.date();
            Option scenarioVersionId = scenarioPaused.scenarioVersionId();
            ScenarioComment comment = scenarioPaused.comment();
            scenarioActivity2 = Dtos$ScenarioActivity$.MODULE$.forScenarioPaused(scenarioActivityId, user.name().value(), date, (Option<Object>)scenarioVersionId.map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)((ScenarioVersionId)x$9).value())), this.toDto(comment));
        } else if (scenarioActivity3 instanceof ScenarioActivity.ScenarioCanceled) {
            ScenarioActivity.ScenarioCanceled scenarioCanceled = (ScenarioActivity.ScenarioCanceled)scenarioActivity3;
            UUID scenarioActivityId = scenarioCanceled.scenarioActivityId();
            ScenarioUser user = scenarioCanceled.user();
            Instant date = scenarioCanceled.date();
            Option scenarioVersionId = scenarioCanceled.scenarioVersionId();
            ScenarioComment comment = scenarioCanceled.comment();
            scenarioActivity2 = Dtos$ScenarioActivity$.MODULE$.forScenarioCanceled(scenarioActivityId, user.name().value(), date, (Option<Object>)scenarioVersionId.map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)((ScenarioVersionId)x$10).value())), this.toDto(comment));
        } else if (scenarioActivity3 instanceof ScenarioActivity.ScenarioModified) {
            ScenarioActivity.ScenarioModified scenarioModified = (ScenarioActivity.ScenarioModified)scenarioActivity3;
            UUID scenarioActivityId = scenarioModified.scenarioActivityId();
            ScenarioUser user = scenarioModified.user();
            Instant date = scenarioModified.date();
            Option oldVersionId = scenarioModified.previousScenarioVersionId();
            Option newVersionId = scenarioModified.scenarioVersionId();
            ScenarioComment comment = scenarioModified.comment();
            scenarioActivity2 = Dtos$ScenarioActivity$.MODULE$.forScenarioModified(scenarioActivityId, user.name().value(), date, (Option<Object>)oldVersionId.map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)((ScenarioVersionId)x$11).value())), (Option<Object>)newVersionId.map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)((ScenarioVersionId)x$12).value())), this.toDto(comment));
        } else if (scenarioActivity3 instanceof ScenarioActivity.ScenarioNameChanged) {
            ScenarioActivity.ScenarioNameChanged scenarioNameChanged = (ScenarioActivity.ScenarioNameChanged)scenarioActivity3;
            UUID id = scenarioNameChanged.scenarioActivityId();
            ScenarioUser user = scenarioNameChanged.user();
            Instant date = scenarioNameChanged.date();
            Option version = scenarioNameChanged.scenarioVersionId();
            String oldName = scenarioNameChanged.oldName();
            String newName = scenarioNameChanged.newName();
            scenarioActivity2 = Dtos$ScenarioActivity$.MODULE$.forScenarioNameChanged(id, user.name().value(), date, (Option<Object>)version.map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)((ScenarioVersionId)x$13).value())), oldName, newName);
        } else if (scenarioActivity3 instanceof ScenarioActivity.CommentAdded) {
            ScenarioActivity.CommentAdded commentAdded = (ScenarioActivity.CommentAdded)scenarioActivity3;
            UUID scenarioActivityId = commentAdded.scenarioActivityId();
            ScenarioUser user = commentAdded.user();
            Instant date = commentAdded.date();
            Option scenarioVersionId = commentAdded.scenarioVersionId();
            ScenarioComment comment = commentAdded.comment();
            scenarioActivity2 = Dtos$ScenarioActivity$.MODULE$.forCommentAdded(scenarioActivityId, user.name().value(), date, (Option<Object>)scenarioVersionId.map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToLong((long)((ScenarioVersionId)x$14).value())), this.toDto(comment));
        } else if (scenarioActivity3 instanceof ScenarioActivity.AttachmentAdded) {
            ScenarioActivity.AttachmentAdded attachmentAdded = (ScenarioActivity.AttachmentAdded)scenarioActivity3;
            UUID scenarioActivityId = attachmentAdded.scenarioActivityId();
            ScenarioUser user = attachmentAdded.user();
            Instant date = attachmentAdded.date();
            Option scenarioVersionId = attachmentAdded.scenarioVersionId();
            ScenarioAttachment attachment = attachmentAdded.attachment();
            scenarioActivity2 = Dtos$ScenarioActivity$.MODULE$.forAttachmentAdded(scenarioActivityId, user.name().value(), date, (Option<Object>)scenarioVersionId.map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToLong((long)((ScenarioVersionId)x$15).value())), this.toDto(attachment));
        } else if (scenarioActivity3 instanceof ScenarioActivity.ChangedProcessingMode) {
            ScenarioActivity.ChangedProcessingMode changedProcessingMode = (ScenarioActivity.ChangedProcessingMode)scenarioActivity3;
            UUID scenarioActivityId = changedProcessingMode.scenarioActivityId();
            ScenarioUser user = changedProcessingMode.user();
            Instant date = changedProcessingMode.date();
            Option scenarioVersionId = changedProcessingMode.scenarioVersionId();
            ProcessingMode from = changedProcessingMode.from();
            ProcessingMode to = changedProcessingMode.to();
            scenarioActivity2 = Dtos$ScenarioActivity$.MODULE$.forChangedProcessingMode(scenarioActivityId, user.name().value(), date, (Option<Object>)scenarioVersionId.map((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToLong((long)((ScenarioVersionId)x$16).value())), from.entryName(), to.entryName());
        } else if (scenarioActivity3 instanceof ScenarioActivity.IncomingMigration) {
            ScenarioActivity.IncomingMigration incomingMigration = (ScenarioActivity.IncomingMigration)scenarioActivity3;
            UUID scenarioActivityId = incomingMigration.scenarioActivityId();
            ScenarioUser user = incomingMigration.user();
            Instant date = incomingMigration.date();
            Option scenarioVersionId = incomingMigration.scenarioVersionId();
            String sourceEnvironment = incomingMigration.sourceEnvironment();
            UserName sourceUser = incomingMigration.sourceUser();
            Option sourceScenarioVersionId = incomingMigration.sourceScenarioVersionId();
            Option targetEnvironment = incomingMigration.targetEnvironment();
            scenarioActivity2 = Dtos$ScenarioActivity$.MODULE$.forIncomingMigration(scenarioActivityId, user.name().value(), date, (Option<Object>)scenarioVersionId.map((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToLong((long)((ScenarioVersionId)x$17).value())), sourceEnvironment, sourceUser.value(), (Option<Object>)sourceScenarioVersionId.map((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToLong((long)((ScenarioVersionId)x$18).value())), (Option<String>)targetEnvironment.map((Function1 & Serializable & scala.Serializable)x$19 -> ((Environment)x$19).name()));
        } else if (scenarioActivity3 instanceof ScenarioActivity.OutgoingMigration) {
            ScenarioActivity.OutgoingMigration outgoingMigration = (ScenarioActivity.OutgoingMigration)scenarioActivity3;
            UUID scenarioActivityId = outgoingMigration.scenarioActivityId();
            ScenarioUser user = outgoingMigration.user();
            Instant date = outgoingMigration.date();
            Option scenarioVersionId = outgoingMigration.scenarioVersionId();
            String destinationEnvironment = outgoingMigration.destinationEnvironment();
            scenarioActivity2 = Dtos$ScenarioActivity$.MODULE$.forOutgoingMigration(scenarioActivityId, user.name().value(), date, (Option<Object>)scenarioVersionId.map((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToLong((long)((ScenarioVersionId)x$20).value())), destinationEnvironment);
        } else if (scenarioActivity3 instanceof ScenarioActivity.PerformedSingleExecution) {
            None$ none$;
            ScenarioActivity.PerformedSingleExecution performedSingleExecution = (ScenarioActivity.PerformedSingleExecution)scenarioActivity3;
            UUID scenarioActivityId = performedSingleExecution.scenarioActivityId();
            ScenarioUser user = performedSingleExecution.user();
            Instant date = performedSingleExecution.date();
            Option scenarioVersionId = performedSingleExecution.scenarioVersionId();
            ScenarioComment comment = performedSingleExecution.comment();
            DeploymentResult result = performedSingleExecution.result();
            String string = user.name().value();
            Option option = scenarioVersionId.map((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToLong((long)((ScenarioVersionId)x$21).value()));
            Dtos.ScenarioActivityComment scenarioActivityComment = this.toDto(comment);
            Instant instant = result.dateFinished();
            DeploymentResult deploymentResult = result;
            if (deploymentResult instanceof DeploymentResult.Success) {
                none$ = None$.MODULE$;
            } else if (deploymentResult instanceof DeploymentResult.Failure) {
                DeploymentResult.Failure failure = (DeploymentResult.Failure)deploymentResult;
                Option errorMessage = failure.errorMessage();
                none$ = errorMessage;
            } else {
                throw new MatchError((Object)deploymentResult);
            }
            scenarioActivity2 = Dtos$ScenarioActivity$.MODULE$.forPerformedSingleExecution(scenarioActivityId, string, date, (Option<Object>)option, scenarioActivityComment, instant, (Option<String>)none$, this.zoneId());
        } else if (scenarioActivity3 instanceof ScenarioActivity.PerformedScheduledExecution) {
            ScenarioActivity.PerformedScheduledExecution performedScheduledExecution = (ScenarioActivity.PerformedScheduledExecution)scenarioActivity3;
            UUID scenarioActivityId = performedScheduledExecution.scenarioActivityId();
            ScenarioUser user = performedScheduledExecution.user();
            Instant date = performedScheduledExecution.date();
            Option scenarioVersionId = performedScheduledExecution.scenarioVersionId();
            ScheduledExecutionStatus scheduledExecutionStatus = performedScheduledExecution.scheduledExecutionStatus();
            Instant dateFinished = performedScheduledExecution.dateFinished();
            String scheduleName = performedScheduledExecution.scheduleName();
            Instant createdAt = performedScheduledExecution.createdAt();
            Option nextRetryAt = performedScheduledExecution.nextRetryAt();
            Option retriesLeft = performedScheduledExecution.retriesLeft();
            UUID x$1 = scenarioActivityId;
            String x$2 = user.name().value();
            Instant x$3 = date;
            Option x$4 = scenarioVersionId.map((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToLong((long)((ScenarioVersionId)x$22).value()));
            Instant x$52 = dateFinished;
            String x$62 = scheduleName;
            ScheduledExecutionStatus x$72 = scheduledExecutionStatus;
            Instant x$82 = createdAt;
            Option x$92 = retriesLeft;
            Option x$102 = nextRetryAt;
            scenarioActivity2 = Dtos$ScenarioActivity$.MODULE$.forPerformedScheduledExecution(x$1, x$2, x$3, (Option<Object>)x$4, x$52, x$62, x$72, x$82, (Option<Instant>)x$102, (Option<Object>)x$92, this.zoneId());
        } else if (scenarioActivity3 instanceof ScenarioActivity.AutomaticUpdate) {
            ScenarioActivity.AutomaticUpdate automaticUpdate = (ScenarioActivity.AutomaticUpdate)scenarioActivity3;
            UUID scenarioActivityId = automaticUpdate.scenarioActivityId();
            ScenarioUser user = automaticUpdate.user();
            Instant date = automaticUpdate.date();
            Option scenarioVersionId = automaticUpdate.scenarioVersionId();
            String changes = automaticUpdate.changes();
            scenarioActivity2 = Dtos$ScenarioActivity$.MODULE$.forAutomaticUpdate(scenarioActivityId, user.name().value(), date, (Option<Object>)scenarioVersionId.map((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToLong((long)((ScenarioVersionId)x$23).value())), changes);
        } else if (scenarioActivity3 instanceof ScenarioActivity.CustomAction) {
            None$ none$;
            ScenarioActivity.CustomAction customAction = (ScenarioActivity.CustomAction)scenarioActivity3;
            UUID scenarioActivityId = customAction.scenarioActivityId();
            ScenarioUser user = customAction.user();
            Instant date = customAction.date();
            Option scenarioVersionId = customAction.scenarioVersionId();
            String actionName = customAction.actionName();
            ScenarioComment comment = customAction.comment();
            DeploymentResult result = customAction.result();
            UUID x$112 = scenarioActivityId;
            String x$122 = user.name().value();
            Instant x$132 = date;
            Option x$142 = scenarioVersionId.map((Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToLong((long)((ScenarioVersionId)x$24).value()));
            String x$152 = actionName;
            Dtos.ScenarioActivityComment x$162 = this.toDto(comment);
            None$ x$172 = None$.MODULE$;
            DeploymentResult deploymentResult = result;
            if (deploymentResult instanceof DeploymentResult.Success) {
                none$ = None$.MODULE$;
            } else if (deploymentResult instanceof DeploymentResult.Failure) {
                DeploymentResult.Failure failure = (DeploymentResult.Failure)deploymentResult;
                Option errorMessage = failure.errorMessage();
                none$ = errorMessage;
            } else {
                throw new MatchError((Object)deploymentResult);
            }
            None$ x$182 = none$;
            scenarioActivity2 = Dtos$ScenarioActivity$.MODULE$.forCustomAction(x$112, x$122, x$132, (Option<Object>)x$142, x$162, x$152, (Option<String>)x$172, (Option<String>)x$182);
        } else {
            throw new MatchError((Object)scenarioActivity3);
        }
        return scenarioActivity2;
    }

    private EitherT<Future, Dtos.ScenarioActivityError, ScenarioActivityId> addNewComment(Dtos.AddCommentRequest request, ProcessId scenarioId, LoggedUser loggedUser) {
        return EitherT.RightPartiallyApplied$.MODULE$.apply$extension(EitherT$.MODULE$.right(), this.dbioActionRunner.run(this.scenarioActivityRepository.addComment(scenarioId, request.versionId(), request.commentContent(), loggedUser)), (Functor)Invariant$.MODULE$.catsInstancesForFuture(this.executionContext));
    }

    private EitherT<Future, Dtos.ScenarioActivityError, ScenarioActivityId> editComment(Dtos.EditCommentRequest request, ProcessId scenarioId, LoggedUser loggedUser) {
        return new EitherT(this.dbioActionRunner.run(this.scenarioActivityRepository.editComment(scenarioId, request.scenarioActivityId(), (Function1<ScenarioActivityRepository.CommentModificationMetadata, Either<ScenarioActivityRepository.ModifyCommentError, BoxedUnit>>)(Function1 & Serializable & scala.Serializable)x$25 -> this.validateComment((ScenarioActivityRepository.CommentModificationMetadata)x$25, request.commentContent()), request.commentContent(), loggedUser))).leftMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Product product;
            ScenarioActivityRepository.ModifyCommentError modifyCommentError = x0$1;
            if (modifyCommentError instanceof ScenarioActivityRepository.ModifyCommentError.InvalidContent) {
                ScenarioActivityRepository.ModifyCommentError.InvalidContent invalidContent = (ScenarioActivityRepository.ModifyCommentError.InvalidContent)modifyCommentError;
                String error = invalidContent.error();
                product = new Dtos.ScenarioActivityError.InvalidComment(error);
            } else {
                boolean bl = ScenarioActivityRepository$ModifyCommentError$ActivityDoesNotExist$.MODULE$.equals(modifyCommentError) ? true : (ScenarioActivityRepository$ModifyCommentError$CommentDoesNotExist$.MODULE$.equals(modifyCommentError) ? true : ScenarioActivityRepository$ModifyCommentError$CouldNotModifyComment$.MODULE$.equals(modifyCommentError));
                if (bl) {
                    product = new Dtos.ScenarioActivityError.NoActivity(request.scenarioActivityId());
                } else {
                    throw new MatchError((Object)modifyCommentError);
                }
            }
            return product;
        }, (Functor)Invariant$.MODULE$.catsInstancesForFuture(this.executionContext));
    }

    private Either<ScenarioActivityRepository.ModifyCommentError.InvalidContent, BoxedUnit> validateComment(ScenarioActivityRepository.CommentModificationMetadata commentModificationMetadata, String content) {
        Right right;
        Option commentOpt = Comment$.MODULE$.from(content);
        if (commentModificationMetadata.commentForScenarioDeployed()) {
            Right right2;
            Either either = DeploymentComment$.MODULE$.createDeploymentComment((Option<Comment>)commentOpt, this.deploymentCommentSettings).toEither();
            if (either instanceof Right) {
                Right right3 = (Right)either;
                Option commentOpt2 = (Option)right3.value();
                right2 = package$.MODULE$.Right().apply((Object)commentOpt2);
            } else if (either instanceof Left) {
                Left left = (Left)either;
                CommentValidationError error = (CommentValidationError)left.value();
                right2 = package$.MODULE$.Left().apply((Object)new ScenarioActivityRepository.ModifyCommentError.InvalidContent(error.message()));
            } else {
                throw new MatchError((Object)either);
            }
            right = right2;
        } else {
            right = package$.MODULE$.Right().apply((Object)commentOpt);
        }
        Right result = right;
        return result.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Right right;
            Option option = x0$1;
            if (option instanceof Some) {
                right = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
            } else if (None$.MODULE$.equals(option)) {
                right = package$.MODULE$.Left().apply((Object)new ScenarioActivityRepository.ModifyCommentError.InvalidContent("Empty comment"));
            } else {
                throw new MatchError((Object)option);
            }
            return right;
        });
    }

    private EitherT<Future, Dtos.ScenarioActivityError, ScenarioActivityId> deleteComment(Dtos.DeprecatedDeleteCommentRequest request, ProcessId scenarioId, LoggedUser loggedUser) {
        DeploymentComment$.MODULE$.createDeploymentComment((Option<Comment>)None$.MODULE$, this.deploymentCommentSettings).toEither();
        return new EitherT(this.dbioActionRunner.run(this.scenarioActivityRepository.deleteComment(scenarioId, request.commentId(), (Function1<ScenarioActivityRepository.CommentModificationMetadata, Either<ScenarioActivityRepository.ModifyCommentError, BoxedUnit>>)(Function1 & Serializable & scala.Serializable)x$26 -> this.validateCommentCanBeRemoved((ScenarioActivityRepository.CommentModificationMetadata)x$26), loggedUser))).leftMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Product product;
            ScenarioActivityRepository.ModifyCommentError modifyCommentError = x0$1;
            if (modifyCommentError instanceof ScenarioActivityRepository.ModifyCommentError.InvalidContent) {
                ScenarioActivityRepository.ModifyCommentError.InvalidContent invalidContent = (ScenarioActivityRepository.ModifyCommentError.InvalidContent)modifyCommentError;
                String error = invalidContent.error();
                product = new Dtos.ScenarioActivityError.InvalidComment(error);
            } else {
                boolean bl = ScenarioActivityRepository$ModifyCommentError$ActivityDoesNotExist$.MODULE$.equals(modifyCommentError) ? true : (ScenarioActivityRepository$ModifyCommentError$CommentDoesNotExist$.MODULE$.equals(modifyCommentError) ? true : ScenarioActivityRepository$ModifyCommentError$CouldNotModifyComment$.MODULE$.equals(modifyCommentError));
                if (bl) {
                    product = new Dtos.ScenarioActivityError.NoComment(request.commentId());
                } else {
                    throw new MatchError((Object)modifyCommentError);
                }
            }
            return product;
        }, (Functor)Invariant$.MODULE$.catsInstancesForFuture(this.executionContext));
    }

    private EitherT<Future, Dtos.ScenarioActivityError, ScenarioActivityId> deleteComment(Dtos.DeleteCommentRequest request, ProcessId scenarioId, LoggedUser loggedUser) {
        return new EitherT(this.dbioActionRunner.run(this.scenarioActivityRepository.deleteComment(scenarioId, request.scenarioActivityId(), (Function1<ScenarioActivityRepository.CommentModificationMetadata, Either<ScenarioActivityRepository.ModifyCommentError, BoxedUnit>>)(Function1 & Serializable & scala.Serializable)x$27 -> this.validateCommentCanBeRemoved((ScenarioActivityRepository.CommentModificationMetadata)x$27), loggedUser))).leftMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Product product;
            ScenarioActivityRepository.ModifyCommentError modifyCommentError = x0$1;
            if (modifyCommentError instanceof ScenarioActivityRepository.ModifyCommentError.InvalidContent) {
                ScenarioActivityRepository.ModifyCommentError.InvalidContent invalidContent = (ScenarioActivityRepository.ModifyCommentError.InvalidContent)modifyCommentError;
                String error = invalidContent.error();
                product = new Dtos.ScenarioActivityError.InvalidComment(error);
            } else {
                boolean bl = ScenarioActivityRepository$ModifyCommentError$ActivityDoesNotExist$.MODULE$.equals(modifyCommentError) ? true : (ScenarioActivityRepository$ModifyCommentError$CommentDoesNotExist$.MODULE$.equals(modifyCommentError) ? true : ScenarioActivityRepository$ModifyCommentError$CouldNotModifyComment$.MODULE$.equals(modifyCommentError));
                if (bl) {
                    product = new Dtos.ScenarioActivityError.NoActivity(request.scenarioActivityId());
                } else {
                    throw new MatchError((Object)modifyCommentError);
                }
            }
            return product;
        }, (Functor)Invariant$.MODULE$.catsInstancesForFuture(this.executionContext));
    }

    private Either<ScenarioActivityRepository.ModifyCommentError.InvalidContent, BoxedUnit> validateCommentCanBeRemoved(ScenarioActivityRepository.CommentModificationMetadata commentModificationMetadata) {
        Right right;
        if (commentModificationMetadata.commentForScenarioDeployed()) {
            Right right2;
            Either either = DeploymentComment$.MODULE$.createDeploymentComment((Option<Comment>)None$.MODULE$, this.deploymentCommentSettings).toEither();
            if (either instanceof Right) {
                right2 = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
            } else if (either instanceof Left) {
                Left left = (Left)either;
                CommentValidationError error = (CommentValidationError)left.value();
                right2 = package$.MODULE$.Left().apply((Object)new ScenarioActivityRepository.ModifyCommentError.InvalidContent(error.message()));
            } else {
                throw new MatchError((Object)either);
            }
            right = right2;
        } else {
            right = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        }
        return right;
    }

    private EitherT<Future, Dtos.ScenarioActivityError, Dtos.ScenarioAttachments> fetchAttachments(ProcessId scenarioId) {
        return EitherT.RightPartiallyApplied$.MODULE$.apply$extension(EitherT$.MODULE$.right(), this.dbioActionRunner.run(this.scenarioActivityRepository.findAttachments(scenarioId)), (Functor)Invariant$.MODULE$.catsInstancesForFuture(this.executionContext)).map((Function1 & Serializable & scala.Serializable)x$28 -> ((TraversableOnce)x$28.map((Function1 & Serializable & scala.Serializable)attachmentEntity -> Dtos$Attachment$.MODULE$.apply(attachmentEntity.id(), attachmentEntity.processVersionId().value(), attachmentEntity.fileName(), attachmentEntity.user(), attachmentEntity.createDateTime()), Seq$.MODULE$.canBuildFrom())).toList(), (Functor)Invariant$.MODULE$.catsInstancesForFuture(this.executionContext)).map((Function1 & Serializable & scala.Serializable)attachments -> new Dtos.ScenarioAttachments((List<Dtos.Attachment>)attachments), (Functor)Invariant$.MODULE$.catsInstancesForFuture(this.executionContext));
    }

    private EitherT<Future, Dtos.ScenarioActivityError, BoxedUnit> saveAttachment(Dtos.AddAttachmentRequest request, ProcessId scenarioId, LoggedUser loggedUser) {
        return EitherT.RightPartiallyApplied$.MODULE$.apply$extension(EitherT$.MODULE$.right(), this.attachmentService.saveAttachment(scenarioId, request.versionId(), request.fileName().value(), request.body(), loggedUser), (Functor)Invariant$.MODULE$.catsInstancesForFuture(this.executionContext));
    }

    private EitherT<Future, Dtos.ScenarioActivityError, BoxedUnit> markAttachmentAsDeleted(Dtos.DeleteAttachmentRequest request, ProcessId scenarioId, LoggedUser loggedUser) {
        return new EitherT(this.dbioActionRunner.run(this.scenarioActivityRepository.markAttachmentAsDeleted(scenarioId, request.attachmentId(), loggedUser))).leftMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ScenarioActivityRepository.DeleteAttachmentError deleteAttachmentError = x0$1;
            if (!ScenarioActivityRepository$DeleteAttachmentError$CouldNotDeleteAttachment$.MODULE$.equals(deleteAttachmentError)) {
                throw new MatchError((Object)deleteAttachmentError);
            }
            Dtos.ScenarioActivityError.NoAttachment noAttachment = new Dtos.ScenarioActivityError.NoAttachment(request.attachmentId());
            return noAttachment;
        }, (Functor)Invariant$.MODULE$.catsInstancesForFuture(this.executionContext));
    }

    private Dtos.GetAttachmentResponse buildResponse(Option<Tuple2<String, byte[]>> maybeAttachment) {
        Dtos.GetAttachmentResponse getAttachmentResponse;
        Some some;
        Tuple2 tuple2;
        Option<Tuple2<String, byte[]>> option = maybeAttachment;
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            String fileName = (String)tuple2._1();
            byte[] content = (byte[])tuple2._2();
            getAttachmentResponse = new Dtos.GetAttachmentResponse(new ByteArrayInputStream(content), HeadersSupport$ContentDisposition$.MODULE$.fromFileNameString(fileName).headerValue(), (String)Option$.MODULE$.apply((Object)URLConnection.guessContentTypeFromName(fileName)).getOrElse((Function0 & Serializable & scala.Serializable)() -> MediaType$.MODULE$.ApplicationOctetStream().toString()));
        } else if (None$.MODULE$.equals(option)) {
            getAttachmentResponse = Dtos$GetAttachmentResponse$.MODULE$.emptyResponse();
        } else {
            throw new MatchError(option);
        }
        return getAttachmentResponse;
    }

    public static final /* synthetic */ void $anonfun$new$12(UUID _) {
    }

    public static final /* synthetic */ void $anonfun$new$18(UUID _) {
    }

    public static final /* synthetic */ void $anonfun$new$24(BoxedUnit _) {
    }

    public static final /* synthetic */ void $anonfun$new$30(BoxedUnit _) {
    }

    public static final /* synthetic */ void $anonfun$new$62(UUID _) {
    }

    public static final /* synthetic */ void $anonfun$new$68(UUID _) {
    }

    public static final /* synthetic */ void $anonfun$new$74(UUID _) {
    }

    public static final /* synthetic */ Either $anonfun$isAuthorized$1(boolean x0$1) {
        Right right;
        boolean bl = x0$1;
        if (bl) {
            right = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        } else if (!bl) {
            right = package$.MODULE$.Left().apply((Object)Dtos$ScenarioActivityError$NoPermission$.MODULE$);
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        return right;
    }

    public static final /* synthetic */ boolean $anonfun$fetchActivities$4(ScenarioActivity x0$1) {
        boolean bl;
        ScenarioActivity scenarioActivity = x0$1;
        if (scenarioActivity instanceof BatchDeploymentRelatedActivity) {
            bl = true;
        } else if (scenarioActivity instanceof DeploymentRelatedActivity) {
            boolean bl2;
            DeploymentRelatedActivity deploymentRelatedActivity = (DeploymentRelatedActivity)scenarioActivity;
            DeploymentResult deploymentResult = deploymentRelatedActivity.result();
            if (deploymentResult instanceof DeploymentResult.Success) {
                bl2 = true;
            } else if (deploymentResult instanceof DeploymentResult.Failure) {
                bl2 = false;
            } else {
                throw new MatchError((Object)deploymentResult);
            }
            bl = bl2;
        } else {
            bl = true;
        }
        return bl;
    }

    public ScenarioActivityApiHttpService(AuthManager authManager, DeploymentManagerDispatcher deploymentManagerDispatcher, ScenarioActivityRepository scenarioActivityRepository, ProcessService scenarioService, AuthorizeProcess scenarioAuthorizer, ScenarioAttachmentService attachmentService, Option<DeploymentCommentSettings> deploymentCommentSettings, TapirStreamEndpointProvider streamEndpointProvider, DBIOActionRunner dbioActionRunner, ExecutionContext executionContext) {
        this.deploymentManagerDispatcher = deploymentManagerDispatcher;
        this.scenarioActivityRepository = scenarioActivityRepository;
        this.scenarioService = scenarioService;
        this.scenarioAuthorizer = scenarioAuthorizer;
        this.attachmentService = attachmentService;
        this.deploymentCommentSettings = deploymentCommentSettings;
        this.dbioActionRunner = dbioActionRunner;
        this.executionContext = executionContext;
        super(authManager, executionContext);
        LazyLogging.$init$((LazyLogging)this);
        this.zoneId = ZoneId.systemDefault();
        this.securityInput = authManager.authenticationEndpointInput();
        this.endpoints = new Endpoints(this.securityInput(), streamEndpointProvider, this.zoneId());
        this.expose(this.ServerLogicExtension(this.endpoints().deprecatedScenarioActivityEndpoint().serverSecurityLogic((Function1 & Serializable & scala.Serializable)credentials -> this.authorizeKnownUser((AuthCredentials)credentials))).serverLogicEitherT((Function1 & Serializable & scala.Serializable)loggedUser -> (Function1 & Serializable & scala.Serializable)scenarioName -> this.getScenarioIdByName((ProcessName)scenarioName).flatMap((Function1 & Serializable & scala.Serializable)scenarioId -> this.isAuthorized((ProcessId)scenarioId, Permission$.MODULE$.Read(), (LoggedUser)loggedUser).flatMap((Function1 & Serializable & scala.Serializable)_ -> this.fetchProcessActivity((ProcessId)scenarioId).map((Function1 & Serializable & scala.Serializable)processActivity -> processActivity, (Functor)Invariant$.MODULE$.catsInstancesForFuture($this.executionContext)), (Monad)Invariant$.MODULE$.catsInstancesForFuture($this.executionContext)), (Monad)Invariant$.MODULE$.catsInstancesForFuture($this.executionContext))));
        this.expose(this.ServerLogicExtension(this.endpoints().deprecatedAddCommentEndpoint().serverSecurityLogic((Function1 & Serializable & scala.Serializable)credentials -> this.authorizeKnownUser((AuthCredentials)credentials))).serverLogicEitherT((Function1 & Serializable & scala.Serializable)loggedUser -> (Function1 & Serializable & scala.Serializable)request -> this.getScenarioIdByName(request.scenarioName()).flatMap((Function1 & Serializable & scala.Serializable)scenarioId -> this.isAuthorized((ProcessId)scenarioId, Permission$.MODULE$.Write(), (LoggedUser)loggedUser).flatMap((Function1 & Serializable & scala.Serializable)_2 -> this.addNewComment((Dtos.AddCommentRequest)request, (ProcessId)scenarioId, (LoggedUser)loggedUser).map((Function1 & Serializable & scala.Serializable)_ -> {
            ScenarioActivityApiHttpService.$anonfun$new$12(((ScenarioActivityId)_).value());
            return BoxedUnit.UNIT;
        }, (Functor)Invariant$.MODULE$.catsInstancesForFuture($this.executionContext)), (Monad)Invariant$.MODULE$.catsInstancesForFuture($this.executionContext)), (Monad)Invariant$.MODULE$.catsInstancesForFuture($this.executionContext))));
        this.expose(this.ServerLogicExtension(this.endpoints().deprecatedDeleteCommentEndpoint().serverSecurityLogic((Function1 & Serializable & scala.Serializable)credentials -> this.authorizeKnownUser((AuthCredentials)credentials))).serverLogicEitherT((Function1 & Serializable & scala.Serializable)loggedUser -> (Function1 & Serializable & scala.Serializable)request -> this.getScenarioIdByName(request.scenarioName()).flatMap((Function1 & Serializable & scala.Serializable)scenarioId -> this.isAuthorized((ProcessId)scenarioId, Permission$.MODULE$.Write(), (LoggedUser)loggedUser).flatMap((Function1 & Serializable & scala.Serializable)_2 -> this.deleteComment((Dtos.DeprecatedDeleteCommentRequest)request, (ProcessId)scenarioId, (LoggedUser)loggedUser).map((Function1 & Serializable & scala.Serializable)_ -> {
            ScenarioActivityApiHttpService.$anonfun$new$18(((ScenarioActivityId)_).value());
            return BoxedUnit.UNIT;
        }, (Functor)Invariant$.MODULE$.catsInstancesForFuture($this.executionContext)), (Monad)Invariant$.MODULE$.catsInstancesForFuture($this.executionContext)), (Monad)Invariant$.MODULE$.catsInstancesForFuture($this.executionContext))));
        this.expose(this.ServerLogicExtension(this.endpoints().addAttachmentEndpoint().serverSecurityLogic((Function1 & Serializable & scala.Serializable)credentials -> this.authorizeKnownUser((AuthCredentials)credentials))).serverLogicEitherT((Function1 & Serializable & scala.Serializable)loggedUser -> (Function1 & Serializable & scala.Serializable)request -> this.getScenarioIdByName(request.scenarioName()).flatMap((Function1 & Serializable & scala.Serializable)scenarioId -> this.isAuthorized((ProcessId)scenarioId, Permission$.MODULE$.Write(), (LoggedUser)loggedUser).flatMap((Function1 & Serializable & scala.Serializable)_2 -> this.saveAttachment((Dtos.AddAttachmentRequest)request, (ProcessId)scenarioId, (LoggedUser)loggedUser).map((Function1 & Serializable & scala.Serializable)_ -> {
            ScenarioActivityApiHttpService.$anonfun$new$24(_);
            return BoxedUnit.UNIT;
        }, (Functor)Invariant$.MODULE$.catsInstancesForFuture($this.executionContext)), (Monad)Invariant$.MODULE$.catsInstancesForFuture($this.executionContext)), (Monad)Invariant$.MODULE$.catsInstancesForFuture($this.executionContext))));
        this.expose(this.ServerLogicExtension(this.endpoints().deleteAttachmentEndpoint().serverSecurityLogic((Function1 & Serializable & scala.Serializable)credentials -> this.authorizeKnownUser((AuthCredentials)credentials))).serverLogicEitherT((Function1 & Serializable & scala.Serializable)loggedUser -> (Function1 & Serializable & scala.Serializable)request -> this.getScenarioIdByName(request.scenarioName()).flatMap((Function1 & Serializable & scala.Serializable)scenarioId -> this.isAuthorized((ProcessId)scenarioId, Permission$.MODULE$.Write(), (LoggedUser)loggedUser).flatMap((Function1 & Serializable & scala.Serializable)_2 -> this.markAttachmentAsDeleted((Dtos.DeleteAttachmentRequest)request, (ProcessId)scenarioId, (LoggedUser)loggedUser).map((Function1 & Serializable & scala.Serializable)_ -> {
            ScenarioActivityApiHttpService.$anonfun$new$30(_);
            return BoxedUnit.UNIT;
        }, (Functor)Invariant$.MODULE$.catsInstancesForFuture($this.executionContext)), (Monad)Invariant$.MODULE$.catsInstancesForFuture($this.executionContext)), (Monad)Invariant$.MODULE$.catsInstancesForFuture($this.executionContext))));
        this.expose(this.ServerLogicExtension(this.endpoints().downloadAttachmentEndpoint().serverSecurityLogic((Function1 & Serializable & scala.Serializable)credentials -> this.authorizeKnownUser((AuthCredentials)credentials))).serverLogicEitherT((Function1 & Serializable & scala.Serializable)loggedUser -> (Function1 & Serializable & scala.Serializable)request -> this.getScenarioIdByName(request.scenarioName()).flatMap((Function1 & Serializable & scala.Serializable)scenarioId -> this.isAuthorized((ProcessId)scenarioId, Permission$.MODULE$.Read(), (LoggedUser)loggedUser).flatMap((Function1 & Serializable & scala.Serializable)_ -> EitherT.RightPartiallyApplied$.MODULE$.apply$extension(EitherT$.MODULE$.right(), $this.attachmentService.readAttachment(request.attachmentId(), (ProcessId)scenarioId), (Functor)Invariant$.MODULE$.catsInstancesForFuture($this.executionContext)).map((Function1 & Serializable & scala.Serializable)maybeAttachment -> {
            Dtos.GetAttachmentResponse response = this.buildResponse((Option<Tuple2<String, byte[]>>)maybeAttachment);
            return new Tuple2(maybeAttachment, (Object)response);
        }, (Functor)Invariant$.MODULE$.catsInstancesForFuture($this.executionContext)).map((Function1 & Serializable & scala.Serializable)x$1 -> {
            Dtos.GetAttachmentResponse response;
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Dtos.GetAttachmentResponse getAttachmentResponse = response = (Dtos.GetAttachmentResponse)tuple2._2();
            return getAttachmentResponse;
        }, (Functor)Invariant$.MODULE$.catsInstancesForFuture($this.executionContext)), (Monad)Invariant$.MODULE$.catsInstancesForFuture($this.executionContext)), (Monad)Invariant$.MODULE$.catsInstancesForFuture($this.executionContext))));
        this.expose(this.ServerLogicExtension(this.endpoints().scenarioActivitiesEndpoint().serverSecurityLogic((Function1 & Serializable & scala.Serializable)credentials -> this.authorizeKnownUser((AuthCredentials)credentials))).serverLogicEitherT((Function1 & Serializable & scala.Serializable)loggedUser -> (Function1 & Serializable & scala.Serializable)scenarioName -> this.getScenarioIdByName((ProcessName)scenarioName).flatMap((Function1 & Serializable & scala.Serializable)scenarioId -> this.isAuthorized((ProcessId)scenarioId, Permission$.MODULE$.Read(), (LoggedUser)loggedUser).flatMap((Function1 & Serializable & scala.Serializable)_ -> this.fetchActivities(new ProcessIdWithName(scenarioId, scenarioName), (LoggedUser)loggedUser).map((Function1 & Serializable & scala.Serializable)activities -> new Dtos.ScenarioActivities((List<Dtos.ScenarioActivity>)activities), (Functor)Invariant$.MODULE$.catsInstancesForFuture($this.executionContext)), (Monad)Invariant$.MODULE$.catsInstancesForFuture($this.executionContext)), (Monad)Invariant$.MODULE$.catsInstancesForFuture($this.executionContext))));
        this.expose(this.ServerLogicExtension(this.endpoints().attachmentsEndpoint().serverSecurityLogic((Function1 & Serializable & scala.Serializable)credentials -> this.authorizeKnownUser((AuthCredentials)credentials))).serverLogicEitherT((Function1 & Serializable & scala.Serializable)loggedUser -> (Function1 & Serializable & scala.Serializable)processName -> this.getScenarioIdByName((ProcessName)processName).flatMap((Function1 & Serializable & scala.Serializable)scenarioId -> this.isAuthorized((ProcessId)scenarioId, Permission$.MODULE$.Read(), (LoggedUser)loggedUser).flatMap((Function1 & Serializable & scala.Serializable)_ -> this.fetchAttachments((ProcessId)scenarioId).map((Function1 & Serializable & scala.Serializable)attachments -> attachments, (Functor)Invariant$.MODULE$.catsInstancesForFuture($this.executionContext)), (Monad)Invariant$.MODULE$.catsInstancesForFuture($this.executionContext)), (Monad)Invariant$.MODULE$.catsInstancesForFuture($this.executionContext))));
        this.expose(this.ServerLogicExtension(this.endpoints().scenarioActivitiesMetadataEndpoint().serverSecurityLogic((Function1 & Serializable & scala.Serializable)credentials -> this.authorizeKnownUser((AuthCredentials)credentials))).serverLogicEitherT((Function1 & Serializable & scala.Serializable)loggedUser -> (Function1 & Serializable & scala.Serializable)scenarioName -> this.getScenarioIdByName((ProcessName)scenarioName).flatMap((Function1 & Serializable & scala.Serializable)scenarioId -> this.isAuthorized((ProcessId)scenarioId, Permission$.MODULE$.Read(), (LoggedUser)loggedUser).flatMap((Function1 & Serializable & scala.Serializable)_ -> EitherT.RightPartiallyApplied$.MODULE$.apply$extension(EitherT$.MODULE$.right(), $this.scenarioService.getLatestProcessWithDetails(new ProcessIdWithName(scenarioId, scenarioName), ProcessService$GetScenarioWithDetailsOptions$.MODULE$.detailsOnly(), (LoggedUser)loggedUser), (Functor)Invariant$.MODULE$.catsInstancesForFuture($this.executionContext)).map((Function1 & Serializable & scala.Serializable)scenarioWithDetails -> {
            Product scenarioType = scenarioWithDetails.isFragment() ? Dtos$ScenarioType$Fragment$.MODULE$ : Dtos$ScenarioType$Scenario$.MODULE$;
            Dtos.ScenarioActivitiesMetadata metadata = Dtos$ScenarioActivitiesMetadata$.MODULE$.default((Dtos.ScenarioType)scenarioType);
            return new Tuple3(scenarioWithDetails, (Object)scenarioType, (Object)metadata);
        }, (Functor)Invariant$.MODULE$.catsInstancesForFuture($this.executionContext)).map((Function1 & Serializable & scala.Serializable)x$2 -> {
            Dtos.ScenarioActivitiesMetadata metadata;
            Tuple3 tuple3 = x$2;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            Dtos.ScenarioActivitiesMetadata scenarioActivitiesMetadata = metadata = (Dtos.ScenarioActivitiesMetadata)tuple3._3();
            return scenarioActivitiesMetadata;
        }, (Functor)Invariant$.MODULE$.catsInstancesForFuture($this.executionContext)), (Monad)Invariant$.MODULE$.catsInstancesForFuture($this.executionContext)), (Monad)Invariant$.MODULE$.catsInstancesForFuture($this.executionContext))));
        this.expose(this.ServerLogicExtension(this.endpoints().addCommentEndpoint().serverSecurityLogic((Function1 & Serializable & scala.Serializable)credentials -> this.authorizeKnownUser((AuthCredentials)credentials))).serverLogicEitherT((Function1 & Serializable & scala.Serializable)loggedUser -> (Function1 & Serializable & scala.Serializable)request -> this.getScenarioIdByName(request.scenarioName()).flatMap((Function1 & Serializable & scala.Serializable)scenarioId -> this.isAuthorized((ProcessId)scenarioId, Permission$.MODULE$.Write(), (LoggedUser)loggedUser).flatMap((Function1 & Serializable & scala.Serializable)_2 -> this.addNewComment((Dtos.AddCommentRequest)request, (ProcessId)scenarioId, (LoggedUser)loggedUser).map((Function1 & Serializable & scala.Serializable)_ -> {
            ScenarioActivityApiHttpService.$anonfun$new$62(((ScenarioActivityId)_).value());
            return BoxedUnit.UNIT;
        }, (Functor)Invariant$.MODULE$.catsInstancesForFuture($this.executionContext)), (Monad)Invariant$.MODULE$.catsInstancesForFuture($this.executionContext)), (Monad)Invariant$.MODULE$.catsInstancesForFuture($this.executionContext))));
        this.expose(this.ServerLogicExtension(this.endpoints().editCommentEndpoint().serverSecurityLogic((Function1 & Serializable & scala.Serializable)credentials -> this.authorizeKnownUser((AuthCredentials)credentials))).serverLogicEitherT((Function1 & Serializable & scala.Serializable)loggedUser -> (Function1 & Serializable & scala.Serializable)request -> this.getScenarioIdByName(request.scenarioName()).flatMap((Function1 & Serializable & scala.Serializable)scenarioId -> this.isAuthorized((ProcessId)scenarioId, Permission$.MODULE$.Write(), (LoggedUser)loggedUser).flatMap((Function1 & Serializable & scala.Serializable)_2 -> this.editComment((Dtos.EditCommentRequest)request, (ProcessId)scenarioId, (LoggedUser)loggedUser).map((Function1 & Serializable & scala.Serializable)_ -> {
            ScenarioActivityApiHttpService.$anonfun$new$68(((ScenarioActivityId)_).value());
            return BoxedUnit.UNIT;
        }, (Functor)Invariant$.MODULE$.catsInstancesForFuture($this.executionContext)), (Monad)Invariant$.MODULE$.catsInstancesForFuture($this.executionContext)), (Monad)Invariant$.MODULE$.catsInstancesForFuture($this.executionContext))));
        this.expose(this.ServerLogicExtension(this.endpoints().deleteCommentEndpoint().serverSecurityLogic((Function1 & Serializable & scala.Serializable)credentials -> this.authorizeKnownUser((AuthCredentials)credentials))).serverLogicEitherT((Function1 & Serializable & scala.Serializable)loggedUser -> (Function1 & Serializable & scala.Serializable)request -> this.getScenarioIdByName(request.scenarioName()).flatMap((Function1 & Serializable & scala.Serializable)scenarioId -> this.isAuthorized((ProcessId)scenarioId, Permission$.MODULE$.Write(), (LoggedUser)loggedUser).flatMap((Function1 & Serializable & scala.Serializable)_2 -> this.deleteComment((Dtos.DeleteCommentRequest)request, (ProcessId)scenarioId, (LoggedUser)loggedUser).map((Function1 & Serializable & scala.Serializable)_ -> {
            ScenarioActivityApiHttpService.$anonfun$new$74(((ScenarioActivityId)_).value());
            return BoxedUnit.UNIT;
        }, (Functor)Invariant$.MODULE$.catsInstancesForFuture($this.executionContext)), (Monad)Invariant$.MODULE$.catsInstancesForFuture($this.executionContext)), (Monad)Invariant$.MODULE$.catsInstancesForFuture($this.executionContext))));
    }
}

