/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.api;

import cats.Functor;
import cats.Invariant$;
import cats.Monad;
import cats.data.EitherT;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import pl.touk.nussknacker.engine.api.MetaData;
import pl.touk.nussknacker.engine.api.definition.Parameter;
import pl.touk.nussknacker.engine.api.graph.ScenarioGraph;
import pl.touk.nussknacker.engine.api.process.ProcessName;
import pl.touk.nussknacker.engine.definition.test.TestingCapabilities;
import pl.touk.nussknacker.restmodel.definition.package;
import pl.touk.nussknacker.restmodel.scenariodetails.ScenarioWithDetails;
import pl.touk.nussknacker.restmodel.validation.ValidationResults;
import pl.touk.nussknacker.security.AuthCredentials;
import pl.touk.nussknacker.ui.api.BaseHttpService;
import pl.touk.nussknacker.ui.api.TestingApiHttpService;
import pl.touk.nussknacker.ui.api.TestingApiHttpService$TestingError$NoPermission$;
import pl.touk.nussknacker.ui.api.description.NodesApiEndpoints;
import pl.touk.nussknacker.ui.api.description.TestingApiEndpoints;
import pl.touk.nussknacker.ui.api.utils.ScenarioHttpServiceExtensions;
import pl.touk.nussknacker.ui.process.ProcessService;
import pl.touk.nussknacker.ui.process.processingtype.provider.ProcessingTypeDataProvider;
import pl.touk.nussknacker.ui.process.test.RawScenarioTestData;
import pl.touk.nussknacker.ui.process.test.ScenarioTestService;
import pl.touk.nussknacker.ui.security.api.AuthManager;
import pl.touk.nussknacker.ui.security.api.LoggedUser;
import pl.touk.nussknacker.ui.validation.ParametersValidator;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple6;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sttp.tapir.EndpointInput;

@ScalaSignature(bytes="\u0006\u0001\u0011udaBA\u0006\u0003\u001b\u0001\u00111\u0005\u0005\u000b\u0003\u001b\u0002!\u0011!Q\u0001\n\u0005=\u0003BCA/\u0001\t\u0005\t\u0015!\u0003\u0002`!Q\u0011Q\u0014\u0001\u0003\u0002\u0003\u0006I!a(\t\u0015\u0005U\u0006A!b\u0001\n#\n9\f\u0003\u0006\u0002B\u0002\u0011\t\u0011)A\u0005\u0003sC!\"a1\u0001\u0005\u000b\u0007I1KAc\u0011)\t\u0019\u000e\u0001B\u0001B\u0003%\u0011q\u0019\u0005\b\u0003+\u0004A\u0011AAl\u000b\u0019\t9\u0010\u0001\u0015\u0002z\"9A1\f\u0001\u0005R\u0011u\u0003b\u0002C1\u0001\u0011EC1\r\u0005\n\tW\u0002!\u0019!C\u0005\t[B\u0001\u0002b\u001f\u0001A\u0003%AqN\u0004\t\u0005/\ti\u0001#\u0001\u0003\u001a\u0019A\u00111BA\u0007\u0011\u0003\u0011Y\u0002C\u0004\u0002V>!\tAa\t\u0007\u0013\t\u0015r\u0002%A\u0012\"\t\u001dra\u0002C\u0012\u001f!\u0005!\u0011\u0007\u0004\b\u0005Ky\u0001\u0012\u0001B\u0017\u0011\u001d\t)n\u0005C\u0001\u0005_1aA!\u000e\u0014\u0005\n]\u0002B\u0003B$+\tU\r\u0011\"\u0001\u0003J!Q!1L\u000b\u0003\u0012\u0003\u0006IAa\u0013\t\u000f\u0005UW\u0003\"\u0001\u0003^!I!QM\u000b\u0002\u0002\u0013\u0005!q\r\u0005\n\u0005W*\u0012\u0013!C\u0001\u0005[B\u0011Ba!\u0016\u0003\u0003%\tE!\"\t\u0013\tUU#!A\u0005\u0002\t]\u0005\"\u0003BP+\u0005\u0005I\u0011\u0001BQ\u0011%\u00119+FA\u0001\n\u0003\u0012I\u000bC\u0005\u00038V\t\t\u0011\"\u0001\u0003:\"I!1Y\u000b\u0002\u0002\u0013\u0005#Q\u0019\u0005\n\u0005\u000f,\u0012\u0011!C!\u0005\u0013D\u0011Ba3\u0016\u0003\u0003%\tE!4\b\u0013\tE7#!A\t\u0002\tMg!\u0003B\u001b'\u0005\u0005\t\u0012\u0001Bk\u0011\u001d\t)\u000e\nC\u0001\u0005GD\u0011Ba2%\u0003\u0003%)E!3\t\u0013\t\u0015H%!A\u0005\u0002\n\u001d\b\"\u0003BvI\u0005\u0005I\u0011\u0011Bw\u0011%\u0011I\u0010JA\u0001\n\u0013\u0011YP\u0002\u0004\u0004\u0004M\u00115Q\u0001\u0005\u000b\u0007\u000fQ#Q3A\u0005\u0002\r%\u0001BCB\u000eU\tE\t\u0015!\u0003\u0004\f!9\u0011Q\u001b\u0016\u0005\u0002\ru\u0001\"\u0003B3U\u0005\u0005I\u0011AB\u0012\u0011%\u0011YGKI\u0001\n\u0003\u00199\u0003C\u0005\u0003\u0004*\n\t\u0011\"\u0011\u0003\u0006\"I!Q\u0013\u0016\u0002\u0002\u0013\u0005!q\u0013\u0005\n\u0005?S\u0013\u0011!C\u0001\u0007WA\u0011Ba*+\u0003\u0003%\tE!+\t\u0013\t]&&!A\u0005\u0002\r=\u0002\"\u0003BbU\u0005\u0005I\u0011\tBc\u0011%\u00119MKA\u0001\n\u0003\u0012I\rC\u0005\u0003L*\n\t\u0011\"\u0011\u00044\u001dI1qG\n\u0002\u0002#\u00051\u0011\b\u0004\n\u0007\u0007\u0019\u0012\u0011!E\u0001\u0007wAq!!6:\t\u0003\u0019y\u0004C\u0005\u0003Hf\n\t\u0011\"\u0012\u0003J\"I!Q]\u001d\u0002\u0002\u0013\u00055\u0011\t\u0005\n\u0005WL\u0014\u0011!CA\u0007\u000bB\u0011B!?:\u0003\u0003%IAa?\u0007\r\r-3CQB'\u0011)\u0019ye\u0010BK\u0002\u0013\u00051\u0011\u000b\u0005\u000b\u0007[z$\u0011#Q\u0001\n\rM\u0003bBAk\u007f\u0011\u00051q\u000e\u0005\n\u0005Kz\u0014\u0011!C\u0001\u0007kB\u0011Ba\u001b@#\u0003%\ta!\u001f\t\u0013\t\ru(!A\u0005B\t\u0015\u0005\"\u0003BK\u007f\u0005\u0005I\u0011\u0001BL\u0011%\u0011yjPA\u0001\n\u0003\u0019i\bC\u0005\u0003(~\n\t\u0011\"\u0011\u0003*\"I!qW \u0002\u0002\u0013\u00051\u0011\u0011\u0005\n\u0005\u0007|\u0014\u0011!C!\u0005\u000bD\u0011Ba2@\u0003\u0003%\tE!3\t\u0013\t-w(!A\u0005B\r\u0015u!CBE'\u0005\u0005\t\u0012ABF\r%\u0019YeEA\u0001\u0012\u0003\u0019i\tC\u0004\u0002V:#\ta!%\t\u0013\t\u001dg*!A\u0005F\t%\u0007\"\u0003Bs\u001d\u0006\u0005I\u0011QBJ\u0011%\u0011YOTA\u0001\n\u0003\u001b9\nC\u0005\u0003z:\u000b\t\u0011\"\u0003\u0003|\u001e91QT\n\t\u0006\u000e}eaBBQ'!\u001551\u0015\u0005\b\u0003+,F\u0011ABZ\u0011%\u0011\u0019)VA\u0001\n\u0003\u0012)\tC\u0005\u0003\u0016V\u000b\t\u0011\"\u0001\u0003\u0018\"I!qT+\u0002\u0002\u0013\u00051Q\u0017\u0005\n\u0005O+\u0016\u0011!C!\u0005SC\u0011Ba.V\u0003\u0003%\ta!/\t\u0013\t\rW+!A\u0005B\t\u0015\u0007\"\u0003Bd+\u0006\u0005I\u0011\tBe\u0011%\u0011I0VA\u0001\n\u0013\u0011YP\u0002\u0004\u0003,M\u0011EQ\u0002\u0005\u000b\u0005\u000fz&Q3A\u0005\u0002\t%\u0003B\u0003B.?\nE\t\u0015!\u0003\u0003L!9\u0011Q[0\u0005\u0002\u0011=\u0001\"\u0003B3?\u0006\u0005I\u0011\u0001C\n\u0011%\u0011YgXI\u0001\n\u0003\u0011i\u0007C\u0005\u0003\u0004~\u000b\t\u0011\"\u0011\u0003\u0006\"I!QS0\u0002\u0002\u0013\u0005!q\u0013\u0005\n\u0005?{\u0016\u0011!C\u0001\t/A\u0011Ba*`\u0003\u0003%\tE!+\t\u0013\t]v,!A\u0005\u0002\u0011m\u0001\"\u0003Bb?\u0006\u0005I\u0011\tBc\u0011%\u00119mXA\u0001\n\u0003\u0012I\rC\u0005\u0003L~\u000b\t\u0011\"\u0011\u0005 \u001dI1QX\n\u0002\u0002#\u00051q\u0018\u0004\n\u0005W\u0019\u0012\u0011!E\u0001\u0007\u0003Dq!!6o\t\u0003\u00199\rC\u0005\u0003H:\f\t\u0011\"\u0012\u0003J\"I!Q\u001d8\u0002\u0002\u0013\u00055\u0011\u001a\u0005\n\u0005Wt\u0017\u0011!CA\u0007\u001bD\u0011B!?o\u0003\u0003%IAa?\t\u0013\rE7C1A\u0005\u0004\rM\u0007\u0002CBz'\u0001\u0006Ia!6\t\u0013\rU8C1A\u0005\u0004\r]\b\u0002CB~'\u0001\u0006Ia!?\t\u0013\ru8C1A\u0005\u0004\r}\b\u0002\u0003C\u0002'\u0001\u0006I\u0001\"\u0001\t\u0013\u0011\u00151C1A\u0005\u0004\u0011\u001d\u0001\u0002\u0003C\u0006'\u0001\u0006I\u0001\"\u0003\b\u000f\u0011\u0015r\u0002#\u0001\u0005(\u00199A\u0011F\b\t\u0002\u0011-\u0002bBAk{\u0012\u0005AQ\u0006\u0005\n\t_i(\u0019!C\u0001\tcA\u0001\u0002\"\u0012~A\u0003%A1\u0007\u0005\n\t\u000fj(\u0019!C\u0001\t\u0013B\u0001\u0002b\u0014~A\u0003%A1\n\u0005\n\t#j(\u0019!C\u0001\t'B\u0001\u0002\"\u0017~A\u0003%AQ\u000b\u0002\u0016)\u0016\u001cH/\u001b8h\u0003BL\u0007\n\u001e;q'\u0016\u0014h/[2f\u0015\u0011\ty!!\u0005\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002\u0014\u0005U\u0011AA;j\u0015\u0011\t9\"!\u0007\u0002\u00179,8o]6oC\u000e\\WM\u001d\u0006\u0005\u00037\ti\"\u0001\u0003u_V\\'BAA\u0010\u0003\t\u0001Hn\u0001\u0001\u0014\u000f\u0001\t)#!\f\u0002:A!\u0011qEA\u0015\u001b\t\ti!\u0003\u0003\u0002,\u00055!a\u0004\"bg\u0016DE\u000f\u001e9TKJ4\u0018nY3\u0011\t\u0005=\u0012QG\u0007\u0003\u0003cQA!a\r\u0002\u000e\u0005)Q\u000f^5mg&!\u0011qGA\u0019\u0005u\u00196-\u001a8be&|\u0007\n\u001e;q'\u0016\u0014h/[2f\u000bb$XM\\:j_:\u001c\b\u0003BA\u001e\u0003\u0013j!!!\u0010\u000b\t\u0005}\u0012\u0011I\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0005\u0003\u0007\n)%\u0001\u0005usB,7/\u00194f\u0015\t\t9%A\u0002d_6LA!a\u0013\u0002>\tYA*\u0019>z\u0019><w-\u001b8h\u0003-\tW\u000f\u001e5NC:\fw-\u001a:\u0011\t\u0005E\u0013\u0011L\u0007\u0003\u0003'RA!a\u0004\u0002V)!\u0011qKA\t\u0003!\u0019XmY;sSRL\u0018\u0002BA.\u0003'\u00121\"Q;uQ6\u000bg.Y4fe\u0006\u0019\u0003O]8dKN\u001c\u0018N\\4UsB,Gk\u001c)be\u0006lW\r^3sgZ\u000bG.\u001b3bi>\u0014\b\u0007BA1\u0003\u000b\u0003\u0002\"a\u0019\u0002r\u0005U\u0014\u0011Q\u0007\u0003\u0003KRA!a\u001a\u0002j\u0005A\u0001O]8wS\u0012,'O\u0003\u0003\u0002l\u00055\u0014A\u00049s_\u000e,7o]5oORL\b/\u001a\u0006\u0005\u0003_\n\t\"A\u0004qe>\u001cWm]:\n\t\u0005M\u0014Q\r\u0002\u001b!J|7-Z:tS:<G+\u001f9f\t\u0006$\u0018\r\u0015:pm&$WM\u001d\t\u0005\u0003o\ni(\u0004\u0002\u0002z)!\u00111PA\t\u0003)1\u0018\r\\5eCRLwN\\\u0005\u0005\u0003\u007f\nIHA\nQCJ\fW.\u001a;feN4\u0016\r\\5eCR|'\u000f\u0005\u0003\u0002\u0004\u0006\u0015E\u0002\u0001\u0003\f\u0003\u000f\u0013\u0011\u0011!A\u0001\u0006\u0003\tIIA\u0002`IE\nB!a#\u0002\u0018B!\u0011QRAJ\u001b\t\tyI\u0003\u0002\u0002\u0012\u0006)1oY1mC&!\u0011QSAH\u0005\u001dqu\u000e\u001e5j]\u001e\u0004B!!$\u0002\u001a&!\u00111TAH\u0005\r\te._\u0001%aJ|7-Z:tS:<G+\u001f9f)>\u001c6-\u001a8be&|G+Z:u'\u0016\u0014h/[2fgB\"\u0011\u0011UAY!!\t\u0019'!\u001d\u0002$\u0006=\u0006\u0003BAS\u0003Wk!!a*\u000b\t\u0005%\u0016QN\u0001\u0005i\u0016\u001cH/\u0003\u0003\u0002.\u0006\u001d&aE*dK:\f'/[8UKN$8+\u001a:wS\u000e,\u0007\u0003BAB\u0003c#1\"a-\u0004\u0003\u0003\u0005\tQ!\u0001\u0002\n\n\u0019q\f\n\u001a\u0002\u001fM\u001cWM\\1sS>\u001cVM\u001d<jG\u0016,\"!!/\u0011\t\u0005m\u0016QX\u0007\u0003\u0003[JA!a0\u0002n\tq\u0001K]8dKN\u001c8+\u001a:wS\u000e,\u0017\u0001E:dK:\f'/[8TKJ4\u0018nY3!\u0003A)\u00070Z2vi&|gnQ8oi\u0016DH/\u0006\u0002\u0002HB!\u0011\u0011ZAh\u001b\t\tYM\u0003\u0003\u0002N\u0006=\u0015AC2p]\u000e,(O]3oi&!\u0011\u0011[Af\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH/A\tfq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0002\na\u0001P5oSRtDCCAm\u0003?\f\t/a;\u0002vR!\u00111\\Ao!\r\t9\u0003\u0001\u0005\b\u0003\u0007D\u00019AAd\u0011\u001d\ti\u0005\u0003a\u0001\u0003\u001fBq!!\u0018\t\u0001\u0004\t\u0019\u000f\r\u0003\u0002f\u0006%\b\u0003CA2\u0003c\n)(a:\u0011\t\u0005\r\u0015\u0011\u001e\u0003\r\u0003\u000f\u000b\t/!A\u0001\u0002\u000b\u0005\u0011\u0011\u0012\u0005\b\u0003;C\u0001\u0019AAwa\u0011\ty/a=\u0011\u0011\u0005\r\u0014\u0011OAR\u0003c\u0004B!a!\u0002t\u0012a\u00111WAv\u0003\u0003\u0005\tQ!\u0001\u0002\n\"9\u0011Q\u0017\u0005A\u0002\u0005e&!\u0005\"vg&tWm]:FeJ|'\u000fV=qKB\u0019\u00111`\t\u000f\u0007\u0005uhB\u0004\u0003\u0002\u0000\nUa\u0002\u0002B\u0001\u0005'qAAa\u0001\u0003\u00129!!Q\u0001B\b\u001d\u0011\u00119A!\u0004\u000e\u0005\t%!\u0002\u0002B\u0006\u0003C\ta\u0001\u0010:p_Rt\u0014BAA\u0010\u0013\u0011\tY\"!\b\n\t\u0005]\u0011\u0011D\u0005\u0005\u0003'\t)\"\u0003\u0003\u0002\u0010\u0005E\u0011!\u0006+fgRLgnZ!qS\"#H\u000f]*feZL7-\u001a\t\u0004\u0003Oy1cA\b\u0003\u001eA!\u0011Q\u0012B\u0010\u0013\u0011\u0011\t#a$\u0003\r\u0005s\u0017PU3g)\t\u0011IB\u0001\u0007UKN$\u0018N\\4FeJ|'oE\u0002\u0012\u0005;Ic!E0V\u007f)*\"!F'bY\u001a|'/\\3e)f\u0004\u0018N\\4SKN,H\u000e^\n\u0004'\tuAC\u0001B\u0019!\r\u0011\u0019dE\u0007\u0002\u001f\t9B+Z:u\t\u0006$\u0018mR3oKJ\fG/[8o\u000bJ\u0014xN]\n\n+\tu!\u0011\bB\u001e\u0005\u0003\u00022Aa\r\u0012!\u0011\tiI!\u0010\n\t\t}\u0012q\u0012\u0002\b!J|G-^2u!\u0011\tiIa\u0011\n\t\t\u0015\u0013q\u0012\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0004[N<WC\u0001B&!\u0011\u0011iE!\u0016\u000f\t\t=#\u0011\u000b\t\u0005\u0005\u000f\ty)\u0003\u0003\u0003T\u0005=\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0003X\te#AB*ue&twM\u0003\u0003\u0003T\u0005=\u0015\u0001B7tO\u0002\"BAa\u0018\u0003dA\u0019!\u0011M\u000b\u000e\u0003MAqAa\u0012\u0019\u0001\u0004\u0011Y%\u0001\u0003d_BLH\u0003\u0002B0\u0005SB\u0011Ba\u0012\u001a!\u0003\u0005\rAa\u0013\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!q\u000e\u0016\u0005\u0005\u0017\u0012\th\u000b\u0002\u0003tA!!Q\u000fB@\u001b\t\u00119H\u0003\u0003\u0003z\tm\u0014!C;oG\",7m[3e\u0015\u0011\u0011i(a$\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\u0002\n]$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"Aa\"\u0011\t\t%%1S\u0007\u0003\u0005\u0017SAA!$\u0003\u0010\u0006!A.\u00198h\u0015\t\u0011\t*\u0001\u0003kCZ\f\u0017\u0002\u0002B,\u0005\u0017\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif,\"A!'\u0011\t\u00055%1T\u0005\u0005\u0005;\u000byIA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u0018\n\r\u0006\"\u0003BS;\u0005\u0005\t\u0019\u0001BM\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!1\u0016\t\u0007\u0005[\u0013\u0019,a&\u000e\u0005\t=&\u0002\u0002BY\u0003\u001f\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011)La,\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005w\u0013\t\r\u0005\u0003\u0002\u000e\nu\u0016\u0002\u0002B`\u0003\u001f\u0013qAQ8pY\u0016\fg\u000eC\u0005\u0003&~\t\t\u00111\u0001\u0002\u0018\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0003\u001a\u0006AAo\\*ue&tw\r\u0006\u0002\u0003\b\u00061Q-];bYN$BAa/\u0003P\"I!Q\u0015\u0012\u0002\u0002\u0003\u0007\u0011qS\u0001\u0018)\u0016\u001cH\u000fR1uC\u001e+g.\u001a:bi&|g.\u0012:s_J\u00042A!\u0019%'\u0015!#q\u001bB!!!\u0011INa8\u0003L\t}SB\u0001Bn\u0015\u0011\u0011i.a$\u0002\u000fI,h\u000e^5nK&!!\u0011\u001dBn\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g.\r\u000b\u0003\u0005'\fQ!\u00199qYf$BAa\u0018\u0003j\"9!qI\u0014A\u0002\t-\u0013aB;oCB\u0004H.\u001f\u000b\u0005\u0005_\u0014)\u0010\u0005\u0004\u0002\u000e\nE(1J\u0005\u0005\u0005g\fyI\u0001\u0004PaRLwN\u001c\u0005\n\u0005oD\u0013\u0011!a\u0001\u0005?\n1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\tu\b\u0003\u0002BE\u0005\u007fLAa!\u0001\u0003\f\n1qJ\u00196fGR\u0014!BT8TG\u0016t\u0017M]5p'%Q#Q\u0004B\u001d\u0005w\u0011\t%\u0001\u0007tG\u0016t\u0017M]5p\u001d\u0006lW-\u0006\u0002\u0004\fA!1QBB\f\u001b\t\u0019yA\u0003\u0003\u0002p\rE!\u0002BA\b\u0007'QAa!\u0006\u0002\u0016\u00051QM\\4j]\u0016LAa!\u0007\u0004\u0010\tY\u0001K]8dKN\u001ch*Y7f\u00035\u00198-\u001a8be&|g*Y7fAQ!1qDB\u0011!\r\u0011\tG\u000b\u0005\b\u0007\u000fi\u0003\u0019AB\u0006)\u0011\u0019yb!\n\t\u0013\r\u001da\u0006%AA\u0002\r-QCAB\u0015U\u0011\u0019YA!\u001d\u0015\t\u0005]5Q\u0006\u0005\n\u0005K\u0013\u0014\u0011!a\u0001\u00053#BAa/\u00042!I!Q\u0015\u001b\u0002\u0002\u0003\u0007\u0011q\u0013\u000b\u0005\u0005w\u001b)\u0004C\u0005\u0003&^\n\t\u00111\u0001\u0002\u0018\u0006Qaj\\*dK:\f'/[8\u0011\u0007\t\u0005\u0014hE\u0003:\u0007{\u0011\t\u0005\u0005\u0005\u0003Z\n}71BB\u0010)\t\u0019I\u0004\u0006\u0003\u0004 \r\r\u0003bBB\u0004y\u0001\u000711\u0002\u000b\u0005\u0007\u000f\u001aI\u0005\u0005\u0004\u0002\u000e\nE81\u0002\u0005\n\u0005ol\u0014\u0011!a\u0001\u0007?\u0011\u0001CT8Qe>\u001cWm]:j]\u001e$\u0016\u0010]3\u0014\u0013}\u0012iB!\u000f\u0003<\t\u0005\u0013A\u00049s_\u000e,7o]5oORK\b/Z\u000b\u0003\u0007'\u0002Ba!\u0016\u0004h9!1qKB2\u001d\u0011\u0019If!\u0019\u000f\t\rm3q\f\b\u0005\u0005\u0003\u0019i&\u0003\u0003\u0004\u0016\u0005U\u0011\u0002BA\b\u0007'IA!a\u001c\u0004\u0012%!1QMB\b\u0003\u001d\u0001\u0018mY6bO\u0016LAa!\u001b\u0004l\tq\u0001K]8dKN\u001c\u0018N\\4UsB,'\u0002BB3\u0007\u001f\tq\u0002\u001d:pG\u0016\u001c8/\u001b8h)f\u0004X\r\t\u000b\u0005\u0007c\u001a\u0019\bE\u0002\u0003b}Bqaa\u0014C\u0001\u0004\u0019\u0019\u0006\u0006\u0003\u0004r\r]\u0004\"CB(\u0007B\u0005\t\u0019AB*+\t\u0019YH\u000b\u0003\u0004T\tED\u0003BAL\u0007\u007fB\u0011B!*H\u0003\u0003\u0005\rA!'\u0015\t\tm61\u0011\u0005\n\u0005KK\u0015\u0011!a\u0001\u0003/#BAa/\u0004\b\"I!Q\u0015'\u0002\u0002\u0003\u0007\u0011qS\u0001\u0011\u001d>\u0004&o\\2fgNLgn\u001a+za\u0016\u00042A!\u0019O'\u0015q5q\u0012B!!!\u0011INa8\u0004T\rEDCABF)\u0011\u0019\th!&\t\u000f\r=\u0013\u000b1\u0001\u0004TQ!1\u0011TBN!\u0019\tiI!=\u0004T!I!q\u001f*\u0002\u0002\u0003\u00071\u0011O\u0001\r\u001d>\u0004VM]7jgNLwN\u001c\t\u0004\u0005C*&\u0001\u0004(p!\u0016\u0014X.[:tS>t7cC+\u0003\u001e\te2Q\u0015B\u001e\u0005\u0003\u0002Baa*\u0004.:!\u0011Q`BU\u0013\u0011\u0019Y+!\u0004\u0002\u001f\t\u000b7/\u001a%uiB\u001cVM\u001d<jG\u0016LAaa,\u00042\nA2)^:u_6\fU\u000f\u001e5pe&T\u0018\r^5p]\u0016\u0013(o\u001c:\u000b\t\r-\u0016Q\u0002\u000b\u0003\u0007?#B!a&\u00048\"I!QU-\u0002\u0002\u0003\u0007!\u0011\u0014\u000b\u0005\u0005w\u001bY\fC\u0005\u0003&n\u000b\t\u00111\u0001\u0002\u0018\u0006)R*\u00197g_JlW\r\u001a+za&twMU3tk2$\bc\u0001B1]N)ana1\u0003BAA!\u0011\u001cBp\u0005\u0017\u001a)\rE\u0002\u0003b}#\"aa0\u0015\t\r\u001571\u001a\u0005\b\u0005\u000f\n\b\u0019\u0001B&)\u0011\u0011yoa4\t\u0013\t](/!AA\u0002\r\u0015\u0017a\u00048p'\u000e,g.\u0019:j_\u000e{G-Z2\u0016\u0005\rU\u0007CCBl\u0007C\u0014Yea\b\u0004f6\u00111\u0011\u001c\u0006\u0005\u00077\u001ci.A\u0003uCBL'O\u0003\u0002\u0004`\u0006!1\u000f\u001e;q\u0013\u0011\u0019\u0019o!7\u0003\u000b\r{G-Z2\u0011\t\r\u001d8Q\u001e\b\u0005\u0007/\u001cI/\u0003\u0003\u0004l\u000ee\u0017aC\"pI\u0016\u001cgi\u001c:nCRLAaa<\u0004r\nIA+\u001a=u!2\f\u0017N\u001c\u0006\u0005\u0007W\u001cI.\u0001\to_N\u001bWM\\1sS>\u001cu\u000eZ3dA\u0005)bn\u001c)s_\u000e,7o]5oORK\b/Z\"pI\u0016\u001cWCAB}!)\u00199n!9\u0003L\rE4Q]\u0001\u0017]>\u0004&o\\2fgNLgn\u001a+za\u0016\u001cu\u000eZ3dA\u0005QR.\u00197g_JlW\r\u001a+za&twMU3tk2$8i\u001c3fIV\u0011A\u0011\u0001\t\u000b\u0007/\u001c\tOa\u0013\u0004F\u000e\u0015\u0018aG7bY\u001a|'/\\3e)f\u0004\u0018N\\4SKN,H\u000e^\"pI\u0016$\u0007%A\u000fuKN$H)\u0019;b\u000f\u0016tWM]1uS>tWI\u001d:peR\u001cu\u000eZ3e+\t!I\u0001\u0005\u0006\u0004X\u000e\u0005(1\nB0\u0007K\fa\u0004^3ti\u0012\u000bG/Y$f]\u0016\u0014\u0018\r^5p]\u0016\u0013(o\u001c:u\u0007>$W\r\u001a\u0011\u0014\u0013}\u0013iB!\u000f\u0003<\t\u0005C\u0003BBc\t#AqAa\u0012c\u0001\u0004\u0011Y\u0005\u0006\u0003\u0004F\u0012U\u0001\"\u0003B$GB\u0005\t\u0019\u0001B&)\u0011\t9\n\"\u0007\t\u0013\t\u0015v-!AA\u0002\teE\u0003\u0002B^\t;A\u0011B!*j\u0003\u0003\u0005\r!a&\u0015\t\tmF\u0011\u0005\u0005\n\u0005Kc\u0017\u0011!a\u0001\u0003/\u000bA\u0002V3ti&tw-\u0012:s_J\f\u0001\"\u0012=b[BdWm\u001d\t\u0004\u0005gi(\u0001C#yC6\u0004H.Z:\u0014\u0007u\u0014i\u0002\u0006\u0002\u0005(\u0005\tbn\\*dK:\f'/[8Fq\u0006l\u0007\u000f\\3\u0016\u0005\u0011M\u0002C\u0002C\u001b\tw!\tE\u0004\u0003\u0004X\u0012]\u0012\u0002\u0002C\u001d\u00073\fa\"\u00128ea>Lg\u000e^(viB,H/\u0003\u0003\u0005>\u0011}\"\u0001D(oK>3g+\u0019:jC:$(\u0002\u0002C\u001d\u00073\u00042\u0001b\u0011+\u001d\r\tYPE\u0001\u0013]>\u001c6-\u001a8be&|W\t_1na2,\u0007%\u0001\u0010uKN$H)\u0019;b\u000f\u0016tWM]1uS>tWI\u001d:pe\u0016C\u0018-\u001c9mKV\u0011A1\n\t\u0007\tk!Y\u0004\"\u0014\u0011\u0007\u0011\rS#A\u0010uKN$H)\u0019;b\u000f\u0016tWM]1uS>tWI\u001d:pe\u0016C\u0018-\u001c9mK\u0002\nA$\\1mM>\u0014X.\u001a3UsBLgn\u001a*fgVdG/\u0012=b[BdW-\u0006\u0002\u0005VA1AQ\u0007C\u001e\t/\u00022\u0001b\u0011`\u0003ui\u0017\r\u001c4pe6,G\rV=qS:<'+Z:vYR,\u00050Y7qY\u0016\u0004\u0013a\u00048p'\u000e,g.\u0019:j_\u0016\u0013(o\u001c:\u0015\t\u0005eHq\f\u0005\b\u0007\u000fQ\u0001\u0019AB\u0006\u0003Eqw\u000eU3s[&\u001c8/[8o\u000bJ\u0014xN]\u000b\u0003\tK\u0012b\u0001b\u001a\u0002z\u000e\u0015fA\u0002C5\u0001\u0001!)G\u0001\u0007=e\u00164\u0017N\\3nK:$h(A\nuKN$\u0018N\\4Ba&,e\u000e\u001a9pS:$8/\u0006\u0002\u0005pA!A\u0011\u000fC<\u001b\t!\u0019H\u0003\u0003\u0005v\u00055\u0011a\u00033fg\u000e\u0014\u0018\u000e\u001d;j_:LA\u0001\"\u001f\u0005t\t\u0019B+Z:uS:<\u0017\t]5F]\u0012\u0004x.\u001b8ug\u0006!B/Z:uS:<\u0017\t]5F]\u0012\u0004x.\u001b8ug\u0002\u0002")
public class TestingApiHttpService
extends BaseHttpService
implements ScenarioHttpServiceExtensions,
LazyLogging {
    private final ProcessingTypeDataProvider<ParametersValidator, ?> processingTypeToParametersValidator;
    private final ProcessingTypeDataProvider<ScenarioTestService, ?> processingTypeToScenarioTestServices;
    private final ProcessService scenarioService;
    private final ExecutionContext executionContext;
    private final TestingApiEndpoints testingApiEndpoints;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public EitherT<Future, Object, ScenarioWithDetails> getScenarioWithDetailsByName(ProcessName scenarioName, LoggedUser loggedUser) {
        return ScenarioHttpServiceExtensions.getScenarioWithDetailsByName$(this, scenarioName, loggedUser);
    }

    @Override
    public <T> EitherT<Future, Object, T> eitherifyErrors(Future<T> future) {
        return ScenarioHttpServiceExtensions.eitherifyErrors$(this, future);
    }

    @Override
    public PartialFunction<Throwable, Object> handleOtherErrors() {
        return ScenarioHttpServiceExtensions.handleOtherErrors$(this);
    }

    private Logger logger$lzycompute() {
        TestingApiHttpService testingApiHttpService = this;
        synchronized (testingApiHttpService) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public ProcessService scenarioService() {
        return this.scenarioService;
    }

    @Override
    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    @Override
    public TestingError noScenarioError(ProcessName scenarioName) {
        return new TestingError.NoScenario(scenarioName);
    }

    @Override
    public TestingError noPermissionError() {
        return TestingApiHttpService$TestingError$NoPermission$.MODULE$;
    }

    private TestingApiEndpoints testingApiEndpoints() {
        return this.testingApiEndpoints;
    }

    public TestingApiHttpService(AuthManager authManager, ProcessingTypeDataProvider<ParametersValidator, ?> processingTypeToParametersValidator, ProcessingTypeDataProvider<ScenarioTestService, ?> processingTypeToScenarioTestServices, ProcessService scenarioService, ExecutionContext executionContext) {
        this.processingTypeToParametersValidator = processingTypeToParametersValidator;
        this.processingTypeToScenarioTestServices = processingTypeToScenarioTestServices;
        this.scenarioService = scenarioService;
        this.executionContext = executionContext;
        super(authManager, executionContext);
        ScenarioHttpServiceExtensions.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        this.testingApiEndpoints = new TestingApiEndpoints((EndpointInput<AuthCredentials>)authManager.authenticationEndpointInput());
        this.expose(this.ServerLogicExtension(this.testingApiEndpoints().scenarioTestingAdhocValidateEndpoint().serverSecurityLogic((Function1 & Serializable & scala.Serializable)credentials -> this.authorizeKnownUser((AuthCredentials)credentials))).serverLogicEitherT((Function1 & Serializable & scala.Serializable)loggedUser -> (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ProcessName scenarioName = (ProcessName)tuple2._1();
            NodesApiEndpoints.Dtos.AdhocTestParametersRequest request = (NodesApiEndpoints.Dtos.AdhocTestParametersRequest)tuple2._2();
            EitherT eitherT = this.getScenarioWithDetailsByName(scenarioName, (LoggedUser)loggedUser).map((Function1 & Serializable & scala.Serializable)scenarioWithDetails -> {
                ParametersValidator validator = $this.processingTypeToParametersValidator.forProcessingTypeUnsafe(scenarioWithDetails.processingType(), (LoggedUser)loggedUser);
                ScenarioTestService scenarioTestService = $this.processingTypeToScenarioTestServices.forProcessingTypeUnsafe(scenarioWithDetails.processingType(), (LoggedUser)loggedUser);
                Map<String, List<Parameter>> inputParameters = scenarioTestService.testParametersDefinition(request.scenarioGraph(), scenarioWithDetails.processVersionUnsafe(), scenarioWithDetails.isFragment(), (LoggedUser)loggedUser);
                MetaData metaData = request.scenarioGraph().properties().toMetaData(scenarioName);
                List<ValidationResults.NodeValidationError> validationResults = validator.validate(request.sourceParameters(), inputParameters, metaData);
                return new Tuple6(scenarioWithDetails, (Object)validator, (Object)scenarioTestService, inputParameters, (Object)metaData, validationResults);
            }, (Functor)Invariant$.MODULE$.catsInstancesForFuture(this.executionContext())).map((Function1 & Serializable & scala.Serializable)x$1 -> {
                Tuple6 tuple6 = x$1;
                if (tuple6 == null) {
                    throw new MatchError((Object)tuple6);
                }
                List validationResults = (List)tuple6._6();
                NodesApiEndpoints.Dtos.ParametersValidationResultDto parametersValidationResultDto = new NodesApiEndpoints.Dtos.ParametersValidationResultDto((List<ValidationResults.NodeValidationError>)validationResults, true);
                return parametersValidationResultDto;
            }, (Functor)Invariant$.MODULE$.catsInstancesForFuture(this.executionContext()));
            return eitherT;
        }));
        this.expose(this.ServerLogicExtension(this.testingApiEndpoints().scenarioTestingCapabilitiesEndpoint().serverSecurityLogic((Function1 & Serializable & scala.Serializable)credentials -> this.authorizeKnownUser((AuthCredentials)credentials))).serverLogicEitherT((Function1 & Serializable & scala.Serializable)loggedUser -> (Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ProcessName scenarioName = (ProcessName)tuple2._1();
            ScenarioGraph scenarioGraph = (ScenarioGraph)tuple2._2();
            EitherT eitherT = this.getScenarioWithDetailsByName(scenarioName, (LoggedUser)loggedUser).map((Function1 & Serializable & scala.Serializable)scenarioWithDetails -> {
                ScenarioTestService scenarioTestService = $this.processingTypeToScenarioTestServices.forProcessingTypeUnsafe(scenarioWithDetails.processingType(), (LoggedUser)loggedUser);
                TestingCapabilities capabilities = scenarioTestService.getTestingCapabilities(scenarioGraph, scenarioWithDetails.processVersionUnsafe(), scenarioWithDetails.isFragment(), (LoggedUser)loggedUser);
                return new Tuple3(scenarioWithDetails, (Object)scenarioTestService, (Object)capabilities);
            }, (Functor)Invariant$.MODULE$.catsInstancesForFuture(this.executionContext())).map((Function1 & Serializable & scala.Serializable)x$2 -> {
                TestingCapabilities capabilities;
                Tuple3 tuple3 = x$2;
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                TestingCapabilities testingCapabilities = capabilities = (TestingCapabilities)tuple3._3();
                return testingCapabilities;
            }, (Functor)Invariant$.MODULE$.catsInstancesForFuture(this.executionContext()));
            return eitherT;
        }));
        this.expose(this.ServerLogicExtension(this.testingApiEndpoints().scenarioTestingParametersEndpoint().serverSecurityLogic((Function1 & Serializable & scala.Serializable)credentials -> this.authorizeKnownUser((AuthCredentials)credentials))).serverLogicEitherT((Function1 & Serializable & scala.Serializable)loggedUser -> (Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ProcessName scenarioName = (ProcessName)tuple2._1();
            ScenarioGraph scenarioGraph = (ScenarioGraph)tuple2._2();
            EitherT eitherT = this.getScenarioWithDetailsByName(scenarioName, (LoggedUser)loggedUser).map((Function1 & Serializable & scala.Serializable)scenarioWithDetails -> {
                ScenarioTestService scenarioTestService = $this.processingTypeToScenarioTestServices.forProcessingTypeUnsafe(scenarioWithDetails.processingType(), (LoggedUser)loggedUser);
                List<package.UISourceParameters> parametersDefinition = scenarioTestService.testUISourceParametersDefinition(scenarioGraph, scenarioWithDetails.processVersionUnsafe(), scenarioWithDetails.isFragment(), (LoggedUser)loggedUser);
                return new Tuple3(scenarioWithDetails, (Object)scenarioTestService, parametersDefinition);
            }, (Functor)Invariant$.MODULE$.catsInstancesForFuture(this.executionContext())).map((Function1 & Serializable & scala.Serializable)x$3 -> {
                List parametersDefinition;
                Tuple3 tuple3 = x$3;
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                List list = parametersDefinition = (List)tuple3._3();
                return list;
            }, (Functor)Invariant$.MODULE$.catsInstancesForFuture(this.executionContext()));
            return eitherT;
        }));
        this.expose(this.ServerLogicExtension(this.testingApiEndpoints().scenarioTestingGenerateEndpoint().serverSecurityLogic((Function1 & Serializable & scala.Serializable)credentials -> this.authorizeKnownUser((AuthCredentials)credentials))).serverLogicEitherT((Function1 & Serializable & scala.Serializable)loggedUser -> (Function1 & Serializable & scala.Serializable)x0$4 -> {
            Tuple3 tuple3 = x0$4;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            ProcessName scenarioName = (ProcessName)tuple3._1();
            int testSampleSize = BoxesRunTime.unboxToInt((Object)tuple3._2());
            ScenarioGraph scenarioGraph = (ScenarioGraph)tuple3._3();
            EitherT eitherT = this.getScenarioWithDetailsByName(scenarioName, (LoggedUser)loggedUser).map((Function1 & Serializable & scala.Serializable)scenarioWithDetails -> {
                ScenarioTestService scenarioTestService = $this.processingTypeToScenarioTestServices.forProcessingTypeUnsafe(scenarioWithDetails.processingType(), (LoggedUser)loggedUser);
                return new Tuple2(scenarioWithDetails, (Object)scenarioTestService);
            }, (Functor)Invariant$.MODULE$.catsInstancesForFuture(this.executionContext())).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> {
                Future future;
                Tuple2 tuple2 = x$4;
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                ScenarioWithDetails scenarioWithDetails = (ScenarioWithDetails)tuple2._1();
                ScenarioTestService scenarioTestService = (ScenarioTestService)tuple2._2();
                Either<String, RawScenarioTestData> either = scenarioTestService.generateData(scenarioGraph, scenarioWithDetails.processVersionUnsafe(), scenarioWithDetails.isFragment(), testSampleSize, (LoggedUser)loggedUser);
                if (either instanceof Left) {
                    BoxedUnit boxedUnit;
                    Left left = (Left)either;
                    String error = (String)left.value();
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error("Error during generation of test data: {}", new Object[]{error});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    future = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Left().apply((Object)new TestingError.TestDataGenerationError(error)), this.executionContext());
                    return new EitherT((Object)future).map((Function1 & Serializable & scala.Serializable)parametersDefinition -> parametersDefinition, (Functor)Invariant$.MODULE$.catsInstancesForFuture(this.executionContext()));
                } else {
                    if (!(either instanceof Right)) throw new MatchError(either);
                    Right right = (Right)either;
                    RawScenarioTestData rawScenarioTestData = (RawScenarioTestData)right.value();
                    future = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Right().apply((Object)rawScenarioTestData.content()), this.executionContext());
                }
                return new EitherT((Object)future).map((Function1 & Serializable & scala.Serializable)parametersDefinition -> parametersDefinition, (Functor)Invariant$.MODULE$.catsInstancesForFuture(this.executionContext()));
            }, (Monad)Invariant$.MODULE$.catsInstancesForFuture(this.executionContext()));
            return eitherT;
        }));
    }

    public static interface TestingError {
    }
}

