/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.notifications;

import java.io.Serializable;
import java.time.Clock;
import java.time.Instant;
import pl.touk.nussknacker.engine.api.deployment.ProcessAction;
import pl.touk.nussknacker.engine.api.deployment.ProcessActionState$;
import pl.touk.nussknacker.engine.api.deployment.ScenarioActionName;
import pl.touk.nussknacker.engine.api.deployment.ScenarioActionName$;
import pl.touk.nussknacker.engine.api.process.ProcessName;
import pl.touk.nussknacker.ui.notifications.Notification;
import pl.touk.nussknacker.ui.notifications.Notification$;
import pl.touk.nussknacker.ui.notifications.NotificationConfig;
import pl.touk.nussknacker.ui.notifications.NotificationService;
import pl.touk.nussknacker.ui.notifications.NotificationServiceImpl$;
import pl.touk.nussknacker.ui.process.repository.DBIOActionRunner;
import pl.touk.nussknacker.ui.process.repository.ScenarioActionRepository;
import pl.touk.nussknacker.ui.security.api.LoggedUser;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001a4Aa\u0003\u0007\u0001/!A!\u0005\u0001B\u0001B\u0003%1\u0005\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003-\u0011!y\u0003A!A!\u0002\u0013\u0001\u0004\u0002C\u001a\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b\t\u000bq\u0002A\u0011A\u001f\t\u000b5\u0001A\u0011I\"\b\u000f!d\u0011\u0011!E\u0001S\u001a91\u0002DA\u0001\u0012\u0003Q\u0007\"\u0002\u001f\t\t\u0003Y\u0007b\u00027\t#\u0003%\t!\u001c\u0002\u0018\u001d>$\u0018NZ5dCRLwN\\*feZL7-Z%na2T!!\u0004\b\u0002\u001b9|G/\u001b4jG\u0006$\u0018n\u001c8t\u0015\ty\u0001#\u0001\u0002vS*\u0011\u0011CE\u0001\f]V\u001c8o\u001b8bG.,'O\u0003\u0002\u0014)\u0005!Ao\\;l\u0015\u0005)\u0012A\u00019m\u0007\u0001\u00192\u0001\u0001\r\u001f!\tIB$D\u0001\u001b\u0015\u0005Y\u0012!B:dC2\f\u0017BA\u000f\u001b\u0005\u0019\te.\u001f*fMB\u0011q\u0004I\u0007\u0002\u0019%\u0011\u0011\u0005\u0004\u0002\u0014\u001d>$\u0018NZ5dCRLwN\\*feZL7-Z\u0001\u0019g\u000e,g.\u0019:j_\u0006\u001bG/[8o%\u0016\u0004xn]5u_JL\bC\u0001\u0013*\u001b\u0005)#B\u0001\u0014(\u0003)\u0011X\r]8tSR|'/\u001f\u0006\u0003Q9\tq\u0001\u001d:pG\u0016\u001c8/\u0003\u0002+K\tA2kY3oCJLw.Q2uS>t'+\u001a9pg&$xN]=\u0002\u0015\u0011\u0014\u0017n\u001c*v]:,'\u000f\u0005\u0002%[%\u0011a&\n\u0002\u0011\t\nKu*Q2uS>t'+\u001e8oKJ\faaY8oM&<\u0007CA\u00102\u0013\t\u0011DB\u0001\nO_RLg-[2bi&|gnQ8oM&<\u0017!B2m_\u000e\\\u0007CA\u001b;\u001b\u00051$BA\u001c9\u0003\u0011!\u0018.\\3\u000b\u0003e\nAA[1wC&\u00111H\u000e\u0002\u0006\u00072|7m[\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000byz\u0004)\u0011\"\u0011\u0005}\u0001\u0001\"\u0002\u0012\u0006\u0001\u0004\u0019\u0003\"B\u0016\u0006\u0001\u0004a\u0003\"B\u0018\u0006\u0001\u0004\u0001\u0004bB\u001a\u0006!\u0003\u0005\r\u0001\u000e\u000b\u0004\tf\u001b\u0007cA#I\u00156\taI\u0003\u0002H5\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005%3%A\u0002$viV\u0014X\rE\u0002L'Zs!\u0001T)\u000f\u00055\u0003V\"\u0001(\u000b\u0005=3\u0012A\u0002\u001fs_>$h(C\u0001\u001c\u0013\t\u0011&$A\u0004qC\u000e\\\u0017mZ3\n\u0005Q+&\u0001\u0002'jgRT!A\u0015\u000e\u0011\u0005}9\u0016B\u0001-\r\u00051qu\u000e^5gS\u000e\fG/[8o\u0011\u0015Qf\u0001q\u0001\\\u0003\u0011)8/\u001a:\u0011\u0005q\u000bW\"A/\u000b\u0005y{\u0016aA1qS*\u0011\u0001MD\u0001\tg\u0016\u001cWO]5us&\u0011!-\u0018\u0002\u000b\u0019><w-\u001a3Vg\u0016\u0014\b\"\u00023\u0007\u0001\b)\u0017AA3d!\t)e-\u0003\u0002h\r\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u0018\u001d>$\u0018NZ5dCRLwN\\*feZL7-Z%na2\u0004\"a\b\u0005\u0014\u0005!AB#A5\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135+\u0005q'F\u0001\u001bpW\u0005\u0001\bCA9w\u001b\u0005\u0011(BA:u\u0003%)hn\u00195fG.,GM\u0003\u0002v5\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005]\u0014(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class NotificationServiceImpl
implements NotificationService {
    private final ScenarioActionRepository scenarioActionRepository;
    private final DBIOActionRunner dbioRunner;
    private final NotificationConfig config;
    private final Clock clock;

    public static Clock $lessinit$greater$default$4() {
        return NotificationServiceImpl$.MODULE$.$lessinit$greater$default$4();
    }

    @Override
    public Future<List<Notification>> notifications(LoggedUser user, ExecutionContext ec) {
        Instant now = this.clock.instant();
        Instant limit = now.minusMillis(this.config.duration().toMillis());
        return this.dbioRunner.run(this.scenarioActionRepository.getUserActionsAfter(user, (Set<ScenarioActionName>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new ScenarioActionName[]{new ScenarioActionName(ScenarioActionName$.MODULE$.Deploy()), new ScenarioActionName(ScenarioActionName$.MODULE$.Cancel())}))), (Set<Enumeration.Value>)((Set)ProcessActionState$.MODULE$.FinishedStates().$plus((Object)ProcessActionState$.MODULE$.Failed())), limit)).map((Function1 & Serializable & scala.Serializable)x$1 -> (List)x$1.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Notification notification;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            ProcessAction action = (ProcessAction)tuple2._1();
            ProcessName scenarioName = (ProcessName)tuple2._2();
            Enumeration.Value value = action.state();
            Enumeration.Value value2 = ProcessActionState$.MODULE$.Finished();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                notification = Notification$.MODULE$.actionFinishedNotification(action.id().toString(), action.actionName(), scenarioName);
                return notification;
            } else {
                Enumeration.Value value4 = ProcessActionState$.MODULE$.Failed();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    notification = Notification$.MODULE$.actionFailedNotification(action.id().toString(), action.actionName(), scenarioName, (Option<String>)action.failureMessage());
                    return notification;
                } else {
                    Enumeration.Value value6 = ProcessActionState$.MODULE$.ExecutionFinished();
                    Enumeration.Value value7 = value;
                    if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                        notification = Notification$.MODULE$.actionExecutionFinishedNotification(action.id().toString(), action.actionName(), scenarioName);
                        return notification;
                    } else {
                        Enumeration.Value value8 = ProcessActionState$.MODULE$.InProgress();
                        Enumeration.Value value9 = value;
                        if (value8 != null) {
                            if (!value8.equals(value9)) throw new MatchError((Object)value);
                            throw new IllegalStateException(new StringBuilder(53).append("Unexpected action returned by query: ").append(action).append(", for scenario: ").append(scenarioName).toString());
                        }
                        if (value9 == null) throw new IllegalStateException(new StringBuilder(53).append("Unexpected action returned by query: ").append(action).append(", for scenario: ").append(scenarioName).toString());
                        throw new MatchError((Object)value);
                    }
                }
            }
        }, List$.MODULE$.canBuildFrom()), ec);
    }

    public NotificationServiceImpl(ScenarioActionRepository scenarioActionRepository, DBIOActionRunner dbioRunner, NotificationConfig config, Clock clock) {
        this.scenarioActionRepository = scenarioActionRepository;
        this.dbioRunner = dbioRunner;
        this.config = config;
        this.clock = clock;
    }
}

