/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.process;

import cats.effect.IO;
import cats.effect.IO$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import java.io.Serializable;
import java.util.UUID;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import pl.touk.nussknacker.engine.api.component.ProcessingMode;
import pl.touk.nussknacker.engine.api.deployment.DeploymentResult;
import pl.touk.nussknacker.engine.api.deployment.ProcessActionId;
import pl.touk.nussknacker.engine.api.deployment.ScenarioActivity;
import pl.touk.nussknacker.engine.api.deployment.ScenarioAttachment;
import pl.touk.nussknacker.engine.api.deployment.ScenarioComment;
import pl.touk.nussknacker.engine.api.deployment.ScenarioVersionId;
import pl.touk.nussknacker.engine.api.deployment.ScenarioVersionId$;
import pl.touk.nussknacker.engine.api.deployment.ScheduledExecutionStatus;
import pl.touk.nussknacker.engine.api.deployment.UserName;
import pl.touk.nussknacker.engine.api.process.ProcessId;
import pl.touk.nussknacker.engine.api.process.VersionId;
import pl.touk.nussknacker.ui.process.ScenarioAttachmentService;
import pl.touk.nussknacker.ui.security.api.LoggedUser;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class ScenarioActivityAuditLog$ {
    public static ScenarioActivityAuditLog$ MODULE$;
    private final Logger logger;

    static {
        new ScenarioActivityAuditLog$();
    }

    private Logger logger() {
        return this.logger;
    }

    public IO<BoxedUnit> onCreateScenarioActivity(ScenarioActivity scenarioActivity) {
        return this.logWithContext(scenarioActivity.scenarioId(), (Option<ScenarioVersionId>)scenarioActivity.scenarioVersionId(), scenarioActivity.user().name().value(), new StringBuilder(14).append("New activity: ").append(this.stringify(scenarioActivity)).toString());
    }

    public IO<BoxedUnit> onEditComment(ProcessId processId, LoggedUser user, UUID scenarioActivityId, String comment) {
        return this.logWithContext(processId.value(), (Option<ScenarioVersionId>)None$.MODULE$, user.username(), new StringBuilder(42).append("[commentId=").append(scenarioActivityId.toString()).append("] Comment edited, new value: [").append(comment).append("]").toString());
    }

    public IO<BoxedUnit> onDeleteComment(ProcessId processId, long rowId, LoggedUser user) {
        return this.logWithContext(processId.value(), (Option<ScenarioVersionId>)None$.MODULE$, user.username(), new StringBuilder(27).append("Comment with rowId=").append(rowId).append(" deleted").toString());
    }

    public IO<BoxedUnit> onDeleteComment(ProcessId processId, UUID activityId, LoggedUser user) {
        return this.logWithContext(processId.value(), (Option<ScenarioVersionId>)None$.MODULE$, user.username(), new StringBuilder(31).append("Comment for activityId=").append(activityId).append(" deleted").toString());
    }

    public IO<BoxedUnit> onAddAttachment(ScenarioAttachmentService.AttachmentToAdd attachmentToAdd, LoggedUser user) {
        return this.logWithContext(attachmentToAdd.scenarioId().value(), (Option<ScenarioVersionId>)new Some((Object)new ScenarioVersionId(ScenarioVersionId$.MODULE$.from(attachmentToAdd.scenarioVersionId()))), user.username(), new StringBuilder(20).append("Attachment added: [").append(attachmentToAdd.fileName()).append("]").toString());
    }

    public IO<BoxedUnit> onDeleteAttachment(ProcessId scenarioId, long attachmentId, LoggedUser user) {
        return this.logWithContext(scenarioId.value(), (Option<ScenarioVersionId>)None$.MODULE$, user.username(), new StringBuilder(35).append("Attachment deleted: [attachmentId=").append(attachmentId).append("]").toString());
    }

    public IO<BoxedUnit> onScenarioImmediateAction(ProcessActionId processActionId, ProcessId processId, String actionName, Option<VersionId> processVersion, LoggedUser user) {
        return this.logWithContext(processId.value(), (Option<ScenarioVersionId>)processVersion.map((Function1 & Serializable & scala.Serializable)versionId -> new ScenarioVersionId(ScenarioVersionId$.MODULE$.from(versionId))), user.username(), new StringBuilder(49).append("Immediate scenario action [actionName=").append(actionName).append(",actionId=").append(processActionId.value()).append("]").toString());
    }

    public IO<BoxedUnit> onScenarioActionStarted(ProcessActionId processActionId, ProcessId processId, String actionName, Option<VersionId> processVersion, LoggedUser user) {
        return this.logWithContext(processId.value(), (Option<ScenarioVersionId>)processVersion.map((Function1 & Serializable & scala.Serializable)versionId -> new ScenarioVersionId(ScenarioVersionId$.MODULE$.from(versionId))), user.username(), new StringBuilder(47).append("Scenario action [actionName=").append(actionName).append(",actionId=").append(processActionId.value()).append("] started").toString());
    }

    public IO<BoxedUnit> onScenarioActionFinishedWithSuccess(ProcessActionId processActionId, ProcessId processId, String actionName, Option<VersionId> processVersion, Option<String> comment, LoggedUser user) {
        String string;
        Option<String> option = comment;
        if (option instanceof Some) {
            Some some = (Some)option;
            String content = (String)some.value();
            string = new StringBuilder(10).append("comment [").append(content).append("]").toString();
        } else if (None$.MODULE$.equals(option)) {
            string = "without comment";
        } else {
            throw new MatchError(option);
        }
        String commentValue = string;
        return this.logWithContext(processId.value(), (Option<ScenarioVersionId>)processVersion.map((Function1 & Serializable & scala.Serializable)versionId -> new ScenarioVersionId(ScenarioVersionId$.MODULE$.from(versionId))), user.username(), new StringBuilder(67).append("Scenario action [actionName=").append(actionName).append(",actionId=").append(processActionId.value()).append("] finished with success and ").append(commentValue).append(" ").toString());
    }

    public IO<BoxedUnit> onScenarioActionFinishedWithFailure(ProcessActionId processActionId, ProcessId processId, String actionName, Option<VersionId> processVersion, Option<String> comment, String failureMessage, LoggedUser user) {
        String string;
        Option<String> option = comment;
        if (option instanceof Some) {
            Some some = (Some)option;
            String content = (String)some.value();
            string = new StringBuilder(15).append("with comment [").append(content).append("]").toString();
        } else if (None$.MODULE$.equals(option)) {
            string = "without comment";
        } else {
            throw new MatchError(option);
        }
        String commentValue = string;
        return this.logWithContext(processId.value(), (Option<ScenarioVersionId>)processVersion.map((Function1 & Serializable & scala.Serializable)versionId -> new ScenarioVersionId(ScenarioVersionId$.MODULE$.from(versionId))), user.username(), new StringBuilder(65).append("Scenario action [actionName=").append(actionName).append(",actionId=").append(processActionId.value()).append("] finished with failure [").append(failureMessage).append("] ").append(commentValue).toString());
    }

    public IO<BoxedUnit> onScenarioActionRemoved(ProcessActionId processActionId, ProcessId processId, Option<VersionId> processVersion, LoggedUser user) {
        return this.logWithContext(processId.value(), (Option<ScenarioVersionId>)processVersion.map((Function1 & Serializable & scala.Serializable)versionId -> new ScenarioVersionId(ScenarioVersionId$.MODULE$.from(versionId))), user.username(), new StringBuilder(35).append("Scenario action [actionId=").append(processActionId.value()).append("] removed").toString());
    }

    private String stringify(ScenarioActivity scenarioActivity) {
        String string;
        ScenarioActivity scenarioActivity2 = scenarioActivity;
        if (scenarioActivity2 instanceof ScenarioActivity.ScenarioDeployed) {
            ScenarioActivity.ScenarioDeployed scenarioDeployed = (ScenarioActivity.ScenarioDeployed)scenarioActivity2;
            ScenarioComment comment = scenarioDeployed.comment();
            DeploymentResult result = scenarioDeployed.result();
            string = new StringBuilder(34).append("ScenarioDeployed(comment=").append(this.stringify(comment)).append(",result=").append(this.stringify(result)).append(")").toString();
        } else if (scenarioActivity2 instanceof ScenarioActivity.ScenarioPaused) {
            ScenarioActivity.ScenarioPaused scenarioPaused = (ScenarioActivity.ScenarioPaused)scenarioActivity2;
            ScenarioComment comment = scenarioPaused.comment();
            DeploymentResult result = scenarioPaused.result();
            string = new StringBuilder(32).append("ScenarioPaused(comment=").append(this.stringify(comment)).append(",result=").append(this.stringify(result)).append(")").toString();
        } else if (scenarioActivity2 instanceof ScenarioActivity.ScenarioCanceled) {
            ScenarioActivity.ScenarioCanceled scenarioCanceled = (ScenarioActivity.ScenarioCanceled)scenarioActivity2;
            ScenarioComment comment = scenarioCanceled.comment();
            DeploymentResult result = scenarioCanceled.result();
            string = new StringBuilder(34).append("ScenarioCanceled(comment=").append(this.stringify(comment)).append(",result=").append(this.stringify(result)).append(")").toString();
        } else if (scenarioActivity2 instanceof ScenarioActivity.CustomAction) {
            ScenarioActivity.CustomAction customAction = (ScenarioActivity.CustomAction)scenarioActivity2;
            String actionName = customAction.actionName();
            ScenarioComment comment = customAction.comment();
            DeploymentResult result = customAction.result();
            string = new StringBuilder(38).append("CustomAction(action=").append(actionName).append(",comment=").append(this.stringify(comment)).append(",result=").append(this.stringify(result)).append(")").toString();
        } else if (scenarioActivity2 instanceof ScenarioActivity.PerformedSingleExecution) {
            ScenarioActivity.PerformedSingleExecution performedSingleExecution = (ScenarioActivity.PerformedSingleExecution)scenarioActivity2;
            ScenarioComment comment = performedSingleExecution.comment();
            DeploymentResult result = performedSingleExecution.result();
            string = new StringBuilder(42).append("PerformedSingleExecution(comment=").append(this.stringify(comment)).append(",result=").append(this.stringify(result)).append(")").toString();
        } else if (scenarioActivity2 instanceof ScenarioActivity.PerformedScheduledExecution) {
            ScenarioActivity.PerformedScheduledExecution performedScheduledExecution = (ScenarioActivity.PerformedScheduledExecution)scenarioActivity2;
            ScheduledExecutionStatus status = performedScheduledExecution.scheduledExecutionStatus();
            String scheduleName = performedScheduledExecution.scheduleName();
            string = new StringBuilder(68).append("PerformedScheduledExecution(scheduleName=").append(scheduleName).append(",scheduledExecutionStatus=").append(status.entryName()).append(")").toString();
        } else if (scenarioActivity2 instanceof ScenarioActivity.ScenarioCreated) {
            string = "ScenarioCreated";
        } else if (scenarioActivity2 instanceof ScenarioActivity.ScenarioArchived) {
            string = "ScenarioArchived";
        } else if (scenarioActivity2 instanceof ScenarioActivity.ScenarioUnarchived) {
            string = "ScenarioUnarchived";
        } else if (scenarioActivity2 instanceof ScenarioActivity.ScenarioModified) {
            ScenarioActivity.ScenarioModified scenarioModified = (ScenarioActivity.ScenarioModified)scenarioActivity2;
            ScenarioComment comment = scenarioModified.comment();
            string = new StringBuilder(26).append("ScenarioModified(comment=").append(this.stringify(comment)).append(")").toString();
        } else if (scenarioActivity2 instanceof ScenarioActivity.ScenarioNameChanged) {
            ScenarioActivity.ScenarioNameChanged scenarioNameChanged = (ScenarioActivity.ScenarioNameChanged)scenarioActivity2;
            String oldName = scenarioNameChanged.oldName();
            String newName = scenarioNameChanged.newName();
            string = new StringBuilder(38).append("ScenarioNameChanged(oldName=").append(oldName).append(",newName=").append(newName).append(")").toString();
        } else if (scenarioActivity2 instanceof ScenarioActivity.CommentAdded) {
            ScenarioActivity.CommentAdded commentAdded = (ScenarioActivity.CommentAdded)scenarioActivity2;
            ScenarioComment comment = commentAdded.comment();
            string = new StringBuilder(22).append("CommentAdded(comment=").append(this.stringify(comment)).append(")").toString();
        } else if (scenarioActivity2 instanceof ScenarioActivity.AttachmentAdded) {
            ScenarioActivity.AttachmentAdded attachmentAdded = (ScenarioActivity.AttachmentAdded)scenarioActivity2;
            ScenarioAttachment attachment = attachmentAdded.attachment();
            string = new StringBuilder(26).append("AttachmentAdded(fileName=").append(this.stringify(attachment)).append(")").toString();
        } else if (scenarioActivity2 instanceof ScenarioActivity.ChangedProcessingMode) {
            ScenarioActivity.ChangedProcessingMode changedProcessingMode = (ScenarioActivity.ChangedProcessingMode)scenarioActivity2;
            ProcessingMode from = changedProcessingMode.from();
            ProcessingMode to = changedProcessingMode.to();
            string = new StringBuilder(32).append("ChangedProcessingMode(from=").append(from).append(",to=").append(to).append(")").toString();
        } else if (scenarioActivity2 instanceof ScenarioActivity.IncomingMigration) {
            ScenarioActivity.IncomingMigration incomingMigration = (ScenarioActivity.IncomingMigration)scenarioActivity2;
            String sourceEnvironment = incomingMigration.sourceEnvironment();
            UserName sourceUser = incomingMigration.sourceUser();
            Option sourceVersionId = incomingMigration.sourceScenarioVersionId();
            string = new StringBuilder(66).append("IncomingMigration(sourceEnvironment=").append(sourceEnvironment).append(",sourceUser=").append(sourceUser.value()).append(",sourceVersionId=").append(sourceVersionId.map((Function1 & Serializable & scala.Serializable)x$1 -> ScenarioActivityAuditLog$.$anonfun$stringify$1(((ScenarioVersionId)x$1).value())).getOrElse((Function0 & Serializable & scala.Serializable)() -> "[none]")).append(")").toString();
        } else if (scenarioActivity2 instanceof ScenarioActivity.OutgoingMigration) {
            ScenarioActivity.OutgoingMigration outgoingMigration = (ScenarioActivity.OutgoingMigration)scenarioActivity2;
            String destinationEnvironment = outgoingMigration.destinationEnvironment();
            string = new StringBuilder(42).append("OutgoingMigration(destinationEnvironment=").append(destinationEnvironment).append(")").toString();
        } else if (scenarioActivity2 instanceof ScenarioActivity.AutomaticUpdate) {
            ScenarioActivity.AutomaticUpdate automaticUpdate = (ScenarioActivity.AutomaticUpdate)scenarioActivity2;
            String changes = automaticUpdate.changes();
            string = new StringBuilder(25).append("AutomaticUpdate(changes=").append(changes).append(")").toString();
        } else {
            throw new MatchError((Object)scenarioActivity2);
        }
        return string;
    }

    private String stringify(ScenarioAttachment attachment) {
        String string;
        ScenarioAttachment scenarioAttachment = attachment;
        if (scenarioAttachment instanceof ScenarioAttachment.Available) {
            ScenarioAttachment.Available available = (ScenarioAttachment.Available)scenarioAttachment;
            String attachmentFilename = available.attachmentFilename();
            string = new StringBuilder(11).append("Available(").append(attachmentFilename).append(")").toString();
        } else if (scenarioAttachment instanceof ScenarioAttachment.Deleted) {
            ScenarioAttachment.Deleted deleted = (ScenarioAttachment.Deleted)scenarioAttachment;
            String attachmentFilename = deleted.attachmentFilename();
            string = new StringBuilder(9).append("Deleted(").append(attachmentFilename).append(")").toString();
        } else {
            throw new MatchError((Object)scenarioAttachment);
        }
        return string;
    }

    private String stringify(ScenarioComment comment) {
        String string;
        ScenarioComment scenarioComment = comment;
        if (scenarioComment instanceof ScenarioComment.WithContent) {
            String comment2;
            ScenarioComment.WithContent withContent = (ScenarioComment.WithContent)scenarioComment;
            string = comment2 = withContent.comment();
        } else if (scenarioComment instanceof ScenarioComment.WithoutContent) {
            string = "none";
        } else {
            throw new MatchError((Object)scenarioComment);
        }
        return string;
    }

    private String stringify(DeploymentResult result) {
        String string;
        DeploymentResult deploymentResult = result;
        if (deploymentResult instanceof DeploymentResult.Success) {
            string = "Success";
        } else if (deploymentResult instanceof DeploymentResult.Failure) {
            DeploymentResult.Failure failure = (DeploymentResult.Failure)deploymentResult;
            Option errorMessage = failure.errorMessage();
            string = new StringBuilder(9).append("Failure(").append(errorMessage).append(")").toString();
        } else {
            throw new MatchError((Object)deploymentResult);
        }
        return string;
    }

    private IO<BoxedUnit> logWithContext(long scenarioId, Option<ScenarioVersionId> scenarioVersionId, String username, String log) {
        return IO$.MODULE$.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            MDC.clear();
            MDC.put((String)"scenarioId", (String)((Object)BoxesRunTime.boxToLong((long)scenarioId)).toString());
            MDC.put((String)"scenarioVersionId", (String)((String)scenarioVersionId.map((Function1 & Serializable & scala.Serializable)x$2 -> ScenarioActivityAuditLog$.$anonfun$logWithContext$2(((ScenarioVersionId)x$2).value())).getOrElse((Function0 & Serializable & scala.Serializable)() -> "none")));
            MDC.put((String)"username", (String)username);
            if (MODULE$.logger().underlying().isInfoEnabled()) {
                MODULE$.logger().underlying().info(log);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            MDC.clear();
        });
    }

    public static final /* synthetic */ String $anonfun$stringify$1(long x$1) {
        return ((Object)BoxesRunTime.boxToLong((long)x$1)).toString();
    }

    public static final /* synthetic */ String $anonfun$logWithContext$2(long x$2) {
        return ((Object)BoxesRunTime.boxToLong((long)x$2)).toString();
    }

    private ScenarioActivityAuditLog$() {
        MODULE$ = this;
        this.logger = Logger$.MODULE$.apply(LoggerFactory.getLogger((String)"scenario-activity-audit"));
    }
}

