/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.statistics;

import cats.Applicative;
import cats.implicits$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import pl.touk.nussknacker.ui.statistics.Encryption$;
import pl.touk.nussknacker.ui.statistics.NuFingerprint$;
import pl.touk.nussknacker.ui.statistics.PublicEncryptionKey;
import pl.touk.nussknacker.ui.statistics.RequestIdStat$;
import pl.touk.nussknacker.ui.statistics.StatisticError;
import pl.touk.nussknacker.ui.statistics.StatisticUrlConfig;
import pl.touk.nussknacker.ui.statistics.Statistics$;
import pl.touk.nussknacker.ui.util.IterableExtensions$;
import pl.touk.nussknacker.ui.util.IterableExtensions$Chunked$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.util.Either;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015ea\u0002\u000e\u001c!\u0003\r\nC\n\u0005\u0006[\u00011\tAL\u0004\u0007\u0003\u0007[\u0002\u0012\u00010\u0007\u000biY\u0002\u0012A)\t\u000bq\u001bA\u0011A/\u0007\t}\u001b!\u0001\u0019\u0005\tE\u0016\u0011\t\u0011)A\u0005G\"Aa-\u0002B\u0001B\u0003%q\r\u0003\u0005k\u000b\t\u0005\t\u0015!\u0003l\u0011\u0015aV\u0001\"\u0001w\u0011!aX\u0001#b\u0001\n\u0013i\b\"CA\u0006\u000b\t\u0007I\u0011BA\u0007\u0011!\tI\"\u0002Q\u0001\n\u0005=\u0001\"CA\u000e\u000b\t\u0007I\u0011BA\u0007\u0011!\ti\"\u0002Q\u0001\n\u0005=\u0001BB\u0017\u0006\t\u0003\ny\u0002C\u0004\u0002$\u0015!I!!\n\t\u000f\u0005ER\u0001\"\u0003\u00024!9\u0011\u0011J\u0003\u0005\n\u0005-\u0003bBA.\u000b\u0011%\u0011Q\f\u0005\b\u0003G*A\u0011BA3\u000f\u001d\tig\u0001E\u0003\u0003_2a\u0001U\u0002\t\u0006\u0005m\u0004B\u0002/\u0017\t\u0003\ti\b\u0003\u0004.-\u0011\u0005\u0013q\u0010\u0005\t\u0003c\u001aA\u0011A\u000e\u0002t\tQ1\u000b^1uSN$\u0018nY:\u000b\u0005qi\u0012AC:uCRL7\u000f^5dg*\u0011adH\u0001\u0003k&T!\u0001I\u0011\u0002\u00179,8o]6oC\u000e\\WM\u001d\u0006\u0003E\r\nA\u0001^8vW*\tA%\u0001\u0002qY\u000e\u00011C\u0001\u0001(!\tA3&D\u0001*\u0015\u0005Q\u0013!B:dC2\f\u0017B\u0001\u0017*\u0005\u0019\te.\u001f*fM\u0006Y\u0001O]3qCJ,WK\u0015't)\ty#\n\u0005\u00031qmzdBA\u00197\u001d\t\u0011T'D\u00014\u0015\t!T%\u0001\u0004=e>|GOP\u0005\u0002U%\u0011q'K\u0001\ba\u0006\u001c7.Y4f\u0013\tI$H\u0001\u0004FSRDWM\u001d\u0006\u0003o%\u0002\"\u0001P\u001f\u000e\u0003mI!AP\u000e\u0003\u001dM#\u0018\r^5ti&\u001cWI\u001d:peB\u0019\u0001\u0007\u0011\"\n\u0005\u0005S$\u0001\u0002'jgR\u0004\"a\u0011%\u000e\u0003\u0011S!!\u0012$\u0002\u00079,GOC\u0001H\u0003\u0011Q\u0017M^1\n\u0005%#%aA+S\u0019\")1*\u0001a\u0001\u0019\u0006\u00191MZ4\u0011\u0005qj\u0015B\u0001(\u001c\u0005I\u0019F/\u0019;jgRL7-\u0016:m\u0007>tg-[4*\u0007\u00011RAA\u0003F[B$\u0018pE\u0002\u0004OI\u0003\"a\u0015.\u000e\u0003QS!!\u0016,\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005]C\u0016\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003e\u000b1aY8n\u0013\tYFKA\u0006MCjLHj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001_!\ta4A\u0001\u0005O_:,U\u000e\u001d;z'\u0011)q%\u0019*\u0011\u0005q\u0002\u0011a\u00034j]\u001e,'\u000f\u001d:j]R\u0004\"\u0001\u00103\n\u0005\u0015\\\"a\u0003$j]\u001e,'\u000f\u001d:j]R\f\u0011B]3rk\u0016\u001cH/\u00133\u0011\u0005qB\u0017BA5\u001c\u0005%\u0011V-];fgRLE-A\u0007sC^\u001cF/\u0019;jgRL7m\u001d\t\u0005YB\u001c8O\u0004\u0002n]B\u0011!'K\u0005\u0003_&\na\u0001\u0015:fI\u00164\u0017BA9s\u0005\ri\u0015\r\u001d\u0006\u0003_&\u0002\"\u0001\u001c;\n\u0005U\u0014(AB*ue&tw\r\u0006\u0003xsj\\\bC\u0001=\u0006\u001b\u0005\u0019\u0001\"\u00022\n\u0001\u0004\u0019\u0007\"\u00024\n\u0001\u00049\u0007\"\u00026\n\u0001\u0004Y\u0017AF9vKJL\b+\u0019:b[N4uN]#wKJLXK\u0015'\u0016\u0003y\u0004Ba`A\u0005g6\u0011\u0011\u0011\u0001\u0006\u0005\u0003\u0007\t)!A\u0005j[6,H/\u00192mK*\u0019\u0011qA\u0015\u0002\u0015\r|G\u000e\\3di&|g.C\u0002B\u0003\u0003\tA$\u001a8def\u0004H/\u001a3QCJ\fWn])vKJL\b+\u0019:b[.+\u00170\u0006\u0002\u0002\u0010A!\u0011\u0011CA\f\u001b\t\t\u0019BC\u0002\u0002\u0016\u0019\u000bA\u0001\\1oO&\u0019Q/a\u0005\u0002;\u0015t7M]=qi\u0016$\u0007+\u0019:b[N\fV/\u001a:z!\u0006\u0014\u0018-\\&fs\u0002\n!$\u001a8def\u0004H/[8o\u0017\u0016L\u0018+^3ssB\u000b'/Y7LKf\f1$\u001a8def\u0004H/[8o\u0017\u0016L\u0018+^3ssB\u000b'/Y7LKf\u0004CcA\u0018\u0002\"!)1j\u0004a\u0001\u0019\u0006\u0001RM\\2pI\u0016\fV/\u001a:z!\u0006\u0014\u0018-\u001c\u000b\u0004g\u0006\u001d\u0002bBA\u0015!\u0001\u0007\u00111F\u0001\u0006K:$(/\u001f\t\u0006Q\u000552o]\u0005\u0004\u0003_I#A\u0002+va2,''\u0001\tqe\u0016\u0004\u0018M]3Ve2\u001cFO]5oOR1\u0011QGA\u001f\u0003\u000f\u0002R\u0001\r\u001d<\u0003o\u0001B\u0001KA\u001dg&\u0019\u00111H\u0015\u0003\r=\u0003H/[8o\u0011\u001d\ty$\u0005a\u0001\u0003\u0003\n1\"];fef\u0004\u0016M]1ngB!\u0001'a\u0011t\u0013\r\t)E\u000f\u0002\t\u0013R,'/\u00192mK\")1*\u0005a\u0001\u0019\u0006\u0011RM\\2ssB$\u0018+^3ssB\u000b'/Y7t)\u0019\ti%a\u0014\u0002ZA!\u0001\u0007O\u001et\u0011\u001d\t\tF\u0005a\u0001\u0003'\n1a[3z!\ra\u0014QK\u0005\u0004\u0003/Z\"a\u0005)vE2L7-\u00128def\u0004H/[8o\u0017\u0016L\bBBA %\u0001\u00071/A\fk_&t\u0017+^3ssB\u000b'/Y7t)>\u001cFO]5oOR)1/a\u0018\u0002b!9\u0011qH\nA\u0002\u0005\u0005\u0003\"B&\u0014\u0001\u0004a\u0015A\u00059sKB,g\u000eZ,ji\"\fE\r\u001a:fgN$Ra]A4\u0003WBa!!\u001b\u0015\u0001\u0004\u0019\u0018!\u00056pS:,G-U;fef\u0004\u0016M]1ng\")1\n\u0006a\u0001\u0019\u0006)Q)\u001c9usB\u0011\u0001PF\u0001\u0006i>,&\u000b\u0014\u000b\u0005\u0003k\n9\b\u0005\u00031qm\u0012\u0005BBA=3\u0001\u00071/A\u0005ve2\u001cFO]5oON\u0019acJ1\u0015\u0005\u0005=DcA\u0018\u0002\u0002\")1\n\u0007a\u0001\u0019\u0006Q1\u000b^1uSN$\u0018nY:")
public interface Statistics {
    public Either<StatisticError, List<URL>> prepareURLs(StatisticUrlConfig var1);

    public static final class NonEmpty
    implements Statistics,
    LazyLogging {
        private List<String> queryParamsForEveryURL;
        private final String fingerprint;
        private final String requestId;
        private final Map<String, String> rawStatistics;
        private final String encryptedParamsQueryParamKey;
        private final String encryptionKeyQueryParamKey;
        private transient Logger logger;
        private volatile transient boolean bitmap$trans$0;
        private volatile boolean bitmap$0;

        private Logger logger$lzycompute() {
            NonEmpty nonEmpty = this;
            synchronized (nonEmpty) {
                if (!this.bitmap$trans$0) {
                    this.logger = LazyLogging.logger$((LazyLogging)this);
                    this.bitmap$trans$0 = true;
                }
            }
            return this.logger;
        }

        public Logger logger() {
            return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
        }

        private List<String> queryParamsForEveryURL$lzycompute() {
            NonEmpty nonEmpty = this;
            synchronized (nonEmpty) {
                if (!this.bitmap$0) {
                    this.queryParamsForEveryURL = new .colon.colon((Object)this.encodeQueryParam((Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)NuFingerprint$.MODULE$.name()), (Object)this.fingerprint)), (List)new .colon.colon((Object)this.encodeQueryParam((Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)RequestIdStat$.MODULE$.name()), (Object)this.requestId)), (List)Nil$.MODULE$));
                    this.bitmap$0 = true;
                }
            }
            this.fingerprint = null;
            this.requestId = null;
            return this.queryParamsForEveryURL;
        }

        private List<String> queryParamsForEveryURL() {
            return !this.bitmap$0 ? this.queryParamsForEveryURL$lzycompute() : this.queryParamsForEveryURL;
        }

        private String encryptedParamsQueryParamKey() {
            return this.encryptedParamsQueryParamKey;
        }

        private String encryptionKeyQueryParamKey() {
            return this.encryptionKeyQueryParamKey;
        }

        @Override
        public Either<StatisticError, List<URL>> prepareURLs(StatisticUrlConfig cfg) {
            return ((Either)implicits$.MODULE$.toTraverseOps(IterableExtensions$Chunked$.MODULE$.groupByMaxChunkSize$extension(IterableExtensions$.MODULE$.Chunked((Iterable<String>)((Iterable)((List)this.rawStatistics.toList().sortBy((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1._1(), implicits$.MODULE$.catsKernelOrderingForOrder(implicits$.MODULE$.catsKernelStdOrderForString()))).map((Function1 & Serializable & scala.Serializable)entry -> this.encodeQueryParam((Tuple2<String, String>)entry), List$.MODULE$.canBuildFrom()))), cfg.urlBytesSizeLimit()).map((Function1 & Serializable & scala.Serializable)queryParams -> this.prepareUrlString((Iterable<String>)queryParams, cfg), List$.MODULE$.canBuildFrom()), implicits$.MODULE$.catsStdInstancesForList()).sequence(Predef$.MODULE$.$conforms(), (Applicative)implicits$.MODULE$.catsStdInstancesForEither())).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> (Either)implicits$.MODULE$.toTraverseOps(((List)x$2.flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).map((Function1 & Serializable & scala.Serializable)urlString -> Statistics$.MODULE$.toURL((String)urlString), List$.MODULE$.canBuildFrom()), implicits$.MODULE$.catsStdInstancesForList()).sequence(Predef$.MODULE$.$conforms(), (Applicative)implicits$.MODULE$.catsStdInstancesForEither()));
        }

        private String encodeQueryParam(Tuple2<String, String> entry) {
            return new StringBuilder(1).append(URLEncoder.encode((String)entry._1(), StandardCharsets.UTF_8)).append("=").append(URLEncoder.encode((String)entry._2(), StandardCharsets.UTF_8)).toString();
        }

        private Either<StatisticError, Option<String>> prepareUrlString(Iterable<String> queryParams, StatisticUrlConfig cfg) {
            Right right;
            if (queryParams.nonEmpty()) {
                PublicEncryptionKey key = cfg.publicEncryptionKey();
                String joinedQP = this.joinQueryParamsToString(queryParams, cfg);
                Either<StatisticError, String> encryptedJoinedQP = this.encryptQueryParams(key, joinedQP);
                right = encryptedJoinedQP.map((Function1 & Serializable & scala.Serializable)qp -> new Some((Object)this.prependWithAddress((String)qp, cfg)));
            } else {
                right = package$.MODULE$.Right().apply((Object)None$.MODULE$);
            }
            return right;
        }

        private Either<StatisticError, String> encryptQueryParams(PublicEncryptionKey key, String queryParams) {
            return Encryption$.MODULE$.encrypt(key, queryParams).map((Function1 & Serializable & scala.Serializable)r -> new StringBuilder(3).append(this.encryptedParamsQueryParamKey()).append("=").append(r.encryptedValue()).append("&").append(this.encryptionKeyQueryParamKey()).append("=").append(r.encryptedSymmetricKey()).toString());
        }

        private String joinQueryParamsToString(Iterable<String> queryParams, StatisticUrlConfig cfg) {
            Iterable queryParamsWithFingerprint = (Iterable)queryParams.$plus$plus(this.queryParamsForEveryURL(), Iterable$.MODULE$.canBuildFrom());
            return queryParamsWithFingerprint.mkString(cfg.queryParamsSeparator());
        }

        private String prependWithAddress(String joinedQueryParams, StatisticUrlConfig cfg) {
            return new StringBuilder(0).append(cfg.nuStatsUrl()).append(joinedQueryParams).toString();
        }

        public NonEmpty(String fingerprint, String requestId, Map<String, String> rawStatistics) {
            this.fingerprint = fingerprint;
            this.requestId = requestId;
            this.rawStatistics = rawStatistics;
            LazyLogging.$init$((LazyLogging)this);
            this.encryptedParamsQueryParamKey = "encryptedParams";
            this.encryptionKeyQueryParamKey = "encryptionKey";
        }
    }
}

