/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.process.deployment;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import pl.touk.nussknacker.engine.api.ProcessVersion;
import pl.touk.nussknacker.engine.api.deployment.DeployedScenarioData;
import pl.touk.nussknacker.engine.api.deployment.DeploymentManager;
import pl.touk.nussknacker.engine.api.deployment.ProcessState;
import pl.touk.nussknacker.engine.api.process.ProcessId;
import pl.touk.nussknacker.engine.api.process.ProcessName;
import pl.touk.nussknacker.engine.api.process.VersionId;
import pl.touk.nussknacker.engine.canonicalgraph.CanonicalProcess;
import pl.touk.nussknacker.engine.deployment.DeploymentData;
import pl.touk.nussknacker.restmodel.process.ProcessIdWithName;
import pl.touk.nussknacker.restmodel.processdetails;
import pl.touk.nussknacker.ui.api.ListenerApiUser$;
import pl.touk.nussknacker.ui.db.entity.ProcessActionEntityData;
import pl.touk.nussknacker.ui.listener.ProcessChangeEvent;
import pl.touk.nussknacker.ui.listener.ProcessChangeListener;
import pl.touk.nussknacker.ui.listener.User;
import pl.touk.nussknacker.ui.process.deployment.ScenarioResolver;
import pl.touk.nussknacker.ui.process.repository.DbProcessActionRepository;
import pl.touk.nussknacker.ui.process.repository.DeploymentComment;
import pl.touk.nussknacker.ui.process.repository.DeploymentComment$;
import pl.touk.nussknacker.ui.process.repository.FetchingProcessRepository;
import pl.touk.nussknacker.ui.process.repository.ProcessDBQueryRepository;
import pl.touk.nussknacker.ui.security.api.LoggedUser;
import pl.touk.nussknacker.ui.security.api.NussknackerInternalUser$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\tmc\u0001\u0002\n\u0014\u0001\u0001B\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\t}\u0001\u0011\t\u0011)A\u0005\u007f!A!\t\u0001B\u0001B\u0003%1\t\u0003\u0005H\u0001\t\u0005\t\u0015!\u0003I\u0011!q\u0005A!b\u0001\n\u0007y\u0005\u0002C*\u0001\u0005\u0003\u0005\u000b\u0011\u0002)\t\u000bQ\u0003A\u0011A+\t\u000bu\u0003A\u0011\u00010\t\u000f\u0005m\u0001\u0001\"\u0001\u0002\u001e!9\u0011Q\u000e\u0001\u0005\u0002\u0005=\u0004bBAP\u0001\u0011\u0005\u0011\u0011\u0015\u0005\b\u0003g\u0003A\u0011BA[\u0011\u001d\t\u0019\u000f\u0001C\u0005\u0003KDqA!\u0004\u0001\t\u0013\u0011y\u0001C\u0004\u0003$\u0001!IA!\n\t\u000f\t]\u0002\u0001\"\u0003\u0003:!9!q\b\u0001\u0005\n\t\u0005#!\u0005#fa2|\u00170\\3oiN+'O^5dK*\u0011A#F\u0001\u000bI\u0016\u0004Hn\\=nK:$(B\u0001\f\u0018\u0003\u001d\u0001(o\\2fgNT!\u0001G\r\u0002\u0005UL'B\u0001\u000e\u001c\u0003-qWo]:l]\u0006\u001c7.\u001a:\u000b\u0005qi\u0012\u0001\u0002;pk.T\u0011AH\u0001\u0003a2\u001c\u0001aE\u0002\u0001C\u001d\u0002\"AI\u0013\u000e\u0003\rR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\u0012a!\u00118z%\u00164\u0007C\u0001\u00150\u001b\u0005I#B\u0001\u0016,\u00031\u00198-\u00197bY><w-\u001b8h\u0015\taS&\u0001\u0005usB,7/\u00194f\u0015\u0005q\u0013aA2p[&\u0011\u0001'\u000b\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw-A\tqe>\u001cWm]:SKB|7/\u001b;pef\u00042a\r\u001c9\u001b\u0005!$BA\u001b\u0016\u0003)\u0011X\r]8tSR|'/_\u0005\u0003oQ\u0012\u0011DR3uG\"Lgn\u001a)s_\u000e,7o\u001d*fa>\u001c\u0018\u000e^8ssB\u0011\u0011\bP\u0007\u0002u)\u00111hI\u0001\u000bG>t7-\u001e:sK:$\u0018BA\u001f;\u0005\u00191U\u000f^;sK\u0006\u0001\u0012m\u0019;j_:\u0014V\r]8tSR|'/\u001f\t\u0003g\u0001K!!\u0011\u001b\u00033\u0011\u0013\u0007K]8dKN\u001c\u0018i\u0019;j_:\u0014V\r]8tSR|'/_\u0001\u0011g\u000e,g.\u0019:j_J+7o\u001c7wKJ\u0004\"\u0001R#\u000e\u0003MI!AR\n\u0003!M\u001bWM\\1sS>\u0014Vm]8mm\u0016\u0014\u0018!\u00069s_\u000e,7o]\"iC:<W\rT5ti\u0016tWM\u001d\t\u0003\u00132k\u0011A\u0013\u0006\u0003\u0017^\t\u0001\u0002\\5ti\u0016tWM]\u0005\u0003\u001b*\u0013Q\u0003\u0015:pG\u0016\u001c8o\u00115b]\u001e,G*[:uK:,'/\u0001\u0002fGV\t\u0001\u000b\u0005\u0002:#&\u0011!K\u000f\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\f1!Z2!\u0003\u0019a\u0014N\\5u}Q)a+\u0017.\\9R\u0011q\u000b\u0017\t\u0003\t\u0002AQAT\u0004A\u0004ACQ!M\u0004A\u0002IBQAP\u0004A\u0002}BQAQ\u0004A\u0002\rCQaR\u0004A\u0002!\u000bQbY1oG\u0016d\u0007K]8dKN\u001cH#B0ty\u0006%AC\u00011j!\rID(\u0019\t\u0003E\u001el\u0011a\u0019\u0006\u0003I\u0016\fa!\u001a8uSRL(B\u00014\u0018\u0003\t!'-\u0003\u0002iG\n9\u0002K]8dKN\u001c\u0018i\u0019;j_:,e\u000e^5us\u0012\u000bG/\u0019\u0005\u0006U\"\u0001\u001da[\u0001\u0005kN,'\u000f\u0005\u0002mc6\tQN\u0003\u0002o_\u0006\u0019\u0011\r]5\u000b\u0005A<\u0012\u0001C:fGV\u0014\u0018\u000e^=\n\u0005Il'A\u0003'pO\u001e,G-V:fe\")A\u000f\u0003a\u0001k\u0006I\u0001O]8dKN\u001c\u0018\n\u001a\t\u0003mjl\u0011a\u001e\u0006\u0003-aT!!_\r\u0002\u0013I,7\u000f^7pI\u0016d\u0017BA>x\u0005E\u0001&o\\2fgNLEmV5uQ:\u000bW.\u001a\u0005\u0006{\"\u0001\rA`\u0001\u0012I\u0016\u0004Hn\\=nK:$8i\\7nK:$\b\u0003\u0002\u0012\u0000\u0003\u0007I1!!\u0001$\u0005\u0019y\u0005\u000f^5p]B\u00191'!\u0002\n\u0007\u0005\u001dAGA\tEKBdw._7f]R\u001cu.\\7f]RDq!a\u0003\t\u0001\u0004\ti!A\u0007qKJ4wN]7DC:\u001cW\r\u001c\t\u0007E\u0005=Q/a\u0005\n\u0007\u0005E1EA\u0005Gk:\u001cG/[8ocA!\u0011\bPA\u000b!\r\u0011\u0013qC\u0005\u0004\u00033\u0019#\u0001B+oSR\fAcZ3u\t\u0016\u0004Hn\\=fIN\u001bWM\\1sS>\u001cH\u0003BA\u0010\u0003\u0013\u0002B!\u000f\u001f\u0002\"A1\u00111EA\u001a\u0003sqA!!\n\u000209!\u0011qEA\u0017\u001b\t\tICC\u0002\u0002,}\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0013\n\u0007\u0005E2%A\u0004qC\u000e\\\u0017mZ3\n\t\u0005U\u0012q\u0007\u0002\u0005\u0019&\u001cHOC\u0002\u00022\r\u0002B!a\u000f\u0002F5\u0011\u0011Q\b\u0006\u0004)\u0005}\"b\u00018\u0002B)\u0019\u00111I\r\u0002\r\u0015tw-\u001b8f\u0013\u0011\t9%!\u0010\u0003)\u0011+\u0007\u000f\\8zK\u0012\u001c6-\u001a8be&|G)\u0019;b\u0011\u001d\tY%\u0003a\u0001\u0003\u001b\na\u0002\u001d:pG\u0016\u001c8/\u001b8h)f\u0004X\r\u0005\u0003\u0002P\u0005\u001dd\u0002BA)\u0003KrA!a\u0015\u0002d9!\u0011QKA1\u001d\u0011\t9&a\u0018\u000f\t\u0005e\u0013Q\f\b\u0005\u0003O\tY&C\u0001\u001f\u0013\taR$\u0003\u0002\u001b7%\u0011\u00110G\u0005\u0003-aL1!!\rx\u0013\u0011\tI'a\u001b\u0003\u001dA\u0013xnY3tg&tw\rV=qK*\u0019\u0011\u0011G<\u0002\u001b\u0011,\u0007\u000f\\8z!J|7-Z:t))\t\t(a\u001e\u0002|\u0005E\u00151\u0013\u000b\u0005\u0003g\n)\bE\u0002:y\u0001DQA\u001b\u0006A\u0004-Da!!\u001f\u000b\u0001\u0004)\u0018!\u00059s_\u000e,7o]%e/&$\bNT1nK\"9\u0011Q\u0010\u0006A\u0002\u0005}\u0014!D:bm\u0016\u0004x.\u001b8u!\u0006$\b\u000e\u0005\u0003#\u007f\u0006\u0005\u0005\u0003BAB\u0003\u0017sA!!\"\u0002\bB\u0019\u0011qE\u0012\n\u0007\u0005%5%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u001b\u000byI\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0013\u001b\u0003\"B?\u000b\u0001\u0004q\bbBAK\u0015\u0001\u0007\u0011qS\u0001\u0012I\u0016\u0004Hn\\=nK:$X*\u00198bO\u0016\u0014\bc\u0002\u0012\u0002\u0010\u00055\u0013\u0011\u0014\t\u0005\u0003w\tY*\u0003\u0003\u0002\u001e\u0006u\"!\u0005#fa2|\u00170\\3oi6\u000bg.Y4fe\u0006)\u0002.\u00198eY\u00164\u0015N\\5tQ\u0016$\u0007K]8dKN\u001cHCBA\n\u0003G\u000b9\u000b\u0003\u0004\u0002&.\u0001\r!^\u0001\u000bS\u0012<\u0016\u000e\u001e5OC6,\u0007bBAU\u0017\u0001\u0007\u00111V\u0001\raJ|7-Z:t'R\fG/\u001a\t\u0005E}\fi\u000b\u0005\u0003\u0002<\u0005=\u0016\u0002BAY\u0003{\u0011A\u0002\u0015:pG\u0016\u001c8o\u0015;bi\u0016\fa\u0003\u001d:pG\u0016\u001c8\u000fR1uC\u0016C\u0018n\u001d;Pe\u001a\u000b\u0017\u000e\\\u000b\u0005\u0003o\u000by\f\u0006\u0004\u0002:\u0006E\u0017q\u001b\t\u0005sq\nY\f\u0005\u0003\u0002>\u0006}F\u0002\u0001\u0003\b\u0003\u0003d!\u0019AAb\u0005\u0005!\u0016\u0003BAc\u0003\u0017\u00042AIAd\u0013\r\tIm\t\u0002\b\u001d>$\b.\u001b8h!\r\u0011\u0013QZ\u0005\u0004\u0003\u001f\u001c#aA!os\"9\u00111\u001b\u0007A\u0002\u0005U\u0017\u0001D7bs\n,\u0007K]8dKN\u001c\b\u0003\u0002\u0012\u0000\u0003wCa\u0001\u001e\u0007A\u0002\u0005e\u0007\u0003BAn\u0003?l!!!8\u000b\u0007Y\ty$\u0003\u0003\u0002b\u0006u'!\u0003)s_\u000e,7o]%e\u0003Q!W\r\u001d7ps\u0006sGmU1wKB\u0013xnY3tgRQ\u0011q]Av\u0005\u000f\u0011IAa\u0003\u0015\t\u0005M\u0014\u0011\u001e\u0005\u0006U6\u0001\u001da\u001b\u0005\u0007-5\u0001\r!!<\u0011\r\u0005=\u0018Q_A~\u001d\u0011\t\u0019&!=\n\u0007\u0005M\b0\u0001\bqe>\u001cWm]:eKR\f\u0017\u000e\\:\n\t\u0005]\u0018\u0011 \u0002\u0013\u0005\u0006\u001cX\r\u0015:pG\u0016\u001c8\u000fR3uC&d7OC\u0002\u0002tb\u0004B!!@\u0003\u00045\u0011\u0011q \u0006\u0005\u0005\u0003\t\t%\u0001\bdC:|g.[2bY\u001e\u0014\u0018\r\u001d5\n\t\t\u0015\u0011q \u0002\u0011\u0007\u0006twN\\5dC2\u0004&o\\2fgNDq!! \u000e\u0001\u0004\ty\bC\u0003~\u001b\u0001\u0007a\u0010C\u0004\u0002\u00166\u0001\r!!'\u0002+A\u0014X\r]1sK\u0012+\u0007\u000f\\8z[\u0016tG\u000fR1uCR!!\u0011\u0003B\u000e!\u0011\u0011\u0019Ba\u0006\u000e\u0005\tU!b\u0001\u000b\u0002B%!!\u0011\u0004B\u000b\u00059!U\r\u001d7ps6,g\u000e\u001e#bi\u0006DaA\u001b\bA\u0002\tu\u0001\u0003\u0002B\n\u0005?IAA!\t\u0003\u0016\t!Qk]3s\u0003M1\u0017N\u001c3EKBdw._3e-\u0016\u00148/[8o)\u0011\u00119C!\u000e\u0015\t\t%\"1\u0007\t\u0005sq\u0012Y\u0003\u0005\u0003#\u007f\n5\u0002\u0003BAn\u0005_IAA!\r\u0002^\nIa+\u001a:tS>t\u0017\n\u001a\u0005\u0006U>\u0001\u001da\u001b\u0005\u0006i>\u0001\r!^\u0001\u000ei>l\u0015M\\1hKJ,6/\u001a:\u0015\t\tu!1\b\u0005\u0007\u0005{\u0001\u0002\u0019A6\u0002\u00151|wmZ3e+N,'/\u0001\u0011xSRDG)\u001a9m_flWM\u001c;BGRLwN\u001c(pi&4\u0017nY1uS>tG\u0003\u0003B\"\u0005'\u0012)F!\u0017\u0015\t\t\u0015#\u0011\n\u000b\u0004A\n\u001d\u0003\"\u00026\u0012\u0001\bY\u0007\u0002\u0003B&#\u0011\u0005\rA!\u0014\u0002\r\u0005\u001cG/[8o!\u0011\u0011#q\n1\n\u0007\tE3E\u0001\u0005=Eft\u0017-\\3?\u0011\u0019\tI(\u0005a\u0001k\"9!qK\tA\u0002\u0005\u0005\u0015AC1di&|gNT1nK\")Q0\u0005a\u0001}\u0002")
public class DeploymentService
implements LazyLogging {
    private final FetchingProcessRepository<Future> processRepository;
    private final DbProcessActionRepository actionRepository;
    private final ScenarioResolver scenarioResolver;
    private final ProcessChangeListener processChangeListener;
    private final ExecutionContext ec;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        DeploymentService deploymentService = this;
        synchronized (deploymentService) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    public Future<ProcessActionEntityData> cancelProcess(ProcessIdWithName processId, Option<DeploymentComment> deploymentComment, Function1<ProcessIdWithName, Future<BoxedUnit>> performCancel, LoggedUser user) {
        return this.withDeploymentActionNotification(processId, "cancel", deploymentComment, (Function0<Future<ProcessActionEntityData>>)(Function0 & Serializable & scala.Serializable)() -> ((Future)performCancel.apply((Object)processId)).flatMap((Function1 & Serializable & scala.Serializable)_ -> this.findDeployedVersion(processId, user).flatMap((Function1 & Serializable & scala.Serializable)maybeVersion -> this.processDataExistOrFail((Option)maybeVersion, processId.id()).flatMap((Function1 & Serializable & scala.Serializable)version -> $this.actionRepository.markProcessAsCancelled(processId.id(), (VersionId)version, deploymentComment, user).map((Function1 & Serializable & scala.Serializable)result -> result, this.ec()), this.ec()), this.ec()), this.ec()), user);
    }

    public Future<List<DeployedScenarioData>> getDeployedScenarios(String processingType) {
        NussknackerInternalUser$ userFetchingDataFromRepository = NussknackerInternalUser$.MODULE$;
        return this.processRepository.fetchProcesses((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)), (Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)), (Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)), (Option<Seq<String>>)None$.MODULE$, (Option<Seq<String>>)new Some((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{processingType}))), processdetails.ProcessShapeFetchStrategy$.FetchCanonical$.MODULE$, (LoggedUser)userFetchingDataFromRepository, this.ec()).flatMap((Function1 & Serializable & scala.Serializable)deployedProcesses -> Future$.MODULE$.sequence((TraversableOnce)deployedProcesses.flatMap((Function1 & Serializable & scala.Serializable)details -> {
            Iterable iterable;
            processdetails.ProcessAction lastDeployAction = (processdetails.ProcessAction)details.lastDeployedAction().get();
            ProcessVersion processVersion = new ProcessVersion(lastDeployAction.processVersionId(), new ProcessName(details.name()), details.processId(), details.createdBy(), details.modelVersion());
            pl.touk.nussknacker.engine.deployment.User deployingUser = new pl.touk.nussknacker.engine.deployment.User(lastDeployAction.user(), lastDeployAction.user());
            DeploymentData deploymentData = this.prepareDeploymentData(deployingUser);
            Try deployedScenarioDataTry = $this.scenarioResolver.resolveScenario((CanonicalProcess)details.json(), details.processCategory()).map((Function1 & Serializable & scala.Serializable)resolvedScenario -> new DeployedScenarioData(processVersion, deploymentData, resolvedScenario));
            Try try_ = deployedScenarioDataTry;
            if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringBuilder(45).append("Exception during resolving deployed scenario ").append(details.id()).toString(), exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            } else if (try_ instanceof Success) {
                Success success = (Success)try_;
                DeployedScenarioData value = (DeployedScenarioData)success.value();
                iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)Future$.MODULE$.successful((Object)value)));
            } else {
                throw new MatchError((Object)try_);
            }
            return iterable;
        }, List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom(), this.ec()).map((Function1 & Serializable & scala.Serializable)dataList -> dataList, this.ec()), this.ec());
    }

    public Future<Future<ProcessActionEntityData>> deployProcess(ProcessIdWithName processIdWithName, Option<String> savepointPath, Option<DeploymentComment> deploymentComment, Function1<String, DeploymentManager> deploymentManager, LoggedUser user) {
        return this.processRepository.fetchLatestProcessDetailsForProcessId(processIdWithName.id(), processdetails.ProcessShapeFetchStrategy$.FetchCanonical$.MODULE$, user, this.ec()).flatMap((Function1 & Serializable & scala.Serializable)maybeProcess -> this.processDataExistOrFail((Option)maybeProcess, processIdWithName.id()).flatMap((Function1 & Serializable & scala.Serializable)process -> this.deployAndSaveProcess((processdetails.BaseProcessDetails<CanonicalProcess>)process, savepointPath, deploymentComment, (DeploymentManager)deploymentManager.apply((Object)process.processingType()), user).map((Function1 & Serializable & scala.Serializable)result -> result, this.ec()), this.ec()), this.ec());
    }

    public Future<BoxedUnit> handleFinishedProcess(ProcessIdWithName idWithName, Option<ProcessState> processState) {
        Some some;
        ProcessState state;
        NussknackerInternalUser$ user = NussknackerInternalUser$.MODULE$;
        User listenerUser = ListenerApiUser$.MODULE$.apply((LoggedUser)user);
        Option<ProcessState> option = processState;
        Future future = option instanceof Some && (state = (ProcessState)(some = (Some)option).value()).status().isFinished() ? this.findDeployedVersion(idWithName, (LoggedUser)user).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Future future;
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                VersionId version = (VersionId)some.value();
                DeploymentComment finishedDeploymentComment = DeploymentComment$.MODULE$.unsafe("Scenario finished");
                future = $this.actionRepository.markProcessAsCancelled(idWithName.id(), version, (Option<DeploymentComment>)new Some((Object)finishedDeploymentComment), (LoggedUser)user).map((Function1 & Serializable & scala.Serializable)x$1 -> {
                    this.processChangeListener.handle((ProcessChangeEvent)new ProcessChangeEvent.OnFinished(idWithName.id(), version), this.ec(), listenerUser);
                    return BoxedUnit.UNIT;
                }, this.ec());
            } else {
                future = Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
            }
            return future;
        }, this.ec()) : Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
        return future;
    }

    private <T> Future<T> processDataExistOrFail(Option<T> maybeProcess, ProcessId processId) {
        Future future;
        Option<T> option = maybeProcess;
        if (option instanceof Some) {
            Some some = (Some)option;
            Object processData = some.value();
            future = Future$.MODULE$.successful(processData);
        } else if (None$.MODULE$.equals(option)) {
            future = Future$.MODULE$.failed((Throwable)new ProcessDBQueryRepository.ProcessNotFoundError(((Object)BoxesRunTime.boxToLong((long)processId.value())).toString()));
        } else {
            throw new MatchError(option);
        }
        return future;
    }

    private Future<Future<ProcessActionEntityData>> deployAndSaveProcess(processdetails.BaseProcessDetails<CanonicalProcess> process, Option<String> savepointPath, Option<DeploymentComment> deploymentComment, DeploymentManager deploymentManager, LoggedUser user) {
        ProcessVersion processVersion = process.toEngineProcessVersion();
        Future validatedData = Future$.MODULE$.fromTry(this.scenarioResolver.resolveScenario((CanonicalProcess)process.json(), process.processCategory())).map((Function1 & Serializable & scala.Serializable)resolvedCanonicalProces -> {
            DeploymentData deploymentData = this.prepareDeploymentData(this.toManagerUser(user));
            return new Tuple2(resolvedCanonicalProces, (Object)deploymentData);
        }, this.ec()).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> {
            Tuple2 tuple2 = x$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            CanonicalProcess resolvedCanonicalProces = (CanonicalProcess)tuple2._1();
            DeploymentData deploymentData = (DeploymentData)tuple2._2();
            Future future = deploymentManager.validate(processVersion, deploymentData, resolvedCanonicalProces).map((Function1 & Serializable & scala.Serializable)_ -> new Tuple2((Object)resolvedCanonicalProces, (Object)deploymentData), this.ec());
            return future;
        }, this.ec());
        return validatedData.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            CanonicalProcess resolvedCanonicalProces = (CanonicalProcess)tuple2._1();
            DeploymentData deploymentData = (DeploymentData)tuple2._2();
            Future<ProcessActionEntityData> future = this.withDeploymentActionNotification(process.idWithName(), "deploy", deploymentComment, (Function0<Future<ProcessActionEntityData>>)(Function0 & Serializable & scala.Serializable)() -> deploymentManager.deploy(processVersion, deploymentData, resolvedCanonicalProces, savepointPath).flatMap((Function1 & Serializable & scala.Serializable)_ -> $this.actionRepository.markProcessAsDeployed(process.processId(), process.processVersionId(), process.processingType(), deploymentComment, user).map((Function1 & Serializable & scala.Serializable)deployedActionData -> deployedActionData, this.ec()), this.ec()), user);
            return future;
        }, this.ec());
    }

    private DeploymentData prepareDeploymentData(pl.touk.nussknacker.engine.deployment.User user) {
        return new DeploymentData("", user, Predef$.MODULE$.Map().empty());
    }

    private Future<Option<VersionId>> findDeployedVersion(ProcessIdWithName processId, LoggedUser user) {
        return this.processRepository.fetchLatestProcessDetailsForProcessId(processId.id(), processdetails.ProcessShapeFetchStrategy$.NotFetch$.MODULE$, user, this.ec()).map((Function1 & Serializable & scala.Serializable)process -> {
            Option lastAction = process.flatMap((Function1 & Serializable & scala.Serializable)x$3 -> x$3.lastDeployedAction());
            return new Tuple2(process, (Object)lastAction);
        }, this.ec()).map((Function1 & Serializable & scala.Serializable)x$4 -> {
            Tuple2 tuple2 = x$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Option lastAction = (Option)tuple2._2();
            Option option = lastAction.map((Function1 & Serializable & scala.Serializable)la -> la.processVersionId());
            return option;
        }, this.ec());
    }

    private pl.touk.nussknacker.engine.deployment.User toManagerUser(LoggedUser loggedUser) {
        return new pl.touk.nussknacker.engine.deployment.User(loggedUser.id(), loggedUser.username());
    }

    private Future<ProcessActionEntityData> withDeploymentActionNotification(ProcessIdWithName processIdWithName, String actionName, Option<DeploymentComment> deploymentComment, Function0<Future<ProcessActionEntityData>> action, LoggedUser user) {
        User listenerUser = ListenerApiUser$.MODULE$.apply(user);
        Future actionToRun = (Future)action.apply();
        actionToRun.onComplete((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DeploymentService.$anonfun$withDeploymentActionNotification$1(this, actionName, processIdWithName, listenerUser, deploymentComment, x0$1);
            return BoxedUnit.UNIT;
        }, this.ec());
        return actionToRun;
    }

    public static final /* synthetic */ void $anonfun$withDeploymentActionNotification$1(DeploymentService $this, String actionName$1, ProcessIdWithName processIdWithName$2, User listenerUser$2, Option deploymentComment$4, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)try_;
            Throwable failure2 = failure.exception();
            if ($this.logger().underlying().isErrorEnabled()) {
                $this.logger().underlying().error(new StringBuilder(34).append("Action: ").append(actionName$1).append(" of ").append(processIdWithName$2.name()).append(" finished with failure").toString(), failure2);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            $this.processChangeListener.handle((ProcessChangeEvent)new ProcessChangeEvent.OnDeployActionFailed(processIdWithName$2.id(), failure2), $this.ec(), listenerUser$2);
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        } else if (try_ instanceof Success) {
            BoxedUnit boxedUnit;
            Success success = (Success)try_;
            ProcessActionEntityData details = (ProcessActionEntityData)success.value();
            if ($this.logger().underlying().isInfoEnabled()) {
                $this.logger().underlying().info("Finishing {} of {}", new Object[]{actionName$1, processIdWithName$2.name()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            $this.processChangeListener.handle((ProcessChangeEvent)new ProcessChangeEvent.OnDeployActionSuccess(details.processId(), details.processVersionId(), deploymentComment$4, details.performedAtTime(), details.action()), $this.ec(), listenerUser$2);
            BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public DeploymentService(FetchingProcessRepository<Future> processRepository, DbProcessActionRepository actionRepository, ScenarioResolver scenarioResolver, ProcessChangeListener processChangeListener, ExecutionContext ec) {
        this.processRepository = processRepository;
        this.actionRepository = actionRepository;
        this.scenarioResolver = scenarioResolver;
        this.processChangeListener = processChangeListener;
        this.ec = ec;
        LazyLogging.$init$((LazyLogging)this);
    }
}

