/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.process.repository;

import cats.data.EitherT;
import cats.data.EitherT$;
import cats.syntax.EitherIdOps$;
import cats.syntax.EitherObjectOps$;
import cats.syntax.package;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import db.util.DBIOActionInstances$;
import java.io.Serializable;
import java.sql.Timestamp;
import java.time.Instant;
import pl.touk.nussknacker.engine.api.process.ProcessId;
import pl.touk.nussknacker.engine.api.process.ProcessName;
import pl.touk.nussknacker.engine.api.process.VersionId;
import pl.touk.nussknacker.engine.api.process.VersionId$;
import pl.touk.nussknacker.engine.canonicalgraph.CanonicalProcess;
import pl.touk.nussknacker.restmodel.process.ProcessIdWithName;
import pl.touk.nussknacker.restmodel.processdetails;
import pl.touk.nussknacker.ui.EspError;
import pl.touk.nussknacker.ui.db.DbConfig;
import pl.touk.nussknacker.ui.db.entity.AttachmentEntityFactory;
import pl.touk.nussknacker.ui.db.entity.BaseEntityFactory;
import pl.touk.nussknacker.ui.db.entity.CommentActions;
import pl.touk.nussknacker.ui.db.entity.CommentEntityData;
import pl.touk.nussknacker.ui.db.entity.CommentEntityFactory;
import pl.touk.nussknacker.ui.db.entity.EnvironmentsEntityFactory;
import pl.touk.nussknacker.ui.db.entity.ProcessActionEntityData;
import pl.touk.nussknacker.ui.db.entity.ProcessActionEntityFactory;
import pl.touk.nussknacker.ui.db.entity.ProcessEntityData;
import pl.touk.nussknacker.ui.db.entity.ProcessEntityFactory;
import pl.touk.nussknacker.ui.db.entity.ProcessVersionEntityData;
import pl.touk.nussknacker.ui.db.entity.ProcessVersionEntityFactory;
import pl.touk.nussknacker.ui.db.entity.TagsEntityData;
import pl.touk.nussknacker.ui.db.entity.TagsEntityFactory;
import pl.touk.nussknacker.ui.listener.Comment;
import pl.touk.nussknacker.ui.process.processingtypedata.ProcessingTypeDataProvider;
import pl.touk.nussknacker.ui.process.repository.ProcessDBQueryRepository;
import pl.touk.nussknacker.ui.process.repository.ProcessRepository;
import pl.touk.nussknacker.ui.process.repository.Repository;
import pl.touk.nussknacker.ui.process.repository.UpdateProcessComment;
import pl.touk.nussknacker.ui.security.api.LoggedUser;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.Either;
import scala.util.Right;
import scala.util.Right$;
import slick.ast.BaseTypedType;
import slick.ast.TypedType;
import slick.dbio.DBIOAction;
import slick.dbio.DBIOAction$;
import slick.dbio.Effect;
import slick.dbio.NoStream;
import slick.jdbc.JdbcActionComponent;
import slick.jdbc.JdbcProfile;
import slick.jdbc.JdbcType;
import slick.lifted.BaseColumnExtensionMethods;
import slick.lifted.BooleanColumnExtensionMethods$;
import slick.lifted.CanBeQueryCondition$;
import slick.lifted.OptionMapper2$;
import slick.lifted.Query;
import slick.lifted.Rep;
import slick.lifted.Shape$;
import slick.lifted.TableQuery;
import slick.sql.FixedSqlAction;

@ScalaSignature(bytes="\u0006\u0001\tUd\u0001B\t\u0013\u0001}A\u0001\u0002\u0016\u0001\u0003\u0006\u0004%\t!\u0016\u0005\t3\u0002\u0011\t\u0011)A\u0005-\"A!\f\u0001BC\u0002\u0013\u00051\f\u0003\u0005f\u0001\t\u0005\t\u0015!\u0003]\u0011\u00151\u0007\u0001\"\u0001h\u0011\u0015Y\u0007\u0001\"\u0011m\u0011\u0015i\b\u0001\"\u0001\u007f\u0011\u001d\tY\u0006\u0001C\u0001\u0003;Bq!a\u001e\u0001\t\u0013\tI\bC\u0004\u0002.\u0002!I!a,\t\u000f\u0005=\b\u0001\"\u0001\u0002r\"9\u0011\u0011 \u0001\u0005\u0002\u0005m\bb\u0002B\u0002\u0001\u0011\u0005!Q\u0001\u0005\b\u0005#\u0001A\u0011\u0001B\n\u0011\u001d\u0011i\u0003\u0001C\t\u0005_AqA!\u0011\u0001\t\u0003\u0011\u0019EA\nE\u0005B\u0013xnY3tgJ+\u0007o\\:ji>\u0014\u0018P\u0003\u0002\u0014)\u0005Q!/\u001a9pg&$xN]=\u000b\u0005U1\u0012a\u00029s_\u000e,7o\u001d\u0006\u0003/a\t!!^5\u000b\u0005eQ\u0012a\u00038vgN\\g.Y2lKJT!a\u0007\u000f\u0002\tQ|Wo\u001b\u0006\u0002;\u0005\u0011\u0001\u000f\\\u0002\u0001'\u001d\u0001\u0001E\n\u001fB\u0017F\u0003\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u0012a!\u00118z%\u00164\u0007cA\u0014)U5\t!#\u0003\u0002*%\t\t\u0002K]8dKN\u001c(+\u001a9pg&$xN]=\u0011\u0005-JdB\u0001\u00177\u001d\ti3G\u0004\u0002/c5\tqF\u0003\u00021=\u00051AH]8pizJ\u0011AM\u0001\u0003I\nL!\u0001N\u001b\u0002\tU$\u0018\u000e\u001c\u0006\u0002e%\u0011q\u0007O\u0001\u0014\t\nKu*Q2uS>t\u0017J\\:uC:\u001cWm\u001d\u0006\u0003iUJ!AO\u001e\u0003\u0005\u0011\u0013%BA\u001c9!\tit(D\u0001?\u0015\t\u0011d#\u0003\u0002A}\tIQi\u001d9UC\ndWm\u001d\t\u0003\u0005&k\u0011a\u0011\u0006\u0003\t\u0016\u000bAb]2bY\u0006dwnZ4j]\u001eT!AR$\u0002\u0011QL\b/Z:bM\u0016T\u0011\u0001S\u0001\u0004G>l\u0017B\u0001&D\u0005-a\u0015M_=M_\u001e<\u0017N\\4\u0011\u00051{U\"A'\u000b\u00059s\u0014AB3oi&$\u00180\u0003\u0002Q\u001b\nq1i\\7nK:$\u0018i\u0019;j_:\u001c\bcA\u0014SU%\u00111K\u0005\u0002\u0019!J|7-Z:t\t\n\u000bV/\u001a:z%\u0016\u0004xn]5u_JL\u0018\u0001\u00033c\u0007>tg-[4\u0016\u0003Y\u0003\"!P,\n\u0005as$\u0001\u0003#c\u0007>tg-[4\u0002\u0013\u0011\u00147i\u001c8gS\u001e\u0004\u0013\u0001D7pI\u0016dg+\u001a:tS>tW#\u0001/\u0011\u0007u\u0003'-D\u0001_\u0015\tyF#\u0001\nqe>\u001cWm]:j]\u001e$\u0018\u0010]3eCR\f\u0017BA1_\u0005i\u0001&o\\2fgNLgn\u001a+za\u0016$\u0015\r^1Qe>4\u0018\u000eZ3s!\t\t3-\u0003\u0002eE\t\u0019\u0011J\u001c;\u0002\u001b5|G-\u001a7WKJ\u001c\u0018n\u001c8!\u0003\u0019a\u0014N\\5u}Q\u0019\u0001.\u001b6\u0011\u0005\u001d\u0002\u0001\"\u0002+\u0006\u0001\u00041\u0006\"\u0002.\u0006\u0001\u0004a\u0016a\u0001:v]V\u0011Q\u000e^\u000b\u0002]B!\u0011e\\9r\u0013\t\u0001(EA\u0005Gk:\u001cG/[8ocA\u00191&\u000f:\u0011\u0005M$H\u0002\u0001\u0003\u0006k\u001a\u0011\rA\u001e\u0002\u0002%F\u0011qO\u001f\t\u0003CaL!!\u001f\u0012\u0003\u000f9{G\u000f[5oOB\u0011\u0011e_\u0005\u0003y\n\u00121!\u00118z\u00039\u0019\u0018M^3OK^\u0004&o\\2fgN$2a`A))\u0011\t\t!!\u0010\u0011\t-J\u00141\u0001\t\u0007\u0003\u000b\tY\"!\t\u000f\t\u0005\u001d\u0011q\u0003\b\u0005\u0003\u0013\t)B\u0004\u0003\u0002\f\u0005Ma\u0002BA\u0007\u0003#q1ALA\b\u0013\u0005i\u0012BA\u000e\u001d\u0013\tI\"$\u0003\u0002\u00181%\u0019\u0011\u0011\u0004\f\u0002\u0011\u0015\u001b\b/\u0012:s_JLA!!\b\u0002 \t1\u0001,\u0012:s_JT1!!\u0007\u0017!\u0015\t\u00131EA\u0014\u0013\r\t)C\t\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005%\u0012q\u0007\b\u0005\u0003W\t\u0019D\u0004\u0003\u0002.\u0005Eb\u0002BA\u0004\u0003_I!!\u0006\f\n\u0005M!\u0012bAA\u001b%\u0005\t\u0002K]8dKN\u001c(+\u001a9pg&$xN]=\n\t\u0005e\u00121\b\u0002\u000f!J|7-Z:t\u0007J,\u0017\r^3e\u0015\r\t)D\u0005\u0005\b\u0003\u007f9\u00019AA!\u0003)awnZ4fIV\u001bXM\u001d\t\u0005\u0003\u0007\ni%\u0004\u0002\u0002F)!\u0011qIA%\u0003\r\t\u0007/\u001b\u0006\u0004\u0003\u00172\u0012\u0001C:fGV\u0014\u0018\u000e^=\n\t\u0005=\u0013Q\t\u0002\u000b\u0019><w-\u001a3Vg\u0016\u0014\bbBA*\u000f\u0001\u0007\u0011QK\u0001\u0007C\u000e$\u0018n\u001c8\u0011\t\u0005%\u0012qK\u0005\u0005\u00033\nYDA\nDe\u0016\fG/\u001a)s_\u000e,7o]!di&|g.A\u0007va\u0012\fG/\u001a)s_\u000e,7o\u001d\u000b\u0005\u0003?\ni\u0007\u0006\u0003\u0002b\u0005-\u0004\u0003B\u0016:\u0003G\u0002b!!\u0002\u0002\u001c\u0005\u0015\u0004\u0003BA\u0015\u0003OJA!!\u001b\u0002<\tq\u0001K]8dKN\u001cX\u000b\u001d3bi\u0016$\u0007bBA \u0011\u0001\u000f\u0011\u0011\t\u0005\b\u0003_B\u0001\u0019AA9\u0003M)\b\u000fZ1uKB\u0013xnY3tg\u0006\u001bG/[8o!\u0011\tI#a\u001d\n\t\u0005U\u00141\b\u0002\u0014+B$\u0017\r^3Qe>\u001cWm]:BGRLwN\\\u0001\u0016kB$\u0017\r^3Qe>\u001cWm]:J]R,'O\\1m)!\tY(a \u0002\u0014\u0006\rF\u0003BA1\u0003{Bq!a\u0010\n\u0001\b\t\t\u0005C\u0004\u0002\u0002&\u0001\r!a!\u0002\u0013A\u0014xnY3tg&#\u0007\u0003BAC\u0003\u001fk!!a\"\u000b\u0007U\tII\u0003\u0003\u0002H\u0005-%bAAG1\u00051QM\\4j]\u0016LA!!%\u0002\b\nI\u0001K]8dKN\u001c\u0018\n\u001a\u0005\b\u0003+K\u0001\u0019AAL\u0003A\u0019\u0017M\\8oS\u000e\fG\u000e\u0015:pG\u0016\u001c8\u000f\u0005\u0003\u0002\u001a\u0006}UBAAN\u0015\u0011\ti*a#\u0002\u001d\r\fgn\u001c8jG\u0006dwM]1qQ&!\u0011\u0011UAN\u0005A\u0019\u0015M\\8oS\u000e\fG\u000e\u0015:pG\u0016\u001c8\u000fC\u0004\u0002&&\u0001\r!a*\u0002C%t7M]3bg\u00164VM]:j_:<\u0006.\u001a8Kg>tgj\u001c;DQ\u0006tw-\u001a3\u0011\u0007\u0005\nI+C\u0002\u0002,\n\u0012qAQ8pY\u0016\fg.\u0001\u0005m_\u001e$UMY;h)\u0011\t\t,a7\u0011\u0015\u0005M\u0016QXAa\u0003\u000f\fi-\u0004\u0002\u00026*!\u0011qWA]\u0003\u0011!'-[8\u000b\u0005\u0005m\u0016!B:mS\u000e\\\u0017\u0002BA`\u0003k\u0013!\u0002\u0012\"J\u001f\u0006\u001bG/[8o!\r\t\u00131Y\u0005\u0004\u0003\u000b\u0014#\u0001B+oSR\u0004B!a-\u0002J&!\u00111ZA[\u0005!qun\u0015;sK\u0006l\u0007\u0003BAh\u0003+tA!a-\u0002R&!\u00111[A[\u0003\u0019)eMZ3di&!\u0011q[Am\u0005\r\tE\u000e\u001c\u0006\u0005\u0003'\f)\fC\u0004\u0002^*\u0001\r!a8\u0002\u0003M\u0004B!!9\u0002j:!\u00111]As!\tq#%C\u0002\u0002h\n\na\u0001\u0015:fI\u00164\u0017\u0002BAv\u0003[\u0014aa\u0015;sS:<'bAAtE\u0005iA-\u001a7fi\u0016\u0004&o\\2fgN$B!a=\u0002xB!1&OA{!\u0019\t)!a\u0007\u0002B\"9\u0011\u0011Q\u0006A\u0002\u0005\r\u0015aB1sG\"Lg/\u001a\u000b\u0007\u0003g\fi0a@\t\u000f\u0005\u0005E\u00021\u0001\u0002\u0004\"9!\u0011\u0001\u0007A\u0002\u0005\u001d\u0016AC5t\u0003J\u001c\u0007.\u001b<fI\u0006qQ\u000f\u001d3bi\u0016\u001c\u0015\r^3h_JLHC\u0002B\u0004\u0005\u0017\u0011i\u0001\u0006\u0003\u0002t\n%\u0001bBA \u001b\u0001\u000f\u0011\u0011\t\u0005\b\u0003\u0003k\u0001\u0019AAB\u0011\u001d\u0011y!\u0004a\u0001\u0003?\f\u0001bY1uK\u001e|'/_\u0001\u000ee\u0016t\u0017-\\3Qe>\u001cWm]:\u0015\r\tU!\u0011\u0004B\u0015)\u0011\t\u0019Pa\u0006\t\u000f\u0005}b\u0002q\u0001\u0002B!1QC\u0004a\u0001\u00057\u0001BA!\b\u0003&5\u0011!q\u0004\u0006\u0004+\t\u0005\"b\u0001B\u00121\u0005I!/Z:u[>$W\r\\\u0005\u0005\u0005O\u0011yBA\tQe>\u001cWm]:JI^KG\u000f\u001b(b[\u0016DqAa\u000b\u000f\u0001\u0004\ty.A\u0004oK^t\u0015-\\3\u0002\u00079|w/\u0006\u0002\u00032A!!1\u0007B\u001f\u001b\t\u0011)D\u0003\u0003\u00038\te\u0012\u0001\u0002;j[\u0016T!Aa\u000f\u0002\t)\fg/Y\u0005\u0005\u0005\u007f\u0011)DA\u0004J]N$\u0018M\u001c;\u0002\u001f\rD\u0017M\\4f-\u0016\u00148/[8o\u0013\u0012$\u0002B!\u0012\u0003f\t\u001d$\u0011\u000f\t\n\u0005\u000f\u0012\u0019FYAd\u0005?rAA!\u0013\u0003L5\t\u0001!\u0003\u0003\u0003N\t=\u0013a\u00029s_\u001aLG.Z\u0005\u0004\u0005#\u0012\"A\u0003*fa>\u001c\u0018\u000e^8ss&!!Q\u000bB,\u00055\u0001&o\u001c4jY\u0016\f5\r^5p]&!!\u0011\fB.\u0005MQEMY2BGRLwN\\\"p[B|g.\u001a8u\u0015\u0011\u0011i&!/\u0002\t)$'m\u0019\t\u0005\u0003\u001f\u0014\t'\u0003\u0003\u0003d\u0005e'!B,sSR,\u0007bBAA!\u0001\u0007\u00111\u0011\u0005\b\u0005S\u0002\u0002\u0019\u0001B6\u0003%1XM]:j_:LE\r\u0005\u0003\u0002\u0006\n5\u0014\u0002\u0002B8\u0003\u000f\u0013\u0011BV3sg&|g.\u00133\t\u000f\tM\u0004\u00031\u0001\u0003l\u0005\tb/\u001a:tS>t\u0017\n\u001a+p+B$\u0017\r^3")
public class DBProcessRepository
implements ProcessRepository<DBIOAction>,
LazyLogging,
CommentActions,
ProcessDBQueryRepository<DBIOAction> {
    private final DbConfig dbConfig;
    private final ProcessingTypeDataProvider<Object> modelVersion;
    private JdbcProfile profile;
    private JdbcProfile.API api;
    private transient Logger logger;
    private final TableQuery<AttachmentEntityFactory.AttachmentEntity> attachmentsTable;
    private final TableQuery<TagsEntityFactory.TagsEntity> tagsTable;
    private final TableQuery<ProcessActionEntityFactory.ProcessActionEntity> processActionsTable;
    private final TableQuery<EnvironmentsEntityFactory.EnvironmentsEntity> environmentsTable;
    private final TableQuery<ProcessVersionEntityFactory.ProcessVersionEntity> processVersionsTable;
    private final TableQuery<ProcessVersionEntityFactory.ProcessVersionEntityNoJson> processVersionsTableNoJson;
    private final TableQuery<CommentEntityFactory.CommentEntity> commentsTable;
    private final TableQuery<ProcessEntityFactory.ProcessEntity> processesTable;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    @Override
    public Query<ProcessEntityFactory.ProcessEntity, ProcessEntityData, Seq> processTableFilteredByUser(LoggedUser loggedUser) {
        return ProcessDBQueryRepository.processTableFilteredByUser$(this, loggedUser);
    }

    @Override
    public Query<ProcessVersionEntityFactory.BaseProcessVersionEntity, ProcessVersionEntityData, Seq> fetchProcessLatestVersionsQuery(ProcessId processId, processdetails.ProcessShapeFetchStrategy<?> fetchShape) {
        return ProcessDBQueryRepository.fetchProcessLatestVersionsQuery$(this, processId, fetchShape);
    }

    @Override
    public Query<Tuple2<Rep<ProcessId>, Tuple2<ProcessActionEntityFactory.ProcessActionEntity, Rep<Option<CommentEntityFactory.CommentEntity>>>>, Tuple2<ProcessId, Tuple2<ProcessActionEntityData, Option<CommentEntityData>>>, Seq> fetchLastDeployedActionPerProcessQuery() {
        return ProcessDBQueryRepository.fetchLastDeployedActionPerProcessQuery$(this);
    }

    @Override
    public Query<Tuple2<Rep<ProcessId>, Tuple2<ProcessActionEntityFactory.ProcessActionEntity, Rep<Option<CommentEntityFactory.CommentEntity>>>>, Tuple2<ProcessId, Tuple2<ProcessActionEntityData, Option<CommentEntityData>>>, Seq> fetchLastActionPerProcessQuery() {
        return ProcessDBQueryRepository.fetchLastActionPerProcessQuery$(this);
    }

    @Override
    public Query<Tuple2<ProcessActionEntityFactory.ProcessActionEntity, Rep<Option<CommentEntityFactory.CommentEntity>>>, Tuple2<ProcessActionEntityData, Option<CommentEntityData>>, Seq> fetchProcessLatestActionsQuery(ProcessId processId) {
        return ProcessDBQueryRepository.fetchProcessLatestActionsQuery$(this, processId);
    }

    @Override
    public Query<Tuple2<Tuple2<Tuple2<Rep<ProcessId>, Rep<Option<Timestamp>>>, ProcessVersionEntityFactory.BaseProcessVersionEntity>, ProcessEntityFactory.ProcessEntity>, Tuple2<Tuple2<Tuple2<ProcessId, Option<Timestamp>>, ProcessVersionEntityData>, ProcessEntityData>, Seq> fetchLatestProcessesQuery(Function1<ProcessEntityFactory.ProcessEntity, Rep<Object>> query, Seq<Tuple2<ProcessId, Tuple2<ProcessActionEntityData, Option<CommentEntityData>>>> lastDeployedActionPerProcess, Option<Object> isDeployed, processdetails.ProcessShapeFetchStrategy<?> fetchShape, LoggedUser loggedUser, ExecutionContext ec) {
        return ProcessDBQueryRepository.fetchLatestProcessesQuery$(this, query, lastDeployedActionPerProcess, isDeployed, fetchShape, loggedUser, ec);
    }

    @Override
    public DBIOAction<Map<ProcessId, List<TagsEntityData>>, NoStream, Effect.Read> fetchTagsPerProcess(processdetails.ProcessShapeFetchStrategy<?> fetchShape, ExecutionContext ec) {
        return ProcessDBQueryRepository.fetchTagsPerProcess$(this, fetchShape, ec);
    }

    @Override
    public TableQuery<ProcessVersionEntityFactory.BaseProcessVersionEntity> processVersionsTableQuery(processdetails.ProcessShapeFetchStrategy<?> fetchShape) {
        return ProcessDBQueryRepository.processVersionsTableQuery$(this, fetchShape);
    }

    @Override
    public Query<ProcessVersionEntityFactory.BaseProcessVersionEntity, ProcessVersionEntityData, Seq> latestProcessVersionsNoJsonQuery(ProcessName processName) {
        return ProcessDBQueryRepository.latestProcessVersionsNoJsonQuery$(this, processName);
    }

    @Override
    public <T extends JdbcProfile> DBIOAction<Object, NoStream, Effect.All> nextIdAction(T jdbcProfile) {
        return CommentActions.nextIdAction$(this, jdbcProfile);
    }

    @Override
    public DBIOAction<Option<Object>, NoStream, Effect.All> newCommentAction(ProcessId processId, VersionId processVersionId, Comment comment, ExecutionContext ec, LoggedUser loggedUser) {
        return CommentActions.newCommentAction$(this, processId, processVersionId, comment, ec, loggedUser);
    }

    @Override
    public JdbcType<ProcessId> procesIdMapping() {
        return BaseEntityFactory.procesIdMapping$(this);
    }

    @Override
    public JdbcType<VersionId> versionIdMapping() {
        return BaseEntityFactory.versionIdMapping$(this);
    }

    @Override
    public JdbcType<Enumeration.Value> deploymentMapper() {
        return BaseEntityFactory.deploymentMapper$(this);
    }

    private JdbcProfile profile$lzycompute() {
        DBProcessRepository dBProcessRepository = this;
        synchronized (dBProcessRepository) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.profile = Repository.profile$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.profile;
    }

    @Override
    public JdbcProfile profile() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.profile$lzycompute() : this.profile;
    }

    private JdbcProfile.API api$lzycompute() {
        DBProcessRepository dBProcessRepository = this;
        synchronized (dBProcessRepository) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.api = Repository.api$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.api;
    }

    @Override
    public JdbcProfile.API api() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.api$lzycompute() : this.api;
    }

    private Logger logger$lzycompute() {
        DBProcessRepository dBProcessRepository = this;
        synchronized (dBProcessRepository) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public TableQuery<AttachmentEntityFactory.AttachmentEntity> attachmentsTable() {
        return this.attachmentsTable;
    }

    @Override
    public void pl$touk$nussknacker$ui$db$entity$AttachmentEntityFactory$_setter_$attachmentsTable_$eq(TableQuery<AttachmentEntityFactory.AttachmentEntity> x$1) {
        this.attachmentsTable = x$1;
    }

    @Override
    public TableQuery<TagsEntityFactory.TagsEntity> tagsTable() {
        return this.tagsTable;
    }

    @Override
    public void pl$touk$nussknacker$ui$db$entity$TagsEntityFactory$_setter_$tagsTable_$eq(TableQuery<TagsEntityFactory.TagsEntity> x$1) {
        this.tagsTable = x$1;
    }

    @Override
    public TableQuery<ProcessActionEntityFactory.ProcessActionEntity> processActionsTable() {
        return this.processActionsTable;
    }

    @Override
    public void pl$touk$nussknacker$ui$db$entity$ProcessActionEntityFactory$_setter_$processActionsTable_$eq(TableQuery<ProcessActionEntityFactory.ProcessActionEntity> x$1) {
        this.processActionsTable = x$1;
    }

    @Override
    public TableQuery<EnvironmentsEntityFactory.EnvironmentsEntity> environmentsTable() {
        return this.environmentsTable;
    }

    @Override
    public void pl$touk$nussknacker$ui$db$entity$EnvironmentsEntityFactory$_setter_$environmentsTable_$eq(TableQuery<EnvironmentsEntityFactory.EnvironmentsEntity> x$1) {
        this.environmentsTable = x$1;
    }

    @Override
    public TableQuery<ProcessVersionEntityFactory.ProcessVersionEntity> processVersionsTable() {
        return this.processVersionsTable;
    }

    @Override
    public TableQuery<ProcessVersionEntityFactory.ProcessVersionEntityNoJson> processVersionsTableNoJson() {
        return this.processVersionsTableNoJson;
    }

    @Override
    public void pl$touk$nussknacker$ui$db$entity$ProcessVersionEntityFactory$_setter_$processVersionsTable_$eq(TableQuery<ProcessVersionEntityFactory.ProcessVersionEntity> x$1) {
        this.processVersionsTable = x$1;
    }

    @Override
    public void pl$touk$nussknacker$ui$db$entity$ProcessVersionEntityFactory$_setter_$processVersionsTableNoJson_$eq(TableQuery<ProcessVersionEntityFactory.ProcessVersionEntityNoJson> x$1) {
        this.processVersionsTableNoJson = x$1;
    }

    @Override
    public TableQuery<CommentEntityFactory.CommentEntity> commentsTable() {
        return this.commentsTable;
    }

    @Override
    public void pl$touk$nussknacker$ui$db$entity$CommentEntityFactory$_setter_$commentsTable_$eq(TableQuery<CommentEntityFactory.CommentEntity> x$1) {
        this.commentsTable = x$1;
    }

    @Override
    public TableQuery<ProcessEntityFactory.ProcessEntity> processesTable() {
        return this.processesTable;
    }

    @Override
    public void pl$touk$nussknacker$ui$db$entity$ProcessEntityFactory$_setter_$processesTable_$eq(TableQuery<ProcessEntityFactory.ProcessEntity> x$1) {
        this.processesTable = x$1;
    }

    @Override
    public DbConfig dbConfig() {
        return this.dbConfig;
    }

    public ProcessingTypeDataProvider<Object> modelVersion() {
        return this.modelVersion;
    }

    @Override
    public <R> Function1<DBIOAction<R, NoStream, Effect.All>, DBIOAction<R, NoStream, Effect.All>> run() {
        return (Function1 & Serializable & scala.Serializable)x -> (DBIOAction)Predef$.MODULE$.identity(x);
    }

    @Override
    public DBIOAction<Either<EspError, Option<ProcessRepository.ProcessCreated>>, NoStream, Effect.All> saveNewProcess(ProcessRepository.CreateProcessAction action, LoggedUser loggedUser) {
        ProcessId x$1 = new ProcessId(-1L);
        String x$22 = action.processName().value();
        String x$32 = action.category();
        None$ x$4 = None$.MODULE$;
        String x$5 = action.processingType();
        boolean x$6 = action.isSubprocess();
        boolean x$7 = false;
        Timestamp x$8 = Timestamp.from(this.now());
        String x$9 = loggedUser.username();
        ProcessEntityData processToSave = new ProcessEntityData(x$1, x$22, (Option<String>)x$4, x$32, x$5, x$6, x$7, x$8, x$9);
        JdbcActionComponent.IntoInsertActionComposer insertNew = ((JdbcActionComponent.CountingInsertActionComposer)this.profile().api().queryInsertActionExtensionMethods(this.processesTable())).returning(this.processesTable().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.id(), Shape$.MODULE$.repColumnShape(this.procesIdMapping()))).into((Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ProcessEntityData entity = (ProcessEntityData)tuple2._1();
            ProcessId newId = (ProcessId)tuple2._2();
            ProcessEntityData processEntityData = entity.copy(newId, entity.copy$default$2(), entity.copy$default$3(), entity.copy$default$4(), entity.copy$default$5(), entity.copy$default$6(), entity.copy$default$7(), entity.copy$default$8(), entity.copy$default$9());
            return processEntityData;
        });
        DBIOAction insertAction = this.logDebug(new StringBuilder(25).append("Saving scenario ").append(action.processName().value()).append(" by user ").append(loggedUser).toString()).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> ((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.profile().api().streamableQueryActionExtensionMethods(this.latestProcessVersionsNoJsonQuery(action.processName()))).result().headOption().flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            DBIOAction dBIOAction;
            Option option = x0$2;
            if (option instanceof Some) {
                dBIOAction = DBIOAction$.MODULE$.successful((Object)EitherIdOps$.MODULE$.asLeft$extension(package.either$.MODULE$.catsSyntaxEitherId((Object)new ProcessDBQueryRepository.ProcessAlreadyExists(action.processName().value()))));
            } else if (None$.MODULE$.equals(option)) {
                dBIOAction = ((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.profile().api().streamableQueryActionExtensionMethods(this.processesTable().filter((Function1 & Serializable & scala.Serializable)x$4 -> new BaseColumnExtensionMethods(this.profile().api().columnExtensionMethods(x$4.name(), (BaseTypedType)this.profile().api().stringColumnType())).$eq$eq$eq((Rep)this.profile().api().valueToConstColumn((Object)action.processName().value(), (TypedType)this.profile().api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)this.profile().api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()))).result().headOption().flatMap((Function1 & Serializable & scala.Serializable)x0$3 -> {
                    DBIOAction dBIOAction;
                    Option option = x0$3;
                    if (option instanceof Some) {
                        dBIOAction = DBIOAction$.MODULE$.successful((Object)EitherIdOps$.MODULE$.asLeft$extension(package.either$.MODULE$.catsSyntaxEitherId((Object)new ProcessDBQueryRepository.ProcessAlreadyExists(action.processName().value()))));
                    } else if (None$.MODULE$.equals(option)) {
                        dBIOAction = insertNew.$plus$eq((Object)processToSave).flatMap((Function1 & Serializable & scala.Serializable)entity -> this.updateProcessInternal(entity.id(), action.canonicalProcess(), false, loggedUser), ExecutionContext.Implicits$.MODULE$.global()).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.right().map((Function1 & Serializable & scala.Serializable)res -> res.newVersion().map((Function1 & Serializable & scala.Serializable)x$6 -> new ProcessRepository.ProcessCreated(res.processId(), (VersionId)x$6))), ExecutionContext.Implicits$.MODULE$.global());
                    } else {
                        throw new MatchError((Object)option);
                    }
                    return dBIOAction;
                }, ExecutionContext.Implicits$.MODULE$.global());
            } else {
                throw new MatchError((Object)option);
            }
            return dBIOAction;
        }, ExecutionContext.Implicits$.MODULE$.global()), ExecutionContext.Implicits$.MODULE$.global());
        return insertAction;
    }

    @Override
    public DBIOAction<Either<EspError, ProcessRepository.ProcessUpdated>, NoStream, Effect.All> updateProcess(ProcessRepository.UpdateProcessAction updateProcessAction, LoggedUser loggedUser) {
        return this.updateProcessInternal(updateProcessAction.id(), updateProcessAction.canonicalProcess(), updateProcessAction.increaseVersionWhenJsonNotChanged(), loggedUser).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            boolean bl = false;
            ObjectRef objectRef = ObjectRef.create(null);
            Either either = x0$1;
            if (either instanceof Right) {
                bl = true;
                objectRef.elem = (Right)either;
                ProcessRepository.ProcessUpdated processUpdated = (ProcessRepository.ProcessUpdated)((Right)objectRef.elem).value();
                if (processUpdated != null) {
                    ProcessId processId = processUpdated.processId();
                    Option<VersionId> option = processUpdated.newVersion();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        VersionId newVersion = (VersionId)some.value();
                        return this.addNewCommentToVersion$1(processId, newVersion, updateProcessAction, loggedUser).map((Function1 & Serializable & scala.Serializable)x$7 -> (Right)x2$1.elem, ExecutionContext.Implicits$.MODULE$.global());
                    }
                }
            }
            if (!bl) return this.profile().api().DBIO().successful((Object)either);
            ProcessRepository.ProcessUpdated processUpdated = (ProcessRepository.ProcessUpdated)((Right)objectRef.elem).value();
            if (processUpdated == null) return this.profile().api().DBIO().successful((Object)either);
            ProcessId processId = processUpdated.processId();
            Option<VersionId> option = processUpdated.oldVersion();
            if (!(option instanceof Some)) return this.profile().api().DBIO().successful((Object)either);
            Some some = (Some)option;
            VersionId oldVersion = (VersionId)some.value();
            return this.addNewCommentToVersion$1(processId, oldVersion, updateProcessAction, loggedUser).map((Function1 & Serializable & scala.Serializable)x$8 -> (Right)x2$1.elem, ExecutionContext.Implicits$.MODULE$.global());
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    private DBIOAction<Either<EspError, ProcessRepository.ProcessUpdated>, NoStream, Effect.All> updateProcessInternal(ProcessId processId, CanonicalProcess canonicalProcess, boolean increaseVersionWhenJsonNotChanged, LoggedUser loggedUser) {
        EitherT insertAction = DBProcessRepository.rightT$1(this.logDebug(new StringBuilder(27).append("Updating scenario ").append(processId).append(" by user ").append(loggedUser).toString())).flatMap((Function1 & Serializable & scala.Serializable)_ -> DBProcessRepository.rightT$1((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.profile().api().streamableQueryActionExtensionMethods(this.processTableFilteredByUser(loggedUser).filter((Function1 & Serializable & scala.Serializable)x$10 -> new BaseColumnExtensionMethods(this.profile().api().columnExtensionMethods(x$10.id(), this.procesIdMapping())).$eq$eq$eq((Rep)this.profile().api().valueToConstColumn((Object)processId, this.procesIdMapping()), OptionMapper2$.MODULE$.getOptionMapper2TT(this.procesIdMapping())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()))).result().headOption()).flatMap((Function1 & Serializable & scala.Serializable)maybeProcess -> EitherT.FromEitherPartiallyApplied$.MODULE$.apply$extension(EitherT$.MODULE$.fromEither(), EitherObjectOps$.MODULE$.fromOption$extension(package.either$.MODULE$.catsSyntaxEitherObject(package$.MODULE$.Either()), maybeProcess, (Function0 & Serializable & scala.Serializable)() -> new ProcessDBQueryRepository.ProcessNotFoundError(((Object)BoxesRunTime.boxToLong((long)processId.value())).toString())), DBIOActionInstances$.MODULE$.dbMonad(ExecutionContext.Implicits$.MODULE$.global())).flatMap((Function1 & Serializable & scala.Serializable)process -> DBProcessRepository.rightT$1((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.profile().api().streamableQueryActionExtensionMethods(this.fetchProcessLatestVersionsQuery(processId, (processdetails.ProcessShapeFetchStrategy<?>)processdetails.ProcessShapeFetchStrategy$.FetchDisplayable$.MODULE$))).result().headOption()).flatMap((Function1 & Serializable & scala.Serializable)latestProcessVersion -> EitherT.FromEitherPartiallyApplied$.MODULE$.apply$extension(EitherT$.MODULE$.fromEither(), (Either)this.versionToInsert$1((Option)latestProcessVersion, process.processingType(), increaseVersionWhenJsonNotChanged, canonicalProcess, processId, loggedUser), DBIOActionInstances$.MODULE$.dbMonad(ExecutionContext.Implicits$.MODULE$.global())).flatMap((Function1 & Serializable & scala.Serializable)newProcessVersion -> EitherT.RightPartiallyApplied$.MODULE$.apply$extension(EitherT$.MODULE$.right(), newProcessVersion.map((Function1 & Serializable & scala.Serializable)x$11 -> ((JdbcActionComponent.SimpleInsertActionComposer)this.profile().api().queryInsertActionExtensionMethods(this.processVersionsTable())).$plus$eq(x$11)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (DBIOAction)DBIOActionInstances$.MODULE$.dbMonad(ExecutionContext.Implicits$.MODULE$.global()).pure((Object)BoxesRunTime.boxToInteger((int)0))), DBIOActionInstances$.MODULE$.dbMonad(ExecutionContext.Implicits$.MODULE$.global())).map((Function1 & Serializable & scala.Serializable)_ -> DBProcessRepository.$anonfun$updateProcessInternal$11(process, latestProcessVersion, newProcessVersion, BoxesRunTime.unboxToInt((Object)_)), DBIOActionInstances$.MODULE$.dbMonad(ExecutionContext.Implicits$.MODULE$.global())), DBIOActionInstances$.MODULE$.dbMonad(ExecutionContext.Implicits$.MODULE$.global())), DBIOActionInstances$.MODULE$.dbMonad(ExecutionContext.Implicits$.MODULE$.global())), DBIOActionInstances$.MODULE$.dbMonad(ExecutionContext.Implicits$.MODULE$.global())), DBIOActionInstances$.MODULE$.dbMonad(ExecutionContext.Implicits$.MODULE$.global())), DBIOActionInstances$.MODULE$.dbMonad(ExecutionContext.Implicits$.MODULE$.global()));
        return (DBIOAction)insertAction.value();
    }

    private DBIOAction<BoxedUnit, NoStream, Effect.All> logDebug(String s) {
        return ((DBIOAction)DBIOActionInstances$.MODULE$.dbMonad(ExecutionContext.Implicits$.MODULE$.global()).pure((Object)BoxedUnit.UNIT)).map((Function1 & Serializable & scala.Serializable)x$14 -> {
            DBProcessRepository.$anonfun$logDebug$1(this, s, x$14);
            return BoxedUnit.UNIT;
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    @Override
    public DBIOAction<Either<EspError, BoxedUnit>, NoStream, Effect.All> deleteProcess(ProcessId processId) {
        return this.profile().api().queryDeleteActionExtensionMethods(this.processesTable().filter((Function1 & Serializable & scala.Serializable)x$15 -> new BaseColumnExtensionMethods(this.profile().api().columnExtensionMethods(x$15.id(), this.procesIdMapping())).$eq$eq$eq((Rep)this.profile().api().valueToConstColumn((Object)processId, this.procesIdMapping()), OptionMapper2$.MODULE$.getOptionMapper2TT(this.procesIdMapping())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition())).delete().map((Function1 & Serializable & scala.Serializable)x0$1 -> DBProcessRepository.$anonfun$deleteProcess$2(processId, BoxesRunTime.unboxToInt((Object)x0$1)), ExecutionContext.Implicits$.MODULE$.global());
    }

    @Override
    public DBIOAction<Either<EspError, BoxedUnit>, NoStream, Effect.All> archive(ProcessId processId, boolean isArchived) {
        return this.profile().api().queryUpdateActionExtensionMethods(this.processesTable().filter((Function1 & Serializable & scala.Serializable)x$16 -> new BaseColumnExtensionMethods(this.profile().api().columnExtensionMethods(x$16.id(), this.procesIdMapping())).$eq$eq$eq((Rep)this.profile().api().valueToConstColumn((Object)processId, this.procesIdMapping()), OptionMapper2$.MODULE$.getOptionMapper2TT(this.procesIdMapping())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.isArchived(), Shape$.MODULE$.repColumnShape((BaseTypedType)this.profile().api().booleanColumnType()))).update((Object)BoxesRunTime.boxToBoolean((boolean)isArchived)).map((Function1 & Serializable & scala.Serializable)x0$1 -> DBProcessRepository.$anonfun$archive$3(processId, BoxesRunTime.unboxToInt((Object)x0$1)), ExecutionContext.Implicits$.MODULE$.global());
    }

    @Override
    public DBIOAction<Either<EspError, BoxedUnit>, NoStream, Effect.All> updateCategory(ProcessId processId, String category, LoggedUser loggedUser) {
        return this.profile().api().queryUpdateActionExtensionMethods(this.processesTable().filter((Function1 & Serializable & scala.Serializable)x$18 -> new BaseColumnExtensionMethods(this.profile().api().columnExtensionMethods(x$18.id(), this.procesIdMapping())).$eq$eq$eq((Rep)this.profile().api().valueToConstColumn((Object)processId, this.procesIdMapping()), OptionMapper2$.MODULE$.getOptionMapper2TT(this.procesIdMapping())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).map((Function1 & Serializable & scala.Serializable)x$19 -> x$19.processCategory(), Shape$.MODULE$.repColumnShape((BaseTypedType)this.profile().api().stringColumnType()))).update((Object)category).map((Function1 & Serializable & scala.Serializable)x0$1 -> DBProcessRepository.$anonfun$updateCategory$3(processId, BoxesRunTime.unboxToInt((Object)x0$1)), ExecutionContext.Implicits$.MODULE$.global());
    }

    @Override
    public DBIOAction<Either<EspError, BoxedUnit>, NoStream, Effect.All> renameProcess(ProcessIdWithName process, String newName, LoggedUser loggedUser) {
        DBIOAction updateNameInProcessJson = ((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.profile().api().streamableQueryActionExtensionMethods(this.processVersionsTable().filter((Function1 & Serializable & scala.Serializable)x$20 -> new BaseColumnExtensionMethods(this.profile().api().columnExtensionMethods(x$20.processId(), this.procesIdMapping())).$eq$eq$eq((Rep)this.profile().api().valueToConstColumn((Object)process.id(), this.procesIdMapping()), OptionMapper2$.MODULE$.getOptionMapper2TT(this.procesIdMapping())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).join(this.processesTable()).on((Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ProcessVersionEntityFactory.ProcessVersionEntity version = (ProcessVersionEntityFactory.ProcessVersionEntity)((Object)((Object)tuple2._1()));
            ProcessEntityFactory.ProcessEntity process = (ProcessEntityFactory.ProcessEntity)((Object)((Object)tuple2._2()));
            Rep rep = new BaseColumnExtensionMethods(this.profile().api().columnExtensionMethods(version.processId(), this.procesIdMapping())).$eq$eq$eq(process.id(), OptionMapper2$.MODULE$.getOptionMapper2TT(this.procesIdMapping()));
            return rep;
        }, CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()))).result().flatMap((Function1 & Serializable & scala.Serializable)processVersions -> this.profile().api().DBIO().seq((Seq)processVersions.map(((Function2 & Serializable & scala.Serializable)(Function2 & Serializable & scala.Serializable)(processVersion, process) -> this.updateNameInSingleProcessVersion$1((ProcessVersionEntityData)processVersion, (ProcessEntityData)process, newName)).tupled(), Seq$.MODULE$.canBuildFrom())), ExecutionContext.Implicits$.MODULE$.global());
        FixedSqlAction updateNameInProcess = this.profile().api().queryUpdateActionExtensionMethods(this.processesTable().filter((Function1 & Serializable & scala.Serializable)x$21 -> new BaseColumnExtensionMethods(this.profile().api().columnExtensionMethods(x$21.id(), this.procesIdMapping())).$eq$eq$eq((Rep)this.profile().api().valueToConstColumn((Object)process.id(), this.procesIdMapping()), OptionMapper2$.MODULE$.getOptionMapper2TT(this.procesIdMapping())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).map((Function1 & Serializable & scala.Serializable)x$22 -> x$22.name(), Shape$.MODULE$.repColumnShape((BaseTypedType)this.profile().api().stringColumnType()))).update((Object)newName);
        DBIOAction addCommentAction = ((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.profile().api().streamableQueryActionExtensionMethods(this.processVersionsTable().filter((Function1 & Serializable & scala.Serializable)x$23 -> new BaseColumnExtensionMethods(this.profile().api().columnExtensionMethods(x$23.processId(), this.procesIdMapping())).$eq$eq$eq((Rep)this.profile().api().valueToConstColumn((Object)process.id(), this.procesIdMapping()), OptionMapper2$.MODULE$.getOptionMapper2TT(this.procesIdMapping())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).sortBy((Function1 & Serializable & scala.Serializable)x$24 -> this.profile().api().columnToOrdered(x$24.id(), this.versionIdMapping()).desc(), (Function1)Predef$.MODULE$.$conforms()))).result().headOption().flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            DBIOAction<Option<Object>, NoStream, Effect.All> dBIOAction;
            Option option = x0$2;
            if (option instanceof Some) {
                Some some = (Some)option;
                ProcessVersionEntityData version = (ProcessVersionEntityData)some.value();
                dBIOAction = this.newCommentAction(process.id(), version.id(), new UpdateProcessComment(new StringBuilder(16).append("Rename: [").append(process.name().value()).append("] -> [").append(newName).append("]").toString()), ExecutionContext.Implicits$.MODULE$.global(), loggedUser);
            } else if (None$.MODULE$.equals(option)) {
                dBIOAction = this.profile().api().DBIO().successful((Object)BoxedUnit.UNIT);
            } else {
                throw new MatchError((Object)option);
            }
            return dBIOAction;
        }, ExecutionContext.Implicits$.MODULE$.global());
        DBIOAction action = ((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.profile().api().streamableQueryActionExtensionMethods(this.processesTable().filter((Function1 & Serializable & scala.Serializable)x$25 -> new BaseColumnExtensionMethods(this.profile().api().columnExtensionMethods(x$25.name(), (BaseTypedType)this.profile().api().stringColumnType())).$eq$eq$eq((Rep)this.profile().api().valueToConstColumn((Object)newName, (TypedType)this.profile().api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)this.profile().api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()))).result().headOption().flatMap((Function1 & Serializable & scala.Serializable)x0$3 -> {
            DBIOAction dBIOAction;
            Option option = x0$3;
            if (option instanceof Some) {
                dBIOAction = this.profile().api().DBIO().successful((Object)EitherIdOps$.MODULE$.asLeft$extension(package.either$.MODULE$.catsSyntaxEitherId((Object)new ProcessDBQueryRepository.ProcessAlreadyExists(newName))));
            } else if (None$.MODULE$.equals(option)) {
                dBIOAction = this.profile().api().jdbcActionExtensionMethods(this.profile().api().DBIO().seq((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DBIOAction[]{updateNameInProcess, updateNameInProcessJson, addCommentAction})).map((Function1 & Serializable & scala.Serializable)x$26 -> EitherIdOps$.MODULE$.asRight$extension(package.either$.MODULE$.catsSyntaxEitherId((Object)BoxedUnit.UNIT)), ExecutionContext.Implicits$.MODULE$.global())).transactionally();
            } else {
                throw new MatchError((Object)option);
            }
            return dBIOAction;
        }, ExecutionContext.Implicits$.MODULE$.global());
        return action;
    }

    public Instant now() {
        return Instant.now();
    }

    public FixedSqlAction<Object, NoStream, Effect.Write> changeVersionId(ProcessId processId, VersionId versionId, VersionId versionIdToUpdate) {
        return this.profile().api().queryUpdateActionExtensionMethods(this.processVersionsTableNoJson().filter((Function1 & Serializable & scala.Serializable)v -> BooleanColumnExtensionMethods$.MODULE$.$amp$amp$extension(this.profile().api().booleanColumnExtensionMethods(new BaseColumnExtensionMethods(this.profile().api().columnExtensionMethods(v.id(), this.versionIdMapping())).$eq$eq$eq((Rep)this.profile().api().valueToConstColumn((Object)versionId, this.versionIdMapping()), OptionMapper2$.MODULE$.getOptionMapper2TT(this.versionIdMapping()))), new BaseColumnExtensionMethods(this.profile().api().columnExtensionMethods(v.processId(), this.procesIdMapping())).$eq$eq$eq((Rep)this.profile().api().valueToConstColumn((Object)processId, this.procesIdMapping()), OptionMapper2$.MODULE$.getOptionMapper2TT(this.procesIdMapping())), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)this.profile().api().booleanColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).map((Function1 & Serializable & scala.Serializable)x$27 -> x$27.id(), Shape$.MODULE$.repColumnShape(this.versionIdMapping()))).update((Object)versionIdToUpdate);
    }

    private final DBIOAction addNewCommentToVersion$1(ProcessId processId, VersionId versionId, ProcessRepository.UpdateProcessAction updateProcessAction$1, LoggedUser loggedUser$2) {
        return this.newCommentAction(processId, versionId, updateProcessAction$1.comment(), ExecutionContext.Implicits$.MODULE$.global(), loggedUser$2);
    }

    private final ProcessVersionEntityData createProcessVersionEntityData$1(VersionId version, String processingType, ProcessId processId$1, CanonicalProcess canonicalProcess$1, LoggedUser loggedUser$3) {
        return new ProcessVersionEntityData(version, processId$1, (Option<CanonicalProcess>)new Some((Object)canonicalProcess$1), Timestamp.from(this.now()), loggedUser$3.username(), this.modelVersion().forType(processingType));
    }

    private static final boolean isLastVersionContainsSameProcess$1(ProcessVersionEntityData lastVersion, CanonicalProcess canonicalProcess$1) {
        return lastVersion.json().contains((Object)canonicalProcess$1);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Right versionToInsert$1(Option latestProcessVersion, String processingType, boolean increaseVersionWhenJsonNotChanged$1, CanonicalProcess canonicalProcess$1, ProcessId processId$1, LoggedUser loggedUser$3) {
        Some some;
        Right$ right$ = package$.MODULE$.Right();
        boolean bl = false;
        Some some2 = null;
        Option option = latestProcessVersion;
        if (option instanceof Some) {
            bl = true;
            some2 = (Some)option;
            ProcessVersionEntityData version = (ProcessVersionEntityData)some2.value();
            if (DBProcessRepository.isLastVersionContainsSameProcess$1(version, canonicalProcess$1) && !increaseVersionWhenJsonNotChanged$1) {
                some = None$.MODULE$;
                return right$.apply((Object)some);
            }
        }
        if (bl) {
            ProcessVersionEntityData version = (ProcessVersionEntityData)some2.value();
            some = new Some((Object)this.createProcessVersionEntityData$1(version.id().increase(), processingType, processId$1, canonicalProcess$1, loggedUser$3));
            return right$.apply((Object)some);
        }
        some = new Some((Object)this.createProcessVersionEntityData$1(VersionId$.MODULE$.initialVersionId(), processingType, processId$1, canonicalProcess$1, loggedUser$3));
        return right$.apply((Object)some);
    }

    private static final EitherT rightT$1(DBIOAction value) {
        return new EitherT((Object)value.map((Function1 & Serializable & scala.Serializable)x$9 -> package$.MODULE$.Right().apply(x$9), ExecutionContext.Implicits$.MODULE$.global()));
    }

    public static final /* synthetic */ ProcessRepository.ProcessUpdated $anonfun$updateProcessInternal$11(ProcessEntityData process$1, Option latestProcessVersion$1, Option newProcessVersion$1, int _) {
        return new ProcessRepository.ProcessUpdated(process$1.id(), (Option<VersionId>)latestProcessVersion$1.map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.id()), (Option<VersionId>)newProcessVersion$1.map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.id()));
    }

    public static final /* synthetic */ void $anonfun$logDebug$1(DBProcessRepository $this, String s$1, BoxedUnit x$14) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug(s$1);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ Either $anonfun$deleteProcess$2(ProcessId processId$2, int x0$1) {
        Right right;
        int n = x0$1;
        switch (n) {
            case 0: {
                right = package$.MODULE$.Left().apply((Object)new ProcessDBQueryRepository.ProcessNotFoundError(((Object)BoxesRunTime.boxToLong((long)processId$2.value())).toString()));
                break;
            }
            case 1: {
                right = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        return right;
    }

    public static final /* synthetic */ Either $anonfun$archive$3(ProcessId processId$3, int x0$1) {
        Right right;
        int n = x0$1;
        switch (n) {
            case 0: {
                right = package$.MODULE$.Left().apply((Object)new ProcessDBQueryRepository.ProcessNotFoundError(((Object)BoxesRunTime.boxToLong((long)processId$3.value())).toString()));
                break;
            }
            case 1: {
                right = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        return right;
    }

    public static final /* synthetic */ Either $anonfun$updateCategory$3(ProcessId processId$4, int x0$1) {
        Right right;
        int n = x0$1;
        switch (n) {
            case 0: {
                right = package$.MODULE$.Left().apply((Object)new ProcessDBQueryRepository.ProcessNotFoundError(((Object)BoxesRunTime.boxToLong((long)processId$4.value())).toString()));
                break;
            }
            case 1: {
                right = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        return right;
    }

    private final DBIOAction updateNameInSingleProcessVersion$1(ProcessVersionEntityData processVersion, ProcessEntityData process, String newName$1) {
        DBIOAction dBIOAction;
        Option<CanonicalProcess> option = processVersion.json();
        if (option instanceof Some) {
            Some some = (Some)option;
            CanonicalProcess json = (CanonicalProcess)some.value();
            CanonicalProcess updatedProcess = json.copy(json.metaData().copy(newName$1, json.metaData().copy$default$2(), json.metaData().copy$default$3(), json.metaData().copy$default$4()), json.copy$default$2(), json.copy$default$3());
            Some x$1 = new Some((Object)updatedProcess);
            VersionId x$2 = processVersion.copy$default$1();
            ProcessId x$3 = processVersion.copy$default$2();
            Timestamp x$4 = processVersion.copy$default$4();
            String x$5 = processVersion.copy$default$5();
            Option<Object> x$6 = processVersion.copy$default$6();
            ProcessVersionEntityData updatedProcessVersion = processVersion.copy(x$2, x$3, (Option<CanonicalProcess>)x$1, x$4, x$5, x$6);
            dBIOAction = this.profile().api().queryUpdateActionExtensionMethods(this.processVersionsTable().filter((Function1 & Serializable & scala.Serializable)version -> BooleanColumnExtensionMethods$.MODULE$.$amp$amp$extension(this.profile().api().booleanColumnExtensionMethods(new BaseColumnExtensionMethods(this.profile().api().columnExtensionMethods(version.id(), this.versionIdMapping())).$eq$eq$eq((Rep)this.profile().api().valueToConstColumn((Object)processVersion.id(), this.versionIdMapping()), OptionMapper2$.MODULE$.getOptionMapper2TT(this.versionIdMapping()))), new BaseColumnExtensionMethods(this.profile().api().columnExtensionMethods(version.processId(), this.procesIdMapping())).$eq$eq$eq((Rep)this.profile().api().valueToConstColumn((Object)process.id(), this.procesIdMapping()), OptionMapper2$.MODULE$.getOptionMapper2TT(this.procesIdMapping())), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)this.profile().api().booleanColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition())).update((Object)updatedProcessVersion);
        } else if (None$.MODULE$.equals(option)) {
            dBIOAction = this.profile().api().DBIO().successful((Object)BoxedUnit.UNIT);
        } else {
            throw new MatchError(option);
        }
        return dBIOAction;
    }

    public DBProcessRepository(DbConfig dbConfig, ProcessingTypeDataProvider<Object> modelVersion) {
        this.dbConfig = dbConfig;
        this.modelVersion = modelVersion;
        BaseEntityFactory.$init$(this);
        ProcessEntityFactory.$init$(this);
        CommentEntityFactory.$init$(this);
        ProcessVersionEntityFactory.$init$(this);
        EnvironmentsEntityFactory.$init$(this);
        ProcessActionEntityFactory.$init$(this);
        TagsEntityFactory.$init$(this);
        AttachmentEntityFactory.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        CommentActions.$init$(this);
        Repository.$init$(this);
        ProcessDBQueryRepository.$init$(this);
    }
}

