/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui;

import akka.actor.ActorSystem;
import akka.actor.ActorSystem$;
import akka.actor.ClassicActorSystemProvider;
import akka.http.scaladsl.Http;
import akka.http.scaladsl.Http$;
import akka.http.scaladsl.HttpsConnectionContext;
import akka.http.scaladsl.server.RequestContext;
import akka.http.scaladsl.server.RouteResult;
import akka.stream.Materializer;
import akka.stream.Materializer$;
import com.typesafe.config.Config;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import fr.davit.akka.http.metrics.core.HttpMetrics$;
import fr.davit.akka.http.metrics.core.HttpMetricsHandler;
import fr.davit.akka.http.metrics.core.HttpMetricsRegistry;
import fr.davit.akka.http.metrics.core.HttpMetricsSettings;
import fr.davit.akka.http.metrics.dropwizard.DropwizardRegistry;
import fr.davit.akka.http.metrics.dropwizard.DropwizardSettings$;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.jmx.JmxReporter;
import java.io.Serializable;
import net.ceedubs.ficus.Ficus$;
import pl.touk.nussknacker.engine.util.JavaClassVersionChecker;
import pl.touk.nussknacker.engine.util.SLF4JBridgeHandlerRegistrar$;
import pl.touk.nussknacker.ui.NusskanckerAppRouter;
import pl.touk.nussknacker.ui.config.UiConfigLoader$;
import pl.touk.nussknacker.ui.db.DatabaseInitializer$;
import pl.touk.nussknacker.ui.db.DbConfig;
import pl.touk.nussknacker.ui.security.ssl.HttpsConnectionContextFactory$;
import pl.touk.nussknacker.ui.security.ssl.KeyStoreConfig;
import pl.touk.nussknacker.ui.security.ssl.SslConfigParser$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.StringOps;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.matching.Regex;
import slick.jdbc.HsqldbProfile$;
import slick.jdbc.JdbcBackend;
import slick.jdbc.JdbcBackend$;
import slick.jdbc.JdbcProfile;
import slick.jdbc.PostgresProfile$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ScalaSignature(bytes="\u0006\u0001\t]q!\u0002\u000f\u001e\u0011\u00031c!\u0002\u0015\u001e\u0011\u0003I\u0003BB\"\u0002\t\u0003\u0011)B\u0002\u0003);\u0001Y\u0003\u0002\u0003\u001f\u0004\u0005\u0003\u0005\u000b\u0011B\u001f\t\u000b\r\u001bA\u0011\u0001#\t\u000f\u0001\u001b!\u0019!C\t\r\"1qi\u0001Q\u0001\nuBq\u0001S\u0002C\u0002\u0013M\u0011\n\u0003\u0004S\u0007\u0001\u0006IA\u0013\u0005\b'\u000e\u0011\r\u0011b\u0005U\u0011\u0019Y6\u0001)A\u0005+\"9Al\u0001b\u0001\n\u0003i\u0006BB5\u0004A\u0003%a\fC\u0004k\u0007\t\u0007I\u0011A6\t\r=\u001c\u0001\u0015!\u0003m\u0011\u0015\u00018\u0001\"\u0001r\u0011\u001d\tyd\u0001C\u0001\u0003\u0003Bq!!\"\u0004\t\u0003\t9\tC\u0004\u0002\"\u000e!I!a)\t\u000f\u0005\r7\u0001\"\u0001\u0002F\"9\u0011Q[\u0002\u0005\n\u0005]\u0007bBAv\u0007\u0011%\u0011Q\u001e\u0004\u0007\u0003s\u001c\u0001!a?\t\u0015\u0005]xC!A!\u0002\u0013\t)\u0002\u0003\u0004D/\u0011\u0005!1\u0001\u0005\b\u0005\u00179B\u0011\tB\u0007\u0011\u001d\u0011ya\u0001C\u0005\u0005#\t\u0011DT;tg.t\u0017mY6fe\u0006\u0003\b/\u00138ji&\fG.\u001b>fe*\u0011adH\u0001\u0003k&T!\u0001I\u0011\u0002\u00179,8o]6oC\u000e\\WM\u001d\u0006\u0003E\r\nA\u0001^8vW*\tA%\u0001\u0002qY\u000e\u0001\u0001CA\u0014\u0002\u001b\u0005i\"!\u0007(vgN\\g.Y2lKJ\f\u0005\u000f]%oSRL\u0017\r\\5{KJ\u001c\"!\u0001\u0016\u0011\u0005\u001d\u001a1cA\u0002-eA\u0011Q\u0006M\u0007\u0002])\tq&A\u0003tG\u0006d\u0017-\u0003\u00022]\t1\u0011I\\=SK\u001a\u0004\"a\r\u001e\u000e\u0003QR!!\u000e\u001c\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005]B\u0014\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003e\n1aY8n\u0013\tYDGA\u0006MCjLHj\\4hS:<\u0017\u0001\u00062bg\u0016,fN]3t_24X\rZ\"p]\u001aLw\r\u0005\u0002?\u00036\tqH\u0003\u0002Am\u000511m\u001c8gS\u001eL!AQ \u0003\r\r{gNZ5h\u0003\u0019a\u0014N\\5u}Q\u0011!&\u0012\u0005\u0006y\u0015\u0001\r!P\u000b\u0002{\u000591m\u001c8gS\u001e\u0004\u0013AB:zgR,W.F\u0001K!\tY\u0005+D\u0001M\u0015\tie*A\u0003bGR|'OC\u0001P\u0003\u0011\t7n[1\n\u0005Ec%aC!di>\u00148+_:uK6\fqa]=ti\u0016l\u0007%\u0001\u0007nCR,'/[1mSj,'/F\u0001V!\t1\u0016,D\u0001X\u0015\tAf*\u0001\u0004tiJ,\u0017-\\\u0005\u00035^\u0013A\"T1uKJL\u0017\r\\5{KJ\fQ\"\\1uKJL\u0017\r\\5{KJ\u0004\u0013!C5oi\u0016\u0014h-Y2f+\u0005q\u0006CA0g\u001d\t\u0001G\r\u0005\u0002b]5\t!M\u0003\u0002dK\u00051AH]8pizJ!!\u001a\u0018\u0002\rA\u0013X\rZ3g\u0013\t9\u0007N\u0001\u0004TiJLgn\u001a\u0006\u0003K:\n!\"\u001b8uKJ4\u0017mY3!\u0003\u0011\u0001xN\u001d;\u0016\u00031\u0004\"!L7\n\u00059t#aA%oi\u0006)\u0001o\u001c:uA\u0005!\u0011N\\5u)\r\u0011\u0018Q\u0007\t\u0006[M,\u0018QC\u0005\u0003i:\u0012a\u0001V;qY\u0016\u0014\u0004c\u0001<\u0002\u00109\u0019q/!\u0003\u000f\u0007a\f\u0019A\u0004\u0002z}:\u0011!\u0010 \b\u0003CnL\u0011aT\u0005\u0003{:\u000bA\u0001\u001b;ua&\u0019q0!\u0001\u0002\u0011M\u001c\u0017\r\\1eg2T!! (\n\t\u0005\u0015\u0011qA\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0007}\f\t!\u0003\u0003\u0002\f\u00055\u0011a\u00029bG.\fw-\u001a\u0006\u0005\u0003\u000b\t9!\u0003\u0003\u0002\u0012\u0005M!!\u0002*pkR,'\u0002BA\u0006\u0003\u001b\u0001b!a\u0006\u0002 \u0005\u0015b\u0002BA\r\u0003;q1!YA\u000e\u0013\u0005y\u0013bAA\u0006]%!\u0011\u0011EA\u0012\u0005!IE/\u001a:bE2,'bAA\u0006]A!\u0011qEA\u0019\u001b\t\tIC\u0003\u0003\u0002,\u00055\u0012\u0001\u00027b]\u001eT!!a\f\u0002\t)\fg/Y\u0005\u0005\u0003g\tICA\u0007BkR|7\t\\8tK\u0006\u0014G.\u001a\u0005\b\u0003o\u0001\u0002\u0019AA\u001d\u0003\u0019\u0011x.\u001e;feB\u0019q%a\u000f\n\u0007\u0005uRD\u0001\u000bOkN\u001c8.\u00198dW\u0016\u0014\u0018\t\u001d9S_V$XM]\u0001\tE&tG\r\u0013;uaRQ\u00111IA3\u0003O\nI'!\u001c\u0015\r\u0005\u0015\u0013\u0011MA2!\u0019\t9%!\u0014\u0002R5\u0011\u0011\u0011\n\u0006\u0004\u0003\u0017r\u0013AC2p]\u000e,(O]3oi&!\u0011qJA%\u0005\u00191U\u000f^;sKB!\u00111KA.\u001d\u0011\t)&a\u0016\u000e\u0005\u0005\u001d\u0011\u0002BA-\u0003\u000f\tA\u0001\u0013;ua&!\u0011QLA0\u00055\u0019VM\u001d<fe\nKg\u000eZ5oO*!\u0011\u0011LA\u0004\u0011\u0015A\u0015\u0003q\u0001K\u0011\u0015\u0019\u0016\u0003q\u0001V\u0011\u0015a\u0016\u00031\u0001_\u0011\u0015Q\u0017\u00031\u0001m\u0011\u0019\tY'\u0005a\u0001k\u0006)!o\\;uK\"9\u0011qN\tA\u0002\u0005E\u0014aD7fiJL7m\u001d*fO&\u001cHO]=\u0011\t\u0005M\u0014\u0011Q\u0007\u0003\u0003kRA!a\u001e\u0002z\u0005AQ.\u001a;sS\u000e\u001cXG\u0003\u0003\u0002|\u0005u\u0014A\u00033s_B<\u0018N_1sI*\u0011\u0011qP\u0001\u0003S>LA!a!\u0002v\tqQ*\u001a;sS\u000e\u0014VmZ5tiJL\u0018!\u00032j]\u0012DE\u000f\u001e9t)1\tI)a$\u0002\u0012\u0006M\u0015QTAP)\u0019\t)%a#\u0002\u000e\")\u0001J\u0005a\u0002\u0015\")1K\u0005a\u0002+\")AL\u0005a\u0001=\")!N\u0005a\u0001Y\"9\u0011Q\u0013\nA\u0002\u0005]\u0015\u0001\u00045uiB\u001c8i\u001c8uKb$\b\u0003BA+\u00033KA!a'\u0002\b\t1\u0002\n\u001e;qg\u000e{gN\\3di&|gnQ8oi\u0016DH\u000f\u0003\u0004\u0002lI\u0001\r!\u001e\u0005\b\u0003_\u0012\u0002\u0019AA9\u0003e\u0001(/\u001a9be\u0016DE\u000f\u001e9NKR\u0014\u0018n\u0019*fO&\u001cHO]=\u0015\t\u0005\u0015\u0016\u0011\u0019\t\u0005\u0003O\u000bi,\u0004\u0002\u0002**!\u00111VAW\u0003\u0011\u0019wN]3\u000b\t\u0005=\u0016\u0011W\u0001\b[\u0016$(/[2t\u0015\ri\u00181\u0017\u0006\u0004\u001f\u0006U&\u0002BA\\\u0003s\u000bQ\u0001Z1wSRT!!a/\u0002\u0005\u0019\u0014\u0018\u0002BA`\u0003S\u00131\u0003\u0013;ua6+GO]5dgJ+w-[:uefDq!a\u001c\u0014\u0001\u0004\t\t(\u0001\u0004j]&$HI\u0019\u000b\u0005\u0003\u000f\f\u0019\u000e\u0005\u0003\u0002J\u0006=WBAAf\u0015\r\ti-H\u0001\u0003I\nLA!!5\u0002L\nAAIY\"p]\u001aLw\rC\u0003A)\u0001\u0007Q(A\bdQ>|7/\u001a#c!J|g-\u001b7f)\u0011\tI.!;\u0011\t\u0005m\u0017Q]\u0007\u0003\u0003;TA!a8\u0002b\u0006!!\u000e\u001a2d\u0015\t\t\u0019/A\u0003tY&\u001c7.\u0003\u0003\u0002h\u0006u'a\u0003&eE\u000e\u0004&o\u001c4jY\u0016DQ\u0001Q\u000bA\u0002u\nq\u0004\u001d:fa\u0006\u0014X-\u00168dCV<\u0007\u000e^#yG\u0016\u0004H/[8o\u0011\u0006tG\r\\3s)\u0011\ty/!>\u0011\u00075\n\t0C\u0002\u0002t:\u0012A!\u00168ji\"9\u0011q\u001f\fA\u0002\u0005U\u0011AD8cU\u0016\u001cGo\u001d+p\u00072|7/\u001a\u0002\u0010'\",H\u000fZ8x]\"\u000bg\u000e\u001a7feN\u0019q#!@\u0011\t\u0005\u001d\u0012q`\u0005\u0005\u0005\u0003\tIC\u0001\u0004UQJ,\u0017\r\u001a\u000b\u0005\u0005\u000b\u0011I\u0001E\u0002\u0003\b]i\u0011a\u0001\u0005\b\u0003oL\u0002\u0019AA\u000b\u0003\r\u0011XO\u001c\u000b\u0003\u0003_\f1c\u00197pg\u0016\fe\u000eZ*ikR$wn\u001e8BY2$B!a<\u0003\u0014!9\u0011q_\u000eA\u0002\u0005UA#\u0001\u0014")
public class NussknackerAppInitializer
implements LazyLogging {
    private final Config config;
    private final ActorSystem system;
    private final Materializer materializer;
    private final String interface;
    private final int port;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        NussknackerAppInitializer nussknackerAppInitializer = this;
        synchronized (nussknackerAppInitializer) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public Config config() {
        return this.config;
    }

    public ActorSystem system() {
        return this.system;
    }

    public Materializer materializer() {
        return this.materializer;
    }

    public String interface() {
        return this.interface;
    }

    public int port() {
        return this.port;
    }

    public Tuple2<Function1<RequestContext, Future<RouteResult>>, Iterable<AutoCloseable>> init(NusskanckerAppRouter router) {
        Future<Http.ServerBinding> future;
        JavaClassVersionChecker.check();
        SLF4JBridgeHandlerRegistrar$.MODULE$.register();
        DbConfig db = this.initDb(this.config());
        MetricRegistry metricsRegistry = new MetricRegistry();
        Tuple2<Function1<RequestContext, Future<RouteResult>>, Iterable<AutoCloseable>> tuple2 = router.create(this.config(), db, metricsRegistry, this.system(), this.materializer());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Function1 route = (Function1)tuple2._1();
        Iterable objectsToClose = (Iterable)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)route, (Object)objectsToClose);
        Tuple2 tuple23 = tuple22;
        Function1 route2 = (Function1)tuple23._1();
        Iterable objectsToClose2 = (Iterable)tuple23._2();
        this.prepareUncaughtExceptionHandler((Iterable<AutoCloseable>)objectsToClose2);
        Runtime.getRuntime().addShutdownHook(new ShutdownHandler(this, (Iterable<AutoCloseable>)objectsToClose2));
        JmxReporter.forRegistry((MetricRegistry)metricsRegistry).build().start();
        Option option = SslConfigParser$.MODULE$.sslEnabled(this.config());
        if (option instanceof Some) {
            Some some = (Some)option;
            KeyStoreConfig keyStoreConfig = (KeyStoreConfig)some.value();
            future = this.bindHttps(this.interface(), this.port(), HttpsConnectionContextFactory$.MODULE$.createServerContext(keyStoreConfig), (Function1<RequestContext, Future<RouteResult>>)route2, metricsRegistry, this.system(), this.materializer());
        } else if (None$.MODULE$.equals(option)) {
            future = this.bindHttp(this.interface(), this.port(), (Function1<RequestContext, Future<RouteResult>>)route2, metricsRegistry, this.system(), this.materializer());
        } else {
            throw new MatchError((Object)option);
        }
        return new Tuple2((Object)route2, (Object)objectsToClose2);
    }

    public Future<Http.ServerBinding> bindHttp(String string, int port, Function1<RequestContext, Future<RouteResult>> route, MetricRegistry metricsRegistry, ActorSystem system, Materializer materializer) {
        return HttpMetrics$.MODULE$.newMeteredServerAt$extension(HttpMetrics$.MODULE$.enrichHttp(Http$.MODULE$.apply((ClassicActorSystemProvider)system)), string, port, (HttpMetricsHandler)this.prepareHttpMetricRegistry(metricsRegistry)).bind(route);
    }

    public Future<Http.ServerBinding> bindHttps(String string, int port, HttpsConnectionContext httpsContext, Function1<RequestContext, Future<RouteResult>> route, MetricRegistry metricsRegistry, ActorSystem system, Materializer materializer) {
        return HttpMetrics$.MODULE$.newMeteredServerAt$extension(HttpMetrics$.MODULE$.enrichHttp(Http$.MODULE$.apply((ClassicActorSystemProvider)system)), string, port, (HttpMetricsHandler)this.prepareHttpMetricRegistry(metricsRegistry)).enableHttps(httpsContext).bind(route);
    }

    private HttpMetricsRegistry prepareHttpMetricRegistry(MetricRegistry metricsRegistry) {
        HttpMetricsSettings settings = DropwizardSettings$.MODULE$.default();
        return new DropwizardRegistry(settings, metricsRegistry);
    }

    public DbConfig initDb(Config config) {
        JdbcBackend.DatabaseDef db = JdbcBackend$.MODULE$.Database().forConfig("db", config, JdbcBackend$.MODULE$.Database().forConfig$default$3(), JdbcBackend$.MODULE$.Database().forConfig$default$4());
        JdbcProfile profile = this.chooseDbProfile(config);
        DbConfig dbConfig = new DbConfig(db, profile);
        DatabaseInitializer$.MODULE$.initDatabase("db", config);
        return dbConfig;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JdbcProfile chooseDbProfile(Config config) {
        String string;
        String string2;
        Option option;
        Regex jdbcUrlPattern = new StringOps(Predef$.MODULE$.augmentString("jdbc:([0-9a-zA-Z]+):.*")).r();
        boolean bl = false;
        Some some = null;
        Option option2 = Ficus$.MODULE$.toFicusConfig(config).getAs("db.url", Ficus$.MODULE$.optionValueReader(Ficus$.MODULE$.stringValueReader()));
        if (option2 instanceof Some) {
            String string3;
            bl = true;
            some = (Some)option2;
            String string4 = (String)some.value();
            Option option3 = jdbcUrlPattern.unapplySeq((CharSequence)string4);
            if (!option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(1) == 0 && "postgresql".equals(string3 = (String)((LinearSeqOptimized)option3.get()).apply(0))) {
                return PostgresProfile$.MODULE$;
            }
        }
        if (bl && !(option = jdbcUrlPattern.unapplySeq((CharSequence)(string2 = (String)some.value()))).isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0 && "hsqldb".equals(string = (String)((LinearSeqOptimized)option.get()).apply(0))) {
            return HsqldbProfile$.MODULE$;
        }
        if (!None$.MODULE$.equals(option2)) throw new MatchError((Object)option2);
        return HsqldbProfile$.MODULE$;
    }

    private void prepareUncaughtExceptionHandler(Iterable<AutoCloseable> objectsToClose) {
        Thread.currentThread().setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(this, objectsToClose){
            private final /* synthetic */ NussknackerAppInitializer $outer;
            private final Iterable objectsToClose$1;

            public void uncaughtException(Thread t, Throwable e) {
                BoxedUnit boxedUnit;
                if (this.$outer.logger().underlying().isErrorEnabled()) {
                    this.$outer.logger().underlying().error("Main thread stopped unexpectedly, terminating ActorSystem", e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                this.$outer.pl$touk$nussknacker$ui$NussknackerAppInitializer$$closeAndShutdownAll((Iterable<AutoCloseable>)this.objectsToClose$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.objectsToClose$1 = objectsToClose$1;
            }
        });
    }

    public void pl$touk$nussknacker$ui$NussknackerAppInitializer$$closeAndShutdownAll(Iterable<AutoCloseable> objectsToClose) {
        objectsToClose.foreach((Function1 & Serializable & scala.Serializable)x$17 -> {
            x$17.close();
            return BoxedUnit.UNIT;
        });
        this.system().terminate();
    }

    public NussknackerAppInitializer(Config baseUnresolvedConfig) {
        LazyLogging.$init$((LazyLogging)this);
        this.config = UiConfigLoader$.MODULE$.load(baseUnresolvedConfig, this.getClass().getClassLoader());
        this.system = ActorSystem$.MODULE$.apply("nussknacker-designer", this.config());
        this.materializer = Materializer$.MODULE$.apply((ClassicActorSystemProvider)this.system());
        this.interface = this.config().getString("http.interface");
        this.port = this.config().getInt("http.port");
    }

    public class ShutdownHandler
    extends Thread {
        private final Iterable<AutoCloseable> objectsToClose;
        public final /* synthetic */ NussknackerAppInitializer $outer;

        @Override
        public void run() {
            BoxedUnit boxedUnit;
            if (this.pl$touk$nussknacker$ui$NussknackerAppInitializer$ShutdownHandler$$$outer().logger().underlying().isInfoEnabled()) {
                this.pl$touk$nussknacker$ui$NussknackerAppInitializer$ShutdownHandler$$$outer().logger().underlying().info("Stopping application");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.pl$touk$nussknacker$ui$NussknackerAppInitializer$ShutdownHandler$$$outer().pl$touk$nussknacker$ui$NussknackerAppInitializer$$closeAndShutdownAll(this.objectsToClose);
        }

        public /* synthetic */ NussknackerAppInitializer pl$touk$nussknacker$ui$NussknackerAppInitializer$ShutdownHandler$$$outer() {
            return this.$outer;
        }

        public ShutdownHandler(NussknackerAppInitializer $outer, Iterable<AutoCloseable> objectsToClose) {
            this.objectsToClose = objectsToClose;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

