/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.process.test;

import akka.actor.ActorRef;
import akka.pattern.AskableActorRef$;
import akka.util.Timeout;
import com.carrotsearch.sizeof.RamUsageEstimator;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import pl.touk.nussknacker.engine.ModelData;
import pl.touk.nussknacker.engine.api.expression.ExpressionTypingInfo;
import pl.touk.nussknacker.engine.api.test.ScenarioTestData;
import pl.touk.nussknacker.engine.canonicalgraph.CanonicalProcess;
import pl.touk.nussknacker.engine.definition.TestInfoProvider;
import pl.touk.nussknacker.engine.definition.TestingCapabilities;
import pl.touk.nussknacker.engine.testmode.TestProcess;
import pl.touk.nussknacker.restmodel.displayedgraph.DisplayableProcess;
import pl.touk.nussknacker.restmodel.process.ProcessIdWithNameAndCategory;
import pl.touk.nussknacker.restmodel.validation.ValidationResults;
import pl.touk.nussknacker.ui.api.TestDataSettings;
import pl.touk.nussknacker.ui.process.deployment.Test;
import pl.touk.nussknacker.ui.process.processingtypedata.ProcessingTypeDataProvider;
import pl.touk.nussknacker.ui.process.test.RawScenarioTestData;
import pl.touk.nussknacker.ui.process.test.ResultsWithCounts;
import pl.touk.nussknacker.ui.process.test.ScenarioTestDataSerDe;
import pl.touk.nussknacker.ui.process.test.ScenarioTestService$;
import pl.touk.nussknacker.ui.processreport.NodeCount;
import pl.touk.nussknacker.ui.processreport.ProcessCounter;
import pl.touk.nussknacker.ui.processreport.RawCount;
import pl.touk.nussknacker.ui.security.api.LoggedUser;
import pl.touk.nussknacker.ui.uiresolving.UIProcessResolving;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0001\t]s!B\u000b\u0017\u0011\u0003\u0019c!B\u0013\u0017\u0011\u00031\u0003\"B\u0017\u0002\t\u0003q\u0003\"B\u0018\u0002\t\u0003\u0001d\u0001B\u0013\u0017\u0001IB\u0001\"\u0010\u0003\u0003\u0002\u0003\u0006IA\u0010\u0005\t\u0019\u0012\u0011\t\u0011)A\u0005\u001b\"A1\u000b\u0002B\u0001B\u0003%A\u000b\u0003\u0005X\t\t\u0005\t\u0015!\u0003Y\u0011!qFA!A!\u0002\u0013y\u0006\u0002C3\u0005\u0005\u0003\u0005\u000b\u0011\u00024\t\u00119$!\u0011!Q\u0001\n=DQ!\f\u0003\u0005\u0002UDq! \u0003C\u0002\u0013-a\u0010\u0003\u0004\u0000\t\u0001\u0006Ia\u001c\u0005\b\u0003\u0003!A\u0011AA\u0002\u0011\u001d\ti\u0003\u0002C\u0001\u0003_Aq!!\u001c\u0005\t\u0003\ty\u0007C\u0004\u0002L\u0012!I!!4\t\u000f\u0005}G\u0001\"\u0003\u0002b\"9!Q\u0004\u0003\u0005\n\t}\u0011aE*dK:\f'/[8UKN$8+\u001a:wS\u000e,'BA\f\u0019\u0003\u0011!Xm\u001d;\u000b\u0005eQ\u0012a\u00029s_\u000e,7o\u001d\u0006\u00037q\t!!^5\u000b\u0005uq\u0012a\u00038vgN\\g.Y2lKJT!a\b\u0011\u0002\tQ|Wo\u001b\u0006\u0002C\u0005\u0011\u0001\u000f\\\u0002\u0001!\t!\u0013!D\u0001\u0017\u0005M\u00196-\u001a8be&|G+Z:u'\u0016\u0014h/[2f'\t\tq\u0005\u0005\u0002)W5\t\u0011FC\u0001+\u0003\u0015\u00198-\u00197b\u0013\ta\u0013F\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\r\nQ!\u00199qYf$R\"\rB \u0005\u001b\u0012yE!\u0015\u0003T\tU\u0003C\u0001\u0013\u0005'\r!qe\r\t\u0003imj\u0011!\u000e\u0006\u0003m]\nAb]2bY\u0006dwnZ4j]\u001eT!\u0001O\u001d\u0002\u0011QL\b/Z:bM\u0016T\u0011AO\u0001\u0004G>l\u0017B\u0001\u001f6\u0005-a\u0015M_=M_\u001e<\u0017N\\4\u0002#Q,7\u000f^%oM>\u0004&o\u001c<jI\u0016\u00148\u000fE\u0002@\u0005\u0012k\u0011\u0001\u0011\u0006\u0003\u0003b\t!\u0003\u001d:pG\u0016\u001c8/\u001b8hif\u0004X\rZ1uC&\u00111\t\u0011\u0002\u001b!J|7-Z:tS:<G+\u001f9f\t\u0006$\u0018\r\u0015:pm&$WM\u001d\t\u0003\u000b*k\u0011A\u0012\u0006\u0003\u000f\"\u000b!\u0002Z3gS:LG/[8o\u0015\tIE$\u0001\u0004f]\u001eLg.Z\u0005\u0003\u0017\u001a\u0013\u0001\u0003V3ti&sgm\u001c)s_ZLG-\u001a:\u0002!Q,7\u000f\u001e#bi\u0006\u001cV\r\u001e;j]\u001e\u001c\bC\u0001(R\u001b\u0005y%B\u0001)\u001b\u0003\r\t\u0007/[\u0005\u0003%>\u0013\u0001\u0003V3ti\u0012\u000bG/Y*fiRLgnZ:\u0002+M\u001cWM\\1sS>$Vm\u001d;ECR\f7+\u001a:EKB\u0011A%V\u0005\u0003-Z\u0011QcU2f]\u0006\u0014\u0018n\u001c+fgR$\u0015\r^1TKJ$U-\u0001\tqe>\u001cWm]:SKN|GN^5oOB\u0011\u0011\fX\u0007\u00025*\u00111LG\u0001\fk&\u0014Xm]8mm&tw-\u0003\u0002^5\n\u0011R+\u0013)s_\u000e,7o\u001d*fg>dg/\u001b8h\u00039\u0001(o\\2fgN\u001cu.\u001e8uKJ\u0004\"\u0001Y2\u000e\u0003\u0005T!A\u0019\u000e\u0002\u001bA\u0014xnY3tgJ,\u0007o\u001c:u\u0013\t!\u0017M\u0001\bQe>\u001cWm]:D_VtG/\u001a:\u0002\u001f5\fg.Y4f[\u0016tG/Q2u_J\u0004\"a\u001a7\u000e\u0003!T!!\u001b6\u0002\u000b\u0005\u001cGo\u001c:\u000b\u0003-\fA!Y6lC&\u0011Q\u000e\u001b\u0002\t\u0003\u000e$xN\u001d*fM\u0006!2/_:uK6\u0014V-];fgR$\u0016.\\3pkR\u0004\"\u0001]:\u000e\u0003ET!A\u001d6\u0002\tU$\u0018\u000e\\\u0005\u0003iF\u0014q\u0001V5nK>,H\u000f\u0006\u00052m^D\u0018P_>}\u0011\u0015iD\u00021\u0001?\u0011\u0015aE\u00021\u0001N\u0011\u0015\u0019F\u00021\u0001U\u0011\u00159F\u00021\u0001Y\u0011\u0015qF\u00021\u0001`\u0011\u0015)G\u00021\u0001g\u0011\u0015qG\u00021\u0001p\u0003\u001d!\u0018.\\3pkR,\u0012a\\\u0001\ti&lWm\\;uA\u00051r-\u001a;UKN$\u0018N\\4DCB\f'-\u001b7ji&,7\u000f\u0006\u0004\u0002\u0006\u0005-\u0011Q\u0004\t\u0004\u000b\u0006\u001d\u0011bAA\u0005\r\n\u0019B+Z:uS:<7)\u00199bE&d\u0017\u000e^5fg\"9\u0011QB\bA\u0002\u0005=\u0011AD5e/&$\bnQ1uK\u001e|'/\u001f\t\u0005\u0003#\tI\"\u0004\u0002\u0002\u0014)\u0019\u0011$!\u0006\u000b\u0007\u0005]A$A\u0005sKN$Xn\u001c3fY&!\u00111DA\n\u0005q\u0001&o\\2fgNLEmV5uQ:\u000bW.Z!oI\u000e\u000bG/Z4pefDq!a\b\u0010\u0001\u0004\t\t#\u0001\neSN\u0004H.Y=bE2,\u0007K]8dKN\u001c\b\u0003BA\u0012\u0003Si!!!\n\u000b\t\u0005\u001d\u0012QC\u0001\u000fI&\u001c\b\u000f\\1zK\u0012<'/\u00199i\u0013\u0011\tY#!\n\u0003%\u0011K7\u000f\u001d7bs\u0006\u0014G.\u001a)s_\u000e,7o]\u0001\rO\u0016tWM]1uK\u0012\u000bG/\u0019\u000b\t\u0003c\ty&!\u0019\u0002dAA\u00111GA\"\u0003\u0013\nIF\u0004\u0003\u00026\u0005}b\u0002BA\u001c\u0003{i!!!\u000f\u000b\u0007\u0005m\"%\u0001\u0004=e>|GOP\u0005\u0002U%\u0019\u0011\u0011I\u0015\u0002\u000fA\f7m[1hK&!\u0011QIA$\u0005\u0019)\u0015\u000e\u001e5fe*\u0019\u0011\u0011I\u0015\u0011\t\u0005-\u00131\u000b\b\u0005\u0003\u001b\ny\u0005E\u0002\u00028%J1!!\u0015*\u0003\u0019\u0001&/\u001a3fM&!\u0011QKA,\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011K\u0015\u0011\u0007\u0011\nY&C\u0002\u0002^Y\u00111CU1x'\u000e,g.\u0019:j_R+7\u000f\u001e#bi\u0006Dq!!\u0004\u0011\u0001\u0004\ty\u0001C\u0004\u0002 A\u0001\r!!\t\t\u000f\u0005\u0015\u0004\u00031\u0001\u0002h\u0005qA/Z:u'\u0006l\u0007\u000f\\3TSj,\u0007c\u0001\u0015\u0002j%\u0019\u00111N\u0015\u0003\u0007%sG/A\u0006qKJ4wN]7UKN$X\u0003BA9\u0003\u0017#\"\"a\u001d\u0002:\u0006m\u0016QXAa)\u0019\t)(!(\u0002(B1\u0011qOA?\u0003\u0003k!!!\u001f\u000b\u0007\u0005m\u0014&\u0001\u0006d_:\u001cWO\u001d:f]RLA!a \u0002z\t1a)\u001e;ve\u0016\u0004R\u0001JAB\u0003\u000fK1!!\"\u0017\u0005E\u0011Vm];miN<\u0016\u000e\u001e5D_VtGo\u001d\t\u0005\u0003\u0013\u000bY\t\u0004\u0001\u0005\u000f\u00055\u0015C1\u0001\u0002\u0010\n\tA+\u0005\u0003\u0002\u0012\u0006]\u0005c\u0001\u0015\u0002\u0014&\u0019\u0011QS\u0015\u0003\u000f9{G\u000f[5oOB\u0019\u0001&!'\n\u0007\u0005m\u0015FA\u0002B]fDq!a(\u0012\u0001\b\t\t+\u0001\u0002fGB!\u0011qOAR\u0013\u0011\t)+!\u001f\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\bbBAU#\u0001\u000f\u00111V\u0001\u0005kN,'\u000f\u0005\u0003\u0002.\u0006UVBAAX\u0015\r\u0001\u0016\u0011\u0017\u0006\u0004\u0003gS\u0012\u0001C:fGV\u0014\u0018\u000e^=\n\t\u0005]\u0016q\u0016\u0002\u000b\u0019><w-\u001a3Vg\u0016\u0014\bbBA\u0007#\u0001\u0007\u0011q\u0002\u0005\b\u0003?\t\u0002\u0019AA\u0011\u0011\u001d\ty,\u0005a\u0001\u00033\n1B]1x)\u0016\u001cH\u000fR1uC\"9\u00111Y\tA\u0002\u0005\u0015\u0017A\u0007;fgR\u0014Vm];miN4\u0016M]5bE2,WI\\2pI\u0016\u0014\bc\u0002\u0015\u0002H\u0006]\u0015qQ\u0005\u0004\u0003\u0013L#!\u0003$v]\u000e$\u0018n\u001c82\u0003I!xnQ1o_:L7-\u00197Qe>\u001cWm]:\u0015\r\u0005=\u00171\\Ao!\u0011\t\t.a6\u000e\u0005\u0005M'bAAk\u0011\u0006q1-\u00198p]&\u001c\u0017\r\\4sCBD\u0017\u0002BAm\u0003'\u0014\u0001cQ1o_:L7-\u00197Qe>\u001cWm]:\t\u000f\u00055!\u00031\u0001\u0002\u0010!9\u0011q\u0004\nA\u0002\u0005\u0005\u0012!H1tg\u0016\u0014H\u000fV3tiJ+7/\u001e7ug\u0006\u0013XMT8u)>|')[4\u0015\t\u0005\r\u00181\u001e\t\u0007\u0003o\ni(!:\u0011\u0007!\n9/C\u0002\u0002j&\u0012A!\u00168ji\"9\u0011Q^\nA\u0002\u0005=\u0018a\u0003;fgR\u0014Vm];miN\u0004D!!=\u0003\u001aA1\u00111\u001fB\t\u0005/qA!!>\u0003\f9!\u0011q\u001fB\u0004\u001d\u0011\tIP!\u0002\u000f\t\u0005m(1\u0001\b\u0005\u0003{\u0014\tA\u0004\u0003\u00028\u0005}\u0018\"A\u0011\n\u0005}\u0001\u0013BA\u000f\u001f\u0013\tIE$C\u0002\u0003\n!\u000b\u0001\u0002^3ti6|G-Z\u0005\u0005\u0005\u001b\u0011y!A\u0006UKN$\bK]8dKN\u001c(b\u0001B\u0005\u0011&!!1\u0003B\u000b\u0005-!Vm\u001d;SKN,H\u000e^:\u000b\t\t5!q\u0002\t\u0005\u0003\u0013\u0013I\u0002\u0002\u0007\u0003\u001c\u0005-\u0018\u0011!A\u0001\u0006\u0003\tyIA\u0002`IE\nQbY8naV$XmQ8v]R\u001cHC\u0002B\u0011\u0005[\u0011\t\u0004\u0005\u0005\u0002L\t\r\u0012\u0011\nB\u0014\u0013\u0011\u0011)#a\u0016\u0003\u00075\u000b\u0007\u000fE\u0002a\u0005SI1Aa\u000bb\u0005%qu\u000eZ3D_VtG\u000fC\u0004\u00030Q\u0001\r!a4\u0002\u0013\r\fgn\u001c8jG\u0006d\u0007b\u0002B\u001a)\u0001\u0007!QG\u0001\be\u0016\u001cX\u000f\u001c;ta\u0011\u00119Da\u000f\u0011\r\u0005M(\u0011\u0003B\u001d!\u0011\tIIa\u000f\u0005\u0019\tu\"\u0011GA\u0001\u0002\u0003\u0015\t!a$\u0003\u0007}##\u0007C\u0004\u0003B\r\u0001\rAa\u0011\u0002\u0013A\u0014xN^5eKJ\u001c\b\u0003B C\u0005\u000b\u0002BAa\u0012\u0003J5\t\u0001*C\u0002\u0003L!\u0013\u0011\"T8eK2$\u0015\r^1\t\u000b1\u001b\u0001\u0019A'\t\u000b]\u001b\u0001\u0019\u0001-\t\u000by\u001b\u0001\u0019A0\t\u000b\u0015\u001c\u0001\u0019\u00014\t\u000b9\u001c\u0001\u0019A8")
public class ScenarioTestService
implements LazyLogging {
    private final ProcessingTypeDataProvider<TestInfoProvider> testInfoProviders;
    private final TestDataSettings testDataSettings;
    private final ScenarioTestDataSerDe scenarioTestDataSerDe;
    private final UIProcessResolving processResolving;
    private final ProcessCounter processCounter;
    private final ActorRef managementActor;
    private final Timeout timeout;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static ScenarioTestService apply(ProcessingTypeDataProvider<ModelData> processingTypeDataProvider, TestDataSettings testDataSettings, UIProcessResolving uIProcessResolving, ProcessCounter processCounter, ActorRef actorRef, Timeout timeout) {
        return ScenarioTestService$.MODULE$.apply(processingTypeDataProvider, testDataSettings, uIProcessResolving, processCounter, actorRef, timeout);
    }

    private Logger logger$lzycompute() {
        ScenarioTestService scenarioTestService = this;
        synchronized (scenarioTestService) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private Timeout timeout() {
        return this.timeout;
    }

    public TestingCapabilities getTestingCapabilities(ProcessIdWithNameAndCategory idWithCategory, DisplayableProcess displayableProcess) {
        TestInfoProvider testInfoProvider = this.testInfoProviders.forTypeUnsafe(displayableProcess.processingType());
        CanonicalProcess canonical = this.toCanonicalProcess(idWithCategory, displayableProcess);
        return testInfoProvider.getTestingCapabilities(canonical);
    }

    public Either<String, RawScenarioTestData> generateData(ProcessIdWithNameAndCategory idWithCategory, DisplayableProcess displayableProcess, int testSampleSize) {
        TestInfoProvider testInfoProvider = this.testInfoProviders.forTypeUnsafe(displayableProcess.processingType());
        CanonicalProcess canonical = this.toCanonicalProcess(idWithCategory, displayableProcess);
        return package$.MODULE$.Either().cond(testSampleSize <= this.testDataSettings.maxSamplesCount(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {}, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Too many samples requested, limit is ").append($this.testDataSettings.maxSamplesCount()).toString()).flatMap((Function1 & Serializable & scala.Serializable)_ -> testInfoProvider.generateTestData(canonical, testSampleSize).toRight((Function0 & Serializable & scala.Serializable)() -> "Test data could not be generated for scenario").flatMap((Function1 & Serializable & scala.Serializable)generatedData -> $this.scenarioTestDataSerDe.serializeTestData((ScenarioTestData)generatedData).map((Function1 & Serializable & scala.Serializable)rawTestData -> rawTestData)));
    }

    public <T> Future<ResultsWithCounts<T>> performTest(ProcessIdWithNameAndCategory idWithCategory, DisplayableProcess displayableProcess, RawScenarioTestData rawTestData, Function1<Object, T> testResultsVariableEncoder, ExecutionContext ec, LoggedUser user) {
        return ((Future)this.scenarioTestDataSerDe.prepareTestData(rawTestData).fold((Function1 & Serializable & scala.Serializable)error -> Future$.MODULE$.failed((Throwable)new IllegalArgumentException((String)error)), (Function1 & Serializable & scala.Serializable)result -> Future$.MODULE$.successful(result))).map((Function1 & Serializable & scala.Serializable)scenarioTestData -> {
            CanonicalProcess canonical = this.toCanonicalProcess(idWithCategory, displayableProcess);
            return new Tuple2(scenarioTestData, (Object)canonical);
        }, ec).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> {
            Tuple2 tuple2 = x$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ScenarioTestData scenarioTestData = (ScenarioTestData)tuple2._1();
            CanonicalProcess canonical = (CanonicalProcess)tuple2._2();
            ActorRef qual$1 = akka.pattern.package$.MODULE$.ask($this.managementActor);
            Test x$1 = new Test(idWithCategory.processIdWithName(), canonical, idWithCategory.category(), scenarioTestData, user, testResultsVariableEncoder);
            Timeout x$22 = this.timeout();
            ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, x$1);
            Future future = AskableActorRef$.MODULE$.$qmark$extension1(qual$1, x$1, x$22, x$3).mapTo(ClassTag$.MODULE$.apply(TestProcess.TestResults.class)).flatMap((Function1 & Serializable & scala.Serializable)testResults -> this.assertTestResultsAreNotTooBig((TestProcess.TestResults<?>)testResults).map((Function1 & Serializable & scala.Serializable)_ -> new ResultsWithCounts(testResults, this.computeCounts(canonical, (TestProcess.TestResults<?>)testResults)), ec), ec);
            return future;
        }, ec);
    }

    private CanonicalProcess toCanonicalProcess(ProcessIdWithNameAndCategory idWithCategory, DisplayableProcess displayableProcess) {
        ValidationResults.ValidationResult validationResult = this.processResolving.validateBeforeUiResolving(displayableProcess, idWithCategory.category());
        return this.processResolving.resolveExpressions(displayableProcess, (Map<String, Map<String, ExpressionTypingInfo>>)validationResult.typingInfo());
    }

    private Future<BoxedUnit> assertTestResultsAreNotTooBig(TestProcess.TestResults<?> testResults) {
        Future future;
        long testDataResultApproxByteSize = RamUsageEstimator.sizeOf(testResults);
        if (testDataResultApproxByteSize > (long)this.testDataSettings.resultsMaxBytes()) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Test data limit exceeded. Approximate test data size: {}, but limit is: {}", new Object[]{BoxesRunTime.boxToLong((long)testDataResultApproxByteSize), BoxesRunTime.boxToInteger((int)this.testDataSettings.resultsMaxBytes())});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            future = Future$.MODULE$.failed((Throwable)new RuntimeException("Too much test data. Please decrease test input data size."));
        } else {
            future = Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
        }
        return future;
    }

    private Map<String, NodeCount> computeCounts(CanonicalProcess canonical, TestProcess.TestResults<?> results) {
        Map counts = (Map)results.nodeResults().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            List nresults = (List)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)new RawCount(nresults.size(), Option$.MODULE$.option2Iterable(results.exceptions().find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ScenarioTestService.$anonfun$computeCounts$2(key, x$3)))).size()));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        return this.processCounter.computeCounts(canonical, (Function1<String, Option<RawCount>>)(Function1 & Serializable & scala.Serializable)key -> counts.get(key));
    }

    public static final /* synthetic */ boolean $anonfun$computeCounts$2(String key$1, TestProcess.ExceptionResult x$3) {
        return x$3.nodeId().contains((Object)key$1);
    }

    public ScenarioTestService(ProcessingTypeDataProvider<TestInfoProvider> testInfoProviders, TestDataSettings testDataSettings, ScenarioTestDataSerDe scenarioTestDataSerDe, UIProcessResolving processResolving, ProcessCounter processCounter, ActorRef managementActor, Timeout systemRequestTimeout) {
        this.testInfoProviders = testInfoProviders;
        this.testDataSettings = testDataSettings;
        this.scenarioTestDataSerDe = scenarioTestDataSerDe;
        this.processResolving = processResolving;
        this.processCounter = processCounter;
        this.managementActor = managementActor;
        LazyLogging.$init$((LazyLogging)this);
        this.timeout = systemRequestTimeout;
    }
}

