/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.api;

import akka.http.javadsl.common.JsonEntityStreamingSupport;
import akka.http.scaladsl.marshalling.Marshaller;
import akka.http.scaladsl.marshalling.Marshaller$;
import akka.http.scaladsl.marshalling.ToResponseMarshallable;
import akka.http.scaladsl.marshalling.ToResponseMarshallable$;
import akka.http.scaladsl.model.ContentTypeRange;
import akka.http.scaladsl.model.ContentTypes$;
import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.HttpEntity$;
import akka.http.scaladsl.model.HttpProtocol;
import akka.http.scaladsl.model.HttpResponse;
import akka.http.scaladsl.model.HttpResponse$;
import akka.http.scaladsl.model.MediaType;
import akka.http.scaladsl.model.RequestEntity;
import akka.http.scaladsl.model.ResponseEntity;
import akka.http.scaladsl.model.StatusCode;
import akka.http.scaladsl.model.StatusCodes;
import akka.http.scaladsl.model.StatusCodes$;
import akka.http.scaladsl.server.Directives$;
import akka.http.scaladsl.server.ExceptionHandler;
import akka.http.scaladsl.server.ExceptionHandler$;
import akka.http.scaladsl.unmarshalling.Unmarshaller;
import akka.stream.scaladsl.Source;
import akka.util.ByteString;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import de.heikoseeberger.akkahttpcirce.BaseCirceSupport;
import de.heikoseeberger.akkahttpcirce.FailFastCirceSupport;
import de.heikoseeberger.akkahttpcirce.FailFastUnmarshaller;
import io.circe.Decoder;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Error;
import io.circe.Json;
import io.circe.KeyEncoder$;
import io.circe.ParsingFailure;
import io.circe.Printer;
import io.circe.syntax.package;
import io.circe.syntax.package$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import pl.touk.nussknacker.ui.BadRequestError;
import pl.touk.nussknacker.ui.EspError;
import pl.touk.nussknacker.ui.FatalError;
import pl.touk.nussknacker.ui.IllegalOperationError;
import pl.touk.nussknacker.ui.NotFoundError;
import pl.touk.nussknacker.ui.process.deployment.ProcessIsBeingDeployed;
import pl.touk.nussknacker.ui.validation.FatalValidationError;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

public final class EspErrorToHttp$
implements LazyLogging,
FailFastCirceSupport {
    public static EspErrorToHttp$ MODULE$;
    private final Marshaller<Source<ByteString, Object>, RequestEntity> de$heikoseeberger$akkahttpcirce$BaseCirceSupport$$jsonSourceStringMarshaller;
    private final Unmarshaller<HttpEntity, Json> jsonUnmarshaller;
    private final Unmarshaller<HttpEntity, Either<ParsingFailure, Json>> safeJsonUnmarshaller;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new EspErrorToHttp$();
    }

    public final <A> Unmarshaller<ByteString, A> fromByteStringUnmarshaller(Decoder<A> evidence$5) {
        return FailFastUnmarshaller.fromByteStringUnmarshaller$((FailFastUnmarshaller)this, evidence$5);
    }

    public final <A> Unmarshaller<HttpEntity, A> unmarshaller(Decoder<A> evidence$6) {
        return FailFastUnmarshaller.unmarshaller$((FailFastUnmarshaller)this, evidence$6);
    }

    public final <A> Unmarshaller<HttpEntity, Either<Error, A>> safeUnmarshaller(Decoder<A> evidence$7) {
        return FailFastUnmarshaller.safeUnmarshaller$((FailFastUnmarshaller)this, evidence$7);
    }

    public scala.collection.immutable.Seq<ContentTypeRange> unmarshallerContentTypes() {
        return BaseCirceSupport.unmarshallerContentTypes$((BaseCirceSupport)this);
    }

    public scala.collection.immutable.Seq<MediaType.WithFixedCharset> mediaTypes() {
        return BaseCirceSupport.mediaTypes$((BaseCirceSupport)this);
    }

    public final Marshaller<Json, RequestEntity> jsonMarshaller(Printer printer) {
        return BaseCirceSupport.jsonMarshaller$((BaseCirceSupport)this, (Printer)printer);
    }

    public final Printer jsonMarshaller$default$1() {
        return BaseCirceSupport.jsonMarshaller$default$1$((BaseCirceSupport)this);
    }

    public final <A> Marshaller<A, RequestEntity> marshaller(Encoder<A> evidence$2, Printer printer) {
        return BaseCirceSupport.marshaller$((BaseCirceSupport)this, evidence$2, (Printer)printer);
    }

    public final <A> Printer marshaller$default$2() {
        return BaseCirceSupport.marshaller$default$2$((BaseCirceSupport)this);
    }

    public Unmarshaller<ByteString, Json> byteStringJsonUnmarshaller() {
        return BaseCirceSupport.byteStringJsonUnmarshaller$((BaseCirceSupport)this);
    }

    public <A> Unmarshaller<HttpEntity, Source<A, Object>> sourceUnmarshaller(Decoder<A> evidence$4, JsonEntityStreamingSupport support) {
        return BaseCirceSupport.sourceUnmarshaller$((BaseCirceSupport)this, evidence$4, (JsonEntityStreamingSupport)support);
    }

    public <A> JsonEntityStreamingSupport sourceUnmarshaller$default$2() {
        return BaseCirceSupport.sourceUnmarshaller$default$2$((BaseCirceSupport)this);
    }

    public <A> Marshaller<Source<A, Object>, RequestEntity> sourceMarshaller(Encoder<A> writes, Printer printer, JsonEntityStreamingSupport support) {
        return BaseCirceSupport.sourceMarshaller$((BaseCirceSupport)this, writes, (Printer)printer, (JsonEntityStreamingSupport)support);
    }

    public <A> Printer sourceMarshaller$default$2() {
        return BaseCirceSupport.sourceMarshaller$default$2$((BaseCirceSupport)this);
    }

    public <A> JsonEntityStreamingSupport sourceMarshaller$default$3() {
        return BaseCirceSupport.sourceMarshaller$default$3$((BaseCirceSupport)this);
    }

    public Marshaller<Source<ByteString, Object>, RequestEntity> de$heikoseeberger$akkahttpcirce$BaseCirceSupport$$jsonSourceStringMarshaller() {
        return this.de$heikoseeberger$akkahttpcirce$BaseCirceSupport$$jsonSourceStringMarshaller;
    }

    public final Unmarshaller<HttpEntity, Json> jsonUnmarshaller() {
        return this.jsonUnmarshaller;
    }

    public final Unmarshaller<HttpEntity, Either<ParsingFailure, Json>> safeJsonUnmarshaller() {
        return this.safeJsonUnmarshaller;
    }

    public final void de$heikoseeberger$akkahttpcirce$BaseCirceSupport$_setter_$de$heikoseeberger$akkahttpcirce$BaseCirceSupport$$jsonSourceStringMarshaller_$eq(Marshaller<Source<ByteString, Object>, RequestEntity> x$1) {
        this.de$heikoseeberger$akkahttpcirce$BaseCirceSupport$$jsonSourceStringMarshaller = x$1;
    }

    public final void de$heikoseeberger$akkahttpcirce$BaseCirceSupport$_setter_$jsonUnmarshaller_$eq(Unmarshaller<HttpEntity, Json> x$1) {
        this.jsonUnmarshaller = x$1;
    }

    public final void de$heikoseeberger$akkahttpcirce$BaseCirceSupport$_setter_$safeJsonUnmarshaller_$eq(Unmarshaller<HttpEntity, Either<ParsingFailure, Json>> x$1) {
        this.safeJsonUnmarshaller = x$1;
    }

    private Logger logger$lzycompute() {
        EspErrorToHttp$ espErrorToHttp$ = this;
        synchronized (espErrorToHttp$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public HttpResponse espErrorToHttp(EspError error) {
        StatusCodes.ClientError statusCode;
        StatusCodes.ClientError clientError;
        EspError espError = error;
        if (espError instanceof NotFoundError) {
            clientError = StatusCodes$.MODULE$.NotFound();
        } else if (espError instanceof FatalError) {
            clientError = StatusCodes$.MODULE$.InternalServerError();
        } else if (espError instanceof BadRequestError) {
            clientError = StatusCodes$.MODULE$.BadRequest();
        } else if (espError instanceof ProcessIsBeingDeployed) {
            clientError = StatusCodes$.MODULE$.Conflict();
        } else if (espError instanceof FatalValidationError) {
            clientError = StatusCodes$.MODULE$.BadRequest();
        } else if (espError instanceof IllegalOperationError) {
            clientError = StatusCodes$.MODULE$.Conflict();
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringBuilder(18).append("Unknown EspError: ").append(error.getMessage()).toString(), new Object[]{error});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            clientError = StatusCodes$.MODULE$.InternalServerError();
        }
        StatusCodes.ClientError x$1 = statusCode = clientError;
        HttpEntity.Strict x$2 = HttpEntity$.MODULE$.apply(error.getMessage());
        scala.collection.immutable.Seq x$3 = HttpResponse$.MODULE$.apply$default$2();
        HttpProtocol x$4 = HttpResponse$.MODULE$.apply$default$4();
        return HttpResponse$.MODULE$.apply((StatusCode)x$1, x$3, (ResponseEntity)x$2, x$4);
    }

    public PartialFunction<Throwable, HttpResponse> errorToHttp() {
        return new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                HttpResponse httpResponse;
                A1 A1 = x1;
                if (A1 instanceof EspError) {
                    A1 A12 = A1;
                    httpResponse = EspErrorToHttp$.MODULE$.espErrorToHttp((EspError)((Object)A12));
                } else if (A1 instanceof IllegalArgumentException) {
                    BoxedUnit boxedUnit;
                    IllegalArgumentException illegalArgumentException = (IllegalArgumentException)A1;
                    if (EspErrorToHttp$.MODULE$.logger().underlying().isDebugEnabled()) {
                        EspErrorToHttp$.MODULE$.logger().underlying().debug(new StringBuilder(18).append("Illegal argument: ").append(illegalArgumentException.getMessage()).toString(), (Throwable)illegalArgumentException);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    StatusCodes.ClientError x$1 = StatusCodes$.MODULE$.BadRequest();
                    HttpEntity.Strict x$2 = HttpEntity$.MODULE$.apply(illegalArgumentException.getMessage());
                    scala.collection.immutable.Seq x$3 = HttpResponse$.MODULE$.apply$default$2();
                    HttpProtocol x$4 = HttpResponse$.MODULE$.apply$default$4();
                    httpResponse = HttpResponse$.MODULE$.apply((StatusCode)x$1, x$3, (ResponseEntity)x$2, x$4);
                } else {
                    BoxedUnit boxedUnit;
                    if (EspErrorToHttp$.MODULE$.logger().underlying().isErrorEnabled()) {
                        EspErrorToHttp$.MODULE$.logger().underlying().error(new StringBuilder(15).append("Unknown error: ").append(A1.getMessage()).toString(), A1);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    StatusCodes.ServerError x$5 = StatusCodes$.MODULE$.InternalServerError();
                    HttpEntity.Strict x$6 = HttpEntity$.MODULE$.apply(A1.getMessage());
                    scala.collection.immutable.Seq x$7 = HttpResponse$.MODULE$.apply$default$2();
                    HttpProtocol x$8 = HttpResponse$.MODULE$.apply$default$4();
                    httpResponse = HttpResponse$.MODULE$.apply((StatusCode)x$5, x$7, (ResponseEntity)x$6, x$8);
                }
                return (B1)httpResponse;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof EspError ? true : (throwable instanceof IllegalArgumentException ? true : true);
                return bl;
            }
        };
    }

    public ExceptionHandler espErrorHandler() {
        return ExceptionHandler$.MODULE$.apply((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                Option option = NonFatal$.MODULE$.unapply(A1);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    object = Directives$.MODULE$.complete((Function0 & Serializable & scala.Serializable)() -> ToResponseMarshallable$.MODULE$.apply(EspErrorToHttp$.MODULE$.errorToHttp().apply((Object)e), Marshaller$.MODULE$.fromResponse()));
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                Option option = NonFatal$.MODULE$.unapply(throwable);
                boolean bl = !option.isEmpty();
                return bl;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(java.lang.Throwable )}, serializedLambda);
            }
        });
    }

    public <T> ToResponseMarshallable toResponseXor(Either<EspError, T> xor, Encoder<T> evidence$1) {
        ToResponseMarshallable toResponseMarshallable;
        Either<EspError, T> either = xor;
        if (either instanceof Right) {
            Right right = (Right)either;
            Object t = right.value();
            toResponseMarshallable = ToResponseMarshallable$.MODULE$.apply(t, Marshaller$.MODULE$.liftMarshaller(this.marshaller(evidence$1, this.marshaller$default$2())));
        } else if (either instanceof Left) {
            Left left = (Left)either;
            EspError err = (EspError)left.value();
            toResponseMarshallable = ToResponseMarshallable$.MODULE$.apply((Object)this.espErrorToHttp(err), Marshaller$.MODULE$.fromResponse());
        } else {
            throw new MatchError(either);
        }
        return toResponseMarshallable;
    }

    public <T> ToResponseMarshallable toResponseEither(Either<EspError, T> either, Encoder<T> evidence$2) {
        ToResponseMarshallable toResponseMarshallable;
        Either<EspError, T> either2 = either;
        if (either2 instanceof Right) {
            Right right = (Right)either2;
            Object t = right.value();
            toResponseMarshallable = ToResponseMarshallable$.MODULE$.apply(t, Marshaller$.MODULE$.liftMarshaller(this.marshaller(evidence$2, this.marshaller$default$2())));
        } else if (either2 instanceof Left) {
            Left left = (Left)either2;
            EspError err = (EspError)left.value();
            toResponseMarshallable = ToResponseMarshallable$.MODULE$.apply((Object)this.espErrorToHttp(err), Marshaller$.MODULE$.fromResponse());
        } else {
            throw new MatchError(either2);
        }
        return toResponseMarshallable;
    }

    public <T> HttpResponse toResponseEither(Either<EspError, T> either, StatusCode okStatus, Encoder<T> evidence$3) {
        HttpResponse httpResponse;
        Either<EspError, T> either2 = either;
        if (either2 instanceof Right) {
            Right right = (Right)either2;
            Object t = right.value();
            StatusCode x$1 = okStatus;
            HttpEntity.Strict x$2 = HttpEntity$.MODULE$.apply(ContentTypes$.MODULE$.application$divjson(), package.EncoderOps$.MODULE$.asJson$extension(package$.MODULE$.EncoderOps(t), evidence$3).noSpaces());
            scala.collection.immutable.Seq x$3 = HttpResponse$.MODULE$.apply$default$2();
            HttpProtocol x$4 = HttpResponse$.MODULE$.apply$default$4();
            httpResponse = HttpResponse$.MODULE$.apply(x$1, x$3, (ResponseEntity)x$2, x$4);
        } else if (either2 instanceof Left) {
            Left left = (Left)either2;
            EspError err = (EspError)left.value();
            httpResponse = this.espErrorToHttp(err);
        } else {
            throw new MatchError(either2);
        }
        return httpResponse;
    }

    public HttpResponse toResponse(StatusCode okStatus, Either<EspError, BoxedUnit> xor) {
        HttpResponse httpResponse;
        Either<EspError, BoxedUnit> either = xor;
        if (either instanceof Left) {
            Left left = (Left)either;
            EspError error = (EspError)left.value();
            httpResponse = this.espErrorToHttp(error);
        } else if (either instanceof Right) {
            httpResponse = HttpResponse$.MODULE$.apply(okStatus, HttpResponse$.MODULE$.apply$default$2(), HttpResponse$.MODULE$.apply$default$3(), HttpResponse$.MODULE$.apply$default$4());
        } else {
            throw new MatchError(either);
        }
        return httpResponse;
    }

    public ToResponseMarshallable toResponseReject(String message) {
        String entity = Encoder$.MODULE$.encodeMap(KeyEncoder$.MODULE$.encodeKeyString(), Encoder$.MODULE$.encodeString()).apply((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)message)}))).spaces2();
        StatusCodes.ClientError x$1 = StatusCodes$.MODULE$.BadRequest();
        HttpEntity.Strict x$2 = HttpEntity$.MODULE$.apply(ContentTypes$.MODULE$.application$divjson(), entity);
        scala.collection.immutable.Seq x$3 = HttpResponse$.MODULE$.apply$default$2();
        HttpProtocol x$4 = HttpResponse$.MODULE$.apply$default$4();
        return ToResponseMarshallable$.MODULE$.apply((Object)HttpResponse$.MODULE$.apply((StatusCode)x$1, x$3, (ResponseEntity)x$2, x$4), Marshaller$.MODULE$.fromResponse());
    }

    private EspErrorToHttp$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        BaseCirceSupport.$init$((BaseCirceSupport)this);
        FailFastUnmarshaller.$init$((FailFastUnmarshaller)this);
    }
}

