/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.component;

import cats.data.Validated;
import com.typesafe.config.Config;
import java.io.Serializable;
import pl.touk.nussknacker.engine.ProcessingTypeData;
import pl.touk.nussknacker.engine.api.component.ComponentId;
import pl.touk.nussknacker.engine.api.component.SingleComponentConfig;
import pl.touk.nussknacker.restmodel.definition.package;
import pl.touk.nussknacker.ui.component.Component;
import pl.touk.nussknacker.ui.component.ComponentConfigurationException;
import pl.touk.nussknacker.ui.component.ComponentIdProvider;
import pl.touk.nussknacker.ui.component.ComponentWrongConfiguration;
import pl.touk.nussknacker.ui.component.DefaultComponentIdProvider;
import pl.touk.nussknacker.ui.component.DefaultComponentService;
import pl.touk.nussknacker.ui.component.DefaultsComponentIcon$;
import pl.touk.nussknacker.ui.component.WrongConfigurationAttribute$;
import pl.touk.nussknacker.ui.definition.UIProcessObjectsFactory$;
import pl.touk.nussknacker.ui.process.ProcessCategoryService;
import pl.touk.nussknacker.ui.process.ProcessService;
import pl.touk.nussknacker.ui.process.processingtypedata.ProcessingTypeDataProvider;
import pl.touk.nussknacker.ui.process.subprocess.SubprocessDetails;
import pl.touk.nussknacker.ui.security.api.LoggedUser;
import pl.touk.nussknacker.ui.security.api.NussknackerInternalUser$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;

public final class DefaultComponentService$ {
    public static DefaultComponentService$ MODULE$;

    static {
        new DefaultComponentService$();
    }

    public DefaultComponentService apply(Config config, ProcessingTypeDataProvider<ProcessingTypeData> processingTypeDataProvider, ProcessService processService, ProcessCategoryService categoryService, ExecutionContext ec) {
        Validated<List<ComponentWrongConfiguration<?>>, ComponentIdProvider> componentIdProvider = this.prepareComponentProvider(processingTypeDataProvider, categoryService, ec);
        return (DefaultComponentService)componentIdProvider.map((Function1 & Serializable & scala.Serializable)x$1 -> new DefaultComponentService(config, processingTypeDataProvider, processService, categoryService, (ComponentIdProvider)x$1, ec)).valueOr((Function1 & Serializable & scala.Serializable)wrongConfigurations -> {
            throw new ComponentConfigurationException("Wrong configured components were found.", (List<ComponentWrongConfiguration<?>>)wrongConfigurations);
        });
    }

    private Validated<List<ComponentWrongConfiguration<?>>, ComponentIdProvider> prepareComponentProvider(ProcessingTypeDataProvider<ProcessingTypeData> processingTypeDataProvider, ProcessCategoryService categoryService, ExecutionContext ec) {
        List data = (List)processingTypeDataProvider.all().toList().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String processingType = (String)tuple2._1();
            ProcessingTypeData processingTypeData = (ProcessingTypeData)tuple2._2();
            DefaultComponentService.ExtractedData extractedData = MODULE$.extractFromProcessingType(processingTypeData, processingType, categoryService, ec);
            return extractedData;
        }, List$.MODULE$.canBuildFrom());
        List wrongComponents = ((TraversableOnce)((TraversableLike)data.flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.components(), List$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x$3 -> new ComponentId(x$3.id())).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Nil$ nil$;
            .colon.colon colon2;
            List list;
            List list2;
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null && (list2 = (List)tuple2._2()) instanceof .colon.colon && Nil$.MODULE$.equals(list = (colon2 = (.colon.colon)list2).tl$access$1())) {
                nil$ = Nil$.MODULE$;
            } else if (tuple2 != null) {
                String componentId = ((ComponentId)tuple2._1()).value();
                List components = (List)tuple2._2();
                nil$ = MODULE$.computeWrongConfigurations(componentId, (Iterable<Component>)components);
            } else {
                throw new MatchError((Object)tuple2);
            }
            return nil$;
        }, Iterable$.MODULE$.canBuildFrom())).toList();
        return wrongComponents.nonEmpty() ? new Validated.Invalid((Object)wrongComponents) : new Validated.Valid((Object)new DefaultComponentIdProvider((Map<String, Map<String, SingleComponentConfig>>)((TraversableOnce)data.map((Function1 & Serializable & scala.Serializable)d -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)d.processingType()), d.componentsUiConfig()), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())));
    }

    private DefaultComponentService.ExtractedData extractFromProcessingType(ProcessingTypeData processingTypeData, String processingType, ProcessCategoryService categoryService, ExecutionContext ec) {
        package.UIProcessObjects uiProcessObjects = UIProcessObjectsFactory$.MODULE$.prepareUIProcessObjects(processingTypeData.modelData(), processingTypeData.deploymentManager(), processingTypeData.typeSpecificInitialData(), (LoggedUser)NussknackerInternalUser$.MODULE$, (Set<SubprocessDetails>)Predef$.MODULE$.Set().empty(), false, categoryService, processingTypeData.additionalPropertiesConfig(), processingType);
        Map componentsUiConfig = uiProcessObjects.componentsConfig();
        DefaultComponentIdProvider componentIdProvider = new DefaultComponentIdProvider((Map<String, Map<String, SingleComponentConfig>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)processingType), (Object)componentsUiConfig)}))));
        List components = (List)uiProcessObjects.componentGroups().flatMap((Function1 & Serializable & scala.Serializable)group -> (List)group.components().map((Function1 & Serializable & scala.Serializable)com -> {
            String componentId = componentIdProvider.createComponentId(processingType, com.label(), com.type());
            String icon = MODULE$.pl$touk$nussknacker$ui$component$DefaultComponentService$$getComponentIcon((Map<String, SingleComponentConfig>)componentsUiConfig, (package.ComponentTemplate)com);
            return new Component(componentId, com.label(), icon, com.type(), group.name());
        }, List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom());
        return new DefaultComponentService.ExtractedData(processingType, (Map<String, SingleComponentConfig>)componentsUiConfig, (List<Component>)components);
    }

    public String pl$touk$nussknacker$ui$component$DefaultComponentService$$getComponentIcon(Map<String, SingleComponentConfig> componentsUiConfig, package.ComponentTemplate com) {
        return (String)this.componentConfig(componentsUiConfig, com).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.icon()).getOrElse((Function0 & Serializable & scala.Serializable)() -> DefaultsComponentIcon$.MODULE$.fromComponentType(com.type()));
    }

    public Option<String> pl$touk$nussknacker$ui$component$DefaultComponentService$$getComponentDoc(Map<String, SingleComponentConfig> componentsUiConfig, package.ComponentTemplate com) {
        return this.componentConfig(componentsUiConfig, com).flatMap((Function1 & Serializable & scala.Serializable)x$5 -> x$5.docsUrl());
    }

    private Option<SingleComponentConfig> componentConfig(Map<String, SingleComponentConfig> componentsUiConfig, package.ComponentTemplate com) {
        return componentsUiConfig.get((Object)com.label());
    }

    private List<ComponentWrongConfiguration<?>> computeWrongConfigurations(String componentId, Iterable<Component> components) {
        Option wrongConfiguredNames = DefaultComponentService$.discoverWrongConfiguration$1(WrongConfigurationAttribute$.MODULE$.NameAttribute(), (Iterable)components.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.name(), scala.collection.Iterable$.MODULE$.canBuildFrom()), componentId);
        Option wrongConfiguredIcons = DefaultComponentService$.discoverWrongConfiguration$1(WrongConfigurationAttribute$.MODULE$.IconAttribute(), (Iterable)components.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.icon(), scala.collection.Iterable$.MODULE$.canBuildFrom()), componentId);
        Option wrongConfiguredGroups = DefaultComponentService$.discoverWrongConfiguration$1(WrongConfigurationAttribute$.MODULE$.ComponentGroupNameAttribute(), (Iterable)components.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.componentGroupName(), scala.collection.Iterable$.MODULE$.canBuildFrom()), componentId);
        Option wrongConfiguredTypes = DefaultComponentService$.discoverWrongConfiguration$1(WrongConfigurationAttribute$.MODULE$.ComponentTypeAttribute(), (Iterable)components.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.componentType(), scala.collection.Iterable$.MODULE$.canBuildFrom()), componentId);
        Iterable wrongConfigurations = (Iterable)((TraversableLike)((TraversableLike)Option$.MODULE$.option2Iterable(wrongConfiguredNames).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(wrongConfiguredTypes), scala.collection.Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(wrongConfiguredGroups), scala.collection.Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(wrongConfiguredIcons), scala.collection.Iterable$.MODULE$.canBuildFrom());
        return wrongConfigurations.toList();
    }

    private static final Option discoverWrongConfiguration$1(Enumeration.Value attribute, Iterable elements, String componentId$1) {
        .colon.colon colon2;
        List list;
        List list2 = (List)elements.toList().distinct();
        Object object = list2 instanceof .colon.colon && Nil$.MODULE$.equals(list = (colon2 = (.colon.colon)list2).tl$access$1()) ? None$.MODULE$ : new Some(new ComponentWrongConfiguration(componentId$1, attribute, list2));
        return object;
    }

    private DefaultComponentService$() {
        MODULE$ = this;
    }
}

