/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.process;

import cats.Applicative;
import cats.Functor;
import cats.Monad;
import cats.data.EitherT;
import cats.data.EitherT$;
import cats.instances.package;
import cats.syntax.EitherIdOps$;
import cats.syntax.package;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import pl.touk.nussknacker.engine.api.deployment.DataFreshnessPolicy;
import pl.touk.nussknacker.engine.api.deployment.ProcessActionType$;
import pl.touk.nussknacker.engine.api.deployment.ProcessState;
import pl.touk.nussknacker.engine.api.expression.ExpressionTypingInfo;
import pl.touk.nussknacker.engine.api.process.ProcessName;
import pl.touk.nussknacker.engine.api.process.VersionId;
import pl.touk.nussknacker.engine.canonicalgraph.CanonicalProcess;
import pl.touk.nussknacker.engine.marshall.ProcessMarshaller$;
import pl.touk.nussknacker.restmodel.displayedgraph.DisplayableProcess;
import pl.touk.nussknacker.restmodel.displayedgraph.ValidatedDisplayableProcess;
import pl.touk.nussknacker.restmodel.process.ProcessIdWithName;
import pl.touk.nussknacker.restmodel.process.package;
import pl.touk.nussknacker.restmodel.processdetails;
import pl.touk.nussknacker.restmodel.validation.ValidationResults;
import pl.touk.nussknacker.ui.EspError;
import pl.touk.nussknacker.ui.api.ProcessesResources$UnmarshallError$;
import pl.touk.nussknacker.ui.listener.Comment;
import pl.touk.nussknacker.ui.process.NewProcessPreparer;
import pl.touk.nussknacker.ui.process.ProcessCategoryService;
import pl.touk.nussknacker.ui.process.ProcessService;
import pl.touk.nussknacker.ui.process.deployment.DeploymentService;
import pl.touk.nussknacker.ui.process.exception.ProcessIllegalAction;
import pl.touk.nussknacker.ui.process.exception.ProcessIllegalAction$;
import pl.touk.nussknacker.ui.process.exception.ProcessValidationError;
import pl.touk.nussknacker.ui.process.marshall.ProcessConverter$;
import pl.touk.nussknacker.ui.process.repository.DBIOActionRunner;
import pl.touk.nussknacker.ui.process.repository.FetchingProcessRepository;
import pl.touk.nussknacker.ui.process.repository.FetchingProcessRepository$FetchProcessesDetailsQuery$;
import pl.touk.nussknacker.ui.process.repository.ProcessActionRepository;
import pl.touk.nussknacker.ui.process.repository.ProcessDBQueryRepository;
import pl.touk.nussknacker.ui.process.repository.ProcessRepository;
import pl.touk.nussknacker.ui.process.subprocess.SubprocessDetails;
import pl.touk.nussknacker.ui.security.api.LoggedUser;
import pl.touk.nussknacker.ui.uiresolving.UIProcessResolving;
import pl.touk.nussknacker.ui.validation.FatalValidationError$;
import pl.touk.nussknacker.ui.validation.ProcessValidation;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import slick.dbio.DBIOAction;
import slick.dbio.DBIOAction$;

@ScalaSignature(bytes="\u0006\u0005\u0011mh\u0001\u0002\u0013&\u0001AB\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\u001b\"A\u0001\u000b\u0001B\u0001B\u0003%\u0011\u000b\u0003\u0005U\u0001\t\u0005\t\u0015!\u0003V\u0011!Y\u0006A!A!\u0002\u0013a\u0006\u0002\u00032\u0001\u0005\u0003\u0005\u000b\u0011B2\t\u00111\u0004!\u0011!Q\u0001\n5D!\"!\u0002\u0001\u0005\u0003\u0005\u000b\u0011BA\u0004\u0011)\ti\u0001\u0001B\u0001B\u0003%\u0011q\u0002\u0005\u000b\u00037\u0001!\u0011!Q\u0001\f\u0005u\u0001bBA\u0012\u0001\u0011\u0005\u0011Q\u0005\u0005\b\u0003\u007f\u0001A\u0011IA!\u0011\u001d\ty\t\u0001C!\u0003#Cq!a5\u0001\t\u0003\n)\u000eC\u0004\u0002^\u0002!\t%a8\t\u000f\u0005\u001d\b\u0001\"\u0011\u0002j\"9!q\u0002\u0001\u0005B\tE\u0001b\u0002B\u0016\u0001\u0011\u0005#Q\u0006\u0005\b\u0005\u0013\u0002A\u0011\tB&\u0011\u001d\u00119\t\u0001C!\u0005\u0013CqA!,\u0001\t\u0003\u0012y\u000bC\u0004\u0003F\u0002!\tEa2\t\u000f\tu\u0007\u0001\"\u0011\u0003`\"911\u0002\u0001\u0005\u0002\r5\u0001bBB\u0016\u0001\u0011%1Q\u0006\u0005\b\u00077\u0002A\u0011BB/\u0011\u001d\u00199\u000b\u0001C\u0005\u0007SCqaa/\u0001\t\u0013\u0019i\fC\u0004\u0004\\\u0002!Ia!8\t\u000f\re\b\u0001\"\u0003\u0004|\"9A1\u0006\u0001\u0005\n\u00115\u0002b\u0002C/\u0001\u0011%Aq\f\u0005\b\t;\u0002A\u0011\u0002CG\u0011\u001d!Y\f\u0001C\u0005\t{CqAa\"\u0001\t\u0013!\u0019N\u0001\tE\u0005B\u0013xnY3tgN+'O^5dK*\u0011aeJ\u0001\baJ|7-Z:t\u0015\tA\u0013&\u0001\u0002vS*\u0011!fK\u0001\f]V\u001c8o\u001b8bG.,'O\u0003\u0002-[\u0005!Ao\\;l\u0015\u0005q\u0013A\u00019m\u0007\u0001\u0019B\u0001A\u00198wA\u0011!'N\u0007\u0002g)\tA'A\u0003tG\u0006d\u0017-\u0003\u00027g\t1\u0011I\\=SK\u001a\u0004\"\u0001O\u001d\u000e\u0003\u0015J!AO\u0013\u0003\u001dA\u0013xnY3tgN+'O^5dKB\u0011AhQ\u0007\u0002{)\u0011ahP\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003\u0001\u0006\u000b\u0001\u0002^=qKN\fg-\u001a\u0006\u0002\u0005\u0006\u00191m\\7\n\u0005\u0011k$a\u0003'bufdunZ4j]\u001e\f\u0011\u0003Z3qY>LX.\u001a8u'\u0016\u0014h/[2f!\t9%*D\u0001I\u0015\tIU%\u0001\u0006eKBdw._7f]RL!a\u0013%\u0003#\u0011+\u0007\u000f\\8z[\u0016tGoU3sm&\u001cW-\u0001\noK^\u0004&o\\2fgN\u0004&/\u001a9be\u0016\u0014\bC\u0001\u001dO\u0013\tyUE\u0001\nOK^\u0004&o\\2fgN\u0004&/\u001a9be\u0016\u0014\u0018A\u00069s_\u000e,7o]\"bi\u0016<wN]=TKJ4\u0018nY3\u0011\u0005a\u0012\u0016BA*&\u0005Y\u0001&o\\2fgN\u001c\u0015\r^3h_JL8+\u001a:wS\u000e,\u0017\u0001\u00059s_\u000e,7o\u001d*fg>dg/\u001b8h!\t1\u0016,D\u0001X\u0015\tAv%A\u0006vSJ,7o\u001c7wS:<\u0017B\u0001.X\u0005I)\u0016\n\u0015:pG\u0016\u001c8OU3t_24\u0018N\\4\u0002\u0015\u0011\u0014\u0017n\u001c*v]:,'\u000f\u0005\u0002^A6\taL\u0003\u0002`K\u0005Q!/\u001a9pg&$xN]=\n\u0005\u0005t&\u0001\u0005#C\u0013>\u000b5\r^5p]J+hN\\3s\u0003e1W\r^2iS:<\u0007K]8dKN\u001c(+\u001a9pg&$xN]=\u0011\u0007u#g-\u0003\u0002f=\nIb)\u001a;dQ&tw\r\u0015:pG\u0016\u001c8OU3q_NLGo\u001c:z!\t9'.D\u0001i\u0015\tI7'\u0001\u0006d_:\u001cWO\u001d:f]RL!a\u001b5\u0003\r\u0019+H/\u001e:f\u0003]\u0001(o\\2fgN\f5\r^5p]J+\u0007o\\:ji>\u0014\u0018\u0010E\u0002^]BL!a\u001c0\u0003/A\u0013xnY3tg\u0006\u001bG/[8o%\u0016\u0004xn]5u_JL\bCA9\u0000\u001d\t\u0011HP\u0004\u0002ts:\u0011Ao^\u0007\u0002k*\u0011aoL\u0001\u0007yI|w\u000e\u001e \n\u0003a\f!\u0001\u001a2\n\u0005i\\\u0018\u0001B;uS2T\u0011\u0001_\u0005\u0003{z\f1\u0003\u0012\"J\u001f\u0006\u001bG/[8o\u0013:\u001cH/\u00198dKNT!A_>\n\t\u0005\u0005\u00111\u0001\u0002\u0003\t\nS!! @\u0002#A\u0014xnY3tgJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0003^\u0003\u0013\u0001\u0018bAA\u0006=\n\t\u0002K]8dKN\u001c(+\u001a9pg&$xN]=\u0002#A\u0014xnY3tgZ\u000bG.\u001b3bi&|g\u000e\u0005\u0003\u0002\u0012\u0005]QBAA\n\u0015\r\t)bJ\u0001\u000bm\u0006d\u0017\u000eZ1uS>t\u0017\u0002BA\r\u0003'\u0011\u0011\u0003\u0015:pG\u0016\u001c8OV1mS\u0012\fG/[8o\u0003\t)7\rE\u0002h\u0003?I1!!\ti\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH/\u0001\u0004=S:LGO\u0010\u000b\u0015\u0003O\ti#a\f\u00022\u0005M\u0012QGA\u001c\u0003s\tY$!\u0010\u0015\t\u0005%\u00121\u0006\t\u0003q\u0001Aq!a\u0007\f\u0001\b\ti\u0002C\u0003F\u0017\u0001\u0007a\tC\u0003M\u0017\u0001\u0007Q\nC\u0003Q\u0017\u0001\u0007\u0011\u000bC\u0003U\u0017\u0001\u0007Q\u000bC\u0003\\\u0017\u0001\u0007A\fC\u0003c\u0017\u0001\u00071\rC\u0003m\u0017\u0001\u0007Q\u000eC\u0004\u0002\u0006-\u0001\r!a\u0002\t\u000f\u000551\u00021\u0001\u0002\u0010\u0005q\u0011M]2iSZ,\u0007K]8dKN\u001cH\u0003BA\"\u0003{\"B!!\u0012\u0002jA!qM[A$!\u0011\tI%a\u0019\u000f\t\u0005-\u0013q\f\b\u0005\u0003\u001b\niF\u0004\u0003\u0002P\u0005mc\u0002BA)\u00033rA!a\u0015\u0002X9\u0019A/!\u0016\n\u00039J!\u0001L\u0017\n\u0005)Z\u0013B\u0001\u0015*\u0013\t1s%C\u0002\u0002b\u0015\na\u0002\u0015:pG\u0016\u001c8oU3sm&\u001cW-\u0003\u0003\u0002f\u0005\u001d$!D#naRL(+Z:q_:\u001cXMC\u0002\u0002b\u0015Bq!a\u001b\r\u0001\b\ti'\u0001\u0003vg\u0016\u0014\b\u0003BA8\u0003sj!!!\u001d\u000b\t\u0005M\u0014QO\u0001\u0004CBL'bAA<O\u0005A1/Z2ve&$\u00180\u0003\u0003\u0002|\u0005E$A\u0003'pO\u001e,G-V:fe\"9\u0011q\u0010\u0007A\u0002\u0005\u0005\u0015!\u00059s_\u000e,7o]%e/&$\bNT1nKB!\u00111QAF\u001b\t\t)IC\u0002'\u0003\u000fS1!!#*\u0003%\u0011Xm\u001d;n_\u0012,G.\u0003\u0003\u0002\u000e\u0006\u0015%!\u0005)s_\u000e,7o]%e/&$\bNT1nK\u0006i!/\u001a8b[\u0016\u0004&o\\2fgN$b!a%\u0002>\u0006}F\u0003BAK\u0003w\u0003Ba\u001a6\u0002\u0018B1\u0011\u0011TAP\u0003KsA!!\u0014\u0002\u001c&\u0019\u0011QT\u0014\u0002\u0011\u0015\u001b\b/\u0012:s_JLA!!)\u0002$\n1\u0001,\u0012:s_JT1!!((!\u0011\t9+!.\u000f\t\u0005%\u0016\u0011\u0017\b\u0005\u0003W\u000byK\u0004\u0003\u0002P\u00055\u0016bAAES%\u0019a%a\"\n\t\u0005M\u0016QQ\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t9,!/\u00033U\u0003H-\u0019;f!J|7-Z:t\u001d\u0006lWMU3ta>t7/\u001a\u0006\u0005\u0003g\u000b)\tC\u0004\u0002l5\u0001\u001d!!\u001c\t\u000f\u0005}T\u00021\u0001\u0002\u0002\"9\u0011\u0011Y\u0007A\u0002\u0005\r\u0017\u0001\u00028b[\u0016\u0004B!!2\u0002P6\u0011\u0011q\u0019\u0006\u0004M\u0005%'\u0002BA:\u0003\u0017T1!!4*\u0003\u0019)gnZ5oK&!\u0011\u0011[Ad\u0005-\u0001&o\\2fgNt\u0015-\\3\u0002!Ut\u0017I]2iSZ,\u0007K]8dKN\u001cH\u0003BAl\u00037$B!!\u0012\u0002Z\"9\u00111\u000e\bA\u0004\u00055\u0004bBA@\u001d\u0001\u0007\u0011\u0011Q\u0001\u000eI\u0016dW\r^3Qe>\u001cWm]:\u0015\t\u0005\u0005\u0018Q\u001d\u000b\u0005\u0003\u000b\n\u0019\u000fC\u0004\u0002l=\u0001\u001d!!\u001c\t\u000f\u0005}t\u00021\u0001\u0002\u0002\u0006qQ\u000f\u001d3bi\u0016\u001c\u0015\r^3h_JLHCBAv\u0003s\fY\u0010\u0006\u0003\u0002n\u0006]\b\u0003B4k\u0003_\u0004b!!'\u0002 \u0006E\b\u0003BAT\u0003gLA!!>\u0002:\niR\u000b\u001d3bi\u0016\u0004&o\\2fgN\u001c\u0015\r^3h_JL(+Z:q_:\u001cX\rC\u0004\u0002lA\u0001\u001d!!\u001c\t\u000f\u0005}\u0004\u00031\u0001\u0002\u0002\"9\u0011Q \tA\u0002\u0005}\u0018\u0001C2bi\u0016<wN]=\u0011\t\t\u0005!\u0011\u0002\b\u0005\u0005\u0007\u0011)\u0001\u0005\u0002ug%\u0019!qA\u001a\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011YA!\u0004\u0003\rM#(/\u001b8h\u0015\r\u00119aM\u0001\u000eGJ,\u0017\r^3Qe>\u001cWm]:\u0015\t\tM!\u0011\u0005\u000b\u0005\u0005+\u0011y\u0002\u0005\u0003hU\n]\u0001CBAM\u0003?\u0013I\u0002\u0005\u0003\u0002(\nm\u0011\u0002\u0002B\u000f\u0003s\u0013q\u0002\u0015:pG\u0016\u001c8OU3ta>t7/\u001a\u0005\b\u0003W\n\u00029AA7\u0011\u001d\u0011\u0019#\u0005a\u0001\u0005K\tqaY8n[\u0006tG\r\u0005\u0003\u0002J\t\u001d\u0012\u0002\u0002B\u0015\u0003O\u0012Ac\u0011:fCR,\u0007K]8dKN\u001c8i\\7nC:$\u0017!D;qI\u0006$X\r\u0015:pG\u0016\u001c8\u000f\u0006\u0004\u00030\tu\"q\b\u000b\u0005\u0005c\u0011Y\u0004\u0005\u0003hU\nM\u0002CBAM\u0003?\u0013)\u0004\u0005\u0003\u0002(\n]\u0012\u0002\u0002B\u001d\u0003s\u0013Q#\u00169eCR,\u0007K]8dKN\u001c(+Z:q_:\u001cX\rC\u0004\u0002lI\u0001\u001d!!\u001c\t\u000f\u0005}$\u00031\u0001\u0002\u0002\"9!\u0011\t\nA\u0002\t\r\u0013AB1di&|g\u000e\u0005\u0003\u0002J\t\u0015\u0013\u0002\u0002B$\u0003O\u0012A#\u00169eCR,\u0007K]8dKN\u001c8i\\7nC:$\u0017AC4fiB\u0013xnY3tgV!!Q\nB4)\u0011\u0011yE!\"\u0015\r\tE#\u0011\u0010BB!\u00119'Na\u0015\u0011\r\u0005e\u0015q\u0014B+!\u0019\u00119F!\u0018\u0003d9!\u00111\u0016B-\u0013\u0011\u0011Y&a\"\u0002\u001dA\u0014xnY3tg\u0012,G/Y5mg&!!q\fB1\u0005I\u0011\u0015m]3Qe>\u001cWm]:EKR\f\u0017\u000e\\:\u000b\t\tm\u0013q\u0011\t\u0005\u0005K\u00129\u0007\u0004\u0001\u0005\u000f\t%4C1\u0001\u0003l\t\u0011\u0001kU\t\u0005\u0005[\u0012\u0019\bE\u00023\u0005_J1A!\u001d4\u0005\u001dqu\u000e\u001e5j]\u001e\u00042A\rB;\u0013\r\u00119h\r\u0002\u0004\u0003:L\b\"\u0003B>'\u0005\u0005\t9\u0001B?\u0003))g/\u001b3f]\u000e,G%\u000e\t\u0007\u0005/\u0012yHa\u0019\n\t\t\u0005%\u0011\r\u0002\u001a!J|7-Z:t'\"\f\u0007/\u001a$fi\u000eD7\u000b\u001e:bi\u0016<\u0017\u0010C\u0004\u0002lM\u0001\u001d!!\u001c\t\u000f\u0005}4\u00031\u0001\u0002\u0002\u0006aq-\u001a;Qe>\u001cWm]:fgV!!1\u0012BR)\u0019\u0011iI!*\u0003,B!qM\u001bBH!\u0019\u0011\tJ!'\u0003 :!!1\u0013BL\u001d\r!(QS\u0005\u0002i%\u0019\u00111W\u001a\n\t\tm%Q\u0014\u0002\u0005\u0019&\u001cHOC\u0002\u00024N\u0002bAa\u0016\u0003^\t\u0005\u0006\u0003\u0002B3\u0005G#qA!\u001b\u0015\u0005\u0004\u0011Y\u0007C\u0005\u0003(R\t\t\u0011q\u0001\u0003*\u0006QQM^5eK:\u001cW\r\n\u001c\u0011\r\t]#q\u0010BQ\u0011\u001d\tY\u0007\u0006a\u0002\u0003[\n1dZ3u!J|7-Z:tKN\fe\u000eZ*vEB\u0014xnY3tg\u0016\u001cX\u0003\u0002BY\u0005w#bAa-\u0003>\n\r\u0007\u0003B4k\u0005k\u0003bA!%\u0003\u001a\n]\u0006C\u0002B,\u0005;\u0012I\f\u0005\u0003\u0003f\tmFa\u0002B5+\t\u0007!1\u000e\u0005\n\u0005\u007f+\u0012\u0011!a\u0002\u0005\u0003\f!\"\u001a<jI\u0016t7-\u001a\u00138!\u0019\u00119Fa \u0003:\"9\u00111N\u000bA\u0004\u00055\u0014aI4fi\u0006\u00138\r[5wK\u0012\u0004&o\\2fgN,7/\u00118e'V\u0014\u0007O]8dKN\u001cXm]\u000b\u0005\u0005\u0013\u0014\u0019\u000e\u0006\u0004\u0003L\nU'1\u001c\t\u0005O*\u0014i\r\u0005\u0004\u0003\u0012\ne%q\u001a\t\u0007\u0005/\u0012iF!5\u0011\t\t\u0015$1\u001b\u0003\b\u0005S2\"\u0019\u0001B6\u0011%\u00119NFA\u0001\u0002\b\u0011I.\u0001\u0006fm&$WM\\2fIa\u0002bAa\u0016\u0003\u0000\tE\u0007bBA6-\u0001\u000f\u0011QN\u0001\u0017O\u0016$8+\u001e2qe>\u001cWm]:fg\u0012+G/Y5mgR!!\u0011\u001dB})\u0011\u0011\u0019Oa>\u0011\t\u001dT'Q\u001d\t\u0007\u0005\u0003\u00119Oa;\n\t\t%(Q\u0002\u0002\u0004'\u0016$\b\u0003\u0002Bw\u0005gl!Aa<\u000b\u0007\tEX%\u0001\u0006tk\n\u0004(o\\2fgNLAA!>\u0003p\n\t2+\u001e2qe>\u001cWm]:EKR\f\u0017\u000e\\:\t\u000f\u0005-t\u0003q\u0001\u0002n!9!1`\fA\u0002\tu\u0018a\u00049s_\u000e,7o]5oORK\b/Z:\u0011\u000bI\u0012ypa\u0001\n\u0007\r\u00051G\u0001\u0004PaRLwN\u001c\t\u0007\u0005#\u0013Ij!\u0002\u0011\t\u0005\u001d6qA\u0005\u0005\u0007\u0013\tIL\u0001\bQe>\u001cWm]:j]\u001e$\u0016\u0010]3\u0002\u001b%l\u0007o\u001c:u!J|7-Z:t)\u0019\u0019yaa\t\u0004(Q!1\u0011CB\u0011!\u00119'na\u0005\u0011\r\u0005e\u0015qTB\u000b!\u0011\u00199b!\b\u000e\u0005\re!\u0002BB\u000e\u0003\u000f\u000ba\u0002Z5ta2\f\u00170\u001a3he\u0006\u0004\b.\u0003\u0003\u0004 \re!a\u0007,bY&$\u0017\r^3e\t&\u001c\b\u000f\\1zC\ndW\r\u0015:pG\u0016\u001c8\u000fC\u0004\u0002la\u0001\u001d!!\u001c\t\u000f\r\u0015\u0002\u00041\u0001\u0002\u0002\u0006I\u0001O]8dKN\u001c\u0018\n\u001a\u0005\b\u0007SA\u0002\u0019AA\u0000\u0003)Q7o\u001c8TiJLgnZ\u0001\"m\u0006d\u0017\u000eZ1uK&s\u0017\u000e^5bYN\u001bWM\\1sS>\u0004&o\u001c9feRLWm\u001d\u000b\t\u0007_\u0019)e!\u0016\u0004ZA1!\u0011\u0013BM\u0007c\u0001Baa\r\u0004@9!1QGB\u001d\u001d\u0011\tYka\u000e\n\t\u0005U\u0011qQ\u0005\u0005\u0007w\u0019i$A\tWC2LG-\u0019;j_:\u0014Vm];miNTA!!\u0006\u0002\b&!1\u0011IB\"\u0005Mqu\u000eZ3WC2LG-\u0019;j_:,%O]8s\u0015\u0011\u0019Yd!\u0010\t\u000f\r\u001d\u0013\u00041\u0001\u0004J\u0005\u00012-\u00198p]&\u001c\u0017\r\u001c)s_\u000e,7o\u001d\t\u0005\u0007\u0017\u001a\t&\u0004\u0002\u0004N)!1qJAf\u00039\u0019\u0017M\\8oS\u000e\fGn\u001a:ba\"LAaa\u0015\u0004N\t\u00012)\u00198p]&\u001c\u0017\r\u001c)s_\u000e,7o\u001d\u0005\b\u0007/J\u0002\u0019AB\u0003\u00039\u0001(o\\2fgNLgn\u001a+za\u0016Dq!!@\u001a\u0001\u0004\ty0\u0001\u000fe_>s\u0007K]8dKN\u001c8\u000b^1uKZ+'/\u001b4jG\u0006$\u0018n\u001c8\u0016\t\r}31\u000e\u000b\u0007\u0007C\u001aYha\"\u0015\t\r\r4\u0011\u000f\u000b\u0005\u0007K\u001ay\u0007\u0005\u0003hU\u000e\u001d\u0004CBAM\u0003?\u001bI\u0007\u0005\u0003\u0003f\r-DaBB75\t\u0007!1\u000e\u0002\u0002)\"9\u00111\u000e\u000eA\u0004\u00055\u0004\u0002CB:5\u0011\u0005\ra!\u001e\u0002\u0011\r\fG\u000e\u001c2bG.\u0004RAMB<\u0007KJ1a!\u001f4\u0005!a$-\u001f8b[\u0016t\u0004B\u0002\u0014\u001b\u0001\u0004\u0019i\b\r\u0003\u0004\u0000\r\r\u0005C\u0002B,\u0005;\u001a\t\t\u0005\u0003\u0003f\r\rE\u0001DBC\u0007w\n\t\u0011!A\u0003\u0002\t-$aA0%c!91\u0011\u0012\u000eA\u0002\r-\u0015!D1di&|g\u000eV8DQ\u0016\u001c7\u000e\u0005\u0003\u0004\u000e\u000e\u0005f\u0002BBH\u00077sAa!%\u0004\u001a:!11SBL\u001d\u0011\tye!&\n\u0007\u00055\u0017&\u0003\u0003\u0002t\u0005-\u0017bA%\u0002J&!1QTBP\u0003E\u0001&o\\2fgN\f5\r^5p]RK\b/\u001a\u0006\u0004\u0013\u0006%\u0017\u0002BBR\u0007K\u0013\u0011\u0003\u0015:pG\u0016\u001c8/Q2uS>tG+\u001f9f\u0015\u0011\u0019ija(\u0002\u0013\u0011|\u0017I]2iSZ,G\u0003BBV\u0007_#B!!\u0012\u0004.\"9\u00111N\u000eA\u0004\u00055\u0004B\u0002\u0014\u001c\u0001\u0004\u0019\t\f\r\u0003\u00044\u000e]\u0006C\u0002B,\u0005;\u001a)\f\u0005\u0003\u0003f\r]F\u0001DB]\u0007_\u000b\t\u0011!A\u0003\u0002\t-$aA0%e\u0005AAm\u001c*f]\u0006lW\r\u0006\u0004\u0004@\u000e]7\u0011\u001c\u000b\u0005\u0007\u0003\u001c)\u000e\u0005\u0003hU\u000e\r\u0007\u0003CBc\u0007\u0013\u001ci-!*\u000e\u0005\r\u001d'B\u0001>4\u0013\u0011\u0019Yma2\u0003\r\u0015KG\u000f[3s!\u0011\u0019ym!5\u000e\u0003\u001dJ1aa5(\u0005!)5\u000f]#se>\u0014\bbBA69\u0001\u000f\u0011Q\u000e\u0005\b\u0003\u007fb\u0002\u0019AAA\u0011\u001d\t\t\r\ba\u0001\u0003\u0007\f\u0011\u0003^8Qe>\u001cWm]:SKN\u0004xN\\:f)\u0019\u0011Iba8\u0004d\"91\u0011]\u000fA\u0002\u0005\r\u0017a\u00039s_\u000e,7o\u001d(b[\u0016Dqa!:\u001e\u0001\u0004\u00199/A\u0004de\u0016\fG/\u001a3\u0011\t\r%81\u001f\b\u0005\u0007W\u001cyO\u0004\u0003\u0002L\r5\u0018BA0&\u0013\r\u0019\tPX\u0001\u0012!J|7-Z:t%\u0016\u0004xn]5u_JL\u0018\u0002BB{\u0007o\u0014a\u0002\u0015:pG\u0016\u001c8o\u0011:fCR,GMC\u0002\u0004rz\u000b1b^5uQB\u0013xnY3tgV!1Q C\u0005)\u0011\u0019y\u0010\"\u000b\u0015\t\u0011\u0005AQ\u0002\u000b\u0005\t\u0007!Y\u0001\u0005\u0003hU\u0012\u0015\u0001CBAM\u0003?#9\u0001\u0005\u0003\u0003f\u0011%AaBB7=\t\u0007!1\u000e\u0005\b\u0003Wr\u00029AA7\u0011\u001d\u0019\u0019H\ba\u0001\t\u001f\u0001rA\rC\t\t+!\u0019!C\u0002\u0005\u0014M\u0012\u0011BR;oGRLwN\\\u00191\t\u0011]A1\u0004\t\u0007\u0005/\u0012i\u0006\"\u0007\u0011\t\t\u0015D1\u0004\u0003\r\t;!y\"!A\u0001\u0002\u000b\u0005!1\u000e\u0002\u0004?\u0012\u001a\u0004bBB:=\u0001\u0007A\u0011\u0005\t\be\u0011EAQ\u0003C\u0012!\u00119'\u000e\"\n\u0011\r\u0005e\u0015q\u0014C\u0014!\u0011\u0011)\u0007\"\u0003\t\u000f\u0005}d\u00041\u0001\u0002\u0002\u0006\u0019r/\u001b;i\u0003J\u001c\u0007.\u001b<fIB\u0013xnY3tgV!Aq\u0006C\u001e)\u0019!\t\u0004b\u0016\u0005ZQ!A1\u0007C )\u0011!)\u0004\"\u0010\u0011\t\u001dTGq\u0007\t\u0007\u00033\u000by\n\"\u000f\u0011\t\t\u0015D1\b\u0003\b\u0007[z\"\u0019\u0001B6\u0011\u001d\tYg\ba\u0002\u0003[Bqaa\u001d \u0001\u0004!\t\u0005E\u00043\t#!\u0019\u0005\"\u000e1\t\u0011\u0015C\u0011\n\t\u0007\u0005/\u0012i\u0006b\u0012\u0011\t\t\u0015D\u0011\n\u0003\r\t\u0017\"i%!A\u0001\u0002\u000b\u0005!1\u000e\u0002\u0004?\u0012\"\u0004bBB:?\u0001\u0007Aq\n\t\be\u0011EA1\tC)!\u00119'\u000eb\u0015\u0011\r\u0005e\u0015q\u0014C+!\u0011\u0011)\u0007b\u000f\t\u000f\u0005}t\u00041\u0001\u0002\u0002\"9A1L\u0010A\u0002\u0005}\u0018\u0001D3se>\u0014X*Z:tC\u001e,\u0017AF<ji\"tu\u000e^!sG\"Lg/\u001a3Qe>\u001cWm]:\u0016\t\u0011\u0005DQ\u000e\u000b\u0007\tG\"I\tb#\u0015\t\u0011\u0015D\u0011\u000f\u000b\u0005\tO\"y\u0007\u0005\u0003hU\u0012%\u0004CBAM\u0003?#Y\u0007\u0005\u0003\u0003f\u00115DaBB7A\t\u0007!1\u000e\u0005\b\u0003W\u0002\u00039AA7\u0011\u001d\u0019\u0019\b\ta\u0001\tg\u0002rA\rC\t\tk\"9\u0007\r\u0003\u0005x\u0011m\u0004C\u0002B,\u0005;\"I\b\u0005\u0003\u0003f\u0011mD\u0001\u0004C?\t\u007f\n\t\u0011!A\u0003\u0002\t-$aA0%k!911\u000f\u0011A\u0002\u0011\u0005\u0005c\u0002\u001a\u0005\u0012\u0011UD1\u0011\t\u0005O*$)\t\u0005\u0004\u0002\u001a\u0006}Eq\u0011\t\u0005\u0005K\"i\u0007C\u0004\u0002\u0000\u0001\u0002\r!!!\t\u000f\u0011m\u0003\u00051\u0001\u0002\u0000V!Aq\u0012CN)\u0019!\t\nb.\u0005:R!A1\u0013CP)\u0011!)\n\"(\u0011\t\u001dTGq\u0013\t\u0007\u00033\u000by\n\"'\u0011\t\t\u0015D1\u0014\u0003\b\u0007[\n#\u0019\u0001B6\u0011\u001d\tY'\ta\u0002\u0003[Bqaa\u001d\"\u0001\u0004!\t\u000bE\u00043\t#!\u0019\u000b\"&1\t\u0011\u0015F\u0011\u0016\t\u0007\u0005/\u0012i\u0006b*\u0011\t\t\u0015D\u0011\u0016\u0003\r\tW#i+!A\u0001\u0002\u000b\u0005!1\u000e\u0002\u0004?\u00122\u0004bBB:C\u0001\u0007Aq\u0016\t\be\u0011EA1\u0015CY!\u00119'\u000eb-\u0011\r\u0005e\u0015q\u0014C[!\u0011\u0011)\u0007b'\t\u000f\u0005}\u0014\u00051\u0001\u0002\u0002\"9!\u0011I\u0011A\u0002\r-\u0015AE<ji\"\u0004&o\\2fgNLgn\u001a+za\u0016,B\u0001b0\u0005LR!A\u0011\u0019Ci)\u0011!\u0019\r\"4\u0011\t\u001dTGQ\u0019\t\t\u0005##9m!4\u0005J&!11\u001aBO!\u0011\u0011)\u0007b3\u0005\u000f\r5$E1\u0001\u0003l!911\u000f\u0012A\u0002\u0011=\u0007c\u0002\u001a\u0005\u0012\r\u0015A1\u0019\u0005\b\u0003{\u0014\u0003\u0019AA\u0000+\u0011!)\u000e\"9\u0015\u0011\u0011]G\u0011\u001eCv\to$B\u0001\"7\u0005dB!qM\u001bCn!\u0019\u0011\tJ!'\u0005^B1!q\u000bB/\t?\u0004BA!\u001a\u0005b\u00129!\u0011N\u0012C\u0002\t-\u0004\"\u0003CsG\u0005\u0005\t9\u0001Ct\u0003))g/\u001b3f]\u000e,G%\u000f\t\u0007\u0005/\u0012y\bb8\t\u000f\u0005-4\u00051\u0001\u0002n!9AQ^\u0012A\u0002\u0011=\u0018\u0001D5t'V\u0014\u0007O]8dKN\u001c\b#\u0002\u001a\u0003\u0000\u0012E\bc\u0001\u001a\u0005t&\u0019AQ_\u001a\u0003\u000f\t{w\u000e\\3b]\"9A\u0011`\u0012A\u0002\u0011=\u0018AC5t\u0003J\u001c\u0007.\u001b<fI\u0002")
public class DBProcessService
implements ProcessService,
LazyLogging {
    private final DeploymentService deploymentService;
    private final NewProcessPreparer newProcessPreparer;
    private final ProcessCategoryService processCategoryService;
    private final UIProcessResolving processResolving;
    private final DBIOActionRunner dbioRunner;
    private final FetchingProcessRepository<Future> fetchingProcessRepository;
    private final ProcessActionRepository<DBIOAction> processActionRepository;
    private final ProcessRepository<DBIOAction> processRepository;
    private final ProcessValidation processValidation;
    private final ExecutionContext ec;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        DBProcessService dBProcessService = this;
        synchronized (dBProcessService) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public Future<Either<EspError, BoxedUnit>> archiveProcess(ProcessIdWithName processIdWithName, LoggedUser user) {
        return this.withNotArchivedProcess(processIdWithName, ProcessActionType$.MODULE$.Archive(), (Function1 & Serializable)process -> {
            if (process.isSubprocess()) {
                return this.doArchive((processdetails.BaseProcessDetails<?>)process, user);
            }
            return this.doOnProcessStateVerification((processdetails.BaseProcessDetails<?>)process, ProcessActionType$.MODULE$.Archive(), (Function0 & Serializable)() -> this.doArchive((processdetails.BaseProcessDetails<?>)process, user), user);
        }, user);
    }

    @Override
    public Future<Either<EspError, package.UpdateProcessNameResponse>> renameProcess(ProcessIdWithName processIdWithName, ProcessName name, LoggedUser user) {
        return this.withNotArchivedProcess(processIdWithName, "Can't rename archived scenario.", (Function1 & Serializable)process -> {
            if (process.isSubprocess()) {
                return this.doRename(processIdWithName, name, user);
            }
            return this.doOnProcessStateVerification((processdetails.BaseProcessDetails<?>)process, ProcessActionType$.MODULE$.Rename(), (Function0 & Serializable)() -> this.doRename(processIdWithName, name, user), user);
        }, user);
    }

    @Override
    public Future<Either<EspError, BoxedUnit>> unArchiveProcess(ProcessIdWithName processIdWithName, LoggedUser user) {
        return this.withProcess(processIdWithName, (Function1 & Serializable)process -> {
            if (process.isArchived()) {
                return $this.dbioRunner.runInTransaction(DBIOAction$.MODULE$.seq((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DBIOAction[]{$this.processRepository.archive(process.idWithName().id(), false), $this.processActionRepository.markProcessAsUnArchived(process.idWithName().id(), process.processVersionId(), user)}))).map((Function1 & Serializable)x$1 -> EitherIdOps$.MODULE$.asRight$extension(package.either$.MODULE$.catsSyntaxEitherId((Object)BoxedUnit.UNIT)), $this.ec);
            }
            return Future$.MODULE$.apply((Function0 & Serializable)() -> package$.MODULE$.Left().apply((Object)new ProcessIllegalAction("Can't unarchive not archived scenario.")), $this.ec);
        }, user);
    }

    @Override
    public Future<Either<EspError, BoxedUnit>> deleteProcess(ProcessIdWithName processIdWithName, LoggedUser user) {
        return this.withArchivedProcess(processIdWithName, "Can't delete not archived scenario.", (Function1 & Serializable)process -> $this.dbioRunner.runInTransaction($this.processRepository.deleteProcess(processIdWithName.id())).map((Function1 & Serializable)x$2 -> EitherIdOps$.MODULE$.asRight$extension(package.either$.MODULE$.catsSyntaxEitherId((Object)BoxedUnit.UNIT)), $this.ec), user);
    }

    @Override
    public Future<Either<EspError, package.UpdateProcessCategoryResponse>> updateCategory(ProcessIdWithName processIdWithName, String category, LoggedUser user) {
        return this.withNotArchivedProcess(processIdWithName, "Can't update category archived scenario.", (Function1 & Serializable)process -> this.withProcessingType(category, (Function1 & Serializable)x$3 -> $this.dbioRunner.runInTransaction($this.processRepository.updateCategory(processIdWithName.id(), category, user).map((Function1 & Serializable)x0$1 -> {
            Either either = x0$1;
            if (either instanceof Right) {
                return package$.MODULE$.Right().apply((Object)new package.UpdateProcessCategoryResponse(process.processCategory(), category));
            }
            if (either instanceof Left) {
                Left left = (Left)either;
                EspError value = (EspError)left.value();
                return package$.MODULE$.Left().apply((Object)value);
            }
            throw new MatchError((Object)either);
        }, $this.ec))), user);
    }

    @Override
    public Future<Either<EspError, package.ProcessResponse>> createProcess(ProcessService.CreateProcessCommand command, LoggedUser user) {
        return this.withProcessingType(command.category(), (Function1 & Serializable)processingType -> {
            CanonicalProcess emptyCanonicalProcess = $this.newProcessPreparer.prepareEmptyProcess(command.processName().value(), (String)processingType, command.isSubprocess());
            ProcessRepository.CreateProcessAction action = new ProcessRepository.CreateProcessAction(command.processName(), command.category(), emptyCanonicalProcess, (String)processingType, command.isSubprocess(), command.forwardedUserName());
            List<ValidationResults.NodeValidationError> propertiesErrors = this.validateInitialScenarioProperties(emptyCanonicalProcess, (String)processingType, command.category());
            if (propertiesErrors.nonEmpty()) {
                return Future$.MODULE$.successful((Object)package$.MODULE$.Left().apply((Object)new ProcessValidationError(propertiesErrors.map((Function1 & Serializable)x$4 -> x$4.message()).mkString(", "))));
            }
            return $this.dbioRunner.runInTransaction($this.processRepository.saveNewProcess(action, user)).map((Function1 & Serializable)x0$1 -> {
                Either either = x0$1;
                if (either instanceof Right) {
                    Right right = (Right)either;
                    Option maybemaybeCreated = (Option)right.value();
                    return (Either)maybemaybeCreated.map((Function1 & Serializable)created -> package$.MODULE$.Right().apply((Object)this.toProcessResponse(command.processName(), (ProcessRepository.ProcessCreated)created))).getOrElse((Function0 & Serializable)() -> package$.MODULE$.Left().apply((Object)new ProcessValidationError("Unknown error on creating scenario.")));
                }
                if (either instanceof Left) {
                    Left left = (Left)either;
                    EspError value = (EspError)left.value();
                    return package$.MODULE$.Left().apply((Object)value);
                }
                throw new MatchError((Object)either);
            }, $this.ec);
        });
    }

    @Override
    public Future<Either<EspError, package.UpdateProcessResponse>> updateProcess(ProcessIdWithName processIdWithName, ProcessService.UpdateProcessCommand action, LoggedUser user) {
        return this.withNotArchivedProcess(processIdWithName, "Can't update graph archived scenario.", (Function1 & Serializable)process -> {
            EitherT result = EitherT.FromEitherPartiallyApplied$.MODULE$.apply$extension(EitherT$.MODULE$.fromEither(), FatalValidationError$.MODULE$.saveNotAllowedAsError($this.processResolving.validateBeforeUiResolving(action.process())), (Applicative)package.future$.MODULE$.catsStdInstancesForFuture($this.ec)).map((Function1 & Serializable)validation -> {
                CanonicalProcess substituted = $this.processResolving.resolveExpressions(action.process(), (Map<String, Map<String, ExpressionTypingInfo>>)validation.typingInfo());
                ProcessRepository.UpdateProcessAction updateProcessAction = new ProcessRepository.UpdateProcessAction(processIdWithName.id(), substituted, (Option<Comment>)Option$.MODULE$.apply((Object)action.comment()), false, action.forwardedUserName());
                return new Tuple3(validation, (Object)substituted, (Object)updateProcessAction);
            }, (Functor)package.future$.MODULE$.catsStdInstancesForFuture($this.ec)).flatMap((Function1 & Serializable)x$7 -> {
                Tuple3 tuple3 = x$7;
                if (tuple3 != null) {
                    ValidationResults.ValidationResult validation = (ValidationResults.ValidationResult)tuple3._1();
                    ProcessRepository.UpdateProcessAction updateProcessAction = (ProcessRepository.UpdateProcessAction)tuple3._3();
                    return new EitherT($this.dbioRunner.runInTransaction($this.processRepository.updateProcess(updateProcessAction, user))).map((Function1 & Serializable)processUpdated -> new package.UpdateProcessResponse(processUpdated.newVersion().map((Function1 & Serializable)x$5 -> new ProcessRepository.ProcessCreated(processIdWithName.id(), (VersionId)x$5)).map((Function1 & Serializable)x$6 -> this.toProcessResponse(processIdWithName.name(), (ProcessRepository.ProcessCreated)x$6)), validation), (Functor)package.future$.MODULE$.catsStdInstancesForFuture($this.ec));
                }
                throw new MatchError((Object)tuple3);
            }, (Monad)package.future$.MODULE$.catsStdInstancesForFuture($this.ec));
            return (Future)result.value();
        }, user);
    }

    @Override
    public <PS> Future<Either<EspError, processdetails.BaseProcessDetails<PS>>> getProcess(ProcessIdWithName processIdWithName, processdetails.ProcessShapeFetchStrategy<PS> evidence$5, LoggedUser user) {
        return this.fetchingProcessRepository.fetchLatestProcessDetailsForProcessId(processIdWithName.id(), evidence$5, user, this.ec).flatMap((Function1 & Serializable)x0$1 -> {
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                processdetails.BaseProcessDetails process = (processdetails.BaseProcessDetails)some.value();
                return Future$.MODULE$.apply((Function0 & Serializable)() -> package$.MODULE$.Right().apply((Object)process), $this.ec);
            }
            if (None$.MODULE$.equals(option)) {
                return Future$.MODULE$.apply((Function0 & Serializable)() -> package$.MODULE$.Left().apply((Object)new ProcessDBQueryRepository.ProcessNotFoundError(Long.toString(processIdWithName.id().value()))), $this.ec);
            }
            throw new MatchError((Object)option);
        }, this.ec);
    }

    @Override
    public <PS> Future<List<processdetails.BaseProcessDetails<PS>>> getProcesses(processdetails.ProcessShapeFetchStrategy<PS> evidence$6, LoggedUser user) {
        return this.getProcesses(user, (Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)), (Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)), evidence$6);
    }

    @Override
    public <PS> Future<List<processdetails.BaseProcessDetails<PS>>> getProcessesAndSubprocesses(processdetails.ProcessShapeFetchStrategy<PS> evidence$7, LoggedUser user) {
        return this.getProcesses(user, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)), evidence$7);
    }

    @Override
    public <PS> Future<List<processdetails.BaseProcessDetails<PS>>> getArchivedProcessesAndSubprocesses(processdetails.ProcessShapeFetchStrategy<PS> evidence$8, LoggedUser user) {
        return this.getProcesses(user, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)), evidence$8);
    }

    @Override
    public Future<Set<SubprocessDetails>> getSubprocessesDetails(Option<List<String>> processingTypes, LoggedUser user) {
        Some x$1 = new Some((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Some x$2 = new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Option<List<String>> x$3 = processingTypes;
        Option<Object> x$4 = FetchingProcessRepository$FetchProcessesDetailsQuery$.MODULE$.apply$default$3();
        Option<Seq<String>> x$5 = FetchingProcessRepository$FetchProcessesDetailsQuery$.MODULE$.apply$default$4();
        Option<Seq<ProcessName>> x$6 = FetchingProcessRepository$FetchProcessesDetailsQuery$.MODULE$.apply$default$6();
        return this.fetchingProcessRepository.fetchProcessesDetails(new FetchingProcessRepository.FetchProcessesDetailsQuery((Option<Object>)x$1, (Option<Object>)x$2, x$4, x$5, x$3, x$6), processdetails.ProcessShapeFetchStrategy$.FetchCanonical$.MODULE$, user, this.ec).map((Function1 & Serializable)processes -> processes.map((Function1 & Serializable)sub -> new SubprocessDetails((CanonicalProcess)sub.json(), sub.processCategory())).toSet(), this.ec);
    }

    @Override
    public Future<Either<EspError, ValidatedDisplayableProcess>> importProcess(ProcessIdWithName processId, String jsonString, LoggedUser user) {
        return this.withNotArchivedProcess(processId, "Import is not allowed for archived process.", (Function1 & Serializable)process -> {
            Either result = ProcessMarshaller$.MODULE$.fromJson(jsonString).leftMap((Function1)ProcessesResources$UnmarshallError$.MODULE$).toEither().map((Function1 & Serializable)jsonCanonicalProcess -> {
                CanonicalProcess canonical = jsonCanonicalProcess.withProcessId(processId.name());
                DisplayableProcess displayable = ProcessConverter$.MODULE$.toDisplayable(canonical, process.processingType(), process.processCategory());
                ValidationResults.ValidationResult validationResult = $this.processResolving.validateBeforeUiReverseResolving(canonical, displayable.processingType(), process.processCategory());
                return new ValidatedDisplayableProcess(displayable, validationResult);
            });
            return Future$.MODULE$.successful((Object)result);
        }, user);
    }

    private List<ValidationResults.NodeValidationError> validateInitialScenarioProperties(CanonicalProcess canonicalProcess, String processingType, String category) {
        ValidationResults.ValidationResult validationResult = this.processValidation.processingTypeValidationWithTypingInfo(canonicalProcess, processingType, category);
        return validationResult.errors().processPropertiesErrors();
    }

    private <T> Future<Either<EspError, T>> doOnProcessStateVerification(processdetails.BaseProcessDetails<?> process, Enumeration.Value actionToCheck, Function0<Future<Either<EspError, T>>> callback, LoggedUser user) {
        DataFreshnessPolicy.Fresh$ freshnessPolicy = DataFreshnessPolicy.Fresh$.MODULE$;
        return this.deploymentService.getProcessState(process, user, this.ec, (DataFreshnessPolicy)freshnessPolicy).flatMap((Function1 & Serializable)state -> {
            if (state.allowedActions().contains((Object)actionToCheck)) {
                return (Future)callback.apply();
            }
            return Future$.MODULE$.apply((Function0 & Serializable)() -> package$.MODULE$.Left().apply((Object)ProcessIllegalAction$.MODULE$.apply(actionToCheck, process.idWithName(), (ProcessState)state)), $this.ec);
        }, this.ec);
    }

    private Future<Either<EspError, BoxedUnit>> doArchive(processdetails.BaseProcessDetails<?> process, LoggedUser user) {
        return this.dbioRunner.runInTransaction(DBIOAction$.MODULE$.seq((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DBIOAction[]{this.processRepository.archive(process.idWithName().id(), true), this.processActionRepository.markProcessAsArchived(process.idWithName().id(), process.processVersionId(), user)}))).map((Function1 & Serializable)x$8 -> EitherIdOps$.MODULE$.asRight$extension(package.either$.MODULE$.catsSyntaxEitherId((Object)BoxedUnit.UNIT)), this.ec);
    }

    private Future<Either<EspError, package.UpdateProcessNameResponse>> doRename(ProcessIdWithName processIdWithName, ProcessName name, LoggedUser user) {
        return this.dbioRunner.runInTransaction(this.processRepository.renameProcess(processIdWithName, name, user).map((Function1 & Serializable)x0$1 -> {
            Either either = x0$1;
            if (either instanceof Right) {
                return package$.MODULE$.Right().apply((Object)package.UpdateProcessNameResponse$.MODULE$.create(processIdWithName.name().value(), name.value()));
            }
            if (either instanceof Left) {
                Left left = (Left)either;
                EspError value = (EspError)left.value();
                return package$.MODULE$.Left().apply((Object)value);
            }
            throw new MatchError((Object)either);
        }, this.ec));
    }

    private package.ProcessResponse toProcessResponse(ProcessName processName, ProcessRepository.ProcessCreated created) {
        return new package.ProcessResponse(created.processId(), created.processVersionId(), processName);
    }

    private <T> Future<Either<EspError, T>> withProcess(ProcessIdWithName processIdWithName, Function1<processdetails.BaseProcessDetails<?>, Future<Either<EspError, T>>> callback, LoggedUser user) {
        return this.getProcess(processIdWithName, (processdetails.ProcessShapeFetchStrategy)processdetails.ProcessShapeFetchStrategy$.NotFetch$.MODULE$, user).flatMap((Function1 & Serializable)x0$1 -> {
            Either either = x0$1;
            if (either instanceof Left) {
                Left left = (Left)either;
                EspError err = (EspError)left.value();
                return Future$.MODULE$.apply((Function0 & Serializable)() -> package$.MODULE$.Left().apply((Object)err), $this.ec);
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                processdetails.BaseProcessDetails t = (processdetails.BaseProcessDetails)right.value();
                return (Future)callback.apply((Object)t);
            }
            throw new MatchError((Object)either);
        }, this.ec);
    }

    private <T> Future<Either<EspError, T>> withArchivedProcess(ProcessIdWithName processIdWithName, String errorMessage, Function1<processdetails.BaseProcessDetails<?>, Future<Either<EspError, T>>> callback, LoggedUser user) {
        return this.withProcess(processIdWithName, (Function1 & Serializable)process -> {
            if (process.isArchived()) {
                return (Future)callback.apply(process);
            }
            return Future$.MODULE$.apply((Function0 & Serializable)() -> package$.MODULE$.Left().apply((Object)new ProcessIllegalAction(errorMessage)), $this.ec);
        }, user);
    }

    private <T> Future<Either<EspError, T>> withNotArchivedProcess(ProcessIdWithName processIdWithName, String errorMessage, Function1<processdetails.BaseProcessDetails<?>, Future<Either<EspError, T>>> callback, LoggedUser user) {
        return this.withProcess(processIdWithName, (Function1 & Serializable)process -> {
            if (process.isArchived()) {
                return Future$.MODULE$.apply((Function0 & Serializable)() -> package$.MODULE$.Left().apply((Object)new ProcessIllegalAction(errorMessage)), $this.ec);
            }
            return (Future)callback.apply(process);
        }, user);
    }

    private <T> Future<Either<EspError, T>> withNotArchivedProcess(ProcessIdWithName processIdWithName, Enumeration.Value action, Function1<processdetails.BaseProcessDetails<?>, Future<Either<EspError, T>>> callback, LoggedUser user) {
        return this.withProcess(processIdWithName, (Function1 & Serializable)process -> {
            if (process.isArchived()) {
                return Future$.MODULE$.apply((Function0 & Serializable)() -> package$.MODULE$.Left().apply((Object)ProcessIllegalAction$.MODULE$.archived(action, process.idWithName())), $this.ec);
            }
            return (Future)callback.apply(process);
        }, user);
    }

    private <T> Future<Either<EspError, T>> withProcessingType(String category, Function1<String, Future<Either<EspError, T>>> callback) {
        Option<String> option = this.processCategoryService.getTypeForCategory(category);
        if (option instanceof Some) {
            Some some = (Some)option;
            String processingType = (String)some.value();
            return (Future)callback.apply((Object)processingType);
        }
        if (None$.MODULE$.equals(option)) {
            return Future$.MODULE$.apply((Function0 & Serializable)() -> package$.MODULE$.Left().apply((Object)new ProcessValidationError("Scenario category not found.")), this.ec);
        }
        throw new MatchError(option);
    }

    private <PS> Future<List<processdetails.BaseProcessDetails<PS>>> getProcesses(LoggedUser user, Option<Object> isSubprocess, Option<Object> isArchived, processdetails.ProcessShapeFetchStrategy<PS> evidence$9) {
        List<String> userCategories = this.processCategoryService.getUserCategories(user);
        processdetails.ProcessShapeFetchStrategy shapeStrategy = (processdetails.ProcessShapeFetchStrategy)Predef$.MODULE$.implicitly(evidence$9);
        Option<Object> x$1 = isSubprocess;
        Option<Object> x$2 = isArchived;
        Some x$3 = new Some(userCategories);
        Option<Object> x$4 = FetchingProcessRepository$FetchProcessesDetailsQuery$.MODULE$.apply$default$3();
        Option<Seq<String>> x$5 = FetchingProcessRepository$FetchProcessesDetailsQuery$.MODULE$.apply$default$5();
        Option<Seq<ProcessName>> x$6 = FetchingProcessRepository$FetchProcessesDetailsQuery$.MODULE$.apply$default$6();
        return this.fetchingProcessRepository.fetchProcessesDetails(new FetchingProcessRepository.FetchProcessesDetailsQuery(x$1, x$2, x$4, (Option<Seq<String>>)x$3, x$5, x$6), shapeStrategy, user, this.ec);
    }

    public DBProcessService(DeploymentService deploymentService, NewProcessPreparer newProcessPreparer, ProcessCategoryService processCategoryService, UIProcessResolving processResolving, DBIOActionRunner dbioRunner, FetchingProcessRepository<Future> fetchingProcessRepository, ProcessActionRepository<DBIOAction> processActionRepository, ProcessRepository<DBIOAction> processRepository, ProcessValidation processValidation, ExecutionContext ec) {
        this.deploymentService = deploymentService;
        this.newProcessPreparer = newProcessPreparer;
        this.processCategoryService = processCategoryService;
        this.processResolving = processResolving;
        this.dbioRunner = dbioRunner;
        this.fetchingProcessRepository = fetchingProcessRepository;
        this.processActionRepository = processActionRepository;
        this.processRepository = processRepository;
        this.processValidation = processValidation;
        this.ec = ec;
        LazyLogging.$init$((LazyLogging)this);
    }
}

