/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.component;

import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.data.Validated;
import cats.data.Validated$;
import java.io.Serializable;
import pl.touk.nussknacker.engine.api.component.ComponentGroupName;
import pl.touk.nussknacker.engine.api.component.ComponentId;
import pl.touk.nussknacker.engine.definition.component.ComponentIdProvider;
import pl.touk.nussknacker.restmodel.definition.package;
import pl.touk.nussknacker.ui.component.ComponentConfigurationException;
import pl.touk.nussknacker.ui.component.ComponentObjects;
import pl.touk.nussknacker.ui.component.ComponentValidationData;
import pl.touk.nussknacker.ui.component.ComponentWrongConfiguration;
import pl.touk.nussknacker.ui.component.DefaultComponentService$;
import pl.touk.nussknacker.ui.component.WrongConfigurationAttribute$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;

public final class ComponentsValidator$ {
    public static final ComponentsValidator$ MODULE$ = new ComponentsValidator$();

    public void checkUnsafe(Map<String, ComponentObjects> componentObjectsMap, ComponentIdProvider componentIdProvider) {
        List components = componentObjectsMap.toList().flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String processingType = (String)tuple2._1();
                ComponentObjects componentObjects = (ComponentObjects)tuple2._2();
                return MODULE$.extractComponents(processingType, componentObjects, componentIdProvider);
            }
            throw new MatchError((Object)tuple2);
        });
        this.validateComponents((List<ComponentValidationData>)components).valueOr((Function1 & Serializable)wrongConfigurations -> {
            throw new ComponentConfigurationException("Wrong configured components were found.", (NonEmptyList<ComponentWrongConfiguration<?>>)wrongConfigurations);
        });
    }

    private List<ComponentValidationData> extractComponents(String processingType, ComponentObjects componentObjects, ComponentIdProvider componentIdProvider) {
        return componentObjects.templates().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                ComponentGroupName groupName = (ComponentGroupName)tuple2._1();
                package.ComponentNodeTemplate com = (package.ComponentNodeTemplate)tuple2._2();
                String componentId = componentIdProvider.createComponentId(processingType, com.componentInfo());
                String icon = DefaultComponentService$.MODULE$.getComponentIcon(componentObjects.config(), com);
                return new ComponentValidationData(componentId, com.label(), icon, com.type(), groupName);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private Validated<NonEmptyList<ComponentWrongConfiguration<?>>, BoxedUnit> validateComponents(List<ComponentValidationData> components) {
        List wrongComponents = ((List)components.groupBy((Function1 & Serializable)x$1 -> new ComponentId(x$1.id())).toList().sortBy((Function1 & Serializable)x$2 -> ((ComponentId)x$2._1()).value(), (Ordering)Ordering.String$.MODULE$)).flatMap((Function1 & Serializable)x0$1 -> {
            .colon.colon colon2;
            List list;
            List list2;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null && (list2 = (List)tuple2._2()) instanceof .colon.colon && Nil$.MODULE$.equals(list = (colon2 = (.colon.colon)list2).next$access$1())) {
                return Nil$.MODULE$;
            }
            if (tuple2 != null) {
                String componentId = ((ComponentId)tuple2._1()).value();
                List components = (List)tuple2._2();
                return MODULE$.computeWrongConfigurations(componentId, (Iterable<ComponentValidationData>)components);
            }
            throw new MatchError((Object)tuple2);
        });
        Option option = NonEmptyList$.MODULE$.fromList(wrongComponents);
        if (None$.MODULE$.equals(option)) {
            return Validated$.MODULE$.valid((Object)BoxedUnit.UNIT);
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            NonEmptyList nonEmptyWrongComponents = (NonEmptyList)some.value();
            return Validated$.MODULE$.invalid((Object)nonEmptyWrongComponents);
        }
        throw new MatchError((Object)option);
    }

    private List<ComponentWrongConfiguration<?>> computeWrongConfigurations(String componentId, Iterable<ComponentValidationData> components) {
        Option wrongConfiguredNames = ComponentsValidator$.checkUniqueAttributeValue$1(WrongConfigurationAttribute$.MODULE$.NameAttribute(), (Iterable)components.map((Function1 & Serializable)x$3 -> x$3.name()), componentId);
        Option wrongConfiguredIcons = ComponentsValidator$.checkUniqueAttributeValue$1(WrongConfigurationAttribute$.MODULE$.IconAttribute(), (Iterable)components.map((Function1 & Serializable)x$4 -> x$4.icon()), componentId);
        Option wrongConfiguredTypes = ComponentsValidator$.checkUniqueAttributeValue$1(WrongConfigurationAttribute$.MODULE$.ComponentTypeAttribute(), (Iterable)components.map((Function1 & Serializable)x$5 -> x$5.componentType()), componentId);
        Option wrongConfiguredGroups = ComponentsValidator$.checkUniqueAttributeValue$1(WrongConfigurationAttribute$.MODULE$.ComponentGroupNameAttribute(), (Iterable)components.map((Function1 & Serializable)x$6 -> x$6.componentGroupName()), componentId);
        Iterable wrongConfigurations = (Iterable)((IterableOps)((IterableOps)Option$.MODULE$.option2Iterable(wrongConfiguredNames).$plus$plus((IterableOnce)wrongConfiguredIcons)).$plus$plus((IterableOnce)wrongConfiguredTypes)).$plus$plus((IterableOnce)wrongConfiguredGroups);
        return wrongConfigurations.toList();
    }

    private static final Option checkUniqueAttributeValue$1(Enumeration.Value attribute, Iterable values, String componentId$1) {
        .colon.colon colon2;
        List list;
        List list2 = (List)values.toList().distinct();
        if (list2 instanceof .colon.colon && Nil$.MODULE$.equals(list = (colon2 = (.colon.colon)list2).next$access$1())) {
            return None$.MODULE$;
        }
        return new Some(new ComponentWrongConfiguration(componentId$1, attribute, list2));
    }

    private ComponentsValidator$() {
    }
}

