/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.notifications;

import java.io.Serializable;
import java.time.Clock;
import java.time.Instant;
import pl.touk.nussknacker.engine.api.deployment.ProcessActionId;
import pl.touk.nussknacker.engine.api.deployment.ProcessActionState$;
import pl.touk.nussknacker.engine.api.deployment.ProcessActionType$;
import pl.touk.nussknacker.engine.api.process.ProcessName;
import pl.touk.nussknacker.ui.db.entity.ProcessActionEntityData;
import pl.touk.nussknacker.ui.notifications.Notification;
import pl.touk.nussknacker.ui.notifications.Notification$;
import pl.touk.nussknacker.ui.notifications.NotificationConfig;
import pl.touk.nussknacker.ui.notifications.NotificationService;
import pl.touk.nussknacker.ui.notifications.NotificationServiceImpl$;
import pl.touk.nussknacker.ui.process.repository.DBIOActionRunner;
import pl.touk.nussknacker.ui.process.repository.DbProcessActionRepository;
import pl.touk.nussknacker.ui.security.api.LoggedUser;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import slick.dbio.DBIOAction;

@ScalaSignature(bytes="\u0006\u0005\u0005=a\u0001B\u0006\r\u0001]A\u0001B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\t{\u0001\u0011\t\u0011)A\u0005}!A\u0011\t\u0001B\u0001B\u0003%!\t\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003G\u0011\u0015q\u0005\u0001\"\u0001P\u0011\u0015i\u0001\u0001\"\u0011V\u000f\u001d9H\"!A\t\u0002a4qa\u0003\u0007\u0002\u0002#\u0005\u0011\u0010C\u0003O\u0011\u0011\u0005!\u0010C\u0004|\u0011E\u0005I\u0011\u0001?\u0003/9{G/\u001b4jG\u0006$\u0018n\u001c8TKJ4\u0018nY3J[Bd'BA\u0007\u000f\u00035qw\u000e^5gS\u000e\fG/[8og*\u0011q\u0002E\u0001\u0003k&T!!\u0005\n\u0002\u00179,8o]6oC\u000e\\WM\u001d\u0006\u0003'Q\tA\u0001^8vW*\tQ#\u0001\u0002qY\u000e\u00011c\u0001\u0001\u0019=A\u0011\u0011\u0004H\u0007\u00025)\t1$A\u0003tG\u0006d\u0017-\u0003\u0002\u001e5\t1\u0011I\\=SK\u001a\u0004\"a\b\u0011\u000e\u00031I!!\t\u0007\u0003'9{G/\u001b4jG\u0006$\u0018n\u001c8TKJ4\u0018nY3\u0002!\u0005\u001cG/[8o%\u0016\u0004xn]5u_JL\bc\u0001\u0013*W5\tQE\u0003\u0002'O\u0005Q!/\u001a9pg&$xN]=\u000b\u0005!r\u0011a\u00029s_\u000e,7o]\u0005\u0003U\u0015\u0012\u0011\u0004\u00122Qe>\u001cWm]:BGRLwN\u001c*fa>\u001c\u0018\u000e^8ssB\u0011AF\u000f\b\u0003[]r!A\f\u001b\u000f\u0005=\u0012T\"\u0001\u0019\u000b\u0005E2\u0012A\u0002\u001fs_>$h(C\u00014\u0003\t!'-\u0003\u00026m\u0005!Q\u000f^5m\u0015\u0005\u0019\u0014B\u0001\u001d:\u0003M!%)S(BGRLwN\\%ogR\fgnY3t\u0015\t)d'\u0003\u0002<y\t\u0011AI\u0011\u0006\u0003qe\n!\u0002\u001a2j_J+hN\\3s!\t!s(\u0003\u0002AK\t\u0001BIQ%P\u0003\u000e$\u0018n\u001c8Sk:tWM]\u0001\u0007G>tg-[4\u0011\u0005}\u0019\u0015B\u0001#\r\u0005Iqu\u000e^5gS\u000e\fG/[8o\u0007>tg-[4\u0002\u000b\rdwnY6\u0011\u0005\u001dcU\"\u0001%\u000b\u0005%S\u0015\u0001\u0002;j[\u0016T\u0011aS\u0001\u0005U\u00064\u0018-\u0003\u0002N\u0011\n)1\t\\8dW\u00061A(\u001b8jiz\"R\u0001U)S'R\u0003\"a\b\u0001\t\u000b\t*\u0001\u0019A\u0012\t\u000bu*\u0001\u0019\u0001 \t\u000b\u0005+\u0001\u0019\u0001\"\t\u000f\u0015+\u0001\u0013!a\u0001\rR\u0019a\u000b\u001b:\u0011\u0007]SF,D\u0001Y\u0015\tI&$\u0001\u0006d_:\u001cWO\u001d:f]RL!a\u0017-\u0003\r\u0019+H/\u001e:f!\ri&-\u001a\b\u0003=\u0002t!aL0\n\u0003mI!!\u0019\u000e\u0002\u000fA\f7m[1hK&\u00111\r\u001a\u0002\u0005\u0019&\u001cHO\u0003\u0002b5A\u0011qDZ\u0005\u0003O2\u0011ABT8uS\u001aL7-\u0019;j_:DQ!\u001b\u0004A\u0004)\fA!^:feB\u00111\u000e]\u0007\u0002Y*\u0011QN\\\u0001\u0004CBL'BA8\u000f\u0003!\u0019XmY;sSRL\u0018BA9m\u0005)aunZ4fIV\u001bXM\u001d\u0005\u0006g\u001a\u0001\u001d\u0001^\u0001\u0003K\u000e\u0004\"aV;\n\u0005YD&\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0003]qu\u000e^5gS\u000e\fG/[8o'\u0016\u0014h/[2f\u00136\u0004H\u000e\u0005\u0002 \u0011M\u0011\u0001\u0002\u0007\u000b\u0002q\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQ*\u0012! \u0016\u0003\rz\\\u0013a \t\u0005\u0003\u0003\tY!\u0004\u0002\u0002\u0004)!\u0011QAA\u0004\u0003%)hn\u00195fG.,GMC\u0002\u0002\ni\t!\"\u00198o_R\fG/[8o\u0013\u0011\ti!a\u0001\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class NotificationServiceImpl
implements NotificationService {
    private final DbProcessActionRepository<DBIOAction> actionRepository;
    private final DBIOActionRunner dbioRunner;
    private final NotificationConfig config;
    private final Clock clock;

    public static Clock $lessinit$greater$default$4() {
        return NotificationServiceImpl$.MODULE$.$lessinit$greater$default$4();
    }

    @Override
    public Future<List<Notification>> notifications(LoggedUser user, ExecutionContext ec) {
        Instant now = this.clock.instant();
        Instant limit = now.minusMillis(this.config.duration().toMillis());
        return this.dbioRunner.run(this.actionRepository.getUserActionsAfter(user, (Set<Enumeration.Value>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{ProcessActionType$.MODULE$.Deploy(), ProcessActionType$.MODULE$.Cancel()}))), (Set<Enumeration.Value>)((Set)ProcessActionState$.MODULE$.FinishedStates().$plus((Object)ProcessActionState$.MODULE$.Failed())), limit)).map((Function1 & Serializable)x$1 -> ((IterableOnceOps)x$1.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                ProcessActionEntityData processActionEntityData = (ProcessActionEntityData)tuple2._1();
                ProcessName processName = (ProcessName)tuple2._2();
                if (processActionEntityData != null) {
                    ProcessActionId id = processActionEntityData.id();
                    Enumeration.Value actionType = processActionEntityData.actionType();
                    Enumeration.Value value = processActionEntityData.state();
                    Enumeration.Value value2 = ProcessActionState$.MODULE$.Finished();
                    Enumeration.Value value3 = value;
                    if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                        return Notification$.MODULE$.actionFinishedNotification(id.toString(), actionType, processName);
                    }
                }
            }
            if (tuple2 != null) {
                ProcessActionEntityData processActionEntityData = (ProcessActionEntityData)tuple2._1();
                ProcessName processName = (ProcessName)tuple2._2();
                if (processActionEntityData != null) {
                    ProcessActionId id = processActionEntityData.id();
                    Enumeration.Value actionType = processActionEntityData.actionType();
                    Enumeration.Value value = processActionEntityData.state();
                    Enumeration.Value value4 = ProcessActionState$.MODULE$.ExecutionFinished();
                    Enumeration.Value value5 = value;
                    if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                        return Notification$.MODULE$.actionExecutionFinishedNotification(id.toString(), actionType, processName);
                    }
                }
            }
            if (tuple2 != null) {
                ProcessActionEntityData processActionEntityData = (ProcessActionEntityData)tuple2._1();
                ProcessName processName = (ProcessName)tuple2._2();
                if (processActionEntityData != null) {
                    ProcessActionId id = processActionEntityData.id();
                    Enumeration.Value actionType = processActionEntityData.actionType();
                    Enumeration.Value value = processActionEntityData.state();
                    Option<String> failureMessageOpt = processActionEntityData.failureMessage();
                    Enumeration.Value value6 = ProcessActionState$.MODULE$.Failed();
                    Enumeration.Value value7 = value;
                    if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                        return Notification$.MODULE$.actionFailedNotification(id.toString(), actionType, processName, failureMessageOpt);
                    }
                }
            }
            if (tuple2 != null) {
                ProcessActionEntityData a = (ProcessActionEntityData)tuple2._1();
                ProcessName processName = (ProcessName)tuple2._2();
                throw new IllegalStateException("Unexpected action returned by query: " + a + ", for scenario: " + processName);
            }
            throw new MatchError((Object)tuple2);
        })).toList(), ec);
    }

    public NotificationServiceImpl(DbProcessActionRepository<DBIOAction> actionRepository, DBIOActionRunner dbioRunner, NotificationConfig config, Clock clock) {
        this.actionRepository = actionRepository;
        this.dbioRunner = dbioRunner;
        this.config = config;
        this.clock = clock;
    }
}

