/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.process.repository;

import cats.Monad;
import cats.data.OptionT;
import cats.data.OptionT$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import db.util.DBIOActionInstances$;
import java.io.Serializable;
import java.time.Instant;
import pl.touk.nussknacker.engine.api.deployment.ProcessAction;
import pl.touk.nussknacker.engine.api.deployment.ProcessActionState$;
import pl.touk.nussknacker.engine.api.deployment.ProcessActionType$;
import pl.touk.nussknacker.engine.api.displayedgraph.DisplayableProcess;
import pl.touk.nussknacker.engine.api.process.ProcessId;
import pl.touk.nussknacker.engine.api.process.ProcessName;
import pl.touk.nussknacker.engine.api.process.ScenarioVersion;
import pl.touk.nussknacker.engine.api.process.VersionId;
import pl.touk.nussknacker.engine.canonicalgraph.CanonicalProcess;
import pl.touk.nussknacker.restmodel.component.ScenarioComponentsUsages;
import pl.touk.nussknacker.ui.db.DbRef;
import pl.touk.nussknacker.ui.db.entity.ProcessEntityData;
import pl.touk.nussknacker.ui.db.entity.ProcessEntityFactory;
import pl.touk.nussknacker.ui.db.entity.ProcessVersionEntityData;
import pl.touk.nussknacker.ui.db.entity.TagsEntityData;
import pl.touk.nussknacker.ui.process.ScenarioQuery;
import pl.touk.nussknacker.ui.process.marshall.ProcessConverter$;
import pl.touk.nussknacker.ui.process.repository.DBFetchingProcessRepository$;
import pl.touk.nussknacker.ui.process.repository.FetchingProcessRepository;
import pl.touk.nussknacker.ui.process.repository.ProcessActionRepository;
import pl.touk.nussknacker.ui.process.repository.ProcessDBQueryRepository;
import pl.touk.nussknacker.ui.process.repository.ProcessDBQueryRepository$;
import pl.touk.nussknacker.ui.process.repository.ScenarioShapeFetchStrategy;
import pl.touk.nussknacker.ui.process.repository.ScenarioShapeFetchStrategy$FetchCanonical$;
import pl.touk.nussknacker.ui.process.repository.ScenarioShapeFetchStrategy$FetchComponentsUsages$;
import pl.touk.nussknacker.ui.process.repository.ScenarioShapeFetchStrategy$FetchDisplayable$;
import pl.touk.nussknacker.ui.process.repository.ScenarioShapeFetchStrategy$NotFetch$;
import pl.touk.nussknacker.ui.process.repository.ScenarioWithDetailsEntity;
import pl.touk.nussknacker.ui.security.api.LoggedUser;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.LinearSeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import slick.ast.BaseTypedType;
import slick.ast.TypedType;
import slick.dbio.DBIOAction;
import slick.dbio.Effect;
import slick.dbio.NoStream;
import slick.jdbc.JdbcActionComponent;
import slick.lifted.BaseColumnExtensionMethods;
import slick.lifted.BooleanColumnExtensionMethods$;
import slick.lifted.CanBeQueryCondition$;
import slick.lifted.OptionMapper2$;
import slick.lifted.Rep;
import slick.lifted.Shape$;

@ScalaSignature(bytes="\u0006\u0005\r%w!\u0002\r\u001a\u0011\u00031c!\u0002\u0015\u001a\u0011\u0003I\u0003\"\u0002\u0019\u0002\t\u0003\t\u0004\"\u0002\u001a\u0002\t\u0003\u0019\u0004bBBV\u0003\u0011\u00051Q\u0016\u0004\u0006Qe\t\t!\u000f\u0005\t-\u0016\u0011)\u0019!C\u0001/\"Aa,\u0002B\u0001B\u0003%\u0001\f\u0003\u0005`\u000b\t\u0005\t\u0015!\u0003a\u0011!!XAaA!\u0002\u0017)\b\"\u0002\u0019\u0006\t\u0003Y\bbBA\u0002\u000b\u0011\u0005\u0013Q\u0001\u0005\b\u0003K*A\u0011BA4\u0011\u001d\ti/\u0002C\u0005\u0003_DqAa\u000f\u0006\t\u0003\u0012i\u0004C\u0004\u0003\\\u0015!\tE!\u0018\t\u000f\t\u0015U\u0001\"\u0011\u0003\b\"9!1T\u0003\u0005\u0002\tu\u0005b\u0002BU\u000b\u0011\u0005#1\u0016\u0005\b\u0005{+A\u0011\tB`\u0011\u001d\u0011\t0\u0002C\u0005\u0005gDqaa\u0004\u0006\t\u0013\u0019\t\u0002C\u0004\u0004B\u0015!Iaa\u0011\t\u000f\r%U\u0001\"\u0003\u0004\f\u0006YBI\u0011$fi\u000eD\u0017N\\4Qe>\u001cWm]:SKB|7/\u001b;pefT!AG\u000e\u0002\u0015I,\u0007o\\:ji>\u0014\u0018P\u0003\u0002\u001d;\u00059\u0001O]8dKN\u001c(B\u0001\u0010 \u0003\t)\u0018N\u0003\u0002!C\u0005Ya.^:tW:\f7m[3s\u0015\t\u00113%\u0001\u0003u_V\\'\"\u0001\u0013\u0002\u0005Ad7\u0001\u0001\t\u0003O\u0005i\u0011!\u0007\u0002\u001c\t\n3U\r^2iS:<\u0007K]8dKN\u001c(+\u001a9pg&$xN]=\u0014\u0005\u0005Q\u0003CA\u0016/\u001b\u0005a#\"A\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u0005=b#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002M\u000511M]3bi\u0016$R\u0001NBT\u0007S#2!NBS%\u00111\u0004ha(\u0007\t]\u001a\u0001!\u000e\u0002\ryI,g-\u001b8f[\u0016tGO\u0010\t\u0004O\u0015\u0019WC\u0001\u001eA'\r)1\b\u0014\t\u0004Oqr\u0014BA\u001f\u001a\u0005e1U\r^2iS:<\u0007K]8dKN\u001c(+\u001a9pg&$xN]=\u0011\u0005}\u0002E\u0002\u0001\u0003\u0006\u0003\u0016\u0011\rA\u0011\u0002\u0002\rV\u00111IS\t\u0003\t\u001e\u0003\"aK#\n\u0005\u0019c#a\u0002(pi\"Lgn\u001a\t\u0003W!K!!\u0013\u0017\u0003\u0007\u0005s\u0017\u0010B\u0003L\u0001\n\u00071I\u0001\u0003`I\u0011\n\u0004CA'U\u001b\u0005q%BA(Q\u00031\u00198-\u00197bY><w-\u001b8h\u0015\t\t&+\u0001\u0005usB,7/\u00194f\u0015\u0005\u0019\u0016aA2p[&\u0011QK\u0014\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw-A\u0003eEJ+g-F\u0001Y!\tIF,D\u0001[\u0015\tYV$\u0001\u0002eE&\u0011QL\u0017\u0002\u0006\t\n\u0014VMZ\u0001\u0007I\n\u0014VM\u001a\u0011\u0002!\u0005\u001cG/[8o%\u0016\u0004xn]5u_JL\bcA\u0014bG&\u0011!-\u0007\u0002\u0018!J|7-Z:t\u0003\u000e$\u0018n\u001c8SKB|7/\u001b;pef\u0004\"\u0001Z9\u000f\u0005\u0015tgB\u00014l\u001d\t9'.D\u0001i\u0015\tIW%\u0001\u0004=e>|GOP\u0005\u00027&\u0011A.\\\u0001\u0005kRLGNC\u0001\\\u0013\ty\u0007/A\nE\u0005&{\u0015i\u0019;j_:Len\u001d;b]\u000e,7O\u0003\u0002m[&\u0011!o\u001d\u0002\u0003\t\nS!a\u001c9\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007E\u0002wszj\u0011a\u001e\u0006\u0002q\u0006!1-\u0019;t\u0013\tQxOA\u0003N_:\fG\r\u0006\u0003}\u007f\u0006\u0005ACA?\u007f!\r9SA\u0010\u0005\u0006i*\u0001\u001d!\u001e\u0005\u0006-*\u0001\r\u0001\u0017\u0005\u0006?*\u0001\r\u0001Y\u0001\u0016M\u0016$8\r\u001b)s_\u000e,7o]3t\t\u0016$\u0018-\u001b7t+\u0011\t9!a\n\u0015\t\u0005%\u0011\u0011\f\u000b\t\u0003\u0017\tY#!\u000e\u0002JA!q\bQA\u0007!\u0019\ty!!\u0007\u0002 9!\u0011\u0011CA\u000b\u001d\r9\u00171C\u0005\u0002[%\u0019\u0011q\u0003\u0017\u0002\u000fA\f7m[1hK&!\u00111DA\u000f\u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005]A\u0006E\u0003(\u0003C\t)#C\u0002\u0002$e\u0011\u0011dU2f]\u0006\u0014\u0018n\\,ji\"$U\r^1jYN,e\u000e^5usB\u0019q(a\n\u0005\r\u0005%2B1\u0001D\u0005\t\u00016\u000bC\u0005\u0002.-\t\t\u0011q\u0001\u00020\u0005QQM^5eK:\u001cW\r\n\u001a\u0011\u000b\u001d\n\t$!\n\n\u0007\u0005M\u0012D\u0001\u000eTG\u0016t\u0017M]5p'\"\f\u0007/\u001a$fi\u000eD7\u000b\u001e:bi\u0016<\u0017\u0010C\u0004\u00028-\u0001\u001d!!\u000f\u0002\u00151|wmZ3e+N,'\u000f\u0005\u0003\u0002<\u0005\u0015SBAA\u001f\u0015\u0011\ty$!\u0011\u0002\u0007\u0005\u0004\u0018NC\u0002\u0002Du\t\u0001b]3dkJLG/_\u0005\u0005\u0003\u000f\niD\u0001\u0006M_\u001e<W\rZ+tKJDq!a\u0013\f\u0001\b\ti%\u0001\u0002fGB!\u0011qJA+\u001b\t\t\tFC\u0002\u0002T1\n!bY8oGV\u0014(/\u001a8u\u0013\u0011\t9&!\u0015\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\bbBA.\u0017\u0001\u0007\u0011QL\u0001\u0006cV,'/\u001f\t\u0005\u0003?\n\t'D\u0001\u001c\u0013\r\t\u0019g\u0007\u0002\u000e'\u000e,g.\u0019:j_F+XM]=\u0002A\u0019,Go\u00195Qe>\u001cWm]:EKR\f\u0017\u000e\\:CsF+XM]=BGRLwN\\\u000b\u0005\u0003S\ny\t\u0006\u0004\u0002l\u0005u\u00161\u001d\u000b\t\u0003[\n\u0019,!/\u0002<BQ\u0011qNA=\u0003\u0013\u000b\t*a&\u000f\t\u0005E\u00141O\u0007\u0002\u000b%!\u0011qHA;\u0013\r\t9(\u0007\u0002\u000b%\u0016\u0004xn]5u_JL\u0018\u0002BA>\u0003{\u0012!\u0002\u0012\"J\u001f\u0006\u001bG/[8o\u0013\u0011\ty(!!\u0003\u000f\u0005c\u0017.Y:fg*!\u00111QAC\u0003\u0019a\u0017N\u001a;fI*\u0011\u0011qQ\u0001\u0006g2L7m\u001b\t\u0007\u0003\u001f\tI\"a#\u0011\u000b\u001d\n\t#!$\u0011\u0007}\ny\t\u0002\u0004\u0002*1\u0011\ra\u0011\t\u0005\u0003_\n\u0019*\u0003\u0003\u0002\u0016\u0006u$\u0001\u0003(p'R\u0014X-Y7\u0013\r\u0005e\u00151TAW\r\u00159T\u0001AAL!\u0011\ti*a)\u000f\t\u0005=\u0014qT\u0005\u0005\u0003C\u000bi(\u0001\u0004FM\u001a,7\r^\u0005\u0005\u0003K\u000b9KA\u0002BY2TA!!)\u0002**!\u00111VAC\u0003\u0011!'-[8\u0011\t\u0005u\u0015qV\u0005\u0005\u0003c\u000b9K\u0001\u0003SK\u0006$\u0007\"CA[\u0019\u0005\u0005\t9AA\\\u0003))g/\u001b3f]\u000e,Ge\r\t\u0006O\u0005E\u0012Q\u0012\u0005\b\u0003oa\u00019AA\u001d\u0011\u001d\tY\u0005\u0004a\u0002\u0003\u001bBq!a\u0017\r\u0001\u0004\ty\fE\u0004,\u0003\u0003\f)-a6\n\u0007\u0005\rGFA\u0005Gk:\u001cG/[8ocA!\u0011qYAj!\u0011\tI-a4\u000e\u0005\u0005-'bAAg5\u00061QM\u001c;jifLA!!5\u0002L\n!\u0002K]8dKN\u001cXI\u001c;jif4\u0015m\u0019;pefLA!!6\u0002P\ni\u0001K]8dKN\u001cXI\u001c;jif\u0004b!a\u001c\u0002Z\u0006u\u0017\u0002BAn\u0003{\u00121AU3q!\rY\u0013q\\\u0005\u0004\u0003Cd#a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003Kd\u0001\u0019AAt\u0003)I7\u000fR3qY>LX\r\u001a\t\u0006W\u0005%\u0018Q\\\u0005\u0004\u0003Wd#AB(qi&|g.A\ngKR\u001c\u0007.Q2uS>t7o\u0014:F[B$\u00180\u0006\u0003\u0002r\n=B\u0003BAz\u0005c!B!!>\u0003(A1\u0011qNA|\u0003wLA!!?\u0002~\t!AIQ%P!!\tiP!\u0002\u0003\f\tma\u0002BA\u0000\u0005\u0003\u0001\"a\u001a\u0017\n\u0007\t\rA&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005\u000f\u0011IAA\u0002NCBT1Aa\u0001-!\u0011\u0011iAa\u0006\u000e\u0005\t=!b\u0001\u000f\u0003\u0012)!\u0011q\bB\n\u0015\r\u0011)bH\u0001\u0007K:<\u0017N\\3\n\t\te!q\u0002\u0002\n!J|7-Z:t\u0013\u0012\u0004BA!\b\u0003$5\u0011!q\u0004\u0006\u0005\u0005C\u0011\t\"\u0001\u0006eKBdw._7f]RLAA!\n\u0003 \ti\u0001K]8dKN\u001c\u0018i\u0019;j_:D\u0011B!\u000b\u000e\u0003\u0003\u0005\u001dAa\u000b\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$C\u0007E\u0003(\u0003c\u0011i\u0003E\u0002@\u0005_!a!!\u000b\u000e\u0005\u0004\u0019\u0005\u0002\u0003B\u001a\u001b\u0011\u0005\rA!\u000e\u0002\u000f\u0011|g)\u001a;dQB)1Fa\u000e\u0002v&\u0019!\u0011\b\u0017\u0003\u0011q\u0012\u0017P\\1nKz\nQEZ3uG\"d\u0015\r^3tiB\u0013xnY3tg\u0012+G/Y5mg\u001a{'\u000f\u0015:pG\u0016\u001c8/\u00133\u0016\t\t}\"1\n\u000b\u0005\u0005\u0003\u00129\u0006\u0006\u0005\u0003D\t5#1\u000bB+!\u0011y\u0004I!\u0012\u0011\u000b-\nIOa\u0012\u0011\u000b\u001d\n\tC!\u0013\u0011\u0007}\u0012Y\u0005\u0002\u0004\u0002*9\u0011\ra\u0011\u0005\n\u0005\u001fr\u0011\u0011!a\u0002\u0005#\n!\"\u001a<jI\u0016t7-\u001a\u00136!\u00159\u0013\u0011\u0007B%\u0011\u001d\t9D\u0004a\u0002\u0003sAq!a\u0013\u000f\u0001\b\ti\u0005C\u0004\u0003Z9\u0001\rAa\u0003\u0002\u0005%$\u0017\u0001\u00074fi\u000eD\u0007K]8dKN\u001cH)\u001a;bS2\u001chi\u001c:JIV!!q\fB6)\u0019\u0011\tGa\u001e\u0003|QA!1\rB7\u0005g\u0012)\b\u0005\u0003@\u0001\n\u0015\u0004#B\u0016\u0002j\n\u001d\u0004#B\u0014\u0002\"\t%\u0004cA \u0003l\u00111\u0011\u0011F\bC\u0002\rC\u0011Ba\u001c\u0010\u0003\u0003\u0005\u001dA!\u001d\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$c\u0007E\u0003(\u0003c\u0011I\u0007C\u0004\u00028=\u0001\u001d!!\u000f\t\u000f\u0005-s\u0002q\u0001\u0002N!9!\u0011P\bA\u0002\t-\u0011!\u00039s_\u000e,7o]%e\u0011\u001d\u0011ih\u0004a\u0001\u0005\u007f\n\u0011B^3sg&|g.\u00133\u0011\t\t5!\u0011Q\u0005\u0005\u0005\u0007\u0013yAA\u0005WKJ\u001c\u0018n\u001c8JI\u0006qa-\u001a;dQB\u0013xnY3tg&#G\u0003\u0002BE\u0005##BAa#\u0003\u0010B!q\b\u0011BG!\u0015Y\u0013\u0011\u001eB\u0006\u0011\u001d\tY\u0005\u0005a\u0002\u0003\u001bBqAa%\u0011\u0001\u0004\u0011)*A\u0006qe>\u001cWm]:OC6,\u0007\u0003\u0002B\u0007\u0005/KAA!'\u0003\u0010\tY\u0001K]8dKN\u001ch*Y7f\u0003A1W\r^2i!J|7-Z:t\u001d\u0006lW\r\u0006\u0003\u0003 \n\u001dF\u0003\u0002BQ\u0005K\u0003Ba\u0010!\u0003$B)1&!;\u0003\u0016\"9\u00111J\tA\u0004\u00055\u0003b\u0002B=#\u0001\u0007!1B\u0001\u0014M\u0016$8\r\u001b)s_\u000e,7o\u001d#fi\u0006LGn\u001d\u000b\u0005\u0005[\u0013Y\f\u0006\u0003\u00030\ne\u0006\u0003B A\u0005c\u0003RaKAu\u0005g\u0003B!!3\u00036&!!qWAf\u0005E\u0001&o\\2fgN,e\u000e^5us\u0012\u000bG/\u0019\u0005\b\u0003\u0017\u0012\u00029AA'\u0011\u001d\u0011\u0019J\u0005a\u0001\u0005+\u000b1CZ3uG\"\u0004&o\\2fgNLgn\u001a+za\u0016$BA!1\u0003pR1!1\u0019Bu\u0005[\u0004Ba\u0010!\u0003FB!!q\u0019Br\u001d\u0011\u0011IM!9\u000f\t\t-'q\u001c\b\u0005\u0005\u001b\u0014iN\u0004\u0003\u0003P\nmg\u0002\u0002Bi\u00053tAAa5\u0003X:\u0019qM!6\n\u0003\u0011J!AI\u0012\n\u0005\u0001\n\u0013b\u0001B\u000b?%!\u0011q\bB\n\u0013\ra\"\u0011C\u0005\u0005\u0003/\u0011y!\u0003\u0003\u0003f\n\u001d(A\u0004)s_\u000e,7o]5oORK\b/\u001a\u0006\u0005\u0003/\u0011y\u0001C\u0004\u0003lN\u0001\u001d!!\u000f\u0002\tU\u001cXM\u001d\u0005\b\u0003\u0017\u001a\u00029AA'\u0011\u001d\u0011Ih\u0005a\u0001\u0005\u0017\t!FZ3uG\"d\u0015\r^3tiB\u0013xnY3tg\u0012+G/Y5mg\u001a{'\u000f\u0015:pG\u0016\u001c8/\u00133Rk\u0016\u0014\u00180\u0006\u0003\u0003v\u000e\u0005A\u0003\u0002B|\u0007\u001b!\u0002B!?\u0004\u0004\r%11\u0002\t\u0005IF\u0014Y\u0010E\u0003,\u0003S\u0014i\u0010E\u0003(\u0003C\u0011y\u0010E\u0002@\u0007\u0003!a!!\u000b\u0015\u0005\u0004\u0019\u0005\"CB\u0003)\u0005\u0005\t9AB\u0004\u0003))g/\u001b3f]\u000e,Ge\u000e\t\u0006O\u0005E\"q \u0005\b\u0003o!\u00029AA\u001d\u0011\u001d\tY\u0005\u0006a\u0002\u0003\u001bBqA!\u0017\u0015\u0001\u0004\u0011Y!A\u000fgKR\u001c\u0007\u000e\u0015:pG\u0016\u001c8\u000fR3uC&d7OR8s-\u0016\u00148/[8o+\u0011\u0019\u0019ba\n\u0015\r\rU11GB\u001f)!\u00199b!\u000b\u00040\rE\u0002cBB\r\u0007?\u001971E\u0007\u0003\u00077Q1a!\bx\u0003\u0011!\u0017\r^1\n\t\r\u000521\u0004\u0002\b\u001fB$\u0018n\u001c8U!\u00159\u0013\u0011EB\u0013!\ry4q\u0005\u0003\u0007\u0003S)\"\u0019A\"\t\u0013\r-R#!AA\u0004\r5\u0012AC3wS\u0012,gnY3%qA)q%!\r\u0004&!9\u0011qG\u000bA\u0004\u0005e\u0002bBA&+\u0001\u000f\u0011Q\n\u0005\b\u0007k)\u0002\u0019AB\u001c\u00039\u0001(o\\2fgN4VM]:j_:\u0004B!!3\u0004:%!11HAf\u0005a\u0001&o\\2fgN4VM]:j_:,e\u000e^5us\u0012\u000bG/\u0019\u0005\b\u0007\u007f)\u0002\u0019AAo\u0003=I7\u000fT1uKN$h+\u001a:tS>t\u0017!E2sK\u0006$XMR;mY\u0012+G/Y5mgV!1QIB')I\u00199e!\u0016\u0004X\re3qLB2\u0007O\u001aIga\u001f\u0015\t\r%3q\n\t\u0006O\u0005\u000521\n\t\u0004\u007f\r5CABA\u0015-\t\u00071\tC\u0005\u0004RY\t\t\u0011q\u0001\u0004T\u0005QQM^5eK:\u001cW\rJ\u001d\u0011\u000b\u001d\n\tda\u0013\t\rq1\u0002\u0019\u0001BZ\u0011\u001d\u0019)D\u0006a\u0001\u0007oAqaa\u0017\u0017\u0001\u0004\u0019i&\u0001\bmCN$\u0018i\u0019;j_:$\u0015\r^1\u0011\u000b-\nIOa\u0007\t\u000f\r\u0005d\u00031\u0001\u0004^\u0005\u0019B.Y:u'R\fG/Z!di&|g\u000eR1uC\"91Q\r\fA\u0002\ru\u0013A\u00067bgR$U\r\u001d7ps\u0016$\u0017i\u0019;j_:$\u0015\r^1\t\u000f\r}b\u00031\u0001\u0002^\"911\u000e\fA\u0002\r5\u0014\u0001\u0002;bON\u0004RaKAu\u0007_\u0002b!a\u0004\u0004r\rU\u0014\u0002BB:\u0003;\u00111aU3r!\u0011\tIma\u001e\n\t\re\u00141\u001a\u0002\u000f)\u0006<7/\u00128uSRLH)\u0019;b\u0011\u001d\u0019iH\u0006a\u0001\u0007\u007f\nq\u0001[5ti>\u0014\u0018\u0010E\u0003,\u0003S\u001c\t\t\u0005\u0004\u0002\u0010\rE41\u0011\t\u0005\u0005\u001b\u0019))\u0003\u0003\u0004\b\n=!aD*dK:\f'/[8WKJ\u001c\u0018n\u001c8\u0002)\r|gN^3siR{G+\u0019:hKR\u001c\u0006.\u00199f+\u0011\u0019iia%\u0015\r\r=51TBO)\u0011\u0019\tj!&\u0011\u0007}\u001a\u0019\n\u0002\u0004\u0002*]\u0011\ra\u0011\u0005\n\u0007/;\u0012\u0011!a\u0002\u00073\u000b1\"\u001a<jI\u0016t7-\u001a\u00132aA)q%!\r\u0004\u0012\"91QG\fA\u0002\r]\u0002B\u0002\u000f\u0018\u0001\u0004\u0011\u0019\fE\u0002(\u0007CK1aa)\u001a\u00059!%-[8SKB|7/\u001b;pefDq!a\u0013\u0004\u0001\b\ti\u0005C\u0003W\u0007\u0001\u0007\u0001\fC\u0003`\u0007\u0001\u0007\u0001-\u0001\fde\u0016\fG/\u001a$viV\u0014XMU3q_NLGo\u001c:z)\u0019\u0019yk!2\u0004HR!1\u0011WBb%\u0019\u0019\u0019l!.\u0004>\u001a)q\u0007\u0002\u0001\u00042B!q%BB\\!\u0011\tye!/\n\t\rm\u0016\u0011\u000b\u0002\u0007\rV$XO]3\u0011\u0007\u001d\u001ay,C\u0002\u0004Bf\u0011qBQ1tS\u000e\u0014V\r]8tSR|'/\u001f\u0005\b\u0003\u0017\"\u00019AA'\u0011\u00151F\u00011\u0001Y\u0011\u0015yF\u00011\u0001a\u0001")
public abstract class DBFetchingProcessRepository<F>
extends FetchingProcessRepository<F>
implements LazyLogging {
    private final DbRef dbRef;
    private final ProcessActionRepository<DBIOAction> actionRepository;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static DBFetchingProcessRepository<Future> createFutureRepository(DbRef dbRef, ProcessActionRepository<DBIOAction> actionRepository, ExecutionContext ec) {
        return DBFetchingProcessRepository$.MODULE$.createFutureRepository(dbRef, actionRepository, ec);
    }

    public static DBFetchingProcessRepository<DBIOAction> create(DbRef dbRef, ProcessActionRepository<DBIOAction> actionRepository, ExecutionContext ec) {
        return DBFetchingProcessRepository$.MODULE$.create(dbRef, actionRepository, ec);
    }

    private Logger logger$lzycompute() {
        DBFetchingProcessRepository dBFetchingProcessRepository = this;
        synchronized (dBFetchingProcessRepository) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public DbRef dbRef() {
        return this.dbRef;
    }

    @Override
    public <PS> F fetchProcessesDetails(ScenarioQuery query, ScenarioShapeFetchStrategy<PS> evidence$2, LoggedUser loggedUser, ExecutionContext ec) {
        .colon.colon expr = new .colon.colon((Object)query.isFragment().map((Function1 & Serializable)arg -> DBFetchingProcessRepository.$anonfun$fetchProcessesDetails$1(this, BoxesRunTime.unboxToBoolean((Object)arg))), (List)new .colon.colon((Object)query.isArchived().map((Function1 & Serializable)arg -> DBFetchingProcessRepository.$anonfun$fetchProcessesDetails$3(this, BoxesRunTime.unboxToBoolean((Object)arg))), (List)new .colon.colon((Object)query.categories().map((Function1 & Serializable)arg -> (Function1 & Serializable)process -> new BaseColumnExtensionMethods(this.api().columnExtensionMethods(process.processCategory(), (BaseTypedType)this.api().stringColumnType())).inSet((Iterable)arg, OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)this.api().stringColumnType()))), (List)new .colon.colon((Object)query.processingTypes().map((Function1 & Serializable)arg -> (Function1 & Serializable)process -> new BaseColumnExtensionMethods(this.api().columnExtensionMethods(process.processingType(), (BaseTypedType)this.api().stringColumnType())).inSet((Iterable)arg, OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)this.api().stringColumnType()))), (List)new .colon.colon((Object)query.names().map((Function1 & Serializable)arg -> (Function1 & Serializable)process -> new BaseColumnExtensionMethods(this.api().columnExtensionMethods(process.name(), this.processNameMapping())).inSet((Iterable)arg, OptionMapper2$.MODULE$.getOptionMapper2TT(this.processNameMapping()))), (List)Nil$.MODULE$)))));
        return (F)this.run().apply(this.fetchProcessDetailsByQueryAction((Function1<ProcessEntityFactory.ProcessEntity, Rep<Object>>)((Function1 & Serializable)arg_0 -> DBFetchingProcessRepository.$anonfun$fetchProcessesDetails$11(this, (List)expr, arg_0)), query.isDeployed(), evidence$2, loggedUser, ec));
    }

    private <PS> DBIOAction<List<ScenarioWithDetailsEntity<PS>>, NoStream, Effect.All> fetchProcessDetailsByQueryAction(Function1<ProcessEntityFactory.ProcessEntity, Rep<Object>> query, Option<Object> isDeployed, ScenarioShapeFetchStrategy<PS> evidence$3, LoggedUser loggedUser, ExecutionContext ec) {
        return this.fetchActionsOrEmpty((Function0<DBIOAction<Map<ProcessId, ProcessAction>, NoStream, Effect.All>>)(Function0 & Serializable)() -> $this.actionRepository.getLastActionPerProcess((Set<Enumeration.Value>)ProcessActionState$.MODULE$.FinishedStates(), (Option<Set<Enumeration.Value>>)None$.MODULE$), evidence$3).flatMap((Function1 & Serializable)lastActionPerProcess -> this.fetchActionsOrEmpty((Function0<DBIOAction<Map<ProcessId, ProcessAction>, NoStream, Effect.All>>)(Function0 & Serializable)() -> $this.actionRepository.getLastActionPerProcess((Set<Enumeration.Value>)ProcessActionState$.MODULE$.FinishedStates(), (Option<Set<Enumeration.Value>>)new Some((Object)ProcessActionType$.MODULE$.StateActionsTypes())), evidence$3).flatMap((Function1 & Serializable)lastStateActionPerProcess -> this.fetchActionsOrEmpty((Function0<DBIOAction<Map<ProcessId, ProcessAction>, NoStream, Effect.All>>)(Function0 & Serializable)() -> $this.actionRepository.getLastActionPerProcess((Set<Enumeration.Value>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{ProcessActionState$.MODULE$.Finished()}))), (Option<Set<Enumeration.Value>>)new Some(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{ProcessActionType$.MODULE$.Deploy()})))), evidence$3).flatMap((Function1 & Serializable)lastDeployedActionPerProcess -> ((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.api().streamableQueryActionExtensionMethods(this.fetchLatestProcessesQuery(query, (Set<ProcessId>)lastDeployedActionPerProcess.keySet(), isDeployed, evidence$3, loggedUser))).result().map((Function1 & Serializable)latestProcesses -> (Seq)latestProcesses.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                ProcessEntityData process = (ProcessEntityData)tuple2._2();
                if (tuple22 != null) {
                    ProcessVersionEntityData processVersion = (ProcessVersionEntityData)tuple22._2();
                    return this.createFullDetails(process, processVersion, (Option<ProcessAction>)lastActionPerProcess.get((Object)process.id()), (Option<ProcessAction>)lastStateActionPerProcess.get((Object)process.id()), (Option<ProcessAction>)lastDeployedActionPerProcess.get((Object)process.id()), true, (Option<Seq<TagsEntityData>>)None$.MODULE$, (Option<Seq<ScenarioVersion>>)None$.MODULE$, evidence$3);
                }
            }
            throw new MatchError((Object)tuple2);
        }), ec), ec), ec), ec).map((Function1 & Serializable)x$1 -> x$1.toList(), ec);
    }

    private <PS> DBIOAction<Map<ProcessId, ProcessAction>, NoStream, Effect.All> fetchActionsOrEmpty(Function0<DBIOAction<Map<ProcessId, ProcessAction>, NoStream, Effect.All>> doFetch, ScenarioShapeFetchStrategy<PS> evidence$4) {
        ScenarioShapeFetchStrategy scenarioShapeFetchStrategy = (ScenarioShapeFetchStrategy)Predef$.MODULE$.implicitly(evidence$4);
        if (ScenarioShapeFetchStrategy$FetchComponentsUsages$.MODULE$.equals(scenarioShapeFetchStrategy)) {
            return this.api().DBIO().successful((Object)Predef$.MODULE$.Map().empty());
        }
        return (DBIOAction)doFetch.apply();
    }

    @Override
    public <PS> F fetchLatestProcessDetailsForProcessId(ProcessId id, ScenarioShapeFetchStrategy<PS> evidence$5, LoggedUser loggedUser, ExecutionContext ec) {
        return (F)this.run().apply(this.fetchLatestProcessDetailsForProcessIdQuery(id, evidence$5, loggedUser, ec));
    }

    @Override
    public <PS> F fetchProcessDetailsForId(ProcessId processId, VersionId versionId, ScenarioShapeFetchStrategy<PS> evidence$6, LoggedUser loggedUser, ExecutionContext ec) {
        OptionT action = new OptionT((Object)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.api().streamableQueryActionExtensionMethods(this.fetchProcessLatestVersionsQuery(processId, ScenarioShapeFetchStrategy$NotFetch$.MODULE$))).result().headOption()).flatMap((Function1 & Serializable)latestProcessVersion -> new OptionT((Object)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.api().streamableQueryActionExtensionMethods(this.fetchProcessLatestVersionsQuery(processId, evidence$6).filter((Function1 & Serializable)pv -> new BaseColumnExtensionMethods(this.api().columnExtensionMethods(pv.id(), this.versionIdMapping())).$eq$eq$eq((Rep)this.api().valueToConstColumn((Object)versionId, this.versionIdMapping()), OptionMapper2$.MODULE$.getOptionMapper2TT(this.versionIdMapping())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()))).result().headOption()).flatMap((Function1 & Serializable)processVersion -> {
            VersionId versionId = latestProcessVersion.id();
            VersionId versionId2 = processVersion.id();
            return this.fetchProcessDetailsForVersion((ProcessVersionEntityData)processVersion, !(versionId != null ? !versionId.equals(versionId2) : versionId2 != null), evidence$6, loggedUser, ec).map((Function1 & Serializable)processDetails -> processDetails, DBIOActionInstances$.MODULE$.dbMonad(ec));
        }, DBIOActionInstances$.MODULE$.dbMonad(ec)), DBIOActionInstances$.MODULE$.dbMonad(ec));
        return (F)this.run().apply(action.value());
    }

    @Override
    public F fetchProcessId(ProcessName processName, ExecutionContext ec) {
        return (F)this.run().apply((Object)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.api().streamableQueryActionExtensionMethods(this.processesTable().filter((Function1 & Serializable)x$2 -> new BaseColumnExtensionMethods(this.api().columnExtensionMethods(x$2.name(), this.processNameMapping())).$eq$eq$eq((Rep)this.api().valueToConstColumn((Object)processName, this.processNameMapping()), OptionMapper2$.MODULE$.getOptionMapper2TT(this.processNameMapping())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).map((Function1 & Serializable)x$3 -> x$3.id(), Shape$.MODULE$.repColumnShape(this.processIdMapping())))).result().headOption().map((Function1 & Serializable)x$4 -> x$4.map((Function1 & Serializable)id -> id), ec));
    }

    @Override
    public F fetchProcessName(ProcessId processId, ExecutionContext ec) {
        return (F)this.run().apply((Object)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.api().streamableQueryActionExtensionMethods(this.processesTable().filter((Function1 & Serializable)x$5 -> new BaseColumnExtensionMethods(this.api().columnExtensionMethods(x$5.id(), this.processIdMapping())).$eq$eq$eq((Rep)this.api().valueToConstColumn((Object)processId, this.processIdMapping()), OptionMapper2$.MODULE$.getOptionMapper2TT(this.processIdMapping())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).map((Function1 & Serializable)x$6 -> x$6.name(), Shape$.MODULE$.repColumnShape(this.processNameMapping())))).result().headOption());
    }

    @Override
    public F fetchProcessDetails(ProcessName processName, ExecutionContext ec) {
        return (F)this.run().apply((Object)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.api().streamableQueryActionExtensionMethods(this.processesTable().filter((Function1 & Serializable)x$7 -> new BaseColumnExtensionMethods(this.api().columnExtensionMethods(x$7.name(), this.processNameMapping())).$eq$eq$eq((Rep)this.api().valueToConstColumn((Object)processName, this.processNameMapping()), OptionMapper2$.MODULE$.getOptionMapper2TT(this.processNameMapping())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()))).result().headOption());
    }

    @Override
    public F fetchProcessingType(ProcessId processId, LoggedUser user, ExecutionContext ec) {
        ScenarioShapeFetchStrategy$NotFetch$ fetchStrategy = ScenarioShapeFetchStrategy$NotFetch$.MODULE$;
        return (F)this.run().apply((Object)this.fetchLatestProcessDetailsForProcessIdQuery(processId, fetchStrategy, user, ec).flatMap((Function1 & Serializable)x0$1 -> {
            Option option = x0$1;
            if (None$.MODULE$.equals(option)) {
                return this.api().DBIO().failed((Throwable)new ProcessDBQueryRepository.ProcessNotFoundError(Long.toString(processId.value())));
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                ScenarioWithDetailsEntity process = (ScenarioWithDetailsEntity)some.value();
                return this.api().DBIO().successful((Object)process.processingType());
            }
            throw new MatchError((Object)option);
        }, ec));
    }

    private <PS> DBIOAction<Option<ScenarioWithDetailsEntity<PS>>, NoStream, Effect.All> fetchLatestProcessDetailsForProcessIdQuery(ProcessId id, ScenarioShapeFetchStrategy<PS> evidence$7, LoggedUser loggedUser, ExecutionContext ec) {
        return (DBIOAction)new OptionT((Object)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.api().streamableQueryActionExtensionMethods(this.fetchProcessLatestVersionsQuery(id, evidence$7))).result().headOption()).flatMap((Function1 & Serializable)latestProcessVersion -> this.fetchProcessDetailsForVersion((ProcessVersionEntityData)latestProcessVersion, true, evidence$7, loggedUser, ec).map((Function1 & Serializable)processDetails -> processDetails, DBIOActionInstances$.MODULE$.dbMonad(ec)), DBIOActionInstances$.MODULE$.dbMonad(ec)).value();
    }

    private <PS> OptionT<DBIOAction, ScenarioWithDetailsEntity<PS>> fetchProcessDetailsForVersion(ProcessVersionEntityData processVersion, boolean isLatestVersion, ScenarioShapeFetchStrategy<PS> evidence$8, LoggedUser loggedUser, ExecutionContext ec) {
        ProcessId id = processVersion.processId();
        return new OptionT((Object)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.api().streamableQueryActionExtensionMethods(this.processTableFilteredByUser(loggedUser).filter((Function1 & Serializable)x$8 -> new BaseColumnExtensionMethods(this.api().columnExtensionMethods(x$8.id(), this.processIdMapping())).$eq$eq$eq((Rep)this.api().valueToConstColumn((Object)id, this.processIdMapping()), OptionMapper2$.MODULE$.getOptionMapper2TT(this.processIdMapping())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()))).result().headOption()).flatMap((Function1 & Serializable)process -> OptionT$.MODULE$.liftF((Object)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.api().streamableQueryActionExtensionMethods(this.fetchProcessLatestVersionsQuery(id, ScenarioShapeFetchStrategy$NotFetch$.MODULE$))).result(), DBIOActionInstances$.MODULE$.dbMonad(ec)).flatMap((Function1 & Serializable)processVersions -> OptionT$.MODULE$.liftF((Object)$this.actionRepository.getFinishedProcessActions(id, (Option<Set<Enumeration.Value>>)None$.MODULE$, ec), DBIOActionInstances$.MODULE$.dbMonad(ec)).flatMap((Function1 & Serializable)actions -> OptionT$.MODULE$.liftF((Object)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.api().streamableQueryActionExtensionMethods(this.tagsTable().filter((Function1 & Serializable)x$9 -> new BaseColumnExtensionMethods(this.api().columnExtensionMethods(x$9.processId(), this.processIdMapping())).$eq$eq$eq((Rep)this.api().valueToConstColumn((Object)process.id(), this.processIdMapping()), OptionMapper2$.MODULE$.getOptionMapper2TT(this.processIdMapping())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()))).result(), DBIOActionInstances$.MODULE$.dbMonad(ec)).map((Function1 & Serializable)tags -> this.createFullDetails((ProcessEntityData)process, processVersion, (Option<ProcessAction>)actions.headOption(), (Option<ProcessAction>)actions.find((Function1 & Serializable)a -> BoxesRunTime.boxToBoolean((boolean)DBFetchingProcessRepository.$anonfun$fetchProcessDetailsForVersion$7(a))), (Option<ProcessAction>)actions.headOption().filter((Function1 & Serializable)a -> BoxesRunTime.boxToBoolean((boolean)DBFetchingProcessRepository.$anonfun$fetchProcessDetailsForVersion$8(a))), isLatestVersion, (Option<Seq<TagsEntityData>>)new Some(tags), (Option<Seq<ScenarioVersion>>)new Some(processVersions.map((Function1 & Serializable)v -> ProcessDBQueryRepository$.MODULE$.toProcessVersion((ProcessVersionEntityData)v, (List<ProcessAction>)actions.filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)DBFetchingProcessRepository.$anonfun$fetchProcessDetailsForVersion$10(v, p)))))), evidence$8), DBIOActionInstances$.MODULE$.dbMonad(ec)), DBIOActionInstances$.MODULE$.dbMonad(ec)), DBIOActionInstances$.MODULE$.dbMonad(ec)), DBIOActionInstances$.MODULE$.dbMonad(ec));
    }

    private <PS> ScenarioWithDetailsEntity<PS> createFullDetails(ProcessEntityData process, ProcessVersionEntityData processVersion, Option<ProcessAction> lastActionData, Option<ProcessAction> lastStateActionData, Option<ProcessAction> lastDeployedActionData, boolean isLatestVersion, Option<Seq<TagsEntityData>> tags, Option<Seq<ScenarioVersion>> history, ScenarioShapeFetchStrategy<PS> evidence$9) {
        String x$1 = process.name().value();
        ProcessId x$2 = process.id();
        ProcessName x$3 = process.name();
        VersionId x$4 = processVersion.id();
        boolean x$5 = isLatestVersion;
        boolean x$6 = process.isArchived();
        boolean x$7 = process.isFragment();
        Option<String> x$8 = process.description();
        String x$9 = process.processingType();
        String x$102 = process.processCategory();
        Option<ProcessAction> x$11 = lastActionData;
        Option<ProcessAction> x$122 = lastStateActionData;
        Option<ProcessAction> x$13 = lastDeployedActionData;
        Option x$14 = tags.map((Function1 & Serializable)x$10 -> ((IterableOnceOps)x$10.map((Function1 & Serializable)x$11 -> x$11.name())).toList());
        Instant x$15 = processVersion.createDate().toInstant();
        Instant x$16 = processVersion.createDate().toInstant();
        String x$17 = processVersion.user();
        Instant x$18 = process.createdAt().toInstant();
        String x$19 = process.createdBy();
        PS x$20 = this.convertToTargetShape(processVersion, process, evidence$9);
        Option x$21 = history.map((Function1 & Serializable)x$12 -> x$12.toList());
        Option<Object> x$22 = processVersion.modelVersion();
        return new ScenarioWithDetailsEntity<PS>(x$1, x$3, x$2, x$4, x$5, x$8, x$6, x$7, x$9, x$102, x$15, x$16, x$17, x$18, x$19, (Option<List<String>>)x$14, x$13, x$122, x$11, x$20, (Option<List<ScenarioVersion>>)x$21, x$22);
    }

    private <PS> PS convertToTargetShape(ProcessVersionEntityData processVersion, ProcessEntityData process, ScenarioShapeFetchStrategy<PS> evidence$10) {
        ScenarioShapeFetchStrategy scenarioShapeFetchStrategy;
        Tuple3 tuple3 = new Tuple3(processVersion.json(), processVersion.componentsUsages(), Predef$.MODULE$.implicitly(evidence$10));
        if (tuple3 != null) {
            Option option = (Option)tuple3._1();
            ScenarioShapeFetchStrategy scenarioShapeFetchStrategy2 = (ScenarioShapeFetchStrategy)tuple3._3();
            if (option instanceof Some) {
                Some some = (Some)option;
                CanonicalProcess canonical = (CanonicalProcess)some.value();
                if (ScenarioShapeFetchStrategy$FetchCanonical$.MODULE$.equals(scenarioShapeFetchStrategy2)) {
                    return (PS)canonical;
                }
            }
        }
        if (tuple3 != null) {
            Option option = (Option)tuple3._1();
            ScenarioShapeFetchStrategy scenarioShapeFetchStrategy3 = (ScenarioShapeFetchStrategy)tuple3._3();
            if (option instanceof Some) {
                Some some = (Some)option;
                CanonicalProcess canonical = (CanonicalProcess)some.value();
                if (ScenarioShapeFetchStrategy$FetchDisplayable$.MODULE$.equals(scenarioShapeFetchStrategy3)) {
                    DisplayableProcess displayableProcess = ProcessConverter$.MODULE$.toDisplayableOrDie(canonical, process.processingType(), process.processCategory());
                    return (PS)displayableProcess;
                }
            }
        }
        if (tuple3 != null && ScenarioShapeFetchStrategy$NotFetch$.MODULE$.equals(scenarioShapeFetchStrategy = (ScenarioShapeFetchStrategy)tuple3._3())) {
            return (PS)BoxedUnit.UNIT;
        }
        if (tuple3 != null) {
            Option option = (Option)tuple3._2();
            ScenarioShapeFetchStrategy scenarioShapeFetchStrategy4 = (ScenarioShapeFetchStrategy)tuple3._3();
            if (option instanceof Some) {
                Some some = (Some)option;
                ScenarioComponentsUsages componentsUsages = (ScenarioComponentsUsages)some.value();
                if (ScenarioShapeFetchStrategy$FetchComponentsUsages$.MODULE$.equals(scenarioShapeFetchStrategy4)) {
                    return (PS)componentsUsages;
                }
            }
        }
        if (tuple3 != null) {
            ScenarioShapeFetchStrategy strategy = (ScenarioShapeFetchStrategy)tuple3._3();
            throw new IllegalArgumentException("Missing scenario json data, it's required to convert for strategy: " + strategy + ".");
        }
        throw new MatchError((Object)tuple3);
    }

    public static final /* synthetic */ Function1 $anonfun$fetchProcessesDetails$1(DBFetchingProcessRepository $this, boolean arg) {
        return (Function1 & Serializable)process -> new BaseColumnExtensionMethods($this.api().columnExtensionMethods(process.isFragment(), (BaseTypedType)$this.api().booleanColumnType())).$eq$eq$eq((Rep)$this.api().valueToConstColumn((Object)BoxesRunTime.boxToBoolean((boolean)arg), (TypedType)$this.api().booleanColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)$this.api().booleanColumnType()));
    }

    public static final /* synthetic */ Function1 $anonfun$fetchProcessesDetails$3(DBFetchingProcessRepository $this, boolean arg) {
        return (Function1 & Serializable)process -> new BaseColumnExtensionMethods($this.api().columnExtensionMethods(process.isArchived(), (BaseTypedType)$this.api().booleanColumnType())).$eq$eq$eq((Rep)$this.api().valueToConstColumn((Object)BoxesRunTime.boxToBoolean((boolean)arg), (TypedType)$this.api().booleanColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)$this.api().booleanColumnType()));
    }

    public static final /* synthetic */ Rep $anonfun$fetchProcessesDetails$11(DBFetchingProcessRepository $this, List expr$1, ProcessEntityFactory.ProcessEntity process) {
        return (Rep)((LinearSeqOps)expr$1.flatten(Predef$.MODULE$.$conforms())).foldLeft((Object)$this.api().valueToConstColumn((Object)BoxesRunTime.boxToBoolean((boolean)true), (TypedType)$this.api().booleanColumnType()), (Function2 & Serializable)(x, y) -> BooleanColumnExtensionMethods$.MODULE$.$amp$amp$extension($this.api().booleanColumnExtensionMethods(x), (Rep)y.apply((Object)process), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)$this.api().booleanColumnType())));
    }

    public static final /* synthetic */ boolean $anonfun$fetchProcessDetailsForVersion$7(ProcessAction a) {
        return ProcessActionType$.MODULE$.StateActionsTypes().contains((Object)a.actionType());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$fetchProcessDetailsForVersion$8(ProcessAction a) {
        Enumeration.Value value = a.actionType();
        Enumeration.Value value2 = ProcessActionType$.MODULE$.Deploy();
        if (value == null) {
            if (value2 != null) {
                return false;
            }
        } else if (!value.equals(value2)) return false;
        Enumeration.Value value3 = a.state();
        Enumeration.Value value4 = ProcessActionState$.MODULE$.Finished();
        if (value3 == null) {
            if (value4 == null) return true;
            return false;
        } else {
            if (!value3.equals(value4)) return false;
            return true;
        }
    }

    public static final /* synthetic */ boolean $anonfun$fetchProcessDetailsForVersion$10(ProcessVersionEntityData v$1, ProcessAction p) {
        VersionId versionId = p.processVersionId();
        VersionId versionId2 = v$1.id();
        return !(versionId != null ? !versionId.equals(versionId2) : versionId2 != null);
    }

    public DBFetchingProcessRepository(DbRef dbRef, ProcessActionRepository<DBIOAction> actionRepository, Monad<F> evidence$1) {
        this.dbRef = dbRef;
        this.actionRepository = actionRepository;
        super(evidence$1);
        LazyLogging.$init$((LazyLogging)this);
    }
}

