/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.server;

import akka.actor.ActorSystem;
import akka.actor.ClassicActorSystemProvider;
import akka.http.scaladsl.Http;
import akka.http.scaladsl.Http$;
import akka.http.scaladsl.HttpsConnectionContext;
import akka.http.scaladsl.server.RequestContext;
import akka.http.scaladsl.server.RouteResult;
import akka.stream.Materializer;
import cats.Applicative;
import cats.Functor;
import cats.effect.ContextShift;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.Resource;
import cats.effect.Resource$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import fr.davit.akka.http.metrics.core.HttpMetrics$;
import fr.davit.akka.http.metrics.core.HttpMetricsHandler;
import fr.davit.akka.http.metrics.core.HttpMetricsRegistry;
import fr.davit.akka.http.metrics.core.HttpMetricsSettings;
import fr.davit.akka.http.metrics.dropwizard.DropwizardRegistry;
import fr.davit.akka.http.metrics.dropwizard.DropwizardSettings$;
import io.dropwizard.metrics5.MetricRegistry;
import java.io.Serializable;
import pl.touk.nussknacker.engine.ConfigWithUnresolvedVersion;
import pl.touk.nussknacker.ui.security.ssl.HttpsConnectionContextFactory$;
import pl.touk.nussknacker.ui.security.ssl.KeyStoreConfig;
import pl.touk.nussknacker.ui.security.ssl.SslConfigParser$;
import pl.touk.nussknacker.ui.server.RouteProvider;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005ef\u0001\u0002\n\u0014\u0001yA\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u001d\"AA\u000b\u0001B\u0001B\u0003%Q\u000bC\u0003\\\u0001\u0011\u0005A\fC\u0004b\u0001\t\u0007I1\u00022\t\r\r\u0004\u0001\u0015!\u0003O\u0011\u001d!\u0007A1A\u0005\f\u0015DaA\u001a\u0001!\u0002\u0013)\u0006bB4\u0001\u0005\u0004%Y\u0001\u001b\u0005\u0007_\u0002\u0001\u000b\u0011B5\t\u000fA\u0004!\u0019!C\u0006c\"1Q\u0010\u0001Q\u0001\nIDQA \u0001\u0005\u0002}Dq!!\u000e\u0001\t\u0013\t9\u0004C\u0004\u0002V\u0001!I!a\u0016\t\u000f\u0005\u0005\u0005\u0001\"\u0003\u0002\u0004\"9\u0011q\u0013\u0001\u0005\n\u0005e%!\u0006(vgN\\g.Y2lKJDE\u000f\u001e9TKJ4XM\u001d\u0006\u0003)U\taa]3sm\u0016\u0014(B\u0001\f\u0018\u0003\t)\u0018N\u0003\u0002\u00193\u0005Ya.^:tW:\f7m[3s\u0015\tQ2$\u0001\u0003u_V\\'\"\u0001\u000f\u0002\u0005Ad7\u0001A\n\u0004\u0001})\u0003C\u0001\u0011$\u001b\u0005\t#\"\u0001\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\n#AB!osJ+g\r\u0005\u0002'[5\tqE\u0003\u0002)S\u0005a1oY1mC2|wmZ5oO*\u0011!fK\u0001\tif\u0004Xm]1gK*\tA&A\u0002d_6L!AL\u0014\u0003\u00171\u000b'0\u001f'pO\u001eLgnZ\u0001\u000ee>,H/\u001a)s_ZLG-\u001a:\u0011\u0007E\u0012D'D\u0001\u0014\u0013\t\u00194CA\u0007S_V$X\r\u0015:pm&$WM\u001d\t\u0003k)s!AN$\u000f\u0005]*eB\u0001\u001dC\u001d\tItH\u0004\u0002;{5\t1H\u0003\u0002=;\u00051AH]8pizJ\u0011AP\u0001\u0005C.\\\u0017-\u0003\u0002A\u0003\u0006!\u0001\u000e\u001e;q\u0015\u0005q\u0014BA\"E\u0003!\u00198-\u00197bINd'B\u0001!B\u0013\t!bI\u0003\u0002D\t&\u0011\u0001*S\u0001\ba\u0006\u001c7.Y4f\u0015\t!b)\u0003\u0002L\u0019\n)!k\\;uK*\u0011\u0001*S\u0001\u0007gf\u001cH/Z7\u0011\u0005=\u0013V\"\u0001)\u000b\u0005E\u000b\u0015!B1di>\u0014\u0018BA*Q\u0005-\t5\r^8s'f\u001cH/Z7\u0002\u00195\fG/\u001a:jC2L'0\u001a:\u0011\u0005YKV\"A,\u000b\u0005a\u000b\u0015AB:ue\u0016\fW.\u0003\u0002[/\naQ*\u0019;fe&\fG.\u001b>fe\u00061A(\u001b8jiz\"B!\u00180`AB\u0011\u0011\u0007\u0001\u0005\u0006_\u0011\u0001\r\u0001\r\u0005\u0006\u001b\u0012\u0001\rA\u0014\u0005\u0006)\u0012\u0001\r!V\u0001\u000fgf\u001cH/Z7J[Bd\u0017nY5u+\u0005q\u0015aD:zgR,W.S7qY&\u001c\u0017\u000e\u001e\u0011\u0002)5\fG/\u001a:jC2L'0\u001a:J[Bd\u0017nY5u+\u0005)\u0016!F7bi\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018*\u001c9mS\u000eLG\u000fI\u0001\u0019Kb,7-\u001e;j_:\u001cuN\u001c;fqRLU\u000e\u001d7jG&$X#A5\u0011\u0005)lW\"A6\u000b\u00051\f\u0013AC2p]\u000e,(O]3oi&\u0011an\u001b\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\f\u0011$\u001a=fGV$\u0018n\u001c8D_:$X\r\u001f;J[Bd\u0017nY5uA\u0005a1m\u001c8uKb$8\u000b[5giV\t!\u000fE\u0002tqjl\u0011\u0001\u001e\u0006\u0003kZ\fa!\u001a4gK\u000e$(\"A<\u0002\t\r\fGo]\u0005\u0003sR\u0014AbQ8oi\u0016DHo\u00155jMR\u0004\"a]>\n\u0005q$(AA%P\u00035\u0019wN\u001c;fqR\u001c\u0006.\u001b4uA\u0005)1\u000f^1siR1\u0011\u0011AA\u0007\u0003;\u0001ba]A\u0002u\u0006\u001d\u0011bAA\u0003i\nA!+Z:pkJ\u001cW\rE\u0002!\u0003\u0013I1!a\u0003\"\u0005\u0011)f.\u001b;\t\u000f\u0005=Q\u00021\u0001\u0002\u0012\u000511m\u001c8gS\u001e\u0004B!a\u0005\u0002\u001a5\u0011\u0011Q\u0003\u0006\u0004\u0003/9\u0012AB3oO&tW-\u0003\u0003\u0002\u001c\u0005U!aG\"p]\u001aLwmV5uQVs'/Z:pYZ,GMV3sg&|g\u000eC\u0004\u0002 5\u0001\r!!\t\u0002\u001d5,GO]5d%\u0016<\u0017n\u001d;ssB!\u00111EA\u0019\u001b\t\t)C\u0003\u0003\u0002(\u0005%\u0012\u0001C7fiJL7m]\u001b\u000b\t\u0005-\u0012QF\u0001\u000bIJ|\u0007o^5{CJ$'BAA\u0018\u0003\tIw.\u0003\u0003\u00024\u0005\u0015\"AD'fiJL7MU3hSN$(/_\u0001\u0016GJ,\u0017\r^3BW.\f\u0007\n\u001e;q\u0005&tG-\u001b8h)!\tI$a\u0013\u0002N\u0005E\u0003CB:\u0002\u0004i\fY\u0004\u0005\u0003\u0002>\u0005\u0015c\u0002BA \u0003\u0003j\u0011AR\u0005\u0004\u0003\u00072\u0015\u0001\u0002%uiBLA!a\u0012\u0002J\ti1+\u001a:wKJ\u0014\u0015N\u001c3j]\u001eT1!a\u0011G\u0011\u001d\tyA\u0004a\u0001\u0003#Aa!a\u0014\u000f\u0001\u0004!\u0014!\u0002:pkR,\u0007bBA*\u001d\u0001\u0007\u0011\u0011E\u0001\u0010[\u0016$(/[2t%\u0016<\u0017n\u001d;ss\u0006A!-\u001b8e\u0011R$\b\u000f\u0006\u0006\u0002Z\u0005}\u00131OA?\u0003\u007f\u0002RA[A.\u0003wI1!!\u0018l\u0005\u00191U\u000f^;sK\"9\u0011\u0011M\bA\u0002\u0005\r\u0014!C5oi\u0016\u0014h-Y2f!\u0011\t)'!\u001c\u000f\t\u0005\u001d\u0014\u0011\u000e\t\u0003u\u0005J1!a\u001b\"\u0003\u0019\u0001&/\u001a3fM&!\u0011qNA9\u0005\u0019\u0019FO]5oO*\u0019\u00111N\u0011\t\u000f\u0005Ut\u00021\u0001\u0002x\u0005!\u0001o\u001c:u!\r\u0001\u0013\u0011P\u0005\u0004\u0003w\n#aA%oi\"1\u0011qJ\bA\u0002QBq!a\u0015\u0010\u0001\u0004\t\t#A\u0005cS:$\u0007\n\u001e;qgRa\u0011\u0011LAC\u0003\u000f\u000bI)a%\u0002\u0016\"9\u0011\u0011\r\tA\u0002\u0005\r\u0004bBA;!\u0001\u0007\u0011q\u000f\u0005\b\u0003\u0017\u0003\u0002\u0019AAG\u00031AG\u000f\u001e9t\u0007>tG/\u001a=u!\u0011\ty$a$\n\u0007\u0005EeI\u0001\fIiR\u00048oQ8o]\u0016\u001cG/[8o\u0007>tG/\u001a=u\u0011\u0019\ty\u0005\u0005a\u0001i!9\u00111\u000b\tA\u0002\u0005\u0005\u0012!\u00079sKB\f'/\u001a%uiBlU\r\u001e:jGJ+w-[:uef$B!a'\u00028B!\u0011QTAZ\u001b\t\tyJ\u0003\u0003\u0002\"\u0006\r\u0016\u0001B2pe\u0016TA!!*\u0002(\u00069Q.\u001a;sS\u000e\u001c(b\u0001!\u0002**\u0019a(a+\u000b\t\u00055\u0016qV\u0001\u0006I\u00064\u0018\u000e\u001e\u0006\u0003\u0003c\u000b!A\u001a:\n\t\u0005U\u0016q\u0014\u0002\u0014\u0011R$\b/T3ue&\u001c7OU3hSN$(/\u001f\u0005\b\u0003'\n\u0002\u0019AA\u0011\u0001")
public class NussknackerHttpServer
implements LazyLogging {
    private final RouteProvider<Function1<RequestContext, Future<RouteResult>>> routeProvider;
    private final ActorSystem systemImplicit;
    private final Materializer materializerImplicit;
    private final ExecutionContext executionContextImplicit;
    private final ContextShift<IO> contextShift;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        NussknackerHttpServer nussknackerHttpServer = this;
        synchronized (nussknackerHttpServer) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private ActorSystem systemImplicit() {
        return this.systemImplicit;
    }

    private Materializer materializerImplicit() {
        return this.materializerImplicit;
    }

    private ExecutionContext executionContextImplicit() {
        return this.executionContextImplicit;
    }

    private ContextShift<IO> contextShift() {
        return this.contextShift;
    }

    public Resource<IO, BoxedUnit> start(ConfigWithUnresolvedVersion config, MetricRegistry metricRegistry) {
        return this.routeProvider.createRoute(config).flatMap((Function1 & Serializable)route -> this.createAkkaHttpBinding(config, (Function1<RequestContext, Future<RouteResult>>)route, metricRegistry).map((Function1 & Serializable)x$1 -> {
            serverBinding = x$1;
            return BoxedUnit.UNIT;
        }, (Applicative)IO$.MODULE$.ioConcurrentEffect(this.contextShift())));
    }

    private Resource<IO, Http.ServerBinding> createAkkaHttpBinding(ConfigWithUnresolvedVersion config, Function1<RequestContext, Future<RouteResult>> route, MetricRegistry metricsRegistry) {
        return Resource$.MODULE$.make((Object)this.createServer$1(config, route, metricsRegistry), (Function1 & Serializable)binding -> this.shutdownServer$1((Http.ServerBinding)binding), (Functor)IO$.MODULE$.ioConcurrentEffect(this.contextShift()));
    }

    private Future<Http.ServerBinding> bindHttp(String string, int port, Function1<RequestContext, Future<RouteResult>> route, MetricRegistry metricsRegistry) {
        return HttpMetrics$.MODULE$.newMeteredServerAt$extension(HttpMetrics$.MODULE$.enrichHttp(Http$.MODULE$.apply((ClassicActorSystemProvider)this.systemImplicit())), string, port, (HttpMetricsHandler)this.prepareHttpMetricRegistry(metricsRegistry)).bind(route);
    }

    private Future<Http.ServerBinding> bindHttps(String string, int port, HttpsConnectionContext httpsContext, Function1<RequestContext, Future<RouteResult>> route, MetricRegistry metricsRegistry) {
        return HttpMetrics$.MODULE$.newMeteredServerAt$extension(HttpMetrics$.MODULE$.enrichHttp(Http$.MODULE$.apply((ClassicActorSystemProvider)this.systemImplicit())), string, port, (HttpMetricsHandler)this.prepareHttpMetricRegistry(metricsRegistry)).enableHttps(httpsContext).bind(route);
    }

    private HttpMetricsRegistry prepareHttpMetricRegistry(MetricRegistry metricsRegistry) {
        HttpMetricsSettings settings = DropwizardSettings$.MODULE$.default();
        return new DropwizardRegistry(settings, metricsRegistry);
    }

    public static final /* synthetic */ void $anonfun$createAkkaHttpBinding$2(NussknackerHttpServer $this, String interface$1, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Http.ServerBinding bindingResult = (Http.ServerBinding)success.value();
            if ($this.logger().underlying().isInfoEnabled()) {
                $this.logger().underlying().info("Nussknacker designer started on {}:{}", new Object[]{interface$1, BoxesRunTime.boxToInteger((int)bindingResult.localAddress().getPort())});
                return;
            }
            return;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            if ($this.logger().underlying().isErrorEnabled()) {
                $this.logger().underlying().error("Nussknacker designer cannot start", exception);
                return;
            }
            return;
        }
        throw new MatchError((Object)try_);
    }

    private final IO createServer$1(ConfigWithUnresolvedVersion config$2, Function1 route$1, MetricRegistry metricsRegistry$1) {
        return IO$.MODULE$.fromFuture(IO$.MODULE$.apply((Function0 & Serializable)() -> {
            Future<Http.ServerBinding> future;
            String string = config$2.resolved().getString("http.interface");
            int port = config$2.resolved().getInt("http.port");
            Option option = SslConfigParser$.MODULE$.sslEnabled(config$2.resolved());
            if (option instanceof Some) {
                Some some = (Some)option;
                KeyStoreConfig keyStoreConfig = (KeyStoreConfig)some.value();
                future = this.bindHttps(string, port, HttpsConnectionContextFactory$.MODULE$.createServerContext(keyStoreConfig), (Function1<RequestContext, Future<RouteResult>>)route$1, metricsRegistry$1);
            } else if (None$.MODULE$.equals(option)) {
                future = this.bindHttp(string, port, (Function1<RequestContext, Future<RouteResult>>)route$1, metricsRegistry$1);
            } else {
                throw new MatchError((Object)option);
            }
            Future<Http.ServerBinding> bindingResultF = future;
            bindingResultF.onComplete((Function1 & Serializable)x0$1 -> {
                NussknackerHttpServer.$anonfun$createAkkaHttpBinding$2(this, string, x0$1);
                return BoxedUnit.UNIT;
            }, this.executionContextImplicit());
            return bindingResultF;
        }), this.contextShift());
    }

    public static final /* synthetic */ void $anonfun$createAkkaHttpBinding$4(Http.HttpTerminated x$2) {
    }

    private final IO shutdownServer$1(Http.ServerBinding binding) {
        return IO$.MODULE$.fromFuture(IO$.MODULE$.apply((Function0 & Serializable)() -> binding.terminate(new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds())), this.contextShift()).map((Function1 & Serializable)x$2 -> {
            NussknackerHttpServer.$anonfun$createAkkaHttpBinding$4(x$2);
            return BoxedUnit.UNIT;
        });
    }

    public NussknackerHttpServer(RouteProvider<Function1<RequestContext, Future<RouteResult>>> routeProvider, ActorSystem system, Materializer materializer) {
        this.routeProvider = routeProvider;
        LazyLogging.$init$((LazyLogging)this);
        this.systemImplicit = system;
        this.materializerImplicit = materializer;
        this.executionContextImplicit = system.dispatcher();
        this.contextShift = IO$.MODULE$.contextShift(this.executionContextImplicit());
    }
}

