/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.api;

import cats.Applicative;
import cats.Functor;
import cats.Invariant$;
import cats.Monad;
import cats.data.EitherT;
import cats.data.EitherT$;
import java.io.Serializable;
import pl.touk.nussknacker.engine.api.process.ProcessName;
import pl.touk.nussknacker.restmodel.scenariodetails.ScenarioWithDetails;
import pl.touk.nussknacker.security.AuthCredentials;
import pl.touk.nussknacker.security.Permission$;
import pl.touk.nussknacker.ui.api.BaseHttpService;
import pl.touk.nussknacker.ui.api.description.DeploymentApiEndpoints;
import pl.touk.nussknacker.ui.api.description.DeploymentApiEndpoints$Dtos$DeploymentError$NoPermission$;
import pl.touk.nussknacker.ui.api.utils.ScenarioHttpServiceExtensions;
import pl.touk.nussknacker.ui.listener.Comment;
import pl.touk.nussknacker.ui.process.ProcessService;
import pl.touk.nussknacker.ui.process.deployment.DeploymentService;
import pl.touk.nussknacker.ui.process.deployment.RunDeploymentCommand;
import pl.touk.nussknacker.ui.process.repository.CommentValidationError;
import pl.touk.nussknacker.ui.security.api.AuthenticationResources;
import pl.touk.nussknacker.ui.security.api.LoggedUser;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Tuple3;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import sttp.tapir.EndpointInput;

@ScalaSignature(bytes="\u0006\u0005\u0005Eb\u0001\u0002\b\u0010\u0001iA\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\t[\u0001\u0011)\u0019!C)]!AQ\u0007\u0001B\u0001B\u0003%q\u0006\u0003\u00057\u0001\t\u0005\t\u0015!\u00038\u0011!i\u0004A!b\u0001\n'r\u0004\u0002C$\u0001\u0005\u0003\u0005\u000b\u0011B \t\u000b!\u0003A\u0011A%\u0006\tA\u0003\u0001&\u0015\u0005\u0006[\u0002!\tF\u001c\u0005\u0006s\u0002!\tF\u001f\u0005\n\u0003\u000b\u0001!\u0019!C\u0005\u0003\u000fA\u0001\"!\u0005\u0001A\u0003%\u0011\u0011\u0002\u0005\b\u0003'\u0001A\u0011KA\u000b\u0005a!U\r\u001d7ps6,g\u000e^!qS\"#H\u000f]*feZL7-\u001a\u0006\u0003!E\t1!\u00199j\u0015\t\u00112#\u0001\u0002vS*\u0011A#F\u0001\f]V\u001c8o\u001b8bG.,'O\u0003\u0002\u0017/\u0005!Ao\\;l\u0015\u0005A\u0012A\u00019m\u0007\u0001\u00192\u0001A\u000e !\taR$D\u0001\u0010\u0013\tqrBA\bCCN,\u0007\n\u001e;q'\u0016\u0014h/[2f!\t\u00013%D\u0001\"\u0015\t\u0011s\"A\u0003vi&d7/\u0003\u0002%C\ti2kY3oCJLw\u000e\u0013;uaN+'O^5dK\u0016CH/\u001a8tS>t7/A\u0007bkRDWM\u001c;jG\u0006$xN\u001d\t\u0003O-j\u0011\u0001\u000b\u0006\u0003!%R!AK\t\u0002\u0011M,7-\u001e:jifL!\u0001\f\u0015\u0003/\u0005+H\u000f[3oi&\u001c\u0017\r^5p]J+7o\\;sG\u0016\u001c\u0018aD:dK:\f'/[8TKJ4\u0018nY3\u0016\u0003=\u0002\"\u0001M\u001a\u000e\u0003ER!AM\t\u0002\u000fA\u0014xnY3tg&\u0011A'\r\u0002\u000f!J|7-Z:t'\u0016\u0014h/[2f\u0003A\u00198-\u001a8be&|7+\u001a:wS\u000e,\u0007%A\teKBdw._7f]R\u001cVM\u001d<jG\u0016\u0004\"\u0001O\u001e\u000e\u0003eR!AO\u0019\u0002\u0015\u0011,\u0007\u000f\\8z[\u0016tG/\u0003\u0002=s\t\tB)\u001a9m_flWM\u001c;TKJ4\u0018nY3\u0002!\u0015DXmY;uS>t7i\u001c8uKb$X#A \u0011\u0005\u0001+U\"A!\u000b\u0005\t\u001b\u0015AC2p]\u000e,(O]3oi*\tA)A\u0003tG\u0006d\u0017-\u0003\u0002G\u0003\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u0012Kb,7-\u001e;j_:\u001cuN\u001c;fqR\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003K\u001b:{ECA&M!\ta\u0002\u0001C\u0003>\u000f\u0001\u000fq\bC\u0003&\u000f\u0001\u0007a\u0005C\u0003.\u000f\u0001\u0007q\u0006C\u00037\u000f\u0001\u0007qGA\tCkNLg.Z:t\u000bJ\u0014xN\u001d+za\u0016\u0004\"A\u00156\u000f\u0005M;gB\u0001+e\u001d\t)&M\u0004\u0002WC:\u0011q\u000b\u0019\b\u00031~s!!\u00170\u000f\u0005ikV\"A.\u000b\u0005qK\u0012A\u0002\u001fs_>$h(C\u0001\u0019\u0013\t1r#\u0003\u0002\u0015+%\u0011!cE\u0005\u0003!EI!aY\b\u0002\u0017\u0011,7o\u0019:jaRLwN\\\u0005\u0003K\u001a\fa\u0003R3qY>LX.\u001a8u\u0003BLWI\u001c3q_&tGo\u001d\u0006\u0003G>I!\u0001[5\u0002\t\u0011#xn\u001d\u0006\u0003K\u001aL!a\u001b7\u0003\u001f\u0011+\u0007\u000f\\8z[\u0016tG/\u0012:s_JT!\u0001[5\u0002\u001f9|7kY3oCJLw.\u0012:s_J$\"!U8\t\u000bAL\u0001\u0019A9\u0002\u0019M\u001cWM\\1sS>t\u0015-\\3\u0011\u0005I<X\"A:\u000b\u0005I\"(B\u0001\tv\u0015\t18#\u0001\u0004f]\u001eLg.Z\u0005\u0003qN\u00141\u0002\u0015:pG\u0016\u001c8OT1nK\u0006\tbn\u001c)fe6L7o]5p]\u0016\u0013(o\u001c:\u0016\u0003mt!\u0001`@\u000f\u0005Ik\u0018B\u0001@m\u0003=!U\r\u001d7ps6,g\u000e^#se>\u0014\u0018\u0002BA\u0001\u0003\u0007\tABT8QKJl\u0017n]:j_:T!A 7\u0002\u0013\u0015tG\r]8j]R\u001cXCAA\u0005!\u0011\tY!!\u0004\u000e\u0003\u0019L1!a\u0004g\u0005Y!U\r\u001d7ps6,g\u000e^!qS\u0016sG\r]8j]R\u001c\u0018AC3oIB|\u0017N\u001c;tA\u0005\t\u0002.\u00198eY\u0016|E\u000f[3s\u000bJ\u0014xN]:\u0016\u0005\u0005]\u0001cBA\r\u00037\ty\"U\u0007\u0002\u0007&\u0019\u0011QD\"\u0003\u001fA\u000b'\u000f^5bY\u001a+hn\u0019;j_:\u0004B!!\t\u0002,9!\u00111EA\u0014\u001d\rQ\u0016QE\u0005\u0002\t&\u0019\u0011\u0011F\"\u0002\u000fA\f7m[1hK&!\u0011QFA\u0018\u0005%!\u0006N]8xC\ndWMC\u0002\u0002*\r\u0003")
public class DeploymentApiHttpService
extends BaseHttpService
implements ScenarioHttpServiceExtensions {
    private final ProcessService scenarioService;
    private final DeploymentService deploymentService;
    private final ExecutionContext executionContext;
    private final DeploymentApiEndpoints endpoints;

    @Override
    public EitherT<Future, Object, ScenarioWithDetails> getScenarioWithDetailsByName(ProcessName scenarioName, LoggedUser loggedUser) {
        return ScenarioHttpServiceExtensions.getScenarioWithDetailsByName$(this, scenarioName, loggedUser);
    }

    @Override
    public <T> EitherT<Future, Object, T> eitherifyErrors(Future<T> future) {
        return ScenarioHttpServiceExtensions.eitherifyErrors$(this, future);
    }

    @Override
    public ProcessService scenarioService() {
        return this.scenarioService;
    }

    @Override
    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    @Override
    public DeploymentApiEndpoints.Dtos.DeploymentError noScenarioError(ProcessName scenarioName) {
        return new DeploymentApiEndpoints.Dtos.DeploymentError.NoScenario(scenarioName);
    }

    @Override
    public DeploymentApiEndpoints$Dtos$DeploymentError$NoPermission$ noPermissionError() {
        return DeploymentApiEndpoints$Dtos$DeploymentError$NoPermission$.MODULE$;
    }

    private DeploymentApiEndpoints endpoints() {
        return this.endpoints;
    }

    public PartialFunction<Throwable, DeploymentApiEndpoints.Dtos.DeploymentError> handleOtherErrors() {
        return new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof CommentValidationError) {
                    CommentValidationError commentValidationError = (CommentValidationError)A1;
                    String message = commentValidationError.message();
                    return (B1)new DeploymentApiEndpoints.Dtos.DeploymentError.DeploymentCommentError(message);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return throwable instanceof CommentValidationError;
            }
        };
    }

    public DeploymentApiHttpService(AuthenticationResources authenticator, ProcessService scenarioService, DeploymentService deploymentService, ExecutionContext executionContext) {
        this.scenarioService = scenarioService;
        this.deploymentService = deploymentService;
        this.executionContext = executionContext;
        super(authenticator, executionContext);
        ScenarioHttpServiceExtensions.$init$(this);
        this.endpoints = new DeploymentApiEndpoints((EndpointInput<AuthCredentials>)authenticator.authenticationMethod());
        this.expose(this.ServerLogicExtension(this.endpoints().requestScenarioDeploymentEndpoint().serverSecurityLogic((Function1 & Serializable)credentials -> this.authorizeKnownUser((AuthCredentials)credentials))).serverLogicEitherT((Function1 & Serializable)loggedUser -> (Function1 & Serializable)x0$1 -> {
            Tuple3 tuple3 = x0$1;
            if (tuple3 != null) {
                ProcessName scenarioName = (ProcessName)tuple3._1();
                DeploymentApiEndpoints.Dtos.DeploymentRequest request = (DeploymentApiEndpoints.Dtos.DeploymentRequest)tuple3._3();
                return this.getScenarioWithDetailsByName(scenarioName, (LoggedUser)loggedUser).flatMap((Function1 & Serializable)scenarioDetails -> EitherT.FromEitherPartiallyApplied$.MODULE$.apply$extension(EitherT$.MODULE$.fromEither(), package$.MODULE$.Either().cond(loggedUser.can(scenarioDetails.processCategory(), Permission$.MODULE$.Deploy()), (Function0)(JFunction0.mcV.sp & Serializable)() -> {}, (Function0 & Serializable)() -> DeploymentApiEndpoints$Dtos$DeploymentError$NoPermission$.MODULE$), (Applicative)Invariant$.MODULE$.catsInstancesForFuture(this.executionContext())).flatMap((Function1 & Serializable)x$2 -> {
                    BoxedUnit boxedUnit = x$2;
                    return this.eitherifyErrors($this.deploymentService.processCommand(new RunDeploymentCommand(scenarioDetails.idWithNameUnsafe(), (Option<String>)None$.MODULE$, (Option<Comment>)request.comment(), request.nodesDeploymentData(), (LoggedUser)loggedUser)).flatten((.less.colon.less)$less$colon$less$.MODULE$.refl())).map((Function1 & Serializable)x$1 -> {
                        option = x$1;
                        return BoxedUnit.UNIT;
                    }, (Functor)Invariant$.MODULE$.catsInstancesForFuture(this.executionContext()));
                }, (Monad)Invariant$.MODULE$.catsInstancesForFuture(this.executionContext())), (Monad)Invariant$.MODULE$.catsInstancesForFuture(this.executionContext()));
            }
            throw new MatchError((Object)tuple3);
        }));
    }
}

