/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.process.newdeployment;

import cats.Applicative;
import cats.Functor;
import cats.Invariant$;
import cats.Monad;
import cats.data.EitherT;
import cats.data.EitherT$;
import db.util.DBIOActionInstances$;
import java.io.Serializable;
import java.sql.Timestamp;
import java.time.Clock;
import pl.touk.nussknacker.engine.api.deployment.DataFreshnessPolicy;
import pl.touk.nussknacker.engine.api.deployment.ProcessState;
import pl.touk.nussknacker.engine.api.process.ProcessIdWithName;
import pl.touk.nussknacker.engine.api.process.ProcessName;
import pl.touk.nussknacker.security.Permission$;
import pl.touk.nussknacker.ui.db.entity.ProcessEntityData;
import pl.touk.nussknacker.ui.process.deployment.CommonCommandData;
import pl.touk.nussknacker.ui.process.newdeployment.DeploymentCommand;
import pl.touk.nussknacker.ui.process.newdeployment.DeploymentEntityFactory;
import pl.touk.nussknacker.ui.process.newdeployment.DeploymentId;
import pl.touk.nussknacker.ui.process.newdeployment.DeploymentRepository;
import pl.touk.nussknacker.ui.process.newdeployment.DeploymentService$NoPermissionError$;
import pl.touk.nussknacker.ui.process.newdeployment.RunDeploymentCommand;
import pl.touk.nussknacker.ui.process.repository.CommentValidationError;
import pl.touk.nussknacker.ui.process.repository.DBIOActionRunner;
import pl.touk.nussknacker.ui.process.repository.ScenarioMetadataRepository;
import pl.touk.nussknacker.ui.security.api.LoggedUser;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.collection.Iterator;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import slick.dbio.DBIOAction;

@ScalaSignature(bytes="\u0006\u0005\u0011Mf!B={\u0001\u0005=\u0001BCA\u000f\u0001\t\u0005\t\u0015!\u0003\u0002 !Q\u00111\u0006\u0001\u0003\u0002\u0003\u0006I!!\f\t\u0015\u0005U\u0002A!A!\u0002\u0013\t9\u0004\u0003\u0006\u0002B\u0001\u0011\t\u0011)A\u0005\u0003\u0007B!\"!\u0013\u0001\u0005\u0003\u0005\u000b\u0011BA&\u0011)\tY\u0006\u0001B\u0001B\u0003-\u0011Q\f\u0005\b\u0003S\u0002A\u0011AA6\u0011\u001d\ti\b\u0001C\u0001\u0003\u007fBqaa%\u0001\t\u0003\u0019)\nC\u0004\u0004P\u0002!Ia!5\t\u000f\rm\u0007\u0001\"\u0003\u0004^\"9Aq\u0004\u0001\u0005\n\u0011\u0005\u0002b\u0002C\u0017\u0001\u0011%Aq\u0006\u0005\b\to\u0001A\u0011\u0002C\u001d\u0011\u001d!\t\u0006\u0001C\u0005\t'Bq\u0001b(\u0001\t\u0013!\tkB\u0004\u0002<jD\t!!0\u0007\reT\b\u0012AA`\u0011\u001d\tIG\u0005C\u0001\u0003\u00034\u0011\"a1\u0013!\u0003\r\n#!2\u0007\u0013\t\u0005&\u0003%A\u0012\"\t\rfABAe%\t\u000bY\r\u0003\u0006\u0002^Z\u0011)\u001a!C\u0001\u0003?D!\"a:\u0017\u0005#\u0005\u000b\u0011BAq\u0011\u001d\tIG\u0006C\u0001\u0003SD\u0011\"a<\u0017\u0003\u0003%\t!!=\t\u0013\u0005Uh#%A\u0005\u0002\u0005]\b\"\u0003B\u0007-\u0005\u0005I\u0011\tB\b\u0011%\u0011iBFA\u0001\n\u0003\u0011y\u0002C\u0005\u0003(Y\t\t\u0011\"\u0001\u0003*!I!Q\u0007\f\u0002\u0002\u0013\u0005#q\u0007\u0005\n\u0005\u000b2\u0012\u0011!C\u0001\u0005\u000fB\u0011B!\u0015\u0017\u0003\u0003%\tEa\u0015\t\u0013\t]c#!A\u0005B\te\u0003\"\u0003B.-\u0005\u0005I\u0011\tB/\u0011%\u0011yFFA\u0001\n\u0003\u0012\tgB\u0005\u0004\u0016I\t\t\u0011#\u0001\u0004\u0018\u0019I\u0011\u0011\u001a\n\u0002\u0002#\u00051\u0011\u0004\u0005\b\u0003S2C\u0011AB\u0019\u0011%\u0011YFJA\u0001\n\u000b\u0012i\u0006C\u0005\u00044\u0019\n\t\u0011\"!\u00046!I1\u0011\b\u0014\u0002\u0002\u0013\u000551\b\u0005\n\u0005#4\u0013\u0011!C\u0005\u0005'4aAa7\u0013\u0005\nu\u0007B\u0003BpY\tU\r\u0011\"\u0001\u0003b\"Q!Q\u001f\u0017\u0003\u0012\u0003\u0006IAa9\t\u000f\u0005%D\u0006\"\u0001\u0003x\"I\u0011q\u001e\u0017\u0002\u0002\u0013\u0005!Q \u0005\n\u0003kd\u0013\u0013!C\u0001\u0007\u0003A\u0011B!\u0004-\u0003\u0003%\tEa\u0004\t\u0013\tuA&!A\u0005\u0002\t}\u0001\"\u0003B\u0014Y\u0005\u0005I\u0011AB\u0003\u0011%\u0011)\u0004LA\u0001\n\u0003\u00129\u0004C\u0005\u0003F1\n\t\u0011\"\u0001\u0004\n!I!\u0011\u000b\u0017\u0002\u0002\u0013\u00053Q\u0002\u0005\n\u0005/b\u0013\u0011!C!\u00053B\u0011Ba\u0017-\u0003\u0003%\tE!\u0018\t\u0013\t}C&!A\u0005B\rEq!CB$%\u0005\u0005\t\u0012AB%\r%\u0011YNEA\u0001\u0012\u0003\u0019Y\u0005C\u0004\u0002jq\"\taa\u0014\t\u0013\tmC(!A\u0005F\tu\u0003\"CB\u001ay\u0005\u0005I\u0011QB)\u0011%\u0019I\u0004PA\u0001\n\u0003\u001b)\u0006C\u0005\u0003Rr\n\t\u0011\"\u0003\u0003T\u001a1!q\u0015\nC\u0005SC!\"!8C\u0005+\u0007I\u0011AAp\u0011)\t9O\u0011B\tB\u0003%\u0011\u0011\u001d\u0005\b\u0003S\u0012E\u0011\u0001BV\u0011%\tyOQA\u0001\n\u0003\u0011\t\fC\u0005\u0002v\n\u000b\n\u0011\"\u0001\u0002x\"I!Q\u0002\"\u0002\u0002\u0013\u0005#q\u0002\u0005\n\u0005;\u0011\u0015\u0011!C\u0001\u0005?A\u0011Ba\nC\u0003\u0003%\tA!.\t\u0013\tU\")!A\u0005B\t]\u0002\"\u0003B#\u0005\u0006\u0005I\u0011\u0001B]\u0011%\u0011\tFQA\u0001\n\u0003\u0012i\fC\u0005\u0003X\t\u000b\t\u0011\"\u0011\u0003Z!I!1\f\"\u0002\u0002\u0013\u0005#Q\f\u0005\n\u0005?\u0012\u0015\u0011!C!\u0005\u0003<\u0011ba\u0017\u0013\u0003\u0003E\ta!\u0018\u0007\u0013\t\u001d&#!A\t\u0002\r}\u0003bBA5%\u0012\u000511\r\u0005\n\u00057\u0012\u0016\u0011!C#\u0005;B\u0011ba\rS\u0003\u0003%\ti!\u001a\t\u0013\re\"+!A\u0005\u0002\u000e%\u0004\"\u0003Bi%\u0006\u0005I\u0011\u0002Bj\u000f\u001d\u0019iG\u0005EA\u0005\u000f4qAa'\u0013\u0011\u0003\u0013i\nC\u0004\u0002je#\tA!2\t\u0013\t5\u0011,!A\u0005B\t=\u0001\"\u0003B\u000f3\u0006\u0005I\u0011\u0001B\u0010\u0011%\u00119#WA\u0001\n\u0003\u0011I\rC\u0005\u00036e\u000b\t\u0011\"\u0011\u00038!I!QI-\u0002\u0002\u0013\u0005!Q\u001a\u0005\n\u0005/J\u0016\u0011!C!\u00053B\u0011Ba\u0017Z\u0003\u0003%\tE!\u0018\t\u0013\tE\u0017,!A\u0005\n\tMgA\u0002B3%\t\u00139\u0007\u0003\u0006\u0003j\r\u0014)\u001a!C\u0001\u0005WB!Ba\u001fd\u0005#\u0005\u000b\u0011\u0002B7\u0011\u001d\tIg\u0019C\u0001\u0005{B\u0011\"a<d\u0003\u0003%\tAa!\t\u0013\u0005U8-%A\u0005\u0002\t\u001d\u0005\"\u0003B\u0007G\u0006\u0005I\u0011\tB\b\u0011%\u0011ibYA\u0001\n\u0003\u0011y\u0002C\u0005\u0003(\r\f\t\u0011\"\u0001\u0003\f\"I!QG2\u0002\u0002\u0013\u0005#q\u0007\u0005\n\u0005\u000b\u001a\u0017\u0011!C\u0001\u0005\u001fC\u0011B!\u0015d\u0003\u0003%\tEa%\t\u0013\t]3-!A\u0005B\te\u0003\"\u0003B.G\u0006\u0005I\u0011\tB/\u0011%\u0011yfYA\u0001\n\u0003\u00129jB\u0005\u0004pI\t\t\u0011#\u0001\u0004r\u0019I!Q\r\n\u0002\u0002#\u000511\u000f\u0005\b\u0003S\u001aH\u0011AB<\u0011%\u0011Yf]A\u0001\n\u000b\u0012i\u0006C\u0005\u00044M\f\t\u0011\"!\u0004z!I1\u0011H:\u0002\u0002\u0013\u00055Q\u0010\u0005\n\u0005#\u001c\u0018\u0011!C\u0005\u0005'\u0014\u0011\u0003R3qY>LX.\u001a8u'\u0016\u0014h/[2f\u0015\tYH0A\u0007oK^$W\r\u001d7ps6,g\u000e\u001e\u0006\u0003{z\fq\u0001\u001d:pG\u0016\u001c8OC\u0002\u0000\u0003\u0003\t!!^5\u000b\t\u0005\r\u0011QA\u0001\f]V\u001c8o\u001b8bG.,'O\u0003\u0003\u0002\b\u0005%\u0011\u0001\u0002;pk.T!!a\u0003\u0002\u0005Ad7\u0001A\n\u0004\u0001\u0005E\u0001\u0003BA\n\u00033i!!!\u0006\u000b\u0005\u0005]\u0011!B:dC2\f\u0017\u0002BA\u000e\u0003+\u0011a!\u00118z%\u00164\u0017AG:dK:\f'/[8NKR\fG-\u0019;b%\u0016\u0004xn]5u_JL\b\u0003BA\u0011\u0003Oi!!a\t\u000b\u0007\u0005\u0015B0\u0001\u0006sKB|7/\u001b;pefLA!!\u000b\u0002$\tQ2kY3oCJLw.T3uC\u0012\fG/\u0019*fa>\u001c\u0018\u000e^8ss\u0006!B-\u001a9m_flWM\u001c;SKB|7/\u001b;pef\u0004B!a\f\u000225\t!0C\u0002\u00024i\u0014A\u0003R3qY>LX.\u001a8u%\u0016\u0004xn]5u_JL\u0018a\u00067fO\u0006\u001c\u0017\u0010R3qY>LX.\u001a8u'\u0016\u0014h/[2f!\u0011\tI$a\u0010\u000e\u0005\u0005m\"bAA\u001fy\u0006QA-\u001a9m_flWM\u001c;\n\u0007e\fY$\u0001\u0006eE&|'+\u001e8oKJ\u0004B!!\t\u0002F%!\u0011qIA\u0012\u0005A!%)S(BGRLwN\u001c*v]:,'/A\u0003dY>\u001c7\u000e\u0005\u0003\u0002N\u0005]SBAA(\u0015\u0011\t\t&a\u0015\u0002\tQLW.\u001a\u0006\u0003\u0003+\nAA[1wC&!\u0011\u0011LA(\u0005\u0015\u0019En\\2l\u0003\t)7\r\u0005\u0003\u0002`\u0005\u0015TBAA1\u0015\u0011\t\u0019'!\u0006\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0002h\u0005\u0005$\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0003\u0019a\u0014N\\5u}Qa\u0011QNA:\u0003k\n9(!\u001f\u0002|Q!\u0011qNA9!\r\ty\u0003\u0001\u0005\b\u00037:\u00019AA/\u0011\u001d\tib\u0002a\u0001\u0003?Aq!a\u000b\b\u0001\u0004\ti\u0003C\u0004\u00026\u001d\u0001\r!a\u000e\t\u000f\u0005\u0005s\u00011\u0001\u0002D!9\u0011\u0011J\u0004A\u0002\u0005-\u0013A\u00049s_\u000e,7o]\"p[6\fg\u000e\u001a\u000b\u0005\u0003\u0003\u001bI\t\u0005\u0004\u0002`\u0005\r\u0015qQ\u0005\u0005\u0003\u000b\u000b\tG\u0001\u0004GkR,(/\u001a\t\t\u0003\u0013\u000bI*a(\u0004\u0004:!\u00111RAK\u001d\u0011\ti)a%\u000e\u0005\u0005=%\u0002BAI\u0003\u001b\ta\u0001\u0010:p_Rt\u0014BAA\f\u0013\u0011\t9*!\u0006\u0002\u000fA\f7m[1hK&!\u00111TAO\u0005\u0019)\u0015\u000e\u001e5fe*!\u0011qSA\u000b!\r\t\t\u000b\u0006\b\u0004\u0003G\u000bb\u0002BAS\u0003ssA!a*\u00028:!\u0011\u0011VA[\u001d\u0011\tY+a-\u000f\t\u00055\u0016\u0011\u0017\b\u0005\u0003\u001b\u000by+\u0003\u0002\u0002\f%!\u0011qAA\u0005\u0013\u0011\t\u0019!!\u0002\n\u0007}\f\t!\u0003\u0002~}&\u00111\u0010`\u0001\u0012\t\u0016\u0004Hn\\=nK:$8+\u001a:wS\u000e,\u0007cAA\u0018%M\u0019!#!\u0005\u0015\u0005\u0005u&A\u0005*v]\u0012+\u0007\u000f\\8z[\u0016tG/\u0012:s_J\u001c2\u0001FA\tS\u0015!bcY--\u0005q\u0019uN\u001c4mS\u000e$\u0018N\\4EKBdw._7f]RLE-\u0012:s_J\u001c\u0012BFA\t\u0003\u001b\f\t.a6\u0011\u0007\u0005=G#D\u0001\u0013!\u0011\t\u0019\"a5\n\t\u0005U\u0017Q\u0003\u0002\b!J|G-^2u!\u0011\tI)!7\n\t\u0005m\u0017Q\u0014\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0003S\u0012,\"!!9\u0011\t\u0005=\u00121]\u0005\u0004\u0003KT(\u0001\u0004#fa2|\u00170\\3oi&#\u0017aA5eAQ!\u00111^Aw!\r\tyM\u0006\u0005\b\u0003;L\u0002\u0019AAq\u0003\u0011\u0019w\u000e]=\u0015\t\u0005-\u00181\u001f\u0005\n\u0003;T\u0002\u0013!a\u0001\u0003C\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002z*\"\u0011\u0011]A~W\t\ti\u0010\u0005\u0003\u0002\u0000\n%QB\u0001B\u0001\u0015\u0011\u0011\u0019A!\u0002\u0002\u0013Ut7\r[3dW\u0016$'\u0002\u0002B\u0004\u0003+\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0011YA!\u0001\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005#\u0001BAa\u0005\u0003\u001a5\u0011!Q\u0003\u0006\u0005\u0005/\t\u0019&\u0001\u0003mC:<\u0017\u0002\u0002B\u000e\u0005+\u0011aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXC\u0001B\u0011!\u0011\t\u0019Ba\t\n\t\t\u0015\u0012Q\u0003\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005W\u0011\t\u0004\u0005\u0003\u0002\u0014\t5\u0012\u0002\u0002B\u0018\u0003+\u00111!\u00118z\u0011%\u0011\u0019DHA\u0001\u0002\u0004\u0011\t#A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005s\u0001bAa\u000f\u0003B\t-RB\u0001B\u001f\u0015\u0011\u0011y$!\u0006\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003D\tu\"\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$BA!\u0013\u0003PA!\u00111\u0003B&\u0013\u0011\u0011i%!\u0006\u0003\u000f\t{w\u000e\\3b]\"I!1\u0007\u0011\u0002\u0002\u0003\u0007!1F\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0003\u0012\tU\u0003\"\u0003B\u001aC\u0005\u0005\t\u0019\u0001B\u0011\u0003!A\u0017m\u001d5D_\u0012,GC\u0001B\u0011\u0003!!xn\u0015;sS:<GC\u0001B\t\u0003\u0019)\u0017/^1mgR!!\u0011\nB2\u0011%\u0011\u0019\u0004JA\u0001\u0002\u0004\u0011YCA\rOK^\u001cu.\\7f]R4\u0016\r\\5eCRLwN\\#se>\u00148#C2\u0002\u0012\u00055\u0017\u0011[Al\u0003\u001diWm]:bO\u0016,\"A!\u001c\u0011\t\t=$q\u000f\b\u0005\u0005c\u0012\u0019\b\u0005\u0003\u0002\u000e\u0006U\u0011\u0002\u0002B;\u0003+\ta\u0001\u0015:fI\u00164\u0017\u0002\u0002B\u000e\u0005sRAA!\u001e\u0002\u0016\u0005AQ.Z:tC\u001e,\u0007\u0005\u0006\u0003\u0003\u0000\t\u0005\u0005cAAhG\"9!\u0011\u000e4A\u0002\t5D\u0003\u0002B@\u0005\u000bC\u0011B!\u001bh!\u0003\u0005\rA!\u001c\u0016\u0005\t%%\u0006\u0002B7\u0003w$BAa\u000b\u0003\u000e\"I!1G6\u0002\u0002\u0003\u0007!\u0011\u0005\u000b\u0005\u0005\u0013\u0012\t\nC\u0005\u000345\f\t\u00111\u0001\u0003,Q!!\u0011\u0003BK\u0011%\u0011\u0019D\\A\u0001\u0002\u0004\u0011\t\u0003\u0006\u0003\u0003J\te\u0005\"\u0003B\u001ac\u0006\u0005\t\u0019\u0001B\u0016\u0005Equ\u000eU3s[&\u001c8/[8o\u000bJ\u0014xN]\n\f3\u0006E\u0011Q\u001aBP\u0003#\f9\u000eE\u0002\u0002PV\u0011\u0001dR3u\t\u0016\u0004Hn\\=nK:$8\u000b^1ukN,%O]8s'\r)\u0012\u0011C\u0015\u0004+\tK&a\u0006#fa2|\u00170\\3oi:{GOR8v]\u0012,%O]8s'%\u0011\u0015\u0011\u0003BP\u0003#\f9\u000e\u0006\u0003\u0003.\n=\u0006cAAh\u0005\"9\u0011Q\\#A\u0002\u0005\u0005H\u0003\u0002BW\u0005gC\u0011\"!8G!\u0003\u0005\r!!9\u0015\t\t-\"q\u0017\u0005\n\u0005gQ\u0015\u0011!a\u0001\u0005C!BA!\u0013\u0003<\"I!1\u0007'\u0002\u0002\u0003\u0007!1\u0006\u000b\u0005\u0005#\u0011y\fC\u0005\u000345\u000b\t\u00111\u0001\u0003\"Q!!\u0011\nBb\u0011%\u0011\u0019\u0004UA\u0001\u0002\u0004\u0011Y\u0003\u0006\u0002\u0003HB\u0019\u0011qZ-\u0015\t\t-\"1\u001a\u0005\n\u0005gi\u0016\u0011!a\u0001\u0005C!BA!\u0013\u0003P\"I!1G0\u0002\u0002\u0003\u0007!1F\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005+\u0004BAa\u0005\u0003X&!!\u0011\u001cB\u000b\u0005\u0019y%M[3di\n)2kY3oCJLwNT8u\r>,h\u000eZ#se>\u00148#\u0003\u0017\u0002\u0012\u00055\u0017\u0011[Al\u00031\u00198-\u001a8be&|g*Y7f+\t\u0011\u0019\u000f\u0005\u0003\u0003f\nEXB\u0001Bt\u0015\ri(\u0011\u001e\u0006\u0005\u0005W\u0014i/A\u0002ba&TAAa<\u0002\u0002\u00051QM\\4j]\u0016LAAa=\u0003h\nY\u0001K]8dKN\u001ch*Y7f\u00035\u00198-\u001a8be&|g*Y7fAQ!!\u0011 B~!\r\ty\r\f\u0005\b\u0005?|\u0003\u0019\u0001Br)\u0011\u0011IPa@\t\u0013\t}\u0007\u0007%AA\u0002\t\rXCAB\u0002U\u0011\u0011\u0019/a?\u0015\t\t-2q\u0001\u0005\n\u0005g!\u0014\u0011!a\u0001\u0005C!BA!\u0013\u0004\f!I!1\u0007\u001c\u0002\u0002\u0003\u0007!1\u0006\u000b\u0005\u0005#\u0019y\u0001C\u0005\u00034]\n\t\u00111\u0001\u0003\"Q!!\u0011JB\n\u0011%\u0011\u0019DOA\u0001\u0002\u0004\u0011Y#\u0001\u000fD_:4G.[2uS:<G)\u001a9m_flWM\u001c;JI\u0016\u0013(o\u001c:\u0011\u0007\u0005=geE\u0003'\u00077\u00199\u0003\u0005\u0005\u0004\u001e\r\r\u0012\u0011]Av\u001b\t\u0019yB\u0003\u0003\u0004\"\u0005U\u0011a\u0002:v]RLW.Z\u0005\u0005\u0007K\u0019yBA\tBEN$(/Y2u\rVt7\r^5p]F\u0002Ba!\u000b\u000405\u001111\u0006\u0006\u0005\u0007[\t\u0019&\u0001\u0002j_&!\u00111\\B\u0016)\t\u00199\"A\u0003baBd\u0017\u0010\u0006\u0003\u0002l\u000e]\u0002bBAoS\u0001\u0007\u0011\u0011]\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0019ida\u0011\u0011\r\u0005M1qHAq\u0013\u0011\u0019\t%!\u0006\u0003\r=\u0003H/[8o\u0011%\u0019)EKA\u0001\u0002\u0004\tY/A\u0002yIA\nQcU2f]\u0006\u0014\u0018n\u001c(pi\u001a{WO\u001c3FeJ|'\u000fE\u0002\u0002Pr\u001aR\u0001PB'\u0007O\u0001\u0002b!\b\u0004$\t\r(\u0011 \u000b\u0003\u0007\u0013\"BA!?\u0004T!9!q\\ A\u0002\t\rH\u0003BB,\u00073\u0002b!a\u0005\u0004@\t\r\b\"CB#\u0001\u0006\u0005\t\u0019\u0001B}\u0003]!U\r\u001d7ps6,g\u000e\u001e(pi\u001a{WO\u001c3FeJ|'\u000fE\u0002\u0002PJ\u001bRAUB1\u0007O\u0001\u0002b!\b\u0004$\u0005\u0005(Q\u0016\u000b\u0003\u0007;\"BA!,\u0004h!9\u0011Q\\+A\u0002\u0005\u0005H\u0003BB\u001f\u0007WB\u0011b!\u0012W\u0003\u0003\u0005\rA!,\u0002#9{\u0007+\u001a:nSN\u001c\u0018n\u001c8FeJ|'/A\rOK^\u001cu.\\7f]R4\u0016\r\\5eCRLwN\\#se>\u0014\bcAAhgN)1o!\u001e\u0004(AA1QDB\u0012\u0005[\u0012y\b\u0006\u0002\u0004rQ!!qPB>\u0011\u001d\u0011IG\u001ea\u0001\u0005[\"Baa \u0004\u0002B1\u00111CB \u0005[B\u0011b!\u0012x\u0003\u0003\u0005\rAa \u0011\t\u0005M1QQ\u0005\u0005\u0007\u000f\u000b)B\u0001\u0003V]&$\bbBBF\u0011\u0001\u00071QR\u0001\bG>lW.\u00198e!\u0011\tyca$\n\u0007\rE%PA\tEKBdw._7f]R\u001cu.\\7b]\u0012\f1cZ3u\t\u0016\u0004Hn\\=nK:$8\u000b^1ukN$Baa&\u0004NR!1\u0011TB^!\u0019\ty&a!\u0004\u001cBA\u0011\u0011RAM\u0007;\u001by\nE\u0002\u0002\"V\u0001Ba!)\u00046:!11UBX\u001d\u0011\u0019)k!,\u000f\t\r\u001d61\u0016\b\u0005\u0003S\u001bI+\u0003\u0003\u0003p\u0006\u0005\u0011\u0002\u0002Bv\u0005[LA!!\u0010\u0003j&!1\u0011WBZ\u0003-\u0019F/\u0019;f'R\fG/^:\u000b\t\u0005u\"\u0011^\u0005\u0005\u0007o\u001bIL\u0001\u0006Ti\u0006$Xo\u001d(b[\u0016TAa!-\u00044\"91QX\u0005A\u0004\r}\u0016A\u00037pO\u001e,G-V:feB!1\u0011YBe\u001b\t\u0019\u0019M\u0003\u0003\u0003l\u000e\u0015'bABd}\u0006A1/Z2ve&$\u00180\u0003\u0003\u0004L\u000e\r'A\u0003'pO\u001e,G-V:fe\"9\u0011Q\\\u0005A\u0002\u0005\u0005\u0018!\u0004:v]\u0012+\u0007\u000f\\8z[\u0016tG\u000f\u0006\u0003\u0002\u0002\u000eM\u0007bBBF\u0015\u0001\u00071Q\u001b\t\u0005\u0003_\u00199.C\u0002\u0004Zj\u0014ACU;o\t\u0016\u0004Hn\\=nK:$8i\\7nC:$\u0017aE4fiN\u001bWM\\1sS>lU\r^1eCR\fG\u0003BBp\t;\u0001\"b!9\u0004l\u000e=HQ\u0002C\b\u001b\t\u0019\u0019O\u0003\u0003\u0004f\u000e\u001d\u0018\u0001\u00023bi\u0006T!a!;\u0002\t\r\fGo]\u0005\u0005\u0007[\u001c\u0019OA\u0004FSRDWM\u001d+\u0011\t\rEHq\u0001\b\u0005\u0007g$\tA\u0004\u0003\u0004v\u000emh\u0002BAG\u0007oL!a!?\u0002\u0005\u0011\u0014\u0017\u0002BB\u007f\u0007\u007f\fA!\u001e;jY*\u00111\u0011`\u0005\u0005\t\u0007!)!A\nE\u0005&{\u0015i\u0019;j_:Len\u001d;b]\u000e,7O\u0003\u0003\u0004~\u000e}\u0018\u0002\u0002C\u0005\t\u0017\u0011!\u0001\u0012\"\u000b\t\u0011\rAQ\u0001\t\u0004\u0003Cc\u0003\u0003\u0002C\t\t3i!\u0001b\u0005\u000b\t\u0011UAqC\u0001\u0007K:$\u0018\u000e^=\u000b\u0007\reh0\u0003\u0003\u0005\u001c\u0011M!!\u0005)s_\u000e,7o]#oi&$\u0018\u0010R1uC\"911R\u0006A\u0002\rU\u0017AD:bm\u0016$U\r\u001d7ps6,g\u000e\u001e\u000b\u0007\tG!9\u0003\"\u000b\u0011\u0015\r\u000581^Bx\tK\u0019\u0019\tE\u0002\u0002\"ZAqaa#\r\u0001\u0004\u0019)\u000eC\u0004\u0005,1\u0001\r\u0001b\u0004\u0002!M\u001cWM\\1sS>lU\r^1eCR\f\u0017AH5om>\\W\rT3hC\u000eL(+\u001e8EKBdw._7f]RdunZ5d)\u0019!\t\u0004b\r\u00056AQ1\u0011]Bv\u0007_\fyja!\t\u000f\r-U\u00021\u0001\u0004V\"9A1F\u0007A\u0002\u0011=\u0011!E4fi\u0012+\u0007\u000f\\8z[\u0016tGOQ=JIR!A1\bC(!)\u0019\toa;\u0005>\u0011}B\u0011\t\t\u0005\u0003?\n\u0019\tE\u0002\u0002\"\n\u0003B\u0001b\u0011\u0005J9!\u00111\u0015C#\u0013\r!9E_\u0001\u0015\t\u0016\u0004Hn\\=nK:$(+\u001a9pg&$xN]=\n\t\u0011-CQ\n\u0002\u001f\t\u0016\u0004Hn\\=nK:$x+\u001b;i'\u000e,g.\u0019:j_6+G/\u00193bi\u0006T1\u0001b\u0012{\u0011\u001d\tiN\u0004a\u0001\u0003C\fqb\u00195fG.\u0004VM]7jgNLwN\\\u000b\u0005\t+\"y\u0006\u0006\u0005\u0005X\u0011}D1\u0011CD)\u0011!I\u0006b\u001d\u0011\u0015\r\u000581\u001eC.\tc\u001a\u0019\t\u0005\u0003\u0005^\u0011}C\u0002\u0001\u0003\b\tCz!\u0019\u0001C2\u0005\u00051U\u0003\u0002C3\t[\nB\u0001b\u001a\u0003,A!\u00111\u0003C5\u0013\u0011!Y'!\u0006\u0003\u000f9{G\u000f[5oO\u0012AAq\u000eC0\u0005\u0004!)G\u0001\u0003`I\u0011\ndbAAQ1\"IAQO\b\u0002\u0002\u0003\u000fAqO\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004C\u0002C=\tw\"Y&\u0004\u0002\u0004h&!AQPBt\u0005-\t\u0005\u000f\u001d7jG\u0006$\u0018N^3\t\u000f\u0011\u0005u\u00021\u0001\u0004@\u0006!Qo]3s\u0011\u001d!)i\u0004a\u0001\u0005[\n\u0001bY1uK\u001e|'/\u001f\u0005\b\t\u0013{\u0001\u0019\u0001CF\u0003)\u0001XM]7jgNLwN\u001c\t\u0005\t\u001b#IJ\u0004\u0003\u0005\u0010\u0012Me\u0002BAU\t#KAaa2\u0002\u0002%!AQ\u0013CL\u0003)\u0001VM]7jgNLwN\u001c\u0006\u0005\u0007\u000f\f\t!\u0003\u0003\u0005\u001c\u0012u%A\u0003)fe6L7o]5p]*!AQ\u0013CL\u0003E9W\r^*dK:\f'/[8Ti\u0006$Xo\u001d\u000b\u0005\tG#\t\f\u0006\u0003\u0005&\u0012=\u0006CCBq\u0007W$id!(\u0005(B!A\u0011\u0016CV\u001b\t\u0019\u0019,\u0003\u0003\u0005.\u000eM&\u0001\u0004)s_\u000e,7o]*uCR,\u0007bBB_!\u0001\u000f1q\u0018\u0005\b\tW\u0001\u0002\u0019\u0001C\b\u0001")
public class DeploymentService {
    private final ScenarioMetadataRepository scenarioMetadataRepository;
    private final DeploymentRepository deploymentRepository;
    private final pl.touk.nussknacker.ui.process.deployment.DeploymentService legacyDeploymentService;
    private final DBIOActionRunner dbioRunner;
    private final Clock clock;
    private final ExecutionContext ec;

    public Future<Either<RunDeploymentError, BoxedUnit>> processCommand(DeploymentCommand command) {
        DeploymentCommand deploymentCommand = command;
        if (deploymentCommand instanceof RunDeploymentCommand) {
            RunDeploymentCommand runDeploymentCommand = (RunDeploymentCommand)deploymentCommand;
            return this.runDeployment(runDeploymentCommand);
        }
        throw new MatchError((Object)deploymentCommand);
    }

    public Future<Either<GetDeploymentStatusError, String>> getDeploymentStatus(DeploymentId id, LoggedUser loggedUser) {
        return (Future)this.getDeploymentById(id).flatMap((Function1 & Serializable)deploymentWithScenarioMetadata -> this.checkPermission(loggedUser, deploymentWithScenarioMetadata.scenarioMetadata().processCategory(), Permission$.MODULE$.Read(), (Applicative)Invariant$.MODULE$.catsInstancesForFuture($this.ec)).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = x$1;
            return this.getScenarioStatus(deploymentWithScenarioMetadata.scenarioMetadata(), loggedUser).map((Function1 & Serializable)scenarioState -> scenarioState.status().name(), (Functor)Invariant$.MODULE$.catsInstancesForFuture($this.ec));
        }, (Monad)Invariant$.MODULE$.catsInstancesForFuture($this.ec)), (Monad)Invariant$.MODULE$.catsInstancesForFuture(this.ec)).value();
    }

    private Future<Either<RunDeploymentError, BoxedUnit>> runDeployment(RunDeploymentCommand command) {
        return this.dbioRunner.run((DBIOAction)this.getScenarioMetadata(command).flatMap((Function1 & Serializable)scenarioMetadata -> this.checkPermission(command.user(), scenarioMetadata.processCategory(), Permission$.MODULE$.Deploy(), (Applicative)DBIOActionInstances$.MODULE$.dbMonad($this.ec)).flatMap((Function1 & Serializable)x$3 -> {
            BoxedUnit boxedUnit = x$3;
            return this.saveDeployment(command, (ProcessEntityData)scenarioMetadata).flatMap((Function1 & Serializable)x$2 -> {
                BoxedUnit boxedUnit = x$2;
                return this.invokeLegacyRunDeploymentLogic(command, (ProcessEntityData)scenarioMetadata).map((Function1 & Serializable)runResult -> {
                    DeploymentService.$anonfun$runDeployment$4(runResult);
                    return BoxedUnit.UNIT;
                }, DBIOActionInstances$.MODULE$.dbMonad($this.ec));
            }, DBIOActionInstances$.MODULE$.dbMonad($this.ec));
        }, DBIOActionInstances$.MODULE$.dbMonad($this.ec)), DBIOActionInstances$.MODULE$.dbMonad(this.ec)).value());
    }

    private EitherT<DBIOAction, ScenarioNotFoundError, ProcessEntityData> getScenarioMetadata(RunDeploymentCommand command) {
        return EitherT$.MODULE$.fromOptionF(this.scenarioMetadataRepository.getScenarioMetadata(command.scenarioName()), (Function0 & Serializable)() -> new ScenarioNotFoundError(command.scenarioName()), DBIOActionInstances$.MODULE$.dbMonad(this.ec));
    }

    private EitherT<DBIOAction, ConflictingDeploymentIdError, BoxedUnit> saveDeployment(RunDeploymentCommand command, ProcessEntityData scenarioMetadata) {
        return new EitherT(this.deploymentRepository.saveDeployment(new DeploymentEntityFactory.DeploymentEntityData(command.id(), scenarioMetadata.id(), Timestamp.from(this.clock.instant()), command.user().id()))).leftMap((Function1 & Serializable)e -> new ConflictingDeploymentIdError(e.id()), DBIOActionInstances$.MODULE$.dbMonad(this.ec));
    }

    private EitherT<DBIOAction, RunDeploymentError, BoxedUnit> invokeLegacyRunDeploymentLogic(RunDeploymentCommand command, ProcessEntityData scenarioMetadata) {
        return new EitherT((Object)DBIOActionInstances$.MODULE$.DB().from(this.legacyDeploymentService.processCommand(new pl.touk.nussknacker.ui.process.deployment.RunDeploymentCommand(new CommonCommandData(new ProcessIdWithName(scenarioMetadata.id(), command.scenarioName()), command.comment(), command.user()), (Option<String>)None$.MODULE$, command.nodesDeploymentData())).transform((Function1 & Serializable)result -> result.map((Function1 & Serializable)x$4 -> package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)).recover((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof CommentValidationError) {
                    CommentValidationError commentValidationError = (CommentValidationError)A1;
                    String msg = commentValidationError.message();
                    return (B1)package$.MODULE$.Left().apply((Object)new NewCommentValidationError(msg));
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return throwable instanceof CommentValidationError;
            }
        }), this.ec)));
    }

    private EitherT<Future, DeploymentNotFoundError, DeploymentRepository.DeploymentWithScenarioMetadata> getDeploymentById(DeploymentId id) {
        return EitherT$.MODULE$.fromOptionF(this.dbioRunner.run(this.deploymentRepository.getDeploymentById(id)), (Function0 & Serializable)() -> new DeploymentNotFoundError(id), (Functor)Invariant$.MODULE$.catsInstancesForFuture(this.ec));
    }

    private <F> EitherT<F, DeploymentService$NoPermissionError$, BoxedUnit> checkPermission(LoggedUser user, String category, Enumeration.Value permission, Applicative<F> evidence$1) {
        return EitherT.CondPartiallyApplied$.MODULE$.apply$extension(EitherT$.MODULE$.cond(), user.can(category, permission), (Function0)(JFunction0.mcV.sp & Serializable)() -> {}, (Function0 & Serializable)() -> DeploymentService$NoPermissionError$.MODULE$, evidence$1);
    }

    private EitherT<Future, GetDeploymentStatusError, ProcessState> getScenarioStatus(ProcessEntityData scenarioMetadata, LoggedUser loggedUser) {
        DataFreshnessPolicy.Fresh$ freshnessPolicy = DataFreshnessPolicy.Fresh$.MODULE$;
        return EitherT.RightPartiallyApplied$.MODULE$.apply$extension(EitherT$.MODULE$.right(), this.legacyDeploymentService.getProcessState(new ProcessIdWithName(scenarioMetadata.id(), scenarioMetadata.name()), loggedUser, (DataFreshnessPolicy)freshnessPolicy), (Functor)Invariant$.MODULE$.catsInstancesForFuture(this.ec));
    }

    public static final /* synthetic */ void $anonfun$runDeployment$4(BoxedUnit runResult) {
    }

    public DeploymentService(ScenarioMetadataRepository scenarioMetadataRepository, DeploymentRepository deploymentRepository, pl.touk.nussknacker.ui.process.deployment.DeploymentService legacyDeploymentService, DBIOActionRunner dbioRunner, Clock clock, ExecutionContext ec) {
        this.scenarioMetadataRepository = scenarioMetadataRepository;
        this.deploymentRepository = deploymentRepository;
        this.legacyDeploymentService = legacyDeploymentService;
        this.dbioRunner = dbioRunner;
        this.clock = clock;
        this.ec = ec;
    }

    public static final class ConflictingDeploymentIdError
    implements RunDeploymentError,
    Product,
    Serializable {
        private final DeploymentId id;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public DeploymentId id() {
            return this.id;
        }

        public ConflictingDeploymentIdError copy(DeploymentId id) {
            return new ConflictingDeploymentIdError(id);
        }

        public DeploymentId copy$default$1() {
            return this.id();
        }

        public String productPrefix() {
            return "ConflictingDeploymentIdError";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.id();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ConflictingDeploymentIdError;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "id";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ConflictingDeploymentIdError)) return false;
            boolean bl = true;
            if (!bl) return false;
            ConflictingDeploymentIdError conflictingDeploymentIdError = (ConflictingDeploymentIdError)x$1;
            DeploymentId deploymentId = this.id();
            DeploymentId deploymentId2 = conflictingDeploymentIdError.id();
            if (deploymentId != null) {
                if (!((Object)deploymentId).equals(deploymentId2)) return false;
                return true;
            }
            if (deploymentId2 == null) return true;
            return false;
        }

        public ConflictingDeploymentIdError(DeploymentId id) {
            this.id = id;
            Product.$init$((Product)this);
        }
    }

    public static final class DeploymentNotFoundError
    implements GetDeploymentStatusError,
    Product,
    Serializable {
        private final DeploymentId id;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public DeploymentId id() {
            return this.id;
        }

        public DeploymentNotFoundError copy(DeploymentId id) {
            return new DeploymentNotFoundError(id);
        }

        public DeploymentId copy$default$1() {
            return this.id();
        }

        public String productPrefix() {
            return "DeploymentNotFoundError";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.id();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof DeploymentNotFoundError;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "id";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof DeploymentNotFoundError)) return false;
            boolean bl = true;
            if (!bl) return false;
            DeploymentNotFoundError deploymentNotFoundError = (DeploymentNotFoundError)x$1;
            DeploymentId deploymentId = this.id();
            DeploymentId deploymentId2 = deploymentNotFoundError.id();
            if (deploymentId != null) {
                if (!((Object)deploymentId).equals(deploymentId2)) return false;
                return true;
            }
            if (deploymentId2 == null) return true;
            return false;
        }

        public DeploymentNotFoundError(DeploymentId id) {
            this.id = id;
            Product.$init$((Product)this);
        }
    }

    public static interface GetDeploymentStatusError {
    }

    public static final class NewCommentValidationError
    implements RunDeploymentError,
    Product,
    Serializable {
        private final String message;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String message() {
            return this.message;
        }

        public NewCommentValidationError copy(String message) {
            return new NewCommentValidationError(message);
        }

        public String copy$default$1() {
            return this.message();
        }

        public String productPrefix() {
            return "NewCommentValidationError";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.message();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof NewCommentValidationError;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "message";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof NewCommentValidationError)) return false;
            boolean bl = true;
            if (!bl) return false;
            NewCommentValidationError newCommentValidationError = (NewCommentValidationError)x$1;
            String string = this.message();
            String string2 = newCommentValidationError.message();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public NewCommentValidationError(String message) {
            this.message = message;
            Product.$init$((Product)this);
        }
    }

    public static interface RunDeploymentError {
    }

    public static final class ScenarioNotFoundError
    implements RunDeploymentError,
    Product,
    Serializable {
        private final ProcessName scenarioName;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public ProcessName scenarioName() {
            return this.scenarioName;
        }

        public ScenarioNotFoundError copy(ProcessName scenarioName) {
            return new ScenarioNotFoundError(scenarioName);
        }

        public ProcessName copy$default$1() {
            return this.scenarioName();
        }

        public String productPrefix() {
            return "ScenarioNotFoundError";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.scenarioName();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ScenarioNotFoundError;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "scenarioName";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ScenarioNotFoundError)) return false;
            boolean bl = true;
            if (!bl) return false;
            ScenarioNotFoundError scenarioNotFoundError = (ScenarioNotFoundError)x$1;
            ProcessName processName = this.scenarioName();
            ProcessName processName2 = scenarioNotFoundError.scenarioName();
            if (processName != null) {
                if (!processName.equals(processName2)) return false;
                return true;
            }
            if (processName2 == null) return true;
            return false;
        }

        public ScenarioNotFoundError(ProcessName scenarioName) {
            this.scenarioName = scenarioName;
            Product.$init$((Product)this);
        }
    }
}

