/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.statistics;

import cats.Foldable;
import cats.UnorderedFoldable$;
import cats.implicits$;
import cats.kernel.CommutativeSemigroup;
import cats.kernel.Monoid;
import cats.kernel.Semigroup$;
import java.io.Serializable;
import java.time.Instant;
import pl.touk.nussknacker.engine.api.component.ComponentType$;
import pl.touk.nussknacker.engine.api.component.ProcessingMode;
import pl.touk.nussknacker.engine.api.deployment.ProcessAction;
import pl.touk.nussknacker.engine.api.deployment.simple.SimpleStateStatus$;
import pl.touk.nussknacker.engine.util.Implicits$;
import pl.touk.nussknacker.restmodel.component.package;
import pl.touk.nussknacker.ui.process.processingtype.DeploymentManagerType;
import pl.touk.nussknacker.ui.process.repository.DbProcessActivityRepository;
import pl.touk.nussknacker.ui.statistics.ActiveCount$;
import pl.touk.nussknacker.ui.statistics.AttachmentsAverage$;
import pl.touk.nussknacker.ui.statistics.AttachmentsTotal$;
import pl.touk.nussknacker.ui.statistics.AuthorsCount$;
import pl.touk.nussknacker.ui.statistics.BoundedStreamCount$;
import pl.touk.nussknacker.ui.statistics.CategoriesCount$;
import pl.touk.nussknacker.ui.statistics.CommentsAverage$;
import pl.touk.nussknacker.ui.statistics.CommentsTotal$;
import pl.touk.nussknacker.ui.statistics.ComponentsCount$;
import pl.touk.nussknacker.ui.statistics.FlinkDMCount$;
import pl.touk.nussknacker.ui.statistics.FragmentCount$;
import pl.touk.nussknacker.ui.statistics.FragmentsUsedAverage$;
import pl.touk.nussknacker.ui.statistics.FragmentsUsedMedian$;
import pl.touk.nussknacker.ui.statistics.LiteEmbeddedDMCount$;
import pl.touk.nussknacker.ui.statistics.LiteK8sDMCount$;
import pl.touk.nussknacker.ui.statistics.NodesAverage$;
import pl.touk.nussknacker.ui.statistics.NodesMax$;
import pl.touk.nussknacker.ui.statistics.NodesMedian$;
import pl.touk.nussknacker.ui.statistics.NodesMin$;
import pl.touk.nussknacker.ui.statistics.RequestResponseCount$;
import pl.touk.nussknacker.ui.statistics.ScenarioCount$;
import pl.touk.nussknacker.ui.statistics.ScenarioStatisticsInputData;
import pl.touk.nussknacker.ui.statistics.StatisticKey;
import pl.touk.nussknacker.ui.statistics.UnboundedStreamCount$;
import pl.touk.nussknacker.ui.statistics.UnknownDMCount$;
import pl.touk.nussknacker.ui.statistics.UptimeAverage$;
import pl.touk.nussknacker.ui.statistics.UptimeMax$;
import pl.touk.nussknacker.ui.statistics.UptimeMin$;
import pl.touk.nussknacker.ui.statistics.VersionsAverage$;
import pl.touk.nussknacker.ui.statistics.VersionsMax$;
import pl.touk.nussknacker.ui.statistics.VersionsMedian$;
import pl.touk.nussknacker.ui.statistics.VersionsMin$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.MapOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class ScenarioStatistics$ {
    public static final ScenarioStatistics$ MODULE$ = new ScenarioStatistics$();
    private static final DeploymentManagerType flinkDeploymentManagerType = new DeploymentManagerType("flinkStreaming");
    private static final DeploymentManagerType liteK8sDeploymentManagerType = new DeploymentManagerType("lite-k8s");
    private static final DeploymentManagerType liteEmbeddedDeploymentManagerType = new DeploymentManagerType("lite-embedded");
    private static final Set<DeploymentManagerType> knownDeploymentManagerTypes = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DeploymentManagerType[]{MODULE$.flinkDeploymentManagerType(), MODULE$.liteK8sDeploymentManagerType(), MODULE$.liteEmbeddedDeploymentManagerType()}));

    private DeploymentManagerType flinkDeploymentManagerType() {
        return flinkDeploymentManagerType;
    }

    private DeploymentManagerType liteK8sDeploymentManagerType() {
        return liteK8sDeploymentManagerType;
    }

    private DeploymentManagerType liteEmbeddedDeploymentManagerType() {
        return liteEmbeddedDeploymentManagerType;
    }

    private Set<DeploymentManagerType> knownDeploymentManagerTypes() {
        return knownDeploymentManagerTypes;
    }

    public Map<String, String> getScenarioStatistics(List<ScenarioStatisticsInputData> scenariosInputData) {
        return Implicits$.MODULE$.RichScalaMap((Map)implicits$.MODULE$.toFoldableOps((Object)scenariosInputData.map((Function1 & Serializable)inputData -> MODULE$.determineStatisticsForScenario((ScenarioStatisticsInputData)inputData)), (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForList()).combineAll((Monoid)Semigroup$.MODULE$.catsKernelCommutativeMonoidForMap((CommutativeSemigroup)Semigroup$.MODULE$.catsKernelCommutativeGroupForInt()))).mapValuesNow((Function1 & Serializable)x$1 -> ScenarioStatistics$.$anonfun$getScenarioStatistics$2(BoxesRunTime.unboxToInt((Object)x$1)));
    }

    public Map<String, String> getGeneralStatistics(List<ScenarioStatisticsInputData> scenariosInputData) {
        if (scenariosInputData.isEmpty()) {
            return Predef$.MODULE$.Map().empty();
        }
        List sortedNodes = (List)scenariosInputData.map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.nodesCount())).sorted((Ordering)Ordering.Int$.MODULE$);
        int nodesMedian = BoxesRunTime.unboxToInt(this.calculateMedian((List)sortedNodes, (Numeric)Numeric.IntIsIntegral$.MODULE$));
        int nodesAverage = BoxesRunTime.unboxToInt(this.calculateAverage((List)sortedNodes, (Numeric)Numeric.IntIsIntegral$.MODULE$));
        int nodesMax = BoxesRunTime.unboxToInt(this.getMax((List)sortedNodes, (Numeric)Numeric.IntIsIntegral$.MODULE$));
        int nodesMin = BoxesRunTime.unboxToInt(this.getMin((List)sortedNodes, (Numeric)Numeric.IntIsIntegral$.MODULE$));
        int categoriesCount = scenariosInputData.map((Function1 & Serializable)x$3 -> x$3.scenarioCategory()).toSet().size();
        List sortedVersions = (List)scenariosInputData.map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)ScenarioStatistics$.$anonfun$getGeneralStatistics$3(x$4))).sorted((Ordering)Ordering.Long$.MODULE$);
        long versionsMedian = BoxesRunTime.unboxToLong(this.calculateMedian((List)sortedVersions, (Numeric)Numeric.LongIsIntegral$.MODULE$));
        long versionsAverage = BoxesRunTime.unboxToLong(this.calculateAverage((List)sortedVersions, (Numeric)Numeric.LongIsIntegral$.MODULE$));
        long versionsMax = BoxesRunTime.unboxToLong(this.getMax((List)sortedVersions, (Numeric)Numeric.LongIsIntegral$.MODULE$));
        long versionsMin = BoxesRunTime.unboxToLong(this.getMin((List)sortedVersions, (Numeric)Numeric.LongIsIntegral$.MODULE$));
        int authorsCount = scenariosInputData.map((Function1 & Serializable)x$5 -> x$5.createdBy()).toSet().size();
        List fragmentsUsedCount = (List)scenariosInputData.filterNot((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isFragment())).map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.fragmentsUsedCount())).sorted((Ordering)Ordering.Int$.MODULE$);
        int fragmentsUsedMedian = BoxesRunTime.unboxToInt(this.calculateMedian((List)fragmentsUsedCount, (Numeric)Numeric.IntIsIntegral$.MODULE$));
        int fragmentsUsedAverage = BoxesRunTime.unboxToInt(this.calculateAverage((List)fragmentsUsedCount, (Numeric)Numeric.IntIsIntegral$.MODULE$));
        List lastActions = scenariosInputData.flatMap((Function1 & Serializable)x$8 -> x$8.lastDeployedAction());
        List sortedUptimes = (List)lastActions.map((Function1 & Serializable)action -> BoxesRunTime.boxToLong((long)ScenarioStatistics$.$anonfun$getGeneralStatistics$8(action))).sorted((Ordering)Ordering.Long$.MODULE$);
        Map uptimeStatsMap = sortedUptimes.isEmpty() ? (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)UptimeAverage$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)UptimeMax$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)UptimeMin$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)0))})) : (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)UptimeAverage$.MODULE$), this.calculateAverage((List)sortedUptimes, (Numeric)Numeric.LongIsIntegral$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)UptimeMax$.MODULE$), this.getMax((List)sortedUptimes, (Numeric)Numeric.LongIsIntegral$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)UptimeMin$.MODULE$), this.getMin((List)sortedUptimes, (Numeric)Numeric.LongIsIntegral$.MODULE$))}));
        return (Map)((MapOps)((MapOps)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)NodesMedian$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)nodesMedian)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)NodesAverage$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)nodesAverage)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)NodesMax$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)nodesMax)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)NodesMin$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)nodesMin)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)CategoriesCount$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)categoriesCount)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)VersionsMedian$.MODULE$), (Object)BoxesRunTime.boxToLong((long)versionsMedian)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)VersionsAverage$.MODULE$), (Object)BoxesRunTime.boxToLong((long)versionsAverage)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)VersionsMax$.MODULE$), (Object)BoxesRunTime.boxToLong((long)versionsMax)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)VersionsMin$.MODULE$), (Object)BoxesRunTime.boxToLong((long)versionsMin)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)AuthorsCount$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)authorsCount)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)FragmentsUsedMedian$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)fragmentsUsedMedian)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)FragmentsUsedAverage$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)fragmentsUsedAverage))}))).$plus$plus((IterableOnce)uptimeStatsMap)).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                StatisticKey k = (StatisticKey)tuple2._1();
                Object v = tuple2._2();
                return new Tuple2((Object)k.toString(), (Object)v.toString());
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Map<String, String> getActivityStatistics(List<DbProcessActivityRepository.ProcessActivity> listOfActivities) {
        if (listOfActivities.isEmpty()) {
            return Predef$.MODULE$.Map().empty();
        }
        List sortedAttachmentCountList = listOfActivities.map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToInteger((int)ScenarioStatistics$.$anonfun$getActivityStatistics$1(x$9)));
        int attachmentAverage = BoxesRunTime.unboxToInt(this.calculateAverage((List)sortedAttachmentCountList, (Numeric)Numeric.IntIsIntegral$.MODULE$));
        int attachmentsTotal = BoxesRunTime.unboxToInt((Object)sortedAttachmentCountList.sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        List comments = listOfActivities.map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToInteger((int)ScenarioStatistics$.$anonfun$getActivityStatistics$2(x$10)));
        int commentsTotal = BoxesRunTime.unboxToInt((Object)comments.sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        int commentsAverage = BoxesRunTime.unboxToInt(this.calculateAverage((List)comments, (Numeric)Numeric.IntIsIntegral$.MODULE$));
        return (Map)((MapOps)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)AttachmentsAverage$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)attachmentAverage)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)AttachmentsTotal$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)attachmentsTotal)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)CommentsTotal$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)commentsTotal)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)CommentsAverage$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)commentsAverage))}))).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                StatisticKey k = (StatisticKey)tuple2._1();
                int v = tuple2._2$mcI$sp();
                return new Tuple2((Object)k.toString(), (Object)Integer.toString(v));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Map<String, String> getComponentStatistic(List<package.ComponentListElement> componentList) {
        if (componentList.isEmpty()) {
            return Predef$.MODULE$.Map().empty();
        }
        List withoutFragments = componentList.filterNot((Function1 & Serializable)comp -> BoxesRunTime.boxToBoolean((boolean)ScenarioStatistics$.$anonfun$getComponentStatistic$1(comp)));
        int componentsByNameCount = withoutFragments.groupBy((Function1 & Serializable)x$11 -> x$11.name()).size();
        return (Map)((MapOps)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ComponentsCount$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)componentsByNameCount))}))).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                ComponentsCount$ k = (ComponentsCount$)tuple2._1();
                int v = tuple2._2$mcI$sp();
                return new Tuple2((Object)k.toString(), (Object)Integer.toString(v));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Map<String, Object> determineStatisticsForScenario(ScenarioStatisticsInputData inputData) {
        Tuple2[] tuple2Array = new Tuple2[10];
        tuple2Array[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ScenarioCount$.MODULE$), (Object)BoxesRunTime.boxToBoolean((!inputData.isFragment() ? 1 : 0) != 0));
        tuple2Array[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)FragmentCount$.MODULE$), (Object)BoxesRunTime.boxToBoolean((boolean)inputData.isFragment()));
        ProcessingMode processingMode = inputData.processingMode();
        ProcessingMode.UnboundedStream$ unboundedStream$ = ProcessingMode.UnboundedStream$.MODULE$;
        tuple2Array[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)UnboundedStreamCount$.MODULE$), (Object)BoxesRunTime.boxToBoolean((!(processingMode != null ? !processingMode.equals(unboundedStream$) : unboundedStream$ != null) ? 1 : 0) != 0));
        ProcessingMode processingMode2 = inputData.processingMode();
        ProcessingMode.BoundedStream$ boundedStream$ = ProcessingMode.BoundedStream$.MODULE$;
        tuple2Array[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoundedStreamCount$.MODULE$), (Object)BoxesRunTime.boxToBoolean((!(processingMode2 != null ? !processingMode2.equals(boundedStream$) : boundedStream$ != null) ? 1 : 0) != 0));
        ProcessingMode processingMode3 = inputData.processingMode();
        ProcessingMode.RequestResponse$ requestResponse$ = ProcessingMode.RequestResponse$.MODULE$;
        tuple2Array[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)RequestResponseCount$.MODULE$), (Object)BoxesRunTime.boxToBoolean((!(processingMode3 != null ? !processingMode3.equals(requestResponse$) : requestResponse$ != null) ? 1 : 0) != 0));
        DeploymentManagerType deploymentManagerType = inputData.deploymentManagerType();
        DeploymentManagerType deploymentManagerType2 = this.flinkDeploymentManagerType();
        tuple2Array[5] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)FlinkDMCount$.MODULE$), (Object)BoxesRunTime.boxToBoolean((!(deploymentManagerType != null ? !((Object)deploymentManagerType).equals(deploymentManagerType2) : deploymentManagerType2 != null) ? 1 : 0) != 0));
        DeploymentManagerType deploymentManagerType3 = inputData.deploymentManagerType();
        DeploymentManagerType deploymentManagerType4 = this.liteK8sDeploymentManagerType();
        tuple2Array[6] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LiteK8sDMCount$.MODULE$), (Object)BoxesRunTime.boxToBoolean((!(deploymentManagerType3 != null ? !((Object)deploymentManagerType3).equals(deploymentManagerType4) : deploymentManagerType4 != null) ? 1 : 0) != 0));
        DeploymentManagerType deploymentManagerType5 = inputData.deploymentManagerType();
        DeploymentManagerType deploymentManagerType6 = this.liteEmbeddedDeploymentManagerType();
        tuple2Array[7] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LiteEmbeddedDMCount$.MODULE$), (Object)BoxesRunTime.boxToBoolean((!(deploymentManagerType5 != null ? !((Object)deploymentManagerType5).equals(deploymentManagerType6) : deploymentManagerType6 != null) ? 1 : 0) != 0));
        tuple2Array[8] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)UnknownDMCount$.MODULE$), (Object)BoxesRunTime.boxToBoolean((!this.knownDeploymentManagerTypes().contains((Object)inputData.deploymentManagerType()) ? 1 : 0) != 0));
        tuple2Array[9] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ActiveCount$.MODULE$), (Object)BoxesRunTime.boxToBoolean((boolean)inputData.status().contains((Object)SimpleStateStatus$.MODULE$.Running())));
        return (Map)((MapOps)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])tuple2Array))).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                StatisticKey k = (StatisticKey)tuple2._1();
                boolean v = tuple2._2$mcZ$sp();
                return new Tuple2((Object)k.toString(), (Object)(v ? BoxesRunTime.boxToInteger((int)1) : BoxesRunTime.boxToInteger((int)0)));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private <T> T calculateMedian(List<T> orderedList, Numeric<T> evidence$1) {
        return (T)implicits$.MODULE$.toFoldableOps(orderedList, (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForList()).get((long)(orderedList.size() / 2)).getOrElse((Function0 & Serializable)() -> ((Numeric)Predef$.MODULE$.implicitly((Object)evidence$1)).zero());
    }

    private <T> T calculateAverage(List<T> list, Numeric<T> evidence$2) {
        if (list.isEmpty()) {
            return (T)((Numeric)Predef$.MODULE$.implicitly(evidence$2)).zero();
        }
        int result = ((Numeric)Predef$.MODULE$.implicitly(evidence$2)).toInt(list.sum(evidence$2)) / list.length();
        return (T)((Numeric)Predef$.MODULE$.implicitly(evidence$2)).fromInt(result);
    }

    private <T> T getMax(List<T> orderedList, Numeric<T> evidence$3) {
        if (orderedList.isEmpty()) {
            return (T)((Numeric)Predef$.MODULE$.implicitly(evidence$3)).zero();
        }
        return (T)orderedList.head();
    }

    private <T> T getMin(List<T> orderedList, Numeric<T> evidence$4) {
        if (orderedList.isEmpty()) {
            return (T)((Numeric)Predef$.MODULE$.implicitly(evidence$4)).zero();
        }
        return (T)orderedList.last();
    }

    public static final /* synthetic */ String $anonfun$getScenarioStatistics$2(int x$1) {
        return Integer.toString(x$1);
    }

    public static final /* synthetic */ long $anonfun$getGeneralStatistics$3(ScenarioStatisticsInputData x$4) {
        return x$4.scenarioVersion().value();
    }

    public static final /* synthetic */ long $anonfun$getGeneralStatistics$8(ProcessAction action) {
        return Instant.now().getEpochSecond() - action.performedAt().getEpochSecond();
    }

    public static final /* synthetic */ int $anonfun$getActivityStatistics$1(DbProcessActivityRepository.ProcessActivity x$9) {
        return x$9.attachments().length();
    }

    public static final /* synthetic */ int $anonfun$getActivityStatistics$2(DbProcessActivityRepository.ProcessActivity x$10) {
        return x$10.comments().length();
    }

    public static final /* synthetic */ boolean $anonfun$getComponentStatistic$1(package.ComponentListElement comp) {
        Enumeration.Value value = comp.componentType();
        Enumeration.Value value2 = ComponentType$.MODULE$.Fragment();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    private ScenarioStatistics$() {
    }
}

