/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.services;

import cats.Applicative;
import cats.Functor;
import cats.Invariant$;
import cats.Monad;
import cats.data.EitherT;
import cats.data.EitherT$;
import cats.data.NonEmptyList;
import cats.data.Validated;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import pl.touk.nussknacker.engine.api.context.PartSubGraphCompilationError;
import pl.touk.nussknacker.engine.api.context.ProcessCompilationError;
import pl.touk.nussknacker.engine.api.process.ProcessId;
import pl.touk.nussknacker.engine.api.process.ProcessIdWithName;
import pl.touk.nussknacker.engine.api.process.ProcessName;
import pl.touk.nussknacker.engine.deployment.CustomActionDefinition;
import pl.touk.nussknacker.restmodel.CustomActionRequest;
import pl.touk.nussknacker.restmodel.validation.PrettyValidationErrors$;
import pl.touk.nussknacker.restmodel.validation.ValidationResults;
import pl.touk.nussknacker.security.AuthCredentials;
import pl.touk.nussknacker.ui.api.BaseHttpService;
import pl.touk.nussknacker.ui.api.CustomActionValidationDto;
import pl.touk.nussknacker.ui.api.ManagementApiEndpoints;
import pl.touk.nussknacker.ui.process.ProcessService;
import pl.touk.nussknacker.ui.process.deployment.DeploymentManagerDispatcher;
import pl.touk.nussknacker.ui.security.api.AuthenticationResources;
import pl.touk.nussknacker.ui.security.api.LoggedUser;
import pl.touk.nussknacker.ui.validation.CustomActionValidator;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import sttp.tapir.EndpointInput;

@ScalaSignature(bytes="\u0006\u0005\u0005ud\u0001B\u0006\r\u0001]A\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\ta\u0001\u0011\t\u0011)A\u0005c!A\u0011\b\u0001B\u0001B\u0003%!\b\u0003\u0005?\u0001\t\u0005\t\u0015a\u0003@\u0011\u00159\u0005\u0001\"\u0001I\u0011\u001d\u0001\u0006A1A\u0005\nECa!\u0016\u0001!\u0002\u0013\u0011\u0006\"\u0002,\u0001\t\u00139\u0006bBA\t\u0001\u0011%\u00111\u0003\u0005\b\u0003\u0017\u0002A\u0011BA'\u0005ai\u0015M\\1hK6,g\u000e^!qS\"#H\u000f]*feZL7-\u001a\u0006\u0003\u001b9\t\u0001b]3sm&\u001cWm\u001d\u0006\u0003\u001fA\t!!^5\u000b\u0005E\u0011\u0012a\u00038vgN\\g.Y2lKJT!a\u0005\u000b\u0002\tQ|Wo\u001b\u0006\u0002+\u0005\u0011\u0001\u000f\\\u0002\u0001'\r\u0001\u0001D\b\t\u00033qi\u0011A\u0007\u0006\u000379\t1!\u00199j\u0013\ti\"DA\bCCN,\u0007\n\u001e;q'\u0016\u0014h/[2f!\tyb%D\u0001!\u0015\t\t#%\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002$I\u0005AA/\u001f9fg\u00064WMC\u0001&\u0003\r\u0019w.\\\u0005\u0003O\u0001\u00121\u0002T1{s2{wmZ5oO\u0006i\u0011-\u001e;iK:$\u0018nY1u_J\u0004\"A\u000b\u0018\u000e\u0003-R!a\u0007\u0017\u000b\u00055r\u0011\u0001C:fGV\u0014\u0018\u000e^=\n\u0005=Z#aF!vi\",g\u000e^5dCRLwN\u001c*fg>,(oY3t\u0003)!\u0017n\u001d9bi\u000eDWM\u001d\t\u0003e]j\u0011a\r\u0006\u0003iU\n!\u0002Z3qY>LX.\u001a8u\u0015\t1d\"A\u0004qe>\u001cWm]:\n\u0005a\u001a$a\u0007#fa2|\u00170\\3oi6\u000bg.Y4fe\u0012K7\u000f]1uG\",'/\u0001\bqe>\u001cWm]:TKJ4\u0018nY3\u0011\u0005mbT\"A\u001b\n\u0005u*$A\u0004)s_\u000e,7o]*feZL7-Z\u0001\u0011Kb,7-\u001e;j_:\u001cuN\u001c;fqR\u0004\"\u0001Q#\u000e\u0003\u0005S!AQ\"\u0002\u0015\r|gnY;se\u0016tGOC\u0001E\u0003\u0015\u00198-\u00197b\u0013\t1\u0015I\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u00061A(\u001b8jiz\"B!S'O\u001fR\u0011!\n\u0014\t\u0003\u0017\u0002i\u0011\u0001\u0004\u0005\u0006}\u0015\u0001\u001da\u0010\u0005\u0006Q\u0015\u0001\r!\u000b\u0005\u0006a\u0015\u0001\r!\r\u0005\u0006s\u0015\u0001\rAO\u0001\u0017[\u0006t\u0017mZ3nK:$\u0018\t]5F]\u0012\u0004x.\u001b8ugV\t!\u000b\u0005\u0002\u001a'&\u0011AK\u0007\u0002\u0017\u001b\u0006t\u0017mZ3nK:$\u0018\t]5F]\u0012\u0004x.\u001b8ug\u00069R.\u00198bO\u0016lWM\u001c;Ba&,e\u000e\u001a9pS:$8\u000fI\u0001\u0014O\u0016$8kY3oCJLw.\u00133Cs:\u000bW.\u001a\u000b\u00041\u0006\u001d\u0001#B-_A\u000e\\X\"\u0001.\u000b\u0005mc\u0016\u0001\u00023bi\u0006T\u0011!X\u0001\u0005G\u0006$8/\u0003\u0002`5\n9Q)\u001b;iKJ$\u0006C\u0001!b\u0013\t\u0011\u0017I\u0001\u0004GkR,(/\u001a\t\u0003Ibt!!Z;\u000f\u0005\u0019\u001chBA4s\u001d\tA\u0017O\u0004\u0002ja:\u0011!n\u001c\b\u0003W:l\u0011\u0001\u001c\u0006\u0003[Z\ta\u0001\u0010:p_Rt\u0014\"A\u000b\n\u0005M!\u0012BA\t\u0013\u0013\ty\u0001#\u0003\u0002\u001c\u001d%\u0011AOG\u0001\u0017\u001b\u0006t\u0017mZ3nK:$\u0018\t]5F]\u0012\u0004x.\u001b8ug&\u0011ao^\u0001\u0013\u001b\u0006t\u0017mZ3nK:$\u0018\t]5FeJ|'O\u0003\u0002u5%\u0011\u0011P\u001f\u0002\u000b\u001d>\u001c6-\u001a8be&|'B\u0001<x!\ra\u00181A\u0007\u0002{*\u0011aG \u0006\u00037}T1!!\u0001\u0011\u0003\u0019)gnZ5oK&\u0019\u0011QA?\u0003\u0013A\u0013xnY3tg&#\u0007bBA\u0005\u0011\u0001\u0007\u00111B\u0001\rg\u000e,g.\u0019:j_:\u000bW.\u001a\t\u0004y\u00065\u0011bAA\b{\nY\u0001K]8dKN\u001ch*Y7f\u0003M9W\r^!di&|g\u000eR3gS:LG/[8o)\u0019\t)\"a\r\u0002>Q!\u0011qCA\u0015!\u001dIf\fYA\r\u0003?\u00012\u0001ZA\u000e\u0013\r\tiB\u001f\u0002\u0013\u001d>\f5\r^5p]\u0012+g-\u001b8ji&|g\u000e\u0005\u0003\u0002\"\u0005\u0015RBAA\u0012\u0015\t!t0\u0003\u0003\u0002(\u0005\r\"AF\"vgR|W.Q2uS>tG)\u001a4j]&$\u0018n\u001c8\t\u000f\u0005-\u0012\u0002q\u0001\u0002.\u0005QAn\\4hK\u0012,6/\u001a:\u0011\u0007)\ny#C\u0002\u00022-\u0012!\u0002T8hO\u0016$Wk]3s\u0011\u001d\t)$\u0003a\u0001\u0003o\t\u0011\u0003\u001d:pG\u0016\u001c8/\u00133XSRDg*Y7f!\ra\u0018\u0011H\u0005\u0004\u0003wi(!\u0005)s_\u000e,7o]%e/&$\bNT1nK\"9\u0011qH\u0005A\u0002\u0005\u0005\u0013AC1di&|gNT1nKB!\u00111IA$\u001b\t\t)E\u0003\u00025}&!\u0011\u0011JA#\u0005I\u00196-\u001a8be&|\u0017i\u0019;j_:t\u0015-\\3\u0002/\u001d,GOV1mS\u0012\fG/[8o%\u0016\u001cX\u000f\u001c;t\tR|GCBA(\u0003;\ni\u0007E\u0004Z=\u0002\f\t&a\u0016\u0011\u0007\u0015\f\u0019&C\u0002\u0002V]\u0014!#T1oC\u001e,W.\u001a8u\u0003BLWI\u001d:peB\u0019\u0011$!\u0017\n\u0007\u0005m#DA\rDkN$x.\\!di&|gNV1mS\u0012\fG/[8o\tR|\u0007bBA0\u0015\u0001\u0007\u0011\u0011M\u0001\nm\u0006d\u0017\u000eZ1u_J\u0004B!a\u0019\u0002j5\u0011\u0011Q\r\u0006\u0004\u0003Or\u0011A\u0003<bY&$\u0017\r^5p]&!\u00111NA3\u0005U\u0019Uo\u001d;p[\u0006\u001bG/[8o-\u0006d\u0017\u000eZ1u_JDq!a\u001c\u000b\u0001\u0004\t\t(A\u0004sKF,Xm\u001d;\u0011\t\u0005M\u0014\u0011P\u0007\u0003\u0003kR1!a\u001e\u0011\u0003%\u0011Xm\u001d;n_\u0012,G.\u0003\u0003\u0002|\u0005U$aE\"vgR|W.Q2uS>t'+Z9vKN$\b")
public class ManagementApiHttpService
extends BaseHttpService
implements LazyLogging {
    private final DeploymentManagerDispatcher dispatcher;
    private final ProcessService processService;
    private final ExecutionContext executionContext;
    private final ManagementApiEndpoints managementApiEndpoints;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        ManagementApiHttpService managementApiHttpService = this;
        synchronized (managementApiHttpService) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private ManagementApiEndpoints managementApiEndpoints() {
        return this.managementApiEndpoints;
    }

    private EitherT<Future, ManagementApiEndpoints.ManagementApiError.NoScenario, ProcessId> getScenarioIdByName(ProcessName scenarioName) {
        return EitherT$.MODULE$.fromOptionF(this.processService.getProcessId(scenarioName, this.executionContext), (Function0 & Serializable)() -> new ManagementApiEndpoints.ManagementApiError.NoScenario(scenarioName), (Functor)Invariant$.MODULE$.catsInstancesForFuture(this.executionContext));
    }

    private EitherT<Future, ManagementApiEndpoints.ManagementApiError.NoActionDefinition, CustomActionDefinition> getActionDefinition(ProcessIdWithName processIdWithName, String actionName, LoggedUser loggedUser) {
        return EitherT$.MODULE$.fromOptionF((Object)this.dispatcher.deploymentManagerUnsafe(processIdWithName, this.executionContext, loggedUser).map((Function1 & Serializable)x$3 -> x$3.customActionsDefinitions().collectFirst((PartialFunction)new Serializable(null, actionName){
            private static final long serialVersionUID = 0L;
            private final String actionName$1;

            public final <A1 extends CustomActionDefinition, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    String string = A1.actionName();
                    String string2 = this.actionName$1;
                    String string3 = string;
                    if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                        return (B1)A1;
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(CustomActionDefinition x1) {
                CustomActionDefinition customActionDefinition = x1;
                if (customActionDefinition != null) {
                    String string = customActionDefinition.actionName();
                    String string2 = this.actionName$1;
                    String string3 = string;
                    if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                        return true;
                    }
                }
                return false;
            }
            {
                this.actionName$1 = actionName$1;
            }
        }), this.executionContext), (Function0 & Serializable)() -> new ManagementApiEndpoints.ManagementApiError.NoActionDefinition(processIdWithName.name(), actionName), (Functor)Invariant$.MODULE$.catsInstancesForFuture(this.executionContext));
    }

    private EitherT<Future, ManagementApiEndpoints.ManagementApiError, CustomActionValidationDto> getValidationResultsDto(CustomActionValidator validator, CustomActionRequest request) {
        CustomActionValidationDto customActionValidationDto;
        Validated<NonEmptyList<PartSubGraphCompilationError>, BoxedUnit> validationResult = validator.validateCustomActionParams((Map<String, String>)request.params());
        Validated<NonEmptyList<PartSubGraphCompilationError>, BoxedUnit> validated = validationResult;
        if (validated instanceof Validated.Valid) {
            customActionValidationDto = new CustomActionValidationDto((List<ValidationResults.NodeValidationError>)Nil$.MODULE$, true);
        } else if (validated instanceof Validated.Invalid) {
            Validated.Invalid invalid = (Validated.Invalid)validated;
            NonEmptyList errors = (NonEmptyList)invalid.e();
            List errorList = errors.toList().map((Function1 & Serializable)x$4 -> PrettyValidationErrors$.MODULE$.formatErrorMessage((ProcessCompilationError)x$4));
            customActionValidationDto = new CustomActionValidationDto((List<ValidationResults.NodeValidationError>)errorList, true);
        } else {
            throw new MatchError(validated);
        }
        CustomActionValidationDto validationDto = customActionValidationDto;
        return EitherT.PurePartiallyApplied$.MODULE$.apply$extension(EitherT$.MODULE$.rightT(), (Object)validationDto, (Applicative)Invariant$.MODULE$.catsInstancesForFuture(this.executionContext));
    }

    public ManagementApiHttpService(AuthenticationResources authenticator, DeploymentManagerDispatcher dispatcher, ProcessService processService, ExecutionContext executionContext) {
        this.dispatcher = dispatcher;
        this.processService = processService;
        this.executionContext = executionContext;
        super(authenticator, executionContext);
        LazyLogging.$init$((LazyLogging)this);
        this.managementApiEndpoints = new ManagementApiEndpoints((EndpointInput<AuthCredentials>)authenticator.authenticationMethod());
        this.expose(this.ServerLogicExtension(this.managementApiEndpoints().customActionValidationEndpoint().serverSecurityLogic((Function1 & Serializable)credentials -> this.authorizeKnownUser((AuthCredentials)credentials))).serverLogicEitherT((Function1 & Serializable)loggedUser -> (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                ProcessName processName = (ProcessName)tuple2._1();
                CustomActionRequest req = (CustomActionRequest)tuple2._2();
                return this.getScenarioIdByName(processName).map((Function1 & Serializable)scenarioId -> {
                    ProcessIdWithName scenarioIdWithName = new ProcessIdWithName(scenarioId, processName);
                    return new Tuple2(scenarioId, (Object)scenarioIdWithName);
                }, (Functor)Invariant$.MODULE$.catsInstancesForFuture($this.executionContext)).flatMap((Function1 & Serializable)x$2 -> {
                    Tuple2 tuple2 = x$2;
                    if (tuple2 != null) {
                        ProcessIdWithName scenarioIdWithName = (ProcessIdWithName)tuple2._2();
                        return this.getActionDefinition(scenarioIdWithName, req.actionName(), (LoggedUser)loggedUser).map((Function1 & Serializable)actionDefinition -> {
                            CustomActionValidator validator = new CustomActionValidator((CustomActionDefinition)actionDefinition);
                            return new Tuple2(actionDefinition, (Object)validator);
                        }, (Functor)Invariant$.MODULE$.catsInstancesForFuture($this.executionContext)).flatMap((Function1 & Serializable)x$1 -> {
                            Tuple2 tuple2 = x$1;
                            if (tuple2 != null) {
                                CustomActionValidator validator = (CustomActionValidator)tuple2._2();
                                return this.getValidationResultsDto(validator, req).map((Function1 & Serializable)resultsDto -> resultsDto, (Functor)Invariant$.MODULE$.catsInstancesForFuture($this.executionContext));
                            }
                            throw new MatchError((Object)tuple2);
                        }, (Monad)Invariant$.MODULE$.catsInstancesForFuture($this.executionContext));
                    }
                    throw new MatchError((Object)tuple2);
                }, (Monad)Invariant$.MODULE$.catsInstancesForFuture($this.executionContext));
            }
            throw new MatchError((Object)tuple2);
        }));
    }
}

