/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.db.timeseries.questdb;

import akka.actor.ActorSystem;
import akka.actor.Cancellable;
import better.files.File;
import better.files.File$;
import cats.ApplicativeError;
import cats.Functor;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.Resource;
import cats.effect.package$;
import com.typesafe.config.Config;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import java.io.Serializable;
import java.time.Clock;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import pl.touk.nussknacker.ui.db.timeseries.FEStatisticsRepository;
import pl.touk.nussknacker.ui.db.timeseries.NoOpFEStatisticsRepository$;
import pl.touk.nussknacker.ui.db.timeseries.questdb.CustomCairoConfiguration;
import pl.touk.nussknacker.ui.db.timeseries.questdb.QuestDbConfig;
import pl.touk.nussknacker.ui.db.timeseries.questdb.QuestDbConfig$;
import pl.touk.nussknacker.ui.db.timeseries.questdb.QuestDbConfig$Disabled$;
import pl.touk.nussknacker.ui.db.timeseries.questdb.QuestDbExtensions$;
import pl.touk.nussknacker.ui.db.timeseries.questdb.QuestDbFEStatisticsRepository;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class QuestDbFEStatisticsRepository$
implements LazyLogging {
    public static final QuestDbFEStatisticsRepository$ MODULE$ = new QuestDbFEStatisticsRepository$();
    private static final String pl$touk$nussknacker$ui$db$timeseries$questdb$QuestDbFEStatisticsRepository$$tableName;
    private static final String pl$touk$nussknacker$ui$db$timeseries$questdb$QuestDbFEStatisticsRepository$$createTableQuery;
    private static final String pl$touk$nussknacker$ui$db$timeseries$questdb$QuestDbFEStatisticsRepository$$selectQuery;
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
        pl$touk$nussknacker$ui$db$timeseries$questdb$QuestDbFEStatisticsRepository$$tableName = "fe_statistics";
        pl$touk$nussknacker$ui$db$timeseries$questdb$QuestDbFEStatisticsRepository$$createTableQuery = "CREATE TABLE IF NOT EXISTS " + MODULE$.pl$touk$nussknacker$ui$db$timeseries$questdb$QuestDbFEStatisticsRepository$$tableName() + " (name string, count long, ts timestamp) TIMESTAMP(ts) PARTITION BY DAY WAL";
        pl$touk$nussknacker$ui$db$timeseries$questdb$QuestDbFEStatisticsRepository$$selectQuery = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       |   SELECT name,\n       |          sum(count)\n       |     FROM " + MODULE$.pl$touk$nussknacker$ui$db$timeseries$questdb$QuestDbFEStatisticsRepository$$tableName() + "\n       |    WHERE timestamp_floor('d', ts) = timestamp_floor('d', now())\n       | GROUP BY name"));
    }

    private Logger logger$lzycompute() {
        QuestDbFEStatisticsRepository$ questDbFEStatisticsRepository$ = this;
        synchronized (questDbFEStatisticsRepository$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public String pl$touk$nussknacker$ui$db$timeseries$questdb$QuestDbFEStatisticsRepository$$tableName() {
        return pl$touk$nussknacker$ui$db$timeseries$questdb$QuestDbFEStatisticsRepository$$tableName;
    }

    public String pl$touk$nussknacker$ui$db$timeseries$questdb$QuestDbFEStatisticsRepository$$createTableQuery() {
        return pl$touk$nussknacker$ui$db$timeseries$questdb$QuestDbFEStatisticsRepository$$createTableQuery;
    }

    public String pl$touk$nussknacker$ui$db$timeseries$questdb$QuestDbFEStatisticsRepository$$selectQuery() {
        return pl$touk$nussknacker$ui$db$timeseries$questdb$QuestDbFEStatisticsRepository$$selectQuery;
    }

    public Resource<IO, FEStatisticsRepository<Future>> create(ActorSystem system, Clock clock, Config config) {
        return package$.MODULE$.Resource().eval((Object)IO$.MODULE$.apply((Function0 & Serializable)() -> QuestDbConfig$.MODULE$.apply(config))).flatMap((Function1 & Serializable)questDbConfig -> {
            Resource<IO, FEStatisticsRepository<Future>> resource;
            QuestDbConfig questDbConfig2 = questDbConfig;
            if (questDbConfig2 instanceof QuestDbConfig.Enabled) {
                QuestDbConfig.Enabled enabled = (QuestDbConfig.Enabled)questDbConfig2;
                resource = MODULE$.createRepositoryResource(system, clock, enabled).handleErrorWith((Function1 & Serializable)t -> {
                    BoxedUnit boxedUnit;
                    if (MODULE$.logger().underlying().isWarnEnabled()) {
                        MODULE$.logger().underlying().warn("Creating QuestDb failed", t);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return MODULE$.createNoOpFEStatisticRepository();
                }, (ApplicativeError)IO$.MODULE$.asyncForIO());
            } else if (QuestDbConfig$Disabled$.MODULE$.equals(questDbConfig2)) {
                BoxedUnit boxedUnit;
                if (MODULE$.logger().underlying().isDebugEnabled()) {
                    MODULE$.logger().underlying().debug("QuestDb is disabled - collecting FE statistics is skipped");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                resource = MODULE$.createNoOpFEStatisticRepository();
            } else {
                throw new MatchError((Object)questDbConfig2);
            }
            return resource.map((Function1 & Serializable)repository -> repository);
        });
    }

    private Resource<IO, FEStatisticsRepository<Future>> createNoOpFEStatisticRepository() {
        return package$.MODULE$.Resource().pure((Object)NoOpFEStatisticsRepository$.MODULE$);
    }

    private Resource<IO, FEStatisticsRepository<Future>> createRepositoryResource(ActorSystem system, Clock clock, QuestDbConfig.Enabled config) {
        return package$.MODULE$.Resource().eval((Object)IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            BoxedUnit boxedUnit;
            if (MODULE$.logger().underlying().isDebugEnabled()) {
                MODULE$.logger().underlying().debug("QuestDb configuration {}", (Object)config);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        })).flatMap((Function1 & Serializable)x$4 -> {
            BoxedUnit boxedUnit = x$4;
            return MODULE$.createExecutorService(config.poolConfig()).flatMap((Function1 & Serializable)executorService -> MODULE$.createCairoEngine(config).flatMap((Function1 & Serializable)cairoEngine -> MODULE$.createRepository((ExecutionContextExecutorService)executorService, (AtomicReference<CairoEngine>)cairoEngine, clock).flatMap((Function1 & Serializable)repository -> MODULE$.scheduleTask(system, config.flushTaskDelay(), config.flushTaskDelay(), () -> repository.pl$touk$nussknacker$ui$db$timeseries$questdb$QuestDbFEStatisticsRepository$$flushDataToDisk()).flatMap((Function1 & Serializable)x$3 -> {
                Cancellable cancellable = x$3;
                return MODULE$.scheduleTask(system, Duration$.MODULE$.Zero(), config.retentionTaskDelay(), () -> repository.pl$touk$nussknacker$ui$db$timeseries$questdb$QuestDbFEStatisticsRepository$$scheduleRetention()).map((Function1 & Serializable)x$2 -> {
                    Cancellable cancellable = x$2;
                    return repository;
                });
            }))));
        });
    }

    private Resource<IO, ExecutionContextExecutorService> createExecutorService(QuestDbConfig.QuestDbPoolConfig config) {
        return package$.MODULE$.Resource().make((Object)IO$.MODULE$.apply((Function0 & Serializable)() -> new ThreadPoolExecutor(config.corePoolSize(), config.maxPoolSize(), config.keepAliveTimeInSeconds(), TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(config.queueCapacity()))).map((Function1 & Serializable)executorService -> {
            ExecutionContextExecutorService ec = ExecutionContext$.MODULE$.fromExecutorService((ExecutorService)executorService);
            return new Tuple2(executorService, (Object)ec);
        }).map((Function1 & Serializable)x$5 -> {
            Tuple2 tuple2 = x$5;
            if (tuple2 != null) {
                ExecutionContextExecutorService ec = (ExecutionContextExecutorService)tuple2._2();
                return ec;
            }
            throw new MatchError((Object)tuple2);
        }), (Function1 & Serializable)ec -> IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> ec.shutdown()), (Functor)IO$.MODULE$.asyncForIO());
    }

    private Resource<IO, AtomicReference<CairoEngine>> createCairoEngine(QuestDbConfig.Enabled config) {
        return package$.MODULE$.Resource().make((Object)IO$.MODULE$.apply((Function0 & Serializable)() -> {
            File nuDir = MODULE$.resolveRootDir(config);
            CairoEngine engine = MODULE$.buildCairoEngine(nuDir);
            return new AtomicReference<CairoEngine>(engine);
        }), (Function1 & Serializable)engine -> IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.closeCairoEngine((CairoEngine)engine.get())), (Functor)IO$.MODULE$.asyncForIO());
    }

    private File resolveRootDir(QuestDbConfig.Enabled config) {
        return (File)config.directory().map((Function1 & Serializable)d -> File$.MODULE$.apply(d, (Seq)Nil$.MODULE$)).getOrElse((Function0 & Serializable)() -> File$.MODULE$.temp().$div("nu/" + config.instanceId()));
    }

    private CairoEngine buildCairoEngine(File rootDir) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Statistics path: {}", (Object)rootDir);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        String canonicalPath = QuestDbExtensions$.MODULE$.BuildCairoEngineExtension(QuestDbExtensions$.MODULE$.BuildCairoEngineExtension(rootDir).createDirIfNotExists()).configureLogging().canonicalPath();
        return new CairoEngine((CairoConfiguration)new CustomCairoConfiguration(canonicalPath));
    }

    private void closeCairoEngine(CairoEngine engine) {
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> engine.close());
        if (try_ instanceof Failure) {
            engine.close();
            return;
        }
        if (try_ instanceof Success) {
            return;
        }
        throw new MatchError((Object)try_);
    }

    private Resource<IO, QuestDbFEStatisticsRepository> createRepository(ExecutionContextExecutorService ec, AtomicReference<CairoEngine> cairoEngine, Clock clock) {
        return package$.MODULE$.Resource().make((Object)IO$.MODULE$.apply((Function0 & Serializable)() -> new QuestDbFEStatisticsRepository(cairoEngine, clock, ec)).flatMap((Function1 & Serializable)repository -> IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> repository.pl$touk$nussknacker$ui$db$timeseries$questdb$QuestDbFEStatisticsRepository$$createTableIfNotExist()).map((Function1 & Serializable)x$6 -> {
            BoxedUnit boxedUnit = x$6;
            return repository;
        })), (Function1 & Serializable)repository -> IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            repository.pl$touk$nussknacker$ui$db$timeseries$questdb$QuestDbFEStatisticsRepository$$flushDataToDisk();
            repository.pl$touk$nussknacker$ui$db$timeseries$questdb$QuestDbFEStatisticsRepository$$close();
        }), (Functor)IO$.MODULE$.asyncForIO());
    }

    private Resource<IO, Cancellable> scheduleTask(ActorSystem system, FiniteDuration initialDelay, FiniteDuration interval, Runnable runnable) {
        return package$.MODULE$.Resource().make((Object)IO$.MODULE$.apply((Function0 & Serializable)() -> system.scheduler().scheduleWithFixedDelay(initialDelay, interval, runnable, (ExecutionContext)system.dispatcher())), (Function1 & Serializable)task -> IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> task.cancel()), (Functor)IO$.MODULE$.asyncForIO());
    }

    public void pl$touk$nussknacker$ui$db$timeseries$questdb$QuestDbFEStatisticsRepository$$recreateCairoEngine(AtomicReference<CairoEngine> engine) {
        CairoEngine cairoEngine = engine.get();
        this.closeCairoEngine(cairoEngine);
        File rootDir = QuestDbExtensions$.MODULE$.CairoEngineExtension(cairoEngine).deleteRootDir();
        engine.set(this.buildCairoEngine(rootDir));
    }

    private QuestDbFEStatisticsRepository$() {
    }
}

