/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.process;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BoundedInputStream;
import pl.touk.nussknacker.engine.api.process.ProcessId;
import pl.touk.nussknacker.engine.api.process.VersionId;
import pl.touk.nussknacker.ui.config.AttachmentsConfig;
import pl.touk.nussknacker.ui.process.repository.ProcessActivityRepository;
import pl.touk.nussknacker.ui.security.api.LoggedUser;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Using;
import scala.util.Using$;

@ScalaSignature(bytes="\u0006\u0005\t5e\u0001\u0002\u0016,\u0001YB\u0001b\u0012\u0001\u0003\u0002\u0003\u0006I\u0001\u0013\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u001d\"AA\u000b\u0001B\u0001B\u0003-Q\u000bC\u0003\\\u0001\u0011\u0005A\fC\u0003d\u0001\u0011\u0005A\rC\u0004\u0002:\u0001!\t!a\u000f\b\u000f\u0005u3\u0006#\u0001\u0002`\u00191!f\u000bE\u0001\u0003CBaa\u0017\u0005\u0005\u0002\u0005\rTABA3\u0011\u0001\t9G\u0002\u0004\u0002z!\u0011\u00151\u0010\u0005\no.\u0011)\u001a!C\u0001\u0003+C\u0011\"a&\f\u0005#\u0005\u000b\u0011\u0002=\t\u0015\u0005\r1B!f\u0001\n\u0003\tI\n\u0003\u0006\u0002\u001c.\u0011\t\u0012)A\u0005\u0003\u000bA!\"!(\f\u0005+\u0007I\u0011AAP\u0011)\t\tk\u0003B\tB\u0003%\u0011q\u0002\u0005\u000b\u0003G[!Q3A\u0005\u0002\u0005\u0015\u0006BCAT\u0017\tE\t\u0015!\u0003\u0002n!11l\u0003C\u0001\u0003SC\u0011\"a.\f\u0003\u0003%\t!!/\t\u0013\u0005\r7\"%A\u0005\u0002\u0005\u0015\u0007\"CAn\u0017E\u0005I\u0011AAo\u0011%\t\toCI\u0001\n\u0003\t\u0019\u000fC\u0005\u0002h.\t\n\u0011\"\u0001\u0002j\"I\u0011Q^\u0006\u0002\u0002\u0013\u0005\u0013q\u001e\u0005\n\u0003w\\\u0011\u0011!C\u0001\u0003{D\u0011B!\u0002\f\u0003\u0003%\tAa\u0002\t\u0013\tM1\"!A\u0005B\tU\u0001\"\u0003B\u0012\u0017\u0005\u0005I\u0011\u0001B\u0013\u0011%\u0011ycCA\u0001\n\u0003\u0012\t\u0004C\u0005\u00036-\t\t\u0011\"\u0011\u00038!I!\u0011H\u0006\u0002\u0002\u0013\u0005#1\b\u0005\n\u0005{Y\u0011\u0011!C!\u0005\u007f9\u0011Ba\u0011\t\u0003\u0003E\tA!\u0012\u0007\u0013\u0005e\u0004\"!A\t\u0002\t\u001d\u0003BB.%\t\u0003\u0011I\u0006C\u0005\u0003:\u0011\n\t\u0011\"\u0012\u0003<!I!1\f\u0013\u0002\u0002\u0013\u0005%Q\f\u0005\n\u0005O\"\u0013\u0011!CA\u0005SB\u0011Ba\u001e%\u0003\u0003%IA!\u001f\u00033M\u001bWM\\1sS>\fE\u000f^1dQ6,g\u000e^*feZL7-\u001a\u0006\u0003Y5\nq\u0001\u001d:pG\u0016\u001c8O\u0003\u0002/_\u0005\u0011Q/\u001b\u0006\u0003aE\n1B\\;tg.t\u0017mY6fe*\u0011!gM\u0001\u0005i>,8NC\u00015\u0003\t\u0001Hn\u0001\u0001\u0014\u0007\u00019T\b\u0005\u00029w5\t\u0011HC\u0001;\u0003\u0015\u00198-\u00197b\u0013\ta\u0014H\u0001\u0004B]f\u0014VM\u001a\t\u0003}\u0015k\u0011a\u0010\u0006\u0003\u0001\u0006\u000bAb]2bY\u0006dwnZ4j]\u001eT!AQ\"\u0002\u0011QL\b/Z:bM\u0016T\u0011\u0001R\u0001\u0004G>l\u0017B\u0001$@\u0005-a\u0015M_=M_\u001e<\u0017N\\4\u0002\r\r|gNZ5h!\tI5*D\u0001K\u0015\t9U&\u0003\u0002M\u0015\n\t\u0012\t\u001e;bG\"lWM\u001c;t\u0007>tg-[4\u00025M\u001cWM\\1sS>\f5\r^5wSRL(+\u001a9pg&$xN]=\u0011\u0005=\u0013V\"\u0001)\u000b\u0005E[\u0013A\u0003:fa>\u001c\u0018\u000e^8ss&\u00111\u000b\u0015\u0002\u001a!J|7-Z:t\u0003\u000e$\u0018N^5usJ+\u0007o\\:ji>\u0014\u00180\u0001\u0002fGB\u0011a+W\u0007\u0002/*\u0011\u0001,O\u0001\u000bG>t7-\u001e:sK:$\u0018B\u0001.X\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH/\u0001\u0004=S:LGO\u0010\u000b\u0004;\u0006\u0014GC\u00010a!\ty\u0006!D\u0001,\u0011\u0015!F\u0001q\u0001V\u0011\u00159E\u00011\u0001I\u0011\u0015iE\u00011\u0001O\u00039\u0019\u0018M^3BiR\f7\r[7f]R$\u0002\"\u001a<\u0002\u0002\u0005-\u0011Q\u0005\u000b\u0003M2\u00042AV4j\u0013\tAwK\u0001\u0004GkR,(/\u001a\t\u0003q)L!a[\u001d\u0003\tUs\u0017\u000e\u001e\u0005\u0006[\u0016\u0001\u001dA\\\u0001\u000bY><w-\u001a3Vg\u0016\u0014\bCA8u\u001b\u0005\u0001(BA9s\u0003\r\t\u0007/\u001b\u0006\u0003g6\n\u0001b]3dkJLG/_\u0005\u0003kB\u0014!\u0002T8hO\u0016$Wk]3s\u0011\u00159X\u00011\u0001y\u0003)\u00198-\u001a8be&|\u0017\n\u001a\t\u0003szl\u0011A\u001f\u0006\u0003YmT!!\u001d?\u000b\u0005u|\u0013AB3oO&tW-\u0003\u0002\u0000u\nI\u0001K]8dKN\u001c\u0018\n\u001a\u0005\b\u0003\u0007)\u0001\u0019AA\u0003\u0003E\u00198-\u001a8be&|g+\u001a:tS>t\u0017\n\u001a\t\u0004s\u0006\u001d\u0011bAA\u0005u\nIa+\u001a:tS>t\u0017\n\u001a\u0005\b\u0003\u001b)\u0001\u0019AA\b\u0003Ay'/[4j]\u0006dg)\u001b7f\u001d\u0006lW\r\u0005\u0003\u0002\u0012\u0005}a\u0002BA\n\u00037\u00012!!\u0006:\u001b\t\t9BC\u0002\u0002\u001aU\na\u0001\u0010:p_Rt\u0014bAA\u000fs\u00051\u0001K]3eK\u001aLA!!\t\u0002$\t11\u000b\u001e:j]\u001eT1!!\b:\u0011\u001d\t9#\u0002a\u0001\u0003S\t1\"\u001b8qkR\u001cFO]3b[B!\u00111FA\u001b\u001b\t\tiC\u0003\u0003\u00020\u0005E\u0012AA5p\u0015\t\t\u0019$\u0001\u0003kCZ\f\u0017\u0002BA\u001c\u0003[\u00111\"\u00138qkR\u001cFO]3b[\u0006q!/Z1e\u0003R$\u0018m\u00195nK:$HCBA\u001f\u0005\u0003\u0013Y\t\u0005\u0003WO\u0006}\u0002#\u0002\u001d\u0002B\u0005\u0015\u0013bAA\"s\t1q\n\u001d;j_:\u00042!a\u0012\u000b\u001d\r\tIe\u0002\b\u0005\u0003\u0017\nYF\u0004\u0003\u0002N\u0005ec\u0002BA(\u0003/rA!!\u0015\u0002V9!\u0011QCA*\u0013\u0005!\u0014B\u0001\u001a4\u0013\t\u0001\u0014'\u0003\u0002/_%\u0011A&L\u0001\u001a'\u000e,g.\u0019:j_\u0006#H/Y2i[\u0016tGoU3sm&\u001cW\r\u0005\u0002`\u0011M\u0011\u0001b\u000e\u000b\u0003\u0003?\u0012a#\u0011;uC\u000eDW.\u001a8u\t\u0006$\u0018mV5uQ:\u000bW.\u001a\t\bq\u0005%\u0014qBA7\u0013\r\tY'\u000f\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u000ba\ny'a\u001d\n\u0007\u0005E\u0014HA\u0003BeJ\f\u0017\u0010E\u00029\u0003kJ1!a\u001e:\u0005\u0011\u0011\u0015\u0010^3\u0003\u001f\u0005#H/Y2i[\u0016tG\u000fV8BI\u0012\u001cbaC\u001c\u0002~\u0005\r\u0005c\u0001\u001d\u0002\u0000%\u0019\u0011\u0011Q\u001d\u0003\u000fA\u0013x\u000eZ;diB!\u0011QQAH\u001d\u0011\t9)a#\u000f\t\u0005U\u0011\u0011R\u0005\u0002u%\u0019\u0011QR\u001d\u0002\u000fA\f7m[1hK&!\u0011\u0011SAJ\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\r\ti)O\u000b\u0002q\u0006Y1oY3oCJLw.\u00133!+\t\t)!\u0001\ntG\u0016t\u0017M]5p-\u0016\u00148/[8o\u0013\u0012\u0004\u0013\u0001\u00034jY\u0016t\u0015-\\3\u0016\u0005\u0005=\u0011!\u00034jY\u0016t\u0015-\\3!\u0003\u0011!\u0017\r^1\u0016\u0005\u00055\u0014!\u00023bi\u0006\u0004CCCAV\u0003_\u000b\t,a-\u00026B\u0019\u0011QV\u0006\u000e\u0003!AQa\u001e\u000bA\u0002aDq!a\u0001\u0015\u0001\u0004\t)\u0001C\u0004\u0002\u001eR\u0001\r!a\u0004\t\u000f\u0005\rF\u00031\u0001\u0002n\u0005!1m\u001c9z))\tY+a/\u0002>\u0006}\u0016\u0011\u0019\u0005\boV\u0001\n\u00111\u0001y\u0011%\t\u0019!\u0006I\u0001\u0002\u0004\t)\u0001C\u0005\u0002\u001eV\u0001\n\u00111\u0001\u0002\u0010!I\u00111U\u000b\u0011\u0002\u0003\u0007\u0011QN\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t9MK\u0002y\u0003\u0013\\#!a3\u0011\t\u00055\u0017q[\u0007\u0003\u0003\u001fTA!!5\u0002T\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003+L\u0014AC1o]>$\u0018\r^5p]&!\u0011\u0011\\Ah\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tyN\u000b\u0003\u0002\u0006\u0005%\u0017AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003KTC!a\u0004\u0002J\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\"TCAAvU\u0011\ti'!3\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\t\u0010\u0005\u0003\u0002t\u0006eXBAA{\u0015\u0011\t90!\r\u0002\t1\fgnZ\u0005\u0005\u0003C\t)0\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002\u0000B\u0019\u0001H!\u0001\n\u0007\t\r\u0011HA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0003\n\t=\u0001c\u0001\u001d\u0003\f%\u0019!QB\u001d\u0003\u0007\u0005s\u0017\u0010C\u0005\u0003\u0012q\t\t\u00111\u0001\u0002\u0000\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa\u0006\u0011\r\te!q\u0004B\u0005\u001b\t\u0011YBC\u0002\u0003\u001ee\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011\tCa\u0007\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005O\u0011i\u0003E\u00029\u0005SI1Aa\u000b:\u0005\u001d\u0011un\u001c7fC:D\u0011B!\u0005\u001f\u0003\u0003\u0005\rA!\u0003\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003c\u0014\u0019\u0004C\u0005\u0003\u0012}\t\t\u00111\u0001\u0002\u0000\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002\u0000\u0006AAo\\*ue&tw\r\u0006\u0002\u0002r\u00061Q-];bYN$BAa\n\u0003B!I!\u0011\u0003\u0012\u0002\u0002\u0003\u0007!\u0011B\u0001\u0010\u0003R$\u0018m\u00195nK:$Hk\\!eIB\u0019\u0011Q\u0016\u0013\u0014\u000b\u0011\u0012IE!\u0016\u0011\u001b\t-#\u0011\u000b=\u0002\u0006\u0005=\u0011QNAV\u001b\t\u0011iEC\u0002\u0003Pe\nqA];oi&lW-\u0003\u0003\u0003T\t5#!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oiA!\u00111\u0006B,\u0013\u0011\t\t*!\f\u0015\u0005\t\u0015\u0013!B1qa2LHCCAV\u0005?\u0012\tGa\u0019\u0003f!)qo\na\u0001q\"9\u00111A\u0014A\u0002\u0005\u0015\u0001bBAOO\u0001\u0007\u0011q\u0002\u0005\b\u0003G;\u0003\u0019AA7\u0003\u001d)h.\u00199qYf$BAa\u001b\u0003tA)\u0001(!\u0011\u0003nAQ\u0001Ha\u001cy\u0003\u000b\ty!!\u001c\n\u0007\tE\u0014H\u0001\u0004UkBdW\r\u000e\u0005\n\u0005kB\u0013\u0011!a\u0001\u0003W\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011Y\b\u0005\u0003\u0002t\nu\u0014\u0002\u0002B@\u0003k\u0014aa\u00142kK\u000e$\bb\u0002BB\r\u0001\u0007!QQ\u0001\rCR$\u0018m\u00195nK:$\u0018\n\u001a\t\u0004q\t\u001d\u0015b\u0001BEs\t!Aj\u001c8h\u0011\u00159h\u00011\u0001y\u0001")
public class ScenarioAttachmentService
implements LazyLogging {
    private final AttachmentsConfig config;
    private final ProcessActivityRepository scenarioActivityRepository;
    private final ExecutionContext ec;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        ScenarioAttachmentService scenarioAttachmentService = this;
        synchronized (scenarioAttachmentService) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public Future<BoxedUnit> saveAttachment(ProcessId scenarioId, VersionId scenarioVersionId, String originalFileName, InputStream inputStream, LoggedUser loggedUser) {
        return Future$.MODULE$.apply((Function0 & Serializable)() -> new BoundedInputStream(inputStream, $this.config.maxSizeInBytes() + 1L), this.ec).map((Function1 & Serializable)x$1 -> (byte[])Using$.MODULE$.resource(x$1, (Function1 & Serializable)isResource -> IOUtils.toByteArray((InputStream)isResource), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$), this.ec).flatMap((Function1 & Serializable)bytes -> {
            if ((long)((byte[])bytes).length > $this.config.maxSizeInBytes()) {
                return Future$.MODULE$.failed((Throwable)new IllegalArgumentException("Maximum (" + $this.config.maxSizeInBytes() + " bytes) attachment size exceeded."));
            }
            return $this.scenarioActivityRepository.addAttachment(new AttachmentToAdd(scenarioId, scenarioVersionId, originalFileName, (byte[])bytes), $this.ec, loggedUser);
        }, this.ec);
    }

    public Future<Option<Tuple2<String, byte[]>>> readAttachment(long attachmentId, ProcessId scenarioId) {
        return this.scenarioActivityRepository.findAttachment(attachmentId, scenarioId, this.ec).map((Function1 & Serializable)x$2 -> x$2.map((Function1 & Serializable)attachment -> new Tuple2((Object)attachment.fileName(), (Object)attachment.data())), this.ec);
    }

    public ScenarioAttachmentService(AttachmentsConfig config, ProcessActivityRepository scenarioActivityRepository, ExecutionContext ec) {
        this.config = config;
        this.scenarioActivityRepository = scenarioActivityRepository;
        this.ec = ec;
        LazyLogging.$init$((LazyLogging)this);
    }

    public static final class AttachmentToAdd
    implements Product,
    Serializable {
        private final ProcessId scenarioId;
        private final VersionId scenarioVersionId;
        private final String fileName;
        private final byte[] data;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public ProcessId scenarioId() {
            return this.scenarioId;
        }

        public VersionId scenarioVersionId() {
            return this.scenarioVersionId;
        }

        public String fileName() {
            return this.fileName;
        }

        public byte[] data() {
            return this.data;
        }

        public AttachmentToAdd copy(ProcessId scenarioId, VersionId scenarioVersionId, String fileName, byte[] data) {
            return new AttachmentToAdd(scenarioId, scenarioVersionId, fileName, data);
        }

        public ProcessId copy$default$1() {
            return this.scenarioId();
        }

        public VersionId copy$default$2() {
            return this.scenarioVersionId();
        }

        public String copy$default$3() {
            return this.fileName();
        }

        public byte[] copy$default$4() {
            return this.data();
        }

        public String productPrefix() {
            return "AttachmentToAdd";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.scenarioId();
                }
                case 1: {
                    return this.scenarioVersionId();
                }
                case 2: {
                    return this.fileName();
                }
                case 3: {
                    return this.data();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof AttachmentToAdd;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "scenarioId";
                }
                case 1: {
                    return "scenarioVersionId";
                }
                case 2: {
                    return "fileName";
                }
                case 3: {
                    return "data";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof AttachmentToAdd)) return false;
            boolean bl = true;
            if (!bl) return false;
            AttachmentToAdd attachmentToAdd = (AttachmentToAdd)x$1;
            ProcessId processId = this.scenarioId();
            ProcessId processId2 = attachmentToAdd.scenarioId();
            if (processId == null) {
                if (processId2 != null) {
                    return false;
                }
            } else if (!processId.equals(processId2)) return false;
            VersionId versionId = this.scenarioVersionId();
            VersionId versionId2 = attachmentToAdd.scenarioVersionId();
            if (versionId == null) {
                if (versionId2 != null) {
                    return false;
                }
            } else if (!versionId.equals(versionId2)) return false;
            String string = this.fileName();
            String string2 = attachmentToAdd.fileName();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.data() != attachmentToAdd.data()) return false;
            return true;
        }

        public AttachmentToAdd(ProcessId scenarioId, VersionId scenarioVersionId, String fileName, byte[] data) {
            this.scenarioId = scenarioId;
            this.scenarioVersionId = scenarioVersionId;
            this.fileName = fileName;
            this.data = data;
            Product.$init$((Product)this);
        }
    }
}

