/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.statistics;

import cats.Applicative;
import cats.implicits$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import pl.touk.nussknacker.ui.statistics.NuFingerprint$;
import pl.touk.nussknacker.ui.statistics.RequestIdStat$;
import pl.touk.nussknacker.ui.statistics.StatisticError;
import pl.touk.nussknacker.ui.statistics.StatisticUrlConfig;
import pl.touk.nussknacker.ui.statistics.Statistics$;
import pl.touk.nussknacker.ui.util.IterableExtensions$;
import pl.touk.nussknacker.ui.util.IterableExtensions$Chunked$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0005\u0005ubaB\n\u0015!\u0003\r\nc\b\u0005\u0006M\u00011\taJ\u0004\u0007\u0003w!\u0002\u0012A,\u0007\u000bM!\u0002\u0012\u0001&\t\u000bU\u001bA\u0011\u0001,\u0007\ta\u001b!!\u0017\u0005\t7\u0016\u0011\t\u0011)A\u00059\"Aq,\u0002B\u0001B\u0003%\u0001\r\u0003\u0005d\u000b\t\u0005\t\u0015!\u0003e\u0011\u0015)V\u0001\"\u0001p\u0011!)X\u0001#b\u0001\n\u00131\b\"\u0002\u0014\u0006\t\u0003r\bbBA\u0001\u000b\u0011%\u00111\u0001\u0005\b\u0003\u001f)A\u0011BA\t\u000f\u001d\t)c\u0001E\u0003\u0003O1a!S\u0002\t\u0006\u0005M\u0002BB+\u0010\t\u0003\t)\u0004\u0003\u0004'\u001f\u0011\u0005\u0013q\u0007\u0005\t\u0003S\u0019A\u0011\u0001\u000b\u0002,\tQ1\u000b^1uSN$\u0018nY:\u000b\u0005U1\u0012AC:uCRL7\u000f^5dg*\u0011q\u0003G\u0001\u0003k&T!!\u0007\u000e\u0002\u00179,8o]6oC\u000e\\WM\u001d\u0006\u00037q\tA\u0001^8vW*\tQ$\u0001\u0002qY\u000e\u00011C\u0001\u0001!!\t\tC%D\u0001#\u0015\u0005\u0019\u0013!B:dC2\f\u0017BA\u0013#\u0005\u0019\te.\u001f*fM\u0006Y\u0001O]3qCJ,WK\u0015't)\tA3\t\u0005\u0003*cQBdB\u0001\u00160\u001d\tYc&D\u0001-\u0015\tic$\u0001\u0004=e>|GOP\u0005\u0002G%\u0011\u0001GI\u0001\ba\u0006\u001c7.Y4f\u0013\t\u00114G\u0001\u0004FSRDWM\u001d\u0006\u0003a\t\u0002\"!\u000e\u001c\u000e\u0003QI!a\u000e\u000b\u0003\u001dM#\u0018\r^5ti&\u001cWI\u001d:peB\u0019\u0011&O\u001e\n\u0005i\u001a$\u0001\u0002'jgR\u0004\"\u0001P!\u000e\u0003uR!AP \u0002\u00079,GOC\u0001A\u0003\u0011Q\u0017M^1\n\u0005\tk$aA+S\u0019\")A)\u0001a\u0001\u000b\u0006\u00191MZ4\u0011\u0005U2\u0015BA$\u0015\u0005I\u0019F/\u0019;jgRL7-\u0016:m\u0007>tg-[4*\u0007\u0001yQAA\u0003F[B$\u0018pE\u0002\u0004A-\u0003\"\u0001T*\u000e\u00035S!AT(\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005A\u000b\u0016\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003I\u000b1aY8n\u0013\t!VJA\u0006MCjLHj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001X!\t)4A\u0001\u0005O_:,U\u000e\u001d;z'\u0011)\u0001EW&\u0011\u0005U\u0002\u0011a\u00034j]\u001e,'\u000f\u001d:j]R\u0004\"!N/\n\u0005y#\"a\u0003$j]\u001e,'\u000f\u001d:j]R\f\u0011B]3rk\u0016\u001cH/\u00133\u0011\u0005U\n\u0017B\u00012\u0015\u0005%\u0011V-];fgRLE-A\u0007sC^\u001cF/\u0019;jgRL7m\u001d\t\u0005K&dGN\u0004\u0002gOB\u00111FI\u0005\u0003Q\n\na\u0001\u0015:fI\u00164\u0017B\u00016l\u0005\ri\u0015\r\u001d\u0006\u0003Q\n\u0002\"!Z7\n\u00059\\'AB*ue&tw\r\u0006\u0003qeN$\bCA9\u0006\u001b\u0005\u0019\u0001\"B.\n\u0001\u0004a\u0006\"B0\n\u0001\u0004\u0001\u0007\"B2\n\u0001\u0004!\u0017AF9vKJL\b+\u0019:b[N4uN]#wKJLXK\u0015'\u0016\u0003]\u00042\u0001_?m\u001b\u0005I(B\u0001>|\u0003%IW.\\;uC\ndWM\u0003\u0002}E\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005iJHC\u0001\u0015\u0000\u0011\u0015!5\u00021\u0001F\u0003A)gnY8eKF+XM]=QCJ\fW\u000eF\u0002m\u0003\u000bAq!a\u0002\r\u0001\u0004\tI!A\u0003f]R\u0014\u0018\u0010E\u0003\"\u0003\u0017aG.C\u0002\u0002\u000e\t\u0012a\u0001V;qY\u0016\u0014\u0014\u0001\u00059sKB\f'/Z+sYN#(/\u001b8h)\u0019\t\u0019\"!\u0007\u0002$A!\u0011%!\u0006m\u0013\r\t9B\t\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u0005mQ\u00021\u0001\u0002\u001e\u0005Y\u0011/^3ssB\u000b'/Y7t!\u0011I\u0013q\u00047\n\u0007\u0005\u00052G\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0011\u0015!U\u00021\u0001F\u0003\u0015)U\u000e\u001d;z!\t\tx\"A\u0003u_V\u0013F\n\u0006\u0003\u0002.\u0005=\u0002\u0003B\u00152imBa!!\r\u0013\u0001\u0004a\u0017!C;sYN#(/\u001b8h'\ry\u0001E\u0017\u000b\u0003\u0003O!2\u0001KA\u001d\u0011\u0015!\u0015\u00031\u0001F\u0003)\u0019F/\u0019;jgRL7m\u001d")
public interface Statistics {
    public Either<StatisticError, List<URL>> prepareURLs(StatisticUrlConfig var1);

    public static final class NonEmpty
    implements Statistics,
    LazyLogging {
        private List<String> queryParamsForEveryURL;
        private String fingerprint;
        private String requestId;
        private final Map<String, String> rawStatistics;
        private transient Logger logger;
        private volatile transient boolean bitmap$trans$0;
        private volatile boolean bitmap$0;

        private Logger logger$lzycompute() {
            NonEmpty nonEmpty = this;
            synchronized (nonEmpty) {
                if (!this.bitmap$trans$0) {
                    this.logger = LazyLogging.logger$((LazyLogging)this);
                    this.bitmap$trans$0 = true;
                }
            }
            return this.logger;
        }

        public Logger logger() {
            if (!this.bitmap$trans$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        private List<String> queryParamsForEveryURL$lzycompute() {
            NonEmpty nonEmpty = this;
            synchronized (nonEmpty) {
                if (!this.bitmap$0) {
                    this.queryParamsForEveryURL = new .colon.colon((Object)this.encodeQueryParam((Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)NuFingerprint$.MODULE$.name()), (Object)this.fingerprint)), (List)new .colon.colon((Object)this.encodeQueryParam((Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)RequestIdStat$.MODULE$.name()), (Object)this.requestId)), (List)Nil$.MODULE$));
                    this.bitmap$0 = true;
                }
            }
            this.fingerprint = null;
            this.requestId = null;
            return this.queryParamsForEveryURL;
        }

        private List<String> queryParamsForEveryURL() {
            if (!this.bitmap$0) {
                return this.queryParamsForEveryURL$lzycompute();
            }
            return this.queryParamsForEveryURL;
        }

        @Override
        public Either<StatisticError, List<URL>> prepareURLs(StatisticUrlConfig cfg) {
            return (Either)implicits$.MODULE$.toTraverseOps((Object)IterableExtensions$Chunked$.MODULE$.groupByMaxChunkSize$extension(IterableExtensions$.MODULE$.Chunked((Iterable<String>)((List)this.rawStatistics.toList().sortBy((Function1 & Serializable)x$1 -> (String)x$1._1(), implicits$.MODULE$.catsKernelOrderingForOrder(implicits$.MODULE$.catsKernelStdOrderForString()))).map((Function1 & Serializable)entry -> this.encodeQueryParam((Tuple2<String, String>)entry))), cfg.urlBytesSizeLimit()).flatMap((Function1 & Serializable)queryParams -> this.prepareUrlString((Iterable<String>)queryParams, cfg)), implicits$.MODULE$.catsStdInstancesForList()).traverse((Function1 & Serializable)urlString -> Statistics$.MODULE$.toURL((String)urlString), (Applicative)implicits$.MODULE$.catsStdInstancesForEither());
        }

        private String encodeQueryParam(Tuple2<String, String> entry) {
            return URLEncoder.encode((String)entry._1(), StandardCharsets.UTF_8) + "=" + URLEncoder.encode((String)entry._2(), StandardCharsets.UTF_8);
        }

        private Option<String> prepareUrlString(Iterable<String> queryParams, StatisticUrlConfig cfg) {
            if (queryParams.nonEmpty()) {
                Iterable queryParamsWithFingerprint = (Iterable)queryParams.$plus$plus(this.queryParamsForEveryURL());
                return new Some((Object)queryParamsWithFingerprint.mkString(cfg.nuStatsUrl(), cfg.queryParamsSeparator(), cfg.emptyString()));
            }
            return None$.MODULE$;
        }

        public NonEmpty(String fingerprint, String requestId, Map<String, String> rawStatistics) {
            this.fingerprint = fingerprint;
            this.requestId = requestId;
            this.rawStatistics = rawStatistics;
            LazyLogging.$init$((LazyLogging)this);
        }
    }
}

