/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.db.timeseries.questdb;

import akka.actor.ActorSystem;
import cats.effect.IO;
import cats.effect.kernel.Resource;
import com.typesafe.config.Config;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.SecurityContext;
import io.questdb.cairo.security.AllowAllSecurityContext;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.wal.WalWriter;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.SqlExecutionContextImpl;
import java.io.Serializable;
import java.time.Clock;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import pl.touk.nussknacker.ui.db.timeseries.FEStatisticsRepository;
import pl.touk.nussknacker.ui.db.timeseries.questdb.FlushDataTask;
import pl.touk.nussknacker.ui.db.timeseries.questdb.PurgeWalTask;
import pl.touk.nussknacker.ui.db.timeseries.questdb.QuestDbExtensions$;
import pl.touk.nussknacker.ui.db.timeseries.questdb.QuestDbFEStatisticsRepository$;
import pl.touk.nussknacker.ui.db.timeseries.questdb.RetentionTask;
import pl.touk.nussknacker.ui.db.timeseries.questdb.TaskRecovery;
import pl.touk.nussknacker.ui.db.timeseries.questdb.ThreadAwareObjectPool;
import pl.touk.nussknacker.ui.statistics.RawFEStatistics;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\r\u0005c\u0001\u0002\u001f>\t1C\u0001b\u001a\u0001\u0003\u0006\u0004%I\u0001\u001b\u0005\t{\u0002\u0011\t\u0011)A\u0005S\"Aa\u0010\u0001BC\u0002\u0013%q\u0010\u0003\u0006\u0002\u000e\u0001\u0011\t\u0011)A\u0005\u0003\u0003A!\"a\u0004\u0001\u0005\u000b\u0007I1BA\t\u0011)\tI\u0002\u0001B\u0001B\u0003%\u00111\u0003\u0005\b\u00037\u0001A\u0011AA\u000f\u0011%\tY\u0003\u0001b\u0001\n\u0013\ti\u0003\u0003\u0005\u00026\u0001\u0001\u000b\u0011BA\u0018\u0011%\t9\u0004\u0001b\u0001\n\u0013\tI\u0004\u0003\u0005\u0002N\u0001\u0001\u000b\u0011BA\u001e\u0011%\ty\u0005\u0001b\u0001\n\u0013\t\t\u0006\u0003\u0005\u0002b\u0001\u0001\u000b\u0011BA*\u0011%\t\u0019\u0007\u0001b\u0001\n\u0013\t)\u0007\u0003\u0005\u0002v\u0001\u0001\u000b\u0011BA4\u0011%\t9\b\u0001b\u0001\n\u0013\tI\b\u0003\u0005\u0002\u0002\u0002\u0001\u000b\u0011BA>\u0011%\t\u0019\t\u0001b\u0001\n\u0013\t)\t\u0003\u0005\u0002\u0010\u0002\u0001\u000b\u0011BAD\u0011%\t\t\n\u0001b\u0001\n\u0013\t\u0019\n\u0003\u0005\u0002\u001e\u0002\u0001\u000b\u0011BAK\u0011)\ty\n\u0001EC\u0002\u0013%\u0011\u0011\u0015\u0005\n\u0003W\u0003!\u0019!C\u0005\u0003[C\u0001\"!.\u0001A\u0003%\u0011q\u0016\u0005\n\u0003o\u0003!\u0019!C\u0005\u0003sC\u0001\"!:\u0001A\u0003%\u00111\u0018\u0005\b\u0003O\u0004A\u0011IAu\u0011\u001d\u0011\u0019\u0001\u0001C!\u0005\u000bAqA!\u0003\u0001\t\u0013\u0011Y\u0001C\u0004\u0003\u0012\u0001!IAa\u0005\t\u000f\tU\u0001\u0001\"\u0003\u0003\u0014!9!q\u0003\u0001\u0005\n\te\u0001b\u0002B\u0013\u0001\u0011%!1\u0003\u0005\b\u0005O\u0001A\u0011\u0002B\u0015\u0011\u001d\u0011\t\u0004\u0001C\u0005\u0005'AqAa\r\u0001\t\u0013\u0011\u0019\u0002C\u0004\u00036\u0001!IAa\u000e\t\u000f\te\u0002\u0001\"\u0003\u0003<!9!Q\b\u0001\u0005\n\t}ra\u0002B!{!\u0005!1\t\u0004\u0007yuB\tA!\u0012\t\u000f\u0005m\u0011\u0006\"\u0001\u0003H!I!\u0011J\u0015C\u0002\u0013%!1\n\u0005\t\u0005#J\u0003\u0015!\u0003\u0003N!I!1K\u0015C\u0002\u0013%!1\n\u0005\t\u0005+J\u0003\u0015!\u0003\u0003N!I!qK\u0015C\u0002\u0013%!\u0011\f\u0005\t\u00057J\u0003\u0015!\u0003\u0002D\"9!QL\u0015\u0005\u0002\t}\u0003b\u0002BVS\u0011%!Q\u0016\u0005\b\u0005_KC\u0011\u0002BY\u0011\u001d\u00119-\u000bC\u0005\u0005\u0013DqA!6*\t\u0013\u00119\u000eC\u0004\u0003^&\"IAa8\t\u000f\tM\u0018\u0006\"\u0003\u0003v\"9!1`\u0015\u0005\n\tu\bbBB\u0001S\u0011%11\u0001\u0005\b\u0007\u001fIC\u0011BB\t\u0011\u001d\u0019Y$\u000bC\u0005\u0007{\u0011Q$U;fgR$%MR#Ti\u0006$\u0018n\u001d;jGN\u0014V\r]8tSR|'/\u001f\u0006\u0003}}\nq!];fgR$'M\u0003\u0002A\u0003\u0006QA/[7fg\u0016\u0014\u0018.Z:\u000b\u0005\t\u001b\u0015A\u00013c\u0015\t!U)\u0001\u0002vS*\u0011aiR\u0001\f]V\u001c8o\u001b8bG.,'O\u0003\u0002I\u0013\u0006!Ao\\;l\u0015\u0005Q\u0015A\u00019m\u0007\u0001\u0019B\u0001A'T;B\u0011a*U\u0007\u0002\u001f*\t\u0001+A\u0003tG\u0006d\u0017-\u0003\u0002S\u001f\n1\u0011I\\=SK\u001a\u00042\u0001V+X\u001b\u0005y\u0014B\u0001,@\u0005Y1Ui\u0015;bi&\u001cH/[2t%\u0016\u0004xn]5u_JL\bC\u0001-\\\u001b\u0005I&B\u0001.P\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u00039f\u0013aAR;ukJ,\u0007C\u00010f\u001b\u0005y&B\u00011b\u00031\u00198-\u00197bY><w-\u001b8h\u0015\t\u00117-\u0001\u0005usB,7/\u00194f\u0015\u0005!\u0017aA2p[&\u0011am\u0018\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw-\u0001\u0004f]\u001eLg.Z\u000b\u0002SB\u0019!N\u001d;\u000e\u0003-T!\u0001\\7\u0002\r\u0005$x.\\5d\u0015\tQfN\u0003\u0002pa\u0006!Q\u000f^5m\u0015\u0005\t\u0018\u0001\u00026bm\u0006L!a]6\u0003\u001f\u0005#x.\\5d%\u00164WM]3oG\u0016\u0004\"!^>\u000e\u0003YT!a\u001e=\u0002\u000b\r\f\u0017N]8\u000b\u0005yJ(\"\u0001>\u0002\u0005%|\u0017B\u0001?w\u0005-\u0019\u0015-\u001b:p\u000b:<\u0017N\\3\u0002\u000f\u0015tw-\u001b8fA\u0005)1\r\\8dWV\u0011\u0011\u0011\u0001\t\u0005\u0003\u0007\tI!\u0004\u0002\u0002\u0006)\u0019\u0011q\u00019\u0002\tQLW.Z\u0005\u0005\u0003\u0017\t)AA\u0003DY>\u001c7.\u0001\u0004dY>\u001c7\u000eI\u0001\u0003K\u000e,\"!a\u0005\u0011\u0007a\u000b)\"C\u0002\u0002\u0018e\u0013q$\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;Fq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0003\r)7\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\r\u0005}\u0011qEA\u0015)\u0011\t\t#!\n\u0011\u0007\u0005\r\u0002!D\u0001>\u0011\u001d\tya\u0002a\u0002\u0003'AQaZ\u0004A\u0002%DaA`\u0004A\u0002\u0005\u0005\u0011aC<pe.,'oQ8v]R,\"!a\f\u0011\u00079\u000b\t$C\u0002\u00024=\u00131!\u00138u\u000319xN]6fe\u000e{WO\u001c;!\u00039\u0019\u0018\u000f\\\"p]R,\u0007\u0010\u001e)p_2,\"!a\u000f\u0011\r\u0005\r\u0012QHA!\u0013\r\ty$\u0010\u0002\u0016)\"\u0014X-\u00193Bo\u0006\u0014Xm\u00142kK\u000e$\bk\\8m!\u0011\t\u0019%!\u0013\u000e\u0005\u0005\u0015#bAA$q\u00069qM]5gM&t\u0017\u0002BA&\u0003\u000b\u00121cU9m\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\fqb]9m\u0007>tG/\u001a=u!>|G\u000eI\u0001\u0011e\u0016\u001cwN\u001d3DkJ\u001cxN\u001d)p_2,\"!a\u0015\u0011\r\u0005\r\u0012QHA+!\u0011\t9&!\u0018\u000e\u0005\u0005e#bAA.m\u0006\u00191/\u001d7\n\t\u0005}\u0013\u0011\f\u0002\u0014%\u0016\u001cwN\u001d3DkJ\u001cxN\u001d$bGR|'/_\u0001\u0012e\u0016\u001cwN\u001d3DkJ\u001cxN\u001d)p_2\u0004\u0013AE<bYR\u000b'\r\\3Xe&$XM\u001d)p_2,\"!a\u001a\u0011\r\u0005\r\u0012QHA5!\u0011\tY'!\u001d\u000e\u0005\u00055$bAA8m\u0006\u0019q/\u00197\n\t\u0005M\u0014Q\u000e\u0002\n/\u0006dwK]5uKJ\f1c^1m)\u0006\u0014G.Z,sSR,'\u000fU8pY\u0002\nA\u0002^1tWJ+7m\u001c<fef,\"!a\u001f\u0011\t\u0005\r\u0012QP\u0005\u0004\u0003\u007fj$\u0001\u0004+bg.\u0014VmY8wKJL\u0018!\u0004;bg.\u0014VmY8wKJL\b%A\u0007gYV\u001c\b\u000eR1uCR\u000b7o[\u000b\u0003\u0003\u000f\u0003BA\u001b:\u0002\nB!\u00111EAF\u0013\r\ti)\u0010\u0002\u000e\r2,8\u000f\u001b#bi\u0006$\u0016m]6\u0002\u001d\u0019dWo\u001d5ECR\fG+Y:lA\u0005a\u0001/\u001e:hK^\u000bG\u000eV1tWV\u0011\u0011Q\u0013\t\u0005UJ\f9\n\u0005\u0003\u0002$\u0005e\u0015bAAN{\ta\u0001+\u001e:hK^\u000bG\u000eV1tW\u0006i\u0001/\u001e:hK^\u000bG\u000eV1tW\u0002\nQB]3uK:$\u0018n\u001c8UCN\\WCAAR!\u0011Q'/!*\u0011\t\u0005\r\u0012qU\u0005\u0004\u0003Sk$!\u0004*fi\u0016tG/[8o)\u0006\u001c8.A\ttQ>,H\u000eZ\"mK\u0006tW\u000b\u001d#bi\u0006,\"!a,\u0011\u0007)\f\t,C\u0002\u00024.\u0014Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017AE:i_VdGm\u00117fC:,\u0006\u000fR1uC\u0002\nA#Y4he\u0016<\u0017\r^3e'R\fG/[:uS\u000e\u001cXCAA^!!\ti,a0\u0002D\u0006eW\"A7\n\u0007\u0005\u0005WNA\tD_:\u001cWO\u001d:f]RD\u0015m\u001d5NCB\u0004B!!2\u0002T:!\u0011qYAh!\r\tImT\u0007\u0003\u0003\u0017T1!!4L\u0003\u0019a$o\\8u}%\u0019\u0011\u0011[(\u0002\rA\u0013X\rZ3g\u0013\u0011\t).a6\u0003\rM#(/\u001b8h\u0015\r\t\tn\u0014\t\u0005\u00037\f\t/\u0004\u0002\u0002^*\u0019\u0011q\u001c9\u0002\t1\fgnZ\u0005\u0005\u0003G\fiN\u0001\u0003M_:<\u0017!F1hOJ,w-\u0019;fIN#\u0018\r^5ti&\u001c7\u000fI\u0001\u0006oJLG/\u001a\u000b\u0005\u0003W\f\u0019\u0010\u0005\u0003Y7\u00065\bc\u0001(\u0002p&\u0019\u0011\u0011_(\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003k\\\u0002\u0019AA|\u0003=\u0011\u0018m\u001e$F'R\fG/[:uS\u000e\u001c\b\u0003BA}\u0003\u007fl!!a?\u000b\u0007\u0005u8)\u0001\u0006ti\u0006$\u0018n\u001d;jGNLAA!\u0001\u0002|\ny!+Y<G\u000bN#\u0018\r^5ti&\u001c7/\u0001\u0003sK\u0006$GC\u0001B\u0004!\u0011A6,a>\u0002#\r,(O]3oiRKW.Z'jGJ|7\u000f\u0006\u0002\u0003\u000eA\u0019aJa\u0004\n\u0007\u0005\rx*A\u0003dY>\u001cX\r\u0006\u0002\u0002n\u0006)2M]3bi\u0016$\u0016M\u00197f\u0013\u001atu\u000e^#ySN$\u0018a\u0002:fG>4XM\u001d\u000b\u0003\u00057\u0001bA!\b\u0003\"\u00055XB\u0001B\u0010\u0015\tyw*\u0003\u0003\u0003$\t}!a\u0001+ss\u0006aQ\r_3dkR,G+Y:lg\u0006\u00112\u000f^1uSN$\u0018nY:T]\u0006\u00048\u000f[8u)\t\u0011Y\u0003\u0005\u0005\u0002F\n5\u00121\u0019B\u0007\u0013\u0011\u0011y#a6\u0003\u00075\u000b\u0007/\u0001\tsk:\u0014V\r^3oi&|g\u000eV1tW\u0006\t2o\u00195fIVdWMU3uK:$\u0018n\u001c8\u0002'\r\u0014X-\u0019;f\r2,8\u000f\u001b#bi\u0006$\u0016m]6\u0015\u0005\u0005%\u0015AE2sK\u0006$X\rU;sO\u0016<\u0016\r\u001c+bg.$\"!a&\u0002'\r\u0014X-\u0019;f%\u0016$XM\u001c;j_:$\u0016m]6\u0015\u0005\u0005\u0015\u0016!H)vKN$HI\u0019$F'R\fG/[:uS\u000e\u001c(+\u001a9pg&$xN]=\u0011\u0007\u0005\r\u0012fE\u0002*\u001bv#\"Aa\u0011\u0002\u0013Q\f'\r\\3OC6,WC\u0001B'!\u0011\tYNa\u0014\n\t\u0005U\u0017Q\\\u0001\u000bi\u0006\u0014G.\u001a(b[\u0016\u0004\u0013\u0001E2sK\u0006$X\rV1cY\u0016\fV/\u001a:z\u0003E\u0019'/Z1uKR\u000b'\r\\3Rk\u0016\u0014\u0018\u0010I\u0001\fg\u0016dWm\u0019;Rk\u0016\u0014\u00180\u0006\u0002\u0002D\u0006a1/\u001a7fGR\fV/\u001a:zA\u000511M]3bi\u0016$\u0002B!\u0019\u0003\b\nm%Q\u0014\t\b\u0005G\u0012IHa T\u001d\u0011\u0011)Ga\u001d\u000f\t\t\u001d$Q\u000e\b\u0005\u0003\u0013\u0014I'\u0003\u0002\u0003l\u0005!1-\u0019;t\u0013\u0011\u0011yG!\u001d\u0002\r\u00154g-Z2u\u0015\t\u0011Y'\u0003\u0003\u0003v\t]\u0014a\u00029bG.\fw-\u001a\u0006\u0005\u0005_\u0012\t(\u0003\u0003\u0003|\tu$\u0001\u0003*fg>,(oY3\u000b\t\tU$q\u000f\t\u0005\u0005\u0003\u0013\u0019)\u0004\u0002\u0003x%!!Q\u0011B<\u0005\tIu\nC\u0004\u0003\nF\u0002\rAa#\u0002\rML8\u000f^3n!\u0011\u0011iIa&\u000e\u0005\t=%\u0002\u0002BI\u0005'\u000bQ!Y2u_JT!A!&\u0002\t\u0005\\7.Y\u0005\u0005\u00053\u0013yIA\u0006BGR|'oU=ti\u0016l\u0007B\u0002@2\u0001\u0004\t\t\u0001C\u0004\u0003 F\u0002\rA!)\u0002\r\r|gNZ5h!\u0011\u0011\u0019Ka*\u000e\u0005\t\u0015&b\u0001BPC&!!\u0011\u0016BS\u0005\u0019\u0019uN\u001c4jO\u0006y2M]3bi\u0016tun\u00149G\u000bN#\u0018\r^5ti&\u001c'+\u001a9pg&$xN]=\u0016\u0005\t\u0005\u0014\u0001G2sK\u0006$XMU3q_NLGo\u001c:z%\u0016\u001cx.\u001e:dKRA!\u0011\rBZ\u0005k\u00139\fC\u0004\u0003\nN\u0002\rAa#\t\ry\u001c\u0004\u0019AA\u0001\u0011\u001d\u0011yj\ra\u0001\u0005s\u0003BAa/\u0003B:!\u00111\u0005B_\u0013\r\u0011y,P\u0001\u000e#V,7\u000f\u001e#c\u0007>tg-[4\n\t\t\r'Q\u0019\u0002\b\u000b:\f'\r\\3e\u0015\r\u0011y,P\u0001\u0016GJ,\u0017\r^3Fq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f)\u0011\u0011YM!4\u0011\u0011\t\r$\u0011\u0010B@\u0003'AqAa(5\u0001\u0004\u0011y\r\u0005\u0003\u0003<\nE\u0017\u0002\u0002Bj\u0005\u000b\u0014\u0011#U;fgR$%\rU8pY\u000e{gNZ5h\u0003E\u0019'/Z1uK\u000e\u000b\u0017N]8F]\u001eLg.\u001a\u000b\u0005\u00053\u0014Y\u000eE\u0004\u0003d\te$qP5\t\u000f\t}U\u00071\u0001\u0003:\u0006q!/Z:pYZ,'k\\8u\t&\u0014H\u0003\u0002Bq\u0005c\u0004BAa9\u0003n6\u0011!Q\u001d\u0006\u0005\u0005O\u0014I/A\u0003gS2,7O\u0003\u0002\u0003l\u00061!-\u001a;uKJLAAa<\u0003f\n!a)\u001b7f\u0011\u001d\u0011yJ\u000ea\u0001\u0005s\u000b\u0001CY;jY\u0012\u001c\u0015-\u001b:p\u000b:<\u0017N\\3\u0015\u0007Q\u00149\u0010C\u0004\u0003z^\u0002\rA!9\u0002\u000fI|w\u000e\u001e#je\u0006\u00012\r\\8tK\u000e\u000b\u0017N]8F]\u001eLg.\u001a\u000b\u0005\u0003[\u0014y\u0010C\u0003hq\u0001\u0007A/\u0001\tde\u0016\fG/\u001a*fa>\u001c\u0018\u000e^8ssRA1QAB\u0004\u0007\u0013\u0019i\u0001\u0005\u0005\u0003d\te$qPA\u0011\u0011\u001d\ty!\u000fa\u0001\u0003'Aaaa\u0003:\u0001\u0004I\u0017aC2bSJ|WI\\4j]\u0016DaA`\u001dA\u0002\u0005\u0005\u0011\u0001D:dQ\u0016$W\u000f\\3UCN\\GCCB\n\u00077\u0019ib!\f\u00042AA!1\rB=\u0005\u007f\u001a)\u0002\u0005\u0003\u0003\u000e\u000e]\u0011\u0002BB\r\u0005\u001f\u00131bQ1oG\u0016dG.\u00192mK\"9!\u0011\u0012\u001eA\u0002\t-\u0005bBB\u0010u\u0001\u00071\u0011E\u0001\rS:LG/[1m\t\u0016d\u0017-\u001f\t\u0005\u0007G\u0019I#\u0004\u0002\u0004&)\u00191qE-\u0002\u0011\u0011,(/\u0019;j_:LAaa\u000b\u0004&\tqa)\u001b8ji\u0016$UO]1uS>t\u0007bBB\u0018u\u0001\u00071\u0011E\u0001\tS:$XM\u001d<bY\"911\u0007\u001eA\u0002\rU\u0012\u0001\u0003:v]:\f'\r\\3\u0011\t\u0005m7qG\u0005\u0005\u0007s\tiN\u0001\u0005Sk:t\u0017M\u00197f\u0003M\u0011Xm\u0019:fCR,7)Y5s_\u0016sw-\u001b8f)\u0011\tioa\u0010\t\u000b\u001d\\\u0004\u0019A5")
public class QuestDbFEStatisticsRepository
implements FEStatisticsRepository<Future>,
LazyLogging {
    private AtomicReference<RetentionTask> retentionTask;
    private final AtomicReference<CairoEngine> engine;
    private final Clock clock;
    private final ExecutionContextExecutorService ec;
    private final int workerCount;
    private final ThreadAwareObjectPool<SqlExecutionContext> sqlContextPool;
    private final ThreadAwareObjectPool<RecordCursorFactory> recordCursorPool;
    private final ThreadAwareObjectPool<WalWriter> walTableWriterPool;
    private final TaskRecovery taskRecovery;
    private final AtomicReference<FlushDataTask> flushDataTask;
    private final AtomicReference<PurgeWalTask> purgeWalTask;
    private final AtomicBoolean shouldCleanUpData;
    private final ConcurrentHashMap<String, Long> aggregatedStatistics;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Resource<IO, FEStatisticsRepository<Future>> create(ActorSystem system, Clock clock, Config config) {
        return QuestDbFEStatisticsRepository$.MODULE$.create(system, clock, config);
    }

    private Logger logger$lzycompute() {
        QuestDbFEStatisticsRepository questDbFEStatisticsRepository = this;
        synchronized (questDbFEStatisticsRepository) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private AtomicReference<CairoEngine> engine() {
        return this.engine;
    }

    private Clock clock() {
        return this.clock;
    }

    private ExecutionContextExecutorService ec() {
        return this.ec;
    }

    private int workerCount() {
        return this.workerCount;
    }

    private ThreadAwareObjectPool<SqlExecutionContext> sqlContextPool() {
        return this.sqlContextPool;
    }

    private ThreadAwareObjectPool<RecordCursorFactory> recordCursorPool() {
        return this.recordCursorPool;
    }

    private ThreadAwareObjectPool<WalWriter> walTableWriterPool() {
        return this.walTableWriterPool;
    }

    private TaskRecovery taskRecovery() {
        return this.taskRecovery;
    }

    private AtomicReference<FlushDataTask> flushDataTask() {
        return this.flushDataTask;
    }

    private AtomicReference<PurgeWalTask> purgeWalTask() {
        return this.purgeWalTask;
    }

    private AtomicReference<RetentionTask> retentionTask$lzycompute() {
        QuestDbFEStatisticsRepository questDbFEStatisticsRepository = this;
        synchronized (questDbFEStatisticsRepository) {
            if (!this.bitmap$0) {
                this.retentionTask = new AtomicReference<RetentionTask>(this.createRetentionTask());
                this.bitmap$0 = true;
            }
        }
        return this.retentionTask;
    }

    private AtomicReference<RetentionTask> retentionTask() {
        if (!this.bitmap$0) {
            return this.retentionTask$lzycompute();
        }
        return this.retentionTask;
    }

    private AtomicBoolean shouldCleanUpData() {
        return this.shouldCleanUpData;
    }

    private ConcurrentHashMap<String, Long> aggregatedStatistics() {
        return this.aggregatedStatistics;
    }

    @Override
    public Future<BoxedUnit> write(RawFEStatistics rawFEStatistics) {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> rawFEStatistics.raw().foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                long newValue = tuple2._2$mcJ$sp();
                return this.aggregatedStatistics().compute(key, (x$1, oldValue) -> {
                    if (oldValue == null) {
                        return Predef$.MODULE$.long2Long(newValue);
                    }
                    return Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(oldValue) + newValue);
                });
            }
            throw new MatchError((Object)tuple2);
        }), (ExecutionContext)this.ec());
    }

    @Override
    public Future<RawFEStatistics> read() {
        return Future$.MODULE$.apply((Function0 & Serializable)() -> {
            Map result = QuestDbExtensions$.MODULE$.RecordCursorFactoryExtension(this.recordCursorPool().get()).fetch(this.sqlContextPool().get(), (Function1 & Serializable)record -> {
                String name = ((Object)record.getStrA(0)).toString();
                long count = record.getLong(1);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)BoxesRunTime.boxToLong((long)count));
            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            return new RawFEStatistics((Map<String, Object>)result);
        }, (ExecutionContext)this.ec());
    }

    private long currentTimeMicros() {
        return Math.multiplyExact(this.clock().instant().toEpochMilli(), 1000L);
    }

    public void pl$touk$nussknacker$ui$db$timeseries$questdb$QuestDbFEStatisticsRepository$$close() {
        this.recordCursorPool().clear();
        this.walTableWriterPool().clear();
        this.sqlContextPool().clear();
        this.flushDataTask().get().close();
        this.purgeWalTask().get().close();
    }

    public void pl$touk$nussknacker$ui$db$timeseries$questdb$QuestDbFEStatisticsRepository$$createTableIfNotExist() {
        this.engine().get().ddl((CharSequence)QuestDbFEStatisticsRepository$.MODULE$.pl$touk$nussknacker$ui$db$timeseries$questdb$QuestDbFEStatisticsRepository$$createTableQuery(), this.sqlContextPool().get());
    }

    private synchronized Try<BoxedUnit> recover() {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.pl$touk$nussknacker$ui$db$timeseries$questdb$QuestDbFEStatisticsRepository$$close();
            QuestDbFEStatisticsRepository$.MODULE$.pl$touk$nussknacker$ui$db$timeseries$questdb$QuestDbFEStatisticsRepository$$recreateCairoEngine(this.engine());
            this.pl$touk$nussknacker$ui$db$timeseries$questdb$QuestDbFEStatisticsRepository$$createTableIfNotExist();
            this.flushDataTask().set(this.createFlushDataTask());
            this.purgeWalTask().set(this.createPurgeWalTask());
            this.retentionTask().set(this.createRetentionTask());
        });
    }

    public void pl$touk$nussknacker$ui$db$timeseries$questdb$QuestDbFEStatisticsRepository$$executeTasks() {
        Map<String, Object> statistics = this.statisticsSnapshot();
        long currentTimeInMicros = this.currentTimeMicros();
        this.taskRecovery().runWithRecover((JFunction0.mcV.sp & Serializable)() -> this.flushDataTask().get().runUnsafe(statistics, currentTimeInMicros));
        this.taskRecovery().runWithRecover((JFunction0.mcV.sp & Serializable)() -> this.purgeWalTask().get().runUnsafe());
        this.runRetentionTask();
    }

    private Map<String, Object> statisticsSnapshot() {
        return CollectionConverters$.MODULE$.SetHasAsScala(this.aggregatedStatistics().keySet()).asScala().toList().map((Function1 & Serializable)key -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable)() -> this.aggregatedStatistics().remove(key)).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private void runRetentionTask() {
        if (this.shouldCleanUpData().get()) {
            this.shouldCleanUpData().set(false);
            this.taskRecovery().runWithRecover((JFunction0.mcV.sp & Serializable)() -> this.retentionTask().get().runUnsafe());
            return;
        }
    }

    public void pl$touk$nussknacker$ui$db$timeseries$questdb$QuestDbFEStatisticsRepository$$scheduleRetention() {
        this.shouldCleanUpData().set(true);
    }

    private FlushDataTask createFlushDataTask() {
        return new FlushDataTask(this.engine().get(), this.walTableWriterPool(), (ExecutionContext)this.ec());
    }

    private PurgeWalTask createPurgeWalTask() {
        return new PurgeWalTask(this.engine().get());
    }

    private RetentionTask createRetentionTask() {
        return new RetentionTask(this.engine().get(), QuestDbFEStatisticsRepository$.MODULE$.pl$touk$nussknacker$ui$db$timeseries$questdb$QuestDbFEStatisticsRepository$$tableName(), this.sqlContextPool(), this.clock());
    }

    public QuestDbFEStatisticsRepository(AtomicReference<CairoEngine> engine, Clock clock, ExecutionContextExecutorService ec) {
        this.engine = engine;
        this.clock = clock;
        this.ec = ec;
        LazyLogging.$init$((LazyLogging)this);
        this.workerCount = 1;
        this.sqlContextPool = new ThreadAwareObjectPool((Function0 & Serializable)() -> new SqlExecutionContextImpl(this.engine().get(), this.workerCount()).with((SecurityContext)AllowAllSecurityContext.INSTANCE, null));
        this.recordCursorPool = new ThreadAwareObjectPool((Function0 & Serializable)() -> this.engine().get().select((CharSequence)QuestDbFEStatisticsRepository$.MODULE$.pl$touk$nussknacker$ui$db$timeseries$questdb$QuestDbFEStatisticsRepository$$selectQuery(), this.sqlContextPool().get()));
        this.walTableWriterPool = new ThreadAwareObjectPool((Function0 & Serializable)() -> this.engine().get().getWalWriter(this.engine().get().getTableTokenIfExists((CharSequence)QuestDbFEStatisticsRepository$.MODULE$.pl$touk$nussknacker$ui$db$timeseries$questdb$QuestDbFEStatisticsRepository$$tableName())));
        this.taskRecovery = new TaskRecovery(engine, (Function0<Try<BoxedUnit>>)(Function0 & Serializable)() -> this.recover(), QuestDbFEStatisticsRepository$.MODULE$.pl$touk$nussknacker$ui$db$timeseries$questdb$QuestDbFEStatisticsRepository$$tableName());
        this.flushDataTask = new AtomicReference<FlushDataTask>(this.createFlushDataTask());
        this.purgeWalTask = new AtomicReference<PurgeWalTask>(this.createPurgeWalTask());
        this.shouldCleanUpData = new AtomicBoolean(false);
        this.aggregatedStatistics = new ConcurrentHashMap();
    }
}

