/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.statistics;

import cats.Functor;
import cats.Invariant$;
import cats.Monad;
import cats.data.EitherT;
import cats.data.EitherT$;
import java.io.Serializable;
import java.time.Clock;
import java.time.Instant;
import pl.touk.nussknacker.engine.api.component.DesignerWideComponentId;
import pl.touk.nussknacker.engine.definition.component.ComponentDefinitionWithImplementation;
import pl.touk.nussknacker.engine.version.BuildInfo$;
import pl.touk.nussknacker.ui.config.UsageStatisticsReportsConfig;
import pl.touk.nussknacker.ui.db.timeseries.FEStatisticsRepository;
import pl.touk.nussknacker.ui.definition.component.ComponentService;
import pl.touk.nussknacker.ui.process.ProcessService;
import pl.touk.nussknacker.ui.process.processingtype.DeploymentManagerType;
import pl.touk.nussknacker.ui.process.processingtype.ProcessingTypeDataProvider;
import pl.touk.nussknacker.ui.process.repository.ProcessActivityRepository;
import pl.touk.nussknacker.ui.statistics.DesignerUptimeInSeconds$;
import pl.touk.nussknacker.ui.statistics.Fingerprint;
import pl.touk.nussknacker.ui.statistics.FingerprintService;
import pl.touk.nussknacker.ui.statistics.NuSource$;
import pl.touk.nussknacker.ui.statistics.NuVersion$;
import pl.touk.nussknacker.ui.statistics.RawFEStatistics;
import pl.touk.nussknacker.ui.statistics.RequestId;
import pl.touk.nussknacker.ui.statistics.RequestId$;
import pl.touk.nussknacker.ui.statistics.ScenarioStatistics$;
import pl.touk.nussknacker.ui.statistics.ScenarioStatisticsInputData;
import pl.touk.nussknacker.ui.statistics.StatisticError;
import pl.touk.nussknacker.ui.statistics.Statistics;
import pl.touk.nussknacker.ui.statistics.Statistics$Empty$;
import pl.touk.nussknacker.ui.statistics.UsageStatisticsReportsSettingsService$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.IterableOnce;
import scala.collection.MapOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0005\t\rs!\u0002\r\u001a\u0011\u0003!c!\u0002\u0014\u001a\u0011\u00039\u0003\"\u0002\u001d\u0002\t\u0003I\u0004b\u0002\u001e\u0002\u0005\u0004%Ia\u000f\u0005\u0007\u007f\u0005\u0001\u000b\u0011\u0002\u001f\t\u000b\u0001\u000bA\u0011A!\t\u000f\t%\u0012\u0001\"\u0003\u0003,\u0019!a%\u0007\u0001E\u0011!)uA!A!\u0002\u00131\u0005\u0002C&\b\u0005\u0003\u0005\u000b\u0011\u0002'\t\u0011=;!\u0011!Q\u0001\nAC\u0001B\\\u0004\u0003\u0002\u0003\u0006Ia\u001c\u0005\n\u007f\u001e\u0011\t\u0011)A\u0005\u0003\u0003A!\"a\u0003\b\u0005\u0003\u0005\u000b\u0011BA\u0007\u0011)\t\u0019c\u0002B\u0001B\u0003%\u0011Q\u0005\u0005\u000b\u0003\u007f9!\u0011!Q\u0001\n\u0005\u0005\u0003BCA)\u000f\t\u0005\t\u0015a\u0003\u0002T!1\u0001h\u0002C\u0001\u00033B\u0011\"a\u001c\b\u0005\u0004%I!!\u001d\t\u0011\u0005et\u0001)A\u0005\u0003gBq!a\u001f\b\t\u0003\ti\bC\u0004\u0002\n\u001e!I!a#\t\u000f\u0005}u\u0001\"\u0003\u0002\"\"9\u0011qU\u0004\u0005\n\u0005%\u0016!J+tC\u001e,7\u000b^1uSN$\u0018nY:SKB|'\u000f^:TKR$\u0018N\\4t'\u0016\u0014h/[2f\u0015\tQ2$\u0001\u0006ti\u0006$\u0018n\u001d;jGNT!\u0001H\u000f\u0002\u0005UL'B\u0001\u0010 \u0003-qWo]:l]\u0006\u001c7.\u001a:\u000b\u0005\u0001\n\u0013\u0001\u0002;pk.T\u0011AI\u0001\u0003a2\u001c\u0001\u0001\u0005\u0002&\u00035\t\u0011DA\u0013Vg\u0006<Wm\u0015;bi&\u001cH/[2t%\u0016\u0004xN\u001d;t'\u0016$H/\u001b8hgN+'O^5dKN\u0019\u0011\u0001\u000b\u0018\u0011\u0005%bS\"\u0001\u0016\u000b\u0003-\nQa]2bY\u0006L!!\f\u0016\u0003\r\u0005s\u0017PU3g!\tyc'D\u00011\u0015\t\t$'\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u00024i\u0005AA/\u001f9fg\u00064WMC\u00016\u0003\r\u0019w.\\\u0005\u0003oA\u00121\u0002T1{s2{wmZ5oO\u00061A(\u001b8jiz\"\u0012\u0001J\u0001\u0016]V4\u0015N\\4feB\u0014\u0018N\u001c;GS2,g*Y7f+\u0005a\u0004CA\u0013>\u0013\tq\u0014D\u0001\u0005GS2,g*Y7f\u0003YqWOR5oO\u0016\u0014\bO]5oi\u001aKG.\u001a(b[\u0016\u0004\u0013!B1qa2LHc\u0005\"\u0002.\u0006=\u0016qXAw\u0003_\fyPa\u0004\u0003$\t\u001dBcA\"\u0002,B\u0011QeB\n\u0003\u000f!\naaY8oM&<\u0007CA$J\u001b\u0005A%BA#\u001c\u0013\tQ\u0005J\u0001\u000fVg\u0006<Wm\u0015;bi&\u001cH/[2t%\u0016\u0004xN\u001d;t\u0007>tg-[4\u0002%\u0019LgnZ3saJLg\u000e^*feZL7-\u001a\t\u0003K5K!AT\r\u0003%\u0019KgnZ3saJLg\u000e^*feZL7-Z\u0001#M\u0016$8\r\u001b(p]\u0006\u00138\r[5wK\u0012\u001c6-\u001a8be&|7/\u00138qkR$\u0015\r^1\u0011\u0007%\n6+\u0003\u0002SU\tIa)\u001e8di&|g\u000e\r\t\u0004)^KV\"A+\u000b\u0005YS\u0013AC2p]\u000e,(O]3oi&\u0011\u0001,\u0016\u0002\u0007\rV$XO]3\u0011\ti\u0013W\r\u001b\b\u00037\u0002t!\u0001X0\u000e\u0003uS!AX\u0012\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0013BA1+\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u00193\u0003\r\u0015KG\u000f[3s\u0015\t\t'\u0006\u0005\u0002&M&\u0011q-\u0007\u0002\u000f'R\fG/[:uS\u000e,%O]8s!\rQ\u0016n[\u0005\u0003U\u0012\u0014A\u0001T5tiB\u0011Q\u0005\\\u0005\u0003[f\u00111dU2f]\u0006\u0014\u0018n\\*uCRL7\u000f^5dg&s\u0007/\u001e;ECR\f\u0017!\u00044fi\u000eD\u0017i\u0019;jm&$\u0018\u0010E\u0002*#B\u00042\u0001V,r!\u0011\u0011h/\u001f?\u000f\u0005M$\bC\u0001/+\u0013\t)(&\u0001\u0004Qe\u0016$WMZ\u0005\u0003ob\u00141!T1q\u0015\t)(\u0006\u0005\u0002su&\u00111\u0010\u001f\u0002\u0007'R\u0014\u0018N\\4\u0011\u0005%j\u0018B\u0001@+\u0005\rIe\u000e^\u0001\u0012M\u0016$8\r\u001b$f'R\fG/[:uS\u000e\u001c\b\u0003B\u0015R\u0003\u0007\u0001B\u0001V,\u0002\u0006A\u0019Q%a\u0002\n\u0007\u0005%\u0011DA\bSC^4Ui\u0015;bi&\u001cH/[2t\u0003)\u0019w.\u001c9p]\u0016tGo\u001d\t\u00055&\fy\u0001\u0005\u0003\u0002\u0012\u0005}QBAA\n\u0015\u0011\t)\"a\u0006\u0002\u0013\r|W\u000e]8oK:$(\u0002BA\r\u00037\t!\u0002Z3gS:LG/[8o\u0015\r\ti\"H\u0001\u0007K:<\u0017N\\3\n\t\u0005\u0005\u00121\u0003\u0002&\u0007>l\u0007o\u001c8f]R$UMZ5oSRLwN\\,ji\"LU\u000e\u001d7f[\u0016tG/\u0019;j_:\fabY8na>tWM\u001c;Vg\u0006<W\r\u0005\u0003*#\u0006\u001d\u0002\u0003\u0002+X\u0003S\u0001bA\u001d<\u0002,\u0005e\u0002\u0003BA\u0017\u0003ki!!a\f\u000b\t\u0005U\u0011\u0011\u0007\u0006\u0005\u0003g\tY\"A\u0002ba&LA!a\u000e\u00020\t9B)Z:jO:,'oV5eK\u000e{W\u000e]8oK:$\u0018\n\u001a\t\u0004S\u0005m\u0012bAA\u001fU\t!Aj\u001c8h\u00035!Wm]5h]\u0016\u00148\t\\8dWB!\u00111IA'\u001b\t\t)E\u0003\u0003\u0002H\u0005%\u0013\u0001\u0002;j[\u0016T!!a\u0013\u0002\t)\fg/Y\u0005\u0005\u0003\u001f\n)EA\u0003DY>\u001c7.\u0001\u0002fGB\u0019A+!\u0016\n\u0007\u0005]SK\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yiR\u0011\u00121LA0\u0003C\n\u0019'!\u001a\u0002h\u0005%\u00141NA7)\r\u0019\u0015Q\f\u0005\b\u0003#\n\u00029AA*\u0011\u0015)\u0015\u00031\u0001G\u0011\u0015Y\u0015\u00031\u0001M\u0011\u0015y\u0015\u00031\u0001Q\u0011\u0015q\u0017\u00031\u0001p\u0011\u0019y\u0018\u00031\u0001\u0002\u0002!9\u00111B\tA\u0002\u00055\u0001bBA\u0012#\u0001\u0007\u0011Q\u0005\u0005\b\u0003\u007f\t\u0002\u0019AA!\u0003E!Wm]5h]\u0016\u00148\u000b^1siRKW.Z\u000b\u0003\u0003g\u0002B!a\u0011\u0002v%!\u0011qOA#\u0005\u001dIen\u001d;b]R\f!\u0003Z3tS\u001etWM]*uCJ$H+[7fA\u0005!\u0002O]3qCJ,7\u000b^1uSN$\u0018nY:Ve2$\"!a \u0011\tQ;\u0016\u0011\u0011\t\u00065\n,\u00171\u0011\t\u0004K\u0005\u0015\u0015bAAD3\tQ1\u000b^1uSN$\u0018nY:\u0002'\u0011,G/\u001a:nS:,7\u000b^1uSN$\u0018nY:\u0015\u0005\u00055\u0005#CAH\u00033\u000bi*ZAB\u001b\t\t\tJ\u0003\u0003\u0002\u0014\u0006U\u0015\u0001\u00023bi\u0006T!!a&\u0002\t\r\fGo]\u0005\u0005\u00037\u000b\tJA\u0004FSRDWM\u001d+\u0011\u0005Q;\u0016\u0001\u00073fi\u0016\u0014X.\u001b8f\u0005\u0006\u001c\u0018nY*uCRL7\u000f^5dgR!\u00111UAS!\u0011\u0011h/_=\t\u000b\u00153\u0002\u0019\u0001$\u00027\u001d,G\u000fR3tS\u001etWM]+qi&lWm\u0015;bi&\u001cH/[2t+\t\t\u0019\u000bC\u0004\u0002R\u0015\u0001\u001d!a\u0015\t\u000b\u0015+\u0001\u0019\u0001$\t\u000f\u0005EV\u00011\u0001\u00024\u0006q\u0001O]8dKN\u001c8+\u001a:wS\u000e,\u0007\u0003BA[\u0003wk!!a.\u000b\u0007\u0005e6$A\u0004qe>\u001cWm]:\n\t\u0005u\u0016q\u0017\u0002\u000f!J|7-Z:t'\u0016\u0014h/[2f\u0011\u001d\t\t-\u0002a\u0001\u0003\u0007\fa\u0003Z3qY>LX.\u001a8u\u001b\u0006t\u0017mZ3s)f\u0004Xm\u001d\u0019\u0005\u0003\u000b\fY\u000e\u0005\u0005\u0002H\u00065\u0017\u0011[Al\u001b\t\tIM\u0003\u0003\u0002L\u0006]\u0016A\u00049s_\u000e,7o]5oORL\b/Z\u0005\u0005\u0003\u001f\fIM\u0001\u000eQe>\u001cWm]:j]\u001e$\u0016\u0010]3ECR\f\u0007K]8wS\u0012,'\u000f\u0005\u0003\u0002H\u0006M\u0017\u0002BAk\u0003\u0013\u0014Q\u0003R3qY>LX.\u001a8u\u001b\u0006t\u0017mZ3s)f\u0004X\r\u0005\u0003\u0002Z\u0006mG\u0002\u0001\u0003\r\u0003;\fy,!A\u0001\u0002\u000b\u0005\u0011q\u001c\u0002\u0004?\u0012\n\u0014\u0003BAq\u0003O\u00042!KAr\u0013\r\t)O\u000b\u0002\b\u001d>$\b.\u001b8h!\rI\u0013\u0011^\u0005\u0004\u0003WT#aA!os\")1*\u0002a\u0001\u0019\"9\u0011\u0011_\u0003A\u0002\u0005M\u0018AG:dK:\f'/[8BGRLg/\u001b;z%\u0016\u0004xn]5u_JL\b\u0003BA{\u0003wl!!a>\u000b\t\u0005e\u0018qW\u0001\u000be\u0016\u0004xn]5u_JL\u0018\u0002BA\u007f\u0003o\u0014\u0011\u0004\u0015:pG\u0016\u001c8/Q2uSZLG/\u001f*fa>\u001c\u0018\u000e^8ss\"9!\u0011A\u0003A\u0002\t\r\u0011\u0001E2p[B|g.\u001a8u'\u0016\u0014h/[2f!\u0011\u0011)Aa\u0003\u000e\u0005\t\u001d!\u0002BA\u000b\u0005\u0013Q1!!\u0007\u001c\u0013\u0011\u0011iAa\u0002\u0003!\r{W\u000e]8oK:$8+\u001a:wS\u000e,\u0007b\u0002B\t\u000b\u0001\u0007!1C\u0001\u0015gR\fG/[:uS\u000e\u001c(+\u001a9pg&$xN]=\u0011\r\tU!qDAO\u001b\t\u00119B\u0003\u0003\u0003\u001a\tm\u0011A\u0003;j[\u0016\u001cXM]5fg*\u0019!QD\u000e\u0002\u0005\u0011\u0014\u0017\u0002\u0002B\u0011\u0005/\u0011aCR#Ti\u0006$\u0018n\u001d;jGN\u0014V\r]8tSR|'/\u001f\u0005\b\u0005K)\u0001\u0019AA\u0007\u00035\u0019w.\u001c9p]\u0016tG\u000fT5ti\"9\u0011qH\u0003A\u0002\u0005\u0005\u0013AG4fi\u001a\u0013\u0018mZ7f]R\u001cXk]3e\u0013:\u001c6-\u001a8be&|Gc\u0001?\u0003.!9!q\u0006\u0004A\u0002\tE\u0012!D:dK:\f'/[8He\u0006\u0004\b\u000eE\u0003*\u0005g\u00119$C\u0002\u00036)\u0012aa\u00149uS>t\u0007\u0003\u0002B\u001d\u0005\u007fi!Aa\u000f\u000b\t\tu\u0012\u0011G\u0001\u0006OJ\f\u0007\u000f[\u0005\u0005\u0005\u0003\u0012YDA\u0007TG\u0016t\u0017M]5p\u000fJ\f\u0007\u000f\u001b")
public class UsageStatisticsReportsSettingsService {
    private final UsageStatisticsReportsConfig config;
    private final FingerprintService fingerprintService;
    private final Function0<Future<Either<StatisticError, List<ScenarioStatisticsInputData>>>> fetchNonArchivedScenariosInputData;
    private final Function0<Future<Map<String, Object>>> fetchActivity;
    private final Function0<Future<RawFEStatistics>> fetchFeStatistics;
    private final List<ComponentDefinitionWithImplementation> components;
    private final Function0<Future<Map<DesignerWideComponentId, Object>>> componentUsage;
    private final Clock designerClock;
    private final ExecutionContext ec;
    private final Instant designerStartTime;

    public static UsageStatisticsReportsSettingsService apply(UsageStatisticsReportsConfig config, ProcessService processService, ProcessingTypeDataProvider<DeploymentManagerType, ?> deploymentManagerTypes, FingerprintService fingerprintService, ProcessActivityRepository scenarioActivityRepository, ComponentService componentService, FEStatisticsRepository<Future> statisticsRepository, List<ComponentDefinitionWithImplementation> componentList, Clock designerClock, ExecutionContext ec) {
        return UsageStatisticsReportsSettingsService$.MODULE$.apply(config, processService, deploymentManagerTypes, fingerprintService, scenarioActivityRepository, componentService, statisticsRepository, componentList, designerClock, ec);
    }

    private Instant designerStartTime() {
        return this.designerStartTime;
    }

    public Future<Either<StatisticError, Statistics>> prepareStatisticsUrl() {
        if (this.config.enabled()) {
            return (Future)this.determineStatistics().value();
        }
        return Future$.MODULE$.successful((Object)package$.MODULE$.Right().apply((Object)Statistics$Empty$.MODULE$));
    }

    private EitherT<Future, StatisticError, Statistics> determineStatistics() {
        return new EitherT(this.fetchNonArchivedScenariosInputData.apply()).map((Function1 & Serializable)scenariosInputData -> {
            Map<String, String> scenariosStatistics = ScenarioStatistics$.MODULE$.getScenarioStatistics((List<ScenarioStatisticsInputData>)scenariosInputData);
            Map<String, String> basicStatistics = this.determineBasicStatistics($this.config);
            Map<String, String> generalStatistics = ScenarioStatistics$.MODULE$.getGeneralStatistics((List<ScenarioStatisticsInputData>)scenariosInputData);
            return new Tuple4(scenariosInputData, scenariosStatistics, basicStatistics, generalStatistics);
        }, (Functor)Invariant$.MODULE$.catsInstancesForFuture(this.ec)).flatMap((Function1 & Serializable)x$7 -> {
            Tuple4 tuple4 = x$7;
            if (tuple4 != null) {
                List scenariosInputData = (List)tuple4._1();
                Map scenariosStatistics = (Map)tuple4._2();
                Map basicStatistics = (Map)tuple4._3();
                Map generalStatistics = (Map)tuple4._4();
                return EitherT$.MODULE$.liftF($this.fetchActivity.apply(), (Functor)Invariant$.MODULE$.catsInstancesForFuture($this.ec)).map((Function1 & Serializable)attachmentsAndCommentsTotal -> {
                    Map<String, String> activityStatistics = ScenarioStatistics$.MODULE$.getActivityStatistics((Map<String, Object>)attachmentsAndCommentsTotal, scenariosInputData.length());
                    return new Tuple2(attachmentsAndCommentsTotal, activityStatistics);
                }, (Functor)Invariant$.MODULE$.catsInstancesForFuture($this.ec)).flatMap((Function1 & Serializable)x$6 -> {
                    Tuple2 tuple2 = x$6;
                    if (tuple2 != null) {
                        Map activityStatistics = (Map)tuple2._2();
                        return EitherT$.MODULE$.liftF($this.componentUsage.apply(), (Functor)Invariant$.MODULE$.catsInstancesForFuture($this.ec)).map((Function1 & Serializable)componentDesignerWideUsage -> {
                            Map<String, String> componentStatistics = ScenarioStatistics$.MODULE$.getComponentStatistics((Map<DesignerWideComponentId, Object>)componentDesignerWideUsage, $this.components);
                            return new Tuple2(componentDesignerWideUsage, componentStatistics);
                        }, (Functor)Invariant$.MODULE$.catsInstancesForFuture($this.ec)).flatMap((Function1 & Serializable)x$5 -> {
                            Tuple2 tuple2 = x$5;
                            if (tuple2 != null) {
                                Map componentStatistics = (Map)tuple2._2();
                                return EitherT$.MODULE$.liftF($this.fetchFeStatistics.apply(), (Functor)Invariant$.MODULE$.catsInstancesForFuture($this.ec)).map((Function1 & Serializable)feStatistics -> {
                                    Map<String, String> designerUptimeStatistics = this.getDesignerUptimeStatistics();
                                    return new Tuple2(feStatistics, designerUptimeStatistics);
                                }, (Functor)Invariant$.MODULE$.catsInstancesForFuture($this.ec)).flatMap((Function1 & Serializable)x$4 -> {
                                    Tuple2 tuple2 = x$4;
                                    if (tuple2 != null) {
                                        RawFEStatistics feStatistics = (RawFEStatistics)tuple2._1();
                                        Map designerUptimeStatistics = (Map)tuple2._2();
                                        return new EitherT($this.fingerprintService.fingerprint($this.config, UsageStatisticsReportsSettingsService$.MODULE$.pl$touk$nussknacker$ui$statistics$UsageStatisticsReportsSettingsService$$nuFingerprintFileName())).map((Function1 & Serializable)fingerprint -> UsageStatisticsReportsSettingsService.$anonfun$determineStatistics$9(basicStatistics, scenariosStatistics, generalStatistics, activityStatistics, componentStatistics, designerUptimeStatistics, feStatistics, ((Fingerprint)fingerprint).value()), (Functor)Invariant$.MODULE$.catsInstancesForFuture($this.ec)).map((Function1 & Serializable)x$3 -> {
                                            Tuple3 tuple3 = x$3;
                                            if (tuple3 != null) {
                                                String fingerprint = ((Fingerprint)tuple3._1()).value();
                                                String requestId = ((RequestId)tuple3._2()).value();
                                                Map combinedStatistics = (Map)tuple3._3();
                                                return new Statistics.NonEmpty(fingerprint, requestId, (Map<String, String>)combinedStatistics);
                                            }
                                            throw new MatchError((Object)tuple3);
                                        }, (Functor)Invariant$.MODULE$.catsInstancesForFuture($this.ec));
                                    }
                                    throw new MatchError((Object)tuple2);
                                }, (Monad)Invariant$.MODULE$.catsInstancesForFuture($this.ec));
                            }
                            throw new MatchError((Object)tuple2);
                        }, (Monad)Invariant$.MODULE$.catsInstancesForFuture($this.ec));
                    }
                    throw new MatchError((Object)tuple2);
                }, (Monad)Invariant$.MODULE$.catsInstancesForFuture($this.ec));
            }
            throw new MatchError((Object)tuple4);
        }, (Monad)Invariant$.MODULE$.catsInstancesForFuture(this.ec));
    }

    private Map<String, String> determineBasicStatistics(UsageStatisticsReportsConfig config) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)NuSource$.MODULE$.name()), config.source().filterNot((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.isBlank())).getOrElse((Function0 & Serializable)() -> "sources")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)NuVersion$.MODULE$.name()), (Object)BuildInfo$.MODULE$.version())}));
    }

    private Map<String, String> getDesignerUptimeStatistics() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DesignerUptimeInSeconds$.MODULE$.name()), (Object)Long.toString(this.designerClock.instant().getEpochSecond() - this.designerStartTime().getEpochSecond()))}));
    }

    public static final /* synthetic */ Tuple3 $anonfun$determineStatistics$9(Map basicStatistics$1, Map scenariosStatistics$1, Map generalStatistics$1, Map activityStatistics$1, Map componentStatistics$1, Map designerUptimeStatistics$1, RawFEStatistics feStatistics$1, String fingerprint) {
        String requestId = RequestId$.MODULE$.apply();
        Map combinedStatistics = (Map)((MapOps)((MapOps)((MapOps)((MapOps)((MapOps)basicStatistics$1.$plus$plus((IterableOnce)scenariosStatistics$1)).$plus$plus((IterableOnce)generalStatistics$1)).$plus$plus((IterableOnce)activityStatistics$1)).$plus$plus((IterableOnce)componentStatistics$1)).$plus$plus((IterableOnce)designerUptimeStatistics$1)).$plus$plus((IterableOnce)feStatistics$1.raw().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                long v = tuple2._2$mcJ$sp();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)Long.toString(v));
            }
            throw new MatchError((Object)tuple2);
        }));
        return new Tuple3((Object)new Fingerprint(fingerprint), (Object)new RequestId(requestId), (Object)combinedStatistics);
    }

    public UsageStatisticsReportsSettingsService(UsageStatisticsReportsConfig config, FingerprintService fingerprintService, Function0<Future<Either<StatisticError, List<ScenarioStatisticsInputData>>>> fetchNonArchivedScenariosInputData, Function0<Future<Map<String, Object>>> fetchActivity, Function0<Future<RawFEStatistics>> fetchFeStatistics, List<ComponentDefinitionWithImplementation> components, Function0<Future<Map<DesignerWideComponentId, Object>>> componentUsage, Clock designerClock, ExecutionContext ec) {
        this.config = config;
        this.fingerprintService = fingerprintService;
        this.fetchNonArchivedScenariosInputData = fetchNonArchivedScenariosInputData;
        this.fetchActivity = fetchActivity;
        this.fetchFeStatistics = fetchFeStatistics;
        this.components = components;
        this.componentUsage = componentUsage;
        this.designerClock = designerClock;
        this.ec = ec;
        this.designerStartTime = designerClock.instant();
    }
}

