/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.api;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.circe.Json;
import io.circe.parser.package$;
import java.io.Serializable;
import net.ceedubs.ficus.Ficus$;
import pl.touk.nussknacker.engine.api.deployment.ProcessState;
import pl.touk.nussknacker.engine.api.deployment.StateStatus;
import pl.touk.nussknacker.engine.api.deployment.simple.SimpleStateStatus;
import pl.touk.nussknacker.engine.api.process.ProcessName;
import pl.touk.nussknacker.engine.util.Implicits$;
import pl.touk.nussknacker.engine.version.BuildInfo$;
import pl.touk.nussknacker.restmodel.scenariodetails.ScenarioWithDetails;
import pl.touk.nussknacker.security.AuthCredentials;
import pl.touk.nussknacker.ui.api.BaseHttpService;
import pl.touk.nussknacker.ui.api.description.AppApiEndpoints;
import pl.touk.nussknacker.ui.api.description.AppApiEndpoints$Dtos$HealthCheckProcessErrorResponseDto$;
import pl.touk.nussknacker.ui.api.description.AppApiEndpoints$Dtos$HealthCheckProcessSuccessResponseDto$;
import pl.touk.nussknacker.ui.api.description.AppApiEndpoints$Dtos$UserCategoriesWithProcessingTypesDto$;
import pl.touk.nussknacker.ui.process.ProcessService;
import pl.touk.nussknacker.ui.process.ProcessService$GetScenarioWithDetailsOptions$;
import pl.touk.nussknacker.ui.process.ScenarioQuery$;
import pl.touk.nussknacker.ui.process.processingtype.provider.ProcessingTypeDataProvider;
import pl.touk.nussknacker.ui.process.processingtype.provider.ReloadableProcessingTypeDataProvider;
import pl.touk.nussknacker.ui.security.api.AuthManager;
import pl.touk.nussknacker.ui.security.api.LoggedUser;
import pl.touk.nussknacker.ui.security.api.NussknackerInternalUser$;
import pl.touk.nussknacker.ui.util.ExecutionContextWithIORuntime;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;
import sttp.tapir.EndpointInput;
import sttp.tapir.server.ServerEndpoint;

@ScalaSignature(bytes="\u0006\u0005\u0005}d\u0001\u0002\b\u0010\u0001iA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005a!Aq\u0007\u0001B\u0001B\u0003%\u0001\b\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003D\u0011!\u0019\u0007A!A!\u0002\u0013!\u0007\u0002C5\u0001\u0005\u0003\u0005\u000b\u0011\u00026\t\u00119\u0004!\u0011!Q\u0001\n=D\u0001B\u001d\u0001\u0003\u0002\u0003\u0006Ya\u001d\u0005\u0006s\u0002!\tA\u001f\u0005\n\u00037\u0001!\u0019!C\u0005\u0003;A\u0001\"a\u000b\u0001A\u0003%\u0011q\u0004\u0005\b\u0003[\u0001A\u0011BA\u0018\u0011\u001d\t)\u0007\u0001C\u0005\u0003O\u0012\u0011#\u00119q\u0003BL\u0007\n\u001e;q'\u0016\u0014h/[2f\u0015\t\u0001\u0012#A\u0002ba&T!AE\n\u0002\u0005UL'B\u0001\u000b\u0016\u0003-qWo]:l]\u0006\u001c7.\u001a:\u000b\u0005Y9\u0012\u0001\u0002;pk.T\u0011\u0001G\u0001\u0003a2\u001c\u0001aE\u0002\u00017}\u0001\"\u0001H\u000f\u000e\u0003=I!AH\b\u0003\u001f\t\u000b7/\u001a%uiB\u001cVM\u001d<jG\u0016\u0004\"\u0001I\u0014\u000e\u0003\u0005R!AI\u0012\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005\u0011*\u0013\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003\u0019\n1aY8n\u0013\tA\u0013EA\u0006MCjLHj\\4hS:<\u0017AB2p]\u001aLw\r\u0005\u0002,[5\tAF\u0003\u0002*G%\u0011a\u0006\f\u0002\u0007\u0007>tg-[4\u0002\u0017\u0005,H\u000f['b]\u0006<WM\u001d\t\u0003cUj\u0011A\r\u0006\u0003!MR!\u0001N\t\u0002\u0011M,7-\u001e:jifL!A\u000e\u001a\u0003\u0017\u0005+H\u000f['b]\u0006<WM]\u0001\u001baJ|7-Z:tS:<G+\u001f9f\t\u0006$\u0018MU3m_\u0006$WM\u001d\t\u0003s\u0001k\u0011A\u000f\u0006\u0003wq\n\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0003{y\na\u0002\u001d:pG\u0016\u001c8/\u001b8hif\u0004XM\u0003\u0002@#\u00059\u0001O]8dKN\u001c\u0018BA!;\u0005\u0011\u0012V\r\\8bI\u0006\u0014G.\u001a)s_\u000e,7o]5oORK\b/\u001a#bi\u0006\u0004&o\u001c<jI\u0016\u0014\u0018aD7pI\u0016d')^5mI&sgm\\:1\u0005\u0011K\u0006\u0003B\u001dF\u000f^K!A\u0012\u001e\u00035A\u0013xnY3tg&tw\rV=qK\u0012\u000bG/\u0019)s_ZLG-\u001a:\u0011\t!\u000bF\u000b\u0016\b\u0003\u0013>\u0003\"AS'\u000e\u0003-S!\u0001T\r\u0002\rq\u0012xn\u001c;?\u0015\u0005q\u0015!B:dC2\f\u0017B\u0001)N\u0003\u0019\u0001&/\u001a3fM&\u0011!k\u0015\u0002\u0004\u001b\u0006\u0004(B\u0001)N!\tAU+\u0003\u0002W'\n11\u000b\u001e:j]\u001e\u0004\"\u0001W-\r\u0001\u0011I!\fBA\u0001\u0002\u0003\u0015\ta\u0017\u0002\u0004?\u0012\n\u0014C\u0001/a!\tif,D\u0001N\u0013\tyVJA\u0004O_RD\u0017N\\4\u0011\u0005u\u000b\u0017B\u00012N\u0005\r\te._\u0001\u000bG\u0006$XmZ8sS\u0016\u001c\bGA3h!\u0011IT\t\u00164\u0011\u0005a;G!\u00035\u0006\u0003\u0003\u0005\tQ!\u0001\\\u0005\ryFEM\u0001\u000faJ|7-Z:t'\u0016\u0014h/[2f!\tYG.D\u0001?\u0013\tigH\u0001\bQe>\u001cWm]:TKJ4\u0018nY3\u0002%MDw.\u001e7e\u000bb\u0004xn]3D_:4\u0017n\u001a\t\u0003;BL!!]'\u0003\u000f\t{w\u000e\\3b]\u0006\u0011Qm\u0019\t\u0003i^l\u0011!\u001e\u0006\u0003mF\tA!\u001e;jY&\u0011\u00010\u001e\u0002\u001e\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR<\u0016\u000e\u001e5J\u001fJ+h\u000e^5nK\u00061A(\u001b8jiz\"Rb\u001f@\u0000\u0003\u0003\t\u0019!!\u0004\u0002\u0018\u0005eAC\u0001?~!\ta\u0002\u0001C\u0003s\u0013\u0001\u000f1\u000fC\u0003*\u0013\u0001\u0007!\u0006C\u00030\u0013\u0001\u0007\u0001\u0007C\u00038\u0013\u0001\u0007\u0001\b\u0003\u0004C\u0013\u0001\u0007\u0011Q\u0001\u0019\u0005\u0003\u000f\tY\u0001E\u0003:\u000b\u001e\u000bI\u0001E\u0002Y\u0003\u0017!!BWA\u0002\u0003\u0003\u0005\tQ!\u0001\\\u0011\u0019\u0019\u0017\u00021\u0001\u0002\u0010A\"\u0011\u0011CA\u000b!\u0015IT\tVA\n!\rA\u0016Q\u0003\u0003\u000bQ\u00065\u0011\u0011!A\u0001\u0006\u0003Y\u0006\"B5\n\u0001\u0004Q\u0007\"\u00028\n\u0001\u0004y\u0017aD1qa\u0006\u0003\u0018.\u00128ea>Lg\u000e^:\u0016\u0005\u0005}\u0001\u0003BA\u0011\u0003Oi!!a\t\u000b\u0007\u0005\u0015r\"A\u0006eKN\u001c'/\u001b9uS>t\u0017\u0002BA\u0015\u0003G\u0011q\"\u00119q\u0003BLWI\u001c3q_&tGo]\u0001\u0011CB\u0004\u0018\t]5F]\u0012\u0004x.\u001b8ug\u0002\n\u0011\u0004\u001d:pE2,Wn\u0015;bi\u0016\u0014\u0015\u0010\u0015:pG\u0016\u001c8OT1nKR!\u0011\u0011GA.!\u0019\t\u0019$!\u000f\u0002>5\u0011\u0011Q\u0007\u0006\u0004\u0003oi\u0015AC2p]\u000e,(O]3oi&!\u00111HA\u001b\u0005\u00191U\u000f^;sKB1\u0001*UA \u0003\u001f\u0002B!!\u0011\u0002L5\u0011\u00111\t\u0006\u0004\u007f\u0005\u0015#b\u0001\t\u0002H)\u0019\u0011\u0011J\n\u0002\r\u0015tw-\u001b8f\u0013\u0011\ti%a\u0011\u0003\u0017A\u0013xnY3tg:\u000bW.\u001a\t\u0005\u0003#\n9&\u0004\u0002\u0002T)!\u0011QKA#\u0003)!W\r\u001d7ps6,g\u000e^\u0005\u0005\u00033\n\u0019F\u0001\u0007Qe>\u001cWm]:Ti\u0006$X\rC\u0004\u0002^1\u0001\u001d!a\u0018\u0002\tU\u001cXM\u001d\t\u0004c\u0005\u0005\u0014bAA2e\tQAj\\4hK\u0012,6/\u001a:\u0002;A\u0014xnY3tg\u0016\u001cx+\u001b;i-\u0006d\u0017\u000eZ1uS>tWI\u001d:peN$B!!\u001b\u0002~A1\u00111GA\u001d\u0003W\u0002R!!\u001c\u0002xQsA!a\u001c\u0002t9\u0019!*!\u001d\n\u00039K1!!\u001eN\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u001f\u0002|\t!A*[:u\u0015\r\t)(\u0014\u0005\b\u0003;j\u00019AA0\u0001")
public class AppApiHttpService
extends BaseHttpService
implements LazyLogging {
    private final Config config;
    private final ReloadableProcessingTypeDataProvider processingTypeDataReloader;
    private final ProcessingTypeDataProvider<Map<String, String>, ?> modelBuildInfos;
    private final ProcessingTypeDataProvider<String, ?> categories;
    private final ProcessService processService;
    private final boolean shouldExposeConfig;
    private final ExecutionContextWithIORuntime ec;
    private final AppApiEndpoints appApiEndpoints;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        AppApiHttpService appApiHttpService = this;
        synchronized (appApiHttpService) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private AppApiEndpoints appApiEndpoints() {
        return this.appApiEndpoints;
    }

    private Future<Map<ProcessName, ProcessState>> problemStateByProcessName(LoggedUser user) {
        boolean x$1 = true;
        ProcessService.ScenarioGraphOptions x$2 = ProcessService$GetScenarioWithDetailsOptions$.MODULE$.detailsOnly().copy$default$1();
        return this.processService.getLatestProcessesWithDetails(ScenarioQuery$.MODULE$.deployed(), ProcessService$GetScenarioWithDetailsOptions$.MODULE$.detailsOnly().copy(x$2, true), user).map((Function1 & Serializable)processes -> {
            Map statusMap = processes.flatMap((Function1 & Serializable)process -> process.state().map((Function1 & Serializable)x$12 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)process.name()), x$12))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            Map withProblem = (Map)statusMap.collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Tuple2<ProcessName, ProcessState>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 != null) {
                        StateStatus stateStatus;
                        ProcessName name = (ProcessName)A1._1();
                        ProcessState processStatus = (ProcessState)A1._2();
                        if (processStatus != null && (stateStatus = processStatus.status()) instanceof SimpleStateStatus.ProblemStateStatus) {
                            return (B1)new Tuple2((Object)name, (Object)processStatus);
                        }
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Tuple2<ProcessName, ProcessState> x1) {
                    StateStatus stateStatus;
                    ProcessState processStatus;
                    Tuple2<ProcessName, ProcessState> tuple2 = x1;
                    return tuple2 != null && (processStatus = (ProcessState)tuple2._2()) != null && (stateStatus = processStatus.status()) instanceof SimpleStateStatus.ProblemStateStatus;
                }
            });
            return new Tuple3(processes, (Object)statusMap, (Object)withProblem);
        }, (ExecutionContext)this.ec).map((Function1 & Serializable)x$13 -> {
            Tuple3 tuple3 = x$13;
            if (tuple3 != null) {
                Map withProblem = (Map)tuple3._3();
                return withProblem;
            }
            throw new MatchError((Object)tuple3);
        }, (ExecutionContext)this.ec);
    }

    private Future<List<String>> processesWithValidationErrors(LoggedUser user) {
        return this.processService.getLatestProcessesWithDetails(ScenarioQuery$.MODULE$.unarchivedProcesses(), ProcessService$GetScenarioWithDetailsOptions$.MODULE$.withsScenarioGraph().withValidation(), user).map((Function1 & Serializable)processes -> processes.filterNot((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)AppApiHttpService.$anonfun$processesWithValidationErrors$2(x$14))).map((Function1 & Serializable)x$15 -> x$15.name().value()), (ExecutionContext)this.ec);
    }

    public static final /* synthetic */ boolean $anonfun$processesWithValidationErrors$2(ScenarioWithDetails x$14) {
        return x$14.validationResultUnsafe().errors().isEmpty();
    }

    public AppApiHttpService(Config config, AuthManager authManager, ReloadableProcessingTypeDataProvider processingTypeDataReloader, ProcessingTypeDataProvider<Map<String, String>, ?> modelBuildInfos, ProcessingTypeDataProvider<String, ?> categories, ProcessService processService, boolean shouldExposeConfig, ExecutionContextWithIORuntime ec) {
        this.config = config;
        this.processingTypeDataReloader = processingTypeDataReloader;
        this.modelBuildInfos = modelBuildInfos;
        this.categories = categories;
        this.processService = processService;
        this.shouldExposeConfig = shouldExposeConfig;
        this.ec = ec;
        super(authManager, ec);
        LazyLogging.$init$((LazyLogging)this);
        this.appApiEndpoints = new AppApiEndpoints((EndpointInput<AuthCredentials>)authManager.authenticationEndpointInput());
        this.expose((ServerEndpoint<Object, Future>)this.appApiEndpoints().appHealthCheckEndpoint().serverLogicSuccess((Function1 & Serializable)x$1 -> Future$.MODULE$.successful((Object)AppApiEndpoints$Dtos$HealthCheckProcessSuccessResponseDto$.MODULE$.apply()), $less$colon$less$.MODULE$.refl()));
        this.expose((ServerEndpoint<Object, Future>)this.appApiEndpoints().processDeploymentHealthCheckEndpoint().serverSecurityLogic((Function1 & Serializable)credentials -> this.authorizeKnownUser((AuthCredentials)credentials)).serverLogic((Function1 & Serializable)loggedUser -> (Function1 & Serializable)x$2 -> this.problemStateByProcessName((LoggedUser)loggedUser).map((Function1 & Serializable)set -> {
            BoxedUnit boxedUnit;
            if (set.isEmpty()) {
                return this.success(AppApiEndpoints$Dtos$HealthCheckProcessSuccessResponseDto$.MODULE$.apply());
            }
            if (this.logger().underlying().isDebugEnabled()) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Scenarios with status PROBLEM: {}", set);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Scenarios with status PROBLEM: {}", (Object)set.keys());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return this.businessError(AppApiEndpoints$Dtos$HealthCheckProcessErrorResponseDto$.MODULE$.apply((Option<String>)new Some((Object)"Scenarios with status PROBLEM"), (Option<Set<String>>)new Some((Object)((IterableOnceOps)set.keys().map((Function1 & Serializable)x$3 -> x$3.value())).toSet())));
        }, (ExecutionContext)$this.ec).recover((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ AppApiHttpService $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Option option;
                A1 A1 = x1;
                if (A1 != null && !(option = NonFatal$.MODULE$.unapply(A1)).isEmpty()) {
                    BoxedUnit boxedUnit;
                    Throwable e = (Throwable)option.get();
                    if (this.$outer.logger().underlying().isErrorEnabled()) {
                        this.$outer.logger().underlying().error("Failed to get statuses", e);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return (B1)this.$outer.businessError(AppApiEndpoints$Dtos$HealthCheckProcessErrorResponseDto$.MODULE$.apply((Option<String>)new Some((Object)"Failed to retrieve job statuses"), (Option<Set<String>>)None$.MODULE$));
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Option option;
                Throwable throwable = x1;
                return throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (ExecutionContext)$this.ec)));
        this.expose((ServerEndpoint<Object, Future>)this.appApiEndpoints().processValidationHealthCheckEndpoint().serverSecurityLogic((Function1 & Serializable)credentials -> this.authorizeKnownUser((AuthCredentials)credentials)).serverLogic((Function1 & Serializable)loggedUser -> (Function1 & Serializable)x$4 -> this.processesWithValidationErrors((LoggedUser)loggedUser).map((Function1 & Serializable)processes -> {
            if (processes.isEmpty()) {
                return this.success(AppApiEndpoints$Dtos$HealthCheckProcessSuccessResponseDto$.MODULE$.apply());
            }
            return this.businessError(AppApiEndpoints$Dtos$HealthCheckProcessErrorResponseDto$.MODULE$.apply((Option<String>)new Some((Object)"Scenarios with validation errors"), (Option<Set<String>>)new Some((Object)processes.toSet())));
        }, (ExecutionContext)$this.ec)));
        this.expose((ServerEndpoint<Object, Future>)this.appApiEndpoints().buildInfoEndpoint().serverLogicSuccess((Function1 & Serializable)x$5 -> Future$.MODULE$.apply((Function0 & Serializable)() -> {
            Option configuredBuildInfo = Ficus$.MODULE$.toFicusConfig($this.config).getAs("globalBuildInfo", Ficus$.MODULE$.optionValueReader(Ficus$.MODULE$.mapValueReader(Ficus$.MODULE$.stringValueReader())));
            Map<String, Map<String, String>> modelBuildInfo = $this.modelBuildInfos.all((LoggedUser)NussknackerInternalUser$.MODULE$.instance());
            return new AppApiEndpoints.Dtos.BuildInfoDto(BuildInfo$.MODULE$.name(), BuildInfo$.MODULE$.gitCommit(), BuildInfo$.MODULE$.buildTime(), BuildInfo$.MODULE$.version(), modelBuildInfo, (Option<Map<String, String>>)configuredBuildInfo);
        }, (ExecutionContext)$this.ec), $less$colon$less$.MODULE$.refl()));
        this.expose((Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> $this.shouldExposeConfig, (ServerEndpoint<Object, Future>)this.appApiEndpoints().serverConfigEndpoint().serverSecurityLogic((Function1 & Serializable)credentials -> this.authorizeAdminUser((AuthCredentials)credentials)).serverLogic((Function1 & Serializable)x$6 -> (Function1 & Serializable)x$7 -> Future$.MODULE$.apply((Function0 & Serializable)() -> {
            Either configJson = package$.MODULE$.parse($this.config.root().render(ConfigRenderOptions.concise())).left().map((Function1 & Serializable)x$8 -> x$8.message());
            Either either = configJson;
            if (either instanceof Right) {
                Right right = (Right)either;
                Json json = (Json)right.value();
                return this.success(new AppApiEndpoints.Dtos.ServerConfigInfoDto(json));
            }
            if (either instanceof Left) {
                BoxedUnit boxedUnit;
                Left left = (Left)either;
                String errorMessage = (String)left.value();
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Cannot create JSON from the Nussknacker configuration. Error: {}", (Object)errorMessage);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                throw new Exception("Cannot prepare configuration");
            }
            throw new MatchError((Object)either);
        }, (ExecutionContext)$this.ec)));
        this.expose((ServerEndpoint<Object, Future>)this.appApiEndpoints().userCategoriesWithProcessingTypesEndpoint().serverSecurityLogic((Function1 & Serializable)credentials -> this.authorizeKnownUser((AuthCredentials)credentials)).serverLogicSuccess((Function1 & Serializable)loggedUser -> (Function1 & Serializable)x$9 -> Future$.MODULE$.apply((Function0 & Serializable)() -> {
            Map processingTypeByCategory = Implicits$.MODULE$.RichTupleList($this.categories.all((LoggedUser)loggedUser).toList().map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String processingType = (String)tuple2._1();
                    String category = (String)tuple2._2();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)category), (Object)processingType);
                }
                throw new MatchError((Object)tuple2);
            })).toMapCheckingDuplicates();
            return AppApiEndpoints$Dtos$UserCategoriesWithProcessingTypesDto$.MODULE$.apply((Map<String, String>)processingTypeByCategory);
        }, (ExecutionContext)$this.ec)));
        this.expose((ServerEndpoint<Object, Future>)this.appApiEndpoints().processingTypeDataReloadEndpoint().serverSecurityLogic((Function1 & Serializable)credentials -> this.authorizeAdminUser((AuthCredentials)credentials)).serverLogicSuccess((Function1 & Serializable)x$10 -> (Function1 & Serializable)x$11 -> $this.processingTypeDataReloader.reloadAll().unsafeToFuture($this.ec.ioRuntime())));
    }
}

