/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.statistics;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import pl.touk.nussknacker.ui.statistics.CannotEncryptURLError$;
import pl.touk.nussknacker.ui.statistics.EncryptionResult;
import pl.touk.nussknacker.ui.statistics.EncryptionType$;
import pl.touk.nussknacker.ui.statistics.PublicEncryptionKey;
import pl.touk.nussknacker.ui.statistics.StatisticError;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Try;
import scala.util.Try$;

public final class Encryption$
implements LazyLogging {
    public static final Encryption$ MODULE$ = new Encryption$();
    private static SecretKey privateSymmetricKey;
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;
    private static volatile boolean bitmap$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
    }

    private Logger logger$lzycompute() {
        Encryption$ encryption$ = this;
        synchronized (encryption$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    private SecretKey privateSymmetricKey$lzycompute() {
        Encryption$ encryption$ = this;
        synchronized (encryption$) {
            if (!bitmap$0) {
                privateSymmetricKey = this.createSymmetricKey();
                bitmap$0 = true;
            }
        }
        return privateSymmetricKey;
    }

    private SecretKey privateSymmetricKey() {
        if (!bitmap$0) {
            return this.privateSymmetricKey$lzycompute();
        }
        return privateSymmetricKey;
    }

    public Either<StatisticError, EncryptionResult> encrypt(PublicEncryptionKey asymmetricPublicKey, String toEncode) {
        Try result = this.cipherAndEncode(toEncode.getBytes(StandardCharsets.UTF_8), (Enumeration.Value)EncryptionType$.MODULE$.AES(), this.privateSymmetricKey()).flatMap((Function1 & Serializable)encryptedBySymmetricKey -> MODULE$.cipherAndEncode(MODULE$.privateSymmetricKey().getEncoded(), (Enumeration.Value)EncryptionType$.MODULE$.RSA(), asymmetricPublicKey.key()).map((Function1 & Serializable)encryptedSymmetricKeyWithPublicRSA -> new EncryptionResult((String)encryptedSymmetricKeyWithPublicRSA, (String)encryptedBySymmetricKey)));
        return result.toEither().left().map((Function1 & Serializable)t -> {
            BoxedUnit boxedUnit;
            if (MODULE$.logger().underlying().isWarnEnabled()) {
                MODULE$.logger().underlying().warn("Encryption failed with exception", t);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return CannotEncryptURLError$.MODULE$;
        });
    }

    private Try<String> cipherAndEncode(byte[] toEncode, Enumeration.Value encryptionType, Key key) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            Cipher cipher = Cipher.getInstance(EncryptionType$.MODULE$.valueToEncryptionTypeVal(encryptionType).encryption());
            cipher.init(1, key);
            byte[] encoded = cipher.doFinal(toEncode);
            return Base64.getEncoder().encodeToString(encoded);
        });
    }

    public SecretKey createSymmetricKey() {
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
        keyGenerator.init(256);
        return keyGenerator.generateKey();
    }

    private Encryption$() {
    }
}

