/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.statistics;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import pl.touk.nussknacker.ui.config.UsageStatisticsReportsConfig;
import pl.touk.nussknacker.ui.db.DBIOActionExtensions;
import pl.touk.nussknacker.ui.process.repository.DBIOActionRunner;
import pl.touk.nussknacker.ui.statistics.CannotGenerateStatisticsError$;
import pl.touk.nussknacker.ui.statistics.Fingerprint;
import pl.touk.nussknacker.ui.statistics.StatisticError;
import pl.touk.nussknacker.ui.statistics.repository.FingerprintRepository;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Random$;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import slick.dbio.DBIOAction;
import slick.dbio.Effect;
import slick.dbio.NoStream;

@ScalaSignature(bytes="\u0006\u0005\u0005Mb\u0001\u0002\u0007\u000e\u0001aA\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005\u0011\"AA\n\u0001B\u0001B\u0003-Q\n\u0003\u0005T\u0001\t\u0005\t\u0015a\u0003U\u0011\u0015Y\u0006\u0001\"\u0001]\u0011\u0015Y\u0006\u0001\"\u0001d\u0011\u0015A\u0007\u0001\"\u0001j\u0011\u001d\t9\u0001\u0001C\u0005\u0003\u0013Aq!!\u0004\u0001\t\u0013\ty\u0001C\u0004\u0002\u001a\u0001!I!a\u0007\t\u000f\u0005=\u0002\u0001\"\u0003\u00022\t\u0011b)\u001b8hKJ\u0004(/\u001b8u'\u0016\u0014h/[2f\u0015\tqq\"\u0001\u0006ti\u0006$\u0018n\u001d;jGNT!\u0001E\t\u0002\u0005UL'B\u0001\n\u0014\u0003-qWo]:l]\u0006\u001c7.\u001a:\u000b\u0005Q)\u0012\u0001\u0002;pk.T\u0011AF\u0001\u0003a2\u001c\u0001a\u0005\u0003\u00013}I\u0003C\u0001\u000e\u001e\u001b\u0005Y\"\"\u0001\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yY\"AB!osJ+g\r\u0005\u0002!O5\t\u0011E\u0003\u0002#G\u0005a1oY1mC2|wmZ5oO*\u0011A%J\u0001\tif\u0004Xm]1gK*\ta%A\u0002d_6L!\u0001K\u0011\u0003\u00171\u000b'0\u001f'pO\u001eLgn\u001a\t\u0003U5j\u0011a\u000b\u0006\u0003Y=\t!\u0001\u001a2\n\u00059Z#\u0001\u0006#C\u0013>\u000b5\r^5p]\u0016CH/\u001a8tS>t7/A\u000bgS:<WM\u001d9sS:$(+\u001a9pg&$xN]=\u0011\u0007E\"d'D\u00013\u0015\t\u0019T\"\u0001\u0006sKB|7/\u001b;pefL!!\u000e\u001a\u0003+\u0019KgnZ3saJLg\u000e\u001e*fa>\u001c\u0018\u000e^8ssB\u0011q\u0007\u0012\b\u0003q\u0005s!!\u000f \u000f\u0005ijT\"A\u001e\u000b\u0005q:\u0012A\u0002\u001fs_>$h(C\u0001-\u0013\ty\u0004)\u0001\u0003vi&d'\"\u0001\u0017\n\u0005\t\u001b\u0015a\u0005#C\u0013>\u000b5\r^5p]&s7\u000f^1oG\u0016\u001c(BA A\u0013\t)eI\u0001\u0002E\u0005*\u0011!iQ\u0001\u0014M&tw-\u001a:qe&tGOR5mK:\u000bW.\u001a\t\u0003\u0013*k\u0011!D\u0005\u0003\u00176\u0011\u0001BR5mK:\u000bW.Z\u0001\u0003K\u000e\u0004\"AT)\u000e\u0003=S!\u0001U\u000e\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002S\u001f\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u000bI\nLwNU;o]\u0016\u0014\bCA+Z\u001b\u00051&BA\u001aX\u0015\tAv\"A\u0004qe>\u001cWm]:\n\u0005i3&\u0001\u0005#C\u0013>\u000b5\r^5p]J+hN\\3s\u0003\u0019a\u0014N\\5u}Q\u0019Q,\u00192\u0015\u0007y{\u0006\r\u0005\u0002J\u0001!)A*\u0002a\u0002\u001b\")1+\u0002a\u0002)\")q&\u0002a\u0001a!)q)\u0002a\u0001\u0011R\u0011Am\u001a\u000b\u0004=\u00164\u0007\"\u0002'\u0007\u0001\bi\u0005\"B*\u0007\u0001\b!\u0006\"B\u0018\u0007\u0001\u0004\u0001\u0014a\u00034j]\u001e,'\u000f\u001d:j]R$\"A\u001b?\u0011\u00079[W.\u0003\u0002m\u001f\n1a)\u001e;ve\u0016\u0004BA\\:ws:\u0011q.\u001d\b\u0003uAL\u0011\u0001H\u0005\u0003en\tq\u0001]1dW\u0006<W-\u0003\u0002uk\n1Q)\u001b;iKJT!A]\u000e\u0011\u0005%;\u0018B\u0001=\u000e\u00059\u0019F/\u0019;jgRL7-\u0012:s_J\u0004\"!\u0013>\n\u0005ml!a\u0003$j]\u001e,'\u000f\u001d:j]RDQ!`\u0004A\u0002y\faaY8oM&<\u0007cA@\u0002\u00045\u0011\u0011\u0011\u0001\u0006\u0003{>IA!!\u0002\u0002\u0002\taRk]1hKN#\u0018\r^5ti&\u001c7OU3q_J$8oQ8oM&<\u0017a\u00044fi\u000eDwJ]$f]\u0016\u0014\u0018\r^3\u0015\u0007)\fY\u0001C\u0003H\u0011\u0001\u0007\u0001*A\fsK\u0006$g)\u001b8hKJ\u0004(/\u001b8u\rJ|WNR5mKR!\u0011\u0011CA\f!\u0011Q\u00121C=\n\u0007\u0005U1D\u0001\u0004PaRLwN\u001c\u0005\u0006\u000f&\u0001\r\u0001S\u0001\u0010M&tw-\u001a:qe&tGOR5mKR!\u0011QDA\u0017!\u0011\ty\"!\u000b\u000e\u0005\u0005\u0005\"\u0002BA\u0012\u0003K\t!![8\u000b\u0005\u0005\u001d\u0012\u0001\u00026bm\u0006LA!a\u000b\u0002\"\t!a)\u001b7f\u0011\u00159%\u00021\u0001I\u0003E\u0011\u0018M\u001c3p[\u001aKgnZ3saJLg\u000e^\u000b\u0002s\u0002")
public class FingerprintService
implements LazyLogging,
DBIOActionExtensions {
    private final FingerprintRepository<DBIOAction> fingerprintRepository;
    private final String fingerprintFileName;
    private final ExecutionContext ec;
    private final DBIOActionRunner dbioRunner;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public <T> DBIOActionExtensions.RunExtension<T> RunExtension(DBIOAction<T, NoStream, Effect.All> action) {
        return DBIOActionExtensions.RunExtension$(this, action);
    }

    private Logger logger$lzycompute() {
        FingerprintService fingerprintService = this;
        synchronized (fingerprintService) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public Future<Either<StatisticError, Fingerprint>> fingerprint(UsageStatisticsReportsConfig config) {
        Option option = config.fingerprint().filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isBlank()));
        if (option instanceof Some) {
            Some some = (Some)option;
            String fingerprintFromConfig = (String)some.value();
            return Future$.MODULE$.successful((Object)package$.MODULE$.Right().apply((Object)new Fingerprint(fingerprintFromConfig)));
        }
        if (None$.MODULE$.equals(option)) {
            return this.fetchOrGenerate(this.fingerprintFileName);
        }
        throw new MatchError((Object)option);
    }

    private Future<Either<StatisticError, Fingerprint>> fetchOrGenerate(String fingerprintFileName) {
        return this.RunExtension(this.fingerprintRepository.read()).run(this.dbioRunner).flatMap((Function1 & Serializable)dbFingerprint -> {
            Future future;
            Option option = dbFingerprint;
            if (option instanceof Some) {
                Some some = (Some)option;
                String dbValue = ((Fingerprint)some.value()).value();
                future = Future$.MODULE$.successful((Object)package$.MODULE$.Right().apply((Object)new Fingerprint(dbValue)));
            } else if (None$.MODULE$.equals(option)) {
                String generated = ((Fingerprint)this.readFingerprintFromFile(fingerprintFileName).getOrElse((Function0 & Serializable)() -> new Fingerprint(this.randomFingerprint()))).value();
                future = this.RunExtension($this.fingerprintRepository.readOrSave(generated).map((Function1 & Serializable)x0$1 -> {
                    Either either = x0$1;
                    if (either instanceof Left) {
                        BoxedUnit boxedUnit;
                        if (this.logger().underlying().isWarnEnabled()) {
                            this.logger().underlying().warn("Cannot persist fingerprint in DB");
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        return package$.MODULE$.Left().apply((Object)CannotGenerateStatisticsError$.MODULE$);
                    }
                    if (either instanceof Right) {
                        BoxedUnit boxedUnit;
                        Right right = (Right)either;
                        String fingerprint = ((Fingerprint)right.value()).value();
                        if (this.logger().underlying().isDebugEnabled()) {
                            this.logger().underlying().debug("Saved fingerprint {}", (Object)fingerprint);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        return package$.MODULE$.Right().apply((Object)new Fingerprint(fingerprint));
                    }
                    throw new MatchError((Object)either);
                }, $this.ec)).runInTransaction($this.dbioRunner);
            } else {
                throw new MatchError((Object)option);
            }
            return future.map((Function1 & Serializable)result -> result, $this.ec);
        }, this.ec);
    }

    private Option<Fingerprint> readFingerprintFromFile(String fingerprintFileName) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> FileUtils.readFileToString((File)this.fingerprintFile(fingerprintFileName), (Charset)StandardCharsets.UTF_8));
        if (try_ instanceof Failure) {
            return None$.MODULE$;
        }
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            String value = (String)success.value();
            return new Some((Object)new Fingerprint(value.trim()));
        }
        throw new MatchError((Object)try_);
    }

    private File fingerprintFile(String fingerprintFileName) {
        return new File((String)Try$.MODULE$.apply((Function0 & Serializable)() -> Option$.MODULE$.apply((Object)System.getProperty("java.io.tmpdir"))).toOption().flatten((.less.colon.less)$less$colon$less$.MODULE$.refl()).getOrElse((Function0 & Serializable)() -> "/tmp"), fingerprintFileName);
    }

    private String randomFingerprint() {
        return "gen-" + Random$.MODULE$.alphanumeric().take(10).mkString();
    }

    public FingerprintService(FingerprintRepository<DBIOAction> fingerprintRepository, String fingerprintFileName, ExecutionContext ec, DBIOActionRunner dbioRunner) {
        this.fingerprintRepository = fingerprintRepository;
        this.fingerprintFileName = fingerprintFileName;
        this.ec = ec;
        this.dbioRunner = dbioRunner;
        LazyLogging.$init$((LazyLogging)this);
        DBIOActionExtensions.$init$(this);
    }

    public FingerprintService(FingerprintRepository<DBIOAction> fingerprintRepository, ExecutionContext ec, DBIOActionRunner dbioRunner) {
        this(fingerprintRepository, "nussknacker.fingerprint", ec, dbioRunner);
    }
}

