/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.process.repository;

import cats.Monad;
import cats.data.OptionT;
import cats.data.OptionT$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import db.util.DBIOActionInstances$;
import java.io.Serializable;
import java.time.Instant;
import pl.touk.nussknacker.engine.api.deployment.ProcessAction;
import pl.touk.nussknacker.engine.api.deployment.ProcessActionState$;
import pl.touk.nussknacker.engine.api.deployment.ScenarioActionName;
import pl.touk.nussknacker.engine.api.deployment.ScenarioActionName$;
import pl.touk.nussknacker.engine.api.graph.ScenarioGraph;
import pl.touk.nussknacker.engine.api.process.ProcessId;
import pl.touk.nussknacker.engine.api.process.ProcessIdWithName;
import pl.touk.nussknacker.engine.api.process.ProcessName;
import pl.touk.nussknacker.engine.api.process.ScenarioVersion;
import pl.touk.nussknacker.engine.api.process.VersionId;
import pl.touk.nussknacker.engine.canonicalgraph.CanonicalProcess;
import pl.touk.nussknacker.restmodel.component.ScenarioComponentsUsages;
import pl.touk.nussknacker.ui.db.DbRef;
import pl.touk.nussknacker.ui.db.entity.ProcessEntityData;
import pl.touk.nussknacker.ui.db.entity.ProcessEntityFactory;
import pl.touk.nussknacker.ui.db.entity.ProcessVersionEntityData;
import pl.touk.nussknacker.ui.process.ScenarioQuery;
import pl.touk.nussknacker.ui.process.label.ScenarioLabel;
import pl.touk.nussknacker.ui.process.marshall.CanonicalProcessConverter$;
import pl.touk.nussknacker.ui.process.repository.DBFetchingProcessRepository$;
import pl.touk.nussknacker.ui.process.repository.FetchingProcessRepository;
import pl.touk.nussknacker.ui.process.repository.ProcessDBQueryRepository;
import pl.touk.nussknacker.ui.process.repository.ProcessDBQueryRepository$;
import pl.touk.nussknacker.ui.process.repository.ScenarioActionRepository;
import pl.touk.nussknacker.ui.process.repository.ScenarioLabelsRepository;
import pl.touk.nussknacker.ui.process.repository.ScenarioShapeFetchStrategy;
import pl.touk.nussknacker.ui.process.repository.ScenarioShapeFetchStrategy$FetchCanonical$;
import pl.touk.nussknacker.ui.process.repository.ScenarioShapeFetchStrategy$FetchComponentsUsages$;
import pl.touk.nussknacker.ui.process.repository.ScenarioShapeFetchStrategy$FetchScenarioGraph$;
import pl.touk.nussknacker.ui.process.repository.ScenarioShapeFetchStrategy$NotFetch$;
import pl.touk.nussknacker.ui.process.repository.ScenarioWithDetailsEntity;
import pl.touk.nussknacker.ui.security.api.LoggedUser;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.LinearSeqOps;
import scala.collection.SetOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import slick.ast.BaseTypedType;
import slick.ast.TypedType;
import slick.dbio.DBIOAction;
import slick.dbio.Effect;
import slick.dbio.NoStream;
import slick.jdbc.JdbcActionComponent;
import slick.lifted.BaseColumnExtensionMethods;
import slick.lifted.BooleanColumnExtensionMethods$;
import slick.lifted.CanBeQueryCondition$;
import slick.lifted.OptionMapper2$;
import slick.lifted.Rep;
import slick.lifted.Shape$;

@ScalaSignature(bytes="\u0006\u0005\rmw!\u0002\u000e\u001c\u0011\u0003Ac!\u0002\u0016\u001c\u0011\u0003Y\u0003\"\u0002\u001a\u0002\t\u0003\u0019\u0004\"\u0002\u001b\u0002\t\u0003)\u0004bBB^\u0003\u0011\u00051Q\u0018\u0004\u0006Um\t\ta\u000f\u0005\t1\u0016\u0011)\u0019!C\t3\"A\u0001-\u0002B\u0001B\u0003%!\f\u0003\u0005b\u000b\t\u0005\t\u0015!\u0003c\u0011!)WA!A!\u0002\u00131\u0007\u0002C5\u0006\u0005\u0007\u0005\u000b1\u00026\t\u0011A,!Q1A\u0005\u0014ED\u0001\u0002_\u0003\u0003\u0002\u0003\u0006IA\u001d\u0005\u0006e\u0015!\t!\u001f\u0005\b\u0003\u0007)A\u0011IA\u0003\u0011\u001d\ti&\u0002C\u0005\u0003?Bq!!:\u0006\t\u0013\t9\u000fC\u0004\u00034\u0015!\tE!\u000e\t\u000f\tMS\u0001\"\u0011\u0003V!9!QP\u0003\u0005B\t}\u0004b\u0002BJ\u000b\u0011\u0005!Q\u0013\u0005\b\u0005C+A\u0011\tBR\u0011\u001d\u0011Y.\u0002C\u0005\u0005;Dqaa\u0005\u0006\t\u0013\u0019)\u0002C\u0004\u0004H\u0015!Ia!\u0013\t\u000f\reU\u0001\"\u0003\u0004\u001c\u0006YBI\u0011$fi\u000eD\u0017N\\4Qe>\u001cWm]:SKB|7/\u001b;pefT!\u0001H\u000f\u0002\u0015I,\u0007o\\:ji>\u0014\u0018P\u0003\u0002\u001f?\u00059\u0001O]8dKN\u001c(B\u0001\u0011\"\u0003\t)\u0018N\u0003\u0002#G\u0005Ya.^:tW:\f7m[3s\u0015\t!S%\u0001\u0003u_V\\'\"\u0001\u0014\u0002\u0005Ad7\u0001\u0001\t\u0003S\u0005i\u0011a\u0007\u0002\u001c\t\n3U\r^2iS:<\u0007K]8dKN\u001c(+\u001a9pg&$xN]=\u0014\u0005\u0005a\u0003CA\u00171\u001b\u0005q#\"A\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Er#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002Q\u000511M]3bi\u0016$rANB[\u0007o\u001bI\fF\u00028\u0007g\u0013B\u0001\u000f\u001e\u0004.\u001a!\u0011h\u0001\u00018\u00051a$/\u001a4j]\u0016lWM\u001c;?!\u0011ISaa\n\u0016\u0005q\u00125cA\u0003>\u001dB\u0019\u0011F\u0010!\n\u0005}Z\"!\u0007$fi\u000eD\u0017N\\4Qe>\u001cWm]:SKB|7/\u001b;pef\u0004\"!\u0011\"\r\u0001\u0011)1)\u0002b\u0001\t\n\ta)\u0006\u0002F\u0019F\u0011a)\u0013\t\u0003[\u001dK!\u0001\u0013\u0018\u0003\u000f9{G\u000f[5oOB\u0011QFS\u0005\u0003\u0017:\u00121!\u00118z\t\u0015i%I1\u0001F\u0005\u0011yF\u0005J\u0019\u0011\u0005=3V\"\u0001)\u000b\u0005E\u0013\u0016\u0001D:dC2\fGn\\4hS:<'BA*U\u0003!!\u0018\u0010]3tC\u001a,'\"A+\u0002\u0007\r|W.\u0003\u0002X!\nYA*\u0019>z\u0019><w-\u001b8h\u0003\u0015!'MU3g+\u0005Q\u0006CA._\u001b\u0005a&BA/ \u0003\t!'-\u0003\u0002`9\n)AI\u0019*fM\u00061AM\u0019*fM\u0002\n\u0001#Y2uS>t'+\u001a9pg&$xN]=\u0011\u0005%\u001a\u0017B\u00013\u001c\u0005a\u00196-\u001a8be&|\u0017i\u0019;j_:\u0014V\r]8tSR|'/_\u0001\u0019g\u000e,g.\u0019:j_2\u000b'-\u001a7t%\u0016\u0004xn]5u_JL\bCA\u0015h\u0013\tA7D\u0001\rTG\u0016t\u0017M]5p\u0019\u0006\u0014W\r\\:SKB|7/\u001b;pef\f!\"\u001a<jI\u0016t7-\u001a\u00132!\rYg\u000eQ\u0007\u0002Y*\tQ.\u0001\u0003dCR\u001c\u0018BA8m\u0005\u0015iuN\\1e\u0003\t)7-F\u0001s!\t\u0019h/D\u0001u\u0015\t)h&\u0001\u0006d_:\u001cWO\u001d:f]RL!a\u001e;\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\u0018aA3dAQ)!P`@\u0002\u0002Q\u00191\u0010`?\u0011\u0007%*\u0001\tC\u0003j\u001b\u0001\u000f!\u000eC\u0003q\u001b\u0001\u000f!\u000fC\u0003Y\u001b\u0001\u0007!\fC\u0003b\u001b\u0001\u0007!\rC\u0003f\u001b\u0001\u0007a-A\u000egKR\u001c\u0007\u000eT1uKN$\bK]8dKN\u001cXm\u001d#fi\u0006LGn]\u000b\u0005\u0003\u000f\ti\u0003\u0006\u0003\u0002\n\u0005EC\u0003CA\u0006\u0003c\tY$a\u0014\u0011\t\u0005\u0013\u0015Q\u0002\t\u0007\u0003\u001f\ty\"!\n\u000f\t\u0005E\u00111\u0004\b\u0005\u0003'\tI\"\u0004\u0002\u0002\u0016)\u0019\u0011qC\u0014\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0013bAA\u000f]\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0011\u0003G\u0011A\u0001T5ti*\u0019\u0011Q\u0004\u0018\u0011\u000b%\n9#a\u000b\n\u0007\u0005%2DA\rTG\u0016t\u0017M]5p/&$\b\u000eR3uC&d7/\u00128uSRL\bcA!\u0002.\u00111\u0011q\u0006\bC\u0002\u0015\u0013!\u0001U*\t\u0013\u0005Mb\"!AA\u0004\u0005U\u0012AC3wS\u0012,gnY3%eA)\u0011&a\u000e\u0002,%\u0019\u0011\u0011H\u000e\u00035M\u001bWM\\1sS>\u001c\u0006.\u00199f\r\u0016$8\r[*ue\u0006$XmZ=\t\u000f\u0005ub\u0002q\u0001\u0002@\u0005QAn\\4hK\u0012,6/\u001a:\u0011\t\u0005\u0005\u00131J\u0007\u0003\u0003\u0007RA!!\u0012\u0002H\u0005\u0019\u0011\r]5\u000b\u0007\u0005%s$\u0001\u0005tK\u000e,(/\u001b;z\u0013\u0011\ti%a\u0011\u0003\u00151{wmZ3e+N,'\u000fC\u0003q\u001d\u0001\u000f!\u000fC\u0004\u0002T9\u0001\r!!\u0016\u0002\u000bE,XM]=\u0011\t\u0005]\u0013\u0011L\u0007\u0002;%\u0019\u00111L\u000f\u0003\u001bM\u001bWM\\1sS>\fV/\u001a:z\u0003\u00192W\r^2i\u0019\u0006$Xm\u001d;Qe>\u001cWm]:EKR\f\u0017\u000e\\:CsF+XM]=BGRLwN\\\u000b\u0005\u0003C\n9\t\u0006\u0004\u0002d\u0005U\u00161\u001c\u000b\t\u0003K\nY+!-\u00024BQ\u0011qMA9\u0003\u0003\u000bI)a$\u000f\t\u0005%\u00141N\u0007\u0002\u000b%!\u0011QIA7\u0013\r\tyg\u0007\u0002\u000b%\u0016\u0004xn]5u_JL\u0018\u0002BA:\u0003k\u0012!\u0002\u0012\"J\u001f\u0006\u001bG/[8o\u0013\u0011\t9(!\u001f\u0003\u000f\u0005c\u0017.Y:fg*!\u00111PA?\u0003\u0019a\u0017N\u001a;fI*\u0011\u0011qP\u0001\u0006g2L7m\u001b\t\u0007\u0003\u001f\ty\"a!\u0011\u000b%\n9#!\"\u0011\u0007\u0005\u000b9\t\u0002\u0004\u00020=\u0011\r!\u0012\t\u0005\u0003O\nY)\u0003\u0003\u0002\u000e\u0006U$\u0001\u0003(p'R\u0014X-Y7\u0013\r\u0005E\u00151SAS\r\u0015IT\u0001AAH!\u0011\t)*a'\u000f\t\u0005\u001d\u0014qS\u0005\u0005\u00033\u000b)(\u0001\u0004FM\u001a,7\r^\u0005\u0005\u0003;\u000byJA\u0002BY2TA!!'\u0002\"*!\u00111UA?\u0003\u0011!'-[8\u0011\t\u0005U\u0015qU\u0005\u0005\u0003S\u000byJ\u0001\u0003SK\u0006$\u0007\"CAW\u001f\u0005\u0005\t9AAX\u0003))g/\u001b3f]\u000e,Ge\r\t\u0006S\u0005]\u0012Q\u0011\u0005\b\u0003{y\u00019AA \u0011\u0015\u0001x\u0002q\u0001s\u0011\u001d\t\u0019f\u0004a\u0001\u0003o\u0003r!LA]\u0003{\u000by-C\u0002\u0002<:\u0012\u0011BR;oGRLwN\\\u0019\u0011\t\u0005}\u00161\u001a\t\u0005\u0003\u0003\f9-\u0004\u0002\u0002D*\u0019\u0011Q\u0019/\u0002\r\u0015tG/\u001b;z\u0013\u0011\tI-a1\u0003)A\u0013xnY3tg\u0016sG/\u001b;z\r\u0006\u001cGo\u001c:z\u0013\u0011\ti-a2\u0003\u001bA\u0013xnY3tg\u0016sG/\u001b;z!\u0019\t9'!5\u0002V&!\u00111[A;\u0005\r\u0011V\r\u001d\t\u0004[\u0005]\u0017bAAm]\t9!i\\8mK\u0006t\u0007bBAo\u001f\u0001\u0007\u0011q\\\u0001\u000bSN$U\r\u001d7ps\u0016$\u0007#B\u0017\u0002b\u0006U\u0017bAAr]\t1q\n\u001d;j_:\f1CZ3uG\"\f5\r^5p]N|%/R7qif,B!!;\u0003(Q!\u00111\u001eB\u0015)\u0011\tiOa\b\u0011\r\u0005\u001d\u0014q^Az\u0013\u0011\t\t0!\u001e\u0003\t\u0011\u0013\u0015j\u0014\t\t\u0003k\fiPa\u0001\u0003\u00149!\u0011q_A}!\r\t\u0019BL\u0005\u0004\u0003wt\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0000\n\u0005!aA'ba*\u0019\u00111 \u0018\u0011\t\t\u0015!qB\u0007\u0003\u0005\u000fQ1A\bB\u0005\u0015\u0011\t)Ea\u0003\u000b\u0007\t5\u0011%\u0001\u0004f]\u001eLg.Z\u0005\u0005\u0005#\u00119AA\u0005Qe>\u001cWm]:JIB!!Q\u0003B\u000e\u001b\t\u00119B\u0003\u0003\u0003\u001a\t%\u0011A\u00033fa2|\u00170\\3oi&!!Q\u0004B\f\u00055\u0001&o\\2fgN\f5\r^5p]\"I!\u0011\u0005\t\u0002\u0002\u0003\u000f!1E\u0001\u000bKZLG-\u001a8dK\u0012\"\u0004#B\u0015\u00028\t\u0015\u0002cA!\u0003(\u00111\u0011q\u0006\tC\u0002\u0015C\u0001Ba\u000b\u0011\t\u0003\u0007!QF\u0001\bI>4U\r^2i!\u0015i#qFAw\u0013\r\u0011\tD\f\u0002\ty\tLh.Y7f}\u0005)c-\u001a;dQ2\u000bG/Z:u!J|7-Z:t\t\u0016$\u0018-\u001b7t\r>\u0014\bK]8dKN\u001c\u0018\nZ\u000b\u0005\u0005o\u0011\u0019\u0005\u0006\u0003\u0003:\t=C\u0003\u0003B\u001e\u0005\u000b\u0012YE!\u0014\u0011\t\u0005\u0013%Q\b\t\u0006[\u0005\u0005(q\b\t\u0006S\u0005\u001d\"\u0011\t\t\u0004\u0003\n\rCABA\u0018#\t\u0007Q\tC\u0005\u0003HE\t\t\u0011q\u0001\u0003J\u0005QQM^5eK:\u001cW\rJ\u001b\u0011\u000b%\n9D!\u0011\t\u000f\u0005u\u0012\u0003q\u0001\u0002@!)\u0001/\u0005a\u0002e\"9!\u0011K\tA\u0002\t\r\u0011AA5e\u0003a1W\r^2i!J|7-Z:t\t\u0016$\u0018-\u001b7t\r>\u0014\u0018\nZ\u000b\u0005\u0005/\u0012\u0019\u0007\u0006\u0004\u0003Z\t=$1\u000f\u000b\t\u00057\u0012)Ga\u001b\u0003nA!\u0011I\u0011B/!\u0015i\u0013\u0011\u001dB0!\u0015I\u0013q\u0005B1!\r\t%1\r\u0003\u0007\u0003_\u0011\"\u0019A#\t\u0013\t\u001d$#!AA\u0004\t%\u0014AC3wS\u0012,gnY3%mA)\u0011&a\u000e\u0003b!9\u0011Q\b\nA\u0004\u0005}\u0002\"\u00029\u0013\u0001\b\u0011\bb\u0002B9%\u0001\u0007!1A\u0001\naJ|7-Z:t\u0013\u0012DqA!\u001e\u0013\u0001\u0004\u00119(A\u0005wKJ\u001c\u0018n\u001c8JIB!!Q\u0001B=\u0013\u0011\u0011YHa\u0002\u0003\u0013Y+'o]5p]&#\u0017A\u00044fi\u000eD\u0007K]8dKN\u001c\u0018\n\u001a\u000b\u0005\u0005\u0003\u0013I\t\u0006\u0003\u0003\u0004\n\u001d\u0005\u0003B!C\u0005\u000b\u0003R!LAq\u0005\u0007AQ\u0001]\nA\u0004IDqAa#\u0014\u0001\u0004\u0011i)A\u0006qe>\u001cWm]:OC6,\u0007\u0003\u0002B\u0003\u0005\u001fKAA!%\u0003\b\tY\u0001K]8dKN\u001ch*Y7f\u0003A1W\r^2i!J|7-Z:t\u001d\u0006lW\r\u0006\u0003\u0003\u0018\n}E\u0003\u0002BM\u0005;\u0003B!\u0011\"\u0003\u001cB)Q&!9\u0003\u000e\")\u0001\u000f\u0006a\u0002e\"9!\u0011\u000f\u000bA\u0002\t\r\u0011a\u00054fi\u000eD\u0007K]8dKN\u001c\u0018N\\4UsB,G\u0003\u0002BS\u0005'$bAa*\u0003N\nE\u0007\u0003B!C\u0005S\u0003BAa+\u0003H:!!Q\u0016Bc\u001d\u0011\u0011yKa1\u000f\t\tE&\u0011\u0019\b\u0005\u0005g\u0013yL\u0004\u0003\u00036\nuf\u0002\u0002B\\\u0005wsA!a\u0005\u0003:&\ta%\u0003\u0002%K%\u0011!eI\u0005\u0004\u0005\u001b\t\u0013\u0002BA#\u0005\u0017I1A\bB\u0005\u0013\u0011\tiBa\u0002\n\t\t%'1\u001a\u0002\u000f!J|7-Z:tS:<G+\u001f9f\u0015\u0011\tiBa\u0002\t\u000f\t=W\u0003q\u0001\u0002@\u0005!Qo]3s\u0011\u0015\u0001X\u0003q\u0001s\u0011\u001d\u0011\t(\u0006a\u0001\u0005+\u0004BA!\u0002\u0003X&!!\u0011\u001cB\u0004\u0005E\u0001&o\\2fgNLEmV5uQ:\u000bW.Z\u0001+M\u0016$8\r\u001b'bi\u0016\u001cH\u000f\u0015:pG\u0016\u001c8\u000fR3uC&d7OR8s!J|7-Z:t\u0013\u0012\fV/\u001a:z+\u0011\u0011yn!\u0002\u0015\t\t\u00058\u0011\u0003\u000b\t\u0005G\u001c9a!\u0004\u0004\u0010A1!Q\u001dB}\u0005\u007ftAAa:\u0003t:!!\u0011\u001eBw\u001d\u0011\t\u0019Ba;\n\u0003uKAAa<\u0003r\u0006!Q\u000f^5m\u0015\u0005i\u0016\u0002\u0002B{\u0005o\f1\u0003\u0012\"J\u001f\u0006\u001bG/[8o\u0013:\u001cH/\u00198dKNTAAa<\u0003r&!!1 B\u007f\u0005\t!%I\u0003\u0003\u0003v\n]\b#B\u0017\u0002b\u000e\u0005\u0001#B\u0015\u0002(\r\r\u0001cA!\u0004\u0006\u00111\u0011q\u0006\fC\u0002\u0015C\u0011b!\u0003\u0017\u0003\u0003\u0005\u001daa\u0003\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$s\u0007E\u0003*\u0003o\u0019\u0019\u0001C\u0004\u0002>Y\u0001\u001d!a\u0010\t\u000bA4\u00029\u0001:\t\u000f\tEc\u00031\u0001\u0003\u0004\u0005ib-\u001a;dQB\u0013xnY3tg\u0012+G/Y5mg\u001a{'OV3sg&|g.\u0006\u0003\u0004\u0018\r5BCBB\r\u0007s\u0019\u0019\u0005\u0006\u0005\u0004\u001c\r=2QGB\u001c!!\u0019iba\t\u0004(\r%RBAB\u0010\u0015\r\u0019\t\u0003\\\u0001\u0005I\u0006$\u0018-\u0003\u0003\u0004&\r}!aB(qi&|g\u000e\u0016\t\u0005\u0005K\u0014I\u0010E\u0003*\u0003O\u0019Y\u0003E\u0002B\u0007[!a!a\f\u0018\u0005\u0004)\u0005\"CB\u0019/\u0005\u0005\t9AB\u001a\u0003))g/\u001b3f]\u000e,G\u0005\u000f\t\u0006S\u0005]21\u0006\u0005\b\u0003{9\u00029AA \u0011\u0015\u0001x\u0003q\u0001s\u0011\u001d\u0019Yd\u0006a\u0001\u0007{\ta\u0002\u001d:pG\u0016\u001c8OV3sg&|g\u000e\u0005\u0003\u0002B\u000e}\u0012\u0002BB!\u0003\u0007\u0014\u0001\u0004\u0015:pG\u0016\u001c8OV3sg&|g.\u00128uSRLH)\u0019;b\u0011\u001d\u0019)e\u0006a\u0001\u0003+\fq\"[:MCR,7\u000f\u001e,feNLwN\\\u0001\u0012GJ,\u0017\r^3Gk2dG)\u001a;bS2\u001cX\u0003BB&\u0007'\"\"c!\u0014\u0004\\\r\r4QMB6\u0007_\u001a\u0019h!\u001e\u0004\bR!1qJB+!\u0015I\u0013qEB)!\r\t51\u000b\u0003\u0007\u0003_A\"\u0019A#\t\u0013\r]\u0003$!AA\u0004\re\u0013AC3wS\u0012,gnY3%sA)\u0011&a\u000e\u0004R!1a\u0004\u0007a\u0001\u0007;\u0002B!!1\u0004`%!1\u0011MAb\u0005E\u0001&o\\2fgN,e\u000e^5us\u0012\u000bG/\u0019\u0005\b\u0007wA\u0002\u0019AB\u001f\u0011\u001d\u00199\u0007\u0007a\u0001\u0007S\na\u0002\\1ti\u0006\u001bG/[8o\t\u0006$\u0018\rE\u0003.\u0003C\u0014\u0019\u0002C\u0004\u0004na\u0001\ra!\u001b\u0002'1\f7\u000f^*uCR,\u0017i\u0019;j_:$\u0015\r^1\t\u000f\rE\u0004\u00041\u0001\u0004j\u00051B.Y:u\t\u0016\u0004Hn\\=fI\u0006\u001bG/[8o\t\u0006$\u0018\rC\u0004\u0004Fa\u0001\r!!6\t\u000f\r]\u0004\u00041\u0001\u0004z\u00051A.\u00192fYN\u0004b!a\u0004\u0002 \rm\u0004\u0003BB?\u0007\u0007k!aa \u000b\u0007\r\u0005U$A\u0003mC\n,G.\u0003\u0003\u0004\u0006\u000e}$!D*dK:\f'/[8MC\n,G\u000eC\u0004\u0004\nb\u0001\raa#\u0002\u000f!L7\u000f^8ssB)Q&!9\u0004\u000eB1\u0011qBBH\u0007'KAa!%\u0002$\t\u00191+Z9\u0011\t\t\u00151QS\u0005\u0005\u0007/\u00139AA\bTG\u0016t\u0017M]5p-\u0016\u00148/[8o\u0003Q\u0019wN\u001c<feR$v\u000eV1sO\u0016$8\u000b[1qKV!1QTBR)\u0011\u0019yja+\u0015\t\r\u00056Q\u0015\t\u0004\u0003\u000e\rFABA\u00183\t\u0007Q\tC\u0005\u0004(f\t\t\u0011q\u0001\u0004*\u0006YQM^5eK:\u001cW\rJ\u00191!\u0015I\u0013qGBQ\u0011\u001d\u0019Y$\u0007a\u0001\u0007{\u00012!KBX\u0013\r\u0019\tl\u0007\u0002\u000f\t\nLwNU3q_NLGo\u001c:z\u0011\u0015\u00018\u0001q\u0001s\u0011\u0015A6\u00011\u0001[\u0011\u0015\t7\u00011\u0001c\u0011\u0015)7\u00011\u0001g\u0003Y\u0019'/Z1uK\u001a+H/\u001e:f%\u0016\u0004xn]5u_JLH\u0003CB`\u0007+\u001c9n!7\u0015\t\r\u000571\u001b\n\u0007\u0007\u0007\u001c)m!4\u0007\u000be\"\u0001a!1\u0011\t%*1q\u0019\t\u0004g\u000e%\u0017bABfi\n1a)\u001e;ve\u0016\u00042!KBh\u0013\r\u0019\tn\u0007\u0002\u0010\u0005\u0006\u001c\u0018n\u0019*fa>\u001c\u0018\u000e^8ss\")\u0001\u000f\u0002a\u0002e\")\u0001\f\u0002a\u00015\")\u0011\r\u0002a\u0001E\")Q\r\u0002a\u0001M\u0002")
public abstract class DBFetchingProcessRepository<F>
extends FetchingProcessRepository<F>
implements LazyLogging {
    private final DbRef dbRef;
    private final ScenarioActionRepository actionRepository;
    private final ScenarioLabelsRepository scenarioLabelsRepository;
    private final ExecutionContext ec;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static DBFetchingProcessRepository<Future> createFutureRepository(DbRef dbRef, ScenarioActionRepository actionRepository, ScenarioLabelsRepository scenarioLabelsRepository, ExecutionContext ec) {
        return DBFetchingProcessRepository$.MODULE$.createFutureRepository(dbRef, actionRepository, scenarioLabelsRepository, ec);
    }

    public static DBFetchingProcessRepository<DBIOAction> create(DbRef dbRef, ScenarioActionRepository actionRepository, ScenarioLabelsRepository scenarioLabelsRepository, ExecutionContext ec) {
        return DBFetchingProcessRepository$.MODULE$.create(dbRef, actionRepository, scenarioLabelsRepository, ec);
    }

    private Logger logger$lzycompute() {
        DBFetchingProcessRepository dBFetchingProcessRepository = this;
        synchronized (dBFetchingProcessRepository) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public DbRef dbRef() {
        return this.dbRef;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    @Override
    public <PS> F fetchLatestProcessesDetails(ScenarioQuery query, ScenarioShapeFetchStrategy<PS> evidence$2, LoggedUser loggedUser, ExecutionContext ec) {
        .colon.colon expr = new .colon.colon((Object)query.isFragment().map((Function1 & Serializable)arg -> DBFetchingProcessRepository.$anonfun$fetchLatestProcessesDetails$1(this, BoxesRunTime.unboxToBoolean((Object)arg))), (List)new .colon.colon((Object)query.isArchived().map((Function1 & Serializable)arg -> DBFetchingProcessRepository.$anonfun$fetchLatestProcessesDetails$3(this, BoxesRunTime.unboxToBoolean((Object)arg))), (List)new .colon.colon((Object)query.categories().map((Function1 & Serializable)arg -> (Function1 & Serializable)process -> new BaseColumnExtensionMethods(this.api().columnExtensionMethods(process.processCategory(), (BaseTypedType)this.api().stringColumnType())).inSet((Iterable)arg, OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)this.api().stringColumnType()))), (List)new .colon.colon((Object)query.processingTypes().map((Function1 & Serializable)arg -> (Function1 & Serializable)process -> new BaseColumnExtensionMethods(this.api().columnExtensionMethods(process.processingType(), (BaseTypedType)this.api().stringColumnType())).inSet((Iterable)arg, OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)this.api().stringColumnType()))), (List)new .colon.colon((Object)query.names().map((Function1 & Serializable)arg -> (Function1 & Serializable)process -> new BaseColumnExtensionMethods(this.api().columnExtensionMethods(process.name(), this.processNameMapping())).inSet((Iterable)arg, OptionMapper2$.MODULE$.getOptionMapper2TT(this.processNameMapping()))), (List)Nil$.MODULE$)))));
        return (F)this.run().apply(this.fetchLatestProcessDetailsByQueryAction((Function1<ProcessEntityFactory.ProcessEntity, Rep<Object>>)((Function1 & Serializable)arg_0 -> DBFetchingProcessRepository.$anonfun$fetchLatestProcessesDetails$11(this, (List)expr, arg_0)), query.isDeployed(), evidence$2, loggedUser, ec));
    }

    private <PS> DBIOAction<List<ScenarioWithDetailsEntity<PS>>, NoStream, Effect.All> fetchLatestProcessDetailsByQueryAction(Function1<ProcessEntityFactory.ProcessEntity, Rep<Object>> query, Option<Object> isDeployed, ScenarioShapeFetchStrategy<PS> evidence$3, LoggedUser loggedUser, ExecutionContext ec) {
        return this.fetchActionsOrEmpty((Function0<DBIOAction<Map<ProcessId, ProcessAction>, NoStream, Effect.All>>)(Function0 & Serializable)() -> $this.actionRepository.getLastActionPerProcess((Set<Enumeration.Value>)ProcessActionState$.MODULE$.FinishedStates(), (Option<Set<ScenarioActionName>>)None$.MODULE$), evidence$3).flatMap((Function1 & Serializable)lastActionPerProcess -> this.fetchActionsOrEmpty((Function0<DBIOAction<Map<ProcessId, ProcessAction>, NoStream, Effect.All>>)(Function0 & Serializable)() -> $this.actionRepository.getLastActionPerProcess((Set<Enumeration.Value>)ProcessActionState$.MODULE$.FinishedStates(), (Option<Set<ScenarioActionName>>)new Some((Object)ScenarioActionName$.MODULE$.StateActions())), evidence$3).flatMap((Function1 & Serializable)lastStateActionPerProcess -> this.fetchActionsOrEmpty((Function0<DBIOAction<Map<ProcessId, ProcessAction>, NoStream, Effect.All>>)(Function0 & Serializable)() -> $this.actionRepository.getLastActionPerProcess((Set<Enumeration.Value>)ProcessActionState$.MODULE$.FinishedStates(), (Option<Set<ScenarioActionName>>)new Some(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new ScenarioActionName[]{new ScenarioActionName(ScenarioActionName$.MODULE$.Deploy()), new ScenarioActionName(ScenarioActionName$.MODULE$.Cancel())})))), evidence$3).map((Function1 & Serializable)x$1 -> (Map)x$1.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DBFetchingProcessRepository.$anonfun$fetchLatestProcessDetailsByQueryAction$7(x0$1))), ec).flatMap((Function1 & Serializable)lastDeployedActionPerProcess -> ((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.api().streamableQueryActionExtensionMethods(this.fetchLatestProcessesQuery(query, (Set<ProcessId>)lastDeployedActionPerProcess.keySet(), isDeployed, evidence$3, loggedUser))).result().flatMap((Function1 & Serializable)latestProcesses -> $this.scenarioLabelsRepository.getLabels().map((Function1 & Serializable)labels -> (Seq)latestProcesses.map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                ProcessEntityData process = (ProcessEntityData)tuple2._2();
                if (tuple22 != null) {
                    ProcessVersionEntityData processVersion = (ProcessVersionEntityData)tuple22._2();
                    return this.createFullDetails(process, processVersion, (Option<ProcessAction>)lastActionPerProcess.get((Object)process.id()), (Option<ProcessAction>)lastStateActionPerProcess.get((Object)process.id()), (Option<ProcessAction>)lastDeployedActionPerProcess.get((Object)process.id()), true, (List<ScenarioLabel>)((List)labels.getOrElse((Object)process.id(), (Function0 & Serializable)() -> package$.MODULE$.List().empty())), (Option<Seq<ScenarioVersion>>)None$.MODULE$, evidence$3);
                }
            }
            throw new MatchError((Object)tuple2);
        }), ec), ec), ec), ec), ec).map((Function1 & Serializable)x$2 -> x$2.toList(), ec);
    }

    private <PS> DBIOAction<Map<ProcessId, ProcessAction>, NoStream, Effect.All> fetchActionsOrEmpty(Function0<DBIOAction<Map<ProcessId, ProcessAction>, NoStream, Effect.All>> doFetch, ScenarioShapeFetchStrategy<PS> evidence$4) {
        ScenarioShapeFetchStrategy scenarioShapeFetchStrategy = (ScenarioShapeFetchStrategy)Predef$.MODULE$.implicitly(evidence$4);
        if (ScenarioShapeFetchStrategy$FetchComponentsUsages$.MODULE$.equals(scenarioShapeFetchStrategy)) {
            return this.api().DBIO().successful((Object)Predef$.MODULE$.Map().empty());
        }
        return (DBIOAction)doFetch.apply();
    }

    @Override
    public <PS> F fetchLatestProcessDetailsForProcessId(ProcessId id, ScenarioShapeFetchStrategy<PS> evidence$5, LoggedUser loggedUser, ExecutionContext ec) {
        return (F)this.run().apply(this.fetchLatestProcessDetailsForProcessIdQuery(id, evidence$5, loggedUser, ec));
    }

    @Override
    public <PS> F fetchProcessDetailsForId(ProcessId processId, VersionId versionId, ScenarioShapeFetchStrategy<PS> evidence$6, LoggedUser loggedUser, ExecutionContext ec) {
        OptionT action = new OptionT((Object)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.api().streamableQueryActionExtensionMethods(this.fetchProcessLatestVersionsQuery(processId, ScenarioShapeFetchStrategy$NotFetch$.MODULE$))).result().headOption()).flatMap((Function1 & Serializable)latestProcessVersion -> new OptionT((Object)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.api().streamableQueryActionExtensionMethods(this.fetchProcessLatestVersionsQuery(processId, evidence$6).filter((Function1 & Serializable)pv -> new BaseColumnExtensionMethods(this.api().columnExtensionMethods(pv.id(), this.versionIdMapping())).$eq$eq$eq((Rep)this.api().valueToConstColumn((Object)versionId, this.versionIdMapping()), OptionMapper2$.MODULE$.getOptionMapper2TT(this.versionIdMapping())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()))).result().headOption()).flatMap((Function1 & Serializable)processVersion -> {
            VersionId versionId = latestProcessVersion.id();
            VersionId versionId2 = processVersion.id();
            return this.fetchProcessDetailsForVersion((ProcessVersionEntityData)processVersion, !(versionId != null ? !versionId.equals(versionId2) : versionId2 != null), evidence$6, loggedUser, ec).map((Function1 & Serializable)processDetails -> processDetails, DBIOActionInstances$.MODULE$.dbMonad(ec));
        }, DBIOActionInstances$.MODULE$.dbMonad(ec)), DBIOActionInstances$.MODULE$.dbMonad(ec));
        return (F)this.run().apply(action.value());
    }

    @Override
    public F fetchProcessId(ProcessName processName, ExecutionContext ec) {
        return (F)this.run().apply((Object)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.api().streamableQueryActionExtensionMethods(this.processesTable().filter((Function1 & Serializable)x$3 -> new BaseColumnExtensionMethods(this.api().columnExtensionMethods(x$3.name(), this.processNameMapping())).$eq$eq$eq((Rep)this.api().valueToConstColumn((Object)processName, this.processNameMapping()), OptionMapper2$.MODULE$.getOptionMapper2TT(this.processNameMapping())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).map((Function1 & Serializable)x$4 -> x$4.id(), Shape$.MODULE$.repColumnShape(this.processIdMapping())))).result().headOption().map((Function1 & Serializable)x$5 -> x$5.map((Function1 & Serializable)id -> id), ec));
    }

    @Override
    public F fetchProcessName(ProcessId processId, ExecutionContext ec) {
        return (F)this.run().apply((Object)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.api().streamableQueryActionExtensionMethods(this.processesTable().filter((Function1 & Serializable)x$6 -> new BaseColumnExtensionMethods(this.api().columnExtensionMethods(x$6.id(), this.processIdMapping())).$eq$eq$eq((Rep)this.api().valueToConstColumn((Object)processId, this.processIdMapping()), OptionMapper2$.MODULE$.getOptionMapper2TT(this.processIdMapping())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).map((Function1 & Serializable)x$7 -> x$7.name(), Shape$.MODULE$.repColumnShape(this.processNameMapping())))).result().headOption());
    }

    @Override
    public F fetchProcessingType(ProcessIdWithName processId, LoggedUser user, ExecutionContext ec) {
        ScenarioShapeFetchStrategy$NotFetch$ fetchStrategy = ScenarioShapeFetchStrategy$NotFetch$.MODULE$;
        return (F)this.run().apply((Object)this.fetchLatestProcessDetailsForProcessIdQuery(processId.id(), fetchStrategy, user, ec).flatMap((Function1 & Serializable)x0$1 -> {
            Option option = x0$1;
            if (None$.MODULE$.equals(option)) {
                return this.api().DBIO().failed((Throwable)new ProcessDBQueryRepository.ProcessNotFoundError(processId.name()));
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                ScenarioWithDetailsEntity process = (ScenarioWithDetailsEntity)some.value();
                return this.api().DBIO().successful((Object)process.processingType());
            }
            throw new MatchError((Object)option);
        }, ec));
    }

    private <PS> DBIOAction<Option<ScenarioWithDetailsEntity<PS>>, NoStream, Effect.All> fetchLatestProcessDetailsForProcessIdQuery(ProcessId id, ScenarioShapeFetchStrategy<PS> evidence$7, LoggedUser loggedUser, ExecutionContext ec) {
        return (DBIOAction)new OptionT((Object)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.api().streamableQueryActionExtensionMethods(this.fetchProcessLatestVersionsQuery(id, evidence$7))).result().headOption()).flatMap((Function1 & Serializable)latestProcessVersion -> this.fetchProcessDetailsForVersion((ProcessVersionEntityData)latestProcessVersion, true, evidence$7, loggedUser, ec).map((Function1 & Serializable)processDetails -> processDetails, DBIOActionInstances$.MODULE$.dbMonad(ec)), DBIOActionInstances$.MODULE$.dbMonad(ec)).value();
    }

    private <PS> OptionT<DBIOAction, ScenarioWithDetailsEntity<PS>> fetchProcessDetailsForVersion(ProcessVersionEntityData processVersion, boolean isLatestVersion, ScenarioShapeFetchStrategy<PS> evidence$8, LoggedUser loggedUser, ExecutionContext ec) {
        ProcessId id = processVersion.processId();
        return new OptionT((Object)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.api().streamableQueryActionExtensionMethods(this.processTableFilteredByUser(loggedUser).filter((Function1 & Serializable)x$8 -> new BaseColumnExtensionMethods(this.api().columnExtensionMethods(x$8.id(), this.processIdMapping())).$eq$eq$eq((Rep)this.api().valueToConstColumn((Object)id, this.processIdMapping()), OptionMapper2$.MODULE$.getOptionMapper2TT(this.processIdMapping())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()))).result().headOption()).flatMap((Function1 & Serializable)process -> OptionT$.MODULE$.liftF((Object)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.api().streamableQueryActionExtensionMethods(this.fetchProcessLatestVersionsQuery(id, ScenarioShapeFetchStrategy$NotFetch$.MODULE$))).result(), DBIOActionInstances$.MODULE$.dbMonad(ec)).flatMap((Function1 & Serializable)processVersions -> OptionT$.MODULE$.liftF($this.actionRepository.getFinishedProcessActions(id, (Option<Set<ScenarioActionName>>)None$.MODULE$), DBIOActionInstances$.MODULE$.dbMonad(ec)).flatMap((Function1 & Serializable)actions -> OptionT$.MODULE$.liftF($this.scenarioLabelsRepository.getLabels(id), DBIOActionInstances$.MODULE$.dbMonad(ec)).map((Function1 & Serializable)labels -> this.createFullDetails((ProcessEntityData)process, processVersion, (Option<ProcessAction>)actions.headOption(), (Option<ProcessAction>)actions.find((Function1 & Serializable)a -> BoxesRunTime.boxToBoolean((boolean)DBFetchingProcessRepository.$anonfun$fetchProcessDetailsForVersion$6(a))), (Option<ProcessAction>)actions.find((Function1 & Serializable)action -> BoxesRunTime.boxToBoolean((boolean)DBFetchingProcessRepository.$anonfun$fetchProcessDetailsForVersion$7(action))).filter((Function1 & Serializable)action -> BoxesRunTime.boxToBoolean((boolean)DBFetchingProcessRepository.$anonfun$fetchProcessDetailsForVersion$8(action))), isLatestVersion, (List<ScenarioLabel>)labels, (Option<Seq<ScenarioVersion>>)new Some(processVersions.map((Function1 & Serializable)v -> ProcessDBQueryRepository$.MODULE$.toProcessVersion((ProcessVersionEntityData)v, (List<ProcessAction>)actions.filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)DBFetchingProcessRepository.$anonfun$fetchProcessDetailsForVersion$10(v, p)))))), evidence$8), DBIOActionInstances$.MODULE$.dbMonad(ec)), DBIOActionInstances$.MODULE$.dbMonad(ec)), DBIOActionInstances$.MODULE$.dbMonad(ec)), DBIOActionInstances$.MODULE$.dbMonad(ec));
    }

    private <PS> ScenarioWithDetailsEntity<PS> createFullDetails(ProcessEntityData process, ProcessVersionEntityData processVersion, Option<ProcessAction> lastActionData, Option<ProcessAction> lastStateActionData, Option<ProcessAction> lastDeployedActionData, boolean isLatestVersion, List<ScenarioLabel> labels, Option<Seq<ScenarioVersion>> history, ScenarioShapeFetchStrategy<PS> evidence$9) {
        ProcessId x$1 = process.id();
        ProcessName x$2 = process.name();
        VersionId x$3 = processVersion.id();
        boolean x$4 = isLatestVersion;
        boolean x$5 = process.isArchived();
        boolean x$6 = process.isFragment();
        Option<String> x$7 = process.description();
        String x$8 = process.processingType();
        String x$92 = process.processCategory();
        Option<ProcessAction> x$102 = lastActionData;
        Option<ProcessAction> x$11 = lastStateActionData;
        Option<ProcessAction> x$12 = lastDeployedActionData;
        List x$13 = labels.map((Function1 & Serializable)x$9 -> x$9.value());
        Instant x$14 = processVersion.createDate().toInstant();
        Instant x$15 = processVersion.createDate().toInstant();
        String x$16 = processVersion.user();
        Instant x$17 = process.createdAt().toInstant();
        String x$18 = process.createdBy();
        PS x$19 = this.convertToTargetShape(processVersion, evidence$9);
        Option x$20 = history.map((Function1 & Serializable)x$10 -> x$10.toList());
        Option<Object> x$21 = processVersion.modelVersion();
        return new ScenarioWithDetailsEntity<PS>(x$2, x$1, x$3, x$4, x$7, x$5, x$6, x$8, x$92, x$14, x$15, x$16, x$17, x$18, (List<String>)x$13, x$12, x$11, x$102, x$19, (Option<List<ScenarioVersion>>)x$20, x$21);
    }

    private <PS> PS convertToTargetShape(ProcessVersionEntityData processVersion, ScenarioShapeFetchStrategy<PS> evidence$10) {
        ScenarioShapeFetchStrategy scenarioShapeFetchStrategy;
        Tuple3 tuple3 = new Tuple3(processVersion.json(), processVersion.componentsUsages(), Predef$.MODULE$.implicitly(evidence$10));
        if (tuple3 != null) {
            Option option = (Option)tuple3._1();
            ScenarioShapeFetchStrategy scenarioShapeFetchStrategy2 = (ScenarioShapeFetchStrategy)tuple3._3();
            if (option instanceof Some) {
                Some some = (Some)option;
                CanonicalProcess canonical = (CanonicalProcess)some.value();
                if (ScenarioShapeFetchStrategy$FetchCanonical$.MODULE$.equals(scenarioShapeFetchStrategy2)) {
                    return (PS)canonical;
                }
            }
        }
        if (tuple3 != null) {
            Option option = (Option)tuple3._1();
            ScenarioShapeFetchStrategy scenarioShapeFetchStrategy3 = (ScenarioShapeFetchStrategy)tuple3._3();
            if (option instanceof Some) {
                Some some = (Some)option;
                CanonicalProcess canonical = (CanonicalProcess)some.value();
                if (ScenarioShapeFetchStrategy$FetchScenarioGraph$.MODULE$.equals(scenarioShapeFetchStrategy3)) {
                    ScenarioGraph scenarioGraph = CanonicalProcessConverter$.MODULE$.toScenarioGraph(canonical);
                    return (PS)scenarioGraph;
                }
            }
        }
        if (tuple3 != null && ScenarioShapeFetchStrategy$NotFetch$.MODULE$.equals(scenarioShapeFetchStrategy = (ScenarioShapeFetchStrategy)tuple3._3())) {
            return (PS)BoxedUnit.UNIT;
        }
        if (tuple3 != null) {
            Option option = (Option)tuple3._2();
            ScenarioShapeFetchStrategy scenarioShapeFetchStrategy4 = (ScenarioShapeFetchStrategy)tuple3._3();
            if (option instanceof Some) {
                Some some = (Some)option;
                ScenarioComponentsUsages componentsUsages = (ScenarioComponentsUsages)some.value();
                if (ScenarioShapeFetchStrategy$FetchComponentsUsages$.MODULE$.equals(scenarioShapeFetchStrategy4)) {
                    return (PS)componentsUsages;
                }
            }
        }
        if (tuple3 != null) {
            ScenarioShapeFetchStrategy strategy = (ScenarioShapeFetchStrategy)tuple3._3();
            throw new IllegalArgumentException("Missing scenario json data, it's required to convert for strategy: " + strategy + ".");
        }
        throw new MatchError((Object)tuple3);
    }

    public static final /* synthetic */ Function1 $anonfun$fetchLatestProcessesDetails$1(DBFetchingProcessRepository $this, boolean arg) {
        return (Function1 & Serializable)process -> new BaseColumnExtensionMethods($this.api().columnExtensionMethods(process.isFragment(), (BaseTypedType)$this.api().booleanColumnType())).$eq$eq$eq((Rep)$this.api().valueToConstColumn((Object)BoxesRunTime.boxToBoolean((boolean)arg), (TypedType)$this.api().booleanColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)$this.api().booleanColumnType()));
    }

    public static final /* synthetic */ Function1 $anonfun$fetchLatestProcessesDetails$3(DBFetchingProcessRepository $this, boolean arg) {
        return (Function1 & Serializable)process -> new BaseColumnExtensionMethods($this.api().columnExtensionMethods(process.isArchived(), (BaseTypedType)$this.api().booleanColumnType())).$eq$eq$eq((Rep)$this.api().valueToConstColumn((Object)BoxesRunTime.boxToBoolean((boolean)arg), (TypedType)$this.api().booleanColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)$this.api().booleanColumnType()));
    }

    public static final /* synthetic */ Rep $anonfun$fetchLatestProcessesDetails$11(DBFetchingProcessRepository $this, List expr$1, ProcessEntityFactory.ProcessEntity process) {
        return (Rep)((LinearSeqOps)expr$1.flatten(Predef$.MODULE$.$conforms())).foldLeft((Object)$this.api().valueToConstColumn((Object)BoxesRunTime.boxToBoolean((boolean)true), (TypedType)$this.api().booleanColumnType()), (Function2 & Serializable)(x, y) -> BooleanColumnExtensionMethods$.MODULE$.$amp$amp$extension($this.api().booleanColumnExtensionMethods(x), (Rep)y.apply((Object)process), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)$this.api().booleanColumnType())));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$fetchLatestProcessDetailsByQueryAction$7(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        ProcessAction action = (ProcessAction)tuple2._2();
        String string = action.actionName();
        String string2 = ScenarioActionName$.MODULE$.Deploy();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Enumeration.Value value = action.state();
        Enumeration.Value value2 = ProcessActionState$.MODULE$.Finished();
        if (value == null) {
            if (value2 == null) return true;
            return false;
        } else {
            if (!value.equals(value2)) return false;
            return true;
        }
    }

    public static final /* synthetic */ boolean $anonfun$fetchProcessDetailsForVersion$6(ProcessAction a) {
        return ScenarioActionName$.MODULE$.StateActions().contains((Object)new ScenarioActionName(a.actionName()));
    }

    public static final /* synthetic */ boolean $anonfun$fetchProcessDetailsForVersion$7(ProcessAction action) {
        return ((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new ScenarioActionName[]{new ScenarioActionName(ScenarioActionName$.MODULE$.Deploy()), new ScenarioActionName(ScenarioActionName$.MODULE$.Cancel())}))).contains((Object)new ScenarioActionName(action.actionName()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$fetchProcessDetailsForVersion$8(ProcessAction action) {
        String string = action.actionName();
        String string2 = ScenarioActionName$.MODULE$.Deploy();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Enumeration.Value value = action.state();
        Enumeration.Value value2 = ProcessActionState$.MODULE$.Finished();
        if (value == null) {
            if (value2 == null) return true;
            return false;
        } else {
            if (!value.equals(value2)) return false;
            return true;
        }
    }

    public static final /* synthetic */ boolean $anonfun$fetchProcessDetailsForVersion$10(ProcessVersionEntityData v$1, ProcessAction p) {
        VersionId versionId = p.processVersionId();
        VersionId versionId2 = v$1.id();
        return !(versionId != null ? !versionId.equals(versionId2) : versionId2 != null);
    }

    public DBFetchingProcessRepository(DbRef dbRef, ScenarioActionRepository actionRepository, ScenarioLabelsRepository scenarioLabelsRepository, Monad<F> evidence$1, ExecutionContext ec) {
        this.dbRef = dbRef;
        this.actionRepository = actionRepository;
        this.scenarioLabelsRepository = scenarioLabelsRepository;
        this.ec = ec;
        super(evidence$1);
        LazyLogging.$init$((LazyLogging)this);
    }
}

