/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.process.migrate;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import pl.touk.nussknacker.engine.api.graph.ScenarioGraph;
import pl.touk.nussknacker.engine.api.process.ProcessName;
import pl.touk.nussknacker.engine.canonicalgraph.CanonicalProcess;
import pl.touk.nussknacker.engine.util.Implicits$;
import pl.touk.nussknacker.restmodel.scenariodetails.ScenarioWithDetailsForMigrations;
import pl.touk.nussknacker.restmodel.validation.ValidationResults;
import pl.touk.nussknacker.ui.process.fragment.FragmentRepository;
import pl.touk.nussknacker.ui.process.fragment.FragmentResolver;
import pl.touk.nussknacker.ui.process.label.ScenarioLabel;
import pl.touk.nussknacker.ui.process.marshall.CanonicalProcessConverter$;
import pl.touk.nussknacker.ui.process.migrate.MigratedProcessDetails;
import pl.touk.nussknacker.ui.process.migrate.MigrationResult;
import pl.touk.nussknacker.ui.process.migrate.ProcessModelMigrator;
import pl.touk.nussknacker.ui.process.migrate.TestMigrationResult;
import pl.touk.nussknacker.ui.process.processingtype.provider.ProcessingTypeDataProvider;
import pl.touk.nussknacker.ui.security.api.LoggedUser;
import pl.touk.nussknacker.ui.validation.UIProcessValidator;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.parallel.ExecutionContextTaskSupport;
import scala.collection.parallel.TaskSupport;
import scala.collection.parallel.immutable.ParVector;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0005\u00055e\u0001B\u0005\u000b\u0001]A\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\")Q\n\u0001C\u0001\u001d\")!\f\u0001C\u00017\"9\u0011q\u0003\u0001\u0005\n\u0005e\u0001bBA\u0018\u0001\u0011%\u0011\u0011\u0007\u0005\b\u0003\u0013\u0002A\u0011BA&\u0011\u001d\ti\u0006\u0001C\u0005\u0003?\u00121\u0003V3ti6{G-\u001a7NS\u001e\u0014\u0018\r^5p]NT!a\u0003\u0007\u0002\u000f5LwM]1uK*\u0011QBD\u0001\baJ|7-Z:t\u0015\ty\u0001#\u0001\u0002vS*\u0011\u0011CE\u0001\f]V\u001c8o\u001b8bG.,'O\u0003\u0002\u0014)\u0005!Ao\\;l\u0015\u0005)\u0012A\u00019m\u0007\u0001\u00192\u0001\u0001\r\u001f!\tIB$D\u0001\u001b\u0015\u0005Y\u0012!B:dC2\f\u0017BA\u000f\u001b\u0005\u0019\te.\u001f*fMB\u0011qDJ\u0007\u0002A)\u0011\u0011EI\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003G\u0011\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002K\u0005\u00191m\\7\n\u0005\u001d\u0002#a\u0003'bufdunZ4j]\u001e\f\u0011\"\\5he\u0006$xN]:1\u0005)B\u0004\u0003B\u00161eYj\u0011\u0001\f\u0006\u0003[9\n\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0003_1\ta\u0002\u001d:pG\u0016\u001c8/\u001b8hif\u0004X-\u0003\u00022Y\tQ\u0002K]8dKN\u001c\u0018N\\4UsB,G)\u0019;b!J|g/\u001b3feB\u00111\u0007N\u0007\u0002\u0015%\u0011QG\u0003\u0002\u0015!J|7-Z:t\u001b>$W\r\\'jOJ\fGo\u001c:\u0011\u0005]BD\u0002\u0001\u0003\ns\u0005\t\t\u0011!A\u0003\u0002i\u00121a\u0018\u00132#\tYd\b\u0005\u0002\u001ay%\u0011QH\u0007\u0002\b\u001d>$\b.\u001b8h!\tIr(\u0003\u0002A5\t\u0019\u0011I\\=\u0002!A\u0014xnY3tgZ\u000bG.\u001b3bi>\u0014\bGA\"L!\u0011Y\u0003\u0007\u0012&\u0011\u0005\u0015CU\"\u0001$\u000b\u0005\u001ds\u0011A\u0003<bY&$\u0017\r^5p]&\u0011\u0011J\u0012\u0002\u0013+&\u0003&o\\2fgN4\u0016\r\\5eCR|'\u000f\u0005\u00028\u0017\u0012IAJAA\u0001\u0002\u0003\u0015\tA\u000f\u0002\u0004?\u0012\u0012\u0014A\u0002\u001fj]&$h\bF\u0002P!V\u0003\"a\r\u0001\t\u000b!\u001a\u0001\u0019A)1\u0005I#\u0006\u0003B\u00161eM\u0003\"a\u000e+\u0005\u0013e\u0002\u0016\u0011!A\u0001\u0006\u0003Q\u0004\"B!\u0004\u0001\u00041\u0006GA,Z!\u0011Y\u0003\u0007\u0012-\u0011\u0005]JF!\u0003'V\u0003\u0003\u0005\tQ!\u0001;\u00039!Xm\u001d;NS\u001e\u0014\u0018\r^5p]N$b\u0001\u0018<\u0002\u0004\u0005\u001dACA/m!\rqf-\u001b\b\u0003?\u0012t!\u0001Y2\u000e\u0003\u0005T!A\u0019\f\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0012BA3\u001b\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u001a5\u0003\t1K7\u000f\u001e\u0006\u0003Kj\u0001\"a\r6\n\u0005-T!a\u0005+fgRl\u0015n\u001a:bi&|gNU3tk2$\b\"B7\u0005\u0001\bq\u0017\u0001B;tKJ\u0004\"a\u001c;\u000e\u0003AT!!\u001d:\u0002\u0007\u0005\u0004\u0018N\u0003\u0002t\u001d\u0005A1/Z2ve&$\u00180\u0003\u0002va\nQAj\\4hK\u0012,6/\u001a:\t\u000b]$\u0001\u0019\u0001=\u0002\u0013A\u0014xnY3tg\u0016\u001c\bc\u00010gsB\u0011!p`\u0007\u0002w*\u0011A0`\u0001\u0010g\u000e,g.\u0019:j_\u0012,G/Y5mg*\u0011a\u0010E\u0001\ne\u0016\u001cH/\\8eK2L1!!\u0001|\u0005\u0001\u001a6-\u001a8be&|w+\u001b;i\t\u0016$\u0018-\u001b7t\r>\u0014X*[4sCRLwN\\:\t\r\u0005\u0015A\u00011\u0001y\u0003%1'/Y4nK:$8\u000fC\u0004\u0002\n\u0011\u0001\r!a\u0003\u00021\t\fGo\u00195j]\u001e,\u00050Z2vi&|gnQ8oi\u0016DH\u000f\u0005\u0003\u0002\u000e\u0005MQBAA\b\u0015\r\t\tBG\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BA\u000b\u0003\u001f\u0011\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002\u001d5LwM]1uKB\u0013xnY3tgR!\u00111DA\u0016)\u0011\ti\"!\u000b\u0011\u000be\ty\"a\t\n\u0007\u0005\u0005\"D\u0001\u0004PaRLwN\u001c\t\u0004g\u0005\u0015\u0012bAA\u0014\u0015\t1R*[4sCR,G\r\u0015:pG\u0016\u001c8\u000fR3uC&d7\u000fC\u0003n\u000b\u0001\u000fa\u000e\u0003\u0004\u0002.\u0015\u0001\r!_\u0001\u0014g\u000e,g.\u0019:j_^KG\u000f\u001b#fi\u0006LGn]\u0001\u001aaJ,\u0007/\u0019:f\rJ\fw-\\3oiJ+\u0007o\\:ji>\u0014\u0018\u0010\u0006\u0003\u00024\u0005\u0015##BA\u001b1\u0005ebABA\u001c\r\u0001\t\u0019D\u0001\u0007=e\u00164\u0017N\\3nK:$h\b\u0005\u0003\u0002<\u0005\u0005SBAA\u001f\u0015\r\ty\u0004D\u0001\tMJ\fw-\\3oi&!\u00111IA\u001f\u0005I1%/Y4nK:$(+\u001a9pg&$xN]=\t\u000f\u0005\u0015a\u00011\u0001\u0002HA!aLZA\u0012\u0003E\u0001(o\\2fgNLe\u000eU1sC2dW\r\u001c\u000b\u0007\u0003\u001b\n9&a\u0017\u0015\u0007u\u000by\u0005\u0003\u0004\u000e\u000f\u0001\u0007\u0011\u0011\u000b\t\u00073\u0005M\u00131E5\n\u0007\u0005U#DA\u0005Gk:\u001cG/[8oc!9\u0011\u0011L\u0004A\u0002\u0005\u001d\u0013!B5oaV$\bbBA\u0005\u000f\u0001\u0007\u00111B\u0001\u0011Kb$(/Y2u\u001d\u0016<XI\u001d:peN$b!!\u0019\u0002\u0006\u0006%\u0005\u0003BA2\u0003\u007frA!!\u001a\u0002z9!\u0011qMA<\u001d\u0011\tI'!\u001e\u000f\t\u0005-\u00141\u000f\b\u0005\u0003[\n\tHD\u0002a\u0003_J\u0011!F\u0005\u0003'QI!!\u0005\n\n\u0005y\u0004\u0012BA$~\u0013\u0011\tY(! \u0002#Y\u000bG.\u001b3bi&|gNU3tk2$8O\u0003\u0002H{&!\u0011\u0011QAB\u0005A1\u0016\r\\5eCRLwN\u001c*fgVdGO\u0003\u0003\u0002|\u0005u\u0004bBAD\u0011\u0001\u0007\u0011\u0011M\u0001\u0007E\u00164wN]3\t\u000f\u0005-\u0005\u00021\u0001\u0002b\u0005)\u0011M\u001a;fe\u0002")
public class TestModelMigrations
implements LazyLogging {
    private final ProcessingTypeDataProvider<ProcessModelMigrator, ?> migrators;
    private final ProcessingTypeDataProvider<UIProcessValidator, ?> processValidator;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        TestModelMigrations testModelMigrations = this;
        synchronized (testModelMigrations) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public List<TestMigrationResult> testMigrations(List<ScenarioWithDetailsForMigrations> processes, List<ScenarioWithDetailsForMigrations> fragments, ExecutionContext batchingExecutionContext, LoggedUser user) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Testing scenario migrations (scenarios={}, fragments={})", new Object[]{BoxesRunTime.boxToInteger((int)processes.count((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TestModelMigrations.$anonfun$testMigrations$1(x$1)))), BoxesRunTime.boxToInteger((int)fragments.count((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TestModelMigrations.$anonfun$testMigrations$2(x$2))))});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        List migratedFragments = fragments.flatMap((Function1 & Serializable)scenarioWithDetails -> this.migrateProcess((ScenarioWithDetailsForMigrations)scenarioWithDetails, user));
        List migratedProcesses = processes.flatMap((Function1 & Serializable)scenarioWithDetails -> this.migrateProcess((ScenarioWithDetailsForMigrations)scenarioWithDetails, user));
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Validating migrated scenarios");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ProcessingTypeDataProvider validator = this.processValidator.mapValues((Function1 & Serializable)x$3 -> x$3.withFragmentResolver(new FragmentResolver(this.prepareFragmentRepository((List<MigratedProcessDetails>)migratedFragments))));
        return this.processInParallel((List<MigratedProcessDetails>)((List)migratedFragments.$plus$plus((IterableOnce)migratedProcesses)), batchingExecutionContext, (Function1<MigratedProcessDetails, TestMigrationResult>)(Function1 & Serializable)migrationDetails -> {
            ValidationResults.ValidationResult validationResult = ((UIProcessValidator)validator.forProcessingTypeUnsafe(migrationDetails.processingType(), user)).validate(migrationDetails.newScenarioGraph(), migrationDetails.processName(), migrationDetails.isFragment(), migrationDetails.labels(), user);
            ValidationResults.ValidationResult newErrors = this.extractNewErrors(migrationDetails.oldProcessErrors(), validationResult);
            return new TestMigrationResult(migrationDetails.processName(), newErrors);
        });
    }

    private Option<MigratedProcessDetails> migrateProcess(ScenarioWithDetailsForMigrations scenarioWithDetails, LoggedUser user) {
        return this.migrators.forProcessingType(scenarioWithDetails.processingType(), user).flatMap((Function1 & Serializable)migrator -> migrator.migrateProcess(scenarioWithDetails.name(), scenarioWithDetails.scenarioGraphUnsafe(), (Option<Object>)scenarioWithDetails.modelVersion(), scenarioWithDetails.processCategory(), false).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)TestModelMigrations.$anonfun$migrateProcess$2(check$ifrefutable$1))).map((Function1 & Serializable)x$5 -> {
            MigrationResult migrationResult = x$5;
            if (migrationResult != null) {
                CanonicalProcess newProcess = migrationResult.process();
                ScenarioGraph scenarioGraph = CanonicalProcessConverter$.MODULE$.toScenarioGraph(newProcess);
                return new Tuple2((Object)migrationResult, (Object)scenarioGraph);
            }
            throw new MatchError((Object)migrationResult);
        }).map((Function1 & Serializable)x$6 -> {
            Tuple2 tuple2 = x$6;
            if (tuple2 != null) {
                MigrationResult migrationResult = (MigrationResult)tuple2._1();
                ScenarioGraph scenarioGraph = (ScenarioGraph)tuple2._2();
                if (migrationResult != null) {
                    return new MigratedProcessDetails(scenarioWithDetails.name(), scenarioWithDetails.processingType(), scenarioWithDetails.isFragment(), (List<ScenarioLabel>)scenarioWithDetails.labels().map((Function1 & Serializable)value -> new ScenarioLabel((String)value)), scenarioGraph, scenarioWithDetails.validationResultUnsafe());
                }
            }
            throw new MatchError((Object)tuple2);
        }));
    }

    private FragmentRepository prepareFragmentRepository(List<MigratedProcessDetails> fragments) {
        ListMap fragmentsByProcessingType = Implicits$.MODULE$.RichTupleList(fragments.map((Function1 & Serializable)fragmentDetails -> {
            CanonicalProcess canonical = CanonicalProcessConverter$.MODULE$.fromScenarioGraph(fragmentDetails.newScenarioGraph(), fragmentDetails.processName());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fragmentDetails.processingType()), (Object)canonical);
        })).toGroupedMap();
        return new FragmentRepository(null, fragmentsByProcessingType){
            private final ListMap fragmentsByProcessingType$1;

            public final List<CanonicalProcess> fetchLatestFragmentsSync(String processingType, LoggedUser user) {
                return FragmentRepository.fetchLatestFragmentsSync$(this, processingType, user);
            }

            public final Option<CanonicalProcess> fetchLatestFragmentSync(ProcessName fragmentName, LoggedUser user) {
                return FragmentRepository.fetchLatestFragmentSync$(this, fragmentName, user);
            }

            public Future<List<CanonicalProcess>> fetchLatestFragments(String processingType, LoggedUser user) {
                return Future$.MODULE$.successful(this.fragmentsByProcessingType$1.getOrElse((Object)processingType, (Function0 & Serializable)() -> package$.MODULE$.List().empty()));
            }

            public Future<Option<CanonicalProcess>> fetchLatestFragment(ProcessName fragmentName, LoggedUser user) {
                throw new IllegalStateException("FragmentRepository.get(ProcessName) used during migration");
            }
            {
                this.fragmentsByProcessingType$1 = fragmentsByProcessingType$1;
                FragmentRepository.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$fetchLatestFragments$1()}, serializedLambda);
            }
        };
    }

    private List<TestMigrationResult> processInParallel(List<MigratedProcessDetails> input, ExecutionContext batchingExecutionContext, Function1<MigratedProcessDetails, TestMigrationResult> process) {
        ParVector parallelCollection = new ParVector(input.toVector());
        parallelCollection.tasksupport_$eq((TaskSupport)new ExecutionContextTaskSupport(batchingExecutionContext));
        return parallelCollection.map(process).toList();
    }

    private ValidationResults.ValidationResult extractNewErrors(ValidationResults.ValidationResult before, ValidationResults.ValidationResult after) {
        return new ValidationResults.ValidationResult(new ValidationResults.ValidationErrors(TestModelMigrations.diffOnMap$1(before.errors().invalidNodes(), after.errors().invalidNodes()), TestModelMigrations.diffErrorLists$1(before.errors().processPropertiesErrors(), after.errors().processPropertiesErrors()), TestModelMigrations.diffOnGlobalErrors$1(before.errors().globalErrors(), after.errors().globalErrors())), new ValidationResults.ValidationWarnings(TestModelMigrations.diffOnMap$1(before.warnings().invalidNodes(), after.warnings().invalidNodes())), Predef$.MODULE$.Map().empty());
    }

    public static final /* synthetic */ boolean $anonfun$testMigrations$1(ScenarioWithDetailsForMigrations x$1) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$testMigrations$2(ScenarioWithDetailsForMigrations x$2) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$migrateProcess$2(MigrationResult check$ifrefutable$1) {
        MigrationResult migrationResult = check$ifrefutable$1;
        return migrationResult != null;
    }

    private static final Tuple3 errorToKey$1(ValidationResults.NodeValidationError error) {
        return new Tuple3((Object)error.fieldName(), (Object)error.errorType(), (Object)error.typ());
    }

    private static final List diffErrorLists$1(List before, List after) {
        Set errorsBefore = before.map((Function1 & Serializable)error -> TestModelMigrations.errorToKey$1(error)).toSet();
        return after.filterNot((Function1 & Serializable)error -> BoxesRunTime.boxToBoolean((boolean)errorsBefore.contains((Object)TestModelMigrations.errorToKey$1(error))));
    }

    public static final /* synthetic */ boolean $anonfun$extractNewErrors$5(Tuple2 x$7) {
        return ((List)x$7._2()).isEmpty();
    }

    private static final Map diffOnMap$1(Map before, Map after) {
        return (Map)after.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String nodeId = (String)tuple2._1();
                List errorsAfter = (List)tuple2._2();
                return new Tuple2((Object)nodeId, (Object)TestModelMigrations.diffErrorLists$1((List)before.getOrElse((Object)nodeId, (Function0 & Serializable)() -> package$.MODULE$.List().empty()), errorsAfter));
            }
            throw new MatchError((Object)tuple2);
        }).filterNot((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)TestModelMigrations.$anonfun$extractNewErrors$5(x$7)));
    }

    private static final List diffOnGlobalErrors$1(List before, List after) {
        Set errorsBefore = before.map((Function1 & Serializable)globalError -> TestModelMigrations.errorToKey$1(globalError.error())).toSet();
        return after.filterNot((Function1 & Serializable)globalError -> BoxesRunTime.boxToBoolean((boolean)errorsBefore.contains((Object)TestModelMigrations.errorToKey$1(globalError.error()))));
    }

    public TestModelMigrations(ProcessingTypeDataProvider<ProcessModelMigrator, ?> migrators, ProcessingTypeDataProvider<UIProcessValidator, ?> processValidator) {
        this.migrators = migrators;
        this.processValidator = processValidator;
        LazyLogging.$init$((LazyLogging)this);
    }
}

