/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.process;

import cats.effect.IO;
import cats.effect.IO$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import java.io.Serializable;
import java.util.UUID;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import pl.touk.nussknacker.engine.api.component.ProcessingMode;
import pl.touk.nussknacker.engine.api.deployment.DeploymentResult;
import pl.touk.nussknacker.engine.api.deployment.ProcessActionId;
import pl.touk.nussknacker.engine.api.deployment.ScenarioActivity;
import pl.touk.nussknacker.engine.api.deployment.ScenarioAttachment;
import pl.touk.nussknacker.engine.api.deployment.ScenarioComment;
import pl.touk.nussknacker.engine.api.deployment.ScenarioVersionId;
import pl.touk.nussknacker.engine.api.deployment.ScenarioVersionId$;
import pl.touk.nussknacker.engine.api.deployment.ScheduledExecutionStatus;
import pl.touk.nussknacker.engine.api.deployment.UserName;
import pl.touk.nussknacker.engine.api.process.ProcessId;
import pl.touk.nussknacker.engine.api.process.VersionId;
import pl.touk.nussknacker.ui.process.ScenarioAttachmentService;
import pl.touk.nussknacker.ui.security.api.LoggedUser;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

public final class ScenarioActivityAuditLog$ {
    public static final ScenarioActivityAuditLog$ MODULE$ = new ScenarioActivityAuditLog$();
    private static final Logger logger = Logger$.MODULE$.apply(LoggerFactory.getLogger((String)"scenario-activity-audit"));

    private Logger logger() {
        return logger;
    }

    public IO<BoxedUnit> onCreateScenarioActivity(ScenarioActivity scenarioActivity) {
        return this.logWithContext(scenarioActivity.scenarioId(), (Option<ScenarioVersionId>)scenarioActivity.scenarioVersionId(), scenarioActivity.user().name().value(), "New activity: " + this.stringify(scenarioActivity));
    }

    public IO<BoxedUnit> onEditComment(ProcessId processId, LoggedUser user, UUID scenarioActivityId, String comment) {
        return this.logWithContext(processId.value(), (Option<ScenarioVersionId>)None$.MODULE$, user.username(), "[commentId=" + scenarioActivityId.toString() + "] Comment edited, new value: [" + comment + "]");
    }

    public IO<BoxedUnit> onDeleteComment(ProcessId processId, long rowId, LoggedUser user) {
        return this.logWithContext(processId.value(), (Option<ScenarioVersionId>)None$.MODULE$, user.username(), "Comment with rowId=" + rowId + " deleted");
    }

    public IO<BoxedUnit> onDeleteComment(ProcessId processId, UUID activityId, LoggedUser user) {
        return this.logWithContext(processId.value(), (Option<ScenarioVersionId>)None$.MODULE$, user.username(), "Comment for activityId=" + activityId + " deleted");
    }

    public IO<BoxedUnit> onAddAttachment(ScenarioAttachmentService.AttachmentToAdd attachmentToAdd, LoggedUser user) {
        return this.logWithContext(attachmentToAdd.scenarioId().value(), (Option<ScenarioVersionId>)new Some((Object)new ScenarioVersionId(ScenarioVersionId$.MODULE$.from(attachmentToAdd.scenarioVersionId()))), user.username(), "Attachment added: [" + attachmentToAdd.fileName() + "]");
    }

    public IO<BoxedUnit> onDeleteAttachment(ProcessId scenarioId, long attachmentId, LoggedUser user) {
        return this.logWithContext(scenarioId.value(), (Option<ScenarioVersionId>)None$.MODULE$, user.username(), "Attachment deleted: [attachmentId=" + attachmentId + "]");
    }

    public IO<BoxedUnit> onScenarioImmediateAction(ProcessActionId processActionId, ProcessId processId, String actionName, Option<VersionId> processVersion, LoggedUser user) {
        return this.logWithContext(processId.value(), (Option<ScenarioVersionId>)processVersion.map((Function1 & Serializable)versionId -> new ScenarioVersionId(ScenarioVersionId$.MODULE$.from(versionId))), user.username(), "Immediate scenario action [actionName=" + actionName + ",actionId=" + processActionId.value() + "]");
    }

    public IO<BoxedUnit> onScenarioActionStarted(ProcessActionId processActionId, ProcessId processId, String actionName, Option<VersionId> processVersion, LoggedUser user) {
        return this.logWithContext(processId.value(), (Option<ScenarioVersionId>)processVersion.map((Function1 & Serializable)versionId -> new ScenarioVersionId(ScenarioVersionId$.MODULE$.from(versionId))), user.username(), "Scenario action [actionName=" + actionName + ",actionId=" + processActionId.value() + "] started");
    }

    public IO<BoxedUnit> onScenarioActionFinishedWithSuccess(ProcessActionId processActionId, ProcessId processId, String actionName, Option<VersionId> processVersion, Option<String> comment, LoggedUser user) {
        Object object;
        Option<String> option = comment;
        if (option instanceof Some) {
            Some some = (Some)option;
            String content = (String)some.value();
            object = "comment [" + content + "]";
        } else if (None$.MODULE$.equals(option)) {
            object = "without comment";
        } else {
            throw new MatchError(option);
        }
        String commentValue = object;
        return this.logWithContext(processId.value(), (Option<ScenarioVersionId>)processVersion.map((Function1 & Serializable)versionId -> new ScenarioVersionId(ScenarioVersionId$.MODULE$.from(versionId))), user.username(), "Scenario action [actionName=" + actionName + ",actionId=" + processActionId.value() + "] finished with success and " + commentValue + " ");
    }

    public IO<BoxedUnit> onScenarioActionFinishedWithFailure(ProcessActionId processActionId, ProcessId processId, String actionName, Option<VersionId> processVersion, Option<String> comment, String failureMessage, LoggedUser user) {
        Object object;
        Option<String> option = comment;
        if (option instanceof Some) {
            Some some = (Some)option;
            String content = (String)some.value();
            object = "with comment [" + content + "]";
        } else if (None$.MODULE$.equals(option)) {
            object = "without comment";
        } else {
            throw new MatchError(option);
        }
        String commentValue = object;
        return this.logWithContext(processId.value(), (Option<ScenarioVersionId>)processVersion.map((Function1 & Serializable)versionId -> new ScenarioVersionId(ScenarioVersionId$.MODULE$.from(versionId))), user.username(), "Scenario action [actionName=" + actionName + ",actionId=" + processActionId.value() + "] finished with failure [" + failureMessage + "] " + commentValue);
    }

    public IO<BoxedUnit> onScenarioActionRemoved(ProcessActionId processActionId, ProcessId processId, Option<VersionId> processVersion, LoggedUser user) {
        return this.logWithContext(processId.value(), (Option<ScenarioVersionId>)processVersion.map((Function1 & Serializable)versionId -> new ScenarioVersionId(ScenarioVersionId$.MODULE$.from(versionId))), user.username(), "Scenario action [actionId=" + processActionId.value() + "] removed");
    }

    private String stringify(ScenarioActivity scenarioActivity) {
        ScenarioActivity scenarioActivity2 = scenarioActivity;
        if (scenarioActivity2 instanceof ScenarioActivity.ScenarioDeployed) {
            ScenarioActivity.ScenarioDeployed scenarioDeployed = (ScenarioActivity.ScenarioDeployed)scenarioActivity2;
            ScenarioComment comment = scenarioDeployed.comment();
            DeploymentResult result = scenarioDeployed.result();
            return "ScenarioDeployed(comment=" + this.stringify(comment) + ",result=" + this.stringify(result) + ")";
        }
        if (scenarioActivity2 instanceof ScenarioActivity.ScenarioPaused) {
            ScenarioActivity.ScenarioPaused scenarioPaused = (ScenarioActivity.ScenarioPaused)scenarioActivity2;
            ScenarioComment comment = scenarioPaused.comment();
            DeploymentResult result = scenarioPaused.result();
            return "ScenarioPaused(comment=" + this.stringify(comment) + ",result=" + this.stringify(result) + ")";
        }
        if (scenarioActivity2 instanceof ScenarioActivity.ScenarioCanceled) {
            ScenarioActivity.ScenarioCanceled scenarioCanceled = (ScenarioActivity.ScenarioCanceled)scenarioActivity2;
            ScenarioComment comment = scenarioCanceled.comment();
            DeploymentResult result = scenarioCanceled.result();
            return "ScenarioCanceled(comment=" + this.stringify(comment) + ",result=" + this.stringify(result) + ")";
        }
        if (scenarioActivity2 instanceof ScenarioActivity.CustomAction) {
            ScenarioActivity.CustomAction customAction = (ScenarioActivity.CustomAction)scenarioActivity2;
            String actionName = customAction.actionName();
            ScenarioComment comment = customAction.comment();
            DeploymentResult result = customAction.result();
            return "CustomAction(action=" + actionName + ",comment=" + this.stringify(comment) + ",result=" + this.stringify(result) + ")";
        }
        if (scenarioActivity2 instanceof ScenarioActivity.PerformedSingleExecution) {
            ScenarioActivity.PerformedSingleExecution performedSingleExecution = (ScenarioActivity.PerformedSingleExecution)scenarioActivity2;
            ScenarioComment comment = performedSingleExecution.comment();
            DeploymentResult result = performedSingleExecution.result();
            return "PerformedSingleExecution(comment=" + this.stringify(comment) + ",result=" + this.stringify(result) + ")";
        }
        if (scenarioActivity2 instanceof ScenarioActivity.PerformedScheduledExecution) {
            ScenarioActivity.PerformedScheduledExecution performedScheduledExecution = (ScenarioActivity.PerformedScheduledExecution)scenarioActivity2;
            ScheduledExecutionStatus status = performedScheduledExecution.scheduledExecutionStatus();
            String scheduleName = performedScheduledExecution.scheduleName();
            return "PerformedScheduledExecution(scheduleName=" + scheduleName + ",scheduledExecutionStatus=" + status.entryName() + ")";
        }
        if (scenarioActivity2 instanceof ScenarioActivity.ScenarioCreated) {
            return "ScenarioCreated";
        }
        if (scenarioActivity2 instanceof ScenarioActivity.ScenarioArchived) {
            return "ScenarioArchived";
        }
        if (scenarioActivity2 instanceof ScenarioActivity.ScenarioUnarchived) {
            return "ScenarioUnarchived";
        }
        if (scenarioActivity2 instanceof ScenarioActivity.ScenarioModified) {
            ScenarioActivity.ScenarioModified scenarioModified = (ScenarioActivity.ScenarioModified)scenarioActivity2;
            ScenarioComment comment = scenarioModified.comment();
            return "ScenarioModified(comment=" + this.stringify(comment) + ")";
        }
        if (scenarioActivity2 instanceof ScenarioActivity.ScenarioNameChanged) {
            ScenarioActivity.ScenarioNameChanged scenarioNameChanged = (ScenarioActivity.ScenarioNameChanged)scenarioActivity2;
            String oldName = scenarioNameChanged.oldName();
            String newName = scenarioNameChanged.newName();
            return "ScenarioNameChanged(oldName=" + oldName + ",newName=" + newName + ")";
        }
        if (scenarioActivity2 instanceof ScenarioActivity.CommentAdded) {
            ScenarioActivity.CommentAdded commentAdded = (ScenarioActivity.CommentAdded)scenarioActivity2;
            ScenarioComment comment = commentAdded.comment();
            return "CommentAdded(comment=" + this.stringify(comment) + ")";
        }
        if (scenarioActivity2 instanceof ScenarioActivity.AttachmentAdded) {
            ScenarioActivity.AttachmentAdded attachmentAdded = (ScenarioActivity.AttachmentAdded)scenarioActivity2;
            ScenarioAttachment attachment = attachmentAdded.attachment();
            return "AttachmentAdded(fileName=" + this.stringify(attachment) + ")";
        }
        if (scenarioActivity2 instanceof ScenarioActivity.ChangedProcessingMode) {
            ScenarioActivity.ChangedProcessingMode changedProcessingMode = (ScenarioActivity.ChangedProcessingMode)scenarioActivity2;
            ProcessingMode from = changedProcessingMode.from();
            ProcessingMode to = changedProcessingMode.to();
            return "ChangedProcessingMode(from=" + from + ",to=" + to + ")";
        }
        if (scenarioActivity2 instanceof ScenarioActivity.IncomingMigration) {
            ScenarioActivity.IncomingMigration incomingMigration = (ScenarioActivity.IncomingMigration)scenarioActivity2;
            String sourceEnvironment = incomingMigration.sourceEnvironment();
            UserName sourceUser = incomingMigration.sourceUser();
            Option sourceVersionId = incomingMigration.sourceScenarioVersionId();
            return "IncomingMigration(sourceEnvironment=" + sourceEnvironment + ",sourceUser=" + sourceUser.value() + ",sourceVersionId=" + sourceVersionId.map((Function1 & Serializable)x$1 -> ScenarioActivityAuditLog$.$anonfun$stringify$1(((ScenarioVersionId)x$1).value())).getOrElse((Function0 & Serializable)() -> "[none]") + ")";
        }
        if (scenarioActivity2 instanceof ScenarioActivity.OutgoingMigration) {
            ScenarioActivity.OutgoingMigration outgoingMigration = (ScenarioActivity.OutgoingMigration)scenarioActivity2;
            String destinationEnvironment = outgoingMigration.destinationEnvironment();
            return "OutgoingMigration(destinationEnvironment=" + destinationEnvironment + ")";
        }
        if (scenarioActivity2 instanceof ScenarioActivity.AutomaticUpdate) {
            ScenarioActivity.AutomaticUpdate automaticUpdate = (ScenarioActivity.AutomaticUpdate)scenarioActivity2;
            String changes = automaticUpdate.changes();
            return "AutomaticUpdate(changes=" + changes + ")";
        }
        throw new MatchError((Object)scenarioActivity2);
    }

    private String stringify(ScenarioAttachment attachment) {
        ScenarioAttachment scenarioAttachment = attachment;
        if (scenarioAttachment instanceof ScenarioAttachment.Available) {
            ScenarioAttachment.Available available = (ScenarioAttachment.Available)scenarioAttachment;
            String attachmentFilename = available.attachmentFilename();
            return "Available(" + attachmentFilename + ")";
        }
        if (scenarioAttachment instanceof ScenarioAttachment.Deleted) {
            ScenarioAttachment.Deleted deleted = (ScenarioAttachment.Deleted)scenarioAttachment;
            String attachmentFilename = deleted.attachmentFilename();
            return "Deleted(" + attachmentFilename + ")";
        }
        throw new MatchError((Object)scenarioAttachment);
    }

    private String stringify(ScenarioComment comment) {
        ScenarioComment scenarioComment = comment;
        if (scenarioComment instanceof ScenarioComment.WithContent) {
            ScenarioComment.WithContent withContent = (ScenarioComment.WithContent)scenarioComment;
            String comment2 = withContent.comment();
            return comment2;
        }
        if (scenarioComment instanceof ScenarioComment.WithoutContent) {
            return "none";
        }
        throw new MatchError((Object)scenarioComment);
    }

    private String stringify(DeploymentResult result) {
        DeploymentResult deploymentResult = result;
        if (deploymentResult instanceof DeploymentResult.Success) {
            return "Success";
        }
        if (deploymentResult instanceof DeploymentResult.Failure) {
            DeploymentResult.Failure failure = (DeploymentResult.Failure)deploymentResult;
            Option errorMessage = failure.errorMessage();
            return "Failure(" + errorMessage + ")";
        }
        throw new MatchError((Object)deploymentResult);
    }

    private IO<BoxedUnit> logWithContext(long scenarioId, Option<ScenarioVersionId> scenarioVersionId, String username, String log) {
        return IO$.MODULE$.delay((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            BoxedUnit boxedUnit;
            MDC.clear();
            MDC.put((String)"scenarioId", (String)Long.toString(scenarioId));
            MDC.put((String)"scenarioVersionId", (String)((String)scenarioVersionId.map((Function1 & Serializable)x$2 -> ScenarioActivityAuditLog$.$anonfun$logWithContext$2(((ScenarioVersionId)x$2).value())).getOrElse((Function0 & Serializable)() -> "none")));
            MDC.put((String)"username", (String)username);
            if (MODULE$.logger().underlying().isInfoEnabled()) {
                MODULE$.logger().underlying().info(log);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            MDC.clear();
        });
    }

    public static final /* synthetic */ String $anonfun$stringify$1(long x$1) {
        return Long.toString(x$1);
    }

    public static final /* synthetic */ String $anonfun$logWithContext$2(long x$2) {
        return Long.toString(x$2);
    }

    private ScenarioActivityAuditLog$() {
    }
}

