/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.process.processingtype;

import cats.data.NonEmptyList;
import cats.data.Validated;
import com.typesafe.config.Config;
import java.io.Serializable;
import net.ceedubs.ficus.Ficus$;
import pl.touk.nussknacker.engine.BaseModelData;
import pl.touk.nussknacker.engine.CustomProcessValidator;
import pl.touk.nussknacker.engine.DeploymentManagerDependencies;
import pl.touk.nussknacker.engine.DeploymentManagerProvider;
import pl.touk.nussknacker.engine.MetaDataInitializer;
import pl.touk.nussknacker.engine.ModelData;
import pl.touk.nussknacker.engine.api.component.ComponentId;
import pl.touk.nussknacker.engine.api.component.ProcessingMode;
import pl.touk.nussknacker.engine.api.component.ScenarioPropertyConfig;
import pl.touk.nussknacker.engine.api.deployment.DeploymentManager;
import pl.touk.nussknacker.engine.api.deployment.cache.ScenarioStateCachingConfig$;
import pl.touk.nussknacker.engine.definition.component.ComponentDefinitionWithImplementation;
import pl.touk.nussknacker.engine.definition.component.ComponentStaticDefinition;
import pl.touk.nussknacker.engine.definition.component.Components;
import pl.touk.nussknacker.engine.definition.component.DynamicComponentStaticDefinitionDeterminer$;
import pl.touk.nussknacker.engine.deployment.EngineSetupName;
import pl.touk.nussknacker.engine.util.config.FicusReaders$;
import pl.touk.nussknacker.ui.process.processingtype.DeploymentData;
import pl.touk.nussknacker.ui.process.processingtype.DeploymentManagerType;
import pl.touk.nussknacker.ui.process.processingtype.DesignerModelData;
import pl.touk.nussknacker.ui.process.processingtype.ProcessingTypeData;
import pl.touk.nussknacker.ui.process.processingtype.ScenarioParametersDeterminer$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple4;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.runtime.ModuleSerializationProxy;
import scala.util.control.NonFatal$;

public final class ProcessingTypeData$
implements Serializable {
    public static final ProcessingTypeData$ MODULE$ = new ProcessingTypeData$();

    public ProcessingTypeData createProcessingTypeData(String name, ModelData modelData, DeploymentManagerProvider deploymentManagerProvider, DeploymentManagerDependencies deploymentManagerDependencies, EngineSetupName engineSetupName, Config deploymentConfig, String category, Components.ComponentDefinitionExtractionMode componentDefinitionExtractionMode) {
        ProcessingTypeData processingTypeData;
        try {
            MetaDataInitializer metaDataInitializer = deploymentManagerProvider.metaDataInitializer(deploymentConfig);
            DeploymentData deploymentData = this.createDeploymentData(deploymentManagerProvider, deploymentManagerDependencies, engineSetupName, modelData, deploymentConfig, metaDataInitializer);
            DesignerModelData designerModelData = this.createDesignerModelData(modelData, metaDataInitializer, name, componentDefinitionExtractionMode);
            processingTypeData = this.apply(name, designerModelData, deploymentData, category);
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                throw new IllegalArgumentException("Error during creation of processing type data for processing type [" + name + "]", throwable2);
            }
            throw throwable;
        }
        return processingTypeData;
    }

    private DeploymentData createDeploymentData(DeploymentManagerProvider deploymentManagerProvider, DeploymentManagerDependencies deploymentManagerDependencies, EngineSetupName engineSetupName, ModelData modelData, Config deploymentConfig, MetaDataInitializer metaDataInitializer) {
        Option scenarioStateCacheTTL = ScenarioStateCachingConfig$.MODULE$.extractScenarioStateCacheTTL(deploymentConfig);
        Validated validDeploymentManager = deploymentManagerProvider.createDeploymentManager((BaseModelData)modelData, deploymentManagerDependencies, deploymentConfig, scenarioStateCacheTTL);
        Map scenarioProperties = (Map)deploymentManagerProvider.scenarioPropertiesConfig(deploymentConfig).$plus$plus((IterableOnce)Ficus$.MODULE$.toFicusConfig(modelData.modelConfig()).getOrElse("scenarioPropertiesConfig", (Function0 & Serializable)() -> Predef$.MODULE$.Map().empty(), Ficus$.MODULE$.optionValueReader(Ficus$.MODULE$.mapValueReader(FicusReaders$.MODULE$.paramConfigReader()))));
        Map fragmentProperties = (Map)Ficus$.MODULE$.toFicusConfig(modelData.modelConfig()).getOrElse("fragmentPropertiesConfig", (Function0 & Serializable)() -> Predef$.MODULE$.Map().empty(), Ficus$.MODULE$.optionValueReader(Ficus$.MODULE$.mapValueReader(FicusReaders$.MODULE$.paramConfigReader())));
        return new DeploymentData((Validated<NonEmptyList<String>, DeploymentManager>)validDeploymentManager, metaDataInitializer, (Map<String, ScenarioPropertyConfig>)scenarioProperties, (Map<String, ScenarioPropertyConfig>)fragmentProperties, (List<CustomProcessValidator>)deploymentManagerProvider.additionalValidators(deploymentConfig), new DeploymentManagerType(deploymentManagerProvider.name()), engineSetupName);
    }

    private DesignerModelData createDesignerModelData(ModelData modelData, MetaDataInitializer metaDataInitializer, String processingType, Components.ComponentDefinitionExtractionMode componentDefinitionExtractionMode) {
        DesignerModelData.DynamicComponentsStaticDefinitions staticDefinitionForDynamicComponents = this.createDynamicComponentsStaticDefinitions(modelData, metaDataInitializer, componentDefinitionExtractionMode);
        ProcessingMode singleProcessingMode = ScenarioParametersDeterminer$.MODULE$.determineProcessingMode((List<ComponentDefinitionWithImplementation>)modelData.modelDefinition().components().components(), processingType);
        return new DesignerModelData(modelData, staticDefinitionForDynamicComponents, singleProcessingMode);
    }

    private DesignerModelData.DynamicComponentsStaticDefinitions createDynamicComponentsStaticDefinitions(ModelData modelData, MetaDataInitializer metaDataInitializer, Components.ComponentDefinitionExtractionMode componentDefinitionExtractionMode) {
        None$ none$;
        Map map = ProcessingTypeData$.createStaticDefinitions$1((Function1 & Serializable)x$2 -> x$2.components(), modelData, metaDataInitializer);
        Components.ComponentDefinitionExtractionMode componentDefinitionExtractionMode2 = componentDefinitionExtractionMode;
        if (Components.ComponentDefinitionExtractionMode$.FinalDefinition$.MODULE$.equals(componentDefinitionExtractionMode2)) {
            none$ = None$.MODULE$;
        } else if (Components.ComponentDefinitionExtractionMode$.FinalAndBasicDefinitions$.MODULE$.equals(componentDefinitionExtractionMode2)) {
            none$ = new Some((Object)ProcessingTypeData$.createStaticDefinitions$1((Function1 & Serializable)x$3 -> x$3.basicComponentsUnsafe(), modelData, metaDataInitializer));
        } else {
            throw new MatchError((Object)componentDefinitionExtractionMode2);
        }
        return new DesignerModelData.DynamicComponentsStaticDefinitions((Map<ComponentId, ComponentStaticDefinition>)map, (Option<Map<ComponentId, ComponentStaticDefinition>>)none$);
    }

    public ProcessingTypeData apply(String name, DesignerModelData designerModelData, DeploymentData deploymentData, String category) {
        return new ProcessingTypeData(name, designerModelData, deploymentData, category);
    }

    public Option<Tuple4<String, DesignerModelData, DeploymentData, String>> unapply(ProcessingTypeData x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple4((Object)x$0.name(), (Object)x$0.designerModelData(), (Object)x$0.deploymentData(), (Object)x$0.category()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ProcessingTypeData$.class);
    }

    private static final Map createStaticDefinitions$1(Function1 extractComponents, ModelData modelData$1, MetaDataInitializer metaDataInitializer$1) {
        return DynamicComponentStaticDefinitionDeterminer$.MODULE$.collectStaticDefinitionsForDynamicComponents(modelData$1, (Function1 & Serializable)x$1 -> metaDataInitializer$1.create(x$1, Predef$.MODULE$.Map().empty()), extractComponents);
    }

    private ProcessingTypeData$() {
    }
}

